/*
 * Decompiled with CFR 0.152.
 */
package org.opends.guitools.controlpanel;

import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.opends.guitools.controlpanel.datamodel.ControlPanelInfo;
import org.opends.guitools.controlpanel.datamodel.ServerDescriptor;
import org.opends.guitools.controlpanel.ui.ControlCenterMainPane;
import org.opends.guitools.controlpanel.ui.MainMenuBar;
import org.opends.guitools.controlpanel.util.Utilities;
import org.opends.messages.AdminToolMessages;

public class ControlPanel {
    private JFrame dlg;
    private ControlPanelInfo info;
    private ControlCenterMainPane controlCenterPane;

    public static void main(String[] args) {
        try {
            ControlPanel.initLookAndFeel();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        final ControlPanel test = new ControlPanel();
        test.initialize(args);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                test.createAndDisplayGUI();
            }
        });
    }

    public void initialize(String[] args) {
        this.info = ControlPanelInfo.getInstance();
        this.info.regenerateDescriptor();
        this.info.startPooling(20000L);
    }

    public void createAndDisplayGUI() {
        this.controlCenterPane = new ControlCenterMainPane(this.info);
        this.dlg = new JFrame();
        this.dlg.setDefaultCloseOperation(0);
        final MainMenuBar menuBar = new MainMenuBar(this.info);
        this.dlg.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                menuBar.quitClicked();
            }
        });
        this.dlg.setJMenuBar(menuBar);
        this.dlg.setTitle(AdminToolMessages.INFO_CONTROL_PANEL_TITLE.get().toString());
        this.dlg.setContentPane(this.controlCenterPane);
        this.dlg.pack();
        Utilities.centerOnScreen(this.dlg);
        this.dlg.setVisible(true);
        if (this.info.getServerDescriptor().getStatus() == ServerDescriptor.ServerStatus.STARTED) {
            this.controlCenterPane.getLoginDialog().setVisible(true);
            this.controlCenterPane.getLoginDialog().toFront();
        }
    }

    private static void initLookAndFeel() throws Throwable {
        if (SwingUtilities.isEventDispatchThread()) {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        } else {
            final Throwable[] ts = new Throwable[]{null};
            SwingUtilities.invokeAndWait(new Runnable(){

                public void run() {
                    try {
                        UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                    }
                    catch (Throwable t) {
                        ts[0] = t;
                    }
                }
            });
            if (ts[0] != null) {
                throw ts[0];
            }
        }
    }
}

