/*
 * Decompiled with CFR 0.152.
 */
package org.opends.guitools.controlpanel.datamodel;

import java.util.Collections;
import java.util.List;
import org.opends.guitools.controlpanel.datamodel.AbstractIndexDescriptor;
import org.opends.guitools.controlpanel.datamodel.BackendDescriptor;
import org.opends.guitools.controlpanel.datamodel.VLVSortOrder;
import org.opends.server.admin.std.meta.LocalDBVLVIndexCfgDefn;
import org.opends.server.types.DN;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VLVIndexDescriptor
extends AbstractIndexDescriptor {
    private DN baseDN;
    private LocalDBVLVIndexCfgDefn.Scope scope;
    private String filter;
    private List<VLVSortOrder> sortOrder = Collections.emptyList();
    private int maxBlockSize;
    private int hashCode;

    public VLVIndexDescriptor(String name, BackendDescriptor backend, DN baseDN, LocalDBVLVIndexCfgDefn.Scope scope, String filter, List<VLVSortOrder> sortOrder, int maxBlockSize) {
        super(name, backend);
        this.baseDN = baseDN;
        this.scope = scope;
        this.filter = filter;
        this.sortOrder = Collections.unmodifiableList(sortOrder);
        this.maxBlockSize = maxBlockSize;
        this.recalculateHashCode();
    }

    public int compareTo(Object o) {
        int returnValue = -1;
        if (o instanceof AbstractIndexDescriptor) {
            AbstractIndexDescriptor index = (AbstractIndexDescriptor)o;
            returnValue = this.getName().compareTo(index.getName());
        }
        return returnValue;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public DN getBaseDN() {
        return this.baseDN;
    }

    public String getFilter() {
        return this.filter;
    }

    public LocalDBVLVIndexCfgDefn.Scope getScope() {
        return this.scope;
    }

    public List<VLVSortOrder> getSortOrder() {
        return this.sortOrder;
    }

    public boolean equals(Object o) {
        boolean equals;
        boolean bl = equals = o == this;
        if (!equals && (equals = o instanceof VLVIndexDescriptor)) {
            VLVIndexDescriptor index = (VLVIndexDescriptor)o;
            boolean bl2 = equals = index.getName().equalsIgnoreCase(this.getName()) && index.getBaseDN().equals(this.getBaseDN()) && index.getFilter().equals(this.getFilter()) && index.getScope() == this.getScope() && ((Object)index.getSortOrder()).equals(this.getSortOrder());
            if (equals && this.getBackend() != null && index.getBackend() != null) {
                equals = this.getBackend().getBackendID().equals(index.getBackend().getBackendID());
            }
        }
        return equals;
    }

    @Override
    protected void recalculateHashCode() {
        StringBuilder sb = new StringBuilder();
        for (VLVSortOrder s : this.sortOrder) {
            sb.append(s.getAttributeName() + s.isAscending() + ",");
        }
        if (this.getBackend() != null) {
            sb.append(this.getBackend().getBackendID());
        }
        this.hashCode = (this.getName() + this.baseDN + (Object)((Object)this.scope) + this.filter + sb + this.maxBlockSize).hashCode();
    }

    public int getMaxBlockSize() {
        return this.maxBlockSize;
    }
}

