/*
 * Decompiled with CFR 0.152.
 */
package org.opends.guitools.controlpanel.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumn;
import org.opends.guitools.controlpanel.datamodel.BackupDescriptor;
import org.opends.guitools.controlpanel.datamodel.BackupTableModel;
import org.opends.guitools.controlpanel.datamodel.ServerDescriptor;
import org.opends.guitools.controlpanel.event.BrowseActionListener;
import org.opends.guitools.controlpanel.event.ConfigurationChangeEvent;
import org.opends.guitools.controlpanel.ui.ColorAndFontConstants;
import org.opends.guitools.controlpanel.ui.RestorePanel;
import org.opends.guitools.controlpanel.ui.StatusGenericPanel;
import org.opends.guitools.controlpanel.ui.renderer.BackupTableCellRenderer;
import org.opends.guitools.controlpanel.util.BackgroundTask;
import org.opends.guitools.controlpanel.util.Utilities;
import org.opends.messages.AdminToolMessages;
import org.opends.messages.CoreMessages;
import org.opends.messages.Message;
import org.opends.messages.ToolMessages;
import org.opends.server.types.BackupDirectory;
import org.opends.server.types.BackupInfo;
import org.opends.server.types.OpenDsException;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BackupListPanel
extends StatusGenericPanel {
    protected JTextField parentDirectory;
    protected final Message REFRESHING_LIST = AdminToolMessages.INFO_CTRL_PANEL_REFRESHING_LIST_SUMMARY.get();
    protected final Message NO_BACKUPS_FOUND = AdminToolMessages.INFO_CTRL_PANEL_NO_BACKUPS_FOUND.get();
    protected JLabel lPath;
    protected JLabel lAvailableBackups;
    protected JLabel lRefreshingList;
    protected JButton refreshList;
    protected JButton verifyBackup;
    protected JButton browse;
    protected JScrollPane tableScroll;
    protected JTable backupList;
    private boolean backupDirectoryInitialized;
    private BackupTableCellRenderer renderer;
    private static final Logger LOG = Logger.getLogger(RestorePanel.class.getName());
    private final String DUMMY_PARENT_PATH = "/local/OpenDS-X.X.X/bak";

    protected BackupListPanel() {
    }

    @Override
    public Component getPreferredFocusComponent() {
        return this.parentDirectory;
    }

    protected BackupDescriptor getSelectedBackup() {
        BackupDescriptor backup = null;
        int row = this.backupList.getSelectedRow();
        if (row != -1) {
            BackupTableModel model = (BackupTableModel)this.backupList.getModel();
            backup = model.get(row);
        }
        return backup;
    }

    protected abstract void verifyBackupClicked();

    protected void createLayout(GridBagConstraints gbc) {
        ++gbc.gridy;
        gbc.anchor = 17;
        gbc.weightx = 0.0;
        gbc.fill = 0;
        gbc.gridwidth = 1;
        gbc.insets.left = 0;
        this.lPath = Utilities.createPrimaryLabel(AdminToolMessages.INFO_CTRL_PANEL_BACKUP_PATH_LABEL.get());
        this.add((Component)this.lPath, gbc);
        gbc.gridx = 1;
        gbc.insets.left = 10;
        this.parentDirectory = Utilities.createLongTextField();
        gbc.weightx = 1.0;
        gbc.fill = 2;
        this.add((Component)this.parentDirectory, gbc);
        this.browse = Utilities.createButton(AdminToolMessages.INFO_CTRL_PANEL_BROWSE_BUTTON_LABEL.get());
        this.browse.setOpaque(false);
        this.browse.addActionListener(new BrowseActionListener(this.parentDirectory, BrowseActionListener.BrowseType.LOCATION_DIRECTORY, this));
        gbc.gridx = 2;
        gbc.weightx = 0.0;
        this.add((Component)this.browse, gbc);
        gbc.gridx = 0;
        ++gbc.gridy;
        gbc.insets.top = 10;
        gbc.insets.left = 0;
        this.lAvailableBackups = Utilities.createPrimaryLabel(AdminToolMessages.INFO_CTRL_PANEL_AVAILABLE_BACKUPS_LABEL.get());
        gbc.anchor = 18;
        gbc.fill = 0;
        this.add((Component)this.lAvailableBackups, gbc);
        gbc.gridx = 1;
        gbc.gridwidth = 2;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        gbc.insets.left = 10;
        this.lRefreshingList = Utilities.createDefaultLabel(this.REFRESHING_LIST);
        this.lRefreshingList.setHorizontalAlignment(0);
        gbc.anchor = 10;
        this.add((Component)this.lRefreshingList, gbc);
        this.backupList = new JTable();
        BackupTableModel model = new BackupTableModel();
        for (BackupDescriptor backup : this.createDummyBackupList()) {
            model.add(backup);
        }
        this.backupList.setModel(model);
        this.backupList.getSelectionModel().setSelectionMode(0);
        this.backupList.setShowGrid(false);
        this.backupList.setIntercellSpacing(new Dimension(0, 0));
        this.renderer = new BackupTableCellRenderer();
        this.renderer.setParentPath(new File("/local/OpenDS-X.X.X/bak"));
        for (int i = 0; i < model.getColumnCount(); ++i) {
            TableColumn col = this.backupList.getColumn(model.getColumnName(i));
            col.setCellRenderer(this.renderer);
        }
        this.backupList.getTableHeader().setVisible(false);
        this.backupList.getTableHeader().setPreferredSize(new Dimension(0, 0));
        this.backupList.getTableHeader().setMinimumSize(new Dimension(0, 0));
        Utilities.updateTableSizes(this.backupList);
        this.tableScroll = Utilities.createScrollPane(this.backupList);
        this.tableScroll.setPreferredSize(this.backupList.getPreferredSize());
        gbc.anchor = 18;
        this.add((Component)this.tableScroll, gbc);
        this.lRefreshingList.setPreferredSize(this.tableScroll.getPreferredSize());
        ++gbc.gridy;
        gbc.anchor = 13;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.insets.top = 5;
        JPanel buttonPanel = new JPanel(new GridBagLayout());
        buttonPanel.setOpaque(false);
        this.add((Component)buttonPanel, gbc);
        GridBagConstraints gbc2 = new GridBagConstraints();
        gbc2.gridx = 0;
        gbc2.gridy = 0;
        gbc2.gridwidth = 1;
        gbc2.anchor = 13;
        gbc2.fill = 2;
        gbc2.weightx = 1.0;
        buttonPanel.add(Box.createHorizontalGlue(), gbc2);
        this.refreshList = Utilities.createButton(AdminToolMessages.INFO_CTRL_PANEL_REFRESH_LIST_BUTTON_LABEL.get());
        this.refreshList.setOpaque(false);
        this.refreshList.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                BackupListPanel.this.refreshList();
            }
        });
        gbc2.weightx = 0.0;
        ++gbc2.gridx;
        buttonPanel.add((Component)this.refreshList, gbc2);
        ++gbc2.gridx;
        gbc2.insets.left = 5;
        this.verifyBackup = Utilities.createButton(AdminToolMessages.INFO_CTRL_PANEL_VERIFY_BACKUP_BUTTON_LABEL.get());
        this.verifyBackup.setOpaque(false);
        this.verifyBackup.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                BackupListPanel.this.verifyBackupClicked();
            }
        });
        ListSelectionListener listener = new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent ev) {
                BackupDescriptor backup = BackupListPanel.this.getSelectedBackup();
                BackupListPanel.this.verifyBackup.setEnabled(backup != null);
            }
        };
        this.backupList.getSelectionModel().addListSelectionListener(listener);
        listener.valueChanged(null);
        buttonPanel.add((Component)this.verifyBackup, gbc2);
    }

    protected void refreshList() {
        final boolean refreshEnabled = this.refreshList.isEnabled();
        this.refreshList.setEnabled(false);
        this.verifyBackup.setEnabled(false);
        this.tableScroll.setVisible(false);
        this.lRefreshingList.setText(this.REFRESHING_LIST.toString());
        this.lRefreshingList.setVisible(true);
        final int lastSelectedRow = this.backupList.getSelectedRow();
        final String parentPath = this.parentDirectory.getText();
        BackgroundTask<Set<BackupInfo>> worker = new BackgroundTask<Set<BackupInfo>>(){

            @Override
            public Set<BackupInfo> processBackgroundTask() throws Throwable {
                LinkedHashSet<BackupInfo> backups = new LinkedHashSet<BackupInfo>();
                Throwable firstThrowable = null;
                try {
                    BackupDirectory backupDir = BackupDirectory.readBackupDirectoryDescriptor(parentPath);
                    backups.addAll(backupDir.getBackups().values());
                }
                catch (Throwable t) {
                    firstThrowable = t;
                }
                File f = new File(parentPath);
                if (f.isDirectory()) {
                    File[] children = f.listFiles();
                    for (int i = 0; i < children.length; ++i) {
                        if (!children[i].isDirectory()) continue;
                        try {
                            BackupDirectory backupDir = BackupDirectory.readBackupDirectoryDescriptor(children[i].getAbsolutePath());
                            backups.addAll(backupDir.getBackups().values());
                            continue;
                        }
                        catch (Throwable t2) {
                            if (children[i].getName().equals("tasks") || firstThrowable == null) continue;
                            LOG.log(Level.WARNING, "Error searching backup: " + t2, t2);
                        }
                    }
                }
                if (backups.size() == 0 && firstThrowable != null) {
                    throw firstThrowable;
                }
                return backups;
            }

            @Override
            public void backgroundTaskCompleted(Set<BackupInfo> returnValue, Throwable t) {
                BackupTableModel model = (BackupTableModel)BackupListPanel.this.backupList.getModel();
                model.clear();
                BackupListPanel.this.renderer.setParentPath(new File(parentPath));
                if (t == null) {
                    if (returnValue.size() > 0) {
                        for (BackupInfo backup : returnValue) {
                            model.add(new BackupDescriptor(backup));
                        }
                        model.fireTableDataChanged();
                        Utilities.updateTableSizes(BackupListPanel.this.backupList);
                        BackupListPanel.this.tableScroll.setVisible(true);
                        BackupListPanel.this.lRefreshingList.setVisible(false);
                    } else {
                        model.fireTableDataChanged();
                        BackupListPanel.this.lRefreshingList.setText(BackupListPanel.this.NO_BACKUPS_FOUND.toString());
                    }
                    BackupListPanel.this.errorPane.setVisible(false);
                    BackupListPanel.this.configurationChanged(new ConfigurationChangeEvent(null, BackupListPanel.this.getInfo().getServerDescriptor()));
                } else {
                    OpenDsException e;
                    model.fireTableDataChanged();
                    boolean displayError = true;
                    if (t instanceof OpenDsException && (e = (OpenDsException)t).getMessageObject().getDescriptor().equals(CoreMessages.ERR_BACKUPDIRECTORY_NO_DESCRIPTOR_FILE)) {
                        displayError = false;
                    }
                    if (displayError) {
                        Message details = ToolMessages.ERR_RESTOREDB_CANNOT_READ_BACKUP_DIRECTORY.get(BackupListPanel.this.parentDirectory.getText(), StaticUtils.getExceptionMessage(t));
                        BackupListPanel.this.updateErrorPane(BackupListPanel.this.errorPane, AdminToolMessages.ERR_ERROR_SEARCHING_BACKUPS_SUMMARY.get(), ColorAndFontConstants.errorTitleFont, details, BackupListPanel.this.errorPane.getFont());
                        BackupListPanel.this.packParentDialog();
                    }
                    BackupListPanel.this.errorPane.setVisible(displayError);
                    if (!displayError) {
                        BackupListPanel.this.configurationChanged(new ConfigurationChangeEvent(null, BackupListPanel.this.getInfo().getServerDescriptor()));
                    }
                    BackupListPanel.this.lRefreshingList.setText(BackupListPanel.this.NO_BACKUPS_FOUND.toString());
                }
                BackupListPanel.this.refreshList.setEnabled(refreshEnabled);
                BackupListPanel.this.verifyBackup.setEnabled(BackupListPanel.this.getSelectedBackup() != null);
                if (lastSelectedRow != -1 && lastSelectedRow < BackupListPanel.this.backupList.getRowCount()) {
                    BackupListPanel.this.backupList.setRowSelectionInterval(lastSelectedRow, lastSelectedRow);
                } else if (BackupListPanel.this.backupList.getRowCount() > 0) {
                    BackupListPanel.this.backupList.setRowSelectionInterval(0, 0);
                }
            }
        };
        worker.startBackgroundTask();
    }

    private ArrayList<BackupDescriptor> createDummyBackupList() {
        ArrayList<BackupDescriptor> list = new ArrayList<BackupDescriptor>();
        list.add(new BackupDescriptor(new File("/local/OpenDS-X.X.X/bak/200704201567Z"), new GregorianCalendar(2007, 5, 20, 8, 10).getTime(), BackupDescriptor.Type.FULL, "id"));
        list.add(new BackupDescriptor(new File("/local/OpenDS-X.X.X/bak/200704201567Z"), new GregorianCalendar(2007, 5, 22, 8, 10).getTime(), BackupDescriptor.Type.INCREMENTAL, "id"));
        list.add(new BackupDescriptor(new File("/local/OpenDS-X.X.X/bak/200704221567Z"), new GregorianCalendar(2007, 5, 25, 8, 10).getTime(), BackupDescriptor.Type.INCREMENTAL, "id"));
        return list;
    }

    @Override
    public void configurationChanged(ConfigurationChangeEvent ev) {
        ServerDescriptor desc = ev.getNewDescriptor();
        if (!this.backupDirectoryInitialized && this.parentDirectory.getText().length() == 0) {
            final String path = new File(desc.getInstancePath(), "bak").getAbsolutePath();
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    BackupListPanel.this.parentDirectory.setText(path);
                    BackupListPanel.this.refreshList();
                    BackupListPanel.this.backupDirectoryInitialized = true;
                }
            });
        }
    }

    @Override
    public void toBeDisplayed(boolean visible) {
        if (visible && this.backupDirectoryInitialized) {
            this.refreshList();
        }
    }
}

