/*
 * Decompiled with CFR 0.152.
 */
package org.opends.guitools.controlpanel.ui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import org.opends.guitools.controlpanel.datamodel.ControlPanelInfo;
import org.opends.guitools.controlpanel.util.BackgroundTask;
import org.opends.guitools.controlpanel.util.Utilities;
import org.opends.messages.AdminToolMessages;
import org.opends.quicksetup.ui.WebBrowserErrorDialog;
import org.opends.quicksetup.util.WebBrowserException;
import org.opends.quicksetup.util.WebBrowserLauncher;

abstract class GenericMenuBar
extends JMenuBar {
    private ControlPanelInfo info;

    protected GenericMenuBar(ControlPanelInfo info) {
        this.info = info;
    }

    public ControlPanelInfo getInfo() {
        return this.info;
    }

    protected JMenu createHelpMenuBar() {
        JMenu menu = Utilities.createMenu(AdminToolMessages.INFO_CTRL_PANEL_HELP_MENU.get(), AdminToolMessages.INFO_CTRL_PANEL_HELP_MENU_DESCRIPTION.get());
        menu.setMnemonic(72);
        JMenuItem menuItem = Utilities.createMenuItem(AdminToolMessages.INFO_CTRL_PANEL_ADMINISTRATION_GUIDE_MENU.get());
        menuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                GenericMenuBar.this.displayURL("https://www.opends.org/wiki/page/AdministrationGuide");
            }
        });
        menu.add(menuItem);
        menuItem = Utilities.createMenuItem(AdminToolMessages.INFO_CTRL_PANEL_DOCUMENTATION_WIKI_MENU.get());
        menuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                GenericMenuBar.this.displayURL("https://www.opends.org/wiki/page/Main");
            }
        });
        menu.add(menuItem);
        return menu;
    }

    protected void displayURL(final String url) {
        BackgroundTask<Void> worker = new BackgroundTask<Void>(){

            @Override
            public Void processBackgroundTask() throws WebBrowserException {
                try {
                    WebBrowserLauncher.openURL(url);
                }
                catch (Throwable t) {
                    throw new WebBrowserException(url, AdminToolMessages.ERR_CTRL_PANEL_UNEXPECTED_DETAILS.get(t.toString()), t);
                }
                return null;
            }

            @Override
            public void backgroundTaskCompleted(Void returnValue, Throwable throwable) {
                WebBrowserException ex = (WebBrowserException)throwable;
                if (ex != null) {
                    WebBrowserErrorDialog dlg = new WebBrowserErrorDialog(Utilities.getFrame(GenericMenuBar.this), ex);
                    Utilities.centerGoldenMean(dlg, Utilities.getParentDialog(GenericMenuBar.this));
                    dlg.setModal(true);
                    dlg.packAndShow();
                }
            }
        };
        worker.startBackgroundTask();
    }
}

