/*
 * Decompiled with CFR 0.152.
 */
package org.opends.guitools.controlpanel.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.naming.ldap.InitialLdapContext;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.opends.guitools.controlpanel.datamodel.AbstractIndexDescriptor;
import org.opends.guitools.controlpanel.datamodel.ControlPanelInfo;
import org.opends.guitools.controlpanel.datamodel.IndexDescriptor;
import org.opends.guitools.controlpanel.event.ConfigurationChangeEvent;
import org.opends.guitools.controlpanel.event.ScrollPaneBorderListener;
import org.opends.guitools.controlpanel.task.DeleteIndexTask;
import org.opends.guitools.controlpanel.task.OfflineUpdateException;
import org.opends.guitools.controlpanel.task.Task;
import org.opends.guitools.controlpanel.ui.AbstractIndexPanel;
import org.opends.guitools.controlpanel.ui.ColorAndFontConstants;
import org.opends.guitools.controlpanel.ui.ProgressDialog;
import org.opends.guitools.controlpanel.ui.UnsavedChangesDialog;
import org.opends.guitools.controlpanel.util.ConfigReader;
import org.opends.guitools.controlpanel.util.Utilities;
import org.opends.messages.AdminToolMessages;
import org.opends.messages.Message;
import org.opends.server.admin.client.ManagementContext;
import org.opends.server.admin.client.ldap.JNDIDirContextAdaptor;
import org.opends.server.admin.client.ldap.LDAPManagementContext;
import org.opends.server.admin.std.client.LocalDBBackendCfgClient;
import org.opends.server.admin.std.client.LocalDBIndexCfgClient;
import org.opends.server.admin.std.client.RootCfgClient;
import org.opends.server.admin.std.meta.LocalDBIndexCfgDefn;
import org.opends.server.core.DirectoryServer;
import org.opends.server.extensions.ConfigFileHandler;
import org.opends.server.types.AttributeType;
import org.opends.server.types.DN;
import org.opends.server.types.Entry;
import org.opends.server.types.LDIFImportConfig;
import org.opends.server.types.OpenDsException;
import org.opends.server.util.LDIFReader;
import org.opends.server.util.ServerConstants;
import org.opends.server.util.cli.CommandBuilder;

public class IndexPanel
extends AbstractIndexPanel {
    private static final long serialVersionUID = 1439500626486823366L;
    private IndexDescriptor index;
    private ScrollPaneBorderListener scrollListener;
    private boolean ignoreCheckSave;
    private ModifyIndexTask newModifyTask;

    public IndexPanel() {
        this.createLayout();
    }

    private void createLayout() {
        GridBagConstraints gbc = new GridBagConstraints();
        JPanel p = new JPanel(new GridBagLayout());
        p.setOpaque(false);
        super.createBasicLayout(p, gbc, true);
        p.setBorder(new EmptyBorder(10, 10, 10, 10));
        gbc = new GridBagConstraints();
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        gbc.gridx = 0;
        gbc.gridy = 0;
        JScrollPane scroll = Utilities.createBorderLessScrollBar(p);
        this.scrollListener = new ScrollPaneBorderListener(scroll);
        this.add((Component)scroll, gbc);
        ++gbc.gridy;
        gbc.gridx = 0;
        gbc.weightx = 1.0;
        gbc.insets.left = 0;
        gbc.gridwidth = 2;
        gbc.weighty = 0.0;
        gbc.fill = 2;
        gbc.insets = new Insets(10, 10, 0, 10);
        this.add((Component)this.warning, gbc);
        Utilities.setWarningLabel(this.warning, this.INDEX_MODIFIED);
        ++gbc.gridy;
        JPanel buttonPanel = new JPanel(new GridBagLayout());
        buttonPanel.setOpaque(false);
        gbc.insets = new Insets(10, 10, 10, 10);
        this.add((Component)buttonPanel, gbc);
        gbc.insets = new Insets(0, 0, 0, 0);
        gbc.gridy = 0;
        gbc.gridx = 0;
        gbc.weightx = 0.0;
        gbc.gridwidth = 1;
        this.deleteIndex.setOpaque(false);
        gbc.insets.left = 0;
        buttonPanel.add((Component)this.deleteIndex, gbc);
        this.deleteIndex.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                IndexPanel.this.deleteIndex();
            }
        });
        gbc.gridx = 2;
        gbc.weightx = 1.0;
        buttonPanel.add(Box.createHorizontalGlue(), gbc);
        gbc.weightx = 0.0;
        gbc.insets.left = 10;
        this.saveChanges.setOpaque(false);
        gbc.gridx = 3;
        buttonPanel.add((Component)this.saveChanges, gbc);
        this.saveChanges.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                IndexPanel.this.saveIndex(false);
            }
        });
        this.entryLimit.getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent ev) {
                IndexPanel.this.checkSaveButton();
            }

            public void changedUpdate(DocumentEvent ev) {
                IndexPanel.this.checkSaveButton();
            }

            public void removeUpdate(DocumentEvent ev) {
                IndexPanel.this.checkSaveButton();
            }
        });
        ActionListener listener = new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                IndexPanel.this.checkSaveButton();
            }
        };
        for (JCheckBox cb : this.types) {
            cb.addActionListener(listener);
        }
    }

    public Message getTitle() {
        return AdminToolMessages.INFO_CTRL_PANEL_INDEX_PANEL_TITLE.get();
    }

    public Component getPreferredFocusComponent() {
        return this.entryLimit;
    }

    public void configurationChanged(final ConfigurationChangeEvent ev) {
        this.updateErrorPaneIfAuthRequired(ev.getNewDescriptor(), AdminToolMessages.INFO_CTRL_PANEL_AUTHENTICATION_REQUIRED_FOR_INDEX_EDITING.get());
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                IndexPanel.this.checkSaveButton();
                IndexPanel.this.deleteIndex.setEnabled(!IndexPanel.this.authenticationRequired(ev.getNewDescriptor()));
            }
        });
    }

    public void okClicked() {
    }

    public boolean mustCheckUnsavedChanges() {
        return this.index != null && this.saveChanges.isVisible() && this.saveChanges.isEnabled();
    }

    public UnsavedChangesDialog.Result checkUnsavedChanges() {
        UnsavedChangesDialog unsavedChangesDlg = new UnsavedChangesDialog((Component)Utilities.getParentDialog(this), this.getInfo());
        unsavedChangesDlg.setMessage(AdminToolMessages.INFO_CTRL_PANEL_UNSAVED_CHANGES_SUMMARY.get(), AdminToolMessages.INFO_CTRL_PANEL_UNSAVED_INDEX_CHANGES_DETAILS.get(this.index.getName()));
        Utilities.centerGoldenMean(unsavedChangesDlg, Utilities.getParentDialog(this));
        unsavedChangesDlg.setVisible(true);
        UnsavedChangesDialog.Result result = unsavedChangesDlg.getResult();
        if (result == UnsavedChangesDialog.Result.SAVE) {
            this.saveIndex(false);
            if (this.newModifyTask == null || this.newModifyTask.getState() != Task.State.FINISHED_SUCCESSFULLY) {
                result = UnsavedChangesDialog.Result.CANCEL;
            }
        }
        return result;
    }

    private void checkSaveButton() {
        if (!this.ignoreCheckSave && this.index != null) {
            this.saveChanges.setEnabled(!this.authenticationRequired(this.getInfo().getServerDescriptor()) && this.isModified());
        }
    }

    private void deleteIndex() {
        ArrayList<Message> errors = new ArrayList<Message>();
        ProgressDialog dlg = new ProgressDialog((Component)Utilities.getParentDialog(this), AdminToolMessages.INFO_CTRL_PANEL_DELETE_INDEX_TITLE.get(), this.getInfo());
        ArrayList<AbstractIndexDescriptor> indexesToDelete = new ArrayList<AbstractIndexDescriptor>();
        indexesToDelete.add(this.index);
        DeleteIndexTask newTask = new DeleteIndexTask(this.getInfo(), dlg, indexesToDelete);
        for (Task task : this.getInfo().getTasks()) {
            task.canLaunch(newTask, errors);
        }
        if (errors.isEmpty()) {
            String indexName = this.index.getName();
            String backendName = this.index.getBackend().getBackendID();
            if (this.displayConfirmationDialog(AdminToolMessages.INFO_CTRL_PANEL_CONFIRMATION_REQUIRED_SUMMARY.get(), AdminToolMessages.INFO_CTRL_PANEL_CONFIRMATION_INDEX_DELETE_DETAILS.get(indexName, backendName))) {
                this.launchOperation(newTask, AdminToolMessages.INFO_CTRL_PANEL_DELETING_INDEX_SUMMARY.get(), AdminToolMessages.INFO_CTRL_PANEL_DELETING_INDEX_COMPLETE.get(), AdminToolMessages.INFO_CTRL_PANEL_DELETING_INDEX_SUCCESSFUL.get(indexName, backendName), AdminToolMessages.ERR_CTRL_PANEL_DELETING_INDEX_ERROR_SUMMARY.get(), AdminToolMessages.ERR_CTRL_PANEL_DELETING_INDEX_ERROR_DETAILS.get(indexName), null, dlg);
                dlg.setVisible(true);
            }
        } else {
            this.displayErrorDialog(errors);
        }
    }

    private void saveIndex(boolean modal) {
        this.newModifyTask = null;
        if (!this.isModified()) {
            return;
        }
        List<Message> errors = this.getErrors();
        if (errors.isEmpty()) {
            ProgressDialog dlg = new ProgressDialog((Component)Utilities.getParentDialog(this), AdminToolMessages.INFO_CTRL_PANEL_MODIFYING_INDEX_TITLE.get(), this.getInfo());
            dlg.setModal(modal);
            this.newModifyTask = new ModifyIndexTask(this.getInfo(), dlg);
            for (Task task : this.getInfo().getTasks()) {
                task.canLaunch(this.newModifyTask, errors);
            }
            if (errors.size() == 0) {
                String attributeName = this.index.getName();
                String backendName = this.index.getBackend().getBackendID();
                this.launchOperation(this.newModifyTask, AdminToolMessages.INFO_CTRL_PANEL_MODIFYING_INDEX_SUMMARY.get(attributeName), AdminToolMessages.INFO_CTRL_PANEL_MODIFYING_INDEX_COMPLETE.get(), AdminToolMessages.INFO_CTRL_PANEL_MODIFYING_INDEX_SUCCESSFUL.get(attributeName, backendName), AdminToolMessages.ERR_CTRL_PANEL_MODIFYING_INDEX_ERROR_SUMMARY.get(), AdminToolMessages.ERR_CTRL_PANEL_MODIFYING_INDEX_ERROR_DETAILS.get(attributeName), null, dlg);
                this.saveChanges.setEnabled(false);
                dlg.setVisible(true);
            }
        }
        if (errors.size() > 0) {
            this.displayErrorDialog(errors);
        }
    }

    public void update(IndexDescriptor index) {
        this.ignoreCheckSave = true;
        this.setPrimaryValid(this.lEntryLimit);
        this.setPrimaryValid(this.lType);
        this.name.setText(index.getName());
        this.backendName.setText(index.getBackend().getBackendID());
        this.titlePanel.setDetails(Message.raw(index.getName(), new Object[0]));
        this.entryLimit.setText(String.valueOf(index.getEntryLimit()));
        this.approximate.setSelected(false);
        this.equality.setSelected(false);
        this.ordering.setSelected(false);
        this.substring.setSelected(false);
        this.presence.setSelected(false);
        for (LocalDBIndexCfgDefn.IndexType type : index.getTypes()) {
            switch (type) {
                case APPROXIMATE: {
                    this.approximate.setSelected(true);
                    break;
                }
                case PRESENCE: {
                    this.presence.setSelected(true);
                    break;
                }
                case EQUALITY: {
                    this.equality.setSelected(true);
                    break;
                }
                case ORDERING: {
                    this.ordering.setSelected(true);
                    break;
                }
                case SUBSTRING: {
                    this.substring.setSelected(true);
                }
            }
        }
        JComponent[] comps = new JComponent[]{this.entryLimit, this.lType, this.typesPanel, this.lEntryLimit};
        for (int i = 0; i < comps.length; ++i) {
            comps[i].setVisible(!index.isDatabaseIndex());
        }
        AttributeType attr = index.getAttributeType();
        this.repopulateTypesPanel(attr);
        if (index.isDatabaseIndex()) {
            this.entryLimit.setText("");
        }
        this.saveChanges.setVisible(!index.isDatabaseIndex());
        this.deleteIndex.setVisible(!index.isDatabaseIndex());
        if (index.isDatabaseIndex()) {
            Utilities.setWarningLabel(this.warning, this.NON_CONFIGURABLE_INDEX);
            this.warning.setVisible(true);
        } else if (this.getInfo() != null) {
            if (this.getInfo().mustReindex(index)) {
                Utilities.setWarningLabel(this.warning, this.INDEX_MODIFIED);
                this.warning.setVisible(true);
                this.warning.setVerticalTextPosition(1);
            } else {
                this.warning.setVisible(false);
            }
        }
        this.index = index;
        this.ignoreCheckSave = false;
        this.checkSaveButton();
        this.scrollListener.updateBorder();
    }

    private boolean isModified() {
        return !this.getTypes().equals(this.index.getTypes()) || !String.valueOf(this.index.getEntryLimit()).equals(this.entryLimit.getText());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class ModifyIndexTask
    extends Task {
        private Set<String> backendSet;
        private String attributeName;
        private String backendName;
        private int entryLimitValue;
        private IndexDescriptor indexToModify;
        private SortedSet<LocalDBIndexCfgDefn.IndexType> indexTypes;
        private IndexDescriptor modifiedIndex;

        public ModifyIndexTask(ControlPanelInfo info, ProgressDialog dlg) {
            super(info, dlg);
            this.indexTypes = new TreeSet<LocalDBIndexCfgDefn.IndexType>();
            this.backendName = IndexPanel.this.index.getBackend().getBackendID();
            this.backendSet = new HashSet<String>();
            this.backendSet.add(this.backendName);
            this.attributeName = IndexPanel.this.index.getName();
            this.entryLimitValue = Integer.parseInt(IndexPanel.this.entryLimit.getText());
            this.indexTypes = IndexPanel.this.getTypes();
            this.indexToModify = IndexPanel.this.index;
        }

        @Override
        public Task.Type getType() {
            return Task.Type.MODIFY_INDEX;
        }

        @Override
        public Set<String> getBackends() {
            return this.backendSet;
        }

        @Override
        public Message getTaskDescription() {
            return AdminToolMessages.INFO_CTRL_PANEL_MODIFY_INDEX_TASK_DESCRIPTION.get(this.attributeName, this.backendName);
        }

        @Override
        public boolean canLaunch(Task taskToBeLaunched, Collection<Message> incompatibilityReasons) {
            boolean canLaunch = true;
            if (this.state == Task.State.RUNNING) {
                TreeSet<String> backends = new TreeSet<String>(taskToBeLaunched.getBackends());
                backends.retainAll(this.getBackends());
                if (backends.size() > 0) {
                    incompatibilityReasons.add(this.getIncompatibilityMessage(this, taskToBeLaunched));
                    canLaunch = false;
                }
            }
            return canLaunch;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void updateConfiguration() throws OpenDsException {
            boolean configHandlerUpdated = false;
            try {
                if (!this.isServerRunning()) {
                    configHandlerUpdated = true;
                    this.getInfo().stopPooling();
                    if (this.getInfo().mustDeregisterConfig()) {
                        DirectoryServer.deregisterBaseDN(DN.decode("cn=config"));
                    }
                    DirectoryServer.getInstance().initializeConfiguration(ConfigFileHandler.class.getName(), ConfigReader.configFile);
                    this.getInfo().setMustDeregisterConfig(true);
                } else {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            StringBuilder sb = new StringBuilder();
                            sb.append(ModifyIndexTask.this.getConfigCommandLineName());
                            List args = ModifyIndexTask.this.getObfuscatedCommandLineArguments(ModifyIndexTask.this.getDSConfigCommandLineArguments());
                            args.removeAll(ModifyIndexTask.this.getConfigCommandLineArguments());
                            for (String arg : args) {
                                sb.append(" " + CommandBuilder.escapeValue(arg));
                            }
                            ModifyIndexTask.this.getProgressDialog().appendProgressHtml(Utilities.applyFont(AdminToolMessages.INFO_CTRL_PANEL_EQUIVALENT_CMD_TO_MODIFY_INDEX.get() + "<br><b>" + sb.toString() + "</b><br><br>", ColorAndFontConstants.progressFont));
                        }
                    });
                }
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        ModifyIndexTask.this.getProgressDialog().appendProgressHtml(Utilities.getProgressWithPoints(AdminToolMessages.INFO_CTRL_PANEL_MODIFYING_INDEX_PROGRESS.get(ModifyIndexTask.this.attributeName), ColorAndFontConstants.progressFont));
                    }
                });
                if (this.isServerRunning()) {
                    this.modifyIndex(this.getInfo().getDirContext());
                } else {
                    this.modifyIndex();
                }
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        ModifyIndexTask.this.getProgressDialog().appendProgressHtml(Utilities.getProgressDone(ColorAndFontConstants.progressFont));
                    }
                });
            }
            finally {
                if (configHandlerUpdated) {
                    DirectoryServer.getInstance().initializeConfiguration(ConfigReader.configClassName, ConfigReader.configFile);
                    this.getInfo().startPooling(20000L);
                }
            }
        }

        private String getIndexLDIF() {
            String dn = Utilities.getRDNString("ds-cfg-backend-id", this.backendName) + ",cn=Backends,cn=config";
            ArrayList<String> lines = new ArrayList<String>();
            lines.add("dn: " + Utilities.getRDNString("ds-cfg-attribute", this.attributeName) + ",cn=Index," + dn);
            lines.add("objectClass: ds-cfg-local-db-index");
            lines.add("objectClass: top");
            lines.add("ds-cfg-attribute: " + this.attributeName);
            lines.add("ds-cfg-index-entry-limit: " + this.entryLimitValue);
            for (LocalDBIndexCfgDefn.IndexType type : this.indexTypes) {
                lines.add("ds-cfg-index-type: " + type.toString());
            }
            StringBuilder sb = new StringBuilder();
            for (String line : lines) {
                sb.append(line + ServerConstants.EOL);
            }
            return sb.toString();
        }

        private void modifyIndex() throws OpenDsException {
            LDIFImportConfig ldifImportConfig = null;
            try {
                String ldif = this.getIndexLDIF();
                ldifImportConfig = new LDIFImportConfig(new StringReader(ldif));
                LDIFReader reader = new LDIFReader(ldifImportConfig);
                Entry newConfigEntry = reader.readEntry();
                Entry oldEntry = DirectoryServer.getConfigEntry(newConfigEntry.getDN()).getEntry();
                DirectoryServer.getConfigHandler().replaceEntry(oldEntry, newConfigEntry, null);
                DirectoryServer.getConfigHandler().writeUpdatedConfig();
            }
            catch (IOException ioe) {
                throw new OfflineUpdateException(AdminToolMessages.ERR_CTRL_PANEL_ERROR_UPDATING_CONFIGURATION.get(ioe.toString()), (Throwable)ioe);
            }
            finally {
                if (ldifImportConfig != null) {
                    ldifImportConfig.close();
                }
            }
        }

        private void modifyIndex(InitialLdapContext ctx) throws OpenDsException {
            StringBuilder sb = new StringBuilder();
            sb.append(this.getConfigCommandLineName());
            List<String> args = this.getObfuscatedCommandLineArguments(this.getDSConfigCommandLineArguments());
            for (String arg : args) {
                sb.append(" " + CommandBuilder.escapeValue(arg));
            }
            ManagementContext mCtx = LDAPManagementContext.createFromContext(JNDIDirContextAdaptor.adapt(ctx));
            RootCfgClient root = mCtx.getRootConfiguration();
            LocalDBBackendCfgClient backend = (LocalDBBackendCfgClient)root.getBackend(this.backendName);
            LocalDBIndexCfgClient index = backend.getLocalDBIndex(this.attributeName);
            if (!this.indexTypes.equals(this.indexToModify.getTypes())) {
                index.setIndexType(this.indexTypes);
            }
            if (this.entryLimitValue != index.getIndexEntryLimit()) {
                index.setIndexEntryLimit(this.entryLimitValue);
            }
            index.commit();
        }

        @Override
        protected String getCommandLinePath() {
            return null;
        }

        protected ArrayList<String> getCommandLineArguments() {
            return new ArrayList<String>();
        }

        private String getConfigCommandLineName() {
            if (this.isServerRunning() && IndexPanel.this.isModified()) {
                return this.getCommandLinePath("dsconfig");
            }
            return null;
        }

        @Override
        public void runTask() {
            this.state = Task.State.RUNNING;
            this.lastException = null;
            try {
                this.updateConfiguration();
                this.modifiedIndex = new IndexDescriptor(this.attributeName, this.indexToModify.getAttributeType(), this.indexToModify.getBackend(), this.indexTypes, this.entryLimitValue);
                this.getInfo().registerModifiedIndex(this.modifiedIndex);
                this.state = Task.State.FINISHED_SUCCESSFULLY;
            }
            catch (Throwable t) {
                this.lastException = t;
                this.state = Task.State.FINISHED_WITH_ERROR;
            }
        }

        @Override
        public void postOperation() {
            if (this.lastException == null && this.state == Task.State.FINISHED_SUCCESSFULLY) {
                IndexPanel.this.rebuildIndexIfNecessary(this.modifiedIndex, this.getProgressDialog());
            }
        }

        private ArrayList<String> getDSConfigCommandLineArguments() {
            ArrayList<String> args = new ArrayList<String>();
            args.add("set-local-db-index-prop");
            args.add("--backend-name");
            args.add(this.backendName);
            args.add("--index-name");
            args.add(this.attributeName);
            if (!this.indexTypes.equals(this.indexToModify.getTypes())) {
                for (LocalDBIndexCfgDefn.IndexType newType : this.indexTypes) {
                    args.add("--set");
                    args.add("index-type:" + newType.toString());
                }
            }
            if (this.entryLimitValue != this.indexToModify.getEntryLimit()) {
                args.add("--set");
                args.add("index-entry-limit:" + this.entryLimitValue);
            }
            args.addAll(this.getConnectionCommandLineArguments());
            args.add("--no-prompt");
            return args;
        }
    }
}

