/*
 * Decompiled with CFR 0.152.
 */
package org.opends.guitools.controlpanel.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import org.opends.guitools.controlpanel.datamodel.Action;
import org.opends.guitools.controlpanel.datamodel.Category;
import org.opends.guitools.controlpanel.event.ConfigurationChangeEvent;
import org.opends.guitools.controlpanel.ui.BackupPanel;
import org.opends.guitools.controlpanel.ui.BrowseEntriesPanel;
import org.opends.guitools.controlpanel.ui.BrowseIndexPanel;
import org.opends.guitools.controlpanel.ui.BrowseSchemaPanel;
import org.opends.guitools.controlpanel.ui.ColorAndFontConstants;
import org.opends.guitools.controlpanel.ui.ExportLDIFPanel;
import org.opends.guitools.controlpanel.ui.GenericDialog;
import org.opends.guitools.controlpanel.ui.ImportLDIFPanel;
import org.opends.guitools.controlpanel.ui.JavaPropertiesPanel;
import org.opends.guitools.controlpanel.ui.NewBaseDNPanel;
import org.opends.guitools.controlpanel.ui.RebuildIndexPanel;
import org.opends.guitools.controlpanel.ui.RestorePanel;
import org.opends.guitools.controlpanel.ui.StatusGenericPanel;
import org.opends.guitools.controlpanel.ui.VerifyIndexPanel;
import org.opends.guitools.controlpanel.ui.WindowsServicePanel;
import org.opends.guitools.controlpanel.ui.components.ActionButton;
import org.opends.guitools.controlpanel.ui.components.CategoryPanel;
import org.opends.guitools.controlpanel.util.Utilities;
import org.opends.messages.AdminToolMessages;
import org.opends.messages.Message;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MainActionsPane
extends StatusGenericPanel {
    private static final long serialVersionUID = 7616418700758530191L;

    public MainActionsPane() {
        this.setBackground(ColorAndFontConstants.greyBackground);
        GridBagConstraints gbc1 = new GridBagConstraints();
        gbc1.gridx = 0;
        gbc1.gridy = 0;
        gbc1.fill = 2;
        gbc1.weightx = 1.0;
        ArrayList<Category> categories = this.createCategories();
        ButtonGroup group = new ButtonGroup();
        int maxWidth = 0;
        final HashMap dialogs = new HashMap();
        ArrayList<ActionButton> actions = new ArrayList<ActionButton>();
        for (Category category : categories) {
            JPanel categoryPanel = new JPanel(new GridBagLayout());
            GridBagConstraints gbc2 = new GridBagConstraints();
            gbc2.gridx = 0;
            gbc2.gridy = 0;
            gbc2.weightx = 1.0;
            gbc2.fill = 2;
            for (Action action : category.getActions()) {
                final ActionButton b = new ActionButton(action);
                actions.add(b);
                b.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent ev) {
                        Action action = b.getActionObject();
                        GenericDialog dlg = (GenericDialog)dialogs.get(action);
                        if (dlg == null) {
                            Class<? extends StatusGenericPanel> panelClass = action.getAssociatedPanelClass();
                            try {
                                Constructor<? extends StatusGenericPanel> constructor = panelClass.getDeclaredConstructor(new Class[0]);
                                StatusGenericPanel panel = constructor.newInstance(new Object[0]);
                                if (MainActionsPane.this.getInfo() != null) {
                                    panel.setInfo(MainActionsPane.this.getInfo());
                                }
                                dlg = new GenericDialog(Utilities.getFrame(MainActionsPane.this), panel);
                                dialogs.put(action, dlg);
                                Utilities.centerGoldenMean(dlg, Utilities.getFrame(MainActionsPane.this));
                            }
                            catch (Throwable t) {
                                t.printStackTrace();
                            }
                        }
                        if (!dlg.isVisible()) {
                            dlg.setVisible(true);
                        } else {
                            dlg.toFront();
                        }
                    }
                });
                categoryPanel.add((Component)b, gbc2);
                ++gbc2.gridy;
                group.add(b);
                maxWidth = Math.max(maxWidth, b.getPreferredSize().width);
            }
            CategoryPanel p = new CategoryPanel(categoryPanel, category);
            maxWidth = Math.max(maxWidth, p.getPreferredSize().width);
            p.setExpanded(false);
            this.add((Component)p, gbc1);
            ++gbc1.gridy;
            if (!category.getName().equals(AdminToolMessages.INFO_CTRL_PANEL_CATEGORY_DIRECTORY_DATA.get())) continue;
            p.setExpanded(true);
        }
        this.add(Box.createHorizontalStrut(maxWidth), gbc1);
        ++gbc1.gridy;
        gbc1.weighty = 1.0;
        this.add(Box.createVerticalGlue(), gbc1);
        this.createActionButtonListeners(actions);
    }

    @Override
    public Component getPreferredFocusComponent() {
        return null;
    }

    protected ArrayList<Category> createCategories() {
        ArrayList<Category> categories = new ArrayList<Category>();
        Message[][] labels = Utilities.isWindows() ? new Message[][]{{AdminToolMessages.INFO_CTRL_PANEL_CATEGORY_DIRECTORY_DATA.get(), AdminToolMessages.INFO_CTRL_PANEL_ACTION_MANAGE_ENTRIES.get(), AdminToolMessages.INFO_CTRL_PANEL_ACTION_NEW_BASEDN.get(), AdminToolMessages.INFO_CTRL_PANEL_ACTION_IMPORT_LDIF.get(), AdminToolMessages.INFO_CTRL_PANEL_ACTION_EXPORT_LDIF.get(), AdminToolMessages.INFO_CTRL_PANEL_ACTION_BACKUP.get(), AdminToolMessages.INFO_CTRL_PANEL_ACTION_RESTORE.get()}, {AdminToolMessages.INFO_CTRL_PANEL_CATEGORY_SCHEMA.get(), AdminToolMessages.INFO_CTRL_PANEL_ACTION_MANAGE_SCHEMA.get()}, {AdminToolMessages.INFO_CTRL_PANEL_CATEGORY_INDEXES.get(), AdminToolMessages.INFO_CTRL_PANEL_ACTION_MANAGE_INDEXES.get(), AdminToolMessages.INFO_CTRL_PANEL_ACTION_VERIFY_INDEXES.get(), AdminToolMessages.INFO_CTRL_PANEL_ACTION_REBUILD_INDEXES.get()}, {AdminToolMessages.INFO_CTRL_PANEL_CATEGORY_RUNTIME_OPTIONS.get(), AdminToolMessages.INFO_CTRL_PANEL_ACTION_JAVA_SETTINGS.get(), AdminToolMessages.INFO_CTRL_PANEL_ACTION_WINDOWS_SERVICE.get()}} : new Message[][]{{AdminToolMessages.INFO_CTRL_PANEL_CATEGORY_DIRECTORY_DATA.get(), AdminToolMessages.INFO_CTRL_PANEL_ACTION_MANAGE_ENTRIES.get(), AdminToolMessages.INFO_CTRL_PANEL_ACTION_NEW_BASEDN.get(), AdminToolMessages.INFO_CTRL_PANEL_ACTION_IMPORT_LDIF.get(), AdminToolMessages.INFO_CTRL_PANEL_ACTION_EXPORT_LDIF.get(), AdminToolMessages.INFO_CTRL_PANEL_ACTION_BACKUP.get(), AdminToolMessages.INFO_CTRL_PANEL_ACTION_RESTORE.get()}, {AdminToolMessages.INFO_CTRL_PANEL_CATEGORY_SCHEMA.get(), AdminToolMessages.INFO_CTRL_PANEL_ACTION_MANAGE_SCHEMA.get()}, {AdminToolMessages.INFO_CTRL_PANEL_CATEGORY_INDEXES.get(), AdminToolMessages.INFO_CTRL_PANEL_ACTION_MANAGE_INDEXES.get(), AdminToolMessages.INFO_CTRL_PANEL_ACTION_VERIFY_INDEXES.get(), AdminToolMessages.INFO_CTRL_PANEL_ACTION_REBUILD_INDEXES.get()}, {AdminToolMessages.INFO_CTRL_PANEL_CATEGORY_RUNTIME_OPTIONS.get(), AdminToolMessages.INFO_CTRL_PANEL_ACTION_JAVA_SETTINGS.get()}};
        ArrayList<Class> classes = new ArrayList<Class>();
        classes.add(BrowseEntriesPanel.class);
        classes.add(NewBaseDNPanel.class);
        classes.add(ImportLDIFPanel.class);
        classes.add(ExportLDIFPanel.class);
        classes.add(BackupPanel.class);
        classes.add(RestorePanel.class);
        classes.add(BrowseSchemaPanel.class);
        classes.add(BrowseIndexPanel.class);
        classes.add(VerifyIndexPanel.class);
        classes.add(RebuildIndexPanel.class);
        classes.add(JavaPropertiesPanel.class);
        if (Utilities.isWindows()) {
            classes.add(WindowsServicePanel.class);
        }
        int classIndex = 0;
        for (int i = 0; i < labels.length; ++i) {
            Category category = new Category();
            category.setName(labels[i][0]);
            for (int j = 1; j < labels[i].length; ++j) {
                Action action = new Action();
                action.setName(labels[i][j]);
                action.setAssociatedPanel((Class)classes.get(classIndex));
                ++classIndex;
                category.getActions().add(action);
            }
            categories.add(category);
        }
        return categories;
    }

    private void createActionButtonListeners(final Collection<ActionButton> actions) {
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                for (ActionButton button : actions) {
                    if (ev.getSource() != button) continue;
                    button.actionPerformed(ev);
                    break;
                }
            }
        };
        MouseAdapter mouseListener = new MouseAdapter(){

            public void mousePressed(MouseEvent ev) {
                for (ActionButton button : actions) {
                    if (ev.getSource() != button) continue;
                    button.mousePressed(ev);
                    break;
                }
            }

            public void mouseReleased(MouseEvent ev) {
                for (ActionButton button : actions) {
                    if (ev.getSource() != button) continue;
                    button.mouseReleased(ev);
                    break;
                }
            }

            public void mouseExited(MouseEvent ev) {
                for (ActionButton button : actions) {
                    if (ev.getSource() != button) continue;
                    button.mouseExited(ev);
                    break;
                }
            }

            public void mouseEntered(MouseEvent ev) {
                for (ActionButton button : actions) {
                    if (ev.getSource() == button) {
                        button.mouseEntered(ev);
                        continue;
                    }
                    button.mouseExited(ev);
                }
            }
        };
        for (ActionButton button : actions) {
            button.addActionListener(actionListener);
            button.addMouseListener(mouseListener);
        }
    }

    @Override
    public Message getTitle() {
        return null;
    }

    @Override
    public void configurationChanged(ConfigurationChangeEvent ev) {
    }

    @Override
    public void okClicked() {
    }
}

