/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.admin;

import java.util.EnumSet;
import org.opends.server.admin.AbstractManagedObjectDefinition;
import org.opends.server.admin.AdministratorAction;
import org.opends.server.admin.DefaultBehaviorProvider;
import org.opends.server.admin.IllegalPropertyValueException;
import org.opends.server.admin.IllegalPropertyValueStringException;
import org.opends.server.admin.PropertyDefinition;
import org.opends.server.admin.PropertyDefinitionVisitor;
import org.opends.server.admin.PropertyOption;
import org.opends.server.admin.PropertyValueVisitor;
import org.opends.server.authorization.dseecompat.Aci;
import org.opends.server.authorization.dseecompat.AciException;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.types.DN;
import org.opends.server.util.Validator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ACIPropertyDefinition
extends PropertyDefinition<Aci> {
    public static Builder createBuilder(AbstractManagedObjectDefinition<?, ?> d, String propertyName) {
        return new Builder(d, propertyName);
    }

    private ACIPropertyDefinition(AbstractManagedObjectDefinition<?, ?> d, String propertyName, EnumSet<PropertyOption> options, AdministratorAction adminAction, DefaultBehaviorProvider<Aci> defaultBehavior) {
        super(d, Aci.class, propertyName, options, adminAction, defaultBehavior);
    }

    @Override
    public void validateValue(Aci value) throws IllegalPropertyValueException {
        Validator.ensureNotNull(value);
    }

    @Override
    public Aci decodeValue(String value) throws IllegalPropertyValueStringException {
        Validator.ensureNotNull(value);
        try {
            return Aci.decode(new ASN1OctetString(value), DN.NULL_DN);
        }
        catch (AciException e) {
            throw new IllegalPropertyValueStringException(this, value);
        }
    }

    @Override
    public <R, P> R accept(PropertyDefinitionVisitor<R, P> v, P p) {
        return v.visitACI(this, p);
    }

    @Override
    public <R, P> R accept(PropertyValueVisitor<R, P> v, Aci value, P p) {
        return v.visitACI(this, value, p);
    }

    @Override
    public int compare(Aci o1, Aci o2) {
        return o1.toString().compareTo(o2.toString());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Builder
    extends PropertyDefinition.AbstractBuilder<Aci, ACIPropertyDefinition> {
        private Builder(AbstractManagedObjectDefinition<?, ?> d, String propertyName) {
            super(d, propertyName);
        }

        @Override
        protected ACIPropertyDefinition buildInstance(AbstractManagedObjectDefinition<?, ?> d, String propertyName, EnumSet<PropertyOption> options, AdministratorAction adminAction, DefaultBehaviorProvider<Aci> defaultBehavior) {
            return new ACIPropertyDefinition(d, propertyName, options, adminAction, defaultBehavior);
        }
    }
}

