/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.admin.std.meta;

import java.util.Collection;
import java.util.SortedSet;
import java.util.TreeSet;
import org.opends.server.admin.AdministratorAction;
import org.opends.server.admin.AggregationPropertyDefinition;
import org.opends.server.admin.BooleanPropertyDefinition;
import org.opends.server.admin.Configuration;
import org.opends.server.admin.ConfigurationClient;
import org.opends.server.admin.DefaultBehaviorException;
import org.opends.server.admin.DefinitionDecodingException;
import org.opends.server.admin.IntegerPropertyDefinition;
import org.opends.server.admin.ManagedObjectAlreadyExistsException;
import org.opends.server.admin.ManagedObjectDefinition;
import org.opends.server.admin.ManagedObjectNotFoundException;
import org.opends.server.admin.OptionalRelationDefinition;
import org.opends.server.admin.PropertyDefinition;
import org.opends.server.admin.PropertyIsReadOnlyException;
import org.opends.server.admin.PropertyOption;
import org.opends.server.admin.PropertyProvider;
import org.opends.server.admin.StringPropertyDefinition;
import org.opends.server.admin.Tag;
import org.opends.server.admin.TopCfgDefn;
import org.opends.server.admin.UndefinedDefaultBehaviorProvider;
import org.opends.server.admin.client.AuthorizationException;
import org.opends.server.admin.client.CommunicationException;
import org.opends.server.admin.client.ConcurrentModificationException;
import org.opends.server.admin.client.ManagedObject;
import org.opends.server.admin.client.ManagedObjectDecodingException;
import org.opends.server.admin.client.MissingMandatoryPropertiesException;
import org.opends.server.admin.client.OperationRejectedException;
import org.opends.server.admin.condition.Conditions;
import org.opends.server.admin.server.ConfigurationAddListener;
import org.opends.server.admin.server.ConfigurationChangeListener;
import org.opends.server.admin.server.ConfigurationDeleteListener;
import org.opends.server.admin.server.ServerManagedObject;
import org.opends.server.admin.std.client.NetworkGroupCfgClient;
import org.opends.server.admin.std.client.NetworkGroupCriteriaCfgClient;
import org.opends.server.admin.std.client.NetworkGroupRequestFilteringPolicyCfgClient;
import org.opends.server.admin.std.client.NetworkGroupResourceLimitsCfgClient;
import org.opends.server.admin.std.client.WorkflowCfgClient;
import org.opends.server.admin.std.meta.NetworkGroupCriteriaCfgDefn;
import org.opends.server.admin.std.meta.NetworkGroupRequestFilteringPolicyCfgDefn;
import org.opends.server.admin.std.meta.NetworkGroupResourceLimitsCfgDefn;
import org.opends.server.admin.std.server.NetworkGroupCfg;
import org.opends.server.admin.std.server.NetworkGroupCriteriaCfg;
import org.opends.server.admin.std.server.NetworkGroupRequestFilteringPolicyCfg;
import org.opends.server.admin.std.server.NetworkGroupResourceLimitsCfg;
import org.opends.server.admin.std.server.WorkflowCfg;
import org.opends.server.config.ConfigException;
import org.opends.server.types.DN;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class NetworkGroupCfgDefn
extends ManagedObjectDefinition<NetworkGroupCfgClient, NetworkGroupCfg> {
    private static final NetworkGroupCfgDefn INSTANCE = new NetworkGroupCfgDefn();
    private static final BooleanPropertyDefinition PD_ENABLED;
    private static final StringPropertyDefinition PD_NETWORK_GROUP_ID;
    private static final IntegerPropertyDefinition PD_PRIORITY;
    private static final AggregationPropertyDefinition<WorkflowCfgClient, WorkflowCfg> PD_WORKFLOW;
    private static final OptionalRelationDefinition<NetworkGroupCriteriaCfgClient, NetworkGroupCriteriaCfg> RD_NETWORK_GROUP_CRITERIA;
    private static final OptionalRelationDefinition<NetworkGroupRequestFilteringPolicyCfgClient, NetworkGroupRequestFilteringPolicyCfg> RD_NETWORK_GROUP_REQUEST_FILTERING_POLICY;
    private static final OptionalRelationDefinition<NetworkGroupResourceLimitsCfgClient, NetworkGroupResourceLimitsCfg> RD_NETWORK_GROUP_RESOURCE_LIMITS;

    public static NetworkGroupCfgDefn getInstance() {
        return INSTANCE;
    }

    private NetworkGroupCfgDefn() {
        super("network-group", TopCfgDefn.getInstance());
    }

    @Override
    public NetworkGroupCfgClient createClientConfiguration(ManagedObject<? extends NetworkGroupCfgClient> impl) {
        return new NetworkGroupCfgClientImpl(impl);
    }

    @Override
    public NetworkGroupCfg createServerConfiguration(ServerManagedObject<? extends NetworkGroupCfg> impl) {
        return new NetworkGroupCfgServerImpl(impl);
    }

    @Override
    public Class<NetworkGroupCfg> getServerConfigurationClass() {
        return NetworkGroupCfg.class;
    }

    public BooleanPropertyDefinition getEnabledPropertyDefinition() {
        return PD_ENABLED;
    }

    public StringPropertyDefinition getNetworkGroupIdPropertyDefinition() {
        return PD_NETWORK_GROUP_ID;
    }

    public IntegerPropertyDefinition getPriorityPropertyDefinition() {
        return PD_PRIORITY;
    }

    public AggregationPropertyDefinition<WorkflowCfgClient, WorkflowCfg> getWorkflowPropertyDefinition() {
        return PD_WORKFLOW;
    }

    public OptionalRelationDefinition<NetworkGroupCriteriaCfgClient, NetworkGroupCriteriaCfg> getNetworkGroupCriteriaRelationDefinition() {
        return RD_NETWORK_GROUP_CRITERIA;
    }

    public OptionalRelationDefinition<NetworkGroupRequestFilteringPolicyCfgClient, NetworkGroupRequestFilteringPolicyCfg> getNetworkGroupRequestFilteringPolicyRelationDefinition() {
        return RD_NETWORK_GROUP_REQUEST_FILTERING_POLICY;
    }

    public OptionalRelationDefinition<NetworkGroupResourceLimitsCfgClient, NetworkGroupResourceLimitsCfg> getNetworkGroupResourceLimitsRelationDefinition() {
        return RD_NETWORK_GROUP_RESOURCE_LIMITS;
    }

    static {
        OptionalRelationDefinition.Builder<ConfigurationClient, Configuration> builder = BooleanPropertyDefinition.createBuilder(INSTANCE, "enabled");
        ((PropertyDefinition.AbstractBuilder)((Object)builder)).setOption(PropertyOption.MANDATORY);
        ((PropertyDefinition.AbstractBuilder)((Object)builder)).setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "enabled"));
        ((PropertyDefinition.AbstractBuilder)((Object)builder)).setDefaultBehaviorProvider(new UndefinedDefaultBehaviorProvider());
        PD_ENABLED = (BooleanPropertyDefinition)((PropertyDefinition.AbstractBuilder)((Object)builder)).getInstance();
        INSTANCE.registerPropertyDefinition(PD_ENABLED);
        builder = StringPropertyDefinition.createBuilder(INSTANCE, "network-group-id");
        ((PropertyDefinition.AbstractBuilder)((Object)builder)).setOption(PropertyOption.READ_ONLY);
        ((PropertyDefinition.AbstractBuilder)((Object)builder)).setOption(PropertyOption.MANDATORY);
        ((PropertyDefinition.AbstractBuilder)((Object)builder)).setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "network-group-id"));
        ((PropertyDefinition.AbstractBuilder)((Object)builder)).setDefaultBehaviorProvider(new UndefinedDefaultBehaviorProvider());
        PD_NETWORK_GROUP_ID = (StringPropertyDefinition)((PropertyDefinition.AbstractBuilder)((Object)builder)).getInstance();
        INSTANCE.registerPropertyDefinition(PD_NETWORK_GROUP_ID);
        builder = IntegerPropertyDefinition.createBuilder(INSTANCE, "priority");
        ((PropertyDefinition.AbstractBuilder)((Object)builder)).setOption(PropertyOption.MANDATORY);
        ((PropertyDefinition.AbstractBuilder)((Object)builder)).setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "priority"));
        ((PropertyDefinition.AbstractBuilder)((Object)builder)).setDefaultBehaviorProvider(new UndefinedDefaultBehaviorProvider());
        ((IntegerPropertyDefinition.Builder)((Object)builder)).setLowerLimit(0);
        PD_PRIORITY = (IntegerPropertyDefinition)((PropertyDefinition.AbstractBuilder)((Object)builder)).getInstance();
        INSTANCE.registerPropertyDefinition(PD_PRIORITY);
        builder = AggregationPropertyDefinition.createBuilder(INSTANCE, "workflow");
        ((PropertyDefinition.AbstractBuilder)((Object)builder)).setOption(PropertyOption.MULTI_VALUED);
        ((PropertyDefinition.AbstractBuilder)((Object)builder)).setAdministratorAction(new AdministratorAction(AdministratorAction.Type.NONE, INSTANCE, "workflow"));
        ((PropertyDefinition.AbstractBuilder)((Object)builder)).setDefaultBehaviorProvider(new UndefinedDefaultBehaviorProvider());
        ((AggregationPropertyDefinition.Builder)((Object)builder)).setParentPath("/");
        ((AggregationPropertyDefinition.Builder)((Object)builder)).setRelationDefinition("workflow");
        ((AggregationPropertyDefinition.Builder)((Object)builder)).setTargetIsEnabledCondition(Conditions.contains("enabled", "true"));
        PD_WORKFLOW = (AggregationPropertyDefinition)((PropertyDefinition.AbstractBuilder)((Object)builder)).getInstance();
        INSTANCE.registerPropertyDefinition(PD_WORKFLOW);
        INSTANCE.registerConstraint(PD_WORKFLOW.getSourceConstraint());
        builder = new OptionalRelationDefinition.Builder<NetworkGroupCriteriaCfgClient, NetworkGroupCriteriaCfg>(INSTANCE, "network-group-criteria", NetworkGroupCriteriaCfgDefn.getInstance());
        RD_NETWORK_GROUP_CRITERIA = (OptionalRelationDefinition)builder.getInstance();
        INSTANCE.registerRelationDefinition(RD_NETWORK_GROUP_CRITERIA);
        builder = new OptionalRelationDefinition.Builder<NetworkGroupRequestFilteringPolicyCfgClient, NetworkGroupRequestFilteringPolicyCfg>(INSTANCE, "network-group-request-filtering-policy", NetworkGroupRequestFilteringPolicyCfgDefn.getInstance());
        RD_NETWORK_GROUP_REQUEST_FILTERING_POLICY = (OptionalRelationDefinition)builder.getInstance();
        INSTANCE.registerRelationDefinition(RD_NETWORK_GROUP_REQUEST_FILTERING_POLICY);
        builder = new OptionalRelationDefinition.Builder<NetworkGroupResourceLimitsCfgClient, NetworkGroupResourceLimitsCfg>(INSTANCE, "network-group-resource-limits", NetworkGroupResourceLimitsCfgDefn.getInstance());
        RD_NETWORK_GROUP_RESOURCE_LIMITS = (OptionalRelationDefinition)builder.getInstance();
        INSTANCE.registerRelationDefinition(RD_NETWORK_GROUP_RESOURCE_LIMITS);
        INSTANCE.registerTag(Tag.valueOf("core-server"));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class NetworkGroupCfgServerImpl
    implements NetworkGroupCfg {
        private ServerManagedObject<? extends NetworkGroupCfg> impl;
        private final boolean pEnabled;
        private final String pNetworkGroupId;
        private final int pPriority;
        private final SortedSet<String> pWorkflow;

        private NetworkGroupCfgServerImpl(ServerManagedObject<? extends NetworkGroupCfg> impl) {
            this.impl = impl;
            this.pEnabled = impl.getPropertyValue(INSTANCE.getEnabledPropertyDefinition());
            this.pNetworkGroupId = impl.getPropertyValue(INSTANCE.getNetworkGroupIdPropertyDefinition());
            this.pPriority = impl.getPropertyValue(INSTANCE.getPriorityPropertyDefinition());
            this.pWorkflow = impl.getPropertyValues(INSTANCE.getWorkflowPropertyDefinition());
        }

        @Override
        public void addChangeListener(ConfigurationChangeListener<NetworkGroupCfg> listener) {
            this.impl.registerChangeListener(listener);
        }

        @Override
        public void removeChangeListener(ConfigurationChangeListener<NetworkGroupCfg> listener) {
            this.impl.deregisterChangeListener(listener);
        }

        @Override
        public boolean isEnabled() {
            return this.pEnabled;
        }

        @Override
        public String getNetworkGroupId() {
            return this.pNetworkGroupId;
        }

        @Override
        public int getPriority() {
            return this.pPriority;
        }

        @Override
        public SortedSet<String> getWorkflow() {
            return this.pWorkflow;
        }

        @Override
        public SortedSet<DN> getWorkflowDNs() {
            SortedSet<String> values = this.getWorkflow();
            TreeSet<DN> dnValues = new TreeSet<DN>();
            for (String value : values) {
                DN dn = INSTANCE.getWorkflowPropertyDefinition().getChildDN(value);
                dnValues.add(dn);
            }
            return dnValues;
        }

        @Override
        public boolean hasNetworkGroupCriteria() {
            return this.impl.hasChild(INSTANCE.getNetworkGroupCriteriaRelationDefinition());
        }

        @Override
        public NetworkGroupCriteriaCfg getNetworkGroupCriteria() throws ConfigException {
            return this.impl.getChild(INSTANCE.getNetworkGroupCriteriaRelationDefinition()).getConfiguration();
        }

        @Override
        public void addNetworkGroupCriteriaAddListener(ConfigurationAddListener<NetworkGroupCriteriaCfg> listener) throws ConfigException {
            this.impl.registerAddListener(INSTANCE.getNetworkGroupCriteriaRelationDefinition(), listener);
        }

        @Override
        public void removeNetworkGroupCriteriaAddListener(ConfigurationAddListener<NetworkGroupCriteriaCfg> listener) {
            this.impl.deregisterAddListener(INSTANCE.getNetworkGroupCriteriaRelationDefinition(), listener);
        }

        @Override
        public void addNetworkGroupCriteriaDeleteListener(ConfigurationDeleteListener<NetworkGroupCriteriaCfg> listener) throws ConfigException {
            this.impl.registerDeleteListener(INSTANCE.getNetworkGroupCriteriaRelationDefinition(), listener);
        }

        @Override
        public void removeNetworkGroupCriteriaDeleteListener(ConfigurationDeleteListener<NetworkGroupCriteriaCfg> listener) {
            this.impl.deregisterDeleteListener(INSTANCE.getNetworkGroupCriteriaRelationDefinition(), listener);
        }

        @Override
        public boolean hasNetworkGroupRequestFilteringPolicy() {
            return this.impl.hasChild(INSTANCE.getNetworkGroupRequestFilteringPolicyRelationDefinition());
        }

        @Override
        public NetworkGroupRequestFilteringPolicyCfg getNetworkGroupRequestFilteringPolicy() throws ConfigException {
            return this.impl.getChild(INSTANCE.getNetworkGroupRequestFilteringPolicyRelationDefinition()).getConfiguration();
        }

        @Override
        public void addNetworkGroupRequestFilteringPolicyAddListener(ConfigurationAddListener<NetworkGroupRequestFilteringPolicyCfg> listener) throws ConfigException {
            this.impl.registerAddListener(INSTANCE.getNetworkGroupRequestFilteringPolicyRelationDefinition(), listener);
        }

        @Override
        public void removeNetworkGroupRequestFilteringPolicyAddListener(ConfigurationAddListener<NetworkGroupRequestFilteringPolicyCfg> listener) {
            this.impl.deregisterAddListener(INSTANCE.getNetworkGroupRequestFilteringPolicyRelationDefinition(), listener);
        }

        @Override
        public void addNetworkGroupRequestFilteringPolicyDeleteListener(ConfigurationDeleteListener<NetworkGroupRequestFilteringPolicyCfg> listener) throws ConfigException {
            this.impl.registerDeleteListener(INSTANCE.getNetworkGroupRequestFilteringPolicyRelationDefinition(), listener);
        }

        @Override
        public void removeNetworkGroupRequestFilteringPolicyDeleteListener(ConfigurationDeleteListener<NetworkGroupRequestFilteringPolicyCfg> listener) {
            this.impl.deregisterDeleteListener(INSTANCE.getNetworkGroupRequestFilteringPolicyRelationDefinition(), listener);
        }

        @Override
        public boolean hasNetworkGroupResourceLimits() {
            return this.impl.hasChild(INSTANCE.getNetworkGroupResourceLimitsRelationDefinition());
        }

        @Override
        public NetworkGroupResourceLimitsCfg getNetworkGroupResourceLimits() throws ConfigException {
            return this.impl.getChild(INSTANCE.getNetworkGroupResourceLimitsRelationDefinition()).getConfiguration();
        }

        @Override
        public void addNetworkGroupResourceLimitsAddListener(ConfigurationAddListener<NetworkGroupResourceLimitsCfg> listener) throws ConfigException {
            this.impl.registerAddListener(INSTANCE.getNetworkGroupResourceLimitsRelationDefinition(), listener);
        }

        @Override
        public void removeNetworkGroupResourceLimitsAddListener(ConfigurationAddListener<NetworkGroupResourceLimitsCfg> listener) {
            this.impl.deregisterAddListener(INSTANCE.getNetworkGroupResourceLimitsRelationDefinition(), listener);
        }

        @Override
        public void addNetworkGroupResourceLimitsDeleteListener(ConfigurationDeleteListener<NetworkGroupResourceLimitsCfg> listener) throws ConfigException {
            this.impl.registerDeleteListener(INSTANCE.getNetworkGroupResourceLimitsRelationDefinition(), listener);
        }

        @Override
        public void removeNetworkGroupResourceLimitsDeleteListener(ConfigurationDeleteListener<NetworkGroupResourceLimitsCfg> listener) {
            this.impl.deregisterDeleteListener(INSTANCE.getNetworkGroupResourceLimitsRelationDefinition(), listener);
        }

        @Override
        public Class<? extends NetworkGroupCfg> configurationClass() {
            return NetworkGroupCfg.class;
        }

        @Override
        public DN dn() {
            return this.impl.getDN();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class NetworkGroupCfgClientImpl
    implements NetworkGroupCfgClient {
        private ManagedObject<? extends NetworkGroupCfgClient> impl;

        private NetworkGroupCfgClientImpl(ManagedObject<? extends NetworkGroupCfgClient> impl) {
            this.impl = impl;
        }

        @Override
        public Boolean isEnabled() {
            return this.impl.getPropertyValue(INSTANCE.getEnabledPropertyDefinition());
        }

        @Override
        public void setEnabled(boolean value) {
            this.impl.setPropertyValue(INSTANCE.getEnabledPropertyDefinition(), value);
        }

        @Override
        public String getNetworkGroupId() {
            return this.impl.getPropertyValue(INSTANCE.getNetworkGroupIdPropertyDefinition());
        }

        @Override
        public void setNetworkGroupId(String value) throws PropertyIsReadOnlyException {
            this.impl.setPropertyValue(INSTANCE.getNetworkGroupIdPropertyDefinition(), value);
        }

        @Override
        public Integer getPriority() {
            return this.impl.getPropertyValue(INSTANCE.getPriorityPropertyDefinition());
        }

        @Override
        public void setPriority(int value) {
            this.impl.setPropertyValue(INSTANCE.getPriorityPropertyDefinition(), value);
        }

        @Override
        public SortedSet<String> getWorkflow() {
            return this.impl.getPropertyValues(INSTANCE.getWorkflowPropertyDefinition());
        }

        @Override
        public void setWorkflow(Collection<String> values) {
            this.impl.setPropertyValues(INSTANCE.getWorkflowPropertyDefinition(), values);
        }

        @Override
        public boolean hasNetworkGroupCriteria() throws ConcurrentModificationException, AuthorizationException, CommunicationException {
            return this.impl.hasChild(INSTANCE.getNetworkGroupCriteriaRelationDefinition());
        }

        @Override
        public NetworkGroupCriteriaCfgClient getNetworkGroupCriteria() throws DefinitionDecodingException, ManagedObjectDecodingException, ManagedObjectNotFoundException, ConcurrentModificationException, AuthorizationException, CommunicationException {
            return this.impl.getChild(INSTANCE.getNetworkGroupCriteriaRelationDefinition()).getConfiguration();
        }

        public <M extends NetworkGroupCriteriaCfgClient> M createNetworkGroupCriteria(ManagedObjectDefinition<M, ? extends NetworkGroupCriteriaCfg> d, Collection<DefaultBehaviorException> exceptions) {
            return (M)((NetworkGroupCriteriaCfgClient)this.impl.createChild(INSTANCE.getNetworkGroupCriteriaRelationDefinition(), d, exceptions).getConfiguration());
        }

        @Override
        public void removeNetworkGroupCriteria() throws ManagedObjectNotFoundException, ConcurrentModificationException, OperationRejectedException, AuthorizationException, CommunicationException {
            this.impl.removeChild(INSTANCE.getNetworkGroupCriteriaRelationDefinition());
        }

        @Override
        public boolean hasNetworkGroupRequestFilteringPolicy() throws ConcurrentModificationException, AuthorizationException, CommunicationException {
            return this.impl.hasChild(INSTANCE.getNetworkGroupRequestFilteringPolicyRelationDefinition());
        }

        @Override
        public NetworkGroupRequestFilteringPolicyCfgClient getNetworkGroupRequestFilteringPolicy() throws DefinitionDecodingException, ManagedObjectDecodingException, ManagedObjectNotFoundException, ConcurrentModificationException, AuthorizationException, CommunicationException {
            return this.impl.getChild(INSTANCE.getNetworkGroupRequestFilteringPolicyRelationDefinition()).getConfiguration();
        }

        public <M extends NetworkGroupRequestFilteringPolicyCfgClient> M createNetworkGroupRequestFilteringPolicy(ManagedObjectDefinition<M, ? extends NetworkGroupRequestFilteringPolicyCfg> d, Collection<DefaultBehaviorException> exceptions) {
            return (M)((NetworkGroupRequestFilteringPolicyCfgClient)this.impl.createChild(INSTANCE.getNetworkGroupRequestFilteringPolicyRelationDefinition(), d, exceptions).getConfiguration());
        }

        @Override
        public void removeNetworkGroupRequestFilteringPolicy() throws ManagedObjectNotFoundException, ConcurrentModificationException, OperationRejectedException, AuthorizationException, CommunicationException {
            this.impl.removeChild(INSTANCE.getNetworkGroupRequestFilteringPolicyRelationDefinition());
        }

        @Override
        public boolean hasNetworkGroupResourceLimits() throws ConcurrentModificationException, AuthorizationException, CommunicationException {
            return this.impl.hasChild(INSTANCE.getNetworkGroupResourceLimitsRelationDefinition());
        }

        @Override
        public NetworkGroupResourceLimitsCfgClient getNetworkGroupResourceLimits() throws DefinitionDecodingException, ManagedObjectDecodingException, ManagedObjectNotFoundException, ConcurrentModificationException, AuthorizationException, CommunicationException {
            return this.impl.getChild(INSTANCE.getNetworkGroupResourceLimitsRelationDefinition()).getConfiguration();
        }

        public <M extends NetworkGroupResourceLimitsCfgClient> M createNetworkGroupResourceLimits(ManagedObjectDefinition<M, ? extends NetworkGroupResourceLimitsCfg> d, Collection<DefaultBehaviorException> exceptions) {
            return (M)((NetworkGroupResourceLimitsCfgClient)this.impl.createChild(INSTANCE.getNetworkGroupResourceLimitsRelationDefinition(), d, exceptions).getConfiguration());
        }

        @Override
        public void removeNetworkGroupResourceLimits() throws ManagedObjectNotFoundException, ConcurrentModificationException, OperationRejectedException, AuthorizationException, CommunicationException {
            this.impl.removeChild(INSTANCE.getNetworkGroupResourceLimitsRelationDefinition());
        }

        @Override
        public ManagedObjectDefinition<? extends NetworkGroupCfgClient, ? extends NetworkGroupCfg> definition() {
            return INSTANCE;
        }

        @Override
        public PropertyProvider properties() {
            return this.impl;
        }

        @Override
        public void commit() throws ManagedObjectAlreadyExistsException, MissingMandatoryPropertiesException, ConcurrentModificationException, OperationRejectedException, AuthorizationException, CommunicationException {
            this.impl.commit();
        }
    }
}

