/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.authorization.dseecompat;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import org.opends.messages.AccessControlMessages;
import org.opends.messages.Message;
import org.opends.server.api.Backend;
import org.opends.server.authorization.dseecompat.Aci;
import org.opends.server.authorization.dseecompat.AciException;
import org.opends.server.authorization.dseecompat.AciHandler;
import org.opends.server.authorization.dseecompat.AciTargets;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.types.Attribute;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.ByteStringFactory;
import org.opends.server.types.DN;
import org.opends.server.types.Entry;
import org.opends.server.types.RDN;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AciList {
    private volatile LinkedHashMap<DN, List<Aci>> aciList = new LinkedHashMap();
    private DN configDN;

    public AciList(DN configDN) {
        this.configDN = configDN;
    }

    private LinkedHashMap<DN, List<Aci>> getList() {
        return this.aciList;
    }

    private LinkedHashMap<DN, List<Aci>> copyList() {
        return new LinkedHashMap<DN, List<Aci>>(this.aciList);
    }

    public LinkedList<Aci> getCandidateAcis(DN baseDN) {
        LinkedList<Aci> candidates = new LinkedList<Aci>();
        if (baseDN == null) {
            return candidates;
        }
        LinkedHashMap<DN, List<Aci>> aciList = this.getList();
        DN entryDN = baseDN;
        while (baseDN != null) {
            List<Aci> acis = aciList.get(baseDN);
            if (acis != null) {
                if (baseDN.isNullDN()) {
                    for (Aci aci : acis) {
                        boolean ret;
                        AciTargets targets = aci.getTargets();
                        if (targets == null || !(ret = AciTargets.isTargetApplicable(aci, targets, entryDN))) continue;
                        candidates.add(aci);
                    }
                } else {
                    candidates.addAll(acis);
                }
            }
            if (baseDN.isNullDN()) break;
            DN parentDN = baseDN.getParent();
            if (parentDN == null) {
                baseDN = DN.nullDN();
                continue;
            }
            baseDN = parentDN;
        }
        return candidates;
    }

    public synchronized int addAci(List<? extends Entry> entries, LinkedList<Message> failedACIMsgs) {
        LinkedHashMap<DN, List<Aci>> aciCopy = this.copyList();
        int validAcis = 0;
        for (Entry entry : entries) {
            DN dn = entry.getDN();
            List<Attribute> attributeList = entry.getOperationalAttribute(AciHandler.aciType);
            validAcis += AciList.addAciAttributeList(aciCopy, dn, this.configDN, attributeList, failedACIMsgs);
        }
        this.aciList = aciCopy;
        return validAcis;
    }

    public synchronized void addAci(DN dn, SortedSet<Aci> acis) {
        this.aciList.put(dn, new LinkedList<Aci>(acis));
    }

    public synchronized int addAci(Entry entry, boolean hasAci, boolean hasGlobalAci, LinkedList<Message> failedACIMsgs) {
        List<Attribute> attributeList;
        int validAcis = 0;
        LinkedHashMap<DN, List<Aci>> aciCopy = this.copyList();
        if (hasGlobalAci && entry.getDN().equals(this.configDN)) {
            attributeList = entry.getAttribute(AciHandler.globalAciType);
            validAcis = AciList.addAciAttributeList(aciCopy, DN.nullDN(), this.configDN, attributeList, failedACIMsgs);
        }
        if (hasAci) {
            attributeList = entry.getAttribute(AciHandler.aciType);
            validAcis += AciList.addAciAttributeList(aciCopy, entry.getDN(), this.configDN, attributeList, failedACIMsgs);
        }
        this.aciList = aciCopy;
        return validAcis;
    }

    private static int addAciAttributeList(LinkedHashMap<DN, List<Aci>> aciList, DN dn, DN configDN, List<Attribute> attributeList, LinkedList<Message> failedACIMsgs) {
        if (attributeList == null) {
            return 0;
        }
        int validAcis = 0;
        ArrayList<Aci> acis = new ArrayList<Aci>();
        for (Attribute attribute : attributeList) {
            for (AttributeValue value : attribute) {
                try {
                    Aci aci = Aci.decode(value.getValue(), dn);
                    acis.add(aci);
                    ++validAcis;
                }
                catch (AciException ex) {
                    DN msgDN = dn;
                    if (dn == DN.nullDN()) {
                        msgDN = configDN;
                    }
                    Message message = AccessControlMessages.WARN_ACI_ADD_LIST_FAILED_DECODE.get(((Object)value.getValue()).toString(), String.valueOf(msgDN), ex.getMessage());
                    failedACIMsgs.add(message);
                }
            }
        }
        AciList.addAci(aciList, dn, acis);
        return validAcis;
    }

    public synchronized void modAciOldNewEntry(Entry oldEntry, Entry newEntry, boolean hasAci, boolean hasGlobalAci) {
        List<Attribute> attributeList;
        LinkedHashMap<DN, List<Aci>> aciCopy = this.copyList();
        LinkedList<Message> failedACIMsgs = new LinkedList<Message>();
        if (hasAci) {
            aciCopy.remove(oldEntry.getDN());
            attributeList = newEntry.getOperationalAttribute(AciHandler.aciType);
            AciList.addAciAttributeList(aciCopy, newEntry.getDN(), this.configDN, attributeList, failedACIMsgs);
        }
        if (hasGlobalAci && oldEntry.getDN().equals(this.configDN)) {
            aciCopy.remove(DN.nullDN());
            attributeList = newEntry.getAttribute(AciHandler.globalAciType);
            AciList.addAciAttributeList(aciCopy, DN.nullDN(), this.configDN, attributeList, failedACIMsgs);
        }
        this.aciList = aciCopy;
    }

    private static void addAci(LinkedHashMap<DN, List<Aci>> aciList, DN dn, List<Aci> acis) {
        if (aciList.containsKey(dn)) {
            List<Aci> tmpAci = aciList.get(dn);
            tmpAci.addAll(acis);
        } else {
            aciList.put(dn, acis);
        }
    }

    public synchronized boolean removeAci(Entry entry, boolean hasAci, boolean hasGlobalAci) {
        LinkedHashMap<DN, List<Aci>> aciCopy = this.copyList();
        if (hasGlobalAci && entry.getDN().equals(this.configDN) && aciCopy.remove(DN.nullDN()) == null) {
            return false;
        }
        if (hasAci && aciCopy.remove(entry.getDN()) == null) {
            return false;
        }
        this.aciList = aciCopy;
        return true;
    }

    public synchronized void removeAci(Backend backend) {
        LinkedHashMap<DN, List<Aci>> aciCopy = this.copyList();
        Iterator<Map.Entry<DN, List<Aci>>> iterator = aciCopy.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<DN, List<Aci>> mapEntry = iterator.next();
            if (!backend.handlesEntry(mapEntry.getKey())) continue;
            iterator.remove();
        }
        this.aciList = aciCopy;
    }

    public synchronized void renameAci(DN oldDN, DN newDN) {
        LinkedHashMap<DN, List<Object>> newCopyList = new LinkedHashMap<DN, List<Object>>();
        int oldRDNCount = oldDN.getNumComponents();
        int newRDNCount = newDN.getNumComponents();
        for (Map.Entry<DN, List<Aci>> hashEntry : this.aciList.entrySet()) {
            if (hashEntry.getKey().isDescendantOf(oldDN)) {
                int i;
                int keyRDNCount = hashEntry.getKey().getNumComponents();
                int keepRDNCount = keyRDNCount - oldRDNCount;
                RDN[] newRDNs = new RDN[keepRDNCount + newRDNCount];
                for (i = 0; i < keepRDNCount; ++i) {
                    newRDNs[i] = hashEntry.getKey().getRDN(i);
                }
                i = keepRDNCount;
                for (int j = 0; j < newRDNCount; ++j) {
                    newRDNs[i] = newDN.getRDN(j);
                    ++i;
                }
                DN relocateDN = new DN(newRDNs);
                LinkedList<Aci> acis = new LinkedList<Aci>();
                for (Aci aci : hashEntry.getValue()) {
                    try {
                        Aci newAci = Aci.decode(ByteStringFactory.create(aci.toString()), relocateDN);
                        acis.add(newAci);
                    }
                    catch (AciException ex) {
                        Message message = AccessControlMessages.WARN_ACI_ADD_LIST_FAILED_DECODE.get(aci.toString(), String.valueOf(relocateDN), ex.getMessage());
                        ErrorLogger.logError(message);
                    }
                }
                newCopyList.put(relocateDN, acis);
                continue;
            }
            newCopyList.put(hashEntry.getKey(), hashEntry.getValue());
        }
        this.aciList = newCopyList;
    }
}

