/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.authorization.dseecompat;

import java.util.LinkedHashSet;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.opends.messages.AccessControlMessages;
import org.opends.messages.Message;
import org.opends.server.authorization.dseecompat.AciException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.types.AttributeType;
import org.opends.server.types.DN;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.LDAPURL;

public class ParentInheritance {
    private static final int MAX_LEVELS = 10;
    private final String parentPat = "parent[";
    private final int[] levels = new int[10];
    private int numLevels;
    private String attrTypeStr;
    private DN baseDN = null;

    ParentInheritance(String pattern, boolean skipParse) throws AciException {
        if (skipParse) {
            if (pattern.startsWith("parent[")) {
                Message message = AccessControlMessages.WARN_ACI_SYNTAX_INVALID_USERATTR_ROLEDN_INHERITANCE_PATTERN.get(pattern);
                throw new AciException(message);
            }
            pattern = pattern.trim();
            Pattern pattern1 = Pattern.compile("((?i)[a-z\\d]{1}[[a-z]\\d-_.;]*(?-i)|\\*{1}|\\+{1})");
            Matcher matcher = pattern1.matcher(pattern);
            if (!matcher.find() || matcher.groupCount() != 1) {
                Message message = AccessControlMessages.WARN_ACI_SYNTAX_INVALID_ATTRIBUTE_TYPE_NAME.get(pattern);
                throw new AciException(message);
            }
            this.numLevels = 1;
            this.levels[0] = 0;
        } else {
            this.parse(pattern);
        }
    }

    private void parse(String pattern) throws AciException {
        if ((pattern = pattern.trim()).startsWith("parent[")) {
            this.numLevels = 0;
            this.levels[0] = 0;
            String p = pattern.substring("parent[".length());
            String[] toks = p.split("\\.");
            if (toks.length != 2) {
                Message message = AccessControlMessages.WARN_ACI_SYNTAX_INVALID_USERATTR_INHERITANCE_PATTERN.get(pattern);
                throw new AciException(message);
            }
            Pattern pattern1 = Pattern.compile("((?i)[a-z\\d]{1}[[a-z]\\d-_.;]*(?-i)|\\*{1}|\\+{1})");
            Matcher matcher = pattern1.matcher(toks[1]);
            if (!matcher.find() || matcher.groupCount() != 1) {
                Message message = AccessControlMessages.WARN_ACI_SYNTAX_INVALID_ATTRIBUTE_TYPE_NAME.get(toks[1]);
                throw new AciException(message);
            }
            this.attrTypeStr = toks[1];
            StringTokenizer tok = new StringTokenizer(toks[0], "],", false);
            while (tok.hasMoreTokens()) {
                String v = tok.nextToken();
                try {
                    if (this.numLevels < 10) {
                        this.levels[this.numLevels++] = Integer.decode(v);
                        continue;
                    }
                    Message message = AccessControlMessages.WARN_ACI_SYNTAX_MAX_USERATTR_INHERITANCE_LEVEL_EXCEEDED.get(pattern, Integer.toString(10));
                    throw new AciException(message);
                }
                catch (NumberFormatException ex) {
                    Message message = AccessControlMessages.WARN_ACI_SYNTAX_INVALID_INHERITANCE_VALUE.get(pattern);
                    throw new AciException(message);
                }
            }
        } else {
            this.attrTypeStr = pattern;
            if (pattern.startsWith("ldap:///")) {
                try {
                    LDAPURL url = LDAPURL.decode(pattern, true);
                    LinkedHashSet<String> attrs = url.getAttributes();
                    if (attrs.size() != 1) {
                        Message message = AccessControlMessages.WARN_ACI_SYNTAX_INVALID_USERATTR_ATTR_URL.get(pattern);
                        throw new AciException(message);
                    }
                    this.baseDN = url.getBaseDN();
                    if (this.baseDN.isNullDN()) {
                        Message message = AccessControlMessages.WARN_ACI_SYNTAX_INVALID_USERATTR_BASEDN_URL.get(pattern);
                        throw new AciException(message);
                    }
                    this.attrTypeStr = (String)attrs.iterator().next();
                }
                catch (DirectoryException ex) {
                    Message message = AccessControlMessages.WARN_ACI_SYNTAX_INVALID_USERATTR_URL.get(ex.getMessageObject());
                    throw new AciException(message);
                }
            }
            this.numLevels = 1;
            this.levels[0] = 0;
        }
    }

    public int getNumLevels() {
        return this.numLevels;
    }

    public int[] getLevels() {
        int[] levelsCopy = new int[this.levels.length];
        System.arraycopy(this.levels, 0, levelsCopy, 0, this.levels.length);
        return levelsCopy;
    }

    public AttributeType getAttributeType() {
        AttributeType attrType = DirectoryServer.getAttributeType(this.attrTypeStr.toLowerCase());
        if (attrType == null) {
            attrType = DirectoryServer.getDefaultAttributeType(this.attrTypeStr.toLowerCase());
        }
        return attrType;
    }

    public String getAttrTypeStr() {
        return this.attrTypeStr;
    }

    public DN getBaseDN() {
        return this.baseDN;
    }
}

