/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.backends;

import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.opends.messages.BackendMessages;
import org.opends.messages.Message;
import org.opends.server.admin.Configuration;
import org.opends.server.admin.server.ConfigurationChangeListener;
import org.opends.server.admin.std.server.LDIFBackendCfg;
import org.opends.server.api.AlertGenerator;
import org.opends.server.api.Backend;
import org.opends.server.config.ConfigException;
import org.opends.server.core.AddOperation;
import org.opends.server.core.DeleteOperation;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.ModifyDNOperation;
import org.opends.server.core.ModifyOperation;
import org.opends.server.core.SearchOperation;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.types.AttributeType;
import org.opends.server.types.BackupConfig;
import org.opends.server.types.BackupDirectory;
import org.opends.server.types.ConditionResult;
import org.opends.server.types.ConfigChangeResult;
import org.opends.server.types.Control;
import org.opends.server.types.DN;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.Entry;
import org.opends.server.types.ExistingFileBehavior;
import org.opends.server.types.IndexType;
import org.opends.server.types.InitializationException;
import org.opends.server.types.LDIFExportConfig;
import org.opends.server.types.LDIFImportConfig;
import org.opends.server.types.LDIFImportResult;
import org.opends.server.types.RestoreConfig;
import org.opends.server.types.ResultCode;
import org.opends.server.types.SearchFilter;
import org.opends.server.types.SearchScope;
import org.opends.server.util.LDIFWriter;
import org.opends.server.util.StaticUtils;
import org.opends.server.util.Validator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LDIFBackend
extends Backend
implements ConfigurationChangeListener<LDIFBackendCfg>,
AlertGenerator {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private DN[] baseDNs;
    private HashMap<DN, HashSet<DN>> childDNs;
    private HashSet<DN> baseDNSet;
    private HashSet<String> supportedControls;
    private HashSet<String> supportedFeatures;
    private LDIFBackendCfg currentConfig;
    private LinkedHashMap<DN, Entry> entryMap = new LinkedHashMap();
    private ReentrantReadWriteLock backendLock;
    private String ldifFilePath;

    public LDIFBackend() {
        this.childDNs = new HashMap();
        boolean useFairLocking = DirectoryServer.getEnvironmentConfig().getLockManagerFairOrdering();
        this.backendLock = new ReentrantReadWriteLock(useFairLocking);
    }

    @Override
    public void initializeBackend() throws ConfigException, InitializationException {
        if (this.baseDNs == null || this.baseDNs.length != 1) {
            Message message = BackendMessages.ERR_LDIF_BACKEND_MULTIPLE_BASE_DNS.get(this.currentConfig.dn().toString());
            throw new ConfigException(message);
        }
        for (DN dn : this.baseDNs) {
            try {
                DirectoryServer.registerBaseDN(dn, this, this.currentConfig.isIsPrivateBackend());
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                Message message = BackendMessages.ERR_BACKEND_CANNOT_REGISTER_BASEDN.get(dn.toString(), StaticUtils.getExceptionMessage(e));
                throw new InitializationException(message, (Throwable)e);
            }
        }
        DirectoryServer.registerAlertGenerator(this);
        this.readLDIF();
    }

    private void readLDIF() throws InitializationException {
        File ldifFile = StaticUtils.getFileForPath(this.ldifFilePath);
        if (!ldifFile.exists()) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugInfo("LDIF backend starting empty because LDIF file " + this.ldifFilePath + " does not exist");
            }
            this.entryMap.clear();
            this.childDNs.clear();
            return;
        }
        try {
            this.importLDIF(new LDIFImportConfig(ldifFile.getAbsolutePath()), false);
        }
        catch (DirectoryException de) {
            throw new InitializationException(de.getMessageObject(), (Throwable)de);
        }
    }

    private void writeLDIF() throws DirectoryException {
        File tempFile;
        File ldifFile;
        block20: {
            LDIFWriter writer;
            ldifFile = StaticUtils.getFileForPath(this.ldifFilePath);
            tempFile = new File(ldifFile.getAbsolutePath() + ".new");
            File oldFile = new File(ldifFile.getAbsolutePath() + ".old");
            try {
                LDIFExportConfig exportConfig = new LDIFExportConfig(tempFile.getAbsolutePath(), ExistingFileBehavior.OVERWRITE);
                writer = new LDIFWriter(exportConfig);
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                Message m = BackendMessages.ERR_LDIF_BACKEND_ERROR_CREATING_FILE.get(tempFile.getAbsolutePath(), this.currentConfig.dn().toString(), StaticUtils.stackTraceToSingleLineString(e));
                DirectoryServer.sendAlertNotification(this, "org.opends.server.LDIFBackendCannotWriteUupdate", m);
                throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), m, e);
            }
            for (Entry entry : this.entryMap.values()) {
                try {
                    writer.writeEntry(entry);
                }
                catch (Exception e) {
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugCaught(DebugLogLevel.ERROR, e);
                    }
                    try {
                        writer.close();
                    }
                    catch (Exception e2) {
                        // empty catch block
                    }
                    Message m = BackendMessages.ERR_LDIF_BACKEND_ERROR_WRITING_FILE.get(tempFile.getAbsolutePath(), this.currentConfig.dn().toString(), StaticUtils.stackTraceToSingleLineString(e));
                    DirectoryServer.sendAlertNotification(this, "org.opends.server.LDIFBackendCannotWriteUupdate", m);
                    throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), m, e);
                }
            }
            try {
                writer.close();
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                if (oldFile.exists()) {
                    oldFile.delete();
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                if (ldifFile.exists()) {
                    ldifFile.renameTo(oldFile);
                }
            }
            catch (Exception e) {
                if (!DebugLogger.debugEnabled()) break block20;
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
        }
        try {
            tempFile.renameTo(ldifFile);
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message m = BackendMessages.ERR_LDIF_BACKEND_ERROR_RENAMING_FILE.get(tempFile.getAbsolutePath(), ldifFile.getAbsolutePath(), this.currentConfig.dn().toString(), StaticUtils.stackTraceToSingleLineString(e));
            DirectoryServer.sendAlertNotification(this, "org.opends.server.LDIFBackendCannotWriteUupdate", m);
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), m, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void finalizeBackend() {
        this.backendLock.writeLock().lock();
        try {
            this.currentConfig.removeLDIFChangeListener(this);
            DirectoryServer.deregisterAlertGenerator(this);
            for (DN dn : this.baseDNs) {
                try {
                    DirectoryServer.deregisterBaseDN(dn);
                }
                catch (Exception e) {
                    if (!DebugLogger.debugEnabled()) continue;
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
            }
        }
        finally {
            this.backendLock.writeLock().unlock();
        }
    }

    @Override
    public DN[] getBaseDNs() {
        return this.baseDNs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getEntryCount() {
        this.backendLock.readLock().lock();
        try {
            if (this.entryMap != null) {
                long l = this.entryMap.size();
                return l;
            }
            long l = -1L;
            return l;
        }
        finally {
            this.backendLock.readLock().unlock();
        }
    }

    @Override
    public boolean isLocal() {
        return true;
    }

    @Override
    public boolean isIndexed(AttributeType attributeType, IndexType indexType) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConditionResult hasSubordinates(DN entryDN) throws DirectoryException {
        this.backendLock.readLock().lock();
        try {
            HashSet<DN> childDNSet = this.childDNs.get(entryDN);
            if (childDNSet == null || childDNSet.isEmpty()) {
                if (this.entryMap.containsKey(entryDN)) {
                    ConditionResult conditionResult = ConditionResult.FALSE;
                    return conditionResult;
                }
                Message m = BackendMessages.ERR_LDIF_BACKEND_HAS_SUBORDINATES_NO_SUCH_ENTRY.get(String.valueOf(entryDN));
                throw new DirectoryException(ResultCode.NO_SUCH_OBJECT, m);
            }
            ConditionResult conditionResult = ConditionResult.TRUE;
            return conditionResult;
        }
        finally {
            this.backendLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long numSubordinates(DN entryDN, boolean subtree) throws DirectoryException {
        this.backendLock.readLock().lock();
        try {
            HashSet<DN> childDNSet = this.childDNs.get(entryDN);
            if (childDNSet == null || childDNSet.isEmpty()) {
                if (this.entryMap.containsKey(entryDN)) {
                    long l = 0L;
                    return l;
                }
                Message m = BackendMessages.ERR_LDIF_BACKEND_NUM_SUBORDINATES_NO_SUCH_ENTRY.get(String.valueOf(entryDN));
                throw new DirectoryException(ResultCode.NO_SUCH_OBJECT, m);
            }
            if (!subtree) {
                long m = childDNSet.size();
                return m;
            }
            long count = 0L;
            for (DN childDN : childDNSet) {
                count += this.numSubordinates(childDN, true);
                ++count;
            }
            long l = count;
            return l;
        }
        finally {
            this.backendLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Entry getEntry(DN entryDN) {
        this.backendLock.readLock().lock();
        try {
            Entry entry = this.entryMap.get(entryDN);
            return entry;
        }
        finally {
            this.backendLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean entryExists(DN entryDN) {
        this.backendLock.readLock().lock();
        try {
            boolean bl = this.entryMap.containsKey(entryDN);
            return bl;
        }
        finally {
            this.backendLock.readLock().unlock();
        }
    }

    @Override
    public void addEntry(Entry entry, AddOperation addOperation) throws DirectoryException {
        this.backendLock.writeLock().lock();
        try {
            DN entryDN = entry.getDN();
            if (this.entryMap.containsKey(entryDN)) {
                Message m = BackendMessages.ERR_LDIF_BACKEND_ADD_ALREADY_EXISTS.get(entryDN.toString());
                throw new DirectoryException(ResultCode.ENTRY_ALREADY_EXISTS, m);
            }
            if (this.baseDNSet.contains(entryDN)) {
                this.entryMap.put(entryDN, entry.duplicate(false));
                this.writeLDIF();
                return;
            }
            DN parentDN = entryDN.getParentDNInSuffix();
            if (parentDN != null && this.entryMap.containsKey(parentDN)) {
                this.entryMap.put(entryDN, entry.duplicate(false));
                HashSet<DN> childDNSet = this.childDNs.get(parentDN);
                if (childDNSet == null) {
                    childDNSet = new HashSet();
                    this.childDNs.put(parentDN, childDNSet);
                }
                childDNSet.add(entryDN);
                this.writeLDIF();
                return;
            }
            DN matchedDN = null;
            while ((parentDN = parentDN.getParentDNInSuffix()) != null) {
                if (!this.entryMap.containsKey(parentDN)) continue;
                matchedDN = parentDN;
                break;
            }
            Message m = BackendMessages.ERR_LDIF_BACKEND_ADD_MISSING_PARENT.get(entryDN.toString());
            throw new DirectoryException(ResultCode.NO_SUCH_OBJECT, m, matchedDN, null);
        }
        finally {
            this.backendLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteEntry(DN entryDN, DeleteOperation deleteOperation) throws DirectoryException {
        this.backendLock.writeLock().lock();
        try {
            HashSet<DN> parentChildren;
            DN parentDN;
            if (!this.entryMap.containsKey(entryDN)) {
                DN matchedDN = null;
                for (parentDN = entryDN.getParentDNInSuffix(); parentDN != null; parentDN = parentDN.getParentDNInSuffix()) {
                    if (!this.entryMap.containsKey(parentDN)) continue;
                    matchedDN = parentDN;
                    break;
                }
                Message m = BackendMessages.ERR_LDIF_BACKEND_DELETE_NO_SUCH_ENTRY.get(entryDN.toString());
                throw new DirectoryException(ResultCode.NO_SUCH_OBJECT, m, matchedDN, null);
            }
            HashSet<DN> childDNSet = this.childDNs.get(entryDN);
            if (childDNSet == null || childDNSet.isEmpty()) {
                HashSet<DN> parentChildren2;
                this.entryMap.remove(entryDN);
                this.childDNs.remove(entryDN);
                if (parentDN != null && (parentChildren2 = this.childDNs.get(parentDN)) != null) {
                    parentChildren2.remove(entryDN);
                    if (parentChildren2.isEmpty()) {
                        this.childDNs.remove(parentDN);
                    }
                }
                this.writeLDIF();
                return;
            }
            boolean subtreeDelete = false;
            for (Control c : deleteOperation.getRequestControls()) {
                if (!c.getOID().equals("1.2.840.113556.1.4.805")) continue;
                subtreeDelete = true;
                break;
            }
            if (!subtreeDelete) {
                Message m = BackendMessages.ERR_LDIF_BACKEND_DELETE_NONLEAF.get(entryDN.toString());
                throw new DirectoryException(ResultCode.NOT_ALLOWED_ON_NONLEAF, m);
            }
            this.entryMap.remove(entryDN);
            this.childDNs.remove(entryDN);
            if (parentDN != null && (parentChildren = this.childDNs.get(parentDN)) != null) {
                parentChildren.remove(entryDN);
                if (parentChildren.isEmpty()) {
                    this.childDNs.remove(parentDN);
                }
            }
            for (DN childDN : childDNSet) {
                this.subtreeDelete(childDN);
            }
            this.writeLDIF();
            return;
        }
        finally {
            this.backendLock.writeLock().unlock();
        }
    }

    private void subtreeDelete(DN entryDN) {
        this.entryMap.remove(entryDN);
        HashSet<DN> childDNSet = this.childDNs.remove(entryDN);
        if (childDNSet != null) {
            for (DN childDN : childDNSet) {
                this.subtreeDelete(childDN);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void replaceEntry(Entry oldEntry, Entry newEntry, ModifyOperation modifyOperation) throws DirectoryException {
        this.backendLock.writeLock().lock();
        try {
            DN entryDN = newEntry.getDN();
            if (!this.entryMap.containsKey(entryDN)) {
                DN matchedDN = null;
                for (DN parentDN = entryDN.getParentDNInSuffix(); parentDN != null; parentDN = parentDN.getParentDNInSuffix()) {
                    if (!this.entryMap.containsKey(parentDN)) continue;
                    matchedDN = parentDN;
                    break;
                }
                Message m = BackendMessages.ERR_LDIF_BACKEND_MODIFY_NO_SUCH_ENTRY.get(entryDN.toString());
                throw new DirectoryException(ResultCode.NO_SUCH_OBJECT, m, matchedDN, null);
            }
            this.entryMap.put(entryDN, newEntry.duplicate(false));
            this.writeLDIF();
            return;
        }
        finally {
            this.backendLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void renameEntry(DN currentDN, Entry entry, ModifyDNOperation modifyDNOperation) throws DirectoryException {
        this.backendLock.writeLock().lock();
        try {
            DN newDN = entry.getDN();
            if (!this.entryMap.containsKey(currentDN)) {
                DN matchedDN = null;
                for (DN parentDN = currentDN.getParentDNInSuffix(); parentDN != null; parentDN = parentDN.getParentDNInSuffix()) {
                    if (!this.entryMap.containsKey(parentDN)) continue;
                    matchedDN = parentDN;
                    break;
                }
                Message m = BackendMessages.ERR_LDIF_BACKEND_MODDN_NO_SUCH_SOURCE_ENTRY.get(currentDN.toString());
                throw new DirectoryException(ResultCode.NO_SUCH_OBJECT, m, matchedDN, null);
            }
            if (this.entryMap.containsKey(newDN)) {
                Message m = BackendMessages.ERR_LDIF_BACKEND_MODDN_TARGET_ENTRY_ALREADY_EXISTS.get(newDN.toString());
                throw new DirectoryException(ResultCode.ENTRY_ALREADY_EXISTS, m);
            }
            DN newParentDN = newDN.getParentDNInSuffix();
            if (!this.entryMap.containsKey(newParentDN)) {
                Message m = BackendMessages.ERR_LDIF_BACKEND_MODDN_NEW_PARENT_DOESNT_EXIST.get(String.valueOf(newParentDN));
                throw new DirectoryException(ResultCode.NO_SUCH_OBJECT, m);
            }
            DN oldParentDN = currentDN.getParentDNInSuffix();
            HashSet<DN> parentChildDNs = this.childDNs.get(oldParentDN);
            if (parentChildDNs != null) {
                parentChildDNs.remove(currentDN);
                if (parentChildDNs.isEmpty() && modifyDNOperation.getNewSuperior() != null) {
                    this.childDNs.remove(oldParentDN);
                }
            }
            if ((parentChildDNs = this.childDNs.get(newParentDN)) == null) {
                parentChildDNs = new HashSet();
                this.childDNs.put(newParentDN, parentChildDNs);
            }
            parentChildDNs.add(newDN);
            Set childDNSet = this.childDNs.remove(currentDN);
            if (childDNSet == null || childDNSet.isEmpty()) {
                this.entryMap.remove(currentDN);
                this.entryMap.put(newDN, entry.duplicate(false));
                this.writeLDIF();
                return;
            }
            this.entryMap.remove(currentDN);
            this.entryMap.put(newDN, entry.duplicate(false));
            for (DN childDN : childDNSet) {
                this.subtreeRename(childDN, newDN);
            }
            this.writeLDIF();
            return;
        }
        finally {
            this.backendLock.writeLock().unlock();
        }
    }

    private void subtreeRename(DN entryDN, DN newParentDN) {
        Set childDNSet = this.childDNs.remove(entryDN);
        DN newEntryDN = new DN(entryDN.getRDN(), newParentDN);
        Entry oldEntry = (Entry)this.entryMap.remove(entryDN);
        if (oldEntry == null) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugWarning("Subtree rename encountered entry DN " + entryDN.toString() + " for nonexistent entry.");
            }
            return;
        }
        Entry newEntry = oldEntry.duplicate(false);
        newEntry.setDN(newEntryDN);
        this.entryMap.put(newEntryDN, newEntry);
        HashSet<DN> parentChildren = this.childDNs.get(newParentDN);
        if (parentChildren == null) {
            parentChildren = new HashSet();
            this.childDNs.put(newParentDN, parentChildren);
        }
        parentChildren.add(newEntryDN);
        if (childDNSet != null) {
            for (DN childDN : childDNSet) {
                this.subtreeRename(childDN, newEntryDN);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void search(SearchOperation searchOperation) throws DirectoryException {
        this.backendLock.readLock().lock();
        try {
            DN baseDN = searchOperation.getBaseDN();
            SearchScope scope = searchOperation.getScope();
            SearchFilter filter = searchOperation.getFilter();
            Entry baseEntry = this.entryMap.get(baseDN);
            if (baseEntry == null && this.handlesEntry(baseDN)) {
                DN matchedDN;
                for (matchedDN = baseDN.getParentDNInSuffix(); matchedDN != null && !this.entryMap.containsKey(matchedDN); matchedDN = matchedDN.getParentDNInSuffix()) {
                }
                Message m = BackendMessages.ERR_LDIF_BACKEND_SEARCH_NO_SUCH_BASE.get(String.valueOf(baseDN));
                throw new DirectoryException(ResultCode.NO_SUCH_OBJECT, m, matchedDN, null);
            }
            if (baseEntry != null) {
                baseEntry = baseEntry.duplicate(true);
            }
            if (scope == SearchScope.BASE_OBJECT) {
                if (filter.matchesEntry(baseEntry)) {
                    searchOperation.returnEntry(baseEntry, new LinkedList<Control>());
                }
            } else {
                for (Entry e : this.entryMap.values()) {
                    if (!(e = e.duplicate(true)).matchesBaseAndScope(baseDN, scope) || !filter.matchesEntry(e)) continue;
                    searchOperation.returnEntry(e, new LinkedList<Control>());
                }
            }
        }
        finally {
            this.backendLock.readLock().unlock();
        }
    }

    public HashSet<String> getSupportedControls() {
        return this.supportedControls;
    }

    public HashSet<String> getSupportedFeatures() {
        return this.supportedFeatures;
    }

    @Override
    public boolean supportsLDIFExport() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void exportLDIF(LDIFExportConfig exportConfig) throws DirectoryException {
        this.backendLock.readLock().lock();
        try {
            LDIFWriter ldifWriter;
            try {
                ldifWriter = new LDIFWriter(exportConfig);
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                Message m = BackendMessages.ERR_LDIF_BACKEND_CANNOT_CREATE_LDIF_WRITER.get(StaticUtils.stackTraceToSingleLineString(e));
                throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), m, e);
            }
            DN entryDN = null;
            try {
                for (Entry entry : this.entryMap.values()) {
                    entryDN = entry.getDN();
                    ldifWriter.writeEntry(entry);
                }
            }
            catch (Exception e) {
                Message m = BackendMessages.ERR_LDIF_BACKEND_CANNOT_WRITE_ENTRY_TO_LDIF.get(String.valueOf(entryDN), StaticUtils.stackTraceToSingleLineString(e));
                throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), m, e);
            }
            finally {
                block17: {
                    try {
                        ldifWriter.close();
                    }
                    catch (Exception e) {
                        if (!DebugLogger.debugEnabled()) break block17;
                        TRACER.debugCaught(DebugLogLevel.ERROR, e);
                    }
                }
            }
        }
        finally {
            this.backendLock.readLock().unlock();
        }
    }

    @Override
    public boolean supportsLDIFImport() {
        return true;
    }

    @Override
    public LDIFImportResult importLDIF(LDIFImportConfig importConfig) throws DirectoryException {
        return this.importLDIF(importConfig, true);
    }

    /*
     * Exception decompiling
     */
    private LDIFImportResult importLDIF(LDIFImportConfig importConfig, boolean writeLDIF) throws DirectoryException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [8[CATCHBLOCK]], but top level block is 4[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public boolean supportsBackup() {
        return false;
    }

    @Override
    public boolean supportsBackup(BackupConfig backupConfig, StringBuilder unsupportedReason) {
        return false;
    }

    @Override
    public void createBackup(BackupConfig backupConfig) throws DirectoryException {
        Message message = BackendMessages.ERR_LDIF_BACKEND_BACKUP_RESTORE_NOT_SUPPORTED.get();
        throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, message);
    }

    @Override
    public void removeBackup(BackupDirectory backupDirectory, String backupID) throws DirectoryException {
        Message message = BackendMessages.ERR_LDIF_BACKEND_BACKUP_RESTORE_NOT_SUPPORTED.get();
        throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, message);
    }

    @Override
    public boolean supportsRestore() {
        return false;
    }

    @Override
    public void restoreBackup(RestoreConfig restoreConfig) throws DirectoryException {
        Message message = BackendMessages.ERR_LDIF_BACKEND_BACKUP_RESTORE_NOT_SUPPORTED.get();
        throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, message);
    }

    @Override
    public void configureBackend(Configuration config) throws ConfigException {
        if (config != null) {
            Validator.ensureTrue(config instanceof LDIFBackendCfg);
            this.currentConfig = (LDIFBackendCfg)config;
            this.currentConfig.addLDIFChangeListener(this);
            this.baseDNs = new DN[this.currentConfig.getBaseDN().size()];
            this.currentConfig.getBaseDN().toArray(this.baseDNs);
            if (this.baseDNs.length != 1) {
                throw new ConfigException(BackendMessages.ERR_LDIF_BACKEND_MULTIPLE_BASE_DNS.get(this.currentConfig.dn().toString()));
            }
            this.baseDNSet = new HashSet();
            for (DN dn : this.baseDNs) {
                this.baseDNSet.add(dn);
            }
            this.supportedControls = new HashSet(1);
            this.supportedControls.add("1.2.840.113556.1.4.805");
            this.supportedFeatures = new HashSet(0);
            this.ldifFilePath = this.currentConfig.getLDIFFile();
        }
    }

    @Override
    public boolean isConfigurationChangeAcceptable(LDIFBackendCfg configuration, List<Message> unacceptableReasons) {
        boolean configAcceptable = true;
        if (configuration.getBaseDN().size() != 1) {
            unacceptableReasons.add(BackendMessages.ERR_LDIF_BACKEND_MULTIPLE_BASE_DNS.get(configuration.dn().toString()));
            configAcceptable = false;
        }
        return configAcceptable;
    }

    @Override
    public ConfigChangeResult applyConfigurationChange(LDIFBackendCfg configuration) {
        File newLDIF;
        File currentLDIF;
        boolean adminActionRequired = false;
        LinkedList<Message> messages = new LinkedList<Message>();
        if (this.ldifFilePath != null && !(currentLDIF = StaticUtils.getFileForPath(this.ldifFilePath)).equals(newLDIF = StaticUtils.getFileForPath(configuration.getLDIFFile()))) {
            messages.add(BackendMessages.INFO_LDIF_BACKEND_LDIF_FILE_CHANGED.get());
            adminActionRequired = true;
        }
        if (this.baseDNSet != null && !this.baseDNSet.equals(configuration.getBaseDN())) {
            messages.add(BackendMessages.INFO_LDIF_BACKEND_BASE_DN_CHANGED.get());
            adminActionRequired = true;
        }
        this.currentConfig = configuration;
        return new ConfigChangeResult(ResultCode.SUCCESS, adminActionRequired, messages);
    }

    @Override
    public DN getComponentEntryDN() {
        return this.currentConfig.dn();
    }

    @Override
    public String getClassName() {
        return LDIFBackend.class.getName();
    }

    @Override
    public LinkedHashMap<String, String> getAlerts() {
        LinkedHashMap<String, String> alerts = new LinkedHashMap<String, String>();
        alerts.put("org.opends.server.LDIFBackendCannotWriteUupdate", "This alert type will be used to provide notification that an LDIF backend was unable to store an updated copy of the LDIF file after processing a write operation.");
        return alerts;
    }

    @Override
    public void preloadEntryCache() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Operation not supported.");
    }
}

