/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.backends;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Random;
import java.util.SortedSet;
import javax.naming.ldap.Rdn;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.opends.messages.BackendMessages;
import org.opends.messages.Message;
import org.opends.server.admin.Configuration;
import org.opends.server.admin.server.ConfigurationChangeListener;
import org.opends.server.admin.std.server.TrustStoreBackendCfg;
import org.opends.server.api.Backend;
import org.opends.server.config.ConfigException;
import org.opends.server.core.AddOperation;
import org.opends.server.core.DeleteOperation;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.ModifyDNOperation;
import org.opends.server.core.ModifyOperation;
import org.opends.server.core.SearchOperation;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.types.Attribute;
import org.opends.server.types.AttributeBuilder;
import org.opends.server.types.AttributeType;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.Attributes;
import org.opends.server.types.BackupConfig;
import org.opends.server.types.BackupDirectory;
import org.opends.server.types.ByteString;
import org.opends.server.types.ConditionResult;
import org.opends.server.types.ConfigChangeResult;
import org.opends.server.types.DN;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.Entry;
import org.opends.server.types.FilePermission;
import org.opends.server.types.IndexType;
import org.opends.server.types.InitializationException;
import org.opends.server.types.LDIFExportConfig;
import org.opends.server.types.LDIFImportConfig;
import org.opends.server.types.LDIFImportResult;
import org.opends.server.types.ObjectClass;
import org.opends.server.types.RDN;
import org.opends.server.types.RestoreConfig;
import org.opends.server.types.ResultCode;
import org.opends.server.types.SearchFilter;
import org.opends.server.types.SearchScope;
import org.opends.server.util.CertificateManager;
import org.opends.server.util.StaticUtils;
import org.opends.server.util.Validator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TrustStoreBackend
extends Backend
implements ConfigurationChangeListener<TrustStoreBackendCfg> {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private TrustStoreBackendCfg configuration;
    private DN baseDN;
    private DN[] baseDNs;
    private Entry baseEntry;
    private HashSet<String> supportedControls;
    private HashSet<String> supportedFeatures;
    private char[] trustStorePIN;
    private String trustStoreFile;
    private String trustStoreType;
    private CertificateManager certificateManager;

    @Override
    public void configureBackend(Configuration config) throws ConfigException {
        Validator.ensureNotNull(config);
        Validator.ensureTrue(config instanceof TrustStoreBackendCfg);
        this.configuration = (TrustStoreBackendCfg)config;
    }

    @Override
    public void initializeBackend() throws ConfigException, InitializationException {
        DN configEntryDN = this.configuration.dn();
        SortedSet<DN> baseDNSet = this.configuration.getBaseDN();
        if (baseDNSet.size() != 1) {
            Message message = BackendMessages.ERR_TRUSTSTORE_REQUIRES_ONE_BASE_DN.get(String.valueOf(configEntryDN));
            throw new InitializationException(message);
        }
        this.baseDN = baseDNSet.first();
        this.baseDNs = new DN[]{this.baseDN};
        this.trustStoreFile = this.configuration.getTrustStoreFile();
        this.trustStoreType = this.configuration.getTrustStoreType();
        if (this.trustStoreType == null) {
            this.trustStoreType = KeyStore.getDefaultType();
        }
        try {
            KeyStore.getInstance(this.trustStoreType);
        }
        catch (KeyStoreException kse) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, kse);
            }
            Message message = BackendMessages.ERR_TRUSTSTORE_INVALID_TYPE.get(String.valueOf(this.trustStoreType), String.valueOf(configEntryDN), StaticUtils.getExceptionMessage(kse));
            throw new InitializationException(message);
        }
        String pinProperty = this.configuration.getTrustStorePinProperty();
        if (pinProperty == null) {
            String pinEnVar = this.configuration.getTrustStorePinEnvironmentVariable();
            if (pinEnVar == null) {
                String pinFilePath = this.configuration.getTrustStorePinFile();
                if (pinFilePath == null) {
                    String pinStr = this.configuration.getTrustStorePin();
                    this.trustStorePIN = (char[])(pinStr == null ? null : pinStr.toCharArray());
                } else {
                    String pinStr;
                    File pinFile = StaticUtils.getFileForPath(pinFilePath);
                    if (!pinFile.exists()) {
                        try {
                            this.trustStorePIN = TrustStoreBackend.createKeystorePassword();
                            TrustStoreBackend.createPINFile(pinFile.getPath(), new String(this.trustStorePIN));
                        }
                        catch (Exception e) {
                            Message message = BackendMessages.ERR_TRUSTSTORE_PIN_FILE_CANNOT_CREATE.get(String.valueOf(pinFilePath), String.valueOf(configEntryDN));
                            throw new InitializationException(message);
                        }
                    }
                    BufferedReader br = null;
                    try {
                        br = new BufferedReader(new FileReader(pinFile));
                        pinStr = br.readLine();
                    }
                    catch (IOException ioe) {
                        Message message = BackendMessages.ERR_TRUSTSTORE_PIN_FILE_CANNOT_READ.get(String.valueOf(pinFilePath), String.valueOf(configEntryDN), StaticUtils.getExceptionMessage(ioe));
                        throw new InitializationException(message, (Throwable)ioe);
                    }
                    finally {
                        try {
                            br.close();
                        }
                        catch (Exception e) {}
                    }
                    if (pinStr == null) {
                        Message message = BackendMessages.ERR_TRUSTSTORE_PIN_FILE_EMPTY.get(String.valueOf(pinFilePath), String.valueOf(configEntryDN));
                        throw new InitializationException(message);
                    }
                    this.trustStorePIN = pinStr.toCharArray();
                }
            } else {
                String pinStr = System.getenv(pinEnVar);
                if (pinStr == null) {
                    Message message = BackendMessages.ERR_TRUSTSTORE_PIN_ENVAR_NOT_SET.get(String.valueOf(pinProperty), String.valueOf(configEntryDN));
                    throw new InitializationException(message);
                }
                this.trustStorePIN = pinStr.toCharArray();
            }
        } else {
            String pinStr = System.getProperty(pinProperty);
            if (pinStr == null) {
                Message message = BackendMessages.ERR_TRUSTSTORE_PIN_PROPERTY_NOT_SET.get(String.valueOf(pinProperty), String.valueOf(configEntryDN));
                throw new InitializationException(message);
            }
            this.trustStorePIN = pinStr.toCharArray();
        }
        this.certificateManager = new CertificateManager(StaticUtils.getFileForPath(this.trustStoreFile).getPath(), this.trustStoreType, new String(this.trustStorePIN));
        this.generateInstanceCertificateIfAbsent();
        LinkedHashMap<ObjectClass, String> objectClasses = new LinkedHashMap<ObjectClass, String>(2);
        objectClasses.put(DirectoryServer.getTopObjectClass(), "top");
        ObjectClass branchOC = DirectoryServer.getObjectClass("ds-cfg-branch", true);
        objectClasses.put(branchOC, "ds-cfg-branch");
        LinkedHashMap<AttributeType, List<Attribute>> opAttrs = new LinkedHashMap<AttributeType, List<Attribute>>(0);
        LinkedHashMap<AttributeType, List<Attribute>> userAttrs = new LinkedHashMap<AttributeType, List<Attribute>>(1);
        RDN rdn = this.baseDN.getRDN();
        int numAVAs = rdn.getNumValues();
        for (int i = 0; i < numAVAs; ++i) {
            AttributeType attrType = rdn.getAttributeType(i);
            ArrayList<Attribute> attrList = new ArrayList<Attribute>(1);
            attrList.add(Attributes.create(attrType, rdn.getAttributeValue(i)));
            userAttrs.put(attrType, attrList);
        }
        this.baseEntry = new Entry(this.baseDN, objectClasses, userAttrs, opAttrs);
        this.supportedControls = new HashSet(0);
        this.supportedFeatures = new HashSet(0);
        this.configuration.addTrustStoreChangeListener(this);
        try {
            DirectoryServer.registerBaseDN(this.baseDN, this, true);
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = BackendMessages.ERR_BACKEND_CANNOT_REGISTER_BASEDN.get(String.valueOf(this.baseDN), String.valueOf(e));
            throw new InitializationException(message, (Throwable)e);
        }
    }

    @Override
    public void finalizeBackend() {
        block2: {
            this.configuration.addTrustStoreChangeListener(this);
            try {
                DirectoryServer.deregisterBaseDN(this.baseDN);
            }
            catch (Exception e) {
                if (!DebugLogger.debugEnabled()) break block2;
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
        }
    }

    @Override
    public DN[] getBaseDNs() {
        return this.baseDNs;
    }

    @Override
    public long getEntryCount() {
        int numEntries;
        block3: {
            numEntries = 1;
            try {
                String[] aliases = this.certificateManager.getCertificateAliases();
                if (aliases != null) {
                    numEntries += aliases.length;
                }
            }
            catch (KeyStoreException e) {
                if (!DebugLogger.debugEnabled()) break block3;
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
        }
        return numEntries;
    }

    @Override
    public boolean isLocal() {
        return true;
    }

    @Override
    public boolean isIndexed(AttributeType attributeType, IndexType indexType) {
        return true;
    }

    @Override
    public Entry getEntry(DN entryDN) throws DirectoryException {
        if (entryDN == null) {
            Message message = BackendMessages.ERR_TRUSTSTORE_GET_ENTRY_NULL.get();
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message);
        }
        if (entryDN.equals(this.baseDN)) {
            return this.baseEntry.duplicate(true);
        }
        DN parentDN = entryDN.getParentDNInSuffix();
        if (parentDN == null) {
            return null;
        }
        if (parentDN.equals(this.baseDN)) {
            try {
                return this.getCertEntry(entryDN);
            }
            catch (DirectoryException e) {
                return null;
            }
        }
        return null;
    }

    private Entry getCertEntry(DN entryDN) throws DirectoryException {
        ASN1OctetString certValue;
        AttributeType t = DirectoryServer.getAttributeType("ds-cfg-key-id", true);
        AttributeValue v = entryDN.getRDN().getAttributeValue(t);
        if (v == null) {
            Message message = BackendMessages.ERR_TRUSTSTORE_DN_DOES_NOT_SPECIFY_CERTIFICATE.get(String.valueOf(entryDN));
            throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, message, this.baseDN, null);
        }
        String certAlias = v.getStringValue();
        try {
            Certificate cert = this.certificateManager.getCertificate(certAlias);
            if (cert == null) {
                Message message = BackendMessages.ERR_TRUSTSTORE_CERTIFICATE_NOT_FOUND.get(String.valueOf(entryDN), certAlias);
                throw new DirectoryException(ResultCode.NO_SUCH_OBJECT, message);
            }
            certValue = new ASN1OctetString(cert.getEncoded());
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.VERBOSE, e);
            }
            Message message = BackendMessages.ERR_TRUSTSTORE_CANNOT_RETRIEVE_CERT.get(certAlias, this.trustStoreFile, e.getMessage());
            throw new DirectoryException(ResultCode.NO_SUCH_OBJECT, message);
        }
        LinkedHashMap<ObjectClass, String> ocMap = new LinkedHashMap<ObjectClass, String>(2);
        ocMap.put(DirectoryServer.getTopObjectClass(), "top");
        ObjectClass objectClass = DirectoryServer.getObjectClass("ds-cfg-instance-key", true);
        ocMap.put(objectClass, "ds-cfg-instance-key");
        LinkedHashMap<AttributeType, List<Attribute>> opAttrs = new LinkedHashMap<AttributeType, List<Attribute>>(0);
        LinkedHashMap<AttributeType, List<Attribute>> userAttrs = new LinkedHashMap<AttributeType, List<Attribute>>(3);
        ArrayList<Attribute> attrList = new ArrayList<Attribute>(1);
        attrList.add(Attributes.create(t, v));
        userAttrs.put(t, attrList);
        t = DirectoryServer.getAttributeType("ds-cfg-public-key-certificate", true);
        AttributeBuilder builder = new AttributeBuilder(t);
        builder.setOption("binary");
        builder.add(new AttributeValue(t, (ByteString)certValue));
        attrList = new ArrayList(1);
        attrList.add(builder.toAttribute());
        userAttrs.put(t, attrList);
        Entry e = new Entry(entryDN, ocMap, userAttrs, opAttrs);
        e.processVirtualAttributes();
        return e;
    }

    @Override
    public void addEntry(Entry entry, AddOperation addOperation) throws DirectoryException {
        DN entryDN = entry.getDN();
        if (entryDN.equals(this.baseDN)) {
            Message message = BackendMessages.ERR_TRUSTSTORE_INVALID_BASE.get(String.valueOf(entryDN));
            throw new DirectoryException(ResultCode.ENTRY_ALREADY_EXISTS, message);
        }
        DN parentDN = entryDN.getParentDNInSuffix();
        if (parentDN == null) {
            Message message = BackendMessages.ERR_TRUSTSTORE_INVALID_BASE.get(String.valueOf(entryDN));
            throw new DirectoryException(ResultCode.NO_SUCH_OBJECT, message);
        }
        if (!parentDN.equals(this.baseDN)) {
            Message message = BackendMessages.ERR_TRUSTSTORE_INVALID_BASE.get(String.valueOf(entryDN));
            throw new DirectoryException(ResultCode.NO_SUCH_OBJECT, message);
        }
        this.addCertificate(entry);
    }

    @Override
    public void deleteEntry(DN entryDN, DeleteOperation deleteOperation) throws DirectoryException {
        if (entryDN.equals(this.baseDN)) {
            Message message = BackendMessages.ERR_TRUSTSTORE_INVALID_BASE.get(String.valueOf(entryDN));
            throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, message);
        }
        DN parentDN = entryDN.getParentDNInSuffix();
        if (parentDN == null || !parentDN.equals(this.baseDN)) {
            Message message = BackendMessages.ERR_TRUSTSTORE_INVALID_BASE.get(String.valueOf(entryDN));
            throw new DirectoryException(ResultCode.NO_SUCH_OBJECT, message);
        }
        this.deleteCertificate(entryDN);
    }

    @Override
    public void replaceEntry(Entry oldEntry, Entry newEntry, ModifyOperation modifyOperation) throws DirectoryException {
        Message message = BackendMessages.ERR_TRUSTSTORE_MODIFY_NOT_SUPPORTED.get();
        throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, message);
    }

    @Override
    public void renameEntry(DN currentDN, Entry entry, ModifyDNOperation modifyDNOperation) throws DirectoryException {
        Message message = BackendMessages.ERR_TRUSTSTORE_MODIFY_DN_NOT_SUPPORTED.get();
        throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, message);
    }

    @Override
    public void search(SearchOperation searchOperation) throws DirectoryException {
        DN baseDN = searchOperation.getBaseDN();
        Entry baseEntry = this.getEntry(baseDN);
        SearchScope scope = searchOperation.getScope();
        SearchFilter filter = searchOperation.getFilter();
        if (this.baseDN.equals(baseDN)) {
            String[] aliases;
            block13: {
                if ((scope == SearchScope.BASE_OBJECT || scope == SearchScope.WHOLE_SUBTREE) && filter.matchesEntry(baseEntry)) {
                    searchOperation.returnEntry(baseEntry, null);
                }
                aliases = null;
                try {
                    aliases = this.certificateManager.getCertificateAliases();
                }
                catch (KeyStoreException e) {
                    if (!DebugLogger.debugEnabled()) break block13;
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
            }
            if (aliases == null) {
                aliases = new String[]{};
            }
            if (scope != SearchScope.BASE_OBJECT && aliases.length != 0) {
                AttributeType certAliasType = DirectoryServer.getAttributeType("ds-cfg-key-id", true);
                for (String alias : aliases) {
                    Entry certEntry;
                    DN certDN = TrustStoreBackend.makeChildDN(this.baseDN, certAliasType, alias);
                    try {
                        certEntry = this.getCertEntry(certDN);
                    }
                    catch (Exception e) {
                        if (!DebugLogger.debugEnabled()) continue;
                        TRACER.debugCaught(DebugLogLevel.VERBOSE, e);
                        continue;
                    }
                    if (!filter.matchesEntry(certEntry)) continue;
                    searchOperation.returnEntry(certEntry, null);
                }
            }
        } else if (this.baseDN.equals(baseDN.getParentDNInSuffix())) {
            Entry certEntry = this.getCertEntry(baseDN);
            if ((scope == SearchScope.BASE_OBJECT || scope == SearchScope.WHOLE_SUBTREE) && filter.matchesEntry(certEntry)) {
                searchOperation.returnEntry(certEntry, null);
            }
        } else {
            Message message = BackendMessages.ERR_TRUSTSTORE_INVALID_BASE.get(String.valueOf(baseDN));
            throw new DirectoryException(ResultCode.NO_SUCH_OBJECT, message);
        }
    }

    public HashSet<String> getSupportedControls() {
        return this.supportedControls;
    }

    public HashSet<String> getSupportedFeatures() {
        return this.supportedFeatures;
    }

    @Override
    public boolean supportsLDIFExport() {
        return false;
    }

    @Override
    public void exportLDIF(LDIFExportConfig exportConfig) throws DirectoryException {
        Message message = BackendMessages.ERR_TRUSTSTORE_IMPORT_AND_EXPORT_NOT_SUPPORTED.get();
        throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, message);
    }

    @Override
    public boolean supportsLDIFImport() {
        return false;
    }

    @Override
    public LDIFImportResult importLDIF(LDIFImportConfig importConfig) throws DirectoryException {
        Message message = BackendMessages.ERR_TRUSTSTORE_IMPORT_AND_EXPORT_NOT_SUPPORTED.get();
        throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, message);
    }

    @Override
    public boolean supportsBackup() {
        return false;
    }

    @Override
    public boolean supportsBackup(BackupConfig backupConfig, StringBuilder unsupportedReason) {
        return false;
    }

    @Override
    public void createBackup(BackupConfig backupConfig) throws DirectoryException {
        Message message = BackendMessages.ERR_TRUSTSTORE_BACKUP_AND_RESTORE_NOT_SUPPORTED.get();
        throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, message);
    }

    @Override
    public void removeBackup(BackupDirectory backupDirectory, String backupID) throws DirectoryException {
        Message message = BackendMessages.ERR_TRUSTSTORE_BACKUP_AND_RESTORE_NOT_SUPPORTED.get();
        throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, message);
    }

    @Override
    public boolean supportsRestore() {
        return false;
    }

    @Override
    public void restoreBackup(RestoreConfig restoreConfig) throws DirectoryException {
        Message message = BackendMessages.ERR_TRUSTSTORE_BACKUP_AND_RESTORE_NOT_SUPPORTED.get();
        throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, message);
    }

    @Override
    public ConditionResult hasSubordinates(DN entryDN) throws DirectoryException {
        throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, BackendMessages.ERR_HAS_SUBORDINATES_NOT_SUPPORTED.get());
    }

    @Override
    public long numSubordinates(DN entryDN, boolean subtree) throws DirectoryException {
        throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, BackendMessages.ERR_NUM_SUBORDINATES_NOT_SUPPORTED.get());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isConfigurationChangeAcceptable(TrustStoreBackendCfg configuration, List<Message> unacceptableReasons) {
        File f;
        String pinFile;
        String pinEnVar;
        String pinProp;
        Message message;
        boolean configAcceptable = true;
        DN cfgEntryDN = configuration.dn();
        String newTrustStoreFile = configuration.getTrustStoreFile();
        try {
            File f2 = StaticUtils.getFileForPath(newTrustStoreFile);
            if (!f2.exists() || !f2.isFile()) {
                unacceptableReasons.add(BackendMessages.ERR_TRUSTSTORE_NO_SUCH_FILE.get(String.valueOf(newTrustStoreFile), String.valueOf(cfgEntryDN)));
                configAcceptable = false;
            }
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            unacceptableReasons.add(BackendMessages.ERR_TRUSTSTORE_CANNOT_DETERMINE_FILE.get(String.valueOf(cfgEntryDN), StaticUtils.getExceptionMessage(e)));
            configAcceptable = false;
        }
        String storeType = configuration.getTrustStoreType();
        if (storeType != null) {
            try {
                KeyStore.getInstance(storeType);
            }
            catch (KeyStoreException kse) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, kse);
                }
                message = BackendMessages.ERR_TRUSTSTORE_INVALID_TYPE.get(String.valueOf(storeType), String.valueOf(cfgEntryDN), StaticUtils.getExceptionMessage(kse));
                unacceptableReasons.add(message);
                configAcceptable = false;
            }
        }
        if ((pinProp = configuration.getTrustStorePinProperty()) != null && System.getProperty(pinProp) == null) {
            message = BackendMessages.ERR_TRUSTSTORE_PIN_PROPERTY_NOT_SET.get(String.valueOf(pinProp), String.valueOf(cfgEntryDN));
            unacceptableReasons.add(message);
            configAcceptable = false;
        }
        if ((pinEnVar = configuration.getTrustStorePinEnvironmentVariable()) != null && System.getenv(pinEnVar) == null) {
            Message message2 = BackendMessages.ERR_TRUSTSTORE_PIN_ENVAR_NOT_SET.get(String.valueOf(pinEnVar), String.valueOf(cfgEntryDN));
            unacceptableReasons.add(message2);
            configAcceptable = false;
        }
        if ((pinFile = configuration.getTrustStorePinFile()) != null && (f = new File(pinFile)).exists()) {
            String pinStr = null;
            BufferedReader br = null;
            try {
                br = new BufferedReader(new FileReader(pinFile));
                pinStr = br.readLine();
            }
            catch (IOException ioe) {
                Message message3 = BackendMessages.ERR_TRUSTSTORE_PIN_FILE_CANNOT_READ.get(String.valueOf(pinFile), String.valueOf(cfgEntryDN), StaticUtils.getExceptionMessage(ioe));
                unacceptableReasons.add(message3);
                configAcceptable = false;
            }
            finally {
                try {
                    br.close();
                }
                catch (Exception e) {}
            }
            if (pinStr == null) {
                Message message4 = BackendMessages.ERR_TRUSTSTORE_PIN_FILE_EMPTY.get(String.valueOf(pinFile), String.valueOf(cfgEntryDN));
                unacceptableReasons.add(message4);
                configAcceptable = false;
            }
        }
        return configAcceptable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConfigChangeResult applyConfigurationChange(TrustStoreBackendCfg cfg) {
        String newTrustStoreType;
        ResultCode resultCode = ResultCode.SUCCESS;
        boolean adminActionRequired = false;
        ArrayList<Message> messages = new ArrayList<Message>();
        DN configEntryDN = cfg.dn();
        String newTrustStoreFile = cfg.getTrustStoreFile();
        File f = StaticUtils.getFileForPath(newTrustStoreFile);
        if (!f.exists() || !f.isFile()) {
            resultCode = DirectoryServer.getServerErrorResultCode();
            messages.add(BackendMessages.ERR_TRUSTSTORE_NO_SUCH_FILE.get(String.valueOf(newTrustStoreFile), String.valueOf(configEntryDN)));
        }
        if ((newTrustStoreType = cfg.getTrustStoreType()) == null) {
            newTrustStoreType = KeyStore.getDefaultType();
        }
        try {
            KeyStore.getInstance(newTrustStoreType);
        }
        catch (KeyStoreException kse) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, kse);
            }
            messages.add(BackendMessages.ERR_TRUSTSTORE_INVALID_TYPE.get(String.valueOf(newTrustStoreType), String.valueOf(configEntryDN), StaticUtils.getExceptionMessage(kse)));
            resultCode = DirectoryServer.getServerErrorResultCode();
        }
        Object newPIN = null;
        String newPINProperty = cfg.getTrustStorePinProperty();
        if (newPINProperty == null) {
            String newPINEnVar = cfg.getTrustStorePinEnvironmentVariable();
            if (newPINEnVar == null) {
                String newPINFile = cfg.getTrustStorePinFile();
                if (newPINFile == null) {
                    String pinStr = cfg.getTrustStorePin();
                    newPIN = pinStr == null ? null : pinStr.toCharArray();
                } else {
                    File pinFile = StaticUtils.getFileForPath(newPINFile);
                    if (!pinFile.exists()) {
                        try {
                            newPIN = TrustStoreBackend.createKeystorePassword();
                            TrustStoreBackend.createPINFile(pinFile.getPath(), new String((char[])newPIN));
                        }
                        catch (Exception e) {
                            resultCode = DirectoryServer.getServerErrorResultCode();
                            messages.add(BackendMessages.ERR_TRUSTSTORE_PIN_FILE_CANNOT_CREATE.get(String.valueOf(newPINFile), String.valueOf(configEntryDN)));
                        }
                    } else {
                        String pinStr = null;
                        BufferedReader br = null;
                        try {
                            br = new BufferedReader(new FileReader(pinFile));
                            pinStr = br.readLine();
                        }
                        catch (IOException ioe) {
                            resultCode = DirectoryServer.getServerErrorResultCode();
                            messages.add(BackendMessages.ERR_TRUSTSTORE_PIN_FILE_CANNOT_READ.get(String.valueOf(newPINFile), String.valueOf(configEntryDN), StaticUtils.getExceptionMessage(ioe)));
                        }
                        finally {
                            try {
                                br.close();
                            }
                            catch (Exception e) {}
                        }
                        if (pinStr == null) {
                            resultCode = DirectoryServer.getServerErrorResultCode();
                            messages.add(BackendMessages.ERR_TRUSTSTORE_PIN_FILE_EMPTY.get(String.valueOf(newPINFile), String.valueOf(configEntryDN)));
                        } else {
                            newPIN = pinStr.toCharArray();
                        }
                    }
                }
            } else {
                String pinStr = System.getenv(newPINEnVar);
                if (pinStr == null) {
                    resultCode = DirectoryServer.getServerErrorResultCode();
                    messages.add(BackendMessages.ERR_TRUSTSTORE_PIN_ENVAR_NOT_SET.get(String.valueOf(newPINEnVar), String.valueOf(configEntryDN)));
                } else {
                    newPIN = pinStr.toCharArray();
                }
            }
        } else {
            String pinStr = System.getProperty(newPINProperty);
            if (pinStr == null) {
                resultCode = DirectoryServer.getServerErrorResultCode();
                messages.add(BackendMessages.ERR_TRUSTSTORE_PIN_PROPERTY_NOT_SET.get(String.valueOf(newPINProperty), String.valueOf(configEntryDN)));
            } else {
                newPIN = pinStr.toCharArray();
            }
        }
        if (resultCode == ResultCode.SUCCESS) {
            this.trustStoreFile = newTrustStoreFile;
            this.trustStoreType = newTrustStoreType;
            this.trustStorePIN = newPIN;
            this.configuration = cfg;
            this.certificateManager = new CertificateManager(StaticUtils.getFileForPath(this.trustStoreFile).getPath(), this.trustStoreType, new String(this.trustStorePIN));
        }
        return new ConfigChangeResult(resultCode, adminActionRequired, messages);
    }

    public static DN makeChildDN(DN parentDN, AttributeType rdnAttrType, String rdnStringValue) {
        AttributeValue attrValue = new AttributeValue(rdnAttrType, rdnStringValue);
        return parentDN.concat(RDN.create(rdnAttrType, attrValue));
    }

    public KeyManager[] getKeyManagers() throws DirectoryException {
        KeyStore keyStore;
        try {
            keyStore = KeyStore.getInstance(this.trustStoreType);
            FileInputStream inputStream = new FileInputStream(StaticUtils.getFileForPath(this.trustStoreFile));
            keyStore.load(inputStream, this.trustStorePIN);
            inputStream.close();
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = BackendMessages.ERR_TRUSTSTORE_CANNOT_LOAD.get(this.trustStoreFile, StaticUtils.getExceptionMessage(e));
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message, e);
        }
        try {
            String keyManagerAlgorithm = KeyManagerFactory.getDefaultAlgorithm();
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(keyManagerAlgorithm);
            keyManagerFactory.init(keyStore, this.trustStorePIN);
            return keyManagerFactory.getKeyManagers();
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = BackendMessages.ERR_TRUSTSTORE_CANNOT_CREATE_FACTORY.get(this.trustStoreFile, StaticUtils.getExceptionMessage(e));
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message, e);
        }
    }

    public TrustManager[] getTrustManagers() throws DirectoryException {
        KeyStore trustStore;
        try {
            trustStore = KeyStore.getInstance(this.trustStoreType);
            FileInputStream inputStream = new FileInputStream(StaticUtils.getFileForPath(this.trustStoreFile));
            trustStore.load(inputStream, this.trustStorePIN);
            inputStream.close();
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = BackendMessages.ERR_TRUSTSTORE_CANNOT_LOAD.get(this.trustStoreFile, StaticUtils.getExceptionMessage(e));
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message, e);
        }
        try {
            String trustManagerAlgorithm = TrustManagerFactory.getDefaultAlgorithm();
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(trustManagerAlgorithm);
            trustManagerFactory.init(trustStore);
            TrustManager[] trustManagers = trustManagerFactory.getTrustManagers();
            return trustManagers;
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = BackendMessages.ERR_TRUSTSTORE_CANNOT_CREATE_FACTORY.get(this.trustStoreFile, StaticUtils.getExceptionMessage(e));
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message, e);
        }
    }

    public Key getKey(String alias) throws DirectoryException {
        KeyStore trustStore;
        try {
            trustStore = KeyStore.getInstance(this.trustStoreType);
            FileInputStream inputStream = new FileInputStream(StaticUtils.getFileForPath(this.trustStoreFile));
            trustStore.load(inputStream, this.trustStorePIN);
            inputStream.close();
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = BackendMessages.ERR_TRUSTSTORE_CANNOT_LOAD.get(this.trustStoreFile, StaticUtils.getExceptionMessage(e));
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message, e);
        }
        try {
            return trustStore.getKey(alias, this.trustStorePIN);
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = BackendMessages.ERR_TRUSTSTORE_ERROR_READING_KEY.get(alias, this.trustStoreFile, StaticUtils.getExceptionMessage(e));
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addCertificate(Entry entry) throws DirectoryException {
        block19: {
            DN entryDN = entry.getDN();
            AttributeType t = DirectoryServer.getAttributeType("ds-cfg-key-id", true);
            AttributeValue v = entryDN.getRDN().getAttributeValue(t);
            if (v == null) {
                Message message = BackendMessages.ERR_TRUSTSTORE_DN_DOES_NOT_SPECIFY_CERTIFICATE.get(String.valueOf(entryDN));
                throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, message, this.baseDN, null);
            }
            String certAlias = v.getStringValue();
            try {
                if (this.certificateManager.aliasInUse(certAlias)) {
                    Message message = BackendMessages.ERR_TRUSTSTORE_ALIAS_IN_USE.get(String.valueOf(entryDN));
                    throw new DirectoryException(ResultCode.ENTRY_ALREADY_EXISTS, message);
                }
                ObjectClass ocSelfSignedCertRequest = DirectoryServer.getObjectClass("ds-cfg-self-signed-cert-request", true);
                if (entry.hasObjectClass(ocSelfSignedCertRequest)) {
                    try {
                        this.certificateManager.generateSelfSignedCertificate(certAlias, TrustStoreBackend.getADSCertificateSubjectDN(), TrustStoreBackend.getADSCertificateValidity());
                        break block19;
                    }
                    catch (Exception e) {
                        Message message = BackendMessages.ERR_TRUSTSTORE_CANNOT_GENERATE_CERT.get(certAlias, this.trustStoreFile, StaticUtils.getExceptionMessage(e));
                        throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message, e);
                    }
                }
                List<Attribute> certAttrs = entry.getAttribute("ds-cfg-public-key-certificate");
                if (certAttrs == null) {
                    Message message = BackendMessages.ERR_TRUSTSTORE_ENTRY_MISSING_CERT_ATTR.get(String.valueOf(entryDN), "ds-cfg-public-key-certificate");
                    throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message);
                }
                if (certAttrs.size() != 1) {
                    Message message = BackendMessages.ERR_TRUSTSTORE_ENTRY_HAS_MULTIPLE_CERT_ATTRS.get(String.valueOf(entryDN), "ds-cfg-public-key-certificate");
                    throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message);
                }
                Attribute certAttr = certAttrs.get(0);
                Iterator<AttributeValue> i = certAttr.iterator();
                if (!i.hasNext()) {
                    Message message = BackendMessages.ERR_TRUSTSTORE_ENTRY_MISSING_CERT_VALUE.get(String.valueOf(entryDN), "ds-cfg-public-key-certificate");
                    throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message);
                }
                byte[] certBytes = i.next().getValueBytes();
                if (i.hasNext()) {
                    Message message = BackendMessages.ERR_TRUSTSTORE_ENTRY_HAS_MULTIPLE_CERT_VALUES.get(String.valueOf(entryDN), "ds-cfg-public-key-certificate");
                    throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message);
                }
                try {
                    File tempDir = StaticUtils.getFileForPath("config");
                    File tempFile = File.createTempFile(this.configuration.getBackendId(), certAlias, tempDir);
                    try {
                        FileOutputStream outputStream = new FileOutputStream(tempFile.getPath(), false);
                        try {
                            outputStream.write(certBytes);
                        }
                        finally {
                            outputStream.close();
                        }
                        this.certificateManager.addCertificate(certAlias, tempFile);
                    }
                    finally {
                        tempFile.delete();
                    }
                }
                catch (IOException e) {
                    Message message = BackendMessages.ERR_TRUSTSTORE_CANNOT_WRITE_CERT.get(certAlias, StaticUtils.getExceptionMessage(e));
                    throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message, e);
                }
            }
            catch (Exception e) {
                Message message = BackendMessages.ERR_TRUSTSTORE_CANNOT_ADD_CERT.get(certAlias, this.trustStoreFile, StaticUtils.getExceptionMessage(e));
                throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message, e);
            }
        }
    }

    private void deleteCertificate(DN entryDN) throws DirectoryException {
        AttributeType t = DirectoryServer.getAttributeType("ds-cfg-key-id", true);
        AttributeValue v = entryDN.getRDN().getAttributeValue(t);
        if (v == null) {
            Message message = BackendMessages.ERR_TRUSTSTORE_DN_DOES_NOT_SPECIFY_CERTIFICATE.get(String.valueOf(entryDN));
            throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, message, this.baseDN, null);
        }
        String certAlias = v.getStringValue();
        try {
            if (!this.certificateManager.aliasInUse(certAlias)) {
                Message message = BackendMessages.ERR_TRUSTSTORE_INVALID_BASE.get(String.valueOf(entryDN));
                throw new DirectoryException(ResultCode.NO_SUCH_OBJECT, message);
            }
            this.certificateManager.removeCertificate(certAlias);
        }
        catch (Exception e) {
            Message message = BackendMessages.ERR_TRUSTSTORE_CANNOT_DELETE_CERT.get(certAlias, this.trustStoreFile, StaticUtils.getExceptionMessage(e));
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message, e);
        }
    }

    private static int getADSCertificateValidity() {
        return 7300;
    }

    private static String getADSCertificateSubjectDN() throws UnknownHostException {
        String hostname = InetAddress.getLocalHost().getCanonicalHostName();
        return "cn=" + Rdn.escapeValue(hostname) + ",O=OpenDS Certificate";
    }

    private static char[] createKeystorePassword() {
        int pwdLength = 50;
        char[] pwd = new char[pwdLength];
        Random random = new Random();
        for (int pos = 0; pos < pwdLength; ++pos) {
            char nextChar;
            int type = TrustStoreBackend.getRandomInt(random, 3);
            pwd[pos] = nextChar = TrustStoreBackend.getRandomChar(random, type);
        }
        return pwd;
    }

    private static char getRandomChar(Random random, int type) {
        char generatedChar;
        int next = random.nextInt();
        switch (type) {
            case 0: {
                int d = next % 10;
                if (d < 0) {
                    d *= -1;
                }
                generatedChar = (char)(d + 48);
                break;
            }
            case 1: {
                int d = next % 26;
                if (d < 0) {
                    d *= -1;
                }
                generatedChar = (char)(d + 97);
                break;
            }
            default: {
                int d = next % 26;
                if (d < 0) {
                    d *= -1;
                }
                generatedChar = (char)(d + 65);
            }
        }
        return generatedChar;
    }

    private static int getRandomInt(Random random, int modulo) {
        return random.nextInt() & modulo;
    }

    public static void createPINFile(String path, String pin) throws IOException {
        FileWriter file = new FileWriter(path);
        PrintWriter out = new PrintWriter(file);
        out.println(pin);
        out.flush();
        out.close();
        if (FilePermission.canSetPermissions()) {
            try {
                if (!FilePermission.setPermissions(new File(path), new FilePermission(384))) {
                    Message message = BackendMessages.WARN_TRUSTSTORE_SET_PERMISSIONS_FAILED.get(path);
                    ErrorLogger.logError(message);
                }
            }
            catch (DirectoryException e) {
                Message message = BackendMessages.WARN_TRUSTSTORE_SET_PERMISSIONS_FAILED.get(path);
                ErrorLogger.logError(message);
            }
        }
    }

    private void generateInstanceCertificateIfAbsent() throws InitializationException {
        String certAlias = "ads-certificate";
        try {
            if (this.certificateManager.aliasInUse(certAlias)) {
                return;
            }
        }
        catch (Exception e) {
            Message message = BackendMessages.ERR_TRUSTSTORE_CANNOT_ADD_CERT.get(certAlias, this.trustStoreFile, StaticUtils.getExceptionMessage(e));
            throw new InitializationException(message, (Throwable)e);
        }
        try {
            this.certificateManager.generateSelfSignedCertificate(certAlias, TrustStoreBackend.getADSCertificateSubjectDN(), TrustStoreBackend.getADSCertificateValidity());
        }
        catch (Exception e) {
            Message message = BackendMessages.ERR_TRUSTSTORE_CANNOT_GENERATE_CERT.get(certAlias, this.trustStoreFile, StaticUtils.getExceptionMessage(e));
            throw new InitializationException(message, (Throwable)e);
        }
    }

    @Override
    public void preloadEntryCache() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Operation not supported.");
    }
}

