/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.backends.jeb;

import com.sleepycat.je.Cursor;
import com.sleepycat.je.CursorConfig;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.LockMode;
import com.sleepycat.je.OperationStatus;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.opends.messages.ExtensionMessages;
import org.opends.messages.Message;
import org.opends.server.api.DirectoryThread;
import org.opends.server.backends.jeb.BackendImpl;
import org.opends.server.backends.jeb.EntryContainer;
import org.opends.server.backends.jeb.ID2Entry;
import org.opends.server.backends.jeb.JebFormat;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.Entry;
import org.opends.server.util.StaticUtils;

class EntryCachePreloader {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private BackendImpl jeb;
    private AtomicBoolean interruptFlag = new AtomicBoolean(false);
    private AtomicLong processedEntries = new AtomicLong(0L);
    private static final long progressInterval = 5000L;
    public static final long PRELOAD_DEFAULT_SLEEP_TIME = 10000L;
    private static long syncSleepTime;
    public static final int PRELOAD_DEFAULT_QUEUE_CAPACITY = 128;
    private static int queueCapacity;
    private List<Thread> preloadThreads = Collections.synchronizedList(new LinkedList());
    private EntryCacheCollector collector = new EntryCacheCollector();
    private LinkedBlockingQueue<PreloadEntry> entryQueue;
    private static final int bytesPerMegabyte = 0x100000;

    public EntryCachePreloader(BackendImpl jeb) {
        syncSleepTime = Long.getLong("org.opends.server.entrycache.preload.sleep", 10000L);
        queueCapacity = Integer.getInteger("org.opends.server.entrycache.preload.queue", 128);
        this.entryQueue = new LinkedBlockingQueue(queueCapacity);
        this.jeb = jeb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void preload() {
        ErrorLogger.logError(ExtensionMessages.NOTE_CACHE_PRELOAD_PROGRESS_START.get(this.jeb.getBackendID()));
        this.collector.start();
        EntryCachePreloadWorker singleWorkerThread = new EntryCachePreloadWorker();
        singleWorkerThread.start();
        this.preloadThreads.add(singleWorkerThread);
        Timer timer = new Timer();
        TimerTask progressTask = new TimerTask(){

            public void run() {
                if (EntryCachePreloader.this.processedEntries.get() > 0L) {
                    long freeMemory = Runtime.getRuntime().freeMemory() / 0x100000L;
                    Message message = ExtensionMessages.NOTE_CACHE_PRELOAD_PROGRESS_REPORT.get(EntryCachePreloader.this.jeb.getBackendID(), EntryCachePreloader.this.processedEntries.get(), freeMemory);
                    ErrorLogger.logError(message);
                }
            }
        };
        timer.scheduleAtFixedRate(progressTask, 5000L, 5000L);
        long processedEntriesCycle = 0L;
        long processedEntriesDelta = 0L;
        long processedEntriesDeltaLow = 0L;
        long processedEntriesDeltaHigh = 0L;
        long lastKnownProcessedEntries = 0L;
        try {
            while (!this.entryQueue.isEmpty() || this.collector.isAlive()) {
                Thread.sleep(syncSleepTime);
                processedEntriesCycle = this.processedEntries.get();
                processedEntriesDelta = processedEntriesCycle - lastKnownProcessedEntries;
                lastKnownProcessedEntries = processedEntriesCycle;
                if (processedEntriesDelta > processedEntriesDeltaHigh) {
                    processedEntriesDeltaLow = processedEntriesDeltaHigh;
                    processedEntriesDeltaHigh = processedEntriesDelta;
                    EntryCachePreloadWorker workerThread = new EntryCachePreloadWorker();
                    workerThread.start();
                    this.preloadThreads.add(workerThread);
                }
                if (processedEntriesDelta >= processedEntriesDeltaLow) continue;
                processedEntriesDeltaHigh = processedEntriesDeltaLow;
                processedEntriesDeltaLow = processedEntriesDelta;
                if (this.preloadThreads.size() <= 1) continue;
                this.interruptFlag.set(true);
            }
            if (this.collector.isAlive()) {
                this.collector.join();
            }
            for (Thread workerThread : this.preloadThreads) {
                if (!workerThread.isAlive()) continue;
                workerThread.join();
            }
            timer.cancel();
            Message message = ExtensionMessages.NOTE_CACHE_PRELOAD_PROGRESS_DONE.get(this.jeb.getBackendID(), this.processedEntries.get());
            ErrorLogger.logError(message);
        }
        catch (InterruptedException ex) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, ex);
            }
            this.collector.interrupt();
            for (Thread thread : this.preloadThreads) {
                thread.interrupt();
            }
            ErrorLogger.logError(ExtensionMessages.WARN_CACHE_PRELOAD_INTERRUPTED.get(this.jeb.getBackendID()));
        }
        finally {
            timer.cancel();
        }
    }

    private class PreloadEntry {
        public byte[] entryBytes;
        public byte[] entryIDBytes;

        public PreloadEntry(byte[] entryBytes, byte[] entryIDBytes) {
            this.entryBytes = entryBytes;
            this.entryIDBytes = entryIDBytes;
        }
    }

    private class EntryCacheCollector
    extends DirectoryThread {
        public EntryCacheCollector() {
            super("Entry Cache Preload Collector");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void run() {
            Cursor cursor = null;
            ID2Entry id2entry = null;
            DatabaseEntry key = new DatabaseEntry();
            DatabaseEntry data = new DatabaseEntry();
            Collection<EntryContainer> entryContainers = EntryCachePreloader.this.jeb.getRootContainer().getEntryContainers();
            Iterator<EntryContainer> ecIterator = entryContainers.iterator();
            OperationStatus status = OperationStatus.SUCCESS;
            try {
                while (status == OperationStatus.SUCCESS) {
                    if (Thread.interrupted()) {
                        return;
                    }
                    try {
                        if (cursor == null) {
                            if (!ecIterator.hasNext()) return;
                            id2entry = ecIterator.next().getID2Entry();
                            if (id2entry == null) continue;
                            cursor = id2entry.openCursor(null, new CursorConfig());
                        }
                        if ((status = cursor.getNext(key, data, LockMode.DEFAULT)) != OperationStatus.SUCCESS) {
                            block23: {
                                if (cursor == null) continue;
                                try {
                                    cursor.close();
                                }
                                catch (DatabaseException de) {
                                    if (!DebugLogger.debugEnabled()) break block23;
                                    TRACER.debugCaught(DebugLogLevel.ERROR, de);
                                }
                            }
                            status = OperationStatus.SUCCESS;
                            cursor = null;
                            continue;
                        }
                        EntryCachePreloader.this.entryQueue.put(new PreloadEntry(data.getData(), key.getData()));
                    }
                    catch (InterruptedException e) {
                        if (cursor == null) return;
                        try {
                            cursor.close();
                            return;
                        }
                        catch (DatabaseException de) {
                            if (!DebugLogger.debugEnabled()) return;
                            TRACER.debugCaught(DebugLogLevel.ERROR, de);
                        }
                        return;
                    }
                    catch (Exception e) {
                        try {
                            if (!DebugLogger.debugEnabled()) continue;
                            TRACER.debugCaught(DebugLogLevel.ERROR, e);
                        }
                        catch (Throwable throwable) {
                            throw throwable;
                            return;
                        }
                    }
                }
            }
            finally {
                block24: {
                    if (cursor != null) {
                        try {
                            cursor.close();
                        }
                        catch (DatabaseException de) {
                            if (!DebugLogger.debugEnabled()) break block24;
                            TRACER.debugCaught(DebugLogLevel.ERROR, de);
                        }
                    }
                }
            }
        }
    }

    private class EntryCachePreloadWorker
    extends DirectoryThread {
        public EntryCachePreloadWorker() {
            super("Entry Cache Preload Worker");
        }

        public void run() {
            while (!EntryCachePreloader.this.entryQueue.isEmpty() || EntryCachePreloader.this.collector.isAlive()) {
                if (Thread.interrupted()) {
                    return;
                }
                if (EntryCachePreloader.this.interruptFlag.compareAndSet(true, false)) {
                    EntryCachePreloader.this.preloadThreads.remove(Thread.currentThread());
                    break;
                }
                try {
                    PreloadEntry preloadEntry = (PreloadEntry)EntryCachePreloader.this.entryQueue.poll();
                    if (preloadEntry == null) continue;
                    long entryID = JebFormat.entryIDFromDatabase(preloadEntry.entryIDBytes);
                    Entry entry = JebFormat.entryFromDatabase(preloadEntry.entryBytes, EntryCachePreloader.this.jeb.getRootContainer().getCompressedSchema());
                    try {
                        DirectoryServer.getEntryCache().putEntry(entry, EntryCachePreloader.this.jeb, entryID);
                        EntryCachePreloader.this.processedEntries.getAndIncrement();
                    }
                    catch (Exception ex) {
                        if (DebugLogger.debugEnabled()) {
                            TRACER.debugCaught(DebugLogLevel.ERROR, ex);
                        }
                        Message message = ExtensionMessages.ERR_CACHE_PRELOAD_ENTRY_FAILED.get(entry.getDN().toNormalizedString(), ex.getCause() != null ? ex.getCause().getMessage() : StaticUtils.stackTraceToSingleLineString(ex));
                        ErrorLogger.logError(message);
                    }
                }
                catch (Exception ex) {
                    break;
                }
            }
        }
    }
}

