/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.backends.jeb;

import com.sleepycat.je.Cursor;
import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseConfig;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.DeadlockException;
import com.sleepycat.je.Environment;
import com.sleepycat.je.LockMode;
import com.sleepycat.je.OperationStatus;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.opends.messages.JebMessages;
import org.opends.messages.Message;
import org.opends.server.api.CompressedSchema;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.protocols.asn1.ASN1Element;
import org.opends.server.protocols.asn1.ASN1Exception;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.protocols.asn1.ASN1Sequence;
import org.opends.server.types.Attribute;
import org.opends.server.types.AttributeBuilder;
import org.opends.server.types.AttributeType;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.Attributes;
import org.opends.server.types.ByteArray;
import org.opends.server.types.ByteString;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.ObjectClass;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JECompressedSchema
extends CompressedSchema {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    public static final String DB_NAME_AD = "compressed_attributes";
    public static final String DB_NAME_OC = "compressed_object_classes";
    private AtomicInteger adCounter;
    private AtomicInteger ocCounter;
    private ConcurrentHashMap<ByteArray, AttributeType> atDecodeMap;
    private ConcurrentHashMap<ByteArray, Set<String>> aoDecodeMap;
    private ConcurrentHashMap<ByteArray, Map<ObjectClass, String>> ocDecodeMap;
    private ConcurrentHashMap<AttributeType, ConcurrentHashMap<Set<String>, ByteArray>> adEncodeMap;
    private ConcurrentHashMap<Map<ObjectClass, String>, ByteArray> ocEncodeMap;
    private Database adDatabase;
    private Database ocDatabase;
    private Environment environment;

    public JECompressedSchema(Environment environment) throws DatabaseException {
        this.environment = environment;
        this.atDecodeMap = new ConcurrentHashMap();
        this.aoDecodeMap = new ConcurrentHashMap();
        this.ocDecodeMap = new ConcurrentHashMap();
        this.adEncodeMap = new ConcurrentHashMap();
        this.ocEncodeMap = new ConcurrentHashMap();
        this.adCounter = new AtomicInteger(1);
        this.ocCounter = new AtomicInteger(1);
        this.load();
    }

    private void load() throws DatabaseException {
        DatabaseConfig dbConfig = new DatabaseConfig();
        if (this.environment.getConfig().getReadOnly()) {
            dbConfig.setReadOnly(true);
            dbConfig.setAllowCreate(false);
            dbConfig.setTransactional(false);
        } else if (!this.environment.getConfig().getTransactional()) {
            dbConfig.setAllowCreate(true);
            dbConfig.setTransactional(false);
            dbConfig.setDeferredWrite(true);
        } else {
            dbConfig.setAllowCreate(true);
            dbConfig.setTransactional(true);
        }
        this.adDatabase = this.environment.openDatabase(null, DB_NAME_AD, dbConfig);
        this.ocDatabase = this.environment.openDatabase(null, DB_NAME_OC, dbConfig);
        Cursor ocCursor = this.ocDatabase.openCursor(null, null);
        int highestToken = 0;
        try {
            DatabaseEntry keyEntry = new DatabaseEntry();
            DatabaseEntry valueEntry = new DatabaseEntry();
            OperationStatus status = ocCursor.getFirst(keyEntry, valueEntry, LockMode.READ_UNCOMMITTED);
            while (status == OperationStatus.SUCCESS) {
                ByteArray token = new ByteArray(keyEntry.getData());
                highestToken = Math.max(highestToken, this.decodeInt(token.array()));
                ArrayList<ASN1Element> elements = ASN1Sequence.decodeAsSequence(valueEntry.getData()).elements();
                LinkedHashMap<ObjectClass, String> ocMap = new LinkedHashMap<ObjectClass, String>(elements.size());
                for (int i = 0; i < elements.size(); ++i) {
                    ASN1OctetString os = elements.get(i).decodeAsOctetString();
                    String ocName = os.stringValue();
                    String lowerName = StaticUtils.toLowerCase(ocName);
                    ObjectClass oc = DirectoryServer.getObjectClass(lowerName, true);
                    ocMap.put(oc, ocName);
                }
                this.ocEncodeMap.put(ocMap, token);
                this.ocDecodeMap.put(token, ocMap);
                status = ocCursor.getNext(keyEntry, valueEntry, LockMode.READ_UNCOMMITTED);
            }
        }
        catch (ASN1Exception ae) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, ae);
            }
            Message m = JebMessages.ERR_JEB_COMPSCHEMA_CANNOT_DECODE_OC_TOKEN.get(ae.getMessage());
            throw new DatabaseException(m.toString(), (Throwable)ae);
        }
        finally {
            ocCursor.close();
        }
        this.ocCounter.set(highestToken + 1);
        Cursor adCursor = this.adDatabase.openCursor(null, null);
        highestToken = 0;
        try {
            DatabaseEntry keyEntry = new DatabaseEntry();
            DatabaseEntry valueEntry = new DatabaseEntry();
            OperationStatus status = adCursor.getFirst(keyEntry, valueEntry, LockMode.READ_UNCOMMITTED);
            while (status == OperationStatus.SUCCESS) {
                ByteArray token = new ByteArray(keyEntry.getData());
                highestToken = Math.max(highestToken, this.decodeInt(token.array()));
                ArrayList<ASN1Element> elements = ASN1Sequence.decodeAsSequence(valueEntry.getData()).elements();
                ASN1OctetString os = elements.get(0).decodeAsOctetString();
                String attrName = os.stringValue();
                String lowerName = StaticUtils.toLowerCase(attrName);
                AttributeType attrType = DirectoryServer.getAttributeType(lowerName, true);
                LinkedHashSet<String> options = new LinkedHashSet<String>(elements.size() - 1);
                for (int i = 1; i < elements.size(); ++i) {
                    os = elements.get(i).decodeAsOctetString();
                    options.add(os.stringValue());
                }
                this.atDecodeMap.put(token, attrType);
                this.aoDecodeMap.put(token, options);
                ConcurrentHashMap<Set<String>, ByteArray> map = this.adEncodeMap.get(attrType);
                if (map == null) {
                    map = new ConcurrentHashMap(1);
                    map.put(options, token);
                    this.adEncodeMap.put(attrType, map);
                } else {
                    map.put(options, token);
                }
                status = adCursor.getNext(keyEntry, valueEntry, LockMode.READ_UNCOMMITTED);
            }
        }
        catch (ASN1Exception ae) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, ae);
            }
            Message m = JebMessages.ERR_JEB_COMPSCHEMA_CANNOT_DECODE_AD_TOKEN.get(ae.getMessage());
            throw new DatabaseException(m.toString(), (Throwable)ae);
        }
        finally {
            adCursor.close();
        }
        this.adCounter.set(highestToken + 1);
    }

    public void close() {
        try {
            this.adDatabase.sync();
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.adDatabase.close();
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.ocDatabase.sync();
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.ocDatabase.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.adDatabase = null;
        this.ocDatabase = null;
        this.environment = null;
        this.atDecodeMap = null;
        this.aoDecodeMap = null;
        this.ocDecodeMap = null;
        this.adEncodeMap = null;
        this.ocEncodeMap = null;
        this.adCounter = null;
        this.ocCounter = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] encodeObjectClasses(Map<ObjectClass, String> objectClasses) throws DirectoryException {
        ByteArray encodedClasses = this.ocEncodeMap.get(objectClasses);
        if (encodedClasses == null) {
            ConcurrentHashMap<Map<ObjectClass, String>, ByteArray> concurrentHashMap = this.ocEncodeMap;
            synchronized (concurrentHashMap) {
                int setValue = this.ocCounter.getAndIncrement();
                byte[] tokenArray = this.encodeInt(setValue);
                ArrayList<ASN1Element> elements = new ArrayList<ASN1Element>(objectClasses.size());
                for (String ocName : objectClasses.values()) {
                    elements.add(new ASN1OctetString(ocName));
                }
                byte[] encodedOCs = new ASN1Sequence(elements).encode();
                this.store(this.ocDatabase, tokenArray, encodedOCs);
                encodedClasses = new ByteArray(tokenArray);
                this.ocEncodeMap.put(objectClasses, encodedClasses);
                this.ocDecodeMap.put(encodedClasses, objectClasses);
                return tokenArray;
            }
        }
        return encodedClasses.array();
    }

    @Override
    public Map<ObjectClass, String> decodeObjectClasses(byte[] encodedObjectClasses) throws DirectoryException {
        ByteArray byteArray = new ByteArray(encodedObjectClasses);
        Map<ObjectClass, String> ocMap = this.ocDecodeMap.get(byteArray);
        if (ocMap == null) {
            Message message = JebMessages.ERR_JEB_COMPSCHEMA_UNKNOWN_OC_TOKEN.get(StaticUtils.bytesToHex(encodedObjectClasses));
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message);
        }
        return ocMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] encodeAttribute(Attribute attribute) throws DirectoryException {
        AttributeType type = attribute.getAttributeType();
        Set<String> options = attribute.getOptions();
        ConcurrentHashMap<Set<String>, ByteArray> map = this.adEncodeMap.get(type);
        if (map == null) {
            byte[] tokenArray;
            ConcurrentHashMap<AttributeType, ConcurrentHashMap<Set<String>, ByteArray>> concurrentHashMap = this.adEncodeMap;
            synchronized (concurrentHashMap) {
                map = new ConcurrentHashMap(1);
                int intValue = this.adCounter.getAndIncrement();
                tokenArray = this.encodeInt(intValue);
                ByteArray byteArray = new ByteArray(tokenArray);
                map.put(options, byteArray);
                ArrayList<ASN1Element> elements = new ArrayList<ASN1Element>(options.size() + 1);
                elements.add(new ASN1OctetString(attribute.getName()));
                for (String option : options) {
                    elements.add(new ASN1OctetString(option));
                }
                byte[] encodedValue = new ASN1Sequence(elements).encode();
                this.store(this.adDatabase, tokenArray, encodedValue);
                this.adEncodeMap.put(type, map);
                this.atDecodeMap.put(byteArray, type);
                this.aoDecodeMap.put(byteArray, options);
            }
            return this.encodeAttribute(tokenArray, attribute);
        }
        ByteArray byteArray = map.get(options);
        if (byteArray == null) {
            byte[] tokenArray;
            ConcurrentHashMap<Set<String>, ByteArray> concurrentHashMap = map;
            synchronized (concurrentHashMap) {
                int intValue = this.adCounter.getAndIncrement();
                tokenArray = this.encodeInt(intValue);
                byteArray = new ByteArray(tokenArray);
                map.put(options, byteArray);
                ArrayList<ASN1Element> elements = new ArrayList<ASN1Element>(options.size() + 1);
                elements.add(new ASN1OctetString(attribute.getName()));
                for (String option : options) {
                    elements.add(new ASN1OctetString(option));
                }
                byte[] encodedValue = new ASN1Sequence(elements).encode();
                this.store(this.adDatabase, tokenArray, encodedValue);
                this.atDecodeMap.put(byteArray, type);
                this.aoDecodeMap.put(byteArray, options);
            }
            return this.encodeAttribute(tokenArray, attribute);
        }
        return this.encodeAttribute(byteArray.array(), attribute);
    }

    private byte[] encodeAttribute(byte[] adArray, Attribute attribute) {
        int totalValuesLength = 0;
        byte[][] subArrays = new byte[attribute.size() * 2][];
        int pos = 0;
        for (AttributeValue v : attribute) {
            byte[] vBytes = v.getValueBytes();
            byte[] lBytes = ASN1Element.encodeLength(vBytes.length);
            subArrays[pos++] = lBytes;
            subArrays[pos++] = vBytes;
            totalValuesLength += lBytes.length + vBytes.length;
        }
        byte[] adArrayLength = ASN1Element.encodeLength(adArray.length);
        byte[] countBytes = ASN1Element.encodeLength(attribute.size());
        int totalLength = adArrayLength.length + adArray.length + countBytes.length + totalValuesLength;
        byte[] array = new byte[totalLength];
        System.arraycopy(adArrayLength, 0, array, 0, adArrayLength.length);
        pos = adArrayLength.length;
        System.arraycopy(adArray, 0, array, pos, adArray.length);
        System.arraycopy(countBytes, 0, array, pos += adArray.length, countBytes.length);
        pos += countBytes.length;
        for (int i = 0; i < subArrays.length; ++i) {
            System.arraycopy(subArrays[i], 0, array, pos, subArrays[i].length);
            pos += subArrays[i].length;
        }
        return array;
    }

    @Override
    public Attribute decodeAttribute(byte[] encodedEntry, int startPos, int length) throws DirectoryException {
        int i;
        int pos = startPos;
        int adArrayLength = encodedEntry[pos] & 0x7F;
        if (adArrayLength != encodedEntry[pos++]) {
            int numLengthBytes = adArrayLength;
            adArrayLength = 0;
            int i2 = 0;
            while (i2 < numLengthBytes) {
                adArrayLength = adArrayLength << 8 | encodedEntry[pos] & 0xFF;
                ++i2;
                ++pos;
            }
        }
        ByteArray adArray = new ByteArray(new byte[adArrayLength]);
        System.arraycopy(encodedEntry, pos, adArray.array(), 0, adArrayLength);
        pos += adArrayLength;
        AttributeType attrType = this.atDecodeMap.get(adArray);
        Set<String> options = this.aoDecodeMap.get(adArray);
        if (attrType == null || options == null) {
            Message message = JebMessages.ERR_JEB_COMPSCHEMA_UNRECOGNIZED_AD_TOKEN.get(StaticUtils.bytesToHex(adArray.array()));
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message);
        }
        int numValues = encodedEntry[pos] & 0x7F;
        if (numValues != encodedEntry[pos++]) {
            int numValuesBytes = numValues;
            numValues = 0;
            i = 0;
            while (i < numValuesBytes) {
                numValues = numValues << 8 | encodedEntry[pos] & 0xFF;
                ++i;
                ++pos;
            }
        }
        if (numValues == 1 && options.isEmpty()) {
            int valueLength = encodedEntry[pos] & 0x7F;
            if (valueLength != encodedEntry[pos++]) {
                int valueLengthBytes = valueLength;
                valueLength = 0;
                int j = 0;
                while (j < valueLengthBytes) {
                    valueLength = valueLength << 8 | encodedEntry[pos] & 0xFF;
                    ++j;
                    ++pos;
                }
            }
            byte[] valueBytes = new byte[valueLength];
            System.arraycopy(encodedEntry, pos, valueBytes, 0, valueLength);
            return Attributes.create(attrType, new AttributeValue(attrType, (ByteString)new ASN1OctetString(valueBytes)));
        }
        AttributeBuilder builder = new AttributeBuilder(attrType);
        builder.setOptions(options);
        builder.setInitialCapacity(numValues);
        for (i = 0; i < numValues; ++i) {
            int valueLength = encodedEntry[pos] & 0x7F;
            if (valueLength != encodedEntry[pos++]) {
                int valueLengthBytes = valueLength;
                valueLength = 0;
                int j = 0;
                while (j < valueLengthBytes) {
                    valueLength = valueLength << 8 | encodedEntry[pos] & 0xFF;
                    ++j;
                    ++pos;
                }
            }
            byte[] valueBytes = new byte[valueLength];
            System.arraycopy(encodedEntry, pos, valueBytes, 0, valueLength);
            pos += valueLength;
            builder.add(new AttributeValue(attrType, (ByteString)new ASN1OctetString(valueBytes)));
        }
        return builder.toAttribute();
    }

    private void store(Database database, byte[] keyBytes, byte[] valueBytes) throws DirectoryException {
        boolean successful = false;
        DatabaseEntry keyEntry = new DatabaseEntry(keyBytes);
        DatabaseEntry valueEntry = new DatabaseEntry(valueBytes);
        for (int i = 0; i < 3; ++i) {
            try {
                OperationStatus status = database.putNoOverwrite(null, keyEntry, valueEntry);
                if (status != OperationStatus.SUCCESS) {
                    Message m = JebMessages.ERR_JEB_COMPSCHEMA_CANNOT_STORE_STATUS.get(status.toString());
                    throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), m);
                }
                successful = true;
                break;
            }
            catch (DeadlockException de) {
                continue;
            }
            catch (DatabaseException de) {
                Message m = JebMessages.ERR_JEB_COMPSCHEMA_CANNOT_STORE_EX.get(de.getMessage());
                throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), m, de);
            }
        }
        if (!successful) {
            Message m = JebMessages.ERR_JEB_COMPSCHEMA_CANNOT_STORE_MULTIPLE_FAILURES.get();
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), m);
        }
    }

    private byte[] encodeInt(int intValue) {
        byte[] array = intValue <= 255 ? new byte[]{(byte)(intValue & 0xFF)} : (intValue <= 65535 ? new byte[]{(byte)(intValue >> 8 & 0xFF), (byte)(intValue & 0xFF)} : (intValue <= 0xFFFFFF ? new byte[]{(byte)(intValue >> 16 & 0xFF), (byte)(intValue >> 8 & 0xFF), (byte)(intValue & 0xFF)} : new byte[]{(byte)(intValue >> 24 & 0xFF), (byte)(intValue >> 16 & 0xFF), (byte)(intValue >> 8 & 0xFF), (byte)(intValue & 0xFF)}));
        return array;
    }

    private int decodeInt(byte[] byteArray) {
        int intValue = 0;
        for (byte b : byteArray) {
            intValue <<= 8;
            intValue |= b & 0xFF;
        }
        return intValue;
    }
}

