/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.backends.jeb;

import com.sleepycat.je.Cursor;
import com.sleepycat.je.CursorConfig;
import com.sleepycat.je.DatabaseConfig;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.Environment;
import com.sleepycat.je.LockMode;
import com.sleepycat.je.OperationStatus;
import com.sleepycat.je.Transaction;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicInteger;
import org.opends.messages.JebMessages;
import org.opends.messages.Message;
import org.opends.server.admin.server.ConfigurationChangeListener;
import org.opends.server.admin.std.server.LocalDBVLVIndexCfg;
import org.opends.server.api.OrderingMatchingRule;
import org.opends.server.backends.jeb.DatabaseContainer;
import org.opends.server.backends.jeb.EntryContainer;
import org.opends.server.backends.jeb.EntryID;
import org.opends.server.backends.jeb.EntryIDSet;
import org.opends.server.backends.jeb.IndexBuffer;
import org.opends.server.backends.jeb.JebException;
import org.opends.server.backends.jeb.JebFormat;
import org.opends.server.backends.jeb.SortValues;
import org.opends.server.backends.jeb.SortValuesSet;
import org.opends.server.backends.jeb.State;
import org.opends.server.backends.jeb.VLVKeyComparator;
import org.opends.server.config.ConfigException;
import org.opends.server.controls.ServerSideSortRequestControl;
import org.opends.server.controls.VLVRequestControl;
import org.opends.server.controls.VLVResponseControl;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.SearchOperation;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.protocols.asn1.ASN1Element;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.types.Attribute;
import org.opends.server.types.AttributeType;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.ByteString;
import org.opends.server.types.ConfigChangeResult;
import org.opends.server.types.DN;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.Entry;
import org.opends.server.types.Modification;
import org.opends.server.types.ResultCode;
import org.opends.server.types.SearchFilter;
import org.opends.server.types.SearchScope;
import org.opends.server.types.SortKey;
import org.opends.server.types.SortOrder;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VLVIndex
extends DatabaseContainer
implements ConfigurationChangeListener<LocalDBVLVIndexCfg> {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    public VLVKeyComparator comparator;
    private int sortedSetCapacity = 4000;
    private AtomicInteger count;
    private State state;
    private boolean trusted = false;
    private boolean rebuildRunning = false;
    private LocalDBVLVIndexCfg config;
    private DN baseDN;
    private SearchFilter filter;
    private SearchScope scope;
    public SortOrder sortOrder;

    public VLVIndex(LocalDBVLVIndexCfg config, State state, Environment env, EntryContainer entryContainer) throws DatabaseException, ConfigException {
        super(entryContainer.getDatabasePrefix() + "_vlv." + config.getName(), env, entryContainer);
        this.config = config;
        this.baseDN = config.getBaseDN();
        this.scope = SearchScope.valueOf(config.getScope().name());
        this.sortedSetCapacity = config.getMaxBlockSize();
        try {
            this.filter = SearchFilter.createFilterFromString(config.getFilter());
        }
        catch (Exception e) {
            Message msg = JebMessages.ERR_JEB_CONFIG_VLV_INDEX_BAD_FILTER.get(config.getFilter(), this.name, StaticUtils.stackTraceToSingleLineString(e));
            throw new ConfigException(msg);
        }
        String[] sortAttrs = config.getSortOrder().split(" ");
        SortKey[] sortKeys = new SortKey[sortAttrs.length];
        OrderingMatchingRule[] orderingRules = new OrderingMatchingRule[sortAttrs.length];
        boolean[] ascending = new boolean[sortAttrs.length];
        for (int i = 0; i < sortAttrs.length; ++i) {
            try {
                if (sortAttrs[i].startsWith("-")) {
                    ascending[i] = false;
                    sortAttrs[i] = sortAttrs[i].substring(1);
                } else {
                    ascending[i] = true;
                    if (sortAttrs[i].startsWith("+")) {
                        sortAttrs[i] = sortAttrs[i].substring(1);
                    }
                }
            }
            catch (Exception e) {
                Message msg = JebMessages.ERR_JEB_CONFIG_VLV_INDEX_UNDEFINED_ATTR.get(String.valueOf(sortKeys[i]), this.name);
                throw new ConfigException(msg);
            }
            AttributeType attrType = DirectoryServer.getAttributeType(sortAttrs[i].toLowerCase());
            if (attrType == null) {
                Message msg = JebMessages.ERR_JEB_CONFIG_VLV_INDEX_UNDEFINED_ATTR.get(sortAttrs[i], this.name);
                throw new ConfigException(msg);
            }
            sortKeys[i] = new SortKey(attrType, ascending[i]);
            orderingRules[i] = attrType.getOrderingMatchingRule();
        }
        this.sortOrder = new SortOrder(sortKeys);
        this.comparator = new VLVKeyComparator(orderingRules, ascending);
        DatabaseConfig dbNodupsConfig = new DatabaseConfig();
        if (env.getConfig().getReadOnly()) {
            dbNodupsConfig.setReadOnly(true);
            dbNodupsConfig.setAllowCreate(false);
            dbNodupsConfig.setTransactional(false);
        } else if (!env.getConfig().getTransactional()) {
            dbNodupsConfig.setAllowCreate(true);
            dbNodupsConfig.setTransactional(false);
            dbNodupsConfig.setDeferredWrite(true);
        } else {
            dbNodupsConfig.setAllowCreate(true);
            dbNodupsConfig.setTransactional(true);
        }
        this.dbConfig = dbNodupsConfig;
        this.dbConfig.setOverrideBtreeComparator(true);
        this.dbConfig.setBtreeComparator((Comparator)this.comparator);
        this.state = state;
        this.trusted = state.getIndexTrustState(null, this);
        if (!this.trusted && entryContainer.getHighestEntryID().equals(new EntryID(0L))) {
            this.setTrusted(null, true);
        }
        this.count = new AtomicInteger(0);
        this.config.addChangeListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void open() throws DatabaseException {
        super.open();
        DatabaseEntry key = new DatabaseEntry();
        LockMode lockMode = LockMode.RMW;
        DatabaseEntry data = new DatabaseEntry();
        Cursor cursor = this.openCursor(null, CursorConfig.READ_COMMITTED);
        try {
            OperationStatus status = cursor.getFirst(key, data, lockMode);
            while (status == OperationStatus.SUCCESS) {
                this.count.getAndAdd(SortValuesSet.getEncodedSize(data.getData(), 0));
                status = cursor.getNext(key, data, lockMode);
            }
        }
        finally {
            cursor.close();
        }
    }

    @Override
    public void close() throws DatabaseException {
        super.close();
        this.config.removeChangeListener(this);
    }

    public boolean addEntry(Transaction txn, EntryID entryID, Entry entry) throws DatabaseException, DirectoryException, JebException {
        DN entryDN = entry.getDN();
        if (entryDN.matchesBaseAndScope(this.baseDN, this.scope) && this.filter.matchesEntry(entry)) {
            return this.insertValues(txn, entryID.longValue(), entry);
        }
        return false;
    }

    public boolean addEntry(IndexBuffer buffer, EntryID entryID, Entry entry) throws DirectoryException {
        DN entryDN = entry.getDN();
        if (entryDN.matchesBaseAndScope(this.baseDN, this.scope) && this.filter.matchesEntry(entry)) {
            SortValues sortValues = new SortValues(entryID, entry, this.sortOrder);
            IndexBuffer.BufferedVLVValues bufferedValues = buffer.getVLVIndex(this);
            if (bufferedValues == null) {
                bufferedValues = new IndexBuffer.BufferedVLVValues();
                buffer.putBufferedVLVIndex(this, bufferedValues);
            }
            if (bufferedValues.deletedValues != null && bufferedValues.deletedValues.contains(sortValues)) {
                bufferedValues.deletedValues.remove(sortValues);
                return true;
            }
            TreeSet<SortValues> bufferedAddedValues = bufferedValues.addedValues;
            if (bufferedAddedValues == null) {
                bufferedValues.addedValues = bufferedAddedValues = new TreeSet();
            }
            bufferedAddedValues.add(sortValues);
            return true;
        }
        return false;
    }

    public boolean removeEntry(Transaction txn, EntryID entryID, Entry entry) throws DatabaseException, DirectoryException, JebException {
        DN entryDN = entry.getDN();
        if (entryDN.matchesBaseAndScope(this.baseDN, this.scope) && this.filter.matchesEntry(entry)) {
            return this.removeValues(txn, entryID.longValue(), entry);
        }
        return false;
    }

    public boolean removeEntry(IndexBuffer buffer, EntryID entryID, Entry entry) throws DirectoryException {
        DN entryDN = entry.getDN();
        if (entryDN.matchesBaseAndScope(this.baseDN, this.scope) && this.filter.matchesEntry(entry)) {
            SortValues sortValues = new SortValues(entryID, entry, this.sortOrder);
            IndexBuffer.BufferedVLVValues bufferedValues = buffer.getVLVIndex(this);
            if (bufferedValues == null) {
                bufferedValues = new IndexBuffer.BufferedVLVValues();
                buffer.putBufferedVLVIndex(this, bufferedValues);
            }
            if (bufferedValues.addedValues != null && bufferedValues.addedValues.contains(sortValues)) {
                bufferedValues.addedValues.remove(sortValues);
                return true;
            }
            TreeSet<SortValues> bufferedDeletedValues = bufferedValues.deletedValues;
            if (bufferedDeletedValues == null) {
                bufferedValues.deletedValues = bufferedDeletedValues = new TreeSet();
            }
            bufferedDeletedValues.add(sortValues);
            return true;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean modifyEntry(Transaction txn, EntryID entryID, Entry oldEntry, Entry newEntry, List<Modification> mods) throws DatabaseException, DirectoryException, JebException {
        DN oldEntryDN = oldEntry.getDN();
        DN newEntryDN = newEntry.getDN();
        if (oldEntryDN.matchesBaseAndScope(this.baseDN, this.scope) && this.filter.matchesEntry(oldEntry)) {
            SortKey[] sortKeys;
            if (!newEntryDN.matchesBaseAndScope(this.baseDN, this.scope) || !this.filter.matchesEntry(newEntry)) return this.removeValues(txn, entryID.longValue(), oldEntry);
            boolean sortAttributeModified = false;
            for (SortKey sortKey : sortKeys = this.sortOrder.getSortKeys()) {
                AttributeType attributeType = sortKey.getAttributeType();
                Iterable<AttributeType> subTypes = DirectoryServer.getSchema().getSubTypes(attributeType);
                block1: for (Modification mod : mods) {
                    AttributeType modAttrType = mod.getAttribute().getAttributeType();
                    if (modAttrType.equals(attributeType)) {
                        sortAttributeModified = true;
                        break;
                    }
                    for (AttributeType subType : subTypes) {
                        if (!modAttrType.equals(subType)) continue;
                        sortAttributeModified = true;
                        continue block1;
                    }
                }
                if (sortAttributeModified) break;
            }
            if (!sortAttributeModified) return true;
            boolean success = this.removeValues(txn, entryID.longValue(), oldEntry);
            return success &= this.insertValues(txn, entryID.longValue(), newEntry);
        }
        if (!newEntryDN.matchesBaseAndScope(this.baseDN, this.scope) || !this.filter.matchesEntry(newEntry)) return true;
        return this.insertValues(txn, entryID.longValue(), newEntry);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean modifyEntry(IndexBuffer buffer, EntryID entryID, Entry oldEntry, Entry newEntry, List<Modification> mods) throws DatabaseException, DirectoryException {
        DN oldEntryDN = oldEntry.getDN();
        DN newEntryDN = newEntry.getDN();
        if (oldEntryDN.matchesBaseAndScope(this.baseDN, this.scope) && this.filter.matchesEntry(oldEntry)) {
            SortKey[] sortKeys;
            if (!newEntryDN.matchesBaseAndScope(this.baseDN, this.scope) || !this.filter.matchesEntry(newEntry)) return this.removeEntry(buffer, entryID, oldEntry);
            boolean sortAttributeModified = false;
            for (SortKey sortKey : sortKeys = this.sortOrder.getSortKeys()) {
                AttributeType attributeType = sortKey.getAttributeType();
                Iterable<AttributeType> subTypes = DirectoryServer.getSchema().getSubTypes(attributeType);
                block1: for (Modification mod : mods) {
                    AttributeType modAttrType = mod.getAttribute().getAttributeType();
                    if (modAttrType.equals(attributeType)) {
                        sortAttributeModified = true;
                        break;
                    }
                    for (AttributeType subType : subTypes) {
                        if (!modAttrType.equals(subType)) continue;
                        sortAttributeModified = true;
                        continue block1;
                    }
                }
                if (sortAttributeModified) break;
            }
            if (!sortAttributeModified) return true;
            boolean success = this.removeEntry(buffer, entryID, oldEntry);
            return success &= this.addEntry(buffer, entryID, newEntry);
        }
        if (!newEntryDN.matchesBaseAndScope(this.baseDN, this.scope) || !this.filter.matchesEntry(newEntry)) return true;
        return this.addEntry(buffer, entryID, newEntry);
    }

    public boolean putSortValuesSet(Transaction txn, SortValuesSet sortValuesSet) throws JebException, DatabaseException, DirectoryException {
        DatabaseEntry key = new DatabaseEntry();
        DatabaseEntry data = new DatabaseEntry();
        byte[] after = sortValuesSet.toDatabase();
        key.setData(sortValuesSet.getKeyBytes());
        data.setData(after);
        return this.put(txn, key, data) == OperationStatus.SUCCESS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SortValuesSet getSortValuesSet(Transaction txn, long entryID, AttributeValue[] values) throws DatabaseException, DirectoryException {
        SortValuesSet sortValuesSet = null;
        DatabaseEntry key = new DatabaseEntry();
        LockMode lockMode = LockMode.DEFAULT;
        DatabaseEntry data = new DatabaseEntry();
        Cursor cursor = this.openCursor(txn, CursorConfig.READ_COMMITTED);
        try {
            key.setData(this.encodeKey(entryID, values));
            OperationStatus status = cursor.getSearchKeyRange(key, data, lockMode);
            if (status != OperationStatus.SUCCESS) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugVerbose("No sort values set exist in VLV vlvIndex %s. Creating unbound set.", this.config.getName());
                }
                sortValuesSet = new SortValuesSet(this);
            } else {
                if (DebugLogger.debugEnabled()) {
                    StringBuilder searchKeyHex = new StringBuilder();
                    StaticUtils.byteArrayToHexPlusAscii(searchKeyHex, key.getData(), 4);
                    StringBuilder foundKeyHex = new StringBuilder();
                    StaticUtils.byteArrayToHexPlusAscii(foundKeyHex, key.getData(), 4);
                    TRACER.debugVerbose("Retrieved a sort values set in VLV vlvIndex %s\nSearch Key:%s\nFound Key:%s\n", this.config.getName(), searchKeyHex, foundKeyHex);
                }
                sortValuesSet = new SortValuesSet(key.getData(), data.getData(), this);
            }
        }
        finally {
            cursor.close();
        }
        return sortValuesSet;
    }

    public boolean containsValues(Transaction txn, long entryID, AttributeValue[] values) throws JebException, DatabaseException, DirectoryException {
        SortValuesSet valuesSet = this.getSortValuesSet(txn, entryID, values);
        int pos = valuesSet.binarySearch(entryID, values);
        return pos >= 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean insertValues(Transaction txn, long entryID, Entry entry) throws JebException, DatabaseException, DirectoryException {
        SortValuesSet sortValuesSet;
        OperationStatus status;
        AttributeValue[] values = this.getSortValues(entry);
        DatabaseEntry key = new DatabaseEntry();
        LockMode lockMode = LockMode.RMW;
        DatabaseEntry data = new DatabaseEntry();
        boolean success = true;
        Cursor cursor = this.openCursor(txn, CursorConfig.READ_COMMITTED);
        try {
            key.setData(this.encodeKey(entryID, values));
            status = cursor.getSearchKeyRange(key, data, lockMode);
        }
        finally {
            cursor.close();
        }
        if (status != OperationStatus.SUCCESS) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugVerbose("No sort values set exist in VLV vlvIndex %s. Creating unbound set.", this.config.getName());
            }
            sortValuesSet = new SortValuesSet(this);
            key.setData(new byte[0]);
        } else {
            if (DebugLogger.debugEnabled()) {
                StringBuilder searchKeyHex = new StringBuilder();
                StaticUtils.byteArrayToHexPlusAscii(searchKeyHex, key.getData(), 4);
                StringBuilder foundKeyHex = new StringBuilder();
                StaticUtils.byteArrayToHexPlusAscii(foundKeyHex, key.getData(), 4);
                TRACER.debugVerbose("Retrieved a sort values set in VLV vlvIndex %s\nSearch Key:%s\nFound Key:%s\n", this.config.getName(), searchKeyHex, foundKeyHex);
            }
            sortValuesSet = new SortValuesSet(key.getData(), data.getData(), this);
        }
        success = sortValuesSet.add(entryID, values);
        int newSize = sortValuesSet.size();
        if (newSize >= this.sortedSetCapacity) {
            SortValuesSet splitSortValuesSet = sortValuesSet.split(newSize / 2);
            byte[] splitAfter = splitSortValuesSet.toDatabase();
            key.setData(splitSortValuesSet.getKeyBytes());
            data.setData(splitAfter);
            this.put(txn, key, data);
            byte[] after = sortValuesSet.toDatabase();
            key.setData(sortValuesSet.getKeyBytes());
            data.setData(after);
            this.put(txn, key, data);
            if (DebugLogger.debugEnabled()) {
                TRACER.debugInfo("SortValuesSet with key %s has reached the entry size of %d. Spliting into two sets with  keys %s and %s.", splitSortValuesSet.getKeySortValues(), newSize, sortValuesSet.getKeySortValues(), splitSortValuesSet.getKeySortValues());
            }
        } else {
            byte[] after = sortValuesSet.toDatabase();
            data.setData(after);
            this.put(txn, key, data);
        }
        if (success) {
            this.count.getAndIncrement();
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean removeValues(Transaction txn, long entryID, Entry entry) throws JebException, DatabaseException, DirectoryException {
        OperationStatus status;
        AttributeValue[] values = this.getSortValues(entry);
        DatabaseEntry key = new DatabaseEntry();
        LockMode lockMode = LockMode.RMW;
        DatabaseEntry data = new DatabaseEntry();
        Cursor cursor = this.openCursor(txn, CursorConfig.READ_COMMITTED);
        try {
            key.setData(this.encodeKey(entryID, values));
            status = cursor.getSearchKeyRange(key, data, lockMode);
        }
        finally {
            cursor.close();
        }
        if (status == OperationStatus.SUCCESS) {
            if (DebugLogger.debugEnabled()) {
                StringBuilder searchKeyHex = new StringBuilder();
                StaticUtils.byteArrayToHexPlusAscii(searchKeyHex, key.getData(), 4);
                StringBuilder foundKeyHex = new StringBuilder();
                StaticUtils.byteArrayToHexPlusAscii(foundKeyHex, key.getData(), 4);
                TRACER.debugVerbose("Retrieved a sort values set in VLV vlvIndex %s\nSearch Key:%s\nFound Key:%s\n", this.config.getName(), searchKeyHex, foundKeyHex);
            }
            SortValuesSet sortValuesSet = new SortValuesSet(key.getData(), data.getData(), this);
            boolean success = sortValuesSet.remove(entryID, values);
            byte[] after = sortValuesSet.toDatabase();
            if (after == null) {
                this.delete(txn, key);
            } else {
                data.setData(after);
                this.put(txn, key, data);
            }
            if (success) {
                this.count.getAndDecrement();
            }
            return success;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateIndex(Transaction txn, TreeSet<SortValues> addedValues, TreeSet<SortValues> deletedValues) throws DirectoryException, DatabaseException {
        if (!(addedValues != null && addedValues.size() != 0 || deletedValues != null && deletedValues.size() != 0)) {
            return;
        }
        DatabaseEntry key = new DatabaseEntry();
        LockMode lockMode = LockMode.RMW;
        DatabaseEntry data = new DatabaseEntry();
        Iterator<SortValues> aValues = null;
        Iterator<SortValues> dValues = null;
        SortValues av = null;
        SortValues dv = null;
        if (addedValues != null) {
            aValues = addedValues.iterator();
            av = aValues.next();
        }
        if (deletedValues != null) {
            dValues = deletedValues.iterator();
            dv = dValues.next();
        }
        while (true) {
            int newSize;
            SortValuesSet sortValuesSet;
            OperationStatus status;
            if (av != null) {
                if (dv != null) {
                    if (av.compareTo(dv) < 0) {
                        key.setData(this.encodeKey(av.getEntryID(), av.getValues()));
                    } else {
                        key.setData(this.encodeKey(dv.getEntryID(), dv.getValues()));
                    }
                } else {
                    key.setData(this.encodeKey(av.getEntryID(), av.getValues()));
                }
            } else {
                if (dv == null) break;
                key.setData(this.encodeKey(dv.getEntryID(), dv.getValues()));
            }
            Cursor cursor = this.openCursor(txn, CursorConfig.READ_COMMITTED);
            try {
                status = cursor.getSearchKeyRange(key, data, lockMode);
            }
            finally {
                cursor.close();
            }
            if (status != OperationStatus.SUCCESS) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugVerbose("No sort values set exist in VLV vlvIndex %s. Creating unbound set.", this.config.getName());
                }
                sortValuesSet = new SortValuesSet(this);
                key.setData(new byte[0]);
            } else {
                if (DebugLogger.debugEnabled()) {
                    StringBuilder searchKeyHex = new StringBuilder();
                    StaticUtils.byteArrayToHexPlusAscii(searchKeyHex, key.getData(), 4);
                    StringBuilder foundKeyHex = new StringBuilder();
                    StaticUtils.byteArrayToHexPlusAscii(foundKeyHex, key.getData(), 4);
                    TRACER.debugVerbose("Retrieved a sort values set in VLV vlvIndex %s\nSearch Key:%s\nFound Key:%s\n", this.config.getName(), searchKeyHex, foundKeyHex);
                }
                sortValuesSet = new SortValuesSet(key.getData(), data.getData(), this);
            }
            int oldSize = sortValuesSet.size();
            if (key.getData().length == 0) {
                while (av != null) {
                    sortValuesSet.add(av.getEntryID(), av.getValues());
                    aValues.remove();
                    if (aValues.hasNext()) {
                        av = aValues.next();
                        continue;
                    }
                    av = null;
                }
                while (dv != null) {
                    sortValuesSet.remove(dv.getEntryID(), dv.getValues());
                    dValues.remove();
                    if (dValues.hasNext()) {
                        dv = dValues.next();
                        continue;
                    }
                    dv = null;
                }
            } else {
                SortValues maxValues = this.decodeKey(sortValuesSet.getKeyBytes());
                while (av != null && av.compareTo(maxValues) <= 0) {
                    sortValuesSet.add(av.getEntryID(), av.getValues());
                    aValues.remove();
                    if (aValues.hasNext()) {
                        av = aValues.next();
                        continue;
                    }
                    av = null;
                }
                while (dv != null && dv.compareTo(maxValues) <= 0) {
                    sortValuesSet.remove(dv.getEntryID(), dv.getValues());
                    dValues.remove();
                    if (dValues.hasNext()) {
                        dv = dValues.next();
                        continue;
                    }
                    dv = null;
                }
            }
            if ((newSize = sortValuesSet.size()) >= this.sortedSetCapacity) {
                SortValuesSet splitSortValuesSet = sortValuesSet.split(newSize / 2);
                byte[] splitAfter = splitSortValuesSet.toDatabase();
                key.setData(splitSortValuesSet.getKeyBytes());
                data.setData(splitAfter);
                this.put(txn, key, data);
                byte[] after = sortValuesSet.toDatabase();
                key.setData(sortValuesSet.getKeyBytes());
                data.setData(after);
                this.put(txn, key, data);
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugInfo("SortValuesSet with key %s has reached the entry size of %d. Spliting into two sets with  keys %s and %s.", splitSortValuesSet.getKeySortValues(), newSize, sortValuesSet.getKeySortValues(), splitSortValuesSet.getKeySortValues());
                }
            } else if (newSize == 0) {
                this.delete(txn, key);
            } else {
                byte[] after = sortValuesSet.toDatabase();
                data.setData(after);
                this.put(txn, key, data);
            }
            this.count.getAndAdd(newSize - oldSize);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public EntryIDSet evaluate(Transaction txn, SearchOperation searchOperation, ServerSideSortRequestControl sortControl, VLVRequestControl vlvRequest, StringBuilder debugBuilder) throws DirectoryException, DatabaseException {
        if (!this.trusted || this.rebuildRunning) {
            return null;
        }
        if (!searchOperation.getBaseDN().equals(this.baseDN)) {
            return null;
        }
        if (!searchOperation.getScope().equals((Object)this.scope)) {
            return null;
        }
        if (!searchOperation.getFilter().equals(this.filter)) {
            return null;
        }
        if (!sortControl.getSortOrder().equals(this.sortOrder)) {
            return null;
        }
        if (debugBuilder != null) {
            debugBuilder.append("vlv=");
            debugBuilder.append("[INDEX:");
            debugBuilder.append(this.name.replace(this.entryContainer.getDatabasePrefix() + "_", ""));
            debugBuilder.append("]");
        }
        selectedIDs = new long[]{};
        if (vlvRequest != null) {
            currentCount = this.count.get();
            beforeCount = vlvRequest.getBeforeCount();
            afterCount = vlvRequest.getAfterCount();
            if (vlvRequest.getTargetType() == -96) {
                targetOffset = vlvRequest.getOffset();
                if (targetOffset < 0) {
                    searchOperation.addResponseControl(new VLVResponseControl(targetOffset, currentCount, 61));
                    message = JebMessages.ERR_ENTRYIDSORTER_NEGATIVE_START_POS.get();
                    throw new DirectoryException(ResultCode.VIRTUAL_LIST_VIEW_ERROR, message);
                }
                if (targetOffset == 0) {
                    targetOffset = 1;
                }
                if ((startPos = (listOffset = targetOffset - 1) - beforeCount) < 0) {
                    startPos = 0;
                    beforeCount = listOffset;
                } else if (startPos >= currentCount) {
                    targetOffset = currentCount + 1;
                    listOffset = currentCount;
                    startPos = listOffset - beforeCount;
                    afterCount = 0;
                }
                count = 1 + beforeCount + afterCount;
                selectedIDs = new long[count];
                key = new DatabaseEntry();
                lockMode = LockMode.DEFAULT;
                data = new DatabaseEntry();
                cursor = this.openCursor(txn, CursorConfig.READ_COMMITTED);
                try {
                    cursorCount = 0;
                    selectedPos = 0;
                    status = cursor.getFirst(key, data, lockMode);
                    while (status == OperationStatus.SUCCESS) {
                        if (DebugLogger.debugEnabled()) {
                            searchKeyHex = new StringBuilder();
                            StaticUtils.byteArrayToHexPlusAscii(searchKeyHex, key.getData(), 4);
                            foundKeyHex = new StringBuilder();
                            StaticUtils.byteArrayToHexPlusAscii(foundKeyHex, key.getData(), 4);
                            VLVIndex.TRACER.debugVerbose("Retrieved a sort values set in VLV vlvIndex %s\nSearch Key:%s\nFound Key:%s\n", new Object[]{this.config.getName(), searchKeyHex, foundKeyHex});
                        }
                        IDs = SortValuesSet.getEncodedIDs(data.getData(), 0);
                        for (i = startPos + selectedPos - cursorCount; i < IDs.length && selectedPos < count; ++i, ++selectedPos) {
                            selectedIDs[selectedPos] = IDs[i];
                        }
                        cursorCount += IDs.length;
                        status = cursor.getNext(key, data, lockMode);
                    }
                    if (selectedPos < count) {
                        newIDArray = new long[selectedPos];
                        System.arraycopy(selectedIDs, 0, newIDArray, 0, selectedPos);
                        selectedIDs = newIDArray;
                    }
                    searchOperation.addResponseControl(new VLVResponseControl(targetOffset, currentCount, 0));
                    if (debugBuilder == null) ** GOTO lbl194
                    debugBuilder.append("[COUNT:");
                    debugBuilder.append(cursorCount);
                    debugBuilder.append("]");
                }
                finally {
                    cursor.close();
                }
            } else {
                targetOffset = 0;
                includedBeforeCount = 0;
                includedAfterCount = 0;
                idList = new LinkedList<EntryID>();
                key = new DatabaseEntry();
                lockMode = LockMode.DEFAULT;
                data = new DatabaseEntry();
                cursor = this.openCursor(txn, CursorConfig.READ_COMMITTED);
                try {
                    vBytes = vlvRequest.getGreaterThanOrEqualAssertion().value();
                    vLength = ASN1Element.encodeLength(vBytes.length);
                    keyBytes = new byte[vBytes.length + vLength.length];
                    System.arraycopy(vLength, 0, keyBytes, 0, vLength.length);
                    System.arraycopy(vBytes, 0, keyBytes, vLength.length, vBytes.length);
                    key.setData(keyBytes);
                    status = cursor.getSearchKeyRange(key, data, lockMode);
                    if (status != OperationStatus.SUCCESS) ** GOTO lbl194
                    if (DebugLogger.debugEnabled()) {
                        searchKeyHex = new StringBuilder();
                        StaticUtils.byteArrayToHexPlusAscii(searchKeyHex, key.getData(), 4);
                        foundKeyHex = new StringBuilder();
                        StaticUtils.byteArrayToHexPlusAscii(foundKeyHex, key.getData(), 4);
                        VLVIndex.TRACER.debugVerbose("Retrieved a sort values set in VLV vlvIndex %s\nSearch Key:%s\nFound Key:%s\n", new Object[]{this.config.getName(), searchKeyHex, foundKeyHex});
                    }
                    if ((adjustedTargetOffset = (sortValuesSet = new SortValuesSet(key.getData(), data.getData(), this)).binarySearch(-1L, assertionValue = new AttributeValue[]{new AttributeValue(this.sortOrder.getSortKeys()[0].getAttributeType(), vlvRequest.getGreaterThanOrEqualAssertion())})) < 0) {
                        adjustedTargetOffset = -(adjustedTargetOffset + 1);
                    }
                    targetOffset = adjustedTargetOffset;
                    lastOffset = adjustedTargetOffset - 1;
                    lastIDs = sortValuesSet.getEntryIDs();
                    while (true) lbl-1000:
                    // 4 sources

                    {
                        for (i = lastOffset; i >= 0 && includedBeforeCount < beforeCount; ++includedBeforeCount, --i) {
                            idList.addFirst(new EntryID(lastIDs[i]));
                        }
                        status = cursor.getPrev(key, data, lockMode);
                        if (status != OperationStatus.SUCCESS) break;
                        if (includedBeforeCount < beforeCount) {
                            lastIDs = SortValuesSet.getEncodedIDs(data.getData(), 0);
                            lastOffset = lastIDs.length - 1;
                            targetOffset += lastIDs.length;
                            ** continue;
                        }
                        targetOffset += SortValuesSet.getEncodedSize(data.getData(), 0);
                    }
                    key.setData(sortValuesSet.getKeyBytes());
                    cursor.getSearchKey(key, data, lockMode);
                    lastOffset = adjustedTargetOffset;
                    lastIDs = sortValuesSet.getEntryIDs();
                    afterIDCount = 0;
                    while (true) {
                        for (i = lastOffset; i < lastIDs.length && includedAfterCount < afterCount + 1; ++includedAfterCount, ++i) {
                            idList.addLast(new EntryID(lastIDs[i]));
                        }
                        if (includedAfterCount >= afterCount + 1 || (status = cursor.getNext(key, data, lockMode)) != OperationStatus.SUCCESS) break;
                        lastIDs = SortValuesSet.getEncodedIDs(data.getData(), 0);
                        lastOffset = 0;
                        afterIDCount += lastIDs.length;
                    }
                    selectedIDs = new long[idList.size()];
                    idIterator = idList.iterator();
                    for (i = 0; i < selectedIDs.length; ++i) {
                        selectedIDs[i] = ((EntryID)idIterator.next()).longValue();
                    }
                    searchOperation.addResponseControl(new VLVResponseControl(targetOffset + 1, currentCount, 0));
                    if (debugBuilder == null) ** GOTO lbl194
                    debugBuilder.append("[COUNT:");
                    debugBuilder.append(targetOffset + afterIDCount + 1);
                    debugBuilder.append("]");
                }
                finally {
                    cursor.close();
                }
            }
        } else {
            idSets = new LinkedList<long[]>();
            currentCount = 0;
            key = new DatabaseEntry();
            lockMode = LockMode.RMW;
            data = new DatabaseEntry();
            cursor = this.openCursor(txn, CursorConfig.READ_COMMITTED);
            try {
                status = cursor.getFirst(key, data, lockMode);
                while (status == OperationStatus.SUCCESS) {
                    if (DebugLogger.debugEnabled()) {
                        searchKeyHex = new StringBuilder();
                        StaticUtils.byteArrayToHexPlusAscii(searchKeyHex, key.getData(), 4);
                        foundKeyHex = new StringBuilder();
                        StaticUtils.byteArrayToHexPlusAscii(foundKeyHex, key.getData(), 4);
                        VLVIndex.TRACER.debugVerbose("Retrieved a sort values set in VLV vlvIndex %s\nSearch Key:%s\nFound Key:%s\n", new Object[]{this.config.getName(), searchKeyHex, foundKeyHex});
                    }
                    ids = SortValuesSet.getEncodedIDs(data.getData(), 0);
                    idSets.add(ids);
                    currentCount += ids.length;
                    status = cursor.getNext(key, data, lockMode);
                }
            }
            finally {
                cursor.close();
            }
            selectedIDs = new long[currentCount];
            pos = 0;
            for (long[] id : idSets) {
                System.arraycopy(id, 0, selectedIDs, pos, id.length);
                pos += id.length;
            }
            if (debugBuilder != null) {
                debugBuilder.append("[COUNT:");
                debugBuilder.append(currentCount);
                debugBuilder.append("]");
            }
        }
lbl194:
        // 8 sources

        return new EntryIDSet(selectedIDs, 0, selectedIDs.length);
    }

    public synchronized void setTrusted(Transaction txn, boolean trusted) throws DatabaseException {
        this.trusted = trusted;
        this.state.putIndexTrustState(txn, this, trusted);
    }

    public boolean isTrusted() {
        return this.trusted;
    }

    public synchronized void setRebuildStatus(boolean rebuildRunning) {
        this.rebuildRunning = rebuildRunning;
    }

    AttributeValue[] getSortValues(Entry entry) {
        SortKey[] sortKeys = this.sortOrder.getSortKeys();
        AttributeValue[] values = new AttributeValue[sortKeys.length];
        for (int i = 0; i < sortKeys.length; ++i) {
            SortKey sortKey = sortKeys[i];
            AttributeType attrType = sortKey.getAttributeType();
            List<Attribute> attrList = entry.getAttribute(attrType);
            if (attrList == null) continue;
            AttributeValue sortValue = null;
            for (Attribute a : attrList) {
                for (AttributeValue v : a) {
                    if (sortValue == null) {
                        sortValue = v;
                        continue;
                    }
                    if (sortKey.compareValues(v, sortValue) >= 0) continue;
                    sortValue = v;
                }
            }
            values[i] = sortValue;
        }
        return values;
    }

    byte[] encodeKey(long entryID, AttributeValue[] values) throws DirectoryException {
        int totalValueBytes = 0;
        LinkedList<byte[]> valueBytes = new LinkedList<byte[]>();
        for (AttributeValue v : values) {
            byte[] vBytes = v == null ? new byte[]{} : v.getNormalizedValueBytes();
            byte[] vLength = ASN1Element.encodeLength(vBytes.length);
            valueBytes.add(vLength);
            valueBytes.add(vBytes);
            totalValueBytes += vLength.length + vBytes.length;
        }
        byte[] entryIDBytes = JebFormat.entryIDToDatabase(entryID);
        byte[] attrBytes = new byte[entryIDBytes.length + totalValueBytes];
        int pos = 0;
        for (byte[] b : valueBytes) {
            System.arraycopy(b, 0, attrBytes, pos, b.length);
            pos += b.length;
        }
        System.arraycopy(entryIDBytes, 0, attrBytes, pos, entryIDBytes.length);
        return attrBytes;
    }

    SortValues decodeKey(byte[] keyBytes) throws DirectoryException {
        if (keyBytes == null || keyBytes.length == 0) {
            return null;
        }
        AttributeValue[] attributeValues = new AttributeValue[this.sortOrder.getSortKeys().length];
        int vBytesPos = 0;
        for (int i = 0; i < attributeValues.length; ++i) {
            int valueLength = keyBytes[vBytesPos] & 0x7F;
            if (valueLength != keyBytes[vBytesPos++]) {
                int valueLengthBytes = valueLength;
                valueLength = 0;
                int j = 0;
                while (j < valueLengthBytes) {
                    valueLength = valueLength << 8 | keyBytes[vBytesPos] & 0xFF;
                    ++j;
                    ++vBytesPos;
                }
            }
            if (valueLength == 0) {
                attributeValues[i] = null;
            } else {
                byte[] valueBytes = new byte[valueLength];
                System.arraycopy(keyBytes, vBytesPos, valueBytes, 0, valueLength);
                attributeValues[i] = new AttributeValue(this.sortOrder.getSortKeys()[i].getAttributeType(), (ByteString)new ASN1OctetString(valueBytes));
            }
            vBytesPos += valueLength;
        }
        long v = 0L;
        for (int i = vBytesPos; i < keyBytes.length; ++i) {
            v <<= 8;
            v |= (long)(keyBytes[i] & 0xFF);
        }
        return new SortValues(new EntryID(v), attributeValues, this.sortOrder);
    }

    public int getSortedSetCapacity() {
        return this.sortedSetCapacity;
    }

    public boolean shouldInclude(Entry entry) throws DirectoryException {
        DN entryDN = entry.getDN();
        return entryDN.matchesBaseAndScope(this.baseDN, this.scope) && this.filter.matchesEntry(entry);
    }

    @Override
    public synchronized boolean isConfigurationChangeAcceptable(LocalDBVLVIndexCfg cfg, List<Message> unacceptableReasons) {
        try {
            this.filter = SearchFilter.createFilterFromString(this.config.getFilter());
        }
        catch (Exception e) {
            Message msg = JebMessages.ERR_JEB_CONFIG_VLV_INDEX_BAD_FILTER.get(this.config.getFilter(), this.name, StaticUtils.stackTraceToSingleLineString(e));
            unacceptableReasons.add(msg);
            return false;
        }
        String[] sortAttrs = this.config.getSortOrder().split(" ");
        SortKey[] sortKeys = new SortKey[sortAttrs.length];
        OrderingMatchingRule[] orderingRules = new OrderingMatchingRule[sortAttrs.length];
        boolean[] ascending = new boolean[sortAttrs.length];
        for (int i = 0; i < sortAttrs.length; ++i) {
            try {
                if (sortAttrs[i].startsWith("-")) {
                    ascending[i] = false;
                    sortAttrs[i] = sortAttrs[i].substring(1);
                } else {
                    ascending[i] = true;
                    if (sortAttrs[i].startsWith("+")) {
                        sortAttrs[i] = sortAttrs[i].substring(1);
                    }
                }
            }
            catch (Exception e) {
                Message msg = JebMessages.ERR_JEB_CONFIG_VLV_INDEX_UNDEFINED_ATTR.get(String.valueOf(sortKeys[i]), this.name);
                unacceptableReasons.add(msg);
                return false;
            }
            AttributeType attrType = DirectoryServer.getAttributeType(sortAttrs[i].toLowerCase());
            if (attrType == null) {
                Message msg = JebMessages.ERR_JEB_CONFIG_VLV_INDEX_UNDEFINED_ATTR.get(sortAttrs[i], this.name);
                unacceptableReasons.add(msg);
                return false;
            }
            sortKeys[i] = new SortKey(attrType, ascending[i]);
            orderingRules[i] = attrType.getOrderingMatchingRule();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized ConfigChangeResult applyConfigurationChange(LocalDBVLVIndexCfg cfg) {
        ArrayList<Message> messages;
        boolean adminActionRequired;
        ResultCode resultCode;
        block28: {
            block25: {
                resultCode = ResultCode.SUCCESS;
                adminActionRequired = false;
                messages = new ArrayList<Message>();
                if (!this.config.getBaseDN().equals(cfg.getBaseDN())) {
                    this.baseDN = cfg.getBaseDN();
                    adminActionRequired = true;
                }
                if (!this.config.getScope().equals((Object)cfg.getScope())) {
                    this.scope = SearchScope.valueOf(cfg.getScope().name());
                    adminActionRequired = true;
                }
                if (this.config.getMaxBlockSize() != cfg.getMaxBlockSize()) {
                    this.sortedSetCapacity = cfg.getMaxBlockSize();
                    if (this.config.getMaxBlockSize() < cfg.getMaxBlockSize()) {
                        adminActionRequired = true;
                    }
                }
                if (!this.config.getFilter().equals(cfg.getFilter())) {
                    try {
                        this.filter = SearchFilter.createFilterFromString(cfg.getFilter());
                        adminActionRequired = true;
                    }
                    catch (Exception e) {
                        Message msg = JebMessages.ERR_JEB_CONFIG_VLV_INDEX_BAD_FILTER.get(this.config.getFilter(), this.name, StaticUtils.stackTraceToSingleLineString(e));
                        messages.add(msg);
                        if (resultCode != ResultCode.SUCCESS) break block25;
                        resultCode = ResultCode.INVALID_ATTRIBUTE_SYNTAX;
                    }
                }
            }
            if (!this.config.getSortOrder().equals(cfg.getMaxBlockSize())) {
                String[] sortAttrs = cfg.getSortOrder().split(" ");
                SortKey[] sortKeys = new SortKey[sortAttrs.length];
                OrderingMatchingRule[] orderingRules = new OrderingMatchingRule[sortAttrs.length];
                boolean[] ascending = new boolean[sortAttrs.length];
                for (int i = 0; i < sortAttrs.length; ++i) {
                    Message msg;
                    block26: {
                        try {
                            if (sortAttrs[i].startsWith("-")) {
                                ascending[i] = false;
                                sortAttrs[i] = sortAttrs[i].substring(1);
                            } else {
                                ascending[i] = true;
                                if (sortAttrs[i].startsWith("+")) {
                                    sortAttrs[i] = sortAttrs[i].substring(1);
                                }
                            }
                        }
                        catch (Exception e) {
                            msg = JebMessages.ERR_JEB_CONFIG_VLV_INDEX_UNDEFINED_ATTR.get(String.valueOf(String.valueOf(sortKeys[i])), this.name);
                            messages.add(msg);
                            if (resultCode != ResultCode.SUCCESS) break block26;
                            resultCode = ResultCode.INVALID_ATTRIBUTE_SYNTAX;
                        }
                    }
                    AttributeType attrType = DirectoryServer.getAttributeType(sortAttrs[i].toLowerCase());
                    if (attrType == null) {
                        msg = JebMessages.ERR_JEB_CONFIG_VLV_INDEX_UNDEFINED_ATTR.get(String.valueOf(String.valueOf(sortKeys[i])), this.name);
                        messages.add(msg);
                        if (resultCode == ResultCode.SUCCESS) {
                            resultCode = ResultCode.INVALID_ATTRIBUTE_SYNTAX;
                        }
                    }
                    sortKeys[i] = new SortKey(attrType, ascending[i]);
                    orderingRules[i] = attrType.getOrderingMatchingRule();
                }
                this.sortOrder = new SortOrder(sortKeys);
                this.comparator = new VLVKeyComparator(orderingRules, ascending);
                this.entryContainer.exclusiveLock.lock();
                try {
                    this.close();
                    this.dbConfig.setBtreeComparator((Comparator)this.comparator);
                    this.open();
                }
                catch (DatabaseException de) {
                    messages.add(Message.raw(StaticUtils.stackTraceToSingleLineString(de), new Object[0]));
                    if (resultCode == ResultCode.SUCCESS) {
                        resultCode = DirectoryServer.getServerErrorResultCode();
                    }
                }
                finally {
                    this.entryContainer.exclusiveLock.unlock();
                }
                adminActionRequired = true;
            }
            if (adminActionRequired) {
                this.trusted = false;
                Message message = JebMessages.NOTE_JEB_INDEX_ADD_REQUIRES_REBUILD.get(this.name);
                messages.add(message);
                try {
                    this.state.putIndexTrustState(null, this, false);
                }
                catch (DatabaseException de) {
                    messages.add(Message.raw(StaticUtils.stackTraceToSingleLineString(de), new Object[0]));
                    if (resultCode != ResultCode.SUCCESS) break block28;
                    resultCode = DirectoryServer.getServerErrorResultCode();
                }
            }
        }
        this.config = cfg;
        return new ConfigChangeResult(resultCode, adminActionRequired, messages);
    }
}

