/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.backends.jeb.importLDIF;

import com.sleepycat.je.dbi.MemoryBudget;
import org.opends.server.backends.jeb.EntryID;
import org.opends.server.backends.jeb.JebFormat;
import org.opends.server.backends.jeb.importLDIF.ImportIDSet;

public class IntegerImportIDSet
implements ImportIDSet {
    private boolean dirty = true;
    private static final int THIS_OVERHEAD = 25;
    private int[] array = null;
    private int count = 0;
    private boolean isDefined = true;
    private long undefinedSize = 0L;

    public IntegerImportIDSet() {
    }

    public IntegerImportIDSet(EntryID id) {
        this.array = new int[1];
        this.array[0] = (int)id.longValue();
        this.count = 1;
    }

    public void setEntryID(EntryID id) {
        if (this.array == null) {
            this.array = new int[1];
        }
        this.reset();
        this.array[0] = (int)id.longValue();
        this.count = 1;
    }

    public void reset() {
        this.count = 0;
        this.isDefined = true;
        this.undefinedSize = 0L;
        this.dirty = true;
    }

    public void setDirty(boolean dirty) {
        this.dirty = dirty;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public boolean isDefined() {
        return this.isDefined;
    }

    public long getUndefinedSize() {
        return this.undefinedSize;
    }

    public void setUndefined() {
        this.array = null;
        this.isDefined = false;
    }

    public int getMemorySize() {
        if (this.array != null) {
            return 25 + MemoryBudget.byteArraySize((int)(this.array.length * 4));
        }
        return 25;
    }

    public void merge(ImportIDSet importIDSet, int limit, boolean maintainCount) {
        if (!this.isDefined()) {
            if (maintainCount) {
                this.undefinedSize = importIDSet.isDefined() ? (this.undefinedSize += (long)importIDSet.size()) : (this.undefinedSize += importIDSet.getUndefinedSize());
            }
            return;
        }
        if (this.isDefined() && this.count + importIDSet.size() > limit) {
            this.isDefined = false;
            this.undefinedSize = maintainCount ? (long)(this.size() + importIDSet.size()) : Long.MAX_VALUE;
            this.array = null;
            this.count = 0;
        } else {
            this.addAll((IntegerImportIDSet)importIDSet);
        }
    }

    public void addEntryID(EntryID entryID, int limit, boolean maintainCount) {
        if (!this.isDefined()) {
            if (maintainCount) {
                ++this.undefinedSize;
            }
            return;
        }
        if (this.isDefined() && this.count + 1 > limit) {
            this.isDefined = false;
            this.array = null;
            this.undefinedSize = maintainCount ? (long)(this.count + 1) : Long.MAX_VALUE;
            this.count = 0;
        } else {
            this.add((int)entryID.longValue());
        }
    }

    private boolean mergeCount(byte[] dBbytes, ImportIDSet importIdSet, int limit) {
        boolean dbUndefined;
        boolean incrLimitCount = false;
        boolean bl = dbUndefined = (dBbytes[0] & 0x80) == 128;
        if (dbUndefined && !importIdSet.isDefined()) {
            this.undefinedSize = JebFormat.entryIDUndefinedSizeFromDatabase(dBbytes) + importIdSet.getUndefinedSize();
            this.isDefined = false;
        } else if (dbUndefined && importIdSet.isDefined()) {
            this.undefinedSize = JebFormat.entryIDUndefinedSizeFromDatabase(dBbytes) + (long)importIdSet.size();
            importIdSet.setUndefined();
            this.isDefined = false;
        } else if (!importIdSet.isDefined()) {
            int dbSize = JebFormat.entryIDListFromDatabase(dBbytes).length;
            this.undefinedSize = (long)dbSize + importIdSet.getUndefinedSize();
            this.isDefined = false;
            incrLimitCount = true;
        } else {
            this.array = JebFormat.intArrayFromDatabaseBytes(dBbytes);
            if (this.array.length + importIdSet.size() > limit) {
                this.undefinedSize = this.array.length + importIdSet.size();
                importIdSet.setUndefined();
                this.isDefined = false;
                incrLimitCount = true;
            } else {
                this.count = this.array.length;
                this.addAll((IntegerImportIDSet)importIdSet);
            }
        }
        return incrLimitCount;
    }

    public boolean merge(byte[] dBbytes, ImportIDSet importIdSet, int limit, boolean maintainCount) {
        boolean incrLimitCount = false;
        if (maintainCount) {
            incrLimitCount = this.mergeCount(dBbytes, importIdSet, limit);
        } else {
            boolean dbUndefined;
            boolean bl = dbUndefined = (dBbytes[0] & 0x80) == 128;
            if (dbUndefined) {
                this.isDefined = false;
                importIdSet.setUndefined();
                this.undefinedSize = Long.MAX_VALUE;
            } else if (!importIdSet.isDefined()) {
                this.isDefined = false;
                incrLimitCount = true;
                this.undefinedSize = Long.MAX_VALUE;
            } else {
                this.array = JebFormat.intArrayFromDatabaseBytes(dBbytes);
                if (this.array.length + importIdSet.size() > limit) {
                    this.isDefined = false;
                    incrLimitCount = true;
                    this.count = 0;
                    importIdSet.setUndefined();
                    this.undefinedSize = Long.MAX_VALUE;
                } else {
                    this.count = this.array.length;
                    this.addAll((IntegerImportIDSet)importIdSet);
                }
            }
        }
        return incrLimitCount;
    }

    private void addAll(IntegerImportIDSet that) {
        int bRemain;
        this.resize(this.count + that.count);
        if (that.count == 0) {
            return;
        }
        if (this.count == 0 || that.array[0] > this.array[this.count - 1]) {
            System.arraycopy(that.array, 0, this.array, this.count, that.count);
            this.count += that.count;
            return;
        }
        if (this.array[0] > that.array[that.count - 1]) {
            System.arraycopy(this.array, 0, this.array, that.count, this.count);
            System.arraycopy(that.array, 0, this.array, 0, that.count);
            this.count += that.count;
            return;
        }
        int destPos = IntegerImportIDSet.binarySearch(this.array, this.count, that.array[0]);
        if (destPos < 0) {
            destPos = -(destPos + 1);
        }
        int aCount = this.count - destPos;
        int aPos = destPos + that.count;
        int aEnd = aPos + aCount;
        System.arraycopy(this.array, destPos, this.array, aPos, aCount);
        if (this.array[aPos] > that.array[that.count - 1]) {
            System.arraycopy(that.array, 0, this.array, destPos, that.count);
            this.count += that.count;
            return;
        }
        int bPos = 0;
        while (aPos < aEnd && bPos < that.count) {
            if (this.array[aPos] < that.array[bPos]) {
                this.array[destPos++] = this.array[aPos++];
                continue;
            }
            if (this.array[aPos] > that.array[bPos]) {
                this.array[destPos++] = that.array[bPos++];
                continue;
            }
            this.array[destPos++] = this.array[aPos++];
            ++bPos;
        }
        int aRemain = aEnd - aPos;
        if (aRemain > 0) {
            System.arraycopy(this.array, aPos, this.array, destPos, aRemain);
            destPos += aRemain;
        }
        if ((bRemain = that.count - bPos) > 0) {
            System.arraycopy(that.array, bPos, this.array, destPos, bRemain);
            destPos += bRemain;
        }
        this.count = destPos;
    }

    public int size() {
        return this.count;
    }

    private boolean add(int v) {
        this.resize(this.count + 1);
        if (this.count == 0 || v > this.array[this.count - 1]) {
            this.array[this.count++] = v;
            return true;
        }
        int pos = IntegerImportIDSet.binarySearch(this.array, this.count, v);
        if (pos >= 0) {
            return false;
        }
        pos = -(pos + 1);
        System.arraycopy(this.array, pos, this.array, pos + 1, this.count - pos);
        this.array[pos] = v;
        ++this.count;
        return true;
    }

    private static int binarySearch(int[] a, int count, int key) {
        int low = 0;
        int high = count - 1;
        while (low <= high) {
            int mid = low + high >> 1;
            int midVal = a[mid];
            if (midVal < key) {
                low = mid + 1;
                continue;
            }
            if (midVal > key) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    private void resize(int size) {
        if (this.array == null) {
            this.array = new int[size];
        } else if (this.array.length < size) {
            int newSize;
            int n = newSize = this.array.length == 0 ? 1 : this.array.length;
            while ((newSize *= 2) < size) {
            }
            int[] newBytes = new int[newSize];
            System.arraycopy(this.array, 0, newBytes, 0, this.count);
            this.array = newBytes;
        }
    }

    public byte[] toDatabase() {
        if (this.isDefined) {
            return this.encode(null);
        }
        return JebFormat.entryIDUndefinedSizeToDatabase(this.undefinedSize);
    }

    private byte[] encode(byte[] bytes) {
        int encodedSize = this.count * 8;
        if (bytes == null || bytes.length < encodedSize) {
            bytes = new byte[encodedSize];
        }
        int pos = 0;
        for (int i = 0; i < this.count; ++i) {
            long v = (long)this.array[i] & 0xFFFFFFFFL;
            bytes[pos++] = (byte)(v >>> 56 & 0xFFL);
            bytes[pos++] = (byte)(v >>> 48 & 0xFFL);
            bytes[pos++] = (byte)(v >>> 40 & 0xFFL);
            bytes[pos++] = (byte)(v >>> 32 & 0xFFL);
            bytes[pos++] = (byte)(v >>> 24 & 0xFFL);
            bytes[pos++] = (byte)(v >>> 16 & 0xFFL);
            bytes[pos++] = (byte)(v >>> 8 & 0xFFL);
            bytes[pos++] = (byte)(v & 0xFFL);
        }
        return bytes;
    }
}

