/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.backends.task;

import java.util.Iterator;
import java.util.List;
import org.opends.messages.BackendMessages;
import org.opends.messages.Message;
import org.opends.server.backends.task.Task;
import org.opends.server.backends.task.TaskScheduler;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.types.Attribute;
import org.opends.server.types.AttributeType;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.DN;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.Entry;
import org.opends.server.types.InitializationException;
import org.opends.server.types.ResultCode;
import org.opends.server.util.StaticUtils;

public class RecurringTask {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private DN recurringTaskEntryDN;
    private Entry recurringTaskEntry;
    private String recurringTaskID;
    private String taskClassName;

    public RecurringTask(TaskScheduler taskScheduler, Entry recurringTaskEntry) throws DirectoryException {
        Task task;
        Class<?> taskClass;
        List<Attribute> attrList;
        this.recurringTaskEntry = recurringTaskEntry;
        this.recurringTaskEntryDN = recurringTaskEntry.getDN();
        AttributeType attrType = DirectoryServer.getAttributeType("ds-recurring-task-id".toLowerCase());
        if (attrType == null) {
            attrType = DirectoryServer.getDefaultAttributeType("ds-recurring-task-id");
        }
        if ((attrList = recurringTaskEntry.getAttribute(attrType)) == null || attrList.isEmpty()) {
            Message message = BackendMessages.ERR_RECURRINGTASK_NO_ID_ATTRIBUTE.get("ds-recurring-task-id");
            throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, message);
        }
        if (attrList.size() > 1) {
            Message message = BackendMessages.ERR_RECURRINGTASK_MULTIPLE_ID_TYPES.get("ds-recurring-task-id");
            throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, message);
        }
        Attribute attr = attrList.get(0);
        if (attr.isEmpty()) {
            Message message = BackendMessages.ERR_RECURRINGTASK_NO_ID.get("ds-recurring-task-id");
            throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, message);
        }
        Iterator<AttributeValue> iterator = attr.iterator();
        AttributeValue value = iterator.next();
        if (iterator.hasNext()) {
            Message message = BackendMessages.ERR_RECURRINGTASK_MULTIPLE_ID_VALUES.get("ds-recurring-task-id");
            throw new DirectoryException(ResultCode.OBJECTCLASS_VIOLATION, message);
        }
        this.recurringTaskID = value.getStringValue();
        attrType = DirectoryServer.getAttributeType("ds-recurring-task-class-name".toLowerCase());
        if (attrType == null) {
            attrType = DirectoryServer.getDefaultAttributeType("ds-recurring-task-class-name");
        }
        if ((attrList = recurringTaskEntry.getAttribute(attrType)) == null || attrList.isEmpty()) {
            Message message = BackendMessages.ERR_RECURRINGTASK_NO_CLASS_ATTRIBUTE.get("ds-recurring-task-class-name");
            throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, message);
        }
        if (attrList.size() > 0) {
            Message message = BackendMessages.ERR_RECURRINGTASK_MULTIPLE_CLASS_TYPES.get("ds-recurring-task-class-name");
            throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, message);
        }
        attr = attrList.get(0);
        if (attr.isEmpty()) {
            Message message = BackendMessages.ERR_RECURRINGTASK_NO_CLASS_VALUES.get("ds-recurring-task-class-name");
            throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, message);
        }
        iterator = attr.iterator();
        value = iterator.next();
        if (iterator.hasNext()) {
            Message message = BackendMessages.ERR_RECURRINGTASK_MULTIPLE_CLASS_VALUES.get("ds-recurring-task-class-name");
            throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, message);
        }
        this.taskClassName = value.getStringValue();
        try {
            taskClass = DirectoryServer.loadClass(this.taskClassName);
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = BackendMessages.ERR_RECURRINGTASK_CANNOT_LOAD_CLASS.get(String.valueOf(this.taskClassName), "ds-recurring-task-class-name", StaticUtils.getExceptionMessage(e));
            throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, message, e);
        }
        try {
            task = (Task)taskClass.newInstance();
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = BackendMessages.ERR_RECURRINGTASK_CANNOT_INSTANTIATE_CLASS_AS_TASK.get(String.valueOf(this.taskClassName), Task.class.getName());
            throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, message, e);
        }
        try {
            task.initializeTaskInternal(taskScheduler, recurringTaskEntry);
        }
        catch (InitializationException ie) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, ie);
            }
            Message message = BackendMessages.ERR_RECURRINGTASK_CANNOT_INITIALIZE_INTERNAL.get(String.valueOf(this.taskClassName), ie.getMessage());
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message, ie);
        }
        task.initializeTask();
    }

    public String getRecurringTaskID() {
        return this.recurringTaskID;
    }

    public DN getRecurringTaskEntryDN() {
        return this.recurringTaskEntryDN;
    }

    public Entry getRecurringTaskEntry() {
        return this.recurringTaskEntry;
    }

    public String getTaskClassName() {
        return this.taskClassName;
    }

    public Task scheduleNextIteration() {
        return null;
    }
}

