/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.core;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.opends.messages.CoreMessages;
import org.opends.messages.Message;
import org.opends.server.api.CompressedSchema;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.protocols.asn1.ASN1Element;
import org.opends.server.protocols.asn1.ASN1Integer;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.protocols.asn1.ASN1Reader;
import org.opends.server.protocols.asn1.ASN1Sequence;
import org.opends.server.protocols.asn1.ASN1Writer;
import org.opends.server.types.Attribute;
import org.opends.server.types.AttributeBuilder;
import org.opends.server.types.AttributeType;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.Attributes;
import org.opends.server.types.ByteArray;
import org.opends.server.types.ByteString;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.ObjectClass;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DefaultCompressedSchema
extends CompressedSchema {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private AtomicInteger adCounter;
    private AtomicInteger ocCounter;
    private ConcurrentHashMap<ByteArray, AttributeType> atDecodeMap = new ConcurrentHashMap();
    private ConcurrentHashMap<ByteArray, Set<String>> aoDecodeMap = new ConcurrentHashMap();
    private ConcurrentHashMap<ByteArray, Map<ObjectClass, String>> ocDecodeMap = new ConcurrentHashMap();
    private ConcurrentHashMap<AttributeType, ConcurrentHashMap<Set<String>, ByteArray>> adEncodeMap = new ConcurrentHashMap();
    private ConcurrentHashMap<Map<ObjectClass, String>, ByteArray> ocEncodeMap = new ConcurrentHashMap();

    public DefaultCompressedSchema() {
        this.adCounter = new AtomicInteger(1);
        this.ocCounter = new AtomicInteger(1);
        this.load();
    }

    private void load() {
        ASN1Reader reader = null;
        try {
            String lowerName;
            String path = DirectoryServer.getInstanceRoot() + File.separator + "config" + File.separator + "schematokens.dat";
            if (!new File(path).exists()) {
                return;
            }
            FileInputStream inputStream = new FileInputStream(path);
            reader = new ASN1Reader(inputStream);
            ASN1Sequence ocSequence = reader.readElement().decodeAsSequence();
            for (ASN1Element element : ocSequence.elements()) {
                ArrayList<ASN1Element> elements = element.decodeAsSequence().elements();
                ASN1OctetString os = elements.get(0).decodeAsOctetString();
                ByteArray token = new ByteArray(os.value());
                LinkedHashMap<ObjectClass, String> ocMap = new LinkedHashMap<ObjectClass, String>(elements.size() - 1);
                for (int i = 1; i < elements.size(); ++i) {
                    os = elements.get(i).decodeAsOctetString();
                    String ocName = os.stringValue();
                    lowerName = StaticUtils.toLowerCase(ocName);
                    ObjectClass oc = DirectoryServer.getObjectClass(lowerName, true);
                    ocMap.put(oc, ocName);
                }
                this.ocEncodeMap.put(ocMap, token);
                this.ocDecodeMap.put(token, ocMap);
            }
            ASN1Element counterElement = reader.readElement();
            this.ocCounter.set(counterElement.decodeAsInteger().intValue());
            ASN1Sequence adSequence = reader.readElement().decodeAsSequence();
            for (ASN1Element element : adSequence.elements()) {
                ArrayList<ASN1Element> elements = element.decodeAsSequence().elements();
                ASN1OctetString os = elements.get(0).decodeAsOctetString();
                ByteArray token = new ByteArray(os.value());
                os = elements.get(1).decodeAsOctetString();
                String attrName = os.stringValue();
                lowerName = StaticUtils.toLowerCase(attrName);
                AttributeType attrType = DirectoryServer.getAttributeType(lowerName, true);
                LinkedHashSet<String> options = new LinkedHashSet<String>(elements.size() - 2);
                for (int i = 2; i < elements.size(); ++i) {
                    os = elements.get(i).decodeAsOctetString();
                    options.add(os.stringValue());
                }
                this.atDecodeMap.put(token, attrType);
                this.aoDecodeMap.put(token, options);
                ConcurrentHashMap<Set<String>, ByteArray> map = this.adEncodeMap.get(attrType);
                if (map == null) {
                    map = new ConcurrentHashMap(1);
                    map.put(options, token);
                    this.adEncodeMap.put(attrType, map);
                    continue;
                }
                map.put(options, token);
            }
            counterElement = reader.readElement();
            this.adCounter.set(counterElement.decodeAsInteger().intValue());
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            throw new RuntimeException(e);
        }
        finally {
            block21: {
                try {
                    if (reader != null) {
                        reader.close();
                    }
                }
                catch (Exception e) {
                    if (!DebugLogger.debugEnabled()) break block21;
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
            }
        }
    }

    private void save() throws DirectoryException {
        ASN1Writer writer = null;
        try {
            String path = DirectoryServer.getInstanceRoot() + File.separator + "config" + File.separator + "schematokens.dat";
            String tempPath = path + ".tmp";
            FileOutputStream outputStream = new FileOutputStream(tempPath);
            writer = new ASN1Writer(outputStream);
            ArrayList<ASN1Element> ocElements = new ArrayList<ASN1Element>(this.ocDecodeMap.size());
            for (Map.Entry<ByteArray, Map<ObjectClass, String>> mapEntry : this.ocDecodeMap.entrySet()) {
                ByteArray token = mapEntry.getKey();
                Map<ObjectClass, String> ocMap = mapEntry.getValue();
                ArrayList<ASN1Element> elements = new ArrayList<ASN1Element>(ocMap.size() + 1);
                elements.add(new ASN1OctetString(token.array()));
                for (String ocName : ocMap.values()) {
                    elements.add(new ASN1OctetString(ocName));
                }
                ocElements.add(new ASN1Sequence(elements));
            }
            writer.writeElement(new ASN1Sequence(ocElements));
            writer.writeElement(new ASN1Integer(this.ocCounter.get()));
            ArrayList<ASN1Element> adElements = new ArrayList<ASN1Element>(this.atDecodeMap.size());
            for (ByteArray token : this.atDecodeMap.keySet()) {
                AttributeType attrType = this.atDecodeMap.get(token);
                Set<String> options = this.aoDecodeMap.get(token);
                ArrayList<ASN1Element> elements = new ArrayList<ASN1Element>(options.size() + 2);
                elements.add(new ASN1OctetString(token.array()));
                elements.add(new ASN1OctetString(attrType.getNameOrOID()));
                for (String option : options) {
                    elements.add(new ASN1OctetString(option));
                }
                adElements.add(new ASN1Sequence(elements));
            }
            writer.writeElement(new ASN1Sequence(adElements));
            writer.writeElement(new ASN1Integer(this.adCounter.get()));
            writer.close();
            File liveFile = new File(path);
            File tempFile = new File(tempPath);
            if (liveFile.exists()) {
                File saveFile = new File(liveFile.getAbsolutePath() + ".save");
                if (saveFile.exists()) {
                    saveFile.delete();
                }
                liveFile.renameTo(saveFile);
            }
            tempFile.renameTo(liveFile);
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = CoreMessages.ERR_COMPRESSEDSCHEMA_CANNOT_WRITE_UPDATED_DATA.get(StaticUtils.stackTraceToSingleLineString(e));
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message, e);
        }
        finally {
            block18: {
                try {
                    if (writer != null) {
                        writer.close();
                    }
                }
                catch (Exception e) {
                    if (!DebugLogger.debugEnabled()) break block18;
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] encodeObjectClasses(Map<ObjectClass, String> objectClasses) throws DirectoryException {
        ByteArray encodedClasses = this.ocEncodeMap.get(objectClasses);
        if (encodedClasses == null) {
            ConcurrentHashMap<Map<ObjectClass, String>, ByteArray> concurrentHashMap = this.ocEncodeMap;
            synchronized (concurrentHashMap) {
                int setValue = this.ocCounter.getAndIncrement();
                byte[] array = this.encodeInt(setValue);
                encodedClasses = new ByteArray(array);
                this.ocEncodeMap.put(objectClasses, encodedClasses);
                this.ocDecodeMap.put(encodedClasses, objectClasses);
                this.save();
                return array;
            }
        }
        return encodedClasses.array();
    }

    @Override
    public Map<ObjectClass, String> decodeObjectClasses(byte[] encodedObjectClasses) throws DirectoryException {
        ByteArray byteArray = new ByteArray(encodedObjectClasses);
        Map<ObjectClass, String> ocMap = this.ocDecodeMap.get(byteArray);
        if (ocMap == null) {
            Message message = CoreMessages.ERR_COMPRESSEDSCHEMA_UNKNOWN_OC_TOKEN.get(StaticUtils.bytesToHex(encodedObjectClasses));
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message);
        }
        return ocMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] encodeAttribute(Attribute attribute) throws DirectoryException {
        AttributeType type = attribute.getAttributeType();
        Set<String> options = attribute.getOptions();
        ConcurrentHashMap<Set<String>, ByteArray> map = this.adEncodeMap.get(type);
        if (map == null) {
            byte[] array;
            ConcurrentHashMap<AttributeType, ConcurrentHashMap<Set<String>, ByteArray>> concurrentHashMap = this.adEncodeMap;
            synchronized (concurrentHashMap) {
                map = new ConcurrentHashMap(1);
                int intValue = this.adCounter.getAndIncrement();
                array = this.encodeInt(intValue);
                ByteArray byteArray = new ByteArray(array);
                map.put(options, byteArray);
                this.adEncodeMap.put(type, map);
                this.atDecodeMap.put(byteArray, type);
                this.aoDecodeMap.put(byteArray, options);
                this.save();
            }
            return this.encodeAttribute(array, attribute);
        }
        ByteArray byteArray = map.get(options);
        if (byteArray == null) {
            byte[] array;
            ConcurrentHashMap<Set<String>, ByteArray> concurrentHashMap = map;
            synchronized (concurrentHashMap) {
                int intValue = this.adCounter.getAndIncrement();
                array = this.encodeInt(intValue);
                byteArray = new ByteArray(array);
                map.put(options, byteArray);
                this.atDecodeMap.put(byteArray, type);
                this.aoDecodeMap.put(byteArray, options);
                this.save();
            }
            return this.encodeAttribute(array, attribute);
        }
        return this.encodeAttribute(byteArray.array(), attribute);
    }

    private byte[] encodeAttribute(byte[] adArray, Attribute attribute) {
        int totalValuesLength = 0;
        byte[][] subArrays = new byte[attribute.size() * 2][];
        int pos = 0;
        for (AttributeValue v : attribute) {
            byte[] vBytes = v.getValueBytes();
            byte[] lBytes = ASN1Element.encodeLength(vBytes.length);
            subArrays[pos++] = lBytes;
            subArrays[pos++] = vBytes;
            totalValuesLength += lBytes.length + vBytes.length;
        }
        byte[] adArrayLength = ASN1Element.encodeLength(adArray.length);
        byte[] countBytes = ASN1Element.encodeLength(attribute.size());
        int totalLength = adArrayLength.length + adArray.length + countBytes.length + totalValuesLength;
        byte[] array = new byte[totalLength];
        System.arraycopy(adArrayLength, 0, array, 0, adArrayLength.length);
        pos = adArrayLength.length;
        System.arraycopy(adArray, 0, array, pos, adArray.length);
        System.arraycopy(countBytes, 0, array, pos += adArray.length, countBytes.length);
        pos += countBytes.length;
        for (int i = 0; i < subArrays.length; ++i) {
            System.arraycopy(subArrays[i], 0, array, pos, subArrays[i].length);
            pos += subArrays[i].length;
        }
        return array;
    }

    @Override
    public Attribute decodeAttribute(byte[] encodedEntry, int startPos, int length) throws DirectoryException {
        int i;
        int pos = startPos;
        int adArrayLength = encodedEntry[pos] & 0x7F;
        if (adArrayLength != encodedEntry[pos++]) {
            int numLengthBytes = adArrayLength;
            adArrayLength = 0;
            int i2 = 0;
            while (i2 < numLengthBytes) {
                adArrayLength = adArrayLength << 8 | encodedEntry[pos] & 0xFF;
                ++i2;
                ++pos;
            }
        }
        ByteArray adArray = new ByteArray(new byte[adArrayLength]);
        System.arraycopy(encodedEntry, pos, adArray.array(), 0, adArrayLength);
        pos += adArrayLength;
        AttributeType attrType = this.atDecodeMap.get(adArray);
        Set<String> options = this.aoDecodeMap.get(adArray);
        if (attrType == null || options == null) {
            Message message = CoreMessages.ERR_COMPRESSEDSCHEMA_UNRECOGNIZED_AD_TOKEN.get(StaticUtils.bytesToHex(adArray.array()));
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message);
        }
        int numValues = encodedEntry[pos] & 0x7F;
        if (numValues != encodedEntry[pos++]) {
            int numValuesBytes = numValues;
            numValues = 0;
            i = 0;
            while (i < numValuesBytes) {
                numValues = numValues << 8 | encodedEntry[pos] & 0xFF;
                ++i;
                ++pos;
            }
        }
        if (numValues == 1 && options.isEmpty()) {
            int valueLength = encodedEntry[pos] & 0x7F;
            if (valueLength != encodedEntry[pos++]) {
                int valueLengthBytes = valueLength;
                valueLength = 0;
                int j = 0;
                while (j < valueLengthBytes) {
                    valueLength = valueLength << 8 | encodedEntry[pos] & 0xFF;
                    ++j;
                    ++pos;
                }
            }
            byte[] valueBytes = new byte[valueLength];
            System.arraycopy(encodedEntry, pos, valueBytes, 0, valueLength);
            return Attributes.create(attrType, new AttributeValue(attrType, (ByteString)new ASN1OctetString(valueBytes)));
        }
        AttributeBuilder builder = new AttributeBuilder(attrType);
        builder.setOptions(options);
        builder.setInitialCapacity(numValues);
        for (i = 0; i < numValues; ++i) {
            int valueLength = encodedEntry[pos] & 0x7F;
            if (valueLength != encodedEntry[pos++]) {
                int valueLengthBytes = valueLength;
                valueLength = 0;
                int j = 0;
                while (j < valueLengthBytes) {
                    valueLength = valueLength << 8 | encodedEntry[pos] & 0xFF;
                    ++j;
                    ++pos;
                }
            }
            byte[] valueBytes = new byte[valueLength];
            System.arraycopy(encodedEntry, pos, valueBytes, 0, valueLength);
            pos += valueLength;
            builder.add(new AttributeValue(attrType, (ByteString)new ASN1OctetString(valueBytes)));
        }
        return builder.toAttribute();
    }

    private byte[] encodeInt(int intValue) {
        byte[] array = intValue <= 255 ? new byte[]{(byte)(intValue & 0xFF)} : (intValue <= 65535 ? new byte[]{(byte)(intValue >> 8 & 0xFF), (byte)(intValue & 0xFF)} : (intValue <= 0xFFFFFF ? new byte[]{(byte)(intValue >> 16 & 0xFF), (byte)(intValue >> 8 & 0xFF), (byte)(intValue & 0xFF)} : new byte[]{(byte)(intValue >> 24 & 0xFF), (byte)(intValue >> 16 & 0xFF), (byte)(intValue >> 8 & 0xFF), (byte)(intValue & 0xFF)}));
        return array;
    }
}

