/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.core;

import java.util.ArrayList;
import java.util.List;
import org.opends.messages.CoreMessages;
import org.opends.server.api.ClientConnection;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.PluginConfigManager;
import org.opends.server.core.UnbindOperation;
import org.opends.server.loggers.AccessLogger;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.types.AbstractOperation;
import org.opends.server.types.CancelResult;
import org.opends.server.types.Control;
import org.opends.server.types.DisconnectReason;
import org.opends.server.types.OperationType;
import org.opends.server.types.ResultCode;
import org.opends.server.types.operation.PostOperationUnbindOperation;
import org.opends.server.types.operation.PreParseUnbindOperation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnbindOperationBasis
extends AbstractOperation
implements UnbindOperation,
PreParseUnbindOperation,
PostOperationUnbindOperation {
    private static final DebugTracer TRACER = DebugLogger.getTracer();

    public UnbindOperationBasis(ClientConnection clientConnection, long operationID, int messageID, ArrayList<Control> requestControls) {
        super(clientConnection, operationID, messageID, requestControls);
        this.cancelResult = new CancelResult(ResultCode.CANNOT_CANCEL, CoreMessages.ERR_CANNOT_CANCEL_UNBIND.get());
    }

    @Override
    public final OperationType getOperationType() {
        return OperationType.UNBIND;
    }

    @Override
    public final String[][] getRequestLogElements() {
        return new String[0][];
    }

    @Override
    public final String[][] getResponseLogElements() {
        return new String[0][];
    }

    @Override
    public final List<Control> getResponseControls() {
        return NO_RESPONSE_CONTROLS;
    }

    @Override
    public final void addResponseControl(Control control) {
    }

    @Override
    public final void removeResponseControl(Control control) {
    }

    @Override
    public final void run() {
        PluginConfigManager pluginConfigManager = DirectoryServer.getPluginConfigManager();
        this.setProcessingStartTime();
        pluginConfigManager.invokePreParseUnbindPlugins(this);
        AccessLogger.logUnbind(this);
        this.getClientConnection().disconnect(DisconnectReason.UNBIND, false, null);
        pluginConfigManager.invokePostOperationUnbindPlugins(this);
        this.setProcessingStopTime();
    }

    @Override
    public final void toString(StringBuilder buffer) {
        buffer.append("UnbindOperation(connID=");
        buffer.append(this.clientConnection.getConnectionID());
        buffer.append(", opID=");
        buffer.append(this.operationID);
        buffer.append(")");
    }
}

