/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.core.networkgroups;

import java.util.ArrayList;
import java.util.Collection;
import org.opends.server.api.ClientConnection;
import org.opends.server.authorization.dseecompat.PatternDN;
import org.opends.server.core.networkgroups.NetworkGroupCriterion;
import org.opends.server.types.AuthenticationType;
import org.opends.server.types.DN;
import org.opends.server.types.DirectoryException;

public class BindDnCriteria
implements NetworkGroupCriterion {
    private Collection<PatternDN> patternDNs = new ArrayList<PatternDN>();

    public void addBindDnFilter(String filter) throws DirectoryException {
        this.patternDNs.add(PatternDN.decode(filter));
    }

    public boolean match(ClientConnection connection) {
        DN dn = connection.getAuthenticationInfo().getAuthenticationDN();
        return this.matchAfterBind(connection, dn, null, false);
    }

    public boolean matchAfterBind(ClientConnection connection, DN bindDN, AuthenticationType authType, boolean isSecure) {
        if (bindDN == null) {
            return false;
        }
        for (PatternDN patternDN : this.patternDNs) {
            if (!patternDN.matchesDN(bindDN)) continue;
            return true;
        }
        return false;
    }
}

