/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.extensions;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.security.sasl.SaslException;
import org.opends.messages.ExtensionMessages;
import org.opends.messages.Message;
import org.opends.server.admin.server.ConfigurationChangeListener;
import org.opends.server.admin.std.meta.DigestMD5SASLMechanismHandlerCfgDefn;
import org.opends.server.admin.std.server.DigestMD5SASLMechanismHandlerCfg;
import org.opends.server.admin.std.server.SASLMechanismHandlerCfg;
import org.opends.server.api.ClientConnection;
import org.opends.server.api.IdentityMapper;
import org.opends.server.api.SASLMechanismHandler;
import org.opends.server.config.ConfigException;
import org.opends.server.core.BindOperation;
import org.opends.server.core.DirectoryServer;
import org.opends.server.extensions.SASLContext;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.types.ConfigChangeResult;
import org.opends.server.types.DN;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.InitializationException;
import org.opends.server.types.ResultCode;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DigestMD5SASLMechanismHandler
extends SASLMechanismHandler<DigestMD5SASLMechanismHandlerCfg>
implements ConfigurationChangeListener<DigestMD5SASLMechanismHandlerCfg> {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private DigestMD5SASLMechanismHandlerCfg configuration;
    private IdentityMapper<?> identityMapper;
    private HashMap<String, String> saslProps;
    private String serverFQDN;
    private DN configEntryDN;
    private static final String REALM_PROPERTY = "com.sun.security.sasl.digest.realm";

    @Override
    public void initializeSASLMechanismHandler(DigestMD5SASLMechanismHandlerCfg configuration) throws ConfigException, InitializationException {
        configuration.addDigestMD5ChangeListener(this);
        this.configEntryDN = configuration.dn();
        try {
            DN identityMapperDN = configuration.getIdentityMapperDN();
            this.identityMapper = DirectoryServer.getIdentityMapper(identityMapperDN);
            this.serverFQDN = this.getFQDN(configuration);
            Message msg = ExtensionMessages.INFO_DIGEST_MD5_SERVER_FQDN.get(this.serverFQDN);
            ErrorLogger.logError(msg);
            String QOP = this.getQOP(configuration);
            this.saslProps = new HashMap();
            this.saslProps.put("javax.security.sasl.qop", QOP);
            String realm = this.getRealm(configuration);
            if (realm != null) {
                msg = ExtensionMessages.INFO_DIGEST_MD5_REALM.get(realm);
                ErrorLogger.logError(msg);
                this.saslProps.put(REALM_PROPERTY, this.getRealm(configuration));
            }
            this.configuration = configuration;
            DirectoryServer.registerSASLMechanismHandler("DIGEST-MD5", this);
        }
        catch (UnknownHostException unhe) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, unhe);
            }
            Message message = ExtensionMessages.ERR_SASL_CANNOT_GET_SERVER_FQDN.get(String.valueOf(this.configEntryDN), StaticUtils.getExceptionMessage(unhe));
            throw new InitializationException(message, (Throwable)unhe);
        }
    }

    @Override
    public void finalizeSASLMechanismHandler() {
        this.configuration.removeDigestMD5ChangeListener(this);
        DirectoryServer.deregisterSASLMechanismHandler("DIGEST-MD5");
    }

    @Override
    public void processSASLBind(BindOperation bindOp) {
        ClientConnection clientConnection = bindOp.getClientConnection();
        if (clientConnection == null) {
            Message message = ExtensionMessages.ERR_SASLGSSAPI_NO_CLIENT_CONNECTION.get();
            bindOp.setAuthFailureReason(message);
            bindOp.setResultCode(ResultCode.INVALID_CREDENTIALS);
            return;
        }
        ClientConnection clientConn = bindOp.getClientConnection();
        SASLContext saslContext = (SASLContext)clientConn.getSASLAuthStateInfo();
        if (saslContext == null) {
            try {
                saslContext = SASLContext.createSASLContext(this.saslProps, this.serverFQDN, "DIGEST-MD5", this.identityMapper);
            }
            catch (SaslException ex) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, ex);
                }
                Message msg = ExtensionMessages.ERR_SASL_CONTEXT_CREATE_ERROR.get("DIGEST-MD5", StaticUtils.getExceptionMessage(ex));
                clientConn.setSASLAuthStateInfo(null);
                bindOp.setAuthFailureReason(msg);
                bindOp.setResultCode(ResultCode.INVALID_CREDENTIALS);
                return;
            }
            saslContext.evaluateInitialStage(bindOp);
        } else {
            saslContext.evaluateFinalStage(bindOp);
        }
    }

    @Override
    public boolean isPasswordBased(String mechanism) {
        return true;
    }

    @Override
    public boolean isSecure(String mechanism) {
        return true;
    }

    @Override
    public boolean isConfigurationAcceptable(SASLMechanismHandlerCfg configuration, List<Message> unacceptableReasons) {
        DigestMD5SASLMechanismHandlerCfg config = (DigestMD5SASLMechanismHandlerCfg)configuration;
        return this.isConfigurationChangeAcceptable(config, unacceptableReasons);
    }

    @Override
    public boolean isConfigurationChangeAcceptable(DigestMD5SASLMechanismHandlerCfg configuration, List<Message> unacceptableReasons) {
        return true;
    }

    @Override
    public ConfigChangeResult applyConfigurationChange(DigestMD5SASLMechanismHandlerCfg configuration) {
        ResultCode resultCode = ResultCode.SUCCESS;
        boolean adminActionRequired = false;
        ArrayList<Message> messages = new ArrayList<Message>();
        try {
            DN identityMapperDN = configuration.getIdentityMapperDN();
            this.identityMapper = DirectoryServer.getIdentityMapper(identityMapperDN);
            this.serverFQDN = this.getFQDN(configuration);
            Message msg = ExtensionMessages.INFO_DIGEST_MD5_SERVER_FQDN.get(this.serverFQDN);
            ErrorLogger.logError(msg);
            String QOP = this.getQOP(configuration);
            this.saslProps = new HashMap();
            this.saslProps.put("javax.security.sasl.qop", QOP);
            String realm = this.getRealm(configuration);
            if (realm != null) {
                msg = ExtensionMessages.INFO_DIGEST_MD5_REALM.get(realm);
                ErrorLogger.logError(msg);
                this.saslProps.put(REALM_PROPERTY, this.getRealm(configuration));
            }
            this.configuration = configuration;
        }
        catch (UnknownHostException unhe) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, unhe);
            }
            resultCode = ResultCode.OPERATIONS_ERROR;
            messages.add(ExtensionMessages.ERR_SASL_CANNOT_GET_SERVER_FQDN.get(String.valueOf(this.configEntryDN), StaticUtils.getExceptionMessage(unhe)));
            return new ConfigChangeResult(resultCode, adminActionRequired, messages);
        }
        return new ConfigChangeResult(resultCode, adminActionRequired, messages);
    }

    private String getQOP(DigestMD5SASLMechanismHandlerCfg configuration) {
        DigestMD5SASLMechanismHandlerCfgDefn.QualityOfProtection QOP = configuration.getQualityOfProtection();
        if (QOP.equals((Object)DigestMD5SASLMechanismHandlerCfgDefn.QualityOfProtection.CONFIDENTIALITY)) {
            return "auth-conf";
        }
        if (QOP.equals((Object)DigestMD5SASLMechanismHandlerCfgDefn.QualityOfProtection.INTEGRITY)) {
            return "auth-int";
        }
        return "auth";
    }

    private String getFQDN(DigestMD5SASLMechanismHandlerCfg configuration) throws UnknownHostException {
        String serverName = configuration.getServerFqdn();
        if (serverName == null) {
            serverName = InetAddress.getLocalHost().getCanonicalHostName();
        }
        return serverName;
    }

    private String getRealm(DigestMD5SASLMechanismHandlerCfg configuration) {
        return configuration.getRealm();
    }
}

