/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.monitors;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.TreeMap;
import org.opends.server.admin.std.server.ClientConnectionMonitorProviderCfg;
import org.opends.server.api.ClientConnection;
import org.opends.server.api.ConnectionHandler;
import org.opends.server.api.MonitorProvider;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.types.Attribute;
import org.opends.server.types.AttributeBuilder;
import org.opends.server.types.AttributeType;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.InitializationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientConnectionMonitorProvider
extends MonitorProvider<ClientConnectionMonitorProviderCfg> {
    public ClientConnectionMonitorProvider() {
        super("Client Connection Monitor Provider");
    }

    @Override
    public void initializeMonitorProvider(ClientConnectionMonitorProviderCfg configuration) throws ConfigException, InitializationException {
    }

    @Override
    public String getMonitorInstanceName() {
        return "Client Connections";
    }

    @Override
    public long getUpdateInterval() {
        return 0L;
    }

    @Override
    public void updateMonitorData() {
    }

    public ArrayList<Attribute> getMonitorData() {
        ArrayList<Collection<ClientConnection>> connCollections = new ArrayList<Collection<ClientConnection>>();
        Iterator<ConnectionHandler> i$ = DirectoryServer.getConnectionHandlers().iterator();
        while (i$.hasNext()) {
            ConnectionHandler handler;
            ConnectionHandler connectionHandler = handler = i$.next();
            connCollections.add(connectionHandler.getClientConnections());
        }
        TreeMap<Long, ClientConnection> connMap = new TreeMap<Long, ClientConnection>();
        for (Collection collection : connCollections) {
            for (ClientConnection conn : collection) {
                connMap.put(conn.getConnectionID(), conn);
            }
        }
        AttributeType attrType = DirectoryServer.getDefaultAttributeType("connection");
        AttributeBuilder attributeBuilder = new AttributeBuilder(attrType);
        for (ClientConnection conn : connMap.values()) {
            attributeBuilder.add(new AttributeValue(attrType, conn.getMonitorSummary()));
        }
        ArrayList<Attribute> attrs = new ArrayList<Attribute>(1);
        attrs.add(attributeBuilder.toAttribute());
        return attrs;
    }
}

