/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.protocols.ldap;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.opends.messages.Message;
import org.opends.messages.ProtocolMessages;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.protocols.asn1.ASN1Element;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.protocols.asn1.ASN1Sequence;
import org.opends.server.protocols.ldap.LDAPAttribute;
import org.opends.server.protocols.ldap.ProtocolOp;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.LDAPException;
import org.opends.server.types.RawAttribute;
import org.opends.server.util.Base64;
import org.opends.server.util.ServerConstants;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddRequestProtocolOp
extends ProtocolOp {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private List<RawAttribute> attributes;
    private ASN1OctetString dn;

    public AddRequestProtocolOp(ASN1OctetString dn) {
        this.dn = dn;
        this.attributes = new ArrayList<RawAttribute>();
    }

    public AddRequestProtocolOp(ASN1OctetString dn, ArrayList<RawAttribute> attributes) {
        this.dn = dn;
        this.attributes = attributes == null ? new ArrayList<RawAttribute>() : attributes;
    }

    public ASN1OctetString getDN() {
        return this.dn;
    }

    public void setDN(ASN1OctetString dn) {
        this.dn = dn;
    }

    public List<RawAttribute> getAttributes() {
        return this.attributes;
    }

    @Override
    public byte getType() {
        return 104;
    }

    @Override
    public String getProtocolOpName() {
        return "Add Request";
    }

    @Override
    public ASN1Element encode() {
        ArrayList<ASN1Element> elements = new ArrayList<ASN1Element>(2);
        elements.add(this.dn);
        ArrayList<ASN1Element> attrElements = new ArrayList<ASN1Element>(this.attributes.size());
        for (RawAttribute attr : this.attributes) {
            attrElements.add(attr.encode());
        }
        elements.add(new ASN1Sequence(attrElements));
        return new ASN1Sequence(104, elements);
    }

    public static AddRequestProtocolOp decodeAddRequest(ASN1Element element) throws LDAPException {
        ArrayList<RawAttribute> attributes;
        ASN1OctetString dn;
        ArrayList<ASN1Element> elements;
        try {
            elements = element.decodeAsSequence().elements();
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = ProtocolMessages.ERR_LDAP_ADD_REQUEST_DECODE_SEQUENCE.get(String.valueOf(e));
            throw new LDAPException(2, message, e);
        }
        int numElements = elements.size();
        if (numElements != 2) {
            Message message = ProtocolMessages.ERR_LDAP_ADD_REQUEST_DECODE_INVALID_ELEMENT_COUNT.get(numElements);
            throw new LDAPException(2, message);
        }
        try {
            dn = elements.get(0).decodeAsOctetString();
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = ProtocolMessages.ERR_LDAP_ADD_REQUEST_DECODE_DN.get(String.valueOf(e));
            throw new LDAPException(2, message, e);
        }
        try {
            ArrayList<ASN1Element> attrElements = elements.get(1).decodeAsSequence().elements();
            attributes = new ArrayList<RawAttribute>(attrElements.size());
            for (ASN1Element e : attrElements) {
                attributes.add(LDAPAttribute.decode(e));
            }
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = ProtocolMessages.ERR_LDAP_ADD_REQUEST_DECODE_ATTRS.get(String.valueOf(e));
            throw new LDAPException(2, message, e);
        }
        return new AddRequestProtocolOp(dn, attributes);
    }

    @Override
    public void toString(StringBuilder buffer) {
        buffer.append("AddRequest(dn=");
        this.dn.toString(buffer);
        buffer.append(", attrs={");
        if (!this.attributes.isEmpty()) {
            Iterator<RawAttribute> iterator = this.attributes.iterator();
            iterator.next().toString(buffer);
            while (iterator.hasNext()) {
                buffer.append(", ");
                iterator.next().toString(buffer);
            }
        }
        buffer.append("})");
    }

    @Override
    public void toString(StringBuilder buffer, int indent) {
        StringBuilder indentBuf = new StringBuilder(indent);
        for (int i = 0; i < indent; ++i) {
            indentBuf.append(' ');
        }
        buffer.append((CharSequence)indentBuf);
        buffer.append("Add Request");
        buffer.append(ServerConstants.EOL);
        buffer.append((CharSequence)indentBuf);
        buffer.append("  DN:  ");
        this.dn.toString(buffer);
        buffer.append(ServerConstants.EOL);
        buffer.append("  Attributes:");
        buffer.append(ServerConstants.EOL);
        for (RawAttribute attribute : this.attributes) {
            attribute.toString(buffer, indent + 4);
        }
    }

    public void toLDIF(StringBuilder buffer, int wrapColumn) {
        int colsRemaining;
        String dnString;
        if (StaticUtils.needsBase64Encoding(this.dn.value())) {
            dnString = Base64.encode(this.dn.value());
            buffer.append("dn:: ");
            colsRemaining = wrapColumn - 5;
        } else {
            dnString = this.dn.stringValue();
            buffer.append("dn: ");
            colsRemaining = wrapColumn - 4;
        }
        int dnLength = dnString.length();
        if (dnLength <= colsRemaining || colsRemaining <= 0) {
            buffer.append(dnString);
            buffer.append(ServerConstants.EOL);
        } else {
            buffer.append(dnString.substring(0, colsRemaining));
            buffer.append(ServerConstants.EOL);
            int startPos = colsRemaining;
            while (dnLength - startPos > wrapColumn - 1) {
                buffer.append(" ");
                buffer.append(dnString.substring(startPos, startPos + wrapColumn - 1));
                buffer.append(ServerConstants.EOL);
                startPos += wrapColumn - 1;
            }
            if (startPos < dnLength) {
                buffer.append(" ");
                buffer.append(dnString.substring(startPos));
                buffer.append(ServerConstants.EOL);
            }
        }
        for (RawAttribute a : this.attributes) {
            String name = a.getAttributeType();
            int nameLength = name.length();
            for (ASN1OctetString v : a.getValues()) {
                String valueString;
                if (StaticUtils.needsBase64Encoding(v.value())) {
                    valueString = Base64.encode(v.value());
                    buffer.append(name);
                    buffer.append(":: ");
                    colsRemaining = wrapColumn - nameLength - 3;
                } else {
                    valueString = v.stringValue();
                    buffer.append(name);
                    buffer.append(": ");
                    colsRemaining = wrapColumn - nameLength - 2;
                }
                int valueLength = valueString.length();
                if (valueLength <= colsRemaining || colsRemaining <= 0) {
                    buffer.append(valueString);
                    buffer.append(ServerConstants.EOL);
                    continue;
                }
                buffer.append(valueString.substring(0, colsRemaining));
                buffer.append(ServerConstants.EOL);
                int startPos = colsRemaining;
                while (valueLength - startPos > wrapColumn - 1) {
                    buffer.append(" ");
                    buffer.append(valueString.substring(startPos, startPos + wrapColumn - 1));
                    buffer.append(ServerConstants.EOL);
                    startPos += wrapColumn - 1;
                }
                if (startPos >= valueLength) continue;
                buffer.append(" ");
                buffer.append(valueString.substring(startPos));
                buffer.append(ServerConstants.EOL);
            }
        }
        buffer.append(ServerConstants.EOL);
    }
}

