/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.replication.plugin;

import org.opends.server.admin.std.server.OrderingMatchingRuleCfg;
import org.opends.server.api.OrderingMatchingRule;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.types.ByteString;

public class HistoricalCsnOrderingMatchingRule
extends OrderingMatchingRule {
    private static final long serialVersionUID = -3424403930225609943L;

    public int compareValues(ByteString value1, ByteString value2) {
        String[] token1 = value1.stringValue().split(":", 3);
        String[] token2 = value2.stringValue().split(":", 3);
        if (token1[1] == null || token2[1] == null) {
            return -1;
        }
        return token1[1].compareTo(token2[1]);
    }

    public void initializeMatchingRule(OrderingMatchingRuleCfg configuration) {
    }

    public String getName() {
        return "historicalCsnOrderingMatch";
    }

    public String getOID() {
        return "1.3.6.1.4.1.26027.1.4.4";
    }

    public String getDescription() {
        return null;
    }

    public String getSyntaxOID() {
        return "1.3.6.1.4.1.26027.1.3.5";
    }

    public ByteString normalizeValue(ByteString value) {
        String[] token = value.stringValue().split(":", 3);
        String timestamp = token[1].substring(0, 16);
        String serverId = token[1].substring(16, 20);
        String seqNumber = token[1].substring(20, 28);
        return new ASN1OctetString(serverId + timestamp + seqNumber);
    }

    public int compare(byte[] b1, byte[] b2) {
        int minLength = Math.min(b1.length, b2.length);
        for (int i = 0; i < minLength; ++i) {
            if (b1[i] == b2[i]) continue;
            if (b1[i] < b2[i]) {
                return -1;
            }
            if (b1[i] <= b2[i]) continue;
            return 1;
        }
        if (b1.length == b2.length) {
            return 0;
        }
        if (b1.length < b2.length) {
            return -1;
        }
        return 1;
    }
}

