/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.replication.protocol;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.DataFormatException;
import org.opends.server.replication.common.ChangeNumber;
import org.opends.server.replication.protocol.ReplicationMsg;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AckMsg
extends ReplicationMsg {
    private ChangeNumber changeNumber;
    private boolean hasTimeout = false;
    private boolean hasWrongStatus = false;
    private boolean hasReplayError = false;
    private List<Short> failedServers = new ArrayList<Short>();

    public AckMsg(ChangeNumber changeNumber) {
        this.changeNumber = changeNumber;
    }

    public AckMsg(ChangeNumber changeNumber, boolean hasTimeout, boolean hasWrongStatus, boolean hasReplayError, List<Short> failedServers) {
        this.changeNumber = changeNumber;
        this.hasTimeout = hasTimeout;
        this.hasWrongStatus = hasWrongStatus;
        this.hasReplayError = hasReplayError;
        this.failedServers = failedServers;
    }

    public AckMsg(byte[] in) throws DataFormatException {
        try {
            if (in[0] != 5) {
                throw new DataFormatException("byte[] is not a valid modify msg");
            }
            int pos = 1;
            int length = this.getNextLength(in, pos);
            String changenumberStr = new String(in, pos, length, "UTF-8");
            this.changeNumber = new ChangeNumber(changenumberStr);
            pos += length + 1;
            this.hasTimeout = in[pos++] == 1;
            this.hasWrongStatus = in[pos++] == 1;
            this.hasReplayError = in[pos++] == 1;
            while (pos < in.length) {
                length = this.getNextLength(in, pos);
                String serverIdString = new String(in, pos, length, "UTF-8");
                Short serverId = Short.valueOf(serverIdString);
                this.failedServers.add(serverId);
                pos += length + 1;
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new DataFormatException("UTF-8 is not supported by this jvm.");
        }
    }

    public ChangeNumber getChangeNumber() {
        return this.changeNumber;
    }

    @Override
    public byte[] getBytes() {
        try {
            ByteArrayOutputStream oStream = new ByteArrayOutputStream();
            oStream.write(5);
            byte[] changeNumberByte = this.changeNumber.toString().getBytes("UTF-8");
            oStream.write(changeNumberByte);
            oStream.write(0);
            oStream.write(this.hasTimeout ? 1 : 0);
            oStream.write(this.hasWrongStatus ? 1 : 0);
            oStream.write(this.hasReplayError ? 1 : 0);
            for (Short sid : this.failedServers) {
                byte[] byteServerId = String.valueOf(sid.shortValue()).getBytes("UTF-8");
                oStream.write(byteServerId);
                oStream.write(0);
            }
            return oStream.toByteArray();
        }
        catch (IOException e) {
            return null;
        }
    }

    public boolean hasTimeout() {
        return this.hasTimeout;
    }

    public boolean hasWrongStatus() {
        return this.hasWrongStatus;
    }

    public boolean hasReplayError() {
        return this.hasReplayError;
    }

    public List<Short> getFailedServers() {
        return this.failedServers;
    }
}

