/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.replication.protocol;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.zip.DataFormatException;
import org.opends.server.core.AddOperationBasis;
import org.opends.server.core.DirectoryServer;
import org.opends.server.protocols.asn1.ASN1Element;
import org.opends.server.protocols.asn1.ASN1Exception;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.protocols.internal.InternalClientConnection;
import org.opends.server.protocols.ldap.LDAPAttribute;
import org.opends.server.replication.common.ChangeNumber;
import org.opends.server.replication.protocol.AddContext;
import org.opends.server.replication.protocol.UpdateMsg;
import org.opends.server.types.Attribute;
import org.opends.server.types.AttributeBuilder;
import org.opends.server.types.AttributeType;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.ByteString;
import org.opends.server.types.LDAPException;
import org.opends.server.types.ObjectClass;
import org.opends.server.types.RawAttribute;
import org.opends.server.types.operation.PostOperationAddOperation;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddMsg
extends UpdateMsg {
    private byte[] encodedAttributes;
    private String parentUniqueId;

    public AddMsg(PostOperationAddOperation op) {
        super((AddContext)op.getAttachment("replicationContext"), op.getRawEntryDN().stringValue());
        AddContext ctx = (AddContext)op.getAttachment("replicationContext");
        this.parentUniqueId = ctx.getParentUid();
        this.encodedAttributes = this.encodeAttributes(op.getObjectClasses(), op.getUserAttributes(), op.getOperationalAttributes());
    }

    private byte[] encodeAttributes(Map<ObjectClass, String> objectClasses, Map<AttributeType, List<Attribute>> userAttributes, Map<AttributeType, List<Attribute>> operationalAttributes) {
        AttributeBuilder builder = new AttributeBuilder(DirectoryServer.getObjectClassAttributeType());
        builder.setInitialCapacity(objectClasses.size());
        for (String s : objectClasses.values()) {
            builder.add(new AttributeValue(new ASN1OctetString(s), (ByteString)new ASN1OctetString(StaticUtils.toLowerCase(s))));
        }
        Attribute attr = builder.toAttribute();
        ArrayList<ASN1Element> elems = new ArrayList<ASN1Element>();
        elems.add(new LDAPAttribute(attr).encode());
        for (List<Attribute> list : userAttributes.values()) {
            for (Attribute a : list) {
                if (a.isVirtual()) continue;
                elems.add(new LDAPAttribute(a).encode());
            }
        }
        for (List<Attribute> list : operationalAttributes.values()) {
            for (Attribute a : list) {
                if (a.isVirtual()) continue;
                elems.add(new LDAPAttribute(a).encode());
            }
        }
        return ASN1Element.encodeValue(elems);
    }

    public AddMsg(ChangeNumber cn, String dn, String uniqueId, String parentId, Map<ObjectClass, String> objectClasses, Map<AttributeType, List<Attribute>> userAttributes, Map<AttributeType, List<Attribute>> operationalAttributes) {
        super(cn, uniqueId, dn);
        this.parentUniqueId = parentId;
        this.encodedAttributes = this.encodeAttributes(objectClasses, userAttributes, operationalAttributes);
    }

    public AddMsg(ChangeNumber cn, String dn, String uniqueId, String parentId, Attribute objectClass, Collection<Attribute> userAttributes, Collection<Attribute> operationalAttributes) {
        super(cn, uniqueId, dn);
        this.parentUniqueId = parentId;
        ArrayList<ASN1Element> elems = new ArrayList<ASN1Element>();
        elems.add(new LDAPAttribute(objectClass).encode());
        for (Attribute a : userAttributes) {
            elems.add(new LDAPAttribute(a).encode());
        }
        if (operationalAttributes != null) {
            for (Attribute a : operationalAttributes) {
                elems.add(new LDAPAttribute(a).encode());
            }
        }
        this.encodedAttributes = ASN1Element.encodeValue(elems);
    }

    public AddMsg(byte[] in) throws DataFormatException, UnsupportedEncodingException {
        byte[] allowedPduTypes = new byte[]{23, 2};
        int pos = this.decodeHeader(allowedPduTypes, in);
        int length = this.getNextLength(in, pos);
        if (length != 0) {
            this.parentUniqueId = new String(in, pos, length, "UTF-8");
            pos += length + 1;
        } else {
            this.parentUniqueId = null;
            ++pos;
        }
        this.encodedAttributes = new byte[in.length - pos];
        int i = 0;
        while (pos < in.length) {
            this.encodedAttributes[i++] = in[pos++];
        }
    }

    @Override
    public AddOperationBasis createOperation(InternalClientConnection connection, String newDn) throws LDAPException, ASN1Exception {
        ArrayList<RawAttribute> attr = new ArrayList<RawAttribute>();
        ArrayList<ASN1Element> elems = ASN1Element.decodeElements(this.encodedAttributes);
        for (ASN1Element elem : elems) {
            attr.add(LDAPAttribute.decode(elem));
        }
        AddOperationBasis add = new AddOperationBasis(connection, InternalClientConnection.nextOperationID(), InternalClientConnection.nextMessageID(), null, new ASN1OctetString(newDn), attr);
        AddContext ctx = new AddContext(this.getChangeNumber(), this.getUniqueId(), this.parentUniqueId);
        add.setAttachment("replicationContext", ctx);
        return add;
    }

    @Override
    public byte[] getBytes() throws UnsupportedEncodingException {
        int length = this.encodedAttributes.length;
        byte[] byteParentId = null;
        if (this.parentUniqueId != null) {
            byteParentId = this.parentUniqueId.getBytes("UTF-8");
            length += byteParentId.length + 1;
        } else {
            ++length;
        }
        byte[] resultByteArray = this.encodeHeader((byte)23, length);
        int pos = resultByteArray.length - length;
        if (byteParentId != null) {
            pos = this.addByteArray(byteParentId, resultByteArray, pos);
        } else {
            resultByteArray[pos++] = 0;
        }
        int i = 0;
        while (i < this.encodedAttributes.length) {
            resultByteArray[pos] = this.encodedAttributes[i];
            ++i;
            ++pos;
        }
        return resultByteArray;
    }

    public String toString() {
        if (this.protocolVersion == 1) {
            return "AddMsg content: \nprotocolVersion: " + this.protocolVersion + "\ndn: " + this.dn + "\nchangeNumber: " + this.changeNumber + "\nuniqueId: " + this.uniqueId + "\nassuredFlag: " + this.assuredFlag;
        }
        if (this.protocolVersion == 2) {
            return "AddMsg content: \nprotocolVersion: " + this.protocolVersion + "\ndn: " + this.dn + "\nchangeNumber: " + this.changeNumber + "\nuniqueId: " + this.uniqueId + "\nassuredFlag: " + this.assuredFlag + "\nassuredMode: " + (Object)((Object)this.assuredMode) + "\nsafeDataLevel: " + this.safeDataLevel;
        }
        return "!!! Unknown version: " + this.protocolVersion + "!!!";
    }

    public void addAttribute(String name, String value) throws ASN1Exception {
        LDAPAttribute newAttr = new LDAPAttribute(name, value);
        ArrayList<ASN1Element> elems = ASN1Element.decodeElements(this.encodedAttributes);
        elems.add(newAttr.encode());
        this.encodedAttributes = ASN1Element.encodeValue(elems);
    }

    public void setParentUid(String uid) {
        this.parentUniqueId = uid;
    }

    public String getParentUid() {
        return this.parentUniqueId;
    }

    @Override
    public int size() {
        return this.encodedAttributes.length + 40;
    }

    @Override
    public byte[] getBytes_V1() throws UnsupportedEncodingException {
        int length = this.encodedAttributes.length;
        byte[] byteParentId = null;
        if (this.parentUniqueId != null) {
            byteParentId = this.parentUniqueId.getBytes("UTF-8");
            length += byteParentId.length + 1;
        } else {
            ++length;
        }
        byte[] resultByteArray = this.encodeHeader_V1((byte)2, length);
        int pos = resultByteArray.length - length;
        if (byteParentId != null) {
            pos = this.addByteArray(byteParentId, resultByteArray, pos);
        } else {
            resultByteArray[pos++] = 0;
        }
        int i = 0;
        while (i < this.encodedAttributes.length) {
            resultByteArray[pos] = this.encodedAttributes[i];
            ++i;
            ++pos;
        }
        return resultByteArray;
    }
}

