/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.replication.protocol;

import java.util.ArrayList;
import java.util.List;
import org.opends.server.protocols.asn1.ASN1Element;
import org.opends.server.protocols.ldap.LDAPAttribute;
import org.opends.server.protocols.ldap.LDAPModification;
import org.opends.server.replication.common.ChangeNumber;
import org.opends.server.replication.plugin.Historical;
import org.opends.server.replication.protocol.OperationContext;
import org.opends.server.replication.protocol.UpdateMsg;
import org.opends.server.types.Attribute;
import org.opends.server.types.AttributeType;
import org.opends.server.types.AttributeUsage;
import org.opends.server.types.Modification;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ModifyCommonMsg
extends UpdateMsg {
    protected byte[] encodedMods = new byte[0];

    public ModifyCommonMsg() {
    }

    public ModifyCommonMsg(OperationContext ctx, String dn) {
        super(ctx, dn);
    }

    public ModifyCommonMsg(ChangeNumber cn, String entryUUID, String dn) {
        super(cn, entryUUID, dn);
    }

    public void setMods(List<Modification> mods) {
        this.encodedMods = this.modsToByte(mods);
    }

    protected byte[] modsToByte(List<Modification> mods) {
        if (mods == null || mods.size() == 0) {
            return new byte[0];
        }
        ArrayList<ASN1Element> modsASN1 = new ArrayList<ASN1Element>(mods.size());
        for (Modification mod : mods) {
            Attribute attr = mod.getAttribute();
            AttributeType type = attr.getAttributeType();
            if (type != null && AttributeUsage.DSA_OPERATION.equals((Object)type.getUsage()) || Historical.isHistoricalAttribute(attr)) continue;
            LDAPModification ldapmod = new LDAPModification(mod.getModificationType(), new LDAPAttribute(mod.getAttribute()));
            modsASN1.add(ldapmod.encode());
        }
        return ASN1Element.encodeValue(modsASN1);
    }
}

