/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.tasks;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import org.opends.messages.Message;
import org.opends.messages.TaskMessages;
import org.opends.messages.ToolMessages;
import org.opends.server.admin.std.server.BackendCfg;
import org.opends.server.api.Backend;
import org.opends.server.api.ClientConnection;
import org.opends.server.backends.task.Task;
import org.opends.server.backends.task.TaskState;
import org.opends.server.config.ConfigEntry;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.LockFileManager;
import org.opends.server.tasks.TaskUtils;
import org.opends.server.types.Attribute;
import org.opends.server.types.AttributeType;
import org.opends.server.types.BackupConfig;
import org.opends.server.types.BackupDirectory;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.Entry;
import org.opends.server.types.Operation;
import org.opends.server.types.Privilege;
import org.opends.server.types.ResultCode;
import org.opends.server.util.StaticUtils;

public class BackupTask
extends Task {
    private static Map<String, Message> argDisplayMap = new HashMap<String, Message>();
    private boolean backUpAll;
    private boolean compress;
    private boolean encrypt;
    private boolean hash;
    private boolean incremental;
    private boolean signHash;
    private List<String> backendIDList;
    private String backupID;
    private File backupDirectory;
    private String incrementalBase;
    private BackupConfig backupConfig;
    private Map<String, ConfigEntry> configEntries;
    private ArrayList<Backend> backendsToArchive;

    public Message getDisplayName() {
        return TaskMessages.INFO_TASK_BACKUP_NAME.get();
    }

    public Message getAttributeDisplayName(String attrName) {
        return argDisplayMap.get(attrName);
    }

    public void initializeTask() throws DirectoryException {
        ClientConnection clientConnection;
        Operation operation = this.getOperation();
        if (operation != null && !(clientConnection = operation.getClientConnection()).hasPrivilege(Privilege.BACKEND_BACKUP, operation)) {
            Message message = TaskMessages.ERR_TASK_BACKUP_INSUFFICIENT_PRIVILEGES.get();
            throw new DirectoryException(ResultCode.INSUFFICIENT_ACCESS_RIGHTS, message);
        }
        Entry taskEntry = this.getTaskEntry();
        AttributeType typeBackupAll = DirectoryServer.getAttributeType("ds-task-backup-all", true);
        AttributeType typeCompress = DirectoryServer.getAttributeType("ds-task-backup-compress", true);
        AttributeType typeEncrypt = DirectoryServer.getAttributeType("ds-task-backup-encrypt", true);
        AttributeType typeHash = DirectoryServer.getAttributeType("ds-task-backup-hash", true);
        AttributeType typeIncremental = DirectoryServer.getAttributeType("ds-task-backup-incremental", true);
        AttributeType typeSignHash = DirectoryServer.getAttributeType("ds-task-backup-sign-hash", true);
        AttributeType typeBackendID = DirectoryServer.getAttributeType("ds-task-backup-backend-id", true);
        AttributeType typeBackupID = DirectoryServer.getAttributeType("ds-backup-id", true);
        AttributeType typeBackupDirectory = DirectoryServer.getAttributeType("ds-backup-directory-path", true);
        AttributeType typeIncrementalBaseID = DirectoryServer.getAttributeType("ds-task-backup-incremental-base-id", true);
        List<Attribute> attrList = taskEntry.getAttribute(typeBackupAll);
        this.backUpAll = TaskUtils.getBoolean(attrList, false);
        attrList = taskEntry.getAttribute(typeCompress);
        this.compress = TaskUtils.getBoolean(attrList, false);
        attrList = taskEntry.getAttribute(typeEncrypt);
        this.encrypt = TaskUtils.getBoolean(attrList, false);
        attrList = taskEntry.getAttribute(typeHash);
        this.hash = TaskUtils.getBoolean(attrList, false);
        attrList = taskEntry.getAttribute(typeIncremental);
        this.incremental = TaskUtils.getBoolean(attrList, false);
        attrList = taskEntry.getAttribute(typeSignHash);
        this.signHash = TaskUtils.getBoolean(attrList, false);
        attrList = taskEntry.getAttribute(typeBackendID);
        this.backendIDList = TaskUtils.getMultiValueString(attrList);
        attrList = taskEntry.getAttribute(typeBackupID);
        this.backupID = TaskUtils.getSingleValueString(attrList);
        attrList = taskEntry.getAttribute(typeBackupDirectory);
        String backupDirectoryPath = TaskUtils.getSingleValueString(attrList);
        this.backupDirectory = new File(backupDirectoryPath);
        if (!this.backupDirectory.isAbsolute()) {
            this.backupDirectory = new File(DirectoryServer.getInstanceRoot(), backupDirectoryPath);
        }
        attrList = taskEntry.getAttribute(typeIncrementalBaseID);
        this.incrementalBase = TaskUtils.getSingleValueString(attrList);
        this.configEntries = TaskUtils.getBackendConfigEntries();
    }

    private boolean argumentsAreValid() {
        Message message;
        if (this.backUpAll) {
            if (!this.backendIDList.isEmpty()) {
                Message message2 = ToolMessages.ERR_BACKUPDB_CANNOT_MIX_BACKUP_ALL_AND_BACKEND_ID.get("ds-task-backup-all", "ds-task-backup-backend-id");
                this.logError(message2);
                return false;
            }
        } else if (this.backendIDList.isEmpty()) {
            Message message3 = ToolMessages.ERR_BACKUPDB_NEED_BACKUP_ALL_OR_BACKEND_ID.get("ds-task-backup-all", "ds-task-backup-backend-id");
            this.logError(message3);
            return false;
        }
        if (this.backupID == null) {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMddHHmmss'Z'");
            dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
            this.backupID = dateFormat.format(new Date());
        }
        if (this.incrementalBase != null && !this.incremental) {
            message = ToolMessages.ERR_BACKUPDB_INCREMENTAL_BASE_REQUIRES_INCREMENTAL.get("ds-task-backup-incremental-base-id", "ds-task-backup-incremental");
            this.logError(message);
            return false;
        }
        if (this.signHash && !this.hash) {
            message = ToolMessages.ERR_BACKUPDB_SIGN_REQUIRES_HASH.get("ds-task-backup-sign-hash", "ds-task-backup-hash");
            this.logError(message);
            return false;
        }
        if (!this.backupDirectory.exists()) {
            try {
                this.backupDirectory.mkdirs();
            }
            catch (Exception e) {
                Message message4 = ToolMessages.ERR_BACKUPDB_CANNOT_CREATE_BACKUP_DIR.get(this.backupDirectory.getPath(), StaticUtils.getExceptionMessage(e));
                System.err.println(message4);
                return false;
            }
        }
        int numBackends = this.configEntries.size();
        this.backendsToArchive = new ArrayList(numBackends);
        if (this.backUpAll) {
            for (Map.Entry entry : this.configEntries.entrySet()) {
                Backend b = DirectoryServer.getBackend((String)entry.getKey());
                if (b == null || !b.supportsBackup()) continue;
                this.backendsToArchive.add(b);
            }
        } else {
            for (String string : this.backendIDList) {
                Backend b = DirectoryServer.getBackend(string);
                if (b == null || this.configEntries.get(string) == null) {
                    Message message5 = ToolMessages.ERR_BACKUPDB_NO_BACKENDS_FOR_ID.get(string);
                    this.logError(message5);
                    continue;
                }
                if (!b.supportsBackup()) {
                    Message message2 = ToolMessages.WARN_BACKUPDB_BACKUP_NOT_SUPPORTED.get(b.getBackendID());
                    this.logError(message2);
                    continue;
                }
                this.backendsToArchive.add(b);
            }
            if (this.backendsToArchive.size() != this.backendIDList.size()) {
                return false;
            }
        }
        if (this.backendsToArchive.isEmpty()) {
            Message message6 = ToolMessages.WARN_BACKUPDB_NO_BACKENDS_TO_ARCHIVE.get();
            this.logError(message6);
            return false;
        }
        return true;
    }

    private boolean backupBackend(Backend b, File backupLocation) {
        Message message;
        BackupDirectory backupDir;
        block12: {
            BackendCfg cfg = TaskUtils.getConfigEntry(b);
            if (backupLocation.exists()) {
                String descriptorPath = backupLocation.getPath() + File.separator + "backup.info";
                File descriptorFile = new File(descriptorPath);
                if (descriptorFile.exists()) {
                    try {
                        backupDir = BackupDirectory.readBackupDirectoryDescriptor(backupLocation.getPath());
                        if (!backupDir.getConfigEntryDN().equals(cfg.dn())) {
                            Message message2 = ToolMessages.ERR_BACKUPDB_CANNOT_BACKUP_IN_DIRECTORY.get(b.getBackendID(), backupLocation.getPath(), backupDir.getConfigEntryDN().getRDN().getAttributeValue(0).getStringValue());
                            this.logError(message2);
                            return false;
                        }
                        break block12;
                    }
                    catch (ConfigException ce) {
                        Message message3 = ToolMessages.ERR_BACKUPDB_CANNOT_PARSE_BACKUP_DESCRIPTOR.get(descriptorPath, ce.getMessage());
                        this.logError(message3);
                        return false;
                    }
                    catch (Exception e) {
                        Message message4 = ToolMessages.ERR_BACKUPDB_CANNOT_PARSE_BACKUP_DESCRIPTOR.get(descriptorPath, StaticUtils.getExceptionMessage(e));
                        this.logError(message4);
                        return false;
                    }
                }
                backupDir = new BackupDirectory(backupLocation.getPath(), cfg.dn());
            } else {
                try {
                    backupLocation.mkdirs();
                }
                catch (Exception e) {
                    Message message5 = ToolMessages.ERR_BACKUPDB_CANNOT_CREATE_BACKUP_DIR.get(backupLocation.getPath(), StaticUtils.getExceptionMessage(e));
                    this.logError(message5);
                    return false;
                }
                backupDir = new BackupDirectory(backupLocation.getPath(), cfg.dn());
            }
        }
        this.backupConfig = new BackupConfig(backupDir, this.backupID, this.incremental);
        this.backupConfig.setCompressData(this.compress);
        this.backupConfig.setEncryptData(this.encrypt);
        this.backupConfig.setHashData(this.hash);
        this.backupConfig.setSignHash(this.signHash);
        this.backupConfig.setIncrementalBaseID(this.incrementalBase);
        try {
            DirectoryServer.notifyBackupBeginning(b, this.backupConfig);
            b.createBackup(this.backupConfig);
            DirectoryServer.notifyBackupEnded(b, this.backupConfig, true);
        }
        catch (DirectoryException de) {
            DirectoryServer.notifyBackupEnded(b, this.backupConfig, false);
            message = ToolMessages.ERR_BACKUPDB_ERROR_DURING_BACKUP.get(b.getBackendID(), de.getMessageObject());
            this.logError(message);
            return false;
        }
        catch (Exception e) {
            DirectoryServer.notifyBackupEnded(b, this.backupConfig, false);
            message = ToolMessages.ERR_BACKUPDB_ERROR_DURING_BACKUP.get(b.getBackendID(), StaticUtils.getExceptionMessage(e));
            this.logError(message);
            return false;
        }
        return true;
    }

    private boolean lockBackend(Backend b) {
        try {
            String lockFile = LockFileManager.getBackendLockFileName(b);
            StringBuilder failureReason = new StringBuilder();
            if (!LockFileManager.acquireSharedLock(lockFile, failureReason)) {
                Message message = ToolMessages.ERR_BACKUPDB_CANNOT_LOCK_BACKEND.get(b.getBackendID(), String.valueOf(failureReason));
                this.logError(message);
                return false;
            }
        }
        catch (Exception e) {
            Message message = ToolMessages.ERR_BACKUPDB_CANNOT_LOCK_BACKEND.get(b.getBackendID(), StaticUtils.getExceptionMessage(e));
            this.logError(message);
            return false;
        }
        return true;
    }

    private boolean unlockBackend(Backend b) {
        try {
            String lockFile = LockFileManager.getBackendLockFileName(b);
            StringBuilder failureReason = new StringBuilder();
            if (!LockFileManager.releaseLock(lockFile, failureReason)) {
                Message message = ToolMessages.WARN_BACKUPDB_CANNOT_UNLOCK_BACKEND.get(b.getBackendID(), String.valueOf(failureReason));
                this.logError(message);
                return false;
            }
        }
        catch (Exception e) {
            Message message = ToolMessages.WARN_BACKUPDB_CANNOT_UNLOCK_BACKEND.get(b.getBackendID(), StaticUtils.getExceptionMessage(e));
            this.logError(message);
            return false;
        }
        return true;
    }

    public void interruptTask(TaskState interruptState, Message interruptReason) {
        if (TaskState.STOPPED_BY_ADMINISTRATOR.equals((Object)interruptState) && this.backupConfig != null) {
            this.addLogMessage(TaskMessages.INFO_TASK_STOPPED_BY_ADMIN.get(interruptReason));
            this.setTaskInterruptState(interruptState);
            this.backupConfig.cancel();
        }
    }

    public boolean isInterruptable() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected TaskState runTask() {
        Message message;
        if (!this.argumentsAreValid()) {
            return TaskState.STOPPED_BY_ERROR;
        }
        boolean multiple = this.backUpAll ? true : this.backendsToArchive.size() > 1;
        boolean errorsEncountered = false;
        for (Backend b : this.backendsToArchive) {
            if (this.isCancelled()) break;
            if (!this.lockBackend(b)) {
                errorsEncountered = true;
                continue;
            }
            try {
                Message message2 = ToolMessages.NOTE_BACKUPDB_STARTING_BACKUP.get(b.getBackendID());
                this.logError(message2);
                File backupLocation = multiple ? new File(this.backupDirectory, b.getBackendID()) : this.backupDirectory;
                if (this.backupBackend(b, backupLocation)) continue;
                errorsEncountered = true;
            }
            finally {
                if (this.unlockBackend(b)) continue;
                errorsEncountered = true;
            }
        }
        if (errorsEncountered) {
            message = ToolMessages.NOTE_BACKUPDB_COMPLETED_WITH_ERRORS.get();
            this.logError(message);
            return TaskState.STOPPED_BY_ERROR;
        }
        if (this.isCancelled()) {
            message = ToolMessages.NOTE_BACKUPDB_CANCELLED.get();
            this.logError(message);
            return this.getTaskInterruptState();
        }
        message = ToolMessages.NOTE_BACKUPDB_COMPLETED_SUCCESSFULLY.get();
        this.logError(message);
        return TaskState.COMPLETED_SUCCESSFULLY;
    }

    static {
        argDisplayMap.put("ds-task-backup-all", TaskMessages.INFO_BACKUP_ARG_BACKUPALL.get());
        argDisplayMap.put("ds-task-backup-compress", TaskMessages.INFO_BACKUP_ARG_COMPRESS.get());
        argDisplayMap.put("ds-task-backup-encrypt", TaskMessages.INFO_BACKUP_ARG_ENCRYPT.get());
        argDisplayMap.put("ds-task-backup-hash", TaskMessages.INFO_BACKUP_ARG_HASH.get());
        argDisplayMap.put("ds-task-backup-incremental", TaskMessages.INFO_BACKUP_ARG_INCREMENTAL.get());
        argDisplayMap.put("ds-task-backup-sign-hash", TaskMessages.INFO_BACKUP_ARG_SIGN_HASH.get());
        argDisplayMap.put("ds-task-backup-backend-id", TaskMessages.INFO_BACKUP_ARG_BACKEND_IDS.get());
        argDisplayMap.put("ds-backup-id", TaskMessages.INFO_BACKUP_ARG_BACKUP_ID.get());
        argDisplayMap.put("ds-backup-directory-path", TaskMessages.INFO_BACKUP_ARG_BACKUP_DIR.get());
        argDisplayMap.put("ds-task-backup-incremental-base-id", TaskMessages.INFO_BACKUP_ARG_INC_BASE_ID.get());
    }
}

