/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.tools;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.security.KeyStoreException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.opends.messages.AdminToolMessages;
import org.opends.messages.Message;
import org.opends.messages.QuickSetupMessages;
import org.opends.messages.ToolMessages;
import org.opends.messages.UtilityMessages;
import org.opends.quicksetup.ApplicationException;
import org.opends.quicksetup.Constants;
import org.opends.quicksetup.CurrentInstallStatus;
import org.opends.quicksetup.QuickSetupLog;
import org.opends.quicksetup.ReturnCode;
import org.opends.quicksetup.SecurityOptions;
import org.opends.quicksetup.UserData;
import org.opends.quicksetup.UserDataException;
import org.opends.quicksetup.event.ProgressUpdateEvent;
import org.opends.quicksetup.event.ProgressUpdateListener;
import org.opends.quicksetup.installer.NewSuffixOptions;
import org.opends.quicksetup.installer.offline.OfflineInstaller;
import org.opends.quicksetup.installer.ui.InstallReviewPanel;
import org.opends.quicksetup.ui.QuickSetupStepPanel;
import org.opends.quicksetup.util.IncompatibleVersionException;
import org.opends.quicksetup.util.PlainTextProgressMessageFormatter;
import org.opends.quicksetup.util.Utils;
import org.opends.server.core.DirectoryServer;
import org.opends.server.tools.InstallDSArgumentParser;
import org.opends.server.types.DN;
import org.opends.server.types.InitializationException;
import org.opends.server.types.NullOutputStream;
import org.opends.server.util.CertificateManager;
import org.opends.server.util.SetupUtils;
import org.opends.server.util.args.ArgumentException;
import org.opends.server.util.args.IntegerArgument;
import org.opends.server.util.args.StringArgument;
import org.opends.server.util.cli.CLIException;
import org.opends.server.util.cli.ConsoleApplication;
import org.opends.server.util.cli.Menu;
import org.opends.server.util.cli.MenuBuilder;
import org.opends.server.util.cli.MenuResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InstallDS
extends ConsoleApplication {
    private PlainTextProgressMessageFormatter formatter = new PlainTextProgressMessageFormatter();
    public static final String LOG_FILE_PREFIX = "opends-setup-";
    public static final String LOG_FILE_SUFFIX = ".log";
    private static final int LIMIT_KEYSTORE_PASSWORD_PROMPT = 7;
    private NewSuffixOptions.Type lastResetPopulateOption = null;
    private String lastResetImportFile = null;
    private String lastResetRejectedFile = null;
    private String lastResetSkippedFile = null;
    private Integer lastResetNumEntries = null;
    private Boolean lastResetEnableSSL = null;
    private Boolean lastResetEnableStartTLS = null;
    private SecurityOptions.CertificateType lastResetCertType = null;
    private String lastResetKeyStorePath = null;
    private Boolean lastResetEnableWindowsService = null;
    private Boolean lastResetStartServer = null;
    private static final Logger LOG = Logger.getLogger(InstallDS.class.getName());
    private InstallDSArgumentParser argParser;

    public InstallDS(PrintStream out, PrintStream err, InputStream in) {
        super(in, (OutputStream)out, (OutputStream)err);
    }

    public static void main(String[] args) {
        int retCode = InstallDS.mainCLI(args, true, System.out, System.err, System.in);
        System.exit(retCode);
    }

    public static int mainCLI(String[] args) {
        return InstallDS.mainCLI(args, true, System.out, System.err, System.in);
    }

    public static int mainCLI(String[] args, boolean initializeServer, OutputStream outStream, OutputStream errStream, InputStream inStream) {
        PrintStream out = outStream == null ? NullOutputStream.printStream() : new PrintStream(outStream);
        System.setProperty("org.opends.quicksetup.cli", "true");
        PrintStream err = errStream == null ? NullOutputStream.printStream() : new PrintStream(errStream);
        try {
            QuickSetupLog.initLogFileHandler(QuickSetupLog.isInitialized() ? null : File.createTempFile(LOG_FILE_PREFIX, LOG_FILE_SUFFIX), "org.opends.server.tools");
            QuickSetupLog.disableConsoleLogging();
        }
        catch (Throwable t) {
            System.err.println("Unable to initialize log");
            t.printStackTrace();
        }
        InstallDS install = new InstallDS(out, err, inStream);
        return install.execute(args, initializeServer);
    }

    public int execute(String[] args, boolean initializeServer) {
        String cmd;
        this.argParser = new InstallDSArgumentParser(InstallDS.class.getName());
        try {
            this.argParser.initializeArguments();
        }
        catch (ArgumentException ae) {
            Message message = ToolMessages.ERR_CANNOT_INITIALIZE_ARGS.get(ae.getMessage());
            this.println(message);
            return ErrorReturnCode.ERROR_UNEXPECTED.getReturnCode();
        }
        try {
            this.argParser.parseArguments(args);
        }
        catch (ArgumentException ae) {
            Message message = ToolMessages.ERR_ERROR_PARSING_ARGS.get(ae.getMessage());
            this.println(message);
            this.println();
            this.println(Message.raw(this.argParser.getUsage(), new Object[0]));
            return ErrorReturnCode.ERROR_USER_DATA.getReturnCode();
        }
        if (this.argParser.testOnlyArg.isPresent()) {
            try {
                QuickSetupLog.getLogFile().deleteOnExit();
            }
            catch (Throwable t) {
                LOG.log(Level.WARNING, "Error while trying to update the contents of the set-java-home file in test only mode: " + t, t);
            }
            try {
                Utils.checkJavaVersion();
            }
            catch (IncompatibleVersionException ive) {
                this.println(ive.getMessageObject());
                return ReturnCode.JAVA_VERSION_INCOMPATIBLE.getReturnCode();
            }
        }
        if (this.argParser.usageOrVersionDisplayed() || this.argParser.testOnlyArg.isPresent()) {
            return ErrorReturnCode.SUCCESSFUL_NOP.getReturnCode();
        }
        try {
            this.checkInstallStatus();
        }
        catch (InitializationException ie) {
            this.println(ie.getMessageObject());
            return ErrorReturnCode.ERROR_SERVER_ALREADY_INSTALLED.getReturnCode();
        }
        if (initializeServer) {
            try {
                this.initializeDirectoryServer(this.argParser.configFileArg.getValue(), this.argParser.configClassArg.getValue());
            }
            catch (InitializationException ie) {
                this.println(ie.getMessageObject());
                return ErrorReturnCode.ERROR_INITIALIZING_SERVER.getReturnCode();
            }
        }
        boolean userApproved = false;
        UserData uData = new UserData();
        block20: while (!userApproved) {
            try {
                if (this.isInteractive()) {
                    this.promptIfRequired(uData);
                } else {
                    this.initializeUserDataWithParser(uData);
                }
            }
            catch (UserDataException ude) {
                this.println(ude.getMessageObject());
                if (this.isPasswordTriesError(ude.getMessageObject())) {
                    return ErrorReturnCode.ERROR_PASSWORD_LIMIT.getReturnCode();
                }
                return ErrorReturnCode.ERROR_USER_DATA.getReturnCode();
            }
            if (this.isInteractive()) {
                ConfirmCode confirm = this.askForConfirmation(uData);
                switch (confirm) {
                    case CONTINUE: {
                        userApproved = true;
                        continue block20;
                    }
                    case CANCEL: {
                        LOG.log(Level.INFO, "User cancelled setup.");
                        return ErrorReturnCode.ERROR_USER_CANCELLED.getReturnCode();
                    }
                }
                try {
                    this.resetArguments(uData);
                }
                catch (Throwable t) {
                    LOG.log(Level.WARNING, "Error resetting arg parser: " + t, t);
                }
                userApproved = false;
                continue;
            }
            userApproved = true;
        }
        System.setProperty("org.opends.quicksetup.cli", "true");
        OfflineInstaller installer = new OfflineInstaller();
        installer.setUserData(uData);
        installer.setProgressMessageFormatter(this.formatter);
        installer.addProgressUpdateListener(new ProgressUpdateListener(){

            public void progressUpdate(ProgressUpdateEvent ev) {
                if (ev.getNewLogs() != null) {
                    InstallDS.this.printProgress(ev.getNewLogs());
                }
            }
        });
        this.printlnProgress();
        installer.run();
        ApplicationException ue = installer.getRunError();
        String root = Utils.getInstallPathFromClasspath();
        if (SetupUtils.isWindows()) {
            String binDir = Utils.getPath(root, "bat");
            cmd = Utils.getPath(binDir, "status.bat");
        } else {
            String binDir = Utils.getPath(root, "bin");
            cmd = Utils.getPath(binDir, "status");
        }
        this.printlnProgress();
        this.printProgress(ToolMessages.INFO_INSTALLDS_STATUS_COMMAND_LINE.get(cmd));
        this.printlnProgress();
        if (ue != null) {
            return ue.getType().getReturnCode();
        }
        return ErrorReturnCode.SUCCESSFUL.getReturnCode();
    }

    private void checkInstallStatus() throws InitializationException {
        block7: {
            CurrentInstallStatus installStatus = new CurrentInstallStatus();
            if (installStatus.canOverwriteCurrentInstall()) {
                if (this.isInteractive()) {
                    this.println(installStatus.getInstallationMsg());
                    try {
                        if (!this.confirmAction(AdminToolMessages.INFO_CLI_DO_YOU_WANT_TO_CONTINUE.get(), true)) {
                            throw new InitializationException(Message.EMPTY, null);
                        }
                        break block7;
                    }
                    catch (CLIException ce) {
                        LOG.log(Level.SEVERE, "Unexpected error: " + ce, ce);
                        throw new InitializationException(Message.EMPTY, null);
                    }
                }
                this.println(installStatus.getInstallationMsg());
            } else if (installStatus.isInstalled()) {
                throw new InitializationException(installStatus.getInstallationMsg(), null);
            }
        }
    }

    private void initializeDirectoryServer(String configFile, String configClass) throws InitializationException {
        this.printlnProgress();
        this.printProgress(Message.raw(DirectoryServer.getVersionString(), new Object[0]));
        this.printlnProgress();
        this.printProgress(ToolMessages.INFO_INSTALLDS_INITIALIZING.get());
        this.printlnProgress();
        DirectoryServer directoryServer = DirectoryServer.getInstance();
        DirectoryServer.bootstrapClient();
        try {
            DirectoryServer.initializeJMX();
        }
        catch (Throwable t) {
            Message message = ToolMessages.ERR_INSTALLDS_CANNOT_INITIALIZE_JMX.get(String.valueOf(configFile), t.getMessage());
            throw new InitializationException(message, t);
        }
        try {
            directoryServer.initializeConfiguration(configClass, configFile);
        }
        catch (Throwable t) {
            Message message = ToolMessages.ERR_INSTALLDS_CANNOT_INITIALIZE_CONFIG.get(configFile, t.getMessage());
            throw new InitializationException(message, t);
        }
        try {
            directoryServer.initializeSchema();
        }
        catch (Throwable t) {
            Message message = ToolMessages.ERR_INSTALLDS_CANNOT_INITIALIZE_SCHEMA.get(configFile, t.getMessage());
            throw new InitializationException(message, t);
        }
    }

    @Override
    public boolean isQuiet() {
        return this.argParser.quietArg.isPresent();
    }

    @Override
    public boolean isInteractive() {
        return !this.argParser.noPromptArg.isPresent();
    }

    @Override
    public boolean isMenuDrivenMode() {
        return true;
    }

    @Override
    public boolean isScriptFriendly() {
        return false;
    }

    @Override
    public boolean isAdvancedMode() {
        return false;
    }

    @Override
    public boolean isVerbose() {
        return this.argParser.verboseArg.isPresent();
    }

    private void initializeUserDataWithParser(UserData uData) throws UserDataException {
        SecurityOptions securityOptions;
        NewSuffixOptions dataOptions;
        Message message;
        LinkedList<Message> errorMessages = new LinkedList<Message>();
        uData.setConfigurationClassName(this.argParser.configClassArg.getValue());
        uData.setConfigurationFile(this.argParser.configFileArg.getValue());
        uData.setQuiet(this.isQuiet());
        uData.setVerbose(this.isVerbose());
        String dmDN = this.argParser.directoryManagerDNArg.getValue();
        try {
            DN.decode(dmDN);
            if (dmDN.trim().length() == 0) {
                errorMessages.add(ToolMessages.ERR_INSTALLDS_EMPTY_DN_RESPONSE.get());
            }
        }
        catch (Exception e) {
            Message message2 = ToolMessages.ERR_INSTALLDS_CANNOT_PARSE_DN.get(dmDN, e.getMessage());
            errorMessages.add(message2);
        }
        uData.setDirectoryManagerDn(dmDN);
        uData.setDirectoryManagerPwd(this.argParser.getDirectoryManagerPassword());
        LinkedList<String> baseDNs = this.argParser.baseDNArg.getValues();
        if (baseDNs.isEmpty()) {
            baseDNs.add(this.argParser.baseDNArg.getDefaultValue());
        }
        for (String baseDN : baseDNs) {
            try {
                DN.decode(baseDN);
            }
            catch (Exception e) {
                message = ToolMessages.ERR_INSTALLDS_CANNOT_PARSE_DN.get(baseDN, e.getMessage());
                errorMessages.add(message);
            }
        }
        try {
            int ldapPort = this.argParser.ldapPortArg.getIntValue();
            uData.setServerPort(ldapPort);
            int adminConnectorPort = this.argParser.adminConnectorPortArg.getIntValue();
            uData.setAdminConnectorPort(adminConnectorPort);
            if (!this.argParser.skipPortCheckArg.isPresent()) {
                Message message3;
                if (!SetupUtils.canUseAsPort(ldapPort)) {
                    message3 = SetupUtils.isPriviledgedPort(ldapPort) ? ToolMessages.ERR_INSTALLDS_CANNOT_BIND_TO_PRIVILEGED_PORT.get(ldapPort) : ToolMessages.ERR_INSTALLDS_CANNOT_BIND_TO_PORT.get(ldapPort);
                    errorMessages.add(message3);
                }
                if (!SetupUtils.canUseAsPort(adminConnectorPort)) {
                    message3 = SetupUtils.isPriviledgedPort(adminConnectorPort) ? ToolMessages.ERR_INSTALLDS_CANNOT_BIND_TO_PRIVILEGED_PORT.get(adminConnectorPort) : ToolMessages.ERR_INSTALLDS_CANNOT_BIND_TO_PORT.get(adminConnectorPort);
                    errorMessages.add(message3);
                }
            }
            if (this.argParser.jmxPortArg.isPresent()) {
                int jmxPort = this.argParser.jmxPortArg.getIntValue();
                uData.setServerJMXPort(jmxPort);
                if (!this.argParser.skipPortCheckArg.isPresent() && !SetupUtils.canUseAsPort(jmxPort)) {
                    message = SetupUtils.isPriviledgedPort(jmxPort) ? ToolMessages.ERR_INSTALLDS_CANNOT_BIND_TO_PRIVILEGED_PORT.get(jmxPort) : ToolMessages.ERR_INSTALLDS_CANNOT_BIND_TO_PORT.get(jmxPort);
                    errorMessages.add(message);
                }
            }
        }
        catch (ArgumentException ae) {
            errorMessages.add(ae.getMessageObject());
        }
        if (this.argParser.importLDIFArg.isPresent()) {
            String skippedFile;
            String rejectedFile;
            LinkedList<String> nonExistingFiles = new LinkedList<String>();
            for (String file : this.argParser.importLDIFArg.getValues()) {
                if (Utils.fileExists(file)) continue;
                nonExistingFiles.add(file);
            }
            if (nonExistingFiles.size() > 0) {
                errorMessages.add(ToolMessages.ERR_INSTALLDS_NO_SUCH_LDIF_FILE.get(Utils.getStringFromCollection(nonExistingFiles, ", ")));
            }
            if ((rejectedFile = this.argParser.rejectedImportFileArg.getValue()) != null && !Utils.canWrite(rejectedFile)) {
                errorMessages.add(ToolMessages.ERR_INSTALLDS_CANNOT_WRITE_REJECTED.get(rejectedFile));
            }
            if ((skippedFile = this.argParser.skippedImportFileArg.getValue()) != null && !Utils.canWrite(skippedFile)) {
                errorMessages.add(ToolMessages.ERR_INSTALLDS_CANNOT_WRITE_SKIPPED.get(skippedFile));
            }
            dataOptions = NewSuffixOptions.createImportFromLDIF(baseDNs, this.argParser.importLDIFArg.getValues(), rejectedFile, skippedFile);
        } else {
            dataOptions = this.argParser.addBaseEntryArg.isPresent() ? NewSuffixOptions.createBaseEntry(baseDNs) : (this.argParser.sampleDataArg.isPresent() ? NewSuffixOptions.createAutomaticallyGenerated(baseDNs, new Integer(this.argParser.sampleDataArg.getValue())) : NewSuffixOptions.createEmpty(baseDNs));
        }
        uData.setNewSuffixOptions(dataOptions);
        String certNickname = this.argParser.certNicknameArg.getValue();
        String pwd = this.argParser.getKeyStorePassword();
        boolean enableSSL = this.argParser.ldapsPortArg.isPresent();
        boolean enableStartTLS = this.argParser.enableStartTLSArg.isPresent();
        int ldapsPort = -1;
        try {
            ldapsPort = enableSSL ? this.argParser.ldapsPortArg.getIntValue() : -1;
        }
        catch (ArgumentException ae) {
            errorMessages.add(ae.getMessageObject());
        }
        if (enableSSL && !this.argParser.skipPortCheckArg.isPresent() && !SetupUtils.canUseAsPort(ldapsPort)) {
            if (SetupUtils.isPriviledgedPort(ldapsPort)) {
                errorMessages.add(ToolMessages.ERR_INSTALLDS_CANNOT_BIND_TO_PRIVILEGED_PORT.get(ldapsPort));
            } else {
                errorMessages.add(ToolMessages.ERR_INSTALLDS_CANNOT_BIND_TO_PORT.get(ldapsPort));
            }
        }
        LinkedList<String> keystoreAliases = new LinkedList<String>();
        if (this.argParser.generateSelfSignedCertificateArg.isPresent()) {
            securityOptions = SecurityOptions.createSelfSignedCertificateOptions(enableSSL, enableStartTLS, ldapsPort);
        } else if (this.argParser.useJavaKeyStoreArg.isPresent()) {
            String path = this.argParser.useJavaKeyStoreArg.getValue();
            this.checkCertificateInKeystore(SecurityOptions.CertificateType.JKS, path, pwd, certNickname, errorMessages, keystoreAliases);
            if (certNickname == null && !keystoreAliases.isEmpty()) {
                certNickname = keystoreAliases.getFirst();
            }
            securityOptions = SecurityOptions.createJKSCertificateOptions(path, pwd, enableSSL, enableStartTLS, ldapsPort, certNickname);
        } else if (this.argParser.useJCEKSArg.isPresent()) {
            String path = this.argParser.useJCEKSArg.getValue();
            this.checkCertificateInKeystore(SecurityOptions.CertificateType.JCEKS, path, pwd, certNickname, errorMessages, keystoreAliases);
            if (certNickname == null && !keystoreAliases.isEmpty()) {
                certNickname = keystoreAliases.getFirst();
            }
            securityOptions = SecurityOptions.createJCEKSCertificateOptions(path, pwd, enableSSL, enableStartTLS, ldapsPort, certNickname);
        } else if (this.argParser.usePkcs12Arg.isPresent()) {
            String path = this.argParser.usePkcs12Arg.getValue();
            this.checkCertificateInKeystore(SecurityOptions.CertificateType.PKCS12, path, pwd, certNickname, errorMessages, keystoreAliases);
            if (certNickname == null && !keystoreAliases.isEmpty()) {
                certNickname = keystoreAliases.getFirst();
            }
            securityOptions = SecurityOptions.createPKCS12CertificateOptions(path, pwd, enableSSL, enableStartTLS, ldapsPort, certNickname);
        } else if (this.argParser.usePkcs11Arg.isPresent()) {
            this.checkCertificateInKeystore(SecurityOptions.CertificateType.PKCS11, null, pwd, certNickname, errorMessages, keystoreAliases);
            if (certNickname == null && !keystoreAliases.isEmpty()) {
                certNickname = keystoreAliases.getFirst();
            }
            securityOptions = SecurityOptions.createPKCS11CertificateOptions(pwd, enableSSL, enableStartTLS, ldapsPort, certNickname);
        } else {
            securityOptions = SecurityOptions.createNoCertificateOptions();
        }
        uData.setSecurityOptions(securityOptions);
        uData.setEnableWindowsService(this.argParser.enableWindowsServiceArg.isPresent());
        uData.setStartServer(!this.argParser.doNotStartArg.isPresent());
        if (errorMessages.size() > 0) {
            throw new UserDataException(null, Utils.getMessageFromCollection(errorMessages, this.formatter.getLineBreak().toString()));
        }
    }

    private void promptIfRequired(UserData uData) throws UserDataException {
        uData.setConfigurationClassName(this.argParser.configClassArg.getValue());
        uData.setConfigurationFile(this.argParser.configFileArg.getValue());
        uData.setQuiet(this.isQuiet());
        uData.setVerbose(this.isVerbose());
        this.promptIfRequiredForDirectoryManager(uData);
        this.promptIfRequiredForPortData(uData);
        this.promptIfRequiredForImportData(uData);
        this.promptIfRequiredForSecurityData(uData);
        this.promptIfRequiredForWindowsService(uData);
        this.promptIfRequiredForStartServer(uData);
    }

    private void promptIfRequiredForDirectoryManager(UserData uData) throws UserDataException {
        LinkedList<String> dns = this.promptIfRequiredForDNs(this.argParser.directoryManagerDNArg, ToolMessages.INFO_INSTALLDS_PROMPT_ROOT_DN.get(), true);
        uData.setDirectoryManagerDn(dns.getFirst());
        String pwd = this.argParser.getDirectoryManagerPassword();
        int nTries = 0;
        while (pwd == null) {
            if (nTries >= 5) {
                throw new UserDataException(null, UtilityMessages.ERR_TRIES_LIMIT_REACHED.get(5));
            }
            String pwd1 = null;
            while (pwd1 == null) {
                pwd1 = this.readPassword(ToolMessages.INFO_INSTALLDS_PROMPT_ROOT_PASSWORD.get(), LOG);
                if (pwd1 != null && !"".equals(pwd1)) continue;
                pwd1 = null;
                this.println();
                this.println(QuickSetupMessages.INFO_EMPTY_PWD.get());
                this.println();
            }
            String pwd2 = this.readPassword(ToolMessages.INFO_INSTALLDS_PROMPT_CONFIRM_ROOT_PASSWORD.get(), LOG);
            if (pwd1.equals(pwd2)) {
                pwd = pwd1;
            } else {
                this.println();
                this.println(ToolMessages.ERR_INSTALLDS_PASSWORDS_DONT_MATCH.get());
            }
            ++nTries;
        }
        uData.setDirectoryManagerPwd(pwd);
    }

    private LinkedList<String> promptIfRequiredForDNs(StringArgument arg, Message promptMsg, boolean includeLineBreak) throws UserDataException {
        LinkedList<String> dns = new LinkedList<String>();
        boolean usedProvided = false;
        boolean firstPrompt = true;
        int nTries = 0;
        while (dns.isEmpty()) {
            if (nTries >= 5) {
                throw new UserDataException(null, UtilityMessages.ERR_TRIES_LIMIT_REACHED.get(5));
            }
            boolean prompted = false;
            if (usedProvided || !arg.isPresent()) {
                if (firstPrompt && includeLineBreak) {
                    this.println();
                }
                try {
                    String dn = this.readInput(promptMsg, arg.getDefaultValue());
                    firstPrompt = false;
                    dns.add(dn);
                    prompted = true;
                }
                catch (CLIException ce) {
                    LOG.log(Level.WARNING, "Error reading input: " + ce, ce);
                }
            } else {
                dns.addAll(arg.getValues());
                usedProvided = true;
            }
            LinkedList<String> toRemove = new LinkedList<String>();
            for (String dn : dns) {
                try {
                    DN.decode(dn);
                    if (dn.trim().length() != 0) continue;
                    toRemove.add(dn);
                    this.println(ToolMessages.ERR_INSTALLDS_EMPTY_DN_RESPONSE.get());
                }
                catch (Exception e) {
                    toRemove.add(dn);
                    Message message = prompted ? ToolMessages.ERR_INSTALLDS_INVALID_DN_RESPONSE.get() : ToolMessages.ERR_INSTALLDS_CANNOT_PARSE_DN.get(dn, e.getMessage());
                    this.println(message);
                }
            }
            if (toRemove.size() > 0) {
                this.println();
            }
            dns.removeAll(toRemove);
            ++nTries;
        }
        return dns;
    }

    private void promptIfRequiredForPortData(UserData uData) {
        LinkedList<Integer> usedPorts = new LinkedList<Integer>();
        int ldapPort = this.promptIfRequiredForPortData(this.argParser.ldapPortArg, ToolMessages.INFO_INSTALLDS_PROMPT_LDAPPORT.get(), usedPorts, true);
        uData.setServerPort(ldapPort);
        usedPorts.add(ldapPort);
        int adminConnectorPort = this.promptIfRequiredForPortData(this.argParser.adminConnectorPortArg, ToolMessages.INFO_INSTALLDS_PROMPT_ADMINCONNECTORPORT.get(), usedPorts, true);
        uData.setAdminConnectorPort(adminConnectorPort);
        usedPorts.add(adminConnectorPort);
        if (this.argParser.jmxPortArg.isPresent()) {
            int jmxPort = this.promptIfRequiredForPortData(this.argParser.jmxPortArg, ToolMessages.INFO_INSTALLDS_PROMPT_JMXPORT.get(), usedPorts, true);
            uData.setServerJMXPort(jmxPort);
        } else {
            uData.setServerJMXPort(-1);
        }
    }

    private int promptIfRequiredForPortData(IntegerArgument portArg, Message promptMsg, Collection<Integer> usedPorts, boolean includeLineBreak) {
        int portNumber = -1;
        boolean usedProvided = false;
        boolean firstPrompt = true;
        while (portNumber == -1) {
            try {
                boolean prompted = false;
                if (usedProvided || !portArg.isPresent()) {
                    int defaultValue = -1;
                    if (portArg.getDefaultValue() != null) {
                        defaultValue = Integer.parseInt(portArg.getDefaultValue());
                    }
                    if (firstPrompt && includeLineBreak) {
                        this.println();
                    }
                    portNumber = -1;
                    while (portNumber == -1) {
                        try {
                            portNumber = this.readPort(promptMsg, defaultValue);
                        }
                        catch (CLIException ce) {
                            portNumber = -1;
                            LOG.log(Level.WARNING, "Error reading input: " + ce, ce);
                        }
                    }
                    prompted = true;
                    firstPrompt = false;
                } else {
                    portNumber = portArg.getIntValue();
                    usedProvided = true;
                }
                if (!this.argParser.skipPortCheckArg.isPresent() && !SetupUtils.canUseAsPort(portNumber)) {
                    if (SetupUtils.isPriviledgedPort(portNumber)) {
                        if (prompted || includeLineBreak) {
                            this.println();
                        }
                        Message message = ToolMessages.ERR_INSTALLDS_CANNOT_BIND_TO_PRIVILEGED_PORT.get(portNumber);
                        this.println(message);
                        portNumber = -1;
                    } else {
                        if (prompted || includeLineBreak) {
                            this.println();
                        }
                        Message message = ToolMessages.ERR_INSTALLDS_CANNOT_BIND_TO_PORT.get(portNumber);
                        this.println(message);
                        this.println();
                        portNumber = -1;
                    }
                }
                if (portNumber == -1 || !usedPorts.contains(portNumber)) continue;
                Message message = ToolMessages.ERR_CONFIGDS_PORT_ALREADY_SPECIFIED.get(String.valueOf(portNumber));
                this.println(message);
                this.println();
                portNumber = -1;
            }
            catch (ArgumentException ae) {
                this.println(ae.getMessageObject());
            }
        }
        return portNumber;
    }

    private void promptIfRequiredForImportData(UserData uData) throws UserDataException {
        NewSuffixOptions dataOptions;
        LinkedList<String> baseDNs = this.promptIfRequiredForDNs(this.argParser.baseDNArg, ToolMessages.INFO_INSTALLDS_PROMPT_BASEDN.get(), true);
        if (this.argParser.importLDIFArg.isPresent()) {
            String skippedFile;
            LinkedList<String> nonExistingFiles = new LinkedList<String>();
            LinkedList<String> importLDIFFiles = new LinkedList<String>();
            for (String file : this.argParser.importLDIFArg.getValues()) {
                if (!Utils.fileExists(file)) {
                    nonExistingFiles.add(file);
                    continue;
                }
                importLDIFFiles.add(file);
            }
            if (nonExistingFiles.size() > 0) {
                this.println();
                this.println(ToolMessages.ERR_INSTALLDS_NO_SUCH_LDIF_FILE.get(Utils.getStringFromCollection(nonExistingFiles, ", ")));
            }
            while (importLDIFFiles.isEmpty()) {
                this.println();
                try {
                    String path = this.readInput(ToolMessages.INFO_INSTALLDS_PROMPT_IMPORT_FILE.get(), this.lastResetImportFile);
                    if (!Utils.fileExists(path)) {
                        this.println();
                        this.println(ToolMessages.ERR_INSTALLDS_NO_SUCH_LDIF_FILE.get(path));
                        continue;
                    }
                    importLDIFFiles.add(path);
                }
                catch (CLIException ce) {
                    LOG.log(Level.WARNING, "Error reading input: " + ce, ce);
                }
            }
            String rejectedFile = this.argParser.rejectedImportFileArg.getValue();
            if (rejectedFile != null) {
                while (!Utils.canWrite(rejectedFile)) {
                    this.println();
                    this.println(ToolMessages.ERR_INSTALLDS_CANNOT_WRITE_REJECTED.get(rejectedFile));
                    this.println();
                    try {
                        rejectedFile = this.readInput(ToolMessages.INFO_INSTALLDS_PROMPT_REJECTED_FILE.get(), this.lastResetRejectedFile);
                    }
                    catch (CLIException ce) {
                        LOG.log(Level.WARNING, "Error reading input: " + ce, ce);
                    }
                }
            }
            if ((skippedFile = this.argParser.skippedImportFileArg.getValue()) != null) {
                while (!Utils.canWrite(skippedFile)) {
                    this.println();
                    this.println(ToolMessages.ERR_INSTALLDS_CANNOT_WRITE_SKIPPED.get(skippedFile));
                    this.println();
                    try {
                        skippedFile = this.readInput(ToolMessages.INFO_INSTALLDS_PROMPT_SKIPPED_FILE.get(), this.lastResetSkippedFile);
                    }
                    catch (CLIException ce) {
                        LOG.log(Level.WARNING, "Error reading input: " + ce, ce);
                    }
                }
            }
            dataOptions = NewSuffixOptions.createImportFromLDIF(baseDNs, importLDIFFiles, rejectedFile, skippedFile);
        } else if (this.argParser.addBaseEntryArg.isPresent()) {
            dataOptions = NewSuffixOptions.createBaseEntry(baseDNs);
        } else if (this.argParser.sampleDataArg.isPresent()) {
            int numUsers;
            try {
                numUsers = this.argParser.sampleDataArg.getIntValue();
            }
            catch (ArgumentException ae) {
                this.println();
                this.println(ae.getMessageObject());
                Message message = ToolMessages.INFO_INSTALLDS_PROMPT_NUM_ENTRIES.get();
                numUsers = this.promptForInteger(message, 2000, 0, Integer.MAX_VALUE);
            }
            dataOptions = NewSuffixOptions.createAutomaticallyGenerated(baseDNs, numUsers);
        } else {
            int populateType;
            boolean POPULATE_TYPE_BASE_ONLY = true;
            int POPULATE_TYPE_LEAVE_EMPTY = 2;
            int POPULATE_TYPE_IMPORT_FROM_LDIF = 3;
            int POPULATE_TYPE_GENERATE_SAMPLE_DATA = 4;
            int[] indexes = new int[]{1, 2, 3, 4};
            Message[] msgs = new Message[]{ToolMessages.INFO_INSTALLDS_POPULATE_OPTION_BASE_ONLY.get(), ToolMessages.INFO_INSTALLDS_POPULATE_OPTION_LEAVE_EMPTY.get(), ToolMessages.INFO_INSTALLDS_POPULATE_OPTION_IMPORT_LDIF.get(), ToolMessages.INFO_INSTALLDS_POPULATE_OPTION_GENERATE_SAMPLE.get()};
            MenuBuilder<Integer> builder = new MenuBuilder<Integer>(this);
            builder.setPrompt(ToolMessages.INFO_INSTALLDS_HEADER_POPULATE_TYPE.get());
            for (int i = 0; i < indexes.length; ++i) {
                builder.addNumberedOption(msgs[i], MenuResult.success(indexes[i]), new Message[0]);
            }
            if (this.lastResetPopulateOption == null) {
                builder.setDefault(Message.raw(String.valueOf(1), new Object[0]), MenuResult.success(1));
            } else {
                switch (this.lastResetPopulateOption) {
                    case LEAVE_DATABASE_EMPTY: {
                        builder.setDefault(Message.raw(String.valueOf(2), new Object[0]), MenuResult.success(2));
                        break;
                    }
                    case IMPORT_FROM_LDIF_FILE: {
                        builder.setDefault(Message.raw(String.valueOf(3), new Object[0]), MenuResult.success(3));
                        break;
                    }
                    case IMPORT_AUTOMATICALLY_GENERATED_DATA: {
                        builder.setDefault(Message.raw(String.valueOf(4), new Object[0]), MenuResult.success(4));
                        break;
                    }
                    default: {
                        builder.setDefault(Message.raw(String.valueOf(1), new Object[0]), MenuResult.success(1));
                    }
                }
            }
            Menu menu = builder.toMenu();
            try {
                MenuResult m = menu.run();
                if (!m.isSuccess()) {
                    throw new RuntimeException();
                }
                populateType = (Integer)m.getValue();
            }
            catch (CLIException ce) {
                populateType = 1;
                LOG.log(Level.WARNING, "Error reading input: " + ce, ce);
            }
            if (populateType == 3) {
                String skippedFile;
                LinkedList<String> importLDIFFiles = new LinkedList<String>();
                while (importLDIFFiles.isEmpty()) {
                    Message message = ToolMessages.INFO_INSTALLDS_PROMPT_IMPORT_FILE.get();
                    this.println();
                    try {
                        String path = this.readInput(message, null);
                        if (Utils.fileExists(path)) {
                            importLDIFFiles.add(path);
                            continue;
                        }
                        message = ToolMessages.ERR_INSTALLDS_NO_SUCH_LDIF_FILE.get(path);
                        this.println();
                        this.println(message);
                    }
                    catch (CLIException ce) {
                        LOG.log(Level.WARNING, "Error reading input: " + ce, ce);
                    }
                }
                String rejectedFile = this.argParser.rejectedImportFileArg.getValue();
                if (rejectedFile != null) {
                    while (!Utils.canWrite(rejectedFile)) {
                        this.println();
                        this.println(ToolMessages.ERR_INSTALLDS_CANNOT_WRITE_REJECTED.get(rejectedFile));
                        this.println();
                        try {
                            rejectedFile = this.readInput(ToolMessages.INFO_INSTALLDS_PROMPT_REJECTED_FILE.get(), null);
                        }
                        catch (CLIException ce) {
                            LOG.log(Level.WARNING, "Error reading input: " + ce, ce);
                        }
                    }
                }
                if ((skippedFile = this.argParser.skippedImportFileArg.getValue()) != null) {
                    while (!Utils.canWrite(skippedFile)) {
                        this.println();
                        this.println(ToolMessages.ERR_INSTALLDS_CANNOT_WRITE_SKIPPED.get(skippedFile));
                        this.println();
                        try {
                            skippedFile = this.readInput(ToolMessages.INFO_INSTALLDS_PROMPT_SKIPPED_FILE.get(), null);
                        }
                        catch (CLIException ce) {
                            LOG.log(Level.WARNING, "Error reading input: " + ce, ce);
                        }
                    }
                }
                dataOptions = NewSuffixOptions.createImportFromLDIF(baseDNs, importLDIFFiles, rejectedFile, skippedFile);
            } else if (populateType == 4) {
                Message message = ToolMessages.INFO_INSTALLDS_PROMPT_NUM_ENTRIES.get();
                int defaultValue = this.lastResetNumEntries == null ? 2000 : this.lastResetNumEntries;
                int numUsers = this.promptForInteger(message, defaultValue, 0, Integer.MAX_VALUE);
                dataOptions = NewSuffixOptions.createAutomaticallyGenerated(baseDNs, numUsers);
            } else if (populateType == 2) {
                dataOptions = NewSuffixOptions.createEmpty(baseDNs);
            } else if (populateType == 1) {
                dataOptions = NewSuffixOptions.createBaseEntry(baseDNs);
            } else {
                throw new IllegalStateException("Unexpected populateType: " + populateType);
            }
        }
        uData.setNewSuffixOptions(dataOptions);
    }

    private void promptIfRequiredForSecurityData(UserData uData) throws UserDataException {
        SecurityOptions securityOptions;
        boolean defaultValue;
        boolean enableSSL = false;
        boolean enableStartTLS = false;
        int ldapsPort = -1;
        LinkedList<Integer> usedPorts = new LinkedList<Integer>();
        usedPorts.add(uData.getServerPort());
        if (uData.getServerJMXPort() != -1) {
            usedPorts.add(uData.getServerJMXPort());
        }
        ldapsPort = -1;
        if (!this.argParser.ldapsPortArg.isPresent()) {
            this.println();
            try {
                defaultValue = this.lastResetEnableSSL != null ? this.lastResetEnableSSL : false;
                enableSSL = this.confirmAction(ToolMessages.INFO_INSTALLDS_PROMPT_ENABLE_SSL.get(), defaultValue);
                if (enableSSL) {
                    ldapsPort = this.promptIfRequiredForPortData(this.argParser.ldapsPortArg, ToolMessages.INFO_INSTALLDS_PROMPT_LDAPSPORT.get(), usedPorts, false);
                }
            }
            catch (CLIException ce) {
                LOG.log(Level.WARNING, "Error reading input: " + ce, ce);
            }
        } else {
            ldapsPort = this.promptIfRequiredForPortData(this.argParser.ldapsPortArg, ToolMessages.INFO_INSTALLDS_PROMPT_LDAPSPORT.get(), usedPorts, true);
            enableSSL = true;
        }
        if (!this.argParser.enableStartTLSArg.isPresent()) {
            this.println();
            try {
                defaultValue = this.lastResetEnableStartTLS != null ? this.lastResetEnableStartTLS : false;
                enableStartTLS = this.confirmAction(ToolMessages.INFO_INSTALLDS_ENABLE_STARTTLS.get(), defaultValue);
            }
            catch (CLIException ce) {
                LOG.log(Level.WARNING, "Error reading input: " + ce, ce);
            }
        } else {
            enableStartTLS = true;
        }
        if (this.argParser.generateSelfSignedCertificateArg.isPresent()) {
            securityOptions = SecurityOptions.createSelfSignedCertificateOptions(enableSSL, enableStartTLS, ldapsPort);
        } else if (this.argParser.useJavaKeyStoreArg.isPresent()) {
            securityOptions = this.createSecurityOptionsPrompting(SecurityOptions.CertificateType.JKS, enableSSL, enableStartTLS, ldapsPort);
        } else if (this.argParser.useJCEKSArg.isPresent()) {
            securityOptions = this.createSecurityOptionsPrompting(SecurityOptions.CertificateType.JCEKS, enableSSL, enableStartTLS, ldapsPort);
        } else if (this.argParser.usePkcs12Arg.isPresent()) {
            securityOptions = this.createSecurityOptionsPrompting(SecurityOptions.CertificateType.PKCS12, enableSSL, enableStartTLS, ldapsPort);
        } else if (this.argParser.usePkcs11Arg.isPresent()) {
            securityOptions = this.createSecurityOptionsPrompting(SecurityOptions.CertificateType.PKCS11, enableSSL, enableStartTLS, ldapsPort);
        } else if (!enableSSL && !enableStartTLS) {
            securityOptions = SecurityOptions.createNoCertificateOptions();
        } else {
            int certType;
            boolean SELF_SIGNED = true;
            int JKS = 2;
            int JCEKS = 3;
            int PKCS12 = 4;
            int PKCS11 = 5;
            int[] indexes = new int[]{1, 2, 3, 4, 5};
            Message[] msgs = new Message[]{ToolMessages.INFO_INSTALLDS_CERT_OPTION_SELF_SIGNED.get(), ToolMessages.INFO_INSTALLDS_CERT_OPTION_JKS.get(), ToolMessages.INFO_INSTALLDS_CERT_OPTION_JCEKS.get(), ToolMessages.INFO_INSTALLDS_CERT_OPTION_PKCS12.get(), ToolMessages.INFO_INSTALLDS_CERT_OPTION_PKCS11.get()};
            MenuBuilder<Integer> builder = new MenuBuilder<Integer>(this);
            builder.setPrompt(ToolMessages.INFO_INSTALLDS_HEADER_CERT_TYPE.get());
            for (int i = 0; i < indexes.length; ++i) {
                builder.addNumberedOption(msgs[i], MenuResult.success(indexes[i]), new Message[0]);
            }
            if (this.lastResetCertType == null) {
                builder.setDefault(Message.raw(String.valueOf(1), new Object[0]), MenuResult.success(1));
            } else {
                switch (this.lastResetCertType) {
                    case JKS: {
                        builder.setDefault(Message.raw(String.valueOf(2), new Object[0]), MenuResult.success(2));
                        break;
                    }
                    case JCEKS: {
                        builder.setDefault(Message.raw(String.valueOf(3), new Object[0]), MenuResult.success(3));
                        break;
                    }
                    case PKCS11: {
                        builder.setDefault(Message.raw(String.valueOf(5), new Object[0]), MenuResult.success(5));
                        break;
                    }
                    case PKCS12: {
                        builder.setDefault(Message.raw(String.valueOf(4), new Object[0]), MenuResult.success(4));
                        break;
                    }
                    default: {
                        builder.setDefault(Message.raw(String.valueOf(1), new Object[0]), MenuResult.success(1));
                    }
                }
            }
            Menu menu = builder.toMenu();
            try {
                MenuResult m = menu.run();
                if (!m.isSuccess()) {
                    throw new RuntimeException();
                }
                certType = (Integer)m.getValue();
            }
            catch (CLIException ce) {
                LOG.log(Level.WARNING, "Error reading input: " + ce, ce);
                certType = 1;
            }
            if (certType == 1) {
                securityOptions = SecurityOptions.createSelfSignedCertificateOptions(enableSSL, enableStartTLS, ldapsPort);
            } else if (certType == 2) {
                securityOptions = this.createSecurityOptionsPrompting(SecurityOptions.CertificateType.JKS, enableSSL, enableStartTLS, ldapsPort);
            } else if (certType == 3) {
                securityOptions = this.createSecurityOptionsPrompting(SecurityOptions.CertificateType.JCEKS, enableSSL, enableStartTLS, ldapsPort);
            } else if (certType == 4) {
                securityOptions = this.createSecurityOptionsPrompting(SecurityOptions.CertificateType.PKCS12, enableSSL, enableStartTLS, ldapsPort);
            } else if (certType == 5) {
                securityOptions = this.createSecurityOptionsPrompting(SecurityOptions.CertificateType.PKCS11, enableSSL, enableStartTLS, ldapsPort);
            } else {
                throw new IllegalStateException("Unexpected cert type: " + certType);
            }
        }
        uData.setSecurityOptions(securityOptions);
    }

    private void promptIfRequiredForWindowsService(UserData uData) {
        boolean enableService = false;
        if (SetupUtils.isWindows()) {
            if (this.argParser.enableWindowsServiceArg.isPresent()) {
                enableService = true;
            } else {
                this.println();
                Message message = ToolMessages.INFO_INSTALLDS_PROMPT_ENABLE_SERVICE.get();
                try {
                    boolean defaultValue = this.lastResetEnableWindowsService == null ? false : this.lastResetEnableWindowsService;
                    enableService = this.confirmAction(message, defaultValue);
                }
                catch (CLIException ce) {
                    LOG.log(Level.WARNING, "Error reading input: " + ce, ce);
                }
            }
        }
        uData.setEnableWindowsService(enableService);
    }

    private void promptIfRequiredForStartServer(UserData uData) {
        boolean startServer = false;
        if (!this.argParser.doNotStartArg.isPresent()) {
            this.println();
            Message message = ToolMessages.INFO_INSTALLDS_PROMPT_START_SERVER.get();
            try {
                boolean defaultValue = this.lastResetStartServer == null ? true : this.lastResetStartServer;
                startServer = this.confirmAction(message, defaultValue);
            }
            catch (CLIException ce) {
                LOG.log(Level.WARNING, "Error reading input: " + ce, ce);
                startServer = true;
            }
        }
        uData.setStartServer(startServer);
    }

    private void checkCertificateInKeystore(SecurityOptions.CertificateType type, String path, String pwd, String certNickname, LinkedList<Message> errorMessages, LinkedList<String> nicknameList) {
        block35: {
            boolean errorWithPath = false;
            if (type != SecurityOptions.CertificateType.PKCS11) {
                File f = new File(path);
                if (!f.exists()) {
                    errorMessages.add(QuickSetupMessages.INFO_KEYSTORE_PATH_DOES_NOT_EXIST.get());
                    errorWithPath = true;
                } else if (!f.isFile()) {
                    errorMessages.add(QuickSetupMessages.INFO_KEYSTORE_PATH_NOT_A_FILE.get());
                    errorWithPath = true;
                }
            }
            boolean pwdProvided = true;
            if (pwd == null) {
                pwdProvided = false;
                errorMessages.add(QuickSetupMessages.INFO_ERROR_NO_KEYSTORE_PASSWORD.get());
            } else if (pwd.length() == 0) {
                pwdProvided = false;
                errorMessages.add(QuickSetupMessages.INFO_ERROR_EMPTY_KEYSTORE_PASSWORD.get());
            }
            if (!errorWithPath && pwdProvided) {
                try {
                    CertificateManager certManager;
                    switch (type) {
                        case JKS: {
                            certManager = new CertificateManager(path, "JKS", pwd);
                            break;
                        }
                        case JCEKS: {
                            certManager = new CertificateManager(path, "JCEKS", pwd);
                            break;
                        }
                        case PKCS12: {
                            certManager = new CertificateManager(path, "PKCS12", pwd);
                            break;
                        }
                        case PKCS11: {
                            certManager = new CertificateManager("NONE", "PKCS11", pwd);
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("Invalid type: " + (Object)((Object)type));
                        }
                    }
                    String[] aliases = certManager.getCertificateAliases();
                    if (aliases == null || aliases.length == 0) {
                        switch (type) {
                            case JKS: {
                                errorMessages.add(QuickSetupMessages.INFO_JKS_KEYSTORE_DOES_NOT_EXIST.get());
                                break block35;
                            }
                            case JCEKS: {
                                errorMessages.add(QuickSetupMessages.INFO_JCEKS_KEYSTORE_DOES_NOT_EXIST.get());
                                break block35;
                            }
                            case PKCS12: {
                                errorMessages.add(QuickSetupMessages.INFO_PKCS12_KEYSTORE_DOES_NOT_EXIST.get());
                                break block35;
                            }
                            case PKCS11: {
                                errorMessages.add(QuickSetupMessages.INFO_PKCS11_KEYSTORE_DOES_NOT_EXIST.get());
                                break block35;
                            }
                            default: {
                                throw new IllegalArgumentException("Invalid type: " + (Object)((Object)type));
                            }
                        }
                    }
                    for (int i = 0; i < aliases.length; ++i) {
                        nicknameList.add(aliases[i]);
                    }
                    String aliasString = Utils.getStringFromCollection(nicknameList, ", ");
                    if (certNickname != null) {
                        boolean found = false;
                        for (int i = 0; i < aliases.length && !found; ++i) {
                            found = aliases[i].equalsIgnoreCase(certNickname);
                        }
                        if (!found) {
                            errorMessages.add(ToolMessages.ERR_INSTALLDS_CERTNICKNAME_NOT_FOUND.get(aliasString));
                        }
                    } else if (aliases.length > 1) {
                        errorMessages.add(ToolMessages.ERR_INSTALLDS_MUST_PROVIDE_CERTNICKNAME.get(aliasString));
                    }
                }
                catch (KeyStoreException ke) {
                    switch (type) {
                        case JKS: {
                            errorMessages.add(QuickSetupMessages.INFO_ERROR_ACCESSING_JKS_KEYSTORE.get());
                            break;
                        }
                        case JCEKS: {
                            errorMessages.add(QuickSetupMessages.INFO_ERROR_ACCESSING_JCEKS_KEYSTORE.get());
                            break;
                        }
                        case PKCS12: {
                            errorMessages.add(QuickSetupMessages.INFO_ERROR_ACCESSING_PKCS12_KEYSTORE.get());
                            break;
                        }
                        case PKCS11: {
                            errorMessages.add(QuickSetupMessages.INFO_ERROR_ACCESSING_PKCS11_KEYSTORE.get());
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("Invalid type: " + (Object)((Object)type));
                        }
                    }
                }
            }
        }
    }

    private SecurityOptions createSecurityOptionsPrompting(SecurityOptions.CertificateType type, boolean enableSSL, boolean enableStartTLS, int ldapsPort) throws UserDataException {
        SecurityOptions securityOptions;
        String defaultPathValue;
        Message pathPrompt;
        String path;
        String certNickname = this.argParser.certNicknameArg.getValue();
        String pwd = this.argParser.getKeyStorePassword();
        if (pwd != null && pwd.length() == 0) {
            pwd = null;
        }
        switch (type) {
            case JKS: {
                path = this.argParser.useJavaKeyStoreArg.getValue();
                pathPrompt = ToolMessages.INFO_INSTALLDS_PROMPT_JKS_PATH.get();
                defaultPathValue = this.argParser.useJavaKeyStoreArg.getValue();
                if (defaultPathValue != null) break;
                defaultPathValue = this.lastResetKeyStorePath;
                break;
            }
            case JCEKS: {
                path = this.argParser.useJCEKSArg.getValue();
                pathPrompt = ToolMessages.INFO_INSTALLDS_PROMPT_JCEKS_PATH.get();
                defaultPathValue = this.argParser.useJCEKSArg.getValue();
                if (defaultPathValue != null) break;
                defaultPathValue = this.lastResetKeyStorePath;
                break;
            }
            case PKCS11: {
                path = null;
                defaultPathValue = null;
                pathPrompt = null;
                break;
            }
            case PKCS12: {
                path = this.argParser.usePkcs12Arg.getValue();
                defaultPathValue = this.argParser.usePkcs12Arg.getValue();
                if (defaultPathValue == null) {
                    defaultPathValue = this.lastResetKeyStorePath;
                }
                pathPrompt = ToolMessages.INFO_INSTALLDS_PROMPT_PKCS12_PATH.get();
                break;
            }
            default: {
                throw new IllegalStateException("Called promptIfRequiredCertificate with invalid type: " + (Object)((Object)type));
            }
        }
        LinkedList<Message> errorMessages = new LinkedList<Message>();
        LinkedList<String> keystoreAliases = new LinkedList<String>();
        boolean firstTry = true;
        int nPasswordPrompts = 0;
        while (errorMessages.size() > 0 || firstTry) {
            boolean prompted = false;
            if (errorMessages.size() > 0) {
                this.println();
                this.println(Utils.getMessageFromCollection(errorMessages, this.formatter.getLineBreak().toString()));
            }
            if (type != SecurityOptions.CertificateType.PKCS11 && (this.containsKeyStorePathErrorMessage(errorMessages) || path == null)) {
                this.println();
                try {
                    path = this.readInput(pathPrompt, defaultPathValue);
                }
                catch (CLIException ce) {
                    path = "";
                    LOG.log(Level.WARNING, "Error reading input: " + ce, ce);
                }
                prompted = true;
                if (pwd != null) {
                    errorMessages.clear();
                    keystoreAliases.clear();
                    this.checkCertificateInKeystore(type, path, pwd, certNickname, errorMessages, keystoreAliases);
                    if (!errorMessages.isEmpty()) {
                        pwd = null;
                    }
                }
            }
            if (this.containsKeyStorePasswordErrorMessage(errorMessages) || pwd == null) {
                if (!prompted) {
                    this.println();
                }
                pwd = null;
                while (pwd == null) {
                    if (nPasswordPrompts > 7) {
                        throw new UserDataException(null, ToolMessages.ERR_INSTALLDS_TOO_MANY_KEYSTORE_PASSWORD_TRIES.get(String.valueOf(7)));
                    }
                    pwd = this.readPassword(ToolMessages.INFO_INSTALLDS_PROMPT_KEYSTORE_PASSWORD.get(), LOG);
                    ++nPasswordPrompts;
                }
            }
            if (this.containsCertNicknameErrorMessage(errorMessages)) {
                if (!prompted) {
                    this.println();
                }
                certNickname = this.promptForCertificateNickname(keystoreAliases);
            }
            errorMessages.clear();
            keystoreAliases.clear();
            this.checkCertificateInKeystore(type, path, pwd, certNickname, errorMessages, keystoreAliases);
            firstTry = false;
        }
        if (certNickname == null) {
            certNickname = (String)keystoreAliases.getFirst();
        }
        switch (type) {
            case JKS: {
                securityOptions = SecurityOptions.createJKSCertificateOptions(path, pwd, enableSSL, enableStartTLS, ldapsPort, certNickname);
                break;
            }
            case JCEKS: {
                securityOptions = SecurityOptions.createJCEKSCertificateOptions(path, pwd, enableSSL, enableStartTLS, ldapsPort, certNickname);
                break;
            }
            case PKCS12: {
                securityOptions = SecurityOptions.createPKCS12CertificateOptions(path, pwd, enableSSL, enableStartTLS, ldapsPort, certNickname);
                break;
            }
            case PKCS11: {
                securityOptions = SecurityOptions.createPKCS11CertificateOptions(pwd, enableSSL, enableStartTLS, ldapsPort, certNickname);
                break;
            }
            default: {
                throw new IllegalStateException("Called createSecurityOptionsPrompting with invalid type: " + (Object)((Object)type));
            }
        }
        return securityOptions;
    }

    private boolean containsKeyStorePathErrorMessage(Collection<Message> msgs) {
        boolean found = false;
        for (Message msg : msgs) {
            if (!msg.getDescriptor().equals(QuickSetupMessages.INFO_KEYSTORE_PATH_DOES_NOT_EXIST) && !msg.getDescriptor().equals(QuickSetupMessages.INFO_KEYSTORE_PATH_NOT_A_FILE) && !msg.getDescriptor().equals(QuickSetupMessages.INFO_JKS_KEYSTORE_DOES_NOT_EXIST) && !msg.getDescriptor().equals(QuickSetupMessages.INFO_JCEKS_KEYSTORE_DOES_NOT_EXIST) && !msg.getDescriptor().equals(QuickSetupMessages.INFO_PKCS12_KEYSTORE_DOES_NOT_EXIST) && !msg.getDescriptor().equals(QuickSetupMessages.INFO_PKCS11_KEYSTORE_DOES_NOT_EXIST) && !msg.getDescriptor().equals(QuickSetupMessages.INFO_ERROR_ACCESSING_JKS_KEYSTORE) && !msg.getDescriptor().equals(QuickSetupMessages.INFO_ERROR_ACCESSING_JCEKS_KEYSTORE) && !msg.getDescriptor().equals(QuickSetupMessages.INFO_ERROR_ACCESSING_PKCS12_KEYSTORE) && !msg.getDescriptor().equals(QuickSetupMessages.INFO_ERROR_ACCESSING_PKCS11_KEYSTORE)) continue;
            found = true;
            break;
        }
        return found;
    }

    private boolean containsKeyStorePasswordErrorMessage(Collection<Message> msgs) {
        boolean found = false;
        for (Message msg : msgs) {
            if (!msg.getDescriptor().equals(QuickSetupMessages.INFO_JKS_KEYSTORE_DOES_NOT_EXIST) && !msg.getDescriptor().equals(QuickSetupMessages.INFO_JCEKS_KEYSTORE_DOES_NOT_EXIST) && !msg.getDescriptor().equals(QuickSetupMessages.INFO_PKCS12_KEYSTORE_DOES_NOT_EXIST) && !msg.getDescriptor().equals(QuickSetupMessages.INFO_PKCS11_KEYSTORE_DOES_NOT_EXIST) && !msg.getDescriptor().equals(QuickSetupMessages.INFO_ERROR_ACCESSING_JKS_KEYSTORE) && !msg.getDescriptor().equals(QuickSetupMessages.INFO_ERROR_ACCESSING_JCEKS_KEYSTORE) && !msg.getDescriptor().equals(QuickSetupMessages.INFO_ERROR_ACCESSING_PKCS12_KEYSTORE) && !msg.getDescriptor().equals(QuickSetupMessages.INFO_ERROR_ACCESSING_PKCS11_KEYSTORE) && !msg.getDescriptor().equals(QuickSetupMessages.INFO_ERROR_NO_KEYSTORE_PASSWORD) && !msg.getDescriptor().equals(QuickSetupMessages.INFO_ERROR_EMPTY_KEYSTORE_PASSWORD)) continue;
            found = true;
            break;
        }
        return found;
    }

    private boolean containsCertNicknameErrorMessage(Collection<Message> msgs) {
        boolean found = false;
        for (Message msg : msgs) {
            if (!msg.getDescriptor().equals(ToolMessages.ERR_INSTALLDS_CERTNICKNAME_NOT_FOUND) && !msg.getDescriptor().equals(ToolMessages.ERR_INSTALLDS_MUST_PROVIDE_CERTNICKNAME)) continue;
            found = true;
            break;
        }
        return found;
    }

    private boolean isPasswordTriesError(Message msg) {
        return msg.getDescriptor().equals(ToolMessages.ERR_INSTALLDS_TOO_MANY_KEYSTORE_PASSWORD_TRIES);
    }

    private int promptForInteger(Message prompt, Integer defaultValue, Integer lowerBound, Integer upperBound) {
        int returnValue = -1;
        while (returnValue == -1) {
            Message message;
            String s;
            try {
                s = this.readInput(prompt, String.valueOf(defaultValue));
            }
            catch (CLIException ce) {
                s = "";
                LOG.log(Level.WARNING, "Error reading input: " + ce, ce);
            }
            if (s.equals("")) {
                if (defaultValue == null) {
                    Message message2 = ToolMessages.ERR_INSTALLDS_INVALID_INTEGER_RESPONSE.get();
                    this.println(message2);
                    this.println();
                    continue;
                }
                returnValue = defaultValue;
                continue;
            }
            try {
                int intValue = Integer.parseInt(s);
                if (lowerBound != null && intValue < lowerBound) {
                    message = ToolMessages.ERR_INSTALLDS_INTEGER_BELOW_LOWER_BOUND.get(lowerBound);
                    this.println(message);
                    this.println();
                    continue;
                }
                if (upperBound != null && intValue > upperBound) {
                    message = ToolMessages.ERR_INSTALLDS_INTEGER_ABOVE_UPPER_BOUND.get(upperBound);
                    this.println(message);
                    this.println();
                    continue;
                }
                returnValue = intValue;
            }
            catch (NumberFormatException nfe) {
                message = ToolMessages.ERR_INSTALLDS_INVALID_INTEGER_RESPONSE.get();
                this.println(message);
                this.println();
            }
        }
        return returnValue;
    }

    private String promptForCertificateNickname(LinkedList<String> nicknames) {
        String nickname = null;
        block2: while (nickname == null) {
            for (String n : nicknames) {
                try {
                    if (!this.confirmAction(ToolMessages.INFO_INSTALLDS_PROMPT_CERTNICKNAME.get(n), true)) continue;
                    nickname = n;
                    continue block2;
                }
                catch (CLIException ce) {
                    LOG.log(Level.WARNING, "Error reading input: " + ce, ce);
                }
            }
        }
        return nickname;
    }

    private ConfirmCode askForConfirmation(UserData uData) {
        ConfirmCode returnValue;
        this.println();
        this.println();
        this.println(ToolMessages.INFO_INSTALLDS_SUMMARY.get());
        Message[] labels = new Message[]{QuickSetupMessages.INFO_SERVER_PORT_LABEL.get(), QuickSetupMessages.INFO_ADMIN_CONNECTOR_PORT_LABEL.get(), ToolMessages.INFO_INSTALLDS_SERVER_JMXPORT_LABEL.get(), QuickSetupMessages.INFO_SERVER_SECURITY_LABEL.get(), QuickSetupMessages.INFO_SERVER_DIRECTORY_MANAGER_DN_LABEL.get(), QuickSetupMessages.INFO_DIRECTORY_DATA_LABEL.get()};
        int jmxPort = uData.getServerJMXPort();
        Message[] values = new Message[]{Message.raw(String.valueOf(uData.getServerPort()), new Object[0]), Message.raw(String.valueOf(uData.getAdminConnectorPort()), new Object[0]), Message.raw(jmxPort != -1 ? String.valueOf(jmxPort) : null, new Object[0]), Message.raw(QuickSetupStepPanel.getSecurityOptionsString(uData.getSecurityOptions(), false), new Object[0]), Message.raw(uData.getDirectoryManagerDn(), new Object[0]), Message.raw(InstallReviewPanel.getDataDisplayString(uData), new Object[0])};
        int maxWidth = 0;
        for (Message l : labels) {
            maxWidth = Math.max(maxWidth, l.length());
        }
        for (int i = 0; i < labels.length; ++i) {
            StringBuilder sb = new StringBuilder();
            if (values[i] == null) continue;
            Message l = labels[i];
            sb.append(l.toString());
            sb.append(" ");
            String[] lines = values[i].toString().split(Constants.LINE_SEPARATOR);
            for (int j = 0; j < lines.length; ++j) {
                int k;
                if (j != 0) {
                    for (k = 0; k <= maxWidth; ++k) {
                        sb.append(" ");
                    }
                } else {
                    for (k = 0; k < maxWidth - l.length(); ++k) {
                        sb.append(" ");
                    }
                }
                sb.append(lines[j]);
                this.println(Message.raw(sb, new Object[0]));
                sb = new StringBuilder();
            }
        }
        this.println();
        if (uData.getStartServer()) {
            this.println(ToolMessages.INFO_INSTALLDS_START_SERVER.get());
        } else {
            this.println(ToolMessages.INFO_INSTALLDS_DO_NOT_START_SERVER.get());
        }
        this.println();
        this.println();
        Message[] msgs = new Message[]{ToolMessages.INFO_INSTALLDS_CONFIRM_INSTALL.get(), ToolMessages.INFO_INSTALLDS_PROVIDE_DATA_AGAIN.get(), ToolMessages.INFO_INSTALLDS_CANCEL.get()};
        MenuBuilder<ConfirmCode> builder = new MenuBuilder<ConfirmCode>(this);
        builder.setPrompt(ToolMessages.INFO_INSTALLDS_CONFIRM_INSTALL_PROMPT.get());
        int i = 0;
        for (ConfirmCode code : ConfirmCode.values()) {
            builder.addNumberedOption(msgs[i], MenuResult.success(code), new Message[0]);
            ++i;
        }
        builder.setDefault(Message.raw(String.valueOf(ConfirmCode.CONTINUE.getReturnCode()), new Object[0]), MenuResult.success(ConfirmCode.CONTINUE));
        Menu menu = builder.toMenu();
        try {
            MenuResult m = menu.run();
            if (!m.isSuccess()) {
                throw new RuntimeException();
            }
            returnValue = (ConfirmCode)((Object)m.getValue());
        }
        catch (CLIException ce) {
            returnValue = ConfirmCode.CANCEL;
            LOG.log(Level.WARNING, "Error reading input: " + ce, ce);
        }
        return returnValue;
    }

    private void resetArguments(UserData uData) {
        this.argParser = new InstallDSArgumentParser(InstallDS.class.getName());
        try {
            LinkedList<String> baseDNs;
            this.argParser.initializeArguments();
            this.argParser.directoryManagerDNArg.setDefaultValue(uData.getDirectoryManagerDn());
            this.argParser.ldapPortArg.setDefaultValue(String.valueOf(uData.getServerPort()));
            this.argParser.adminConnectorPortArg.setDefaultValue(String.valueOf(uData.getAdminConnectorPort()));
            int jmxPort = uData.getServerJMXPort();
            if (jmxPort != -1) {
                this.argParser.jmxPortArg.setDefaultValue(String.valueOf(jmxPort));
            }
            if (!(baseDNs = uData.getNewSuffixOptions().getBaseDns()).isEmpty()) {
                this.argParser.baseDNArg.setDefaultValue(baseDNs.getFirst());
            }
            NewSuffixOptions suffixOptions = uData.getNewSuffixOptions();
            this.lastResetPopulateOption = suffixOptions.getType();
            if (this.lastResetPopulateOption == NewSuffixOptions.Type.IMPORT_AUTOMATICALLY_GENERATED_DATA) {
                this.lastResetNumEntries = suffixOptions.getNumberEntries();
            } else if (this.lastResetPopulateOption == NewSuffixOptions.Type.IMPORT_FROM_LDIF_FILE) {
                this.lastResetImportFile = suffixOptions.getLDIFPaths().getFirst();
                this.lastResetRejectedFile = suffixOptions.getRejectedFile();
                this.lastResetSkippedFile = suffixOptions.getSkippedFile();
            }
            SecurityOptions sec = uData.getSecurityOptions();
            if (sec.getEnableSSL()) {
                this.argParser.ldapsPortArg.setDefaultValue(String.valueOf(sec.getSslPort()));
            }
            this.lastResetEnableSSL = sec.getEnableSSL();
            this.lastResetEnableStartTLS = sec.getEnableStartTLS();
            this.lastResetCertType = sec.getCertificateType();
            this.lastResetKeyStorePath = this.lastResetCertType == SecurityOptions.CertificateType.JKS || this.lastResetCertType == SecurityOptions.CertificateType.JCEKS || this.lastResetCertType == SecurityOptions.CertificateType.PKCS12 ? sec.getKeystorePath() : null;
            this.lastResetEnableWindowsService = uData.getEnableWindowsService();
            this.lastResetStartServer = uData.getStartServer();
        }
        catch (Throwable t) {
            LOG.log(Level.WARNING, "Error resetting arguments: " + t, t);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum ConfirmCode {
        CONTINUE(1),
        PROVIDE_INFORMATION_AGAIN(2),
        CANCEL(3);

        private int returnCode;

        private ConfirmCode(int returnCode) {
            this.returnCode = returnCode;
        }

        public int getReturnCode() {
            return this.returnCode;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum ErrorReturnCode {
        SUCCESSFUL(0),
        SUCCESSFUL_NOP(0),
        ERROR_UNEXPECTED(1),
        ERROR_USER_DATA(2),
        ERROR_SERVER_ALREADY_INSTALLED(3),
        ERROR_INITIALIZING_SERVER(4),
        ERROR_PASSWORD_LIMIT(5),
        ERROR_USER_CANCELLED(6);

        private int returnCode;

        private ErrorReturnCode(int returnCode) {
            this.returnCode = returnCode;
        }

        public int getReturnCode() {
            return this.returnCode;
        }
    }
}

