/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.tools.dsreplication;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.InitialContext;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NameNotFoundException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.InitialLdapContext;
import org.opends.admin.ads.ADSContext;
import org.opends.admin.ads.ADSContextException;
import org.opends.admin.ads.ReplicaDescriptor;
import org.opends.admin.ads.ServerDescriptor;
import org.opends.admin.ads.SuffixDescriptor;
import org.opends.admin.ads.TopologyCache;
import org.opends.admin.ads.TopologyCacheException;
import org.opends.admin.ads.TopologyCacheFilter;
import org.opends.admin.ads.util.ApplicationTrustManager;
import org.opends.admin.ads.util.ConnectionUtils;
import org.opends.admin.ads.util.PreferredConnection;
import org.opends.admin.ads.util.ServerLoader;
import org.opends.messages.AdminToolMessages;
import org.opends.messages.Message;
import org.opends.messages.MessageBuilder;
import org.opends.messages.QuickSetupMessages;
import org.opends.messages.ToolMessages;
import org.opends.quicksetup.ApplicationException;
import org.opends.quicksetup.Constants;
import org.opends.quicksetup.QuickSetupLog;
import org.opends.quicksetup.ReturnCode;
import org.opends.quicksetup.event.ProgressUpdateEvent;
import org.opends.quicksetup.event.ProgressUpdateListener;
import org.opends.quicksetup.installer.InstallerHelper;
import org.opends.quicksetup.installer.PeerNotFoundException;
import org.opends.quicksetup.installer.offline.OfflineInstaller;
import org.opends.quicksetup.util.PlainTextProgressMessageFormatter;
import org.opends.quicksetup.util.Utils;
import org.opends.server.admin.AttributeTypePropertyDefinition;
import org.opends.server.admin.ClassLoaderProvider;
import org.opends.server.admin.ClassPropertyDefinition;
import org.opends.server.admin.DefaultBehaviorException;
import org.opends.server.admin.ManagedObjectNotFoundException;
import org.opends.server.admin.client.ManagementContext;
import org.opends.server.admin.client.ldap.JNDIDirContextAdaptor;
import org.opends.server.admin.client.ldap.LDAPManagementContext;
import org.opends.server.admin.std.client.CryptoManagerCfgClient;
import org.opends.server.admin.std.client.ReplicationDomainCfgClient;
import org.opends.server.admin.std.client.ReplicationServerCfgClient;
import org.opends.server.admin.std.client.ReplicationSynchronizationProviderCfgClient;
import org.opends.server.admin.std.client.RootCfgClient;
import org.opends.server.admin.std.meta.ReplicationDomainCfgDefn;
import org.opends.server.admin.std.meta.ReplicationServerCfgDefn;
import org.opends.server.admin.std.meta.ReplicationSynchronizationProviderCfgDefn;
import org.opends.server.core.DirectoryServer;
import org.opends.server.replication.plugin.MultimasterReplication;
import org.opends.server.tools.ClientException;
import org.opends.server.tools.dsreplication.DisableReplicationUserData;
import org.opends.server.tools.dsreplication.EnableReplicationUserData;
import org.opends.server.tools.dsreplication.InitializeAllReplicationUserData;
import org.opends.server.tools.dsreplication.InitializeReplicationUserData;
import org.opends.server.tools.dsreplication.PostExternalInitializationUserData;
import org.opends.server.tools.dsreplication.PreExternalInitializationUserData;
import org.opends.server.tools.dsreplication.ReplicationCliArgumentParser;
import org.opends.server.tools.dsreplication.ReplicationCliException;
import org.opends.server.tools.dsreplication.ReplicationCliReturnCode;
import org.opends.server.tools.dsreplication.ReplicationUserData;
import org.opends.server.tools.dsreplication.StatusReplicationUserData;
import org.opends.server.types.DN;
import org.opends.server.types.InitializationException;
import org.opends.server.types.NullOutputStream;
import org.opends.server.types.OpenDsException;
import org.opends.server.util.SetupUtils;
import org.opends.server.util.args.ArgumentException;
import org.opends.server.util.cli.CLIException;
import org.opends.server.util.cli.ConsoleApplication;
import org.opends.server.util.cli.LDAPConnectionConsoleInteraction;
import org.opends.server.util.cli.MenuBuilder;
import org.opends.server.util.cli.MenuResult;
import org.opends.server.util.table.TableBuilder;
import org.opends.server.util.table.TextTablePrinter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReplicationCliMain
extends ConsoleApplication {
    private static final String CLASS_NAME = ReplicationCliMain.class.getName();
    public static final String LOG_FILE_PREFIX = "opends-replication-";
    public static final String LOG_FILE_SUFFIX = ".log";
    private boolean forceNonInteractive;
    private static final Logger LOG = Logger.getLogger(ReplicationCliMain.class.getName());
    private boolean useSSL = true;
    private boolean useStartTLS = false;
    private ReplicationCliArgumentParser argParser;
    private LDAPConnectionConsoleInteraction ci = null;
    PlainTextProgressMessageFormatter formatter = new PlainTextProgressMessageFormatter();

    public ReplicationCliMain(PrintStream out, PrintStream err, InputStream in) {
        super(in, (OutputStream)out, (OutputStream)err);
    }

    public static void main(String[] args) {
        int retCode = ReplicationCliMain.mainCLI(args, true, System.out, System.err, System.in);
        System.exit(retCode);
    }

    public static int mainCLI(String[] args) {
        return ReplicationCliMain.mainCLI(args, true, System.out, System.err, System.in);
    }

    public static int mainCLI(String[] args, boolean initializeServer, OutputStream outStream, OutputStream errStream, InputStream inStream) {
        PrintStream out = outStream == null ? NullOutputStream.printStream() : new PrintStream(outStream);
        PrintStream err = errStream == null ? NullOutputStream.printStream() : new PrintStream(errStream);
        try {
            QuickSetupLog.initLogFileHandler(File.createTempFile(LOG_FILE_PREFIX, LOG_FILE_SUFFIX), "org.opends.guitools.replicationcli");
            QuickSetupLog.disableConsoleLogging();
        }
        catch (Throwable t) {
            System.err.println("Unable to initialize log");
            t.printStackTrace();
        }
        ReplicationCliMain replicationCli = new ReplicationCliMain(out, err, inStream);
        return replicationCli.execute(args, initializeServer);
    }

    public int execute(String[] args, boolean initializeServer) {
        Message message;
        ReplicationCliReturnCode returnValue = ReplicationCliReturnCode.SUCCESSFUL_NOP;
        try {
            this.argParser = new ReplicationCliArgumentParser(CLASS_NAME);
            this.argParser.initializeParser(this.getOutputStream());
        }
        catch (ArgumentException ae) {
            message = ToolMessages.ERR_CANNOT_INITIALIZE_ARGS.get(ae.getMessage());
            this.println(message);
            LOG.log(Level.SEVERE, "Complete error stack:", ae);
            returnValue = ReplicationCliReturnCode.CANNOT_INITIALIZE_ARGS;
        }
        if (returnValue == ReplicationCliReturnCode.SUCCESSFUL_NOP) {
            try {
                this.argParser.parseArguments(args);
            }
            catch (ArgumentException ae) {
                message = ToolMessages.ERR_ERROR_PARSING_ARGS.get(ae.getMessage());
                this.println(message);
                this.println();
                this.println(Message.raw(this.argParser.getUsage(), new Object[0]));
                LOG.log(Level.SEVERE, "Complete error stack:", ae);
                returnValue = ReplicationCliReturnCode.ERROR_USER_DATA;
            }
        }
        if (!this.argParser.usageOrVersionDisplayed()) {
            if (returnValue == ReplicationCliReturnCode.SUCCESSFUL_NOP) {
                MessageBuilder buf = new MessageBuilder();
                this.argParser.validateOptions(buf);
                if (buf.length() > 0) {
                    this.println(buf.toMessage());
                    this.println(Message.raw(this.argParser.getUsage(), new Object[0]));
                    returnValue = ReplicationCliReturnCode.ERROR_USER_DATA;
                }
            }
            if (initializeServer) {
                DirectoryServer.bootstrapClient();
                try {
                    ClassLoaderProvider.getInstance().enable();
                    ClassPropertyDefinition.setAllowClassValidation(false);
                    AttributeTypePropertyDefinition.setCheckSchema(false);
                }
                catch (InitializationException ie) {
                    this.println(ie.getMessageObject());
                    returnValue = ReplicationCliReturnCode.ERROR_INITIALIZING_ADMINISTRATION_FRAMEWORK;
                }
            }
            if (returnValue == ReplicationCliReturnCode.SUCCESSFUL_NOP) {
                this.ci = new LDAPConnectionConsoleInteraction(this, this.argParser.getSecureArgsList());
                this.ci.setDisplayLdapIfSecureParameters(!this.argParser.isInitializeAllReplicationSubcommand() && !this.argParser.isPreExternalInitializationSubcommand() || !this.argParser.isPostExternalInitializationSubcommand());
            }
            if (returnValue == ReplicationCliReturnCode.SUCCESSFUL_NOP) {
                File logFile;
                boolean subcommandLaunched = true;
                if (this.argParser.isEnableReplicationSubcommand()) {
                    returnValue = this.enableReplication();
                } else if (this.argParser.isDisableReplicationSubcommand()) {
                    returnValue = this.disableReplication();
                } else if (this.argParser.isInitializeReplicationSubcommand()) {
                    returnValue = this.initializeReplication();
                } else if (this.argParser.isInitializeAllReplicationSubcommand()) {
                    returnValue = this.initializeAllReplication();
                } else if (this.argParser.isPreExternalInitializationSubcommand()) {
                    returnValue = this.preExternalInitialization();
                } else if (this.argParser.isPostExternalInitializationSubcommand()) {
                    returnValue = this.postExternalInitialization();
                } else if (this.argParser.isStatusReplicationSubcommand()) {
                    returnValue = this.statusReplication();
                } else if (this.argParser.isInteractive()) {
                    String subCommand = null;
                    switch (this.promptForSubcommand()) {
                        case ENABLE: {
                            subCommand = "enable";
                            break;
                        }
                        case DISABLE: {
                            subCommand = "disable";
                            break;
                        }
                        case INITIALIZE: {
                            subCommand = "initialize";
                            break;
                        }
                        case INITIALIZE_ALL: {
                            subCommand = "initialize-all";
                            break;
                        }
                        case PRE_EXTERNAL_INITIALIZATION: {
                            subCommand = "pre-external-initialization";
                            break;
                        }
                        case POST_EXTERNAL_INITIALIZATION: {
                            subCommand = "post-external-initialization";
                            break;
                        }
                        case STATUS: {
                            subCommand = "status";
                            break;
                        }
                        default: {
                            returnValue = ReplicationCliReturnCode.USER_CANCELLED;
                        }
                    }
                    if (subCommand != null) {
                        String[] newArgs = new String[args.length + 1];
                        newArgs[0] = subCommand;
                        for (int i = 0; i < args.length; ++i) {
                            newArgs[i + 1] = args[i];
                        }
                        return this.execute(newArgs, false);
                    }
                } else {
                    this.println(AdminToolMessages.ERR_REPLICATION_VALID_SUBCOMMAND_NOT_FOUND.get("--no-prompt"));
                    this.println(Message.raw(this.argParser.getUsage(), new Object[0]));
                    returnValue = ReplicationCliReturnCode.ERROR_USER_DATA;
                    subcommandLaunched = false;
                }
                if (subcommandLaunched && returnValue == ReplicationCliReturnCode.SUCCESSFUL_NOP && (logFile = QuickSetupLog.getLogFile()) != null) {
                    this.println();
                    this.println(QuickSetupMessages.INFO_GENERAL_SEE_FOR_DETAILS.get(logFile.getPath()));
                    this.println();
                }
            }
        }
        return returnValue.getReturnCode();
    }

    private ReplicationCliReturnCode enableReplication() {
        ReplicationCliReturnCode returnValue;
        block5: {
            returnValue = ReplicationCliReturnCode.SUCCESSFUL_NOP;
            EnableReplicationUserData uData = new EnableReplicationUserData();
            if (this.argParser.isInteractive()) {
                try {
                    if (this.promptIfRequired(uData)) {
                        returnValue = this.enableReplication(uData);
                        break block5;
                    }
                    returnValue = ReplicationCliReturnCode.USER_CANCELLED;
                }
                catch (ReplicationCliException rce) {
                    returnValue = rce.getErrorCode();
                    this.println();
                    this.println(this.getCriticalExceptionMessage(rce));
                }
            } else {
                this.initializeWithArgParser(uData);
                returnValue = this.enableReplication(uData);
            }
        }
        return returnValue;
    }

    private ReplicationCliReturnCode disableReplication() {
        ReplicationCliReturnCode returnValue;
        block5: {
            returnValue = ReplicationCliReturnCode.SUCCESSFUL_NOP;
            DisableReplicationUserData uData = new DisableReplicationUserData();
            if (this.argParser.isInteractive()) {
                try {
                    if (this.promptIfRequired(uData)) {
                        returnValue = this.disableReplication(uData);
                        break block5;
                    }
                    returnValue = ReplicationCliReturnCode.USER_CANCELLED;
                }
                catch (ReplicationCliException rce) {
                    returnValue = rce.getErrorCode();
                    this.println();
                    this.println(this.getCriticalExceptionMessage(rce));
                }
            } else {
                this.initializeWithArgParser(uData);
                returnValue = this.disableReplication(uData);
            }
        }
        return returnValue;
    }

    private ReplicationCliReturnCode initializeAllReplication() {
        ReplicationCliReturnCode returnValue = ReplicationCliReturnCode.SUCCESSFUL_NOP;
        InitializeAllReplicationUserData uData = new InitializeAllReplicationUserData();
        if (this.argParser.isInteractive()) {
            returnValue = this.promptIfRequired(uData) ? this.initializeAllReplication(uData) : ReplicationCliReturnCode.USER_CANCELLED;
        } else {
            this.initializeWithArgParser(uData);
            returnValue = this.initializeAllReplication(uData);
        }
        return returnValue;
    }

    private ReplicationCliReturnCode preExternalInitialization() {
        ReplicationCliReturnCode returnValue = ReplicationCliReturnCode.SUCCESSFUL_NOP;
        PreExternalInitializationUserData uData = new PreExternalInitializationUserData();
        if (this.argParser.isInteractive()) {
            returnValue = this.promptIfRequired(uData) ? this.preExternalInitialization(uData) : ReplicationCliReturnCode.USER_CANCELLED;
        } else {
            this.initializeWithArgParser(uData);
            returnValue = this.preExternalInitialization(uData);
        }
        return returnValue;
    }

    private ReplicationCliReturnCode postExternalInitialization() {
        ReplicationCliReturnCode returnValue = ReplicationCliReturnCode.SUCCESSFUL_NOP;
        PostExternalInitializationUserData uData = new PostExternalInitializationUserData();
        if (this.argParser.isInteractive()) {
            returnValue = this.promptIfRequired(uData) ? this.postExternalInitialization(uData) : ReplicationCliReturnCode.USER_CANCELLED;
        } else {
            this.initializeWithArgParser(uData);
            returnValue = this.postExternalInitialization(uData);
        }
        return returnValue;
    }

    private ReplicationCliReturnCode statusReplication() {
        ReplicationCliReturnCode returnValue;
        block5: {
            returnValue = ReplicationCliReturnCode.SUCCESSFUL_NOP;
            StatusReplicationUserData uData = new StatusReplicationUserData();
            if (this.argParser.isInteractive()) {
                try {
                    if (this.promptIfRequired(uData)) {
                        returnValue = this.statusReplication(uData);
                        break block5;
                    }
                    returnValue = ReplicationCliReturnCode.USER_CANCELLED;
                }
                catch (ReplicationCliException rce) {
                    returnValue = rce.getErrorCode();
                    this.println();
                    this.println(this.getCriticalExceptionMessage(rce));
                }
            } else {
                this.initializeWithArgParser(uData);
                returnValue = this.statusReplication(uData);
            }
        }
        return returnValue;
    }

    private ReplicationCliReturnCode initializeReplication() {
        ReplicationCliReturnCode returnValue = ReplicationCliReturnCode.SUCCESSFUL_NOP;
        InitializeReplicationUserData uData = new InitializeReplicationUserData();
        if (this.argParser.isInteractive()) {
            returnValue = this.promptIfRequired(uData) ? this.initializeReplication(uData) : ReplicationCliReturnCode.USER_CANCELLED;
        } else {
            this.initializeWithArgParser(uData);
            returnValue = this.initializeReplication(uData);
        }
        return returnValue;
    }

    private boolean promptIfRequired(EnableReplicationUserData uData) throws ReplicationCliException {
        boolean cancelled = false;
        boolean administratorDefined = false;
        this.ci.setUseAdminOrBindDn(true);
        String adminPwd = this.argParser.getBindPasswordAdmin();
        String adminUid = this.argParser.getAdministratorUID();
        String host1 = this.argParser.getHostName1();
        int port1 = this.argParser.getPort1();
        String bindDn1 = this.argParser.getBindDn1();
        String pwd1 = this.argParser.getBindPassword1();
        Object pwd = null;
        pwd = pwd1 != null ? pwd1 : (bindDn1 != null ? null : adminPwd);
        this.initializeGlobalArguments(host1, port1, adminUid, bindDn1, (String)pwd);
        InitialLdapContext ctx1 = null;
        while (ctx1 == null && !cancelled) {
            try {
                this.ci.setHeadingMessage(AdminToolMessages.INFO_REPLICATION_ENABLE_HOST1_CONNECTION_PARAMETERS.get());
                this.ci.run();
                host1 = this.ci.getHostName();
                port1 = this.ci.getPortNumber();
                if (this.ci.getProvidedAdminUID() != null) {
                    adminUid = this.ci.getProvidedAdminUID();
                    if (this.ci.getProvidedBindDN() == null) {
                        adminPwd = this.ci.getBindPassword();
                    }
                }
                bindDn1 = this.ci.getBindDN();
                pwd1 = this.ci.getBindPassword();
                ctx1 = this.createInitialLdapContextInteracting(this.ci);
                if (ctx1 != null) continue;
                cancelled = true;
            }
            catch (ClientException ce) {
                LOG.log(Level.WARNING, "Client exception " + ce);
                this.println();
                this.println(ce.getMessageObject());
                this.println();
                this.resetConnectionArguments();
            }
            catch (ArgumentException ae) {
                LOG.log(Level.WARNING, "Argument exception " + ae);
                this.println();
                this.println(ae.getMessageObject());
                this.println();
                cancelled = true;
            }
        }
        if (!cancelled) {
            uData.setHostName1(host1);
            uData.setPort1(port1);
            uData.setBindDn1(bindDn1);
            uData.setPwd1(pwd1);
        }
        int replicationPort1 = -1;
        boolean secureReplication1 = this.argParser.isSecureReplication1();
        if (ctx1 != null) {
            InitialLdapContext[] aux;
            if (!this.hasReplicationPort(ctx1)) {
                boolean tryWithDefault;
                boolean bl = tryWithDefault = this.argParser.getReplicationPort1() != -1;
                while (replicationPort1 == -1) {
                    if (tryWithDefault) {
                        replicationPort1 = this.argParser.getReplicationPort1();
                        tryWithDefault = false;
                    } else {
                        replicationPort1 = this.askPort(AdminToolMessages.INFO_REPLICATION_ENABLE_REPLICATIONPORT1_PROMPT.get(), this.argParser.getDefaultReplicationPort1());
                        this.println();
                    }
                    if (!this.argParser.skipReplicationPortCheck() && this.isLocalHost(host1)) {
                        if (SetupUtils.canUseAsPort(replicationPort1)) continue;
                        this.println();
                        this.println(this.getCannotBindToPortError(replicationPort1));
                        this.println();
                        replicationPort1 = -1;
                        continue;
                    }
                    if (replicationPort1 != port1) continue;
                    this.println();
                    this.println(AdminToolMessages.ERR_REPLICATION_PORT_AND_REPLICATION_PORT_EQUAL.get(host1, String.valueOf(replicationPort1)));
                    this.println();
                    replicationPort1 = -1;
                }
                if (!secureReplication1) {
                    try {
                        secureReplication1 = this.askConfirmation(AdminToolMessages.INFO_REPLICATION_ENABLE_SECURE1_PROMPT.get(String.valueOf(replicationPort1)), false, LOG);
                    }
                    catch (CLIException ce) {
                        this.println(ce.getMessageObject());
                        cancelled = true;
                    }
                    this.println();
                }
            }
            cancelled = !this.loadADSAndAcceptCertificates(aux = new InitialLdapContext[]{ctx1}, uData, true);
            ctx1 = aux[0];
            if (!cancelled) {
                administratorDefined |= this.hasAdministrator(ctx1);
                if (uData.getAdminPwd() != null) {
                    adminPwd = uData.getAdminPwd();
                }
            }
        }
        uData.setReplicationPort1(replicationPort1);
        uData.setSecureReplication1(secureReplication1);
        String host2 = null;
        int port2 = -1;
        String bindDn2 = null;
        String pwd2 = null;
        this.ci.resetHeadingDisplayed();
        if (!cancelled) {
            host2 = this.argParser.getHostName2();
            port2 = this.argParser.getPort2();
            bindDn2 = this.argParser.getBindDn2();
            pwd2 = this.argParser.getBindPassword2();
            pwd = pwd2 != null ? pwd2 : (bindDn2 != null ? null : adminPwd);
            this.initializeGlobalArguments(host2, port2, adminUid, bindDn2, (String)pwd);
        }
        InitialLdapContext ctx2 = null;
        while (ctx2 == null && !cancelled) {
            try {
                this.ci.setHeadingMessage(AdminToolMessages.INFO_REPLICATION_ENABLE_HOST2_CONNECTION_PARAMETERS.get());
                this.ci.run();
                host2 = this.ci.getHostName();
                port2 = this.ci.getPortNumber();
                if (this.ci.getProvidedAdminUID() != null) {
                    adminUid = this.ci.getProvidedAdminUID();
                    if (this.ci.getProvidedBindDN() == null) {
                        adminPwd = this.ci.getBindPassword();
                    }
                }
                bindDn2 = this.ci.getBindDN();
                pwd2 = this.ci.getBindPassword();
                boolean error = false;
                if (host1.equalsIgnoreCase(host2) && port1 == port2) {
                    port2 = -1;
                    Message message = AdminToolMessages.ERR_REPLICATION_ENABLE_SAME_SERVER_PORT.get(host1, String.valueOf(port1));
                    this.println();
                    this.println(message);
                    this.println();
                    error = true;
                }
                if (error || (ctx2 = this.createInitialLdapContextInteracting(this.ci)) != null) continue;
                cancelled = true;
            }
            catch (ClientException ce) {
                LOG.log(Level.WARNING, "Client exception " + ce);
                this.println();
                this.println(ce.getMessageObject());
                this.println();
                this.resetConnectionArguments();
            }
            catch (ArgumentException ae) {
                LOG.log(Level.WARNING, "Argument exception " + ae);
                this.println();
                this.println(ae.getMessageObject());
                this.println();
                cancelled = true;
            }
        }
        if (!cancelled) {
            uData.setHostName2(host2);
            uData.setPort2(port2);
            uData.setBindDn2(bindDn2);
            uData.setPwd2(pwd2);
        }
        int replicationPort2 = -1;
        boolean secureReplication2 = this.argParser.isSecureReplication2();
        if (ctx2 != null) {
            InitialLdapContext[] aux;
            if (!this.hasReplicationPort(ctx2)) {
                boolean tryWithDefault;
                boolean bl = tryWithDefault = this.argParser.getReplicationPort2() != -1;
                while (replicationPort2 == -1) {
                    if (tryWithDefault) {
                        replicationPort2 = this.argParser.getReplicationPort2();
                        tryWithDefault = false;
                    } else {
                        replicationPort2 = this.askPort(AdminToolMessages.INFO_REPLICATION_ENABLE_REPLICATIONPORT2_PROMPT.get(), this.argParser.getDefaultReplicationPort2());
                        this.println();
                    }
                    if (!this.argParser.skipReplicationPortCheck() && this.isLocalHost(host2)) {
                        if (!SetupUtils.canUseAsPort(replicationPort2)) {
                            this.println();
                            this.println(this.getCannotBindToPortError(replicationPort2));
                            this.println();
                            replicationPort2 = -1;
                        }
                    } else if (replicationPort2 == port2) {
                        this.println();
                        this.println(AdminToolMessages.ERR_REPLICATION_PORT_AND_REPLICATION_PORT_EQUAL.get(host2, String.valueOf(replicationPort2)));
                        replicationPort2 = -1;
                    }
                    if (!host1.equalsIgnoreCase(host2) || replicationPort1 <= 0 || replicationPort1 != replicationPort2) continue;
                    this.println();
                    this.println(AdminToolMessages.ERR_REPLICATION_SAME_REPLICATION_PORT.get(String.valueOf(replicationPort2), host1));
                    this.println();
                    replicationPort2 = -1;
                }
                if (!secureReplication2) {
                    try {
                        secureReplication2 = this.askConfirmation(AdminToolMessages.INFO_REPLICATION_ENABLE_SECURE2_PROMPT.get(String.valueOf(replicationPort2)), false, LOG);
                    }
                    catch (CLIException ce) {
                        this.println(ce.getMessageObject());
                        cancelled = true;
                    }
                    this.println();
                }
            }
            cancelled = !this.loadADSAndAcceptCertificates(aux = new InitialLdapContext[]{ctx2}, uData, false);
            ctx2 = aux[0];
            if (!cancelled) {
                administratorDefined |= this.hasAdministrator(ctx2);
            }
        }
        uData.setReplicationPort2(replicationPort2);
        uData.setSecureReplication2(secureReplication2);
        boolean promptedForAdmin = false;
        if (!cancelled && uData.getAdminUid() == null && !administratorDefined) {
            if (adminUid == null) {
                this.println(AdminToolMessages.INFO_REPLICATION_ENABLE_ADMINISTRATOR_MUST_BE_CREATED.get());
                promptedForAdmin = true;
                adminUid = this.askForAdministratorUID(this.argParser.getDefaultAdministratorUID());
                this.println();
            }
            uData.setAdminUid(adminUid);
        }
        if (uData.getAdminPwd() == null) {
            uData.setAdminPwd(adminPwd);
        }
        if (!cancelled && uData.getAdminPwd() == null && !administratorDefined) {
            adminPwd = null;
            while (adminPwd == null) {
                if (!promptedForAdmin) {
                    this.println();
                    this.println(AdminToolMessages.INFO_REPLICATION_ENABLE_ADMINISTRATOR_MUST_BE_CREATED.get());
                    this.println();
                }
                while (adminPwd == null) {
                    adminPwd = this.askForAdministratorPwd();
                    this.println();
                }
                String adminPwdConfirm = null;
                while (adminPwdConfirm == null) {
                    adminPwdConfirm = this.readPassword(AdminToolMessages.INFO_ADMINISTRATOR_PWD_CONFIRM_PROMPT.get(), LOG);
                    this.println();
                }
                if (adminPwd.equals(adminPwdConfirm)) continue;
                this.println();
                this.println(AdminToolMessages.ERR_ADMINISTRATOR_PWD_DO_NOT_MATCH.get());
                this.println();
                adminPwd = null;
            }
            uData.setAdminPwd(adminPwd);
        }
        if (!cancelled) {
            LinkedList<String> suffixes = this.argParser.getBaseDNs();
            this.checkSuffixesForEnableReplication(suffixes, ctx1, ctx2, true);
            cancelled = suffixes.isEmpty();
            uData.setBaseDNs(suffixes);
        }
        if (ctx1 != null) {
            try {
                ctx1.close();
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        if (ctx2 != null) {
            try {
                ctx2.close();
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        uData.setReplicateSchema(!this.argParser.noSchemaReplication());
        return !cancelled;
    }

    private boolean promptIfRequired(DisableReplicationUserData uData) throws ReplicationCliException {
        boolean cancelled = false;
        String adminPwd = this.argParser.getBindPasswordAdmin();
        String adminUid = this.argParser.getAdministratorUID();
        String bindDn = this.argParser.getBindDNToDisable();
        String host = this.argParser.getHostNameToDisable();
        int port = this.argParser.getPortToDisable();
        InitialContext ctx = null;
        while (ctx == null && !cancelled) {
            try {
                this.ci.setUseAdminOrBindDn(true);
                this.ci.run();
                host = this.ci.getHostName();
                port = this.ci.getPortNumber();
                bindDn = this.ci.getProvidedBindDN();
                adminUid = this.ci.getProvidedAdminUID();
                adminPwd = this.ci.getBindPassword();
                ctx = this.createInitialLdapContextInteracting(this.ci);
                if (ctx != null) continue;
                cancelled = true;
            }
            catch (ClientException ce) {
                LOG.log(Level.WARNING, "Client exception " + ce);
                this.println();
                this.println(ce.getMessageObject());
                this.println();
                this.resetConnectionArguments();
            }
            catch (ArgumentException ae) {
                LOG.log(Level.WARNING, "Argument exception " + ae);
                this.println();
                this.println(ae.getMessageObject());
                this.println();
                cancelled = true;
            }
        }
        if (!cancelled) {
            uData.setHostName(host);
            uData.setPort(port);
            uData.setAdminUid(adminUid);
            uData.setBindDn(bindDn);
            uData.setAdminPwd(adminPwd);
        }
        if (ctx != null && adminUid != null) {
            InitialLdapContext[] aux = new InitialLdapContext[]{ctx};
            cancelled = !this.loadADSAndAcceptCertificates(aux, uData, false);
            ctx = aux[0];
        }
        if (!cancelled) {
            LinkedList<String> suffixes = this.argParser.getBaseDNs();
            this.checkSuffixesForDisableReplication(suffixes, (InitialLdapContext)ctx, true);
            cancelled = suffixes.isEmpty();
            uData.setBaseDNs(suffixes);
        }
        if (!cancelled) {
            boolean disableADS = false;
            boolean disableSchema = false;
            for (String dn : uData.getBaseDNs()) {
                if (Utils.areDnsEqual(ADSContext.getAdministrationSuffixDN(), dn)) {
                    disableADS = true;
                    continue;
                }
                if (!Utils.areDnsEqual("cn=schema", dn)) continue;
                disableSchema = true;
            }
            if (disableADS) {
                this.println();
                try {
                    cancelled = !this.askConfirmation(AdminToolMessages.INFO_REPLICATION_CONFIRM_DISABLE_ADS.get(ADSContext.getAdministrationSuffixDN()), true, LOG);
                }
                catch (CLIException ce) {
                    this.println(ce.getMessageObject());
                    cancelled = true;
                }
                this.println();
            }
            if (disableSchema) {
                this.println();
                try {
                    cancelled = !this.askConfirmation(AdminToolMessages.INFO_REPLICATION_CONFIRM_DISABLE_SCHEMA.get(), true, LOG);
                }
                catch (CLIException ce) {
                    this.println(ce.getMessageObject());
                    cancelled = true;
                }
                this.println();
            }
            if (!disableSchema && !disableADS) {
                this.println();
                try {
                    cancelled = this.disableAllBaseDns((InitialLdapContext)ctx, uData) ? !this.askConfirmation(AdminToolMessages.INFO_REPLICATION_CONFIRM_DISABLE_LAST_SUFFIXES.get(), true, LOG) : !this.askConfirmation(AdminToolMessages.INFO_REPLICATION_CONFIRM_DISABLE_GENERIC.get(), true, LOG);
                }
                catch (CLIException ce) {
                    this.println(ce.getMessageObject());
                    cancelled = true;
                }
                this.println();
            }
        }
        if (ctx != null) {
            try {
                ctx.close();
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        return !cancelled;
    }

    private boolean promptIfRequired(InitializeAllReplicationUserData uData) {
        boolean cancelled = false;
        String adminPwd = this.argParser.getBindPasswordAdmin();
        String adminUid = this.argParser.getAdministratorUID();
        String host = this.argParser.getHostNameToInitializeAll();
        int port = this.argParser.getPortToInitializeAll();
        InitialContext ctx = null;
        while (ctx == null && !cancelled) {
            try {
                this.ci.setHeadingMessage(AdminToolMessages.INFO_REPLICATION_INITIALIZE_SOURCE_CONNECTION_PARAMETERS.get());
                this.ci.run();
                host = this.ci.getHostName();
                port = this.ci.getPortNumber();
                adminUid = this.ci.getAdministratorUID();
                adminPwd = this.ci.getBindPassword();
                ctx = this.createInitialLdapContextInteracting(this.ci);
                if (ctx != null) continue;
                cancelled = true;
            }
            catch (ClientException ce) {
                LOG.log(Level.WARNING, "Client exception " + ce);
                this.println();
                this.println(ce.getMessageObject());
                this.println();
                this.resetConnectionArguments();
            }
            catch (ArgumentException ae) {
                LOG.log(Level.WARNING, "Argument exception " + ae);
                this.println();
                this.println(ae.getMessageObject());
                this.println();
                cancelled = true;
            }
        }
        if (!cancelled) {
            uData.setHostName(host);
            uData.setPort(port);
            uData.setAdminUid(adminUid);
            uData.setAdminPwd(adminPwd);
        }
        if (!cancelled) {
            LinkedList<String> suffixes = this.argParser.getBaseDNs();
            this.checkSuffixesForInitializeReplication(suffixes, (InitialLdapContext)ctx, true);
            cancelled = suffixes.isEmpty();
            uData.setBaseDNs(suffixes);
        }
        if (!cancelled) {
            boolean initializeADS = false;
            for (String dn : uData.getBaseDNs()) {
                if (!Utils.areDnsEqual(ADSContext.getAdministrationSuffixDN(), dn)) continue;
                initializeADS = true;
            }
            String hostPortSource = ConnectionUtils.getHostPort((InitialLdapContext)ctx);
            if (initializeADS) {
                this.println();
                try {
                    cancelled = !this.askConfirmation(AdminToolMessages.INFO_REPLICATION_CONFIRM_INITIALIZE_ALL_ADS.get(ADSContext.getAdministrationSuffixDN(), hostPortSource), true, LOG);
                }
                catch (CLIException ce) {
                    this.println(ce.getMessageObject());
                    cancelled = true;
                }
                this.println();
            } else {
                this.println();
                try {
                    cancelled = !this.askConfirmation(AdminToolMessages.INFO_REPLICATION_CONFIRM_INITIALIZE_ALL_GENERIC.get(hostPortSource), true, LOG);
                }
                catch (CLIException ce) {
                    this.println(ce.getMessageObject());
                    cancelled = true;
                }
                this.println();
            }
        }
        if (ctx != null) {
            try {
                ctx.close();
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        return !cancelled;
    }

    private boolean promptIfRequired(PreExternalInitializationUserData uData) {
        boolean cancelled = false;
        String adminPwd = this.argParser.getBindPasswordAdmin();
        String adminUid = this.argParser.getAdministratorUID();
        String host = this.argParser.getHostNameToInitializeAll();
        int port = this.argParser.getPortToInitializeAll();
        InitialContext ctx = null;
        while (ctx == null && !cancelled) {
            try {
                this.ci.run();
                host = this.ci.getHostName();
                port = this.ci.getPortNumber();
                adminUid = this.ci.getAdministratorUID();
                adminPwd = this.ci.getBindPassword();
                ctx = this.createInitialLdapContextInteracting(this.ci);
                if (ctx != null) continue;
                cancelled = true;
            }
            catch (ClientException ce) {
                LOG.log(Level.WARNING, "Client exception " + ce);
                this.println();
                this.println(ce.getMessageObject());
                this.println();
                this.resetConnectionArguments();
            }
            catch (ArgumentException ae) {
                LOG.log(Level.WARNING, "Argument exception " + ae);
                this.println();
                this.println(ae.getMessageObject());
                this.println();
                cancelled = true;
            }
        }
        if (!cancelled) {
            boolean localOnly = false;
            if (!this.argParser.isExternalInitializationLocalOnly()) {
                this.println();
                try {
                    localOnly = this.askConfirmation(AdminToolMessages.INFO_REPLICATION_PRE_EXTERNAL_INITIALIZATION_LOCAL_PROMPT.get(ConnectionUtils.getHostPort((InitialLdapContext)ctx)), false, LOG);
                }
                catch (CLIException ce) {
                    this.println(ce.getMessageObject());
                    cancelled = true;
                }
            } else {
                localOnly = true;
            }
            uData.setLocalOnly(localOnly);
            uData.setHostName(host);
            uData.setPort(port);
            uData.setAdminUid(adminUid);
            uData.setAdminPwd(adminPwd);
        }
        if (!cancelled) {
            LinkedList<String> suffixes = this.argParser.getBaseDNs();
            this.checkSuffixesForInitializeReplication(suffixes, (InitialLdapContext)ctx, true);
            cancelled = suffixes.isEmpty();
            uData.setBaseDNs(suffixes);
        }
        if (ctx != null) {
            try {
                ctx.close();
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        return !cancelled;
    }

    private boolean promptIfRequired(PostExternalInitializationUserData uData) {
        boolean cancelled = false;
        String adminPwd = this.argParser.getBindPasswordAdmin();
        String adminUid = this.argParser.getAdministratorUID();
        String host = this.argParser.getHostNameToInitializeAll();
        int port = this.argParser.getPortToInitializeAll();
        InitialContext ctx = null;
        while (ctx == null && !cancelled) {
            try {
                this.ci.run();
                host = this.ci.getHostName();
                port = this.ci.getPortNumber();
                adminUid = this.ci.getAdministratorUID();
                adminPwd = this.ci.getBindPassword();
                ctx = this.createInitialLdapContextInteracting(this.ci);
                if (ctx != null) continue;
                cancelled = true;
            }
            catch (ClientException ce) {
                LOG.log(Level.WARNING, "Client exception " + ce);
                this.println();
                this.println(ce.getMessageObject());
                this.println();
                this.resetConnectionArguments();
            }
            catch (ArgumentException ae) {
                LOG.log(Level.WARNING, "Argument exception " + ae);
                this.println();
                this.println(ae.getMessageObject());
                this.println();
                cancelled = true;
            }
        }
        if (!cancelled) {
            uData.setHostName(host);
            uData.setPort(port);
            uData.setAdminUid(adminUid);
            uData.setAdminPwd(adminPwd);
        }
        if (!cancelled) {
            LinkedList<String> suffixes = this.argParser.getBaseDNs();
            this.checkSuffixesForInitializeReplication(suffixes, (InitialLdapContext)ctx, true);
            cancelled = suffixes.isEmpty();
            uData.setBaseDNs(suffixes);
        }
        if (ctx != null) {
            try {
                ctx.close();
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        return !cancelled;
    }

    private boolean promptIfRequired(StatusReplicationUserData uData) throws ReplicationCliException {
        boolean cancelled = false;
        String adminPwd = this.argParser.getBindPasswordAdmin();
        String adminUid = this.argParser.getAdministratorUID();
        String host = this.argParser.getHostNameToStatus();
        int port = this.argParser.getPortToStatus();
        InitialContext ctx = null;
        while (ctx == null && !cancelled) {
            try {
                this.ci.run();
                host = this.ci.getHostName();
                port = this.ci.getPortNumber();
                adminUid = this.ci.getAdministratorUID();
                adminPwd = this.ci.getBindPassword();
                ctx = this.createInitialLdapContextInteracting(this.ci);
                if (ctx != null) continue;
                cancelled = true;
            }
            catch (ClientException ce) {
                LOG.log(Level.WARNING, "Client exception " + ce);
                this.println();
                this.println(ce.getMessageObject());
                this.println();
                this.resetConnectionArguments();
            }
            catch (ArgumentException ae) {
                LOG.log(Level.WARNING, "Argument exception " + ae);
                this.println();
                this.println(ae.getMessageObject());
                this.println();
                cancelled = true;
            }
        }
        if (!cancelled) {
            uData.setHostName(host);
            uData.setPort(port);
            uData.setAdminUid(adminUid);
            uData.setAdminPwd(adminPwd);
            uData.setScriptFriendly(this.argParser.isScriptFriendly());
        }
        if (ctx != null) {
            InitialLdapContext[] aux = new InitialLdapContext[]{ctx};
            cancelled = !this.loadADSAndAcceptCertificates(aux, uData, false);
            ctx = aux[0];
        }
        if (!cancelled) {
            LinkedList<String> suffixes = this.argParser.getBaseDNs();
            uData.setBaseDNs(suffixes);
        }
        if (ctx != null) {
            try {
                ctx.close();
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        return !cancelled;
    }

    private boolean promptIfRequired(InitializeReplicationUserData uData) {
        boolean cancelled = false;
        String adminPwd = this.argParser.getBindPasswordAdmin();
        String adminUid = this.argParser.getAdministratorUID();
        String hostSource = this.argParser.getHostNameSource();
        int portSource = this.argParser.getPortSource();
        this.initializeGlobalArguments(hostSource, portSource, adminUid, null, adminPwd);
        InitialLdapContext ctxSource = null;
        while (ctxSource == null && !cancelled) {
            try {
                this.ci.setHeadingMessage(AdminToolMessages.INFO_REPLICATION_INITIALIZE_SOURCE_CONNECTION_PARAMETERS.get());
                this.ci.run();
                hostSource = this.ci.getHostName();
                portSource = this.ci.getPortNumber();
                adminUid = this.ci.getAdministratorUID();
                adminPwd = this.ci.getBindPassword();
                ctxSource = this.createInitialLdapContextInteracting(this.ci);
                if (ctxSource != null) continue;
                cancelled = true;
            }
            catch (ClientException ce) {
                LOG.log(Level.WARNING, "Client exception " + ce);
                this.println();
                this.println(ce.getMessageObject());
                this.println();
                this.resetConnectionArguments();
            }
            catch (ArgumentException ae) {
                LOG.log(Level.WARNING, "Argument exception " + ae);
                this.println();
                this.println(ae.getMessageObject());
                this.println();
                cancelled = true;
            }
        }
        if (!cancelled) {
            uData.setHostNameSource(hostSource);
            uData.setPortSource(portSource);
            uData.setAdminUid(adminUid);
            uData.setAdminPwd(adminPwd);
        }
        String hostDestination = this.argParser.getHostNameDestination();
        int portDestination = this.argParser.getPortDestination();
        this.initializeGlobalArguments(hostDestination, portDestination, adminUid, null, adminPwd);
        InitialContext ctxDestination = null;
        this.ci.resetHeadingDisplayed();
        while (ctxDestination == null && !cancelled) {
            try {
                this.ci.setHeadingMessage(AdminToolMessages.INFO_REPLICATION_INITIALIZE_DESTINATION_CONNECTION_PARAMETERS.get());
                this.ci.run();
                hostDestination = this.ci.getHostName();
                portDestination = this.ci.getPortNumber();
                ctxDestination = this.createInitialLdapContextInteracting(this.ci);
                if (ctxDestination != null) continue;
                cancelled = true;
            }
            catch (ClientException ce) {
                LOG.log(Level.WARNING, "Client exception " + ce);
                this.println();
                this.println(ce.getMessageObject());
                this.println();
                this.resetConnectionArguments();
            }
            catch (ArgumentException ae) {
                LOG.log(Level.WARNING, "Argument exception " + ae);
                this.println();
                this.println(ae.getMessageObject());
                this.println();
                cancelled = true;
            }
        }
        if (!cancelled) {
            uData.setHostNameDestination(hostDestination);
            uData.setPortDestination(portDestination);
        }
        if (!cancelled) {
            LinkedList<String> suffixes = this.argParser.getBaseDNs();
            this.checkSuffixesForInitializeReplication(suffixes, ctxSource, (InitialLdapContext)ctxDestination, true);
            cancelled = suffixes.isEmpty();
            uData.setBaseDNs(suffixes);
        }
        if (!cancelled) {
            boolean initializeADS = false;
            for (String dn : uData.getBaseDNs()) {
                if (!Utils.areDnsEqual(ADSContext.getAdministrationSuffixDN(), dn)) continue;
                initializeADS = true;
                break;
            }
            String hostPortSource = ConnectionUtils.getHostPort(ctxSource);
            String hostPortDestination = ConnectionUtils.getHostPort((InitialLdapContext)ctxDestination);
            if (initializeADS) {
                this.println();
                try {
                    cancelled = !this.askConfirmation(AdminToolMessages.INFO_REPLICATION_CONFIRM_INITIALIZE_ADS.get(ADSContext.getAdministrationSuffixDN(), hostPortDestination, hostPortSource), true, LOG);
                }
                catch (CLIException ce) {
                    this.println(ce.getMessageObject());
                    cancelled = true;
                }
                this.println();
            } else {
                this.println();
                try {
                    cancelled = !this.askConfirmation(AdminToolMessages.INFO_REPLICATION_CONFIRM_INITIALIZE_GENERIC.get(hostPortDestination, hostPortSource), true, LOG);
                }
                catch (CLIException ce) {
                    this.println(ce.getMessageObject());
                    cancelled = true;
                }
                this.println();
            }
        }
        if (ctxSource != null) {
            try {
                ctxSource.close();
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        if (ctxDestination != null) {
            try {
                ctxDestination.close();
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        return !cancelled;
    }

    private String getValue(String v, String defaultValue) {
        if (v != null) {
            return v;
        }
        return defaultValue;
    }

    private int getValue(int v, int defaultValue) {
        if (v != -1) {
            return v;
        }
        return defaultValue;
    }

    private ApplicationTrustManager getTrustManager() {
        ApplicationTrustManager t;
        Object trust = this.isInteractive() ? ((t = this.ci.getTrustManager()) == null ? null : (t instanceof ApplicationTrustManager ? t : new ApplicationTrustManager(this.ci.getKeyStore()))) : this.argParser.getTrustManager();
        return trust;
    }

    private void initializeWithArgParser(EnableReplicationUserData uData) {
        uData.setBaseDNs(new LinkedList<String>(this.argParser.getBaseDNs()));
        String adminUid = this.getValue(this.argParser.getAdministratorUID(), this.argParser.getDefaultAdministratorUID());
        uData.setAdminUid(adminUid);
        String adminPwd = this.argParser.getBindPasswordAdmin();
        uData.setAdminPwd(adminPwd);
        String host1Name = this.getValue(this.argParser.getHostName1(), this.argParser.getDefaultHostName1());
        uData.setHostName1(host1Name);
        int port1 = this.getValue(this.argParser.getPort1(), this.argParser.getDefaultPort1());
        uData.setPort1(port1);
        String pwd1 = this.argParser.getBindPassword1();
        if (pwd1 == null) {
            uData.setBindDn1(ADSContext.getAdministratorDN(adminUid));
            uData.setPwd1(adminPwd);
        } else {
            try {
                InitialLdapContext ctx = this.createAdministrativeContext(uData.getHostName1(), uData.getPort1(), this.useSSL, this.useStartTLS, ADSContext.getAdministratorDN(adminUid), adminPwd, this.getTrustManager());
                uData.setBindDn1(ADSContext.getAdministratorDN(adminUid));
                uData.setPwd1(adminPwd);
                ctx.close();
            }
            catch (Throwable t) {
                String bindDn = this.getValue(this.argParser.getBindDn1(), this.argParser.getDefaultBindDn1());
                uData.setBindDn1(bindDn);
                uData.setPwd1(pwd1);
            }
        }
        int replicationPort1 = this.getValue(this.argParser.getReplicationPort1(), this.argParser.getDefaultReplicationPort1());
        uData.setReplicationPort1(replicationPort1);
        uData.setSecureReplication1(this.argParser.isSecureReplication1());
        String host2Name = this.getValue(this.argParser.getHostName2(), this.argParser.getDefaultHostName2());
        uData.setHostName2(host2Name);
        int port2 = this.getValue(this.argParser.getPort2(), this.argParser.getDefaultPort2());
        uData.setPort2(port2);
        String pwd2 = this.argParser.getBindPassword2();
        if (pwd2 == null) {
            uData.setBindDn2(ADSContext.getAdministratorDN(adminUid));
            uData.setPwd2(adminPwd);
        } else {
            try {
                InitialLdapContext ctx = this.createAdministrativeContext(uData.getHostName2(), uData.getPort2(), this.useSSL, this.useStartTLS, ADSContext.getAdministratorDN(adminUid), adminPwd, this.getTrustManager());
                uData.setBindDn2(ADSContext.getAdministratorDN(adminUid));
                uData.setPwd2(adminPwd);
                ctx.close();
            }
            catch (Throwable t) {
                String bindDn = this.getValue(this.argParser.getBindDn2(), this.argParser.getDefaultBindDn2());
                uData.setBindDn2(bindDn);
                uData.setPwd2(pwd2);
            }
        }
        int replicationPort2 = this.getValue(this.argParser.getReplicationPort2(), this.argParser.getDefaultReplicationPort2());
        uData.setReplicationPort2(replicationPort2);
        uData.setSecureReplication2(this.argParser.isSecureReplication2());
        uData.setReplicateSchema(!this.argParser.noSchemaReplication());
    }

    private void initializeWithArgParser(InitializeReplicationUserData uData) {
        uData.setBaseDNs(new LinkedList<String>(this.argParser.getBaseDNs()));
        String adminUid = this.getValue(this.argParser.getAdministratorUID(), this.argParser.getDefaultAdministratorUID());
        uData.setAdminUid(adminUid);
        String adminPwd = this.argParser.getBindPasswordAdmin();
        uData.setAdminPwd(adminPwd);
        String hostNameSource = this.getValue(this.argParser.getHostNameSource(), this.argParser.getDefaultHostNameSource());
        uData.setHostNameSource(hostNameSource);
        int portSource = this.getValue(this.argParser.getPortSource(), this.argParser.getDefaultPortSource());
        uData.setPortSource(portSource);
        String hostNameDestination = this.getValue(this.argParser.getHostNameDestination(), this.argParser.getDefaultHostNameDestination());
        uData.setHostNameDestination(hostNameDestination);
        int portDestination = this.getValue(this.argParser.getPortDestination(), this.argParser.getDefaultPortDestination());
        uData.setPortDestination(portDestination);
    }

    private void initializeWithArgParser(DisableReplicationUserData uData) {
        uData.setBaseDNs(new LinkedList<String>(this.argParser.getBaseDNs()));
        String adminUid = this.argParser.getAdministratorUID();
        String bindDn = this.argParser.getBindDN();
        if (bindDn == null && adminUid == null) {
            adminUid = this.argParser.getDefaultAdministratorUID();
        }
        uData.setAdminUid(adminUid);
        uData.setBindDn(bindDn);
        String adminPwd = this.argParser.getBindPasswordAdmin();
        uData.setAdminPwd(adminPwd);
        String hostName = this.getValue(this.argParser.getHostNameToDisable(), this.argParser.getDefaultHostNameToDisable());
        uData.setHostName(hostName);
        int port = this.getValue(this.argParser.getPortToDisable(), this.argParser.getDefaultPortToDisable());
        uData.setPort(port);
    }

    private void initializeWithArgParser(InitializeAllReplicationUserData uData) {
        uData.setBaseDNs(new LinkedList<String>(this.argParser.getBaseDNs()));
        String adminUid = this.getValue(this.argParser.getAdministratorUID(), this.argParser.getDefaultAdministratorUID());
        uData.setAdminUid(adminUid);
        String adminPwd = this.argParser.getBindPasswordAdmin();
        uData.setAdminPwd(adminPwd);
        String hostName = this.getValue(this.argParser.getHostNameToInitializeAll(), this.argParser.getDefaultHostNameToInitializeAll());
        uData.setHostName(hostName);
        int port = this.getValue(this.argParser.getPortToInitializeAll(), this.argParser.getDefaultPortToInitializeAll());
        uData.setPort(port);
    }

    private void initializeWithArgParser(PreExternalInitializationUserData uData) {
        uData.setBaseDNs(new LinkedList<String>(this.argParser.getBaseDNs()));
        String adminUid = this.getValue(this.argParser.getAdministratorUID(), this.argParser.getDefaultAdministratorUID());
        uData.setAdminUid(adminUid);
        String adminPwd = this.argParser.getBindPasswordAdmin();
        uData.setAdminPwd(adminPwd);
        String hostName = this.getValue(this.argParser.getHostNameToInitializeAll(), this.argParser.getDefaultHostNameToInitializeAll());
        uData.setHostName(hostName);
        int port = this.getValue(this.argParser.getPortToInitializeAll(), this.argParser.getDefaultPortToInitializeAll());
        uData.setPort(port);
        uData.setLocalOnly(this.argParser.isExternalInitializationLocalOnly());
    }

    private void initializeWithArgParser(PostExternalInitializationUserData uData) {
        uData.setBaseDNs(new LinkedList<String>(this.argParser.getBaseDNs()));
        String adminUid = this.getValue(this.argParser.getAdministratorUID(), this.argParser.getDefaultAdministratorUID());
        uData.setAdminUid(adminUid);
        String adminPwd = this.argParser.getBindPasswordAdmin();
        uData.setAdminPwd(adminPwd);
        String hostName = this.getValue(this.argParser.getHostNameToInitializeAll(), this.argParser.getDefaultHostNameToInitializeAll());
        uData.setHostName(hostName);
        int port = this.getValue(this.argParser.getPortToInitializeAll(), this.argParser.getDefaultPortToInitializeAll());
        uData.setPort(port);
    }

    private void initializeWithArgParser(StatusReplicationUserData uData) {
        uData.setBaseDNs(new LinkedList<String>(this.argParser.getBaseDNs()));
        String adminUid = this.getValue(this.argParser.getAdministratorUID(), this.argParser.getDefaultAdministratorUID());
        uData.setAdminUid(adminUid);
        String adminPwd = this.argParser.getBindPasswordAdmin();
        uData.setAdminPwd(adminPwd);
        String hostName = this.getValue(this.argParser.getHostNameToStatus(), this.argParser.getDefaultHostNameToStatus());
        uData.setHostName(hostName);
        int port = this.getValue(this.argParser.getPortToStatus(), this.argParser.getDefaultPortToStatus());
        uData.setPort(port);
        uData.setScriptFriendly(this.argParser.isScriptFriendly());
    }

    private boolean hasReplicationPort(InitialLdapContext ctx) {
        return this.getReplicationPort(ctx) != -1;
    }

    private int getReplicationPort(InitialLdapContext ctx) {
        int replicationPort = -1;
        try {
            ManagementContext mCtx = LDAPManagementContext.createFromContext(JNDIDirContextAdaptor.adapt(ctx));
            RootCfgClient root = mCtx.getRootConfiguration();
            ReplicationSynchronizationProviderCfgClient sync = null;
            sync = (ReplicationSynchronizationProviderCfgClient)root.getSynchronizationProvider("Multimaster Synchronization");
            if (sync.hasReplicationServer()) {
                ReplicationServerCfgClient replicationServer = sync.getReplicationServer();
                replicationPort = replicationServer.getReplicationPort();
            }
        }
        catch (Throwable t) {
            LOG.log(Level.WARNING, "Unexpected error retrieving the replication port: " + t, t);
        }
        return replicationPort;
    }

    private boolean loadADSAndAcceptCertificates(InitialLdapContext[] ctx, ReplicationUserData uData, boolean isFirstOrSourceServer) throws ReplicationCliException {
        boolean cancelled;
        block28: {
            cancelled = false;
            boolean triedWithUserProvidedAdmin = false;
            String host = ConnectionUtils.getHostName(ctx[0]);
            int port = ConnectionUtils.getPort(ctx[0]);
            boolean isSSL = ConnectionUtils.isSSL(ctx[0]);
            boolean isStartTLS = ConnectionUtils.isStartTLS(ctx[0]);
            if (this.getTrustManager() == null) {
                this.forceTrustManagerInitialization();
            }
            try {
                ADSContext adsContext = new ADSContext(ctx[0]);
                if (!adsContext.hasAdminData()) break block28;
                boolean reloadTopology = true;
                LinkedList<Message> exceptionMsgs = new LinkedList<Message>();
                block13: while (reloadTopology && !cancelled) {
                    TopologyCache cache = new TopologyCache(adsContext, this.getTrustManager());
                    cache.getFilter().setSearchMonitoringInformation(false);
                    cache.getFilter().setSearchBaseDNInformation(false);
                    cache.setPreferredConnections(this.getPreferredConnections(ctx[0]));
                    cache.reloadTopology();
                    reloadTopology = false;
                    exceptionMsgs.clear();
                    HashSet<TopologyCacheException> exceptions = new HashSet<TopologyCacheException>();
                    Set<ServerDescriptor> servers = cache.getServers();
                    for (ServerDescriptor server : servers) {
                        TopologyCacheException e = server.getLastException();
                        if (e == null) continue;
                        exceptions.add(e);
                    }
                    boolean notGlobalAdministratorError = false;
                    block15: for (TopologyCacheException e : exceptions) {
                        if (notGlobalAdministratorError) continue block13;
                        switch (e.getType()) {
                            case NOT_GLOBAL_ADMINISTRATOR: {
                                notGlobalAdministratorError = true;
                                boolean connected = false;
                                String adminUid = uData.getAdminUid();
                                String adminPwd = uData.getAdminPwd();
                                boolean errorDisplayed = false;
                                while (!connected) {
                                    if (!triedWithUserProvidedAdmin && adminPwd == null) {
                                        adminUid = this.getValue(this.argParser.getAdministratorUID(), this.argParser.getDefaultAdministratorUID());
                                        adminPwd = this.argParser.getBindPasswordAdmin();
                                        triedWithUserProvidedAdmin = true;
                                    }
                                    if (adminPwd == null) {
                                        if (!errorDisplayed) {
                                            this.println();
                                            this.println(QuickSetupMessages.INFO_NOT_GLOBAL_ADMINISTRATOR_PROVIDED.get());
                                            errorDisplayed = true;
                                        }
                                        adminUid = this.askForAdministratorUID(this.argParser.getDefaultAdministratorUID());
                                        this.println();
                                        adminPwd = this.askForAdministratorPwd();
                                        this.println();
                                    }
                                    try {
                                        ctx[0].close();
                                    }
                                    catch (Throwable t) {
                                        // empty catch block
                                    }
                                    try {
                                        ctx[0] = this.createAdministrativeContext(host, port, isSSL, isStartTLS, ADSContext.getAdministratorDN(adminUid), adminPwd, this.getTrustManager());
                                        adsContext = new ADSContext(ctx[0]);
                                        cache = new TopologyCache(adsContext, this.getTrustManager());
                                        cache.getFilter().setSearchMonitoringInformation(false);
                                        cache.getFilter().setSearchBaseDNInformation(false);
                                        cache.setPreferredConnections(this.getPreferredConnections(ctx[0]));
                                        connected = true;
                                    }
                                    catch (Throwable t) {
                                        this.println();
                                        this.println(AdminToolMessages.ERR_ERROR_CONNECTING_TO_SERVER_PROMPT_AGAIN.get(host + ":" + port, t.getMessage()));
                                        LOG.log(Level.WARNING, "Complete error stack:", t);
                                        this.println();
                                    }
                                }
                                uData.setAdminUid(adminUid);
                                uData.setAdminPwd(adminPwd);
                                if (uData instanceof EnableReplicationUserData) {
                                    EnableReplicationUserData enableData = (EnableReplicationUserData)uData;
                                    if (isFirstOrSourceServer) {
                                        enableData.setBindDn1(ADSContext.getAdministratorDN(adminUid));
                                        enableData.setPwd1(adminPwd);
                                    } else {
                                        enableData.setBindDn2(ADSContext.getAdministratorDN(adminUid));
                                        enableData.setPwd2(adminPwd);
                                    }
                                }
                                reloadTopology = true;
                                continue block15;
                            }
                            case GENERIC_CREATING_CONNECTION: {
                                if (e.getCause() != null && Utils.isCertificateException(e.getCause())) {
                                    reloadTopology = true;
                                    cancelled = !this.ci.promptForCertificateConfirmation(e.getCause(), e.getTrustManager(), e.getLdapUrl(), true, LOG);
                                    continue block15;
                                }
                                exceptionMsgs.add(Utils.getMessage(e));
                                continue block15;
                            }
                        }
                        exceptionMsgs.add(Utils.getMessage(e));
                    }
                }
                if (exceptionMsgs.size() > 0 && !cancelled) {
                    if (uData instanceof StatusReplicationUserData) {
                        this.println(AdminToolMessages.ERR_REPLICATION_STATUS_READING_REGISTERED_SERVERS.get(Utils.getMessageFromCollection(exceptionMsgs, Constants.LINE_SEPARATOR).toString()));
                        this.println();
                    } else {
                        try {
                            cancelled = !this.askConfirmation(AdminToolMessages.ERR_REPLICATION_READING_REGISTERED_SERVERS_CONFIRM_UPDATE_REMOTE.get(Utils.getMessageFromCollection(exceptionMsgs, Constants.LINE_SEPARATOR).toString()), true, LOG);
                        }
                        catch (CLIException ce) {
                            this.println(ce.getMessageObject());
                            cancelled = true;
                        }
                    }
                }
            }
            catch (ADSContextException ace) {
                LOG.log(Level.SEVERE, "Complete error stack:", ace);
                throw new ReplicationCliException(AdminToolMessages.ERR_REPLICATION_READING_ADS.get(ace.getMessage()), ReplicationCliReturnCode.ERROR_READING_ADS, ace);
            }
            catch (TopologyCacheException tce) {
                LOG.log(Level.SEVERE, "Complete error stack:", tce);
                throw new ReplicationCliException(AdminToolMessages.ERR_REPLICATION_READING_ADS.get(tce.getMessage()), ReplicationCliReturnCode.ERROR_READING_TOPOLOGY_CACHE, tce);
            }
        }
        return !cancelled;
    }

    private boolean hasAdministrator(InitialLdapContext ctx) {
        boolean isAdminDefined = false;
        try {
            ADSContext adsContext = new ADSContext(ctx);
            if (adsContext.hasAdminData()) {
                Set<Map<ADSContext.AdministratorProperty, Object>> administrators = adsContext.readAdministratorRegistry();
                isAdminDefined = administrators.size() > 0;
            }
        }
        catch (Throwable t) {
            LOG.log(Level.WARNING, "Unexpected error retrieving the ADS data: " + t, t);
        }
        return isAdminDefined;
    }

    private boolean hasAdministrator(InitialLdapContext ctx, ReplicationUserData uData) {
        boolean isAdminDefined = false;
        String adminUid = uData.getAdminUid();
        try {
            Map<ADSContext.AdministratorProperty, Object> admin;
            String uid;
            ADSContext adsContext = new ADSContext(ctx);
            Set<Map<ADSContext.AdministratorProperty, Object>> administrators = adsContext.readAdministratorRegistry();
            Iterator<Map<ADSContext.AdministratorProperty, Object>> i$ = administrators.iterator();
            while (i$.hasNext() && ((uid = (String)(admin = i$.next()).get((Object)ADSContext.AdministratorProperty.UID)) == null || !(isAdminDefined = uid.equalsIgnoreCase(adminUid) || adminUid == null))) {
            }
        }
        catch (Throwable t) {
            LOG.log(Level.WARNING, "Unexpected error retrieving the ADS data: " + t, t);
        }
        return isAdminDefined;
    }

    private Collection<String> getCommonSuffixes(InitialLdapContext ctx1, InitialLdapContext ctx2, SuffixRelationType type) {
        LinkedList<String> suffixes = new LinkedList<String>();
        try {
            TopologyCacheFilter filter = new TopologyCacheFilter();
            filter.setSearchMonitoringInformation(false);
            ServerDescriptor server1 = ServerDescriptor.createStandalone(ctx1, filter);
            ServerDescriptor server2 = ServerDescriptor.createStandalone(ctx2, filter);
            Set<ReplicaDescriptor> replicas1 = server1.getReplicas();
            Set<ReplicaDescriptor> replicas2 = server2.getReplicas();
            for (ReplicaDescriptor rep1 : replicas1) {
                block10: for (ReplicaDescriptor rep2 : replicas2) {
                    switch (type) {
                        case NOT_REPLICATED: {
                            if (this.areReplicated(rep1, rep2) || !Utils.areDnsEqual(rep1.getSuffix().getDN(), rep2.getSuffix().getDN())) continue block10;
                            suffixes.add(rep1.getSuffix().getDN());
                            continue block10;
                        }
                        case FULLY_REPLICATED: {
                            if (!this.areFullyReplicated(rep1, rep2)) continue block10;
                            suffixes.add(rep1.getSuffix().getDN());
                            continue block10;
                        }
                        case REPLICATED: {
                            if (!this.areReplicated(rep1, rep2)) continue block10;
                            suffixes.add(rep1.getSuffix().getDN());
                            continue block10;
                        }
                        case NOT_FULLY_REPLICATED: {
                            if (this.areFullyReplicated(rep1, rep2) || !Utils.areDnsEqual(rep1.getSuffix().getDN(), rep2.getSuffix().getDN())) continue block10;
                            suffixes.add(rep1.getSuffix().getDN());
                            continue block10;
                        }
                        case ALL: {
                            if (!Utils.areDnsEqual(rep1.getSuffix().getDN(), rep2.getSuffix().getDN())) continue block10;
                            suffixes.add(rep1.getSuffix().getDN());
                            continue block10;
                        }
                    }
                    throw new IllegalStateException("Unknown type: " + (Object)((Object)type));
                }
            }
        }
        catch (Throwable t) {
            LOG.log(Level.WARNING, "Unexpected error retrieving the server configuration: " + t, t);
        }
        return suffixes;
    }

    private boolean areFullyReplicated(ReplicaDescriptor rep1, ReplicaDescriptor rep2) {
        boolean areFullyReplicated = false;
        if (Utils.areDnsEqual(rep1.getSuffix().getDN(), rep2.getSuffix().getDN()) && rep1.isReplicated() && rep2.isReplicated() && rep1.getServer().isReplicationServer() && rep2.getServer().isReplicationServer()) {
            Set<String> servers1 = rep1.getReplicationServers();
            Set<String> servers2 = rep2.getReplicationServers();
            String server1 = rep1.getServer().getReplicationServerHostPort();
            String server2 = rep2.getServer().getReplicationServerHostPort();
            areFullyReplicated = servers1.contains(server2) && servers2.contains(server1);
        }
        return areFullyReplicated;
    }

    private boolean areReplicated(ReplicaDescriptor rep1, ReplicaDescriptor rep2) {
        boolean areReplicated = false;
        if (Utils.areDnsEqual(rep1.getSuffix().getDN(), rep2.getSuffix().getDN()) && rep1.isReplicated() && rep2.isReplicated()) {
            Set<String> servers1 = rep1.getReplicationServers();
            Set<String> servers2 = rep2.getReplicationServers();
            servers1.retainAll(servers2);
            areReplicated = !servers1.isEmpty();
        }
        return areReplicated;
    }

    private Collection<ReplicaDescriptor> getReplicas(InitialLdapContext ctx) {
        LinkedList<ReplicaDescriptor> suffixes = new LinkedList<ReplicaDescriptor>();
        TopologyCacheFilter filter = new TopologyCacheFilter();
        filter.setSearchMonitoringInformation(false);
        try {
            ServerDescriptor server = ServerDescriptor.createStandalone(ctx, filter);
            suffixes.addAll(server.getReplicas());
        }
        catch (Throwable t) {
            LOG.log(Level.WARNING, "Unexpected error retrieving the server configuration: " + t, t);
        }
        return suffixes;
    }

    private ReplicationCliReturnCode enableReplication(EnableReplicationUserData uData) {
        String hostPort;
        ReplicationCliReturnCode returnValue = ReplicationCliReturnCode.SUCCESSFUL_NOP;
        InitialLdapContext ctx1 = null;
        InitialLdapContext ctx2 = null;
        String host1 = uData.getHostName1();
        String host2 = uData.getHostName2();
        int port1 = uData.getPort1();
        int port2 = uData.getPort2();
        LinkedList<Message> errorMessages = new LinkedList<Message>();
        this.printlnProgress();
        this.printProgress(this.formatter.getFormattedWithPoints(AdminToolMessages.INFO_REPLICATION_CONNECTING.get()));
        try {
            ctx1 = this.createAdministrativeContext(host1, port1, this.useSSL, this.useStartTLS, uData.getBindDn1(), uData.getPwd1(), this.getTrustManager());
        }
        catch (NamingException ne) {
            hostPort = host1 + ":" + port1;
            errorMessages.add(this.getMessageForException(ne, hostPort));
            LOG.log(Level.SEVERE, "Complete error stack:", ne);
        }
        try {
            ctx2 = this.createAdministrativeContext(host2, port2, this.useSSL, this.useStartTLS, uData.getBindDn2(), uData.getPwd2(), this.getTrustManager());
        }
        catch (NamingException ne) {
            hostPort = host2 + ":" + port2;
            errorMessages.add(this.getMessageForException(ne, hostPort));
            LOG.log(Level.SEVERE, "Complete error stack:", ne);
        }
        if (errorMessages.size() > 0) {
            returnValue = ReplicationCliReturnCode.ERROR_CONNECTING;
        }
        if (errorMessages.isEmpty()) {
            this.printProgress(this.formatter.getFormattedDone());
            this.printlnProgress();
            if (!this.argParser.isInteractive()) {
                boolean hasReplicationPort1 = this.hasReplicationPort(ctx1);
                boolean hasReplicationPort2 = this.hasReplicationPort(ctx2);
                int replPort1 = uData.getReplicationPort1();
                int replPort2 = uData.getReplicationPort2();
                if (!hasReplicationPort1 && !this.argParser.skipReplicationPortCheck() && this.isLocalHost(host1) && !SetupUtils.canUseAsPort(replPort1)) {
                    errorMessages.add(this.getCannotBindToPortError(replPort1));
                }
                if (!hasReplicationPort2 && !this.argParser.skipReplicationPortCheck() && this.isLocalHost(host2) && !SetupUtils.canUseAsPort(replPort2)) {
                    errorMessages.add(this.getCannotBindToPortError(replPort2));
                }
                if (!hasReplicationPort1 && !hasReplicationPort2 && replPort1 == replPort2 && host1.equalsIgnoreCase(host2)) {
                    errorMessages.add(AdminToolMessages.ERR_REPLICATION_SAME_REPLICATION_PORT.get(String.valueOf(replPort1), host1));
                }
                if (this.argParser.skipReplicationPortCheck()) {
                    if (replPort1 == port1) {
                        errorMessages.add(AdminToolMessages.ERR_REPLICATION_PORT_AND_REPLICATION_PORT_EQUAL.get(host1, String.valueOf(replPort1)));
                    }
                    if (replPort2 == port2) {
                        errorMessages.add(AdminToolMessages.ERR_REPLICATION_PORT_AND_REPLICATION_PORT_EQUAL.get(host2, String.valueOf(replPort2)));
                    }
                }
            }
            if (errorMessages.size() > 0) {
                returnValue = ReplicationCliReturnCode.ERROR_USER_DATA;
            }
        }
        if (errorMessages.isEmpty()) {
            LinkedList<String> suffixes = uData.getBaseDNs();
            this.checkSuffixesForEnableReplication(suffixes, ctx1, ctx2, false);
            if (!suffixes.isEmpty()) {
                uData.setBaseDNs(suffixes);
                try {
                    this.updateConfiguration(ctx1, ctx2, uData);
                    returnValue = ReplicationCliReturnCode.SUCCESSFUL;
                }
                catch (ReplicationCliException rce) {
                    returnValue = rce.getErrorCode();
                    this.println();
                    this.println(this.getCriticalExceptionMessage(rce));
                    LOG.log(Level.SEVERE, "Complete error stack:", rce);
                }
            } else {
                returnValue = ReplicationCliReturnCode.REPLICATION_CANNOT_BE_ENABLED_ON_BASEDN;
            }
        }
        for (Message msg : errorMessages) {
            this.println();
            this.println(msg);
        }
        if (returnValue == ReplicationCliReturnCode.SUCCESSFUL) {
            long time1 = Utils.getServerClock(ctx1);
            long time2 = Utils.getServerClock(ctx2);
            if (time1 != -1L && time2 != -1L && Math.abs(time1 - time2) > 300000L) {
                this.println(QuickSetupMessages.INFO_WARNING_SERVERS_CLOCK_DIFFERENCE.get(ConnectionUtils.getHostPort(ctx1), ConnectionUtils.getHostPort(ctx2), String.valueOf(5)));
            }
            this.printlnProgress();
            this.printProgress(AdminToolMessages.INFO_REPLICATION_POST_ENABLE_INFO.get("dsreplication", "initialize"));
            this.printlnProgress();
        }
        if (ctx1 != null) {
            try {
                ctx1.close();
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        if (ctx2 != null) {
            try {
                ctx2.close();
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        return returnValue;
    }

    private ReplicationCliReturnCode disableReplication(DisableReplicationUserData uData) {
        ReplicationCliReturnCode returnValue = ReplicationCliReturnCode.SUCCESSFUL_NOP;
        InitialLdapContext ctx = null;
        this.printProgress(this.formatter.getFormattedWithPoints(AdminToolMessages.INFO_REPLICATION_CONNECTING.get()));
        String bindDn = uData.getAdminUid() == null ? uData.getBindDn() : ADSContext.getAdministratorDN(uData.getAdminUid());
        try {
            ctx = this.createAdministrativeContext(uData.getHostName(), uData.getPort(), this.useSSL, this.useStartTLS, bindDn, uData.getAdminPwd(), this.getTrustManager());
        }
        catch (NamingException ne) {
            String hostPort = uData.getHostName() + ":" + uData.getPort();
            this.println();
            this.println(this.getMessageForException(ne, hostPort));
            LOG.log(Level.SEVERE, "Complete error stack:", ne);
        }
        if (ctx != null) {
            this.printProgress(this.formatter.getFormattedDone());
            this.printlnProgress();
            LinkedList<String> suffixes = uData.getBaseDNs();
            this.checkSuffixesForDisableReplication(suffixes, ctx, false);
            if (!suffixes.isEmpty()) {
                uData.setBaseDNs(suffixes);
                try {
                    this.updateConfiguration(ctx, uData);
                    returnValue = ReplicationCliReturnCode.SUCCESSFUL;
                }
                catch (ReplicationCliException rce) {
                    returnValue = rce.getErrorCode();
                    this.println();
                    this.println(this.getCriticalExceptionMessage(rce));
                    LOG.log(Level.SEVERE, "Complete error stack:", rce);
                }
            } else {
                returnValue = ReplicationCliReturnCode.REPLICATION_CANNOT_BE_DISABLED_ON_BASEDN;
            }
        } else {
            returnValue = ReplicationCliReturnCode.ERROR_CONNECTING;
        }
        if (ctx != null) {
            try {
                ctx.close();
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        return returnValue;
    }

    private ReplicationCliReturnCode statusReplication(StatusReplicationUserData uData) {
        ReplicationCliReturnCode returnValue = ReplicationCliReturnCode.SUCCESSFUL_NOP;
        InitialLdapContext ctx = null;
        try {
            ctx = this.createAdministrativeContext(uData.getHostName(), uData.getPort(), this.useSSL, this.useStartTLS, ADSContext.getAdministratorDN(uData.getAdminUid()), uData.getAdminPwd(), this.getTrustManager());
        }
        catch (NamingException ne) {
            String hostPort = uData.getHostName() + ":" + uData.getPort();
            this.println();
            this.println(this.getMessageForException(ne, hostPort));
            LOG.log(Level.SEVERE, "Complete error stack:", ne);
        }
        if (ctx != null) {
            uData.setBaseDNs(uData.getBaseDNs());
            try {
                this.displayStatus(ctx, uData);
                returnValue = ReplicationCliReturnCode.SUCCESSFUL;
            }
            catch (ReplicationCliException rce) {
                returnValue = rce.getErrorCode();
                this.println();
                this.println(this.getCriticalExceptionMessage(rce));
                LOG.log(Level.SEVERE, "Complete error stack:", rce);
            }
        } else {
            returnValue = ReplicationCliReturnCode.ERROR_CONNECTING;
        }
        if (ctx != null) {
            try {
                ctx.close();
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        return returnValue;
    }

    private ReplicationCliReturnCode initializeReplication(InitializeReplicationUserData uData) {
        String hostPort;
        ReplicationCliReturnCode returnValue = ReplicationCliReturnCode.SUCCESSFUL_NOP;
        InitialLdapContext ctxSource = null;
        InitialLdapContext ctxDestination = null;
        try {
            ctxSource = this.createAdministrativeContext(uData.getHostNameSource(), uData.getPortSource(), this.useSSL, this.useStartTLS, ADSContext.getAdministratorDN(uData.getAdminUid()), uData.getAdminPwd(), this.getTrustManager());
        }
        catch (NamingException ne) {
            hostPort = uData.getHostNameSource() + ":" + uData.getPortSource();
            this.println();
            this.println(this.getMessageForException(ne, hostPort));
            LOG.log(Level.SEVERE, "Complete error stack:", ne);
        }
        try {
            ctxDestination = this.createAdministrativeContext(uData.getHostNameDestination(), uData.getPortDestination(), this.useSSL, this.useStartTLS, ADSContext.getAdministratorDN(uData.getAdminUid()), uData.getAdminPwd(), this.getTrustManager());
        }
        catch (NamingException ne) {
            hostPort = uData.getHostNameDestination() + ":" + uData.getPortDestination();
            this.println();
            this.println(this.getMessageForException(ne, hostPort));
            LOG.log(Level.SEVERE, "Complete error stack:", ne);
        }
        if (ctxSource != null && ctxDestination != null) {
            LinkedList<String> baseDNs = uData.getBaseDNs();
            this.checkSuffixesForInitializeReplication(baseDNs, ctxSource, ctxDestination, false);
            if (!baseDNs.isEmpty()) {
                for (String baseDN : baseDNs) {
                    try {
                        this.printlnProgress();
                        Message msg = this.formatter.getFormattedProgress(QuickSetupMessages.INFO_PROGRESS_INITIALIZING_SUFFIX.get(baseDN, ConnectionUtils.getHostPort(ctxSource)));
                        this.printProgress(msg);
                        this.printlnProgress();
                        this.initializeSuffix(baseDN, ctxSource, ctxDestination, true);
                    }
                    catch (ReplicationCliException rce) {
                        this.println();
                        this.println(this.getCriticalExceptionMessage(rce));
                        returnValue = rce.getErrorCode();
                        LOG.log(Level.SEVERE, "Complete error stack:", rce);
                    }
                }
            } else {
                returnValue = ReplicationCliReturnCode.REPLICATION_CANNOT_BE_INITIALIZED_ON_BASEDN;
            }
        } else {
            returnValue = ReplicationCliReturnCode.ERROR_CONNECTING;
        }
        if (ctxSource != null) {
            try {
                ctxSource.close();
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        if (ctxDestination != null) {
            try {
                ctxDestination.close();
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        return returnValue;
    }

    private ReplicationCliReturnCode initializeAllReplication(InitializeAllReplicationUserData uData) {
        ReplicationCliReturnCode returnValue = ReplicationCliReturnCode.SUCCESSFUL_NOP;
        InitialLdapContext ctx = null;
        try {
            ctx = this.createAdministrativeContext(uData.getHostName(), uData.getPort(), this.useSSL, this.useStartTLS, ADSContext.getAdministratorDN(uData.getAdminUid()), uData.getAdminPwd(), this.getTrustManager());
        }
        catch (NamingException ne) {
            String hostPort = uData.getHostName() + ":" + uData.getPort();
            this.println();
            this.println(this.getMessageForException(ne, hostPort));
            LOG.log(Level.SEVERE, "Complete error stack:", ne);
        }
        if (ctx != null) {
            LinkedList<String> baseDNs = uData.getBaseDNs();
            this.checkSuffixesForInitializeReplication(baseDNs, ctx, false);
            if (!baseDNs.isEmpty()) {
                for (String baseDN : baseDNs) {
                    try {
                        this.printlnProgress();
                        Message msg = this.formatter.getFormattedProgress(QuickSetupMessages.INFO_PROGRESS_INITIALIZING_SUFFIX.get(baseDN, ConnectionUtils.getHostPort(ctx)));
                        this.printProgress(msg);
                        this.println();
                        this.initializeAllSuffix(baseDN, ctx, true);
                    }
                    catch (ReplicationCliException rce) {
                        this.println();
                        this.println(this.getCriticalExceptionMessage(rce));
                        returnValue = rce.getErrorCode();
                        LOG.log(Level.SEVERE, "Complete error stack:", rce);
                    }
                }
            } else {
                returnValue = ReplicationCliReturnCode.REPLICATION_CANNOT_BE_INITIALIZED_ON_BASEDN;
            }
        } else {
            returnValue = ReplicationCliReturnCode.ERROR_CONNECTING;
        }
        if (ctx != null) {
            try {
                ctx.close();
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        return returnValue;
    }

    private ReplicationCliReturnCode preExternalInitialization(PreExternalInitializationUserData uData) {
        ReplicationCliReturnCode returnValue = ReplicationCliReturnCode.SUCCESSFUL_NOP;
        InitialLdapContext ctx = null;
        try {
            ctx = this.createAdministrativeContext(uData.getHostName(), uData.getPort(), this.useSSL, this.useStartTLS, ADSContext.getAdministratorDN(uData.getAdminUid()), uData.getAdminPwd(), this.getTrustManager());
        }
        catch (NamingException ne) {
            String hostPort = uData.getHostName() + ":" + uData.getPort();
            this.println();
            this.println(this.getMessageForException(ne, hostPort));
            LOG.log(Level.SEVERE, "Complete error stack:", ne);
        }
        if (ctx != null) {
            LinkedList<String> baseDNs = uData.getBaseDNs();
            this.checkSuffixesForInitializeReplication(baseDNs, ctx, false);
            if (!baseDNs.isEmpty()) {
                for (String baseDN : baseDNs) {
                    try {
                        this.printlnProgress();
                        Message msg = this.formatter.getFormattedWithPoints(AdminToolMessages.INFO_PROGRESS_PRE_EXTERNAL_INITIALIZATION.get(baseDN));
                        this.printProgress(msg);
                        this.preExternalInitialization(baseDN, ctx, uData.isLocalOnly(), false);
                        this.printProgress(this.formatter.getFormattedDone());
                        this.printlnProgress();
                    }
                    catch (ReplicationCliException rce) {
                        this.println();
                        this.println(this.getCriticalExceptionMessage(rce));
                        returnValue = rce.getErrorCode();
                        LOG.log(Level.SEVERE, "Complete error stack:", rce);
                    }
                }
                if (uData.isLocalOnly()) {
                    this.printlnProgress();
                    this.printProgress(AdminToolMessages.INFO_PROGRESS_PRE_INITIALIZATION_LOCAL_FINISHED_PROCEDURE.get(ConnectionUtils.getHostPort(ctx), "post-external-initialization"));
                    this.printlnProgress();
                } else {
                    this.printlnProgress();
                    this.printProgress(AdminToolMessages.INFO_PROGRESS_PRE_INITIALIZATION_FINISHED_PROCEDURE.get("post-external-initialization"));
                    this.printlnProgress();
                }
            } else {
                returnValue = ReplicationCliReturnCode.REPLICATION_CANNOT_BE_INITIALIZED_ON_BASEDN;
            }
        } else {
            returnValue = ReplicationCliReturnCode.ERROR_CONNECTING;
        }
        if (ctx != null) {
            try {
                ctx.close();
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        return returnValue;
    }

    private ReplicationCliReturnCode postExternalInitialization(PostExternalInitializationUserData uData) {
        ReplicationCliReturnCode returnValue = ReplicationCliReturnCode.SUCCESSFUL_NOP;
        InitialLdapContext ctx = null;
        try {
            ctx = this.createAdministrativeContext(uData.getHostName(), uData.getPort(), this.useSSL, this.useStartTLS, ADSContext.getAdministratorDN(uData.getAdminUid()), uData.getAdminPwd(), this.getTrustManager());
        }
        catch (NamingException ne) {
            String hostPort = uData.getHostName() + ":" + uData.getPort();
            this.println();
            this.println(this.getMessageForException(ne, hostPort));
            LOG.log(Level.SEVERE, "Complete error stack:", ne);
        }
        if (ctx != null) {
            LinkedList<String> baseDNs = uData.getBaseDNs();
            this.checkSuffixesForInitializeReplication(baseDNs, ctx, false);
            if (!baseDNs.isEmpty()) {
                for (String baseDN : baseDNs) {
                    try {
                        this.printlnProgress();
                        Message msg = this.formatter.getFormattedWithPoints(AdminToolMessages.INFO_PROGRESS_POST_EXTERNAL_INITIALIZATION.get(baseDN));
                        this.printProgress(msg);
                        this.postExternalInitialization(baseDN, ctx, false);
                        this.printProgress(this.formatter.getFormattedDone());
                        this.printlnProgress();
                    }
                    catch (ReplicationCliException rce) {
                        this.println();
                        this.println(this.getCriticalExceptionMessage(rce));
                        returnValue = rce.getErrorCode();
                        LOG.log(Level.SEVERE, "Complete error stack:", rce);
                    }
                }
                this.printlnProgress();
                this.printProgress(AdminToolMessages.INFO_PROGRESS_POST_INITIALIZATION_FINISHED_PROCEDURE.get());
                this.printlnProgress();
            } else {
                returnValue = ReplicationCliReturnCode.REPLICATION_CANNOT_BE_INITIALIZED_ON_BASEDN;
            }
        } else {
            returnValue = ReplicationCliReturnCode.ERROR_CONNECTING;
        }
        if (ctx != null) {
            try {
                ctx.close();
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        return returnValue;
    }

    private void checkSuffixesForEnableReplication(Collection<String> suffixes, InitialLdapContext ctx1, InitialLdapContext ctx2, boolean interactive) {
        TreeSet<String> availableSuffixes = new TreeSet<String>(this.getCommonSuffixes(ctx1, ctx2, SuffixRelationType.NOT_FULLY_REPLICATED));
        TreeSet<String> alreadyReplicatedSuffixes = new TreeSet<String>(this.getCommonSuffixes(ctx1, ctx2, SuffixRelationType.FULLY_REPLICATED));
        if (availableSuffixes.size() == 0) {
            this.println();
            this.println(AdminToolMessages.ERR_NO_SUFFIXES_AVAILABLE_TO_ENABLE_REPLICATION.get());
            LinkedList<String> userProvidedSuffixes = this.argParser.getBaseDNs();
            TreeSet<String> userProvidedReplicatedSuffixes = new TreeSet<String>();
            for (String s1 : userProvidedSuffixes) {
                for (String s2 : alreadyReplicatedSuffixes) {
                    if (!Utils.areDnsEqual(s1, s2)) continue;
                    userProvidedReplicatedSuffixes.add(s1);
                }
            }
            if (userProvidedReplicatedSuffixes.size() > 0) {
                this.println();
                this.println(AdminToolMessages.INFO_ALREADY_REPLICATED_SUFFIXES.get(Utils.getStringFromCollection(userProvidedReplicatedSuffixes, Constants.LINE_SEPARATOR)));
            }
            suffixes.clear();
        } else {
            TreeSet<String> notFound = new TreeSet<String>();
            TreeSet<String> alreadyReplicated = new TreeSet<String>();
            for (String dn : suffixes) {
                boolean found = false;
                for (String dn1 : availableSuffixes) {
                    if (!Utils.areDnsEqual(dn, dn1)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                boolean isReplicated = false;
                for (String s : alreadyReplicatedSuffixes) {
                    if (!Utils.areDnsEqual(s, dn)) continue;
                    isReplicated = true;
                    break;
                }
                if (isReplicated) {
                    alreadyReplicated.add(dn);
                    continue;
                }
                notFound.add(dn);
            }
            suffixes.removeAll(notFound);
            suffixes.removeAll(alreadyReplicated);
            if (notFound.size() > 0) {
                this.println();
                this.println(AdminToolMessages.ERR_REPLICATION_ENABLE_SUFFIXES_NOT_FOUND.get(Utils.getStringFromCollection(notFound, Constants.LINE_SEPARATOR)));
            }
            if (alreadyReplicated.size() > 0) {
                this.println();
                this.println(AdminToolMessages.INFO_ALREADY_REPLICATED_SUFFIXES.get(Utils.getStringFromCollection(alreadyReplicated, Constants.LINE_SEPARATOR)));
            }
            if (interactive) {
                boolean confirmationLimitReached = false;
                while (suffixes.isEmpty()) {
                    boolean noSchemaOrAds = false;
                    for (String s : availableSuffixes) {
                        if (Utils.areDnsEqual(s, ADSContext.getAdministrationSuffixDN()) || Utils.areDnsEqual(s, "cn=schema") || Utils.areDnsEqual(s, "dc=replicationChanges")) continue;
                        noSchemaOrAds = true;
                    }
                    if (!noSchemaOrAds) {
                        this.println();
                        this.println(AdminToolMessages.ERR_NO_SUFFIXES_AVAILABLE_TO_ENABLE_REPLICATION.get());
                        break;
                    }
                    this.println();
                    this.println(AdminToolMessages.ERR_NO_SUFFIXES_SELECTED_TO_REPLICATE.get());
                    for (String dn : availableSuffixes) {
                        if (Utils.areDnsEqual(dn, ADSContext.getAdministrationSuffixDN()) || Utils.areDnsEqual(dn, "cn=schema") || Utils.areDnsEqual(dn, "dc=replicationChanges")) continue;
                        try {
                            if (!this.askConfirmation(AdminToolMessages.INFO_REPLICATION_ENABLE_SUFFIX_PROMPT.get(dn), true, LOG)) continue;
                            suffixes.add(dn);
                        }
                        catch (CLIException ce) {
                            this.println(ce.getMessageObject());
                            confirmationLimitReached = true;
                            break;
                        }
                    }
                    if (!confirmationLimitReached) continue;
                    suffixes.clear();
                    break;
                }
            }
        }
    }

    private void checkSuffixesForDisableReplication(Collection<String> suffixes, InitialLdapContext ctx, boolean interactive) {
        TreeSet<String> availableSuffixes = new TreeSet<String>();
        TreeSet<String> notReplicatedSuffixes = new TreeSet<String>();
        Collection<ReplicaDescriptor> replicas = this.getReplicas(ctx);
        for (ReplicaDescriptor rep : replicas) {
            String dn = rep.getSuffix().getDN();
            if (rep.isReplicated()) {
                availableSuffixes.add(dn);
                continue;
            }
            notReplicatedSuffixes.add(dn);
        }
        if (availableSuffixes.size() == 0) {
            this.println();
            this.println(AdminToolMessages.ERR_NO_SUFFIXES_AVAILABLE_TO_DISABLE_REPLICATION.get());
            LinkedList<String> userProvidedSuffixes = this.argParser.getBaseDNs();
            TreeSet<String> userProvidedNotReplicatedSuffixes = new TreeSet<String>();
            for (String s1 : userProvidedSuffixes) {
                for (String s2 : notReplicatedSuffixes) {
                    if (!Utils.areDnsEqual(s1, s2)) continue;
                    userProvidedNotReplicatedSuffixes.add(s1);
                }
            }
            if (userProvidedNotReplicatedSuffixes.size() > 0) {
                this.println();
                this.println(AdminToolMessages.INFO_ALREADY_NOT_REPLICATED_SUFFIXES.get(Utils.getStringFromCollection(userProvidedNotReplicatedSuffixes, Constants.LINE_SEPARATOR)));
            }
            suffixes.clear();
        } else {
            TreeSet<String> notFound = new TreeSet<String>();
            TreeSet<String> alreadyNotReplicated = new TreeSet<String>();
            for (String dn : suffixes) {
                boolean found = false;
                for (String dn1 : availableSuffixes) {
                    if (!Utils.areDnsEqual(dn, dn1)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                boolean notReplicated = false;
                for (String s : notReplicatedSuffixes) {
                    if (!Utils.areDnsEqual(s, dn)) continue;
                    notReplicated = true;
                    break;
                }
                if (notReplicated) {
                    alreadyNotReplicated.add(dn);
                    continue;
                }
                notFound.add(dn);
            }
            suffixes.removeAll(notFound);
            suffixes.removeAll(alreadyNotReplicated);
            if (notFound.size() > 0) {
                this.println();
                this.println(AdminToolMessages.ERR_REPLICATION_DISABLE_SUFFIXES_NOT_FOUND.get(Utils.getStringFromCollection(notFound, Constants.LINE_SEPARATOR)));
            }
            if (alreadyNotReplicated.size() > 0) {
                this.println();
                this.println(AdminToolMessages.INFO_ALREADY_NOT_REPLICATED_SUFFIXES.get(Utils.getStringFromCollection(alreadyNotReplicated, Constants.LINE_SEPARATOR)));
            }
            if (interactive) {
                boolean confirmationLimitReached = false;
                while (suffixes.isEmpty()) {
                    boolean noSchemaOrAds = false;
                    for (String s : availableSuffixes) {
                        if (Utils.areDnsEqual(s, ADSContext.getAdministrationSuffixDN()) || Utils.areDnsEqual(s, "cn=schema") || Utils.areDnsEqual(s, "dc=replicationChanges")) continue;
                        noSchemaOrAds = true;
                    }
                    if (!noSchemaOrAds) {
                        this.println();
                        this.println(AdminToolMessages.ERR_NO_SUFFIXES_AVAILABLE_TO_DISABLE_REPLICATION.get());
                        break;
                    }
                    this.println();
                    this.println(AdminToolMessages.ERR_NO_SUFFIXES_SELECTED_TO_DISABLE.get());
                    for (String dn : availableSuffixes) {
                        if (Utils.areDnsEqual(dn, ADSContext.getAdministrationSuffixDN()) || Utils.areDnsEqual(dn, "cn=schema") || Utils.areDnsEqual(dn, "dc=replicationChanges")) continue;
                        try {
                            if (!this.askConfirmation(AdminToolMessages.INFO_REPLICATION_DISABLE_SUFFIX_PROMPT.get(dn), true, LOG)) continue;
                            suffixes.add(dn);
                        }
                        catch (CLIException ce) {
                            this.println(ce.getMessageObject());
                            confirmationLimitReached = true;
                            break;
                        }
                    }
                    if (!confirmationLimitReached) continue;
                    suffixes.clear();
                    break;
                }
            }
        }
    }

    private void checkSuffixesForInitializeReplication(Collection<String> suffixes, InitialLdapContext ctx, boolean interactive) {
        TreeSet<String> availableSuffixes = new TreeSet<String>();
        TreeSet<String> notReplicatedSuffixes = new TreeSet<String>();
        Collection<ReplicaDescriptor> replicas = this.getReplicas(ctx);
        for (ReplicaDescriptor rep : replicas) {
            String dn = rep.getSuffix().getDN();
            if (rep.isReplicated()) {
                availableSuffixes.add(dn);
                continue;
            }
            notReplicatedSuffixes.add(dn);
        }
        if (availableSuffixes.size() == 0) {
            this.println();
            if (this.argParser.isInitializeAllReplicationSubcommand()) {
                this.println(AdminToolMessages.ERR_NO_SUFFIXES_AVAILABLE_TO_INITIALIZE_ALL_REPLICATION.get());
            } else {
                this.println(AdminToolMessages.ERR_NO_SUFFIXES_AVAILABLE_TO_INITIALIZE_LOCAL_REPLICATION.get());
            }
            LinkedList<String> userProvidedSuffixes = this.argParser.getBaseDNs();
            TreeSet<String> userProvidedNotReplicatedSuffixes = new TreeSet<String>();
            for (String s1 : userProvidedSuffixes) {
                for (String s2 : notReplicatedSuffixes) {
                    if (!Utils.areDnsEqual(s1, s2)) continue;
                    userProvidedNotReplicatedSuffixes.add(s1);
                }
            }
            if (userProvidedNotReplicatedSuffixes.size() > 0) {
                this.println();
                this.println(AdminToolMessages.INFO_ALREADY_NOT_REPLICATED_SUFFIXES.get(Utils.getStringFromCollection(userProvidedNotReplicatedSuffixes, Constants.LINE_SEPARATOR)));
            }
            suffixes.clear();
        } else {
            TreeSet<String> notFound = new TreeSet<String>();
            TreeSet<String> alreadyNotReplicated = new TreeSet<String>();
            for (String dn : suffixes) {
                boolean found = false;
                for (String dn1 : availableSuffixes) {
                    if (!Utils.areDnsEqual(dn, dn1)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                boolean notReplicated = false;
                for (String s : notReplicatedSuffixes) {
                    if (!Utils.areDnsEqual(s, dn)) continue;
                    notReplicated = true;
                    break;
                }
                if (notReplicated) {
                    alreadyNotReplicated.add(dn);
                    continue;
                }
                notFound.add(dn);
            }
            suffixes.removeAll(notFound);
            suffixes.removeAll(alreadyNotReplicated);
            if (notFound.size() > 0) {
                this.println();
                this.println(AdminToolMessages.ERR_REPLICATION_INITIALIZE_LOCAL_SUFFIXES_NOT_FOUND.get(Utils.getStringFromCollection(notFound, Constants.LINE_SEPARATOR)));
            }
            if (alreadyNotReplicated.size() > 0) {
                this.println();
                this.println(AdminToolMessages.INFO_ALREADY_NOT_REPLICATED_SUFFIXES.get(Utils.getStringFromCollection(alreadyNotReplicated, Constants.LINE_SEPARATOR)));
            }
            if (interactive) {
                boolean confirmationLimitReached = false;
                while (suffixes.isEmpty()) {
                    boolean noSchemaOrAds = false;
                    for (String s : availableSuffixes) {
                        if (Utils.areDnsEqual(s, ADSContext.getAdministrationSuffixDN()) || Utils.areDnsEqual(s, "cn=schema") || Utils.areDnsEqual(s, "dc=replicationChanges")) continue;
                        noSchemaOrAds = true;
                    }
                    if (!noSchemaOrAds) {
                        this.println();
                        if (this.argParser.isInitializeAllReplicationSubcommand()) {
                            this.println(AdminToolMessages.ERR_NO_SUFFIXES_AVAILABLE_TO_INITIALIZE_ALL_REPLICATION.get());
                            break;
                        }
                        this.println(AdminToolMessages.ERR_NO_SUFFIXES_AVAILABLE_TO_INITIALIZE_LOCAL_REPLICATION.get());
                        break;
                    }
                    this.println();
                    if (this.argParser.isInitializeAllReplicationSubcommand()) {
                        this.println(AdminToolMessages.ERR_NO_SUFFIXES_SELECTED_TO_INITIALIZE_ALL.get());
                    } else if (this.argParser.isPreExternalInitializationSubcommand()) {
                        this.println(AdminToolMessages.ERR_NO_SUFFIXES_SELECTED_TO_PRE_EXTERNAL_INITIALIZATION.get());
                    } else if (this.argParser.isPostExternalInitializationSubcommand()) {
                        this.println(AdminToolMessages.ERR_NO_SUFFIXES_SELECTED_TO_POST_EXTERNAL_INITIALIZATION.get());
                    }
                    for (String dn : availableSuffixes) {
                        boolean addSuffix;
                        if (Utils.areDnsEqual(dn, ADSContext.getAdministrationSuffixDN()) || Utils.areDnsEqual(dn, "cn=schema") || Utils.areDnsEqual(dn, "dc=replicationChanges")) continue;
                        try {
                            addSuffix = this.argParser.isPreExternalInitializationSubcommand() ? this.askConfirmation(AdminToolMessages.INFO_REPLICATION_PRE_EXTERNAL_INITIALIZATION_SUFFIX_PROMPT.get(dn), true, LOG) : (this.argParser.isPostExternalInitializationSubcommand() ? this.askConfirmation(AdminToolMessages.INFO_REPLICATION_POST_EXTERNAL_INITIALIZATION_SUFFIX_PROMPT.get(dn), true, LOG) : this.askConfirmation(AdminToolMessages.INFO_REPLICATION_INITIALIZE_ALL_SUFFIX_PROMPT.get(dn), true, LOG));
                        }
                        catch (CLIException ce) {
                            this.println(ce.getMessageObject());
                            confirmationLimitReached = true;
                            break;
                        }
                        if (!addSuffix) continue;
                        suffixes.add(dn);
                    }
                    if (!confirmationLimitReached) continue;
                    suffixes.clear();
                    break;
                }
            }
        }
    }

    private void checkSuffixesForInitializeReplication(Collection<String> suffixes, InitialLdapContext ctxSource, InitialLdapContext ctxDestination, boolean interactive) {
        TreeSet<String> availableSuffixes = new TreeSet<String>(this.getCommonSuffixes(ctxSource, ctxDestination, SuffixRelationType.REPLICATED));
        if (availableSuffixes.size() == 0) {
            this.println();
            this.println(AdminToolMessages.ERR_NO_SUFFIXES_AVAILABLE_TO_INITIALIZE_REPLICATION.get());
            suffixes.clear();
        } else {
            LinkedList<String> notFound = new LinkedList<String>();
            for (String dn : suffixes) {
                boolean found = false;
                for (String dn1 : availableSuffixes) {
                    if (!Utils.areDnsEqual(dn, dn1)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                notFound.add(dn);
            }
            suffixes.removeAll(notFound);
            if (notFound.size() > 0) {
                this.println();
                this.println(AdminToolMessages.ERR_SUFFIXES_CANNOT_BE_INITIALIZED.get(Utils.getStringFromCollection(notFound, Constants.LINE_SEPARATOR)));
            }
            if (interactive) {
                boolean confirmationLimitReached = false;
                while (suffixes.isEmpty()) {
                    boolean noSchemaOrAds = false;
                    for (String s : availableSuffixes) {
                        if (Utils.areDnsEqual(s, ADSContext.getAdministrationSuffixDN()) || Utils.areDnsEqual(s, "cn=schema") || Utils.areDnsEqual(s, "dc=replicationChanges")) continue;
                        noSchemaOrAds = true;
                    }
                    if (!noSchemaOrAds) {
                        this.println();
                        this.println(AdminToolMessages.ERR_NO_SUFFIXES_AVAILABLE_TO_INITIALIZE_REPLICATION.get());
                        break;
                    }
                    this.println();
                    this.println(AdminToolMessages.ERR_NO_SUFFIXES_SELECTED_TO_INITIALIZE.get());
                    for (String dn : availableSuffixes) {
                        if (Utils.areDnsEqual(dn, ADSContext.getAdministrationSuffixDN()) || Utils.areDnsEqual(dn, "cn=schema") || Utils.areDnsEqual(dn, "dc=replicationChanges")) continue;
                        try {
                            if (!this.askConfirmation(AdminToolMessages.INFO_REPLICATION_INITIALIZE_SUFFIX_PROMPT.get(dn), true, LOG)) continue;
                            suffixes.add(dn);
                        }
                        catch (CLIException ce) {
                            this.println(ce.getMessageObject());
                            confirmationLimitReached = true;
                            break;
                        }
                    }
                    if (!confirmationLimitReached) continue;
                    suffixes.clear();
                    break;
                }
            }
        }
    }

    private void updateConfiguration(InitialLdapContext ctx1, InitialLdapContext ctx2, EnableReplicationUserData uData) throws ReplicationCliException {
        ServerDescriptor server2;
        ServerDescriptor server1;
        LinkedHashSet<String> twoReplServers = new LinkedHashSet<String>();
        LinkedHashSet<String> allRepServers = new LinkedHashSet<String>();
        HashMap hmRepServers = new HashMap();
        HashSet<Integer> usedReplicationServerIds = new HashSet<Integer>();
        HashMap hmUsedReplicationDomainIds = new HashMap();
        TopologyCacheFilter filter = new TopologyCacheFilter();
        filter.setSearchMonitoringInformation(false);
        filter.addBaseDNToSearch(ADSContext.getAdministrationSuffixDN());
        for (String dn : uData.getBaseDNs()) {
            filter.addBaseDNToSearch(dn);
        }
        try {
            server1 = ServerDescriptor.createStandalone(ctx1, filter);
        }
        catch (NamingException ne) {
            throw new ReplicationCliException(this.getMessageForException(ne, ConnectionUtils.getHostPort(ctx1)), ReplicationCliReturnCode.ERROR_READING_CONFIGURATION, ne);
        }
        try {
            server2 = ServerDescriptor.createStandalone(ctx2, filter);
        }
        catch (NamingException ne) {
            throw new ReplicationCliException(this.getMessageForException(ne, ConnectionUtils.getHostPort(ctx2)), ReplicationCliReturnCode.ERROR_READING_CONFIGURATION, ne);
        }
        ADSContext adsCtx1 = new ADSContext(ctx1);
        ADSContext adsCtx2 = new ADSContext(ctx2);
        if (!this.argParser.isInteractive()) {
            LinkedHashSet<Message> messages = new LinkedHashSet<Message>();
            try {
                TopologyCache cache;
                LinkedHashSet<PreferredConnection> cnx = new LinkedHashSet<PreferredConnection>();
                cnx.addAll(this.getPreferredConnections(ctx1));
                cnx.addAll(this.getPreferredConnections(ctx2));
                if (adsCtx1.hasAdminData()) {
                    cache = new TopologyCache(adsCtx1, this.getTrustManager());
                    cache.setPreferredConnections(cnx);
                    cache.getFilter().setSearchMonitoringInformation(false);
                    for (String dn : uData.getBaseDNs()) {
                        cache.getFilter().addBaseDNToSearch(dn);
                    }
                    cache.reloadTopology();
                    messages.addAll(this.getErrorMessages(cache));
                }
                if (adsCtx2.hasAdminData()) {
                    cache = new TopologyCache(adsCtx2, this.getTrustManager());
                    cache.setPreferredConnections(cnx);
                    cache.getFilter().setSearchMonitoringInformation(false);
                    for (String dn : uData.getBaseDNs()) {
                        cache.getFilter().addBaseDNToSearch(dn);
                    }
                    cache.reloadTopology();
                    messages.addAll(this.getErrorMessages(cache));
                }
            }
            catch (TopologyCacheException tce) {
                throw new ReplicationCliException(AdminToolMessages.ERR_REPLICATION_READING_ADS.get(tce.getMessage()), ReplicationCliReturnCode.ERROR_READING_TOPOLOGY_CACHE, tce);
            }
            catch (ADSContextException adce) {
                throw new ReplicationCliException(AdminToolMessages.ERR_REPLICATION_READING_ADS.get(adce.getMessage()), ReplicationCliReturnCode.ERROR_READING_ADS, adce);
            }
            if (!messages.isEmpty()) {
                this.println(AdminToolMessages.ERR_REPLICATION_READING_REGISTERED_SERVERS_WARNING.get(Utils.getMessageFromCollection(messages, Constants.LINE_SEPARATOR).toString()));
            }
        }
        InitialLdapContext ctxSource = null;
        InitialLdapContext ctxDestination = null;
        ADSContext adsCtxSource = null;
        boolean adsAlreadyReplicated = false;
        this.printProgress(this.formatter.getFormattedWithPoints(AdminToolMessages.INFO_REPLICATION_ENABLE_UPDATING_ADS_CONTENTS.get()));
        try {
            if (adsCtx1.hasAdminData() && adsCtx2.hasAdminData()) {
                Set<Map<ADSContext.ServerProperty, Object>> registry1 = adsCtx1.readServerRegistry();
                Set<Map<ADSContext.ServerProperty, Object>> registry2 = adsCtx2.readServerRegistry();
                if (registry2.size() <= 1) {
                    if (!this.hasAdministrator(adsCtx1.getDirContext(), uData)) {
                        adsCtx1.createAdministrator(this.getAdministratorProperties(uData));
                    }
                    if (registry2.size() == 0) {
                        server2.updateAdsPropertiesWithServerProperties();
                        this.registerServer(adsCtx1, server2.getAdsProperties());
                    } else {
                        this.registerServer(adsCtx1, registry2.iterator().next());
                    }
                    ctxSource = ctx1;
                    ctxDestination = ctx2;
                    adsCtxSource = adsCtx1;
                } else if (registry1.size() <= 1) {
                    if (!this.hasAdministrator(adsCtx2.getDirContext(), uData)) {
                        adsCtx2.createAdministrator(this.getAdministratorProperties(uData));
                    }
                    if (registry1.size() == 0) {
                        server1.updateAdsPropertiesWithServerProperties();
                        this.registerServer(adsCtx2, server1.getAdsProperties());
                    } else {
                        this.registerServer(adsCtx2, registry1.iterator().next());
                    }
                    ctxSource = ctx2;
                    ctxDestination = ctx1;
                    adsCtxSource = adsCtx2;
                } else {
                    if (!this.areEqual(registry1, registry2)) {
                        throw new ReplicationCliException(AdminToolMessages.ERR_REPLICATION_ADS_MERGE_NOT_SUPPORTED.get(ConnectionUtils.getHostPort(ctx1), ConnectionUtils.getHostPort(ctx2)), ReplicationCliReturnCode.REPLICATION_ADS_MERGE_NOT_SUPPORTED, null);
                    }
                    adsAlreadyReplicated = true;
                }
            } else if (!adsCtx1.hasAdminData() && adsCtx2.hasAdminData()) {
                if (!this.hasAdministrator(adsCtx2.getDirContext(), uData)) {
                    adsCtx2.createAdministrator(this.getAdministratorProperties(uData));
                }
                server1.updateAdsPropertiesWithServerProperties();
                this.registerServer(adsCtx2, server1.getAdsProperties());
                ctxSource = ctx2;
                ctxDestination = ctx1;
                adsCtxSource = adsCtx2;
            } else if (adsCtx1.hasAdminData() && !adsCtx2.hasAdminData()) {
                if (!this.hasAdministrator(adsCtx1.getDirContext(), uData)) {
                    adsCtx1.createAdministrator(this.getAdministratorProperties(uData));
                }
                server2.updateAdsPropertiesWithServerProperties();
                this.registerServer(adsCtx1, server2.getAdsProperties());
                ctxSource = ctx1;
                ctxDestination = ctx2;
                adsCtxSource = adsCtx1;
            } else {
                adsCtx1.createAdminData(null);
                if (!this.hasAdministrator(ctx1, uData)) {
                    adsCtx1.createAdministrator(this.getAdministratorProperties(uData));
                }
                server1.updateAdsPropertiesWithServerProperties();
                adsCtx1.registerServer(server1.getAdsProperties());
                server2.updateAdsPropertiesWithServerProperties();
                adsCtx1.registerServer(server2.getAdsProperties());
                ctxSource = ctx1;
                ctxDestination = ctx2;
                adsCtxSource = adsCtx1;
            }
        }
        catch (ADSContextException adce) {
            throw new ReplicationCliException(AdminToolMessages.ERR_REPLICATION_UPDATING_ADS.get(adce.getReason()), ReplicationCliReturnCode.ERROR_UPDATING_ADS, adce);
        }
        if (!adsAlreadyReplicated) {
            try {
                ServerDescriptor.seedAdsTrustStore(ctxDestination, adsCtxSource.getTrustedCertificates());
            }
            catch (Throwable t) {
                LOG.log(Level.SEVERE, "Error seeding truststores: " + t, t);
                throw new ReplicationCliException(AdminToolMessages.ERR_REPLICATION_ENABLE_SEEDING_TRUSTSTORE.get(t.toString()), ReplicationCliReturnCode.ERROR_SEEDING_TRUSTORE, t);
            }
        }
        this.printProgress(this.formatter.getFormattedDone());
        this.printlnProgress();
        LinkedList<String> baseDNs = uData.getBaseDNs();
        if (!adsAlreadyReplicated) {
            boolean found = false;
            for (String dn : baseDNs) {
                if (!Utils.areDnsEqual(dn, ADSContext.getAdministrationSuffixDN())) continue;
                found = true;
                break;
            }
            if (!found) {
                baseDNs.add(ADSContext.getAdministrationSuffixDN());
                uData.setBaseDNs(baseDNs);
            }
        }
        if (uData.replicateSchema()) {
            baseDNs = uData.getBaseDNs();
            baseDNs.add("cn=schema");
            uData.setBaseDNs(baseDNs);
        }
        TopologyCache cache1 = null;
        TopologyCache cache2 = null;
        try {
            LinkedHashSet<PreferredConnection> cnx = new LinkedHashSet<PreferredConnection>();
            cnx.addAll(this.getPreferredConnections(ctx1));
            cnx.addAll(this.getPreferredConnections(ctx2));
            if (adsCtx1.hasAdminData()) {
                cache1 = new TopologyCache(adsCtx1, this.getTrustManager());
                cache1.setPreferredConnections(cnx);
                cache1.getFilter().setSearchMonitoringInformation(false);
                for (String dn : uData.getBaseDNs()) {
                    cache1.getFilter().addBaseDNToSearch(dn);
                }
                cache1.reloadTopology();
                usedReplicationServerIds.addAll(this.getReplicationServerIds(cache1));
            }
            if (adsCtx2.hasAdminData()) {
                cache2 = new TopologyCache(adsCtx2, this.getTrustManager());
                cache2.setPreferredConnections(cnx);
                cache2.getFilter().setSearchMonitoringInformation(false);
                for (String dn : uData.getBaseDNs()) {
                    cache2.getFilter().addBaseDNToSearch(dn);
                }
                cache2.reloadTopology();
                usedReplicationServerIds.addAll(this.getReplicationServerIds(cache2));
            }
        }
        catch (ADSContextException adce) {
            throw new ReplicationCliException(AdminToolMessages.ERR_REPLICATION_READING_ADS.get(adce.getMessage()), ReplicationCliReturnCode.ERROR_READING_ADS, adce);
        }
        catch (TopologyCacheException tce) {
            throw new ReplicationCliException(AdminToolMessages.ERR_REPLICATION_READING_ADS.get(tce.getMessage()), ReplicationCliReturnCode.ERROR_READING_TOPOLOGY_CACHE, tce);
        }
        if (server1.isReplicationServer()) {
            twoReplServers.add(server1.getReplicationServerHostPort());
            usedReplicationServerIds.add(server1.getReplicationServerId());
        } else {
            twoReplServers.add(ConnectionUtils.getHostName(ctx1) + ":" + uData.getReplicationPort1());
        }
        if (server2.isReplicationServer()) {
            twoReplServers.add(server2.getReplicationServerHostPort());
            usedReplicationServerIds.add(server2.getReplicationServerId());
        } else {
            twoReplServers.add(ConnectionUtils.getHostName(ctx2) + ":" + uData.getReplicationPort2());
        }
        for (String baseDN : uData.getBaseDNs()) {
            LinkedHashSet<String> repServersForBaseDN = new LinkedHashSet<String>();
            repServersForBaseDN.addAll(this.getReplicationServers(baseDN, cache1, server1));
            repServersForBaseDN.addAll(this.getReplicationServers(baseDN, cache2, server2));
            repServersForBaseDN.addAll(twoReplServers);
            hmRepServers.put(baseDN, repServersForBaseDN);
            HashSet<Integer> ids = new HashSet<Integer>();
            ids.addAll(this.getReplicationDomainIds(baseDN, server1));
            ids.addAll(this.getReplicationDomainIds(baseDN, server2));
            if (cache1 != null) {
                for (ServerDescriptor server : cache1.getServers()) {
                    ids.addAll(this.getReplicationDomainIds(baseDN, server));
                }
            }
            if (cache2 != null) {
                for (ServerDescriptor server : cache2.getServers()) {
                    ids.addAll(this.getReplicationDomainIds(baseDN, server));
                }
            }
            hmUsedReplicationDomainIds.put(baseDN, ids);
        }
        for (LinkedHashSet v : hmRepServers.values()) {
            allRepServers.addAll(v);
        }
        HashSet<String> alreadyConfiguredReplicationServers = new HashSet<String>();
        if (!server1.isReplicationServer()) {
            try {
                this.configureAsReplicationServer(ctx1, uData.getReplicationPort1(), uData.isSecureReplication1(), allRepServers, usedReplicationServerIds);
            }
            catch (OpenDsException ode) {
                throw new ReplicationCliException(this.getMessageForReplicationServerException(ode, ConnectionUtils.getHostPort(ctx1)), ReplicationCliReturnCode.ERROR_CONFIGURING_REPLICATIONSERVER, ode);
            }
        }
        try {
            this.updateReplicationServer(ctx1, allRepServers);
        }
        catch (OpenDsException ode) {
            throw new ReplicationCliException(this.getMessageForReplicationServerException(ode, ConnectionUtils.getHostPort(ctx1)), ReplicationCliReturnCode.ERROR_CONFIGURING_REPLICATIONSERVER, ode);
        }
        alreadyConfiguredReplicationServers.add(server1.getId());
        if (!server2.isReplicationServer()) {
            try {
                this.configureAsReplicationServer(ctx2, uData.getReplicationPort2(), uData.isSecureReplication2(), allRepServers, usedReplicationServerIds);
            }
            catch (OpenDsException ode) {
                throw new ReplicationCliException(this.getMessageForReplicationServerException(ode, ConnectionUtils.getHostPort(ctx1)), ReplicationCliReturnCode.ERROR_CONFIGURING_REPLICATIONSERVER, ode);
            }
        }
        try {
            this.updateReplicationServer(ctx2, allRepServers);
        }
        catch (OpenDsException ode) {
            throw new ReplicationCliException(this.getMessageForReplicationServerException(ode, ConnectionUtils.getHostPort(ctx1)), ReplicationCliReturnCode.ERROR_CONFIGURING_REPLICATIONSERVER, ode);
        }
        alreadyConfiguredReplicationServers.add(server2.getId());
        for (String baseDN : uData.getBaseDNs()) {
            LinkedHashSet repServers = (LinkedHashSet)hmRepServers.get(baseDN);
            Set usedIds = (Set)hmUsedReplicationDomainIds.get(baseDN);
            HashSet<String> alreadyConfiguredServers = new HashSet<String>();
            try {
                this.configureToReplicateBaseDN(ctx1, baseDN, repServers, usedIds);
            }
            catch (OpenDsException ode) {
                Message msg = this.getMessageForEnableException(ode, ConnectionUtils.getHostPort(ctx1), baseDN);
                throw new ReplicationCliException(msg, ReplicationCliReturnCode.ERROR_ENABLING_REPLICATION_ON_BASEDN, ode);
            }
            alreadyConfiguredServers.add(server1.getId());
            try {
                this.configureToReplicateBaseDN(ctx2, baseDN, repServers, usedIds);
            }
            catch (OpenDsException ode) {
                Message msg = this.getMessageForEnableException(ode, ConnectionUtils.getHostPort(ctx2), baseDN);
                throw new ReplicationCliException(msg, ReplicationCliReturnCode.ERROR_ENABLING_REPLICATION_ON_BASEDN, ode);
            }
            alreadyConfiguredServers.add(server2.getId());
            if (cache1 != null) {
                this.configureToReplicateBaseDN(baseDN, repServers, usedIds, cache1, server1, alreadyConfiguredServers, allRepServers, alreadyConfiguredReplicationServers);
            }
            if (cache2 == null) continue;
            this.configureToReplicateBaseDN(baseDN, repServers, usedIds, cache2, server2, alreadyConfiguredServers, allRepServers, alreadyConfiguredReplicationServers);
        }
        if (ctxSource != null && ctxDestination != null) {
            this.printProgress(this.formatter.getFormattedWithPoints(AdminToolMessages.INFO_ENABLE_REPLICATION_INITIALIZING_ADS.get(ConnectionUtils.getHostPort(ctxDestination), ConnectionUtils.getHostPort(ctxSource))));
            this.initializeSuffix(ADSContext.getAdministrationSuffixDN(), ctxSource, ctxDestination, false);
            this.printProgress(this.formatter.getFormattedDone());
            this.printlnProgress();
        }
        if (this.mustInitializeSchema(server1, server2)) {
            if (this.argParser.useSecondServerAsSchemaSource()) {
                ctxSource = ctx2;
                ctxDestination = ctx1;
            } else {
                ctxSource = ctx1;
                ctxDestination = ctx2;
            }
            this.printProgress(this.formatter.getFormattedWithPoints(AdminToolMessages.INFO_ENABLE_REPLICATION_INITIALIZING_SCHEMA.get(ConnectionUtils.getHostPort(ctxDestination), ConnectionUtils.getHostPort(ctxSource))));
            this.initializeSuffix("cn=schema", ctxSource, ctxDestination, false);
            this.printProgress(this.formatter.getFormattedDone());
            this.printlnProgress();
        }
    }

    private void updateConfiguration(InitialLdapContext ctx, DisableReplicationUserData uData) throws ReplicationCliException {
        ServerDescriptor server;
        TopologyCacheFilter filter = new TopologyCacheFilter();
        filter.setSearchMonitoringInformation(false);
        filter.addBaseDNToSearch(ADSContext.getAdministrationSuffixDN());
        for (String dn : uData.getBaseDNs()) {
            filter.addBaseDNToSearch(dn);
        }
        try {
            server = ServerDescriptor.createStandalone(ctx, filter);
        }
        catch (NamingException ne) {
            throw new ReplicationCliException(this.getMessageForException(ne, ConnectionUtils.getHostPort(ctx)), ReplicationCliReturnCode.ERROR_READING_CONFIGURATION, ne);
        }
        ADSContext adsCtx = new ADSContext(ctx);
        TopologyCache cache = null;
        boolean tryToUpdateRemote = uData.getAdminUid() != null;
        try {
            if (adsCtx.hasAdminData() && tryToUpdateRemote) {
                cache = new TopologyCache(adsCtx, this.getTrustManager());
                cache.setPreferredConnections(this.getPreferredConnections(ctx));
                cache.getFilter().setSearchMonitoringInformation(false);
                for (String dn : uData.getBaseDNs()) {
                    cache.getFilter().addBaseDNToSearch(dn);
                }
                cache.reloadTopology();
            }
        }
        catch (ADSContextException adce) {
            throw new ReplicationCliException(AdminToolMessages.ERR_REPLICATION_READING_ADS.get(adce.getMessage()), ReplicationCliReturnCode.ERROR_READING_ADS, adce);
        }
        catch (TopologyCacheException tce) {
            throw new ReplicationCliException(AdminToolMessages.ERR_REPLICATION_READING_ADS.get(tce.getMessage()), ReplicationCliReturnCode.ERROR_READING_TOPOLOGY_CACHE, tce);
        }
        if (!this.argParser.isInteractive()) {
            LinkedHashSet<Message> messages = new LinkedHashSet<Message>();
            if (cache != null) {
                messages.addAll(this.getErrorMessages(cache));
            }
            if (!messages.isEmpty()) {
                this.println(AdminToolMessages.ERR_REPLICATION_READING_REGISTERED_SERVERS_WARNING.get(Utils.getMessageFromCollection(messages, Constants.LINE_SEPARATOR).toString()));
            }
        }
        boolean forceDisableSchema = false;
        boolean forceDisableADS = false;
        boolean schemaReplicated = false;
        boolean adsReplicated = false;
        boolean disableAllBaseDns = this.disableAllBaseDns(ctx, uData);
        Collection<ReplicaDescriptor> replicas = this.getReplicas(ctx);
        for (ReplicaDescriptor rep : replicas) {
            String dn = rep.getSuffix().getDN();
            if (!rep.isReplicated()) continue;
            if (Utils.areDnsEqual(ADSContext.getAdministrationSuffixDN(), dn)) {
                adsReplicated = true;
                continue;
            }
            if (!Utils.areDnsEqual("cn=schema", dn)) continue;
            schemaReplicated = true;
        }
        if (disableAllBaseDns) {
            server.updateAdsPropertiesWithServerProperties();
            try {
                adsCtx.unregisterServer(server.getAdsProperties());
                try {
                    Thread.sleep(2000L);
                }
                catch (Throwable t) {}
            }
            catch (ADSContextException adce) {
                LOG.log(Level.INFO, "Error unregistering server: " + server.getAdsProperties(), adce);
                this.println();
                this.println(AdminToolMessages.ERR_REPLICATION_UPDATING_ADS.get(adce.getMessage()));
                this.println();
            }
        }
        if (disableAllBaseDns) {
            forceDisableSchema = schemaReplicated;
            forceDisableADS = adsReplicated;
            for (String dn : uData.getBaseDNs()) {
                if (Utils.areDnsEqual(ADSContext.getAdministrationSuffixDN(), dn)) {
                    forceDisableADS = false;
                    continue;
                }
                if (!Utils.areDnsEqual("cn=schema", dn)) continue;
                forceDisableSchema = false;
            }
        }
        HashSet<String> suffixesToDisable = new HashSet<String>(uData.getBaseDNs());
        if (forceDisableSchema) {
            suffixesToDisable.add("cn=schema");
        }
        if (forceDisableADS) {
            suffixesToDisable.add(ADSContext.getAdministrationSuffixDN());
        }
        String replicationServerHostPort = server.getReplicationServerHostPort();
        for (String baseDN : suffixesToDisable) {
            try {
                this.deleteReplicationDomain(ctx, baseDN);
            }
            catch (OpenDsException ode) {
                Message msg = this.getMessageForDisableException(ode, ConnectionUtils.getHostPort(ctx), baseDN);
                throw new ReplicationCliException(msg, ReplicationCliReturnCode.ERROR_DISABLING_REPLICATION_ON_BASEDN, ode);
            }
        }
        if (replicationServerHostPort != null && cache != null) {
            LinkedHashSet<ServerDescriptor> serversToUpdate = new LinkedHashSet<ServerDescriptor>();
            for (String baseDN : suffixesToDisable) {
                SuffixDescriptor suffix = this.getSuffix(baseDN, cache, server);
                if (suffix == null) continue;
                for (ReplicaDescriptor replica : suffix.getReplicas()) {
                    serversToUpdate.add(replica.getServer());
                }
            }
            String bindDn = ConnectionUtils.getBindDN(ctx);
            String pwd = ConnectionUtils.getBindPassword(ctx);
            for (ServerDescriptor s : serversToUpdate) {
                this.removeReferencesInServer(s, replicationServerHostPort, bindDn, pwd, suffixesToDisable, disableAllBaseDns, this.getPreferredConnections(ctx));
            }
            if (disableAllBaseDns) {
                this.disableReplicationServer(ctx);
                try {
                    Thread.sleep(2000L);
                }
                catch (Throwable t) {
                    // empty catch block
                }
                for (ServerDescriptor s : serversToUpdate) {
                    try {
                        adsCtx.unregisterServer(s.getAdsProperties());
                    }
                    catch (ADSContextException adce) {
                        LOG.log(Level.INFO, "Error unregistering server: " + s.getAdsProperties(), adce);
                        this.println();
                        this.println(AdminToolMessages.ERR_REPLICATION_UPDATING_ADS.get(adce.getMessage()));
                        this.println();
                    }
                }
            }
        }
    }

    private void displayStatus(InitialLdapContext ctx, StatusReplicationUserData uData) throws ReplicationCliException {
        ADSContext adsCtx = new ADSContext(ctx);
        TopologyCache cache = null;
        try {
            cache = new TopologyCache(adsCtx, this.getTrustManager());
            cache.setPreferredConnections(this.getPreferredConnections(ctx));
            for (String dn : uData.getBaseDNs()) {
                cache.getFilter().addBaseDNToSearch(dn);
            }
            cache.reloadTopology();
        }
        catch (TopologyCacheException tce) {
            throw new ReplicationCliException(AdminToolMessages.ERR_REPLICATION_READING_ADS.get(tce.getMessage()), ReplicationCliReturnCode.ERROR_READING_TOPOLOGY_CACHE, tce);
        }
        if (!this.argParser.isInteractive()) {
            LinkedHashSet<Message> messages = new LinkedHashSet<Message>();
            if (cache != null) {
                messages.addAll(this.getErrorMessages(cache));
            }
            if (!messages.isEmpty()) {
                Message msg = AdminToolMessages.ERR_REPLICATION_STATUS_READING_REGISTERED_SERVERS.get(Utils.getMessageFromCollection(messages, Constants.LINE_SEPARATOR).toString());
                this.println(msg);
            }
        }
        LinkedList<String> userBaseDNs = uData.getBaseDNs();
        LinkedList<Set<ReplicaDescriptor>> replicaLists = new LinkedList<Set<ReplicaDescriptor>>();
        boolean oneReplicated = false;
        for (SuffixDescriptor suffix : cache.getSuffixes()) {
            String baseDN;
            String string = suffix.getDN();
            boolean found = userBaseDNs.isEmpty() && !Utils.areDnsEqual(string, ADSContext.getAdministrationSuffixDN()) && !Utils.areDnsEqual(string, "cn=schema") && !Utils.areDnsEqual(string, "dc=replicationChanges");
            Iterator i$ = userBaseDNs.iterator();
            while (i$.hasNext() && !(found = Utils.areDnsEqual(baseDN = (String)i$.next(), string))) {
            }
            if (!found) continue;
            boolean replicated = false;
            for (ReplicaDescriptor replicaDescriptor : suffix.getReplicas()) {
                if (!replicaDescriptor.isReplicated()) continue;
                replicated = true;
                break;
            }
            if (replicated) {
                oneReplicated = true;
                replicaLists.add(suffix.getReplicas());
                continue;
            }
            found = false;
            for (Set set : replicaLists) {
                ReplicaDescriptor replica = (ReplicaDescriptor)set.iterator().next();
                if (replica.isReplicated() || !Utils.areDnsEqual(string, replica.getSuffix().getDN())) continue;
                set.addAll(suffix.getReplicas());
                found = true;
                break;
            }
            if (found) continue;
            replicaLists.add(suffix.getReplicas());
        }
        if (replicaLists.isEmpty()) {
            this.printProgress(AdminToolMessages.INFO_REPLICATION_STATUS_NO_BASEDNS.get());
            this.printlnProgress();
        } else {
            LinkedList<Set> orderedReplicaLists = new LinkedList<Set>();
            for (Set set : replicaLists) {
                String dn1 = ((ReplicaDescriptor)set.iterator().next()).getSuffix().getDN();
                boolean inserted = false;
                for (int i = 0; i < orderedReplicaLists.size() && !inserted; ++i) {
                    String string = ((ReplicaDescriptor)((Set)orderedReplicaLists.get(i)).iterator().next()).getSuffix().getDN();
                    if (dn1.compareTo(string) >= 0) continue;
                    orderedReplicaLists.add(i, set);
                    inserted = true;
                }
                if (inserted) continue;
                orderedReplicaLists.add(set);
            }
            for (Set set : orderedReplicaLists) {
                this.printlnProgress();
                this.displayStatus(set, uData.isScriptFriendly(), this.getPreferredConnections(ctx));
            }
            if (oneReplicated && !uData.isScriptFriendly()) {
                this.printlnProgress();
                this.printProgress(AdminToolMessages.INFO_REPLICATION_STATUS_REPLICATED_LEGEND.get());
                this.printlnProgress();
            }
        }
    }

    private void displayStatus(Set<ReplicaDescriptor> replicas, boolean scriptFriendly, LinkedHashSet<PreferredConnection> cnx) {
        int j;
        boolean isReplicated = false;
        LinkedHashSet<ReplicaDescriptor> orderedReplicas = new LinkedHashSet<ReplicaDescriptor>();
        TreeSet<String> hostPorts = new TreeSet<String>();
        for (ReplicaDescriptor replica : replicas) {
            if (replica.isReplicated()) {
                isReplicated = true;
            }
            hostPorts.add(this.getHostPort(replica.getServer(), cnx));
        }
        for (String hostPort : hostPorts) {
            for (ReplicaDescriptor replica : replicas) {
                if (!this.getHostPort(replica.getServer(), cnx).equals(hostPort)) continue;
                orderedReplicas.add(replica);
            }
        }
        boolean SERVERPORT = false;
        boolean NUMBER_ENTRIES = true;
        int MISSING_CHANGES = 2;
        int AGE_OF_OLDEST_MISSING_CHANGE = 3;
        int REPLICATION_PORT = 4;
        int SECURE = 5;
        Message[] headers = scriptFriendly ? (isReplicated ? new Message[]{AdminToolMessages.INFO_REPLICATION_STATUS_LABEL_SERVERPORT.get(), AdminToolMessages.INFO_REPLICATION_STATUS_LABEL_NUMBER_ENTRIES.get(), AdminToolMessages.INFO_REPLICATION_STATUS_LABEL_MISSING_CHANGES.get(), AdminToolMessages.INFO_REPLICATION_STATUS_LABEL_AGE_OF_OLDEST_MISSING_CHANGE.get(), AdminToolMessages.INFO_REPLICATION_STATUS_LABEL_REPLICATION_PORT.get(), AdminToolMessages.INFO_REPLICATION_STATUS_LABEL_SECURE.get()} : new Message[]{AdminToolMessages.INFO_REPLICATION_STATUS_LABEL_SERVERPORT.get(), AdminToolMessages.INFO_REPLICATION_STATUS_LABEL_NUMBER_ENTRIES.get()}) : (isReplicated ? new Message[]{AdminToolMessages.INFO_REPLICATION_STATUS_HEADER_SERVERPORT.get(), AdminToolMessages.INFO_REPLICATION_STATUS_HEADER_NUMBER_ENTRIES.get(), AdminToolMessages.INFO_REPLICATION_STATUS_HEADER_MISSING_CHANGES.get(), AdminToolMessages.INFO_REPLICATION_STATUS_HEADER_AGE_OF_OLDEST_MISSING_CHANGE.get(), AdminToolMessages.INFO_REPLICATION_STATUS_HEADER_REPLICATION_PORT.get(), AdminToolMessages.INFO_REPLICATION_STATUS_HEADER_SECURE.get()} : new Message[]{AdminToolMessages.INFO_REPLICATION_STATUS_HEADER_SERVERPORT.get(), AdminToolMessages.INFO_REPLICATION_STATUS_HEADER_NUMBER_ENTRIES.get()});
        Message[][] values = new Message[orderedReplicas.size()][headers.length];
        int i = 0;
        for (ReplicaDescriptor replica : orderedReplicas) {
            for (j = 0; j < headers.length; ++j) {
                Message v;
                switch (j) {
                    case 0: {
                        v = Message.raw(this.getHostPort(replica.getServer(), cnx), new Object[0]);
                        break;
                    }
                    case 1: {
                        int nEntries = replica.getEntries();
                        if (nEntries >= 0) {
                            v = Message.raw(String.valueOf(nEntries), new Object[0]);
                            break;
                        }
                        v = AdminToolMessages.INFO_NOT_AVAILABLE_SHORT_LABEL.get();
                        break;
                    }
                    case 2: {
                        int missingChanges = replica.getMissingChanges();
                        if (missingChanges >= 0) {
                            v = Message.raw(String.valueOf(missingChanges), new Object[0]);
                            break;
                        }
                        v = AdminToolMessages.INFO_NOT_AVAILABLE_SHORT_LABEL.get();
                        break;
                    }
                    case 3: {
                        long ageOfOldestMissingChange = replica.getAgeOfOldestMissingChange();
                        if (ageOfOldestMissingChange > 0L) {
                            Date date = new Date(ageOfOldestMissingChange);
                            v = Message.raw(date.toString(), new Object[0]);
                            break;
                        }
                        v = AdminToolMessages.INFO_NOT_AVAILABLE_SHORT_LABEL.get();
                        break;
                    }
                    case 4: {
                        int replicationPort = replica.getServer().getReplicationServerPort();
                        if (replicationPort >= 0) {
                            v = Message.raw(String.valueOf(replicationPort), new Object[0]);
                            break;
                        }
                        v = AdminToolMessages.INFO_NOT_AVAILABLE_SHORT_LABEL.get();
                        break;
                    }
                    case 5: {
                        if (replica.getServer().isReplicationSecure()) {
                            v = AdminToolMessages.INFO_REPLICATION_STATUS_SECURITY_ENABLED.get();
                            break;
                        }
                        v = AdminToolMessages.INFO_REPLICATION_STATUS_SECURITY_DISABLED.get();
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unknown index: " + j);
                    }
                }
                values[i][j] = v;
            }
            ++i;
        }
        String dn = replicas.iterator().next().getSuffix().getDN();
        if (scriptFriendly) {
            Message[] labels = new Message[]{AdminToolMessages.INFO_REPLICATION_STATUS_BASEDN.get(), AdminToolMessages.INFO_REPLICATION_STATUS_IS_REPLICATED.get()};
            Message[] vs = new Message[]{Message.raw(dn, new Object[0]), isReplicated ? AdminToolMessages.INFO_BASEDN_REPLICATED_LABEL.get() : AdminToolMessages.INFO_BASEDN_NOT_REPLICATED_LABEL.get()};
            for (i = 0; i < labels.length; ++i) {
                this.printProgress(Message.raw(labels[i] + " " + vs[i], new Object[0]));
                this.printlnProgress();
            }
            for (i = 0; i < values.length; ++i) {
                this.printProgress(Message.raw("-", new Object[0]));
                this.printlnProgress();
                for (j = 0; j < values[i].length; ++j) {
                    this.printProgress(Message.raw(headers[j] + " " + values[i][j], new Object[0]));
                    this.printlnProgress();
                }
            }
        } else {
            Message msg = isReplicated ? AdminToolMessages.INFO_REPLICATION_STATUS_REPLICATED.get(dn) : AdminToolMessages.INFO_REPLICATION_STATUS_NOT_REPLICATED.get(dn);
            this.printProgressMessageNoWrap(msg);
            this.printlnProgress();
            int length = msg.length();
            StringBuffer buf = new StringBuffer();
            for (i = 0; i < length; ++i) {
                buf.append("=");
            }
            this.printProgressMessageNoWrap(Message.raw(buf.toString(), new Object[0]));
            this.printlnProgress();
            TableBuilder table = new TableBuilder();
            for (i = 0; i < headers.length; ++i) {
                table.appendHeading(headers[i]);
            }
            for (i = 0; i < values.length; ++i) {
                table.startRow();
                for (int j2 = 0; j2 < headers.length; ++j2) {
                    table.appendCell(values[i][j2]);
                }
            }
            TextTablePrinter printer = new TextTablePrinter(this.getOutputStream());
            printer.setColumnSeparator(":");
            table.print(printer);
        }
    }

    private LinkedHashSet<String> getReplicationServers(String baseDN, TopologyCache cache, ServerDescriptor server) {
        LinkedHashSet<String> servers = new LinkedHashSet<String>();
        for (ReplicaDescriptor replica : server.getReplicas()) {
            if (!Utils.areDnsEqual(replica.getSuffix().getDN(), baseDN)) continue;
            servers.addAll(replica.getReplicationServers());
            break;
        }
        if (cache != null) {
            Set<SuffixDescriptor> suffixes = cache.getSuffixes();
            for (SuffixDescriptor suffix : suffixes) {
                if (!Utils.areDnsEqual(suffix.getDN(), baseDN)) continue;
                Set<String> s = suffix.getReplicationServers();
                HashSet<String> copy = new HashSet<String>(s);
                copy.retainAll(servers);
                if (copy.isEmpty()) continue;
                servers.addAll(s);
                break;
            }
        }
        return servers;
    }

    private SuffixDescriptor getSuffix(String baseDN, TopologyCache cache, ServerDescriptor server) {
        SuffixDescriptor returnValue = null;
        LinkedHashSet<String> servers = new LinkedHashSet<String>();
        for (ReplicaDescriptor replica : server.getReplicas()) {
            if (!Utils.areDnsEqual(replica.getSuffix().getDN(), baseDN)) continue;
            servers.addAll(replica.getReplicationServers());
            break;
        }
        Set<SuffixDescriptor> suffixes = cache.getSuffixes();
        for (SuffixDescriptor suffix : suffixes) {
            if (!Utils.areDnsEqual(suffix.getDN(), baseDN)) continue;
            Set<String> s = suffix.getReplicationServers();
            HashSet<String> copy = new HashSet<String>(s);
            copy.retainAll(servers);
            if (copy.isEmpty()) continue;
            returnValue = suffix;
            break;
        }
        return returnValue;
    }

    private Set<Integer> getReplicationDomainIds(String baseDN, ServerDescriptor server) {
        HashSet<Integer> ids = new HashSet<Integer>();
        for (ReplicaDescriptor replica : server.getReplicas()) {
            if (!replica.isReplicated() || !Utils.areDnsEqual(replica.getSuffix().getDN(), baseDN)) continue;
            ids.add(replica.getReplicationId());
            break;
        }
        return ids;
    }

    private void configureAsReplicationServer(InitialLdapContext ctx, int replicationPort, boolean useSecureReplication, LinkedHashSet<String> replicationServers, Set<Integer> usedReplicationServerIds) throws OpenDsException {
        this.printProgress(this.formatter.getFormattedWithPoints(AdminToolMessages.INFO_REPLICATION_ENABLE_CONFIGURING_REPLICATION_SERVER.get(ConnectionUtils.getHostPort(ctx))));
        ManagementContext mCtx = LDAPManagementContext.createFromContext(JNDIDirContextAdaptor.adapt(ctx));
        RootCfgClient root = mCtx.getRootConfiguration();
        ReplicationSynchronizationProviderCfgClient sync = null;
        try {
            sync = (ReplicationSynchronizationProviderCfgClient)root.getSynchronizationProvider("Multimaster Synchronization");
        }
        catch (ManagedObjectNotFoundException monfe) {
            LOG.log(Level.INFO, "Synchronization server does not exist in " + ConnectionUtils.getHostPort(ctx));
        }
        if (sync == null) {
            ReplicationSynchronizationProviderCfgDefn provider = ReplicationSynchronizationProviderCfgDefn.getInstance();
            sync = root.createSynchronizationProvider(provider, "Multimaster Synchronization", new ArrayList<DefaultBehaviorException>());
            sync.setJavaClass(MultimasterReplication.class.getName());
            sync.setEnabled(Boolean.TRUE);
        } else if (!sync.isEnabled().booleanValue()) {
            sync.setEnabled(Boolean.TRUE);
        }
        sync.commit();
        ReplicationServerCfgClient replicationServer = null;
        boolean mustCommit = false;
        if (!sync.hasReplicationServer()) {
            CryptoManagerCfgClient crypto = root.getCryptoManager();
            if (useSecureReplication != crypto.isSSLEncryption()) {
                crypto.setSSLEncryption(useSecureReplication);
                crypto.commit();
            }
            int id = InstallerHelper.getReplicationId(usedReplicationServerIds);
            usedReplicationServerIds.add(id);
            replicationServer = sync.createReplicationServer(ReplicationServerCfgDefn.getInstance(), new ArrayList<DefaultBehaviorException>());
            replicationServer.setReplicationServerId(id);
            replicationServer.setReplicationPort(replicationPort);
            replicationServer.setReplicationServer(replicationServers);
            mustCommit = true;
        } else {
            replicationServer = sync.getReplicationServer();
            usedReplicationServerIds.add(replicationServer.getReplicationServerId());
            SortedSet<String> servers = replicationServer.getReplicationServer();
            if (servers == null) {
                replicationServer.setReplicationServer(replicationServers);
                mustCommit = true;
            } else if (!this.areReplicationServersEqual(servers, replicationServers)) {
                replicationServers.addAll(servers);
                replicationServer.setReplicationServer(this.mergeReplicationServers(replicationServers, servers));
                mustCommit = true;
            }
        }
        if (mustCommit) {
            replicationServer.commit();
        }
        this.printProgress(this.formatter.getFormattedDone());
        this.printlnProgress();
    }

    private void updateReplicationServer(InitialLdapContext ctx, LinkedHashSet<String> replicationServers) throws OpenDsException {
        this.printProgress(this.formatter.getFormattedWithPoints(AdminToolMessages.INFO_REPLICATION_ENABLE_UPDATING_REPLICATION_SERVER.get(ConnectionUtils.getHostPort(ctx))));
        ManagementContext mCtx = LDAPManagementContext.createFromContext(JNDIDirContextAdaptor.adapt(ctx));
        RootCfgClient root = mCtx.getRootConfiguration();
        ReplicationSynchronizationProviderCfgClient sync = (ReplicationSynchronizationProviderCfgClient)root.getSynchronizationProvider("Multimaster Synchronization");
        boolean mustCommit = false;
        ReplicationServerCfgClient replicationServer = sync.getReplicationServer();
        SortedSet<String> servers = replicationServer.getReplicationServer();
        if (servers == null) {
            replicationServer.setReplicationServer(replicationServers);
            mustCommit = true;
        } else if (!this.areReplicationServersEqual(servers, replicationServers)) {
            replicationServers.addAll(servers);
            replicationServer.setReplicationServer(this.mergeReplicationServers(replicationServers, servers));
            mustCommit = true;
        }
        if (mustCommit) {
            replicationServer.commit();
        }
        this.printProgress(this.formatter.getFormattedDone());
        this.printlnProgress();
    }

    private Set<Integer> getReplicationServerIds(TopologyCache cache) {
        HashSet<Integer> ids = new HashSet<Integer>();
        for (ServerDescriptor server : cache.getServers()) {
            if (!server.isReplicationServer()) continue;
            ids.add(server.getReplicationServerId());
        }
        return ids;
    }

    private void configureToReplicateBaseDN(InitialLdapContext ctx, String baseDN, LinkedHashSet<String> replicationServers, Set<Integer> usedReplicationDomainIds) throws OpenDsException {
        boolean userSpecifiedAdminBaseDN = false;
        LinkedList<String> l = this.argParser.getBaseDNs();
        if (l != null) {
            for (String dn : l) {
                if (!Utils.areDnsEqual(dn, ADSContext.getAdministrationSuffixDN())) continue;
                userSpecifiedAdminBaseDN = true;
                break;
            }
        }
        if (!userSpecifiedAdminBaseDN && Utils.areDnsEqual(baseDN, ADSContext.getAdministrationSuffixDN())) {
            this.printProgress(this.formatter.getFormattedWithPoints(AdminToolMessages.INFO_REPLICATION_ENABLE_CONFIGURING_ADS.get(ConnectionUtils.getHostPort(ctx))));
        } else {
            this.printProgress(this.formatter.getFormattedWithPoints(AdminToolMessages.INFO_REPLICATION_ENABLE_CONFIGURING_BASEDN.get(baseDN, ConnectionUtils.getHostPort(ctx))));
        }
        ManagementContext mCtx = LDAPManagementContext.createFromContext(JNDIDirContextAdaptor.adapt(ctx));
        RootCfgClient root = mCtx.getRootConfiguration();
        ReplicationSynchronizationProviderCfgClient sync = (ReplicationSynchronizationProviderCfgClient)root.getSynchronizationProvider("Multimaster Synchronization");
        String[] domainNames = sync.listReplicationDomains();
        if (domainNames == null) {
            domainNames = new String[]{};
        }
        ReplicationDomainCfgClient[] domains = new ReplicationDomainCfgClient[domainNames.length];
        for (int i = 0; i < domains.length; ++i) {
            domains[i] = sync.getReplicationDomain(domainNames[i]);
        }
        ReplicationDomainCfgClient domain = null;
        String domainName = null;
        for (int i = 0; i < domains.length && domain == null; ++i) {
            if (!Utils.areDnsEqual(baseDN, domains[i].getBaseDN().toString())) continue;
            domain = domains[i];
            domainName = domainNames[i];
        }
        boolean mustCommit = false;
        if (domain == null) {
            int domainId = InstallerHelper.getReplicationId(usedReplicationDomainIds);
            usedReplicationDomainIds.add(domainId);
            domainName = InstallerHelper.getDomainName(domainNames, domainId, baseDN);
            domain = sync.createReplicationDomain(ReplicationDomainCfgDefn.getInstance(), domainName, new ArrayList<DefaultBehaviorException>());
            domain.setServerId(domainId);
            domain.setBaseDN(DN.decode(baseDN));
            domain.setReplicationServer(replicationServers);
            mustCommit = true;
        } else {
            SortedSet<String> servers = domain.getReplicationServer();
            if (servers == null) {
                domain.setReplicationServer(servers);
                mustCommit = true;
            } else if (!this.areReplicationServersEqual(servers, replicationServers)) {
                domain.setReplicationServer(this.mergeReplicationServers(replicationServers, servers));
                mustCommit = true;
            }
        }
        if (mustCommit) {
            domain.commit();
        }
        this.printProgress(this.formatter.getFormattedDone());
        this.printlnProgress();
    }

    private void configureToReplicateBaseDN(String baseDN, LinkedHashSet<String> repServers, Set<Integer> usedIds, TopologyCache cache, ServerDescriptor server, Set<String> alreadyConfiguredServers, LinkedHashSet<String> allRepServers, Set<String> alreadyConfiguredReplicationServers) throws ReplicationCliException {
        SuffixDescriptor suffix = this.getSuffix(baseDN, cache, server);
        if (suffix != null) {
            for (ReplicaDescriptor replica : suffix.getReplicas()) {
                ServerDescriptor s = replica.getServer();
                if (alreadyConfiguredServers.contains(s.getId())) continue;
                String dn = ConnectionUtils.getBindDN(cache.getAdsContext().getDirContext());
                String pwd = ConnectionUtils.getBindPassword(cache.getAdsContext().getDirContext());
                TopologyCacheFilter filter = new TopologyCacheFilter();
                filter.setSearchMonitoringInformation(false);
                filter.setSearchBaseDNInformation(false);
                ServerLoader loader = new ServerLoader(s.getAdsProperties(), dn, pwd, this.getTrustManager(), cache.getPreferredConnections(), filter);
                InitialLdapContext ctx = null;
                try {
                    ctx = loader.createContext();
                    this.configureToReplicateBaseDN(ctx, baseDN, repServers, usedIds);
                    if (!alreadyConfiguredReplicationServers.contains(s.getId())) {
                        this.updateReplicationServer(ctx, allRepServers);
                        alreadyConfiguredReplicationServers.add(s.getId());
                    }
                }
                catch (NamingException ne) {
                    String hostPort = this.getHostPort(server, cache.getPreferredConnections());
                    Message msg = this.getMessageForException(ne, hostPort);
                    throw new ReplicationCliException(msg, ReplicationCliReturnCode.ERROR_CONNECTING, ne);
                }
                catch (OpenDsException ode) {
                    String hostPort = this.getHostPort(server, cache.getPreferredConnections());
                    Message msg = this.getMessageForEnableException(ode, hostPort, baseDN);
                    throw new ReplicationCliException(msg, ReplicationCliReturnCode.ERROR_ENABLING_REPLICATION_ON_BASEDN, ode);
                }
                finally {
                    if (ctx != null) {
                        try {
                            ctx.close();
                        }
                        catch (Throwable t) {}
                    }
                }
                alreadyConfiguredServers.add(s.getId());
            }
        }
    }

    private Map<ADSContext.AdministratorProperty, Object> getAdministratorProperties(ReplicationUserData uData) {
        HashMap<ADSContext.AdministratorProperty, Object> adminProperties = new HashMap<ADSContext.AdministratorProperty, Object>();
        adminProperties.put(ADSContext.AdministratorProperty.UID, uData.getAdminUid());
        adminProperties.put(ADSContext.AdministratorProperty.PASSWORD, uData.getAdminPwd());
        adminProperties.put(ADSContext.AdministratorProperty.DESCRIPTION, QuickSetupMessages.INFO_GLOBAL_ADMINISTRATOR_DESCRIPTION.get().toString());
        return adminProperties;
    }

    private void initializeSuffix(String baseDN, InitialLdapContext ctxSource, InitialLdapContext ctxDestination, boolean displayProgress) throws ReplicationCliException {
        int replicationId = -1;
        try {
            TopologyCacheFilter filter = new TopologyCacheFilter();
            filter.setSearchMonitoringInformation(false);
            filter.addBaseDNToSearch(baseDN);
            ServerDescriptor source = ServerDescriptor.createStandalone(ctxSource, filter);
            for (ReplicaDescriptor replica : source.getReplicas()) {
                if (!Utils.areDnsEqual(replica.getSuffix().getDN(), baseDN)) continue;
                replicationId = replica.getReplicationId();
                break;
            }
        }
        catch (NamingException ne) {
            String hostPort = ConnectionUtils.getHostPort(ctxSource);
            Message msg = this.getMessageForException(ne, hostPort);
            throw new ReplicationCliException(msg, ReplicationCliReturnCode.ERROR_READING_CONFIGURATION, ne);
        }
        if (replicationId == -1) {
            throw new ReplicationCliException(AdminToolMessages.ERR_INITIALIZING_REPLICATIONID_NOT_FOUND.get(ConnectionUtils.getHostPort(ctxSource), baseDN), ReplicationCliReturnCode.REPLICATIONID_NOT_FOUND, null);
        }
        OfflineInstaller installer = new OfflineInstaller();
        installer.setProgressMessageFormatter(this.formatter);
        installer.addProgressUpdateListener(new ProgressUpdateListener(){

            public void progressUpdate(ProgressUpdateEvent ev) {
                Message newLogDetails = ev.getNewLogs();
                if (newLogDetails != null && !newLogDetails.toString().trim().equals("")) {
                    ReplicationCliMain.this.printProgress(newLogDetails);
                    ReplicationCliMain.this.printlnProgress();
                }
            }
        });
        int nTries = 5;
        boolean initDone = false;
        while (!initDone) {
            try {
                installer.initializeSuffix(ctxDestination, replicationId, baseDN, displayProgress, ConnectionUtils.getHostPort(ctxSource));
                initDone = true;
            }
            catch (PeerNotFoundException pnfe) {
                LOG.log(Level.INFO, "Peer could not be found");
                if (nTries == 1) {
                    throw new ReplicationCliException(AdminToolMessages.ERR_REPLICATION_INITIALIZING_TRIES_COMPLETED.get(pnfe.getMessageObject().toString()), ReplicationCliReturnCode.INITIALIZING_TRIES_COMPLETED, pnfe);
                }
                try {
                    Thread.sleep((5 - nTries) * 3000);
                }
                catch (Throwable t) {}
            }
            catch (ApplicationException ae) {
                throw new ReplicationCliException(ae.getMessageObject(), ReplicationCliReturnCode.ERROR_INITIALIZING_BASEDN_GENERIC, ae);
            }
            --nTries;
        }
    }

    private void initializeAllSuffix(String baseDN, InitialLdapContext ctx, boolean displayProgress) throws ReplicationCliException {
        int nTries = 5;
        boolean initDone = false;
        while (!initDone) {
            try {
                this.initializeAllSuffixTry(baseDN, ctx, displayProgress);
                this.postPreExternalInitialization(baseDN, ctx, false, displayProgress, false);
                initDone = true;
            }
            catch (PeerNotFoundException pnfe) {
                LOG.log(Level.INFO, "Peer could not be found");
                if (nTries == 1) {
                    throw new ReplicationCliException(AdminToolMessages.ERR_REPLICATION_INITIALIZING_TRIES_COMPLETED.get(pnfe.getMessageObject().toString()), ReplicationCliReturnCode.INITIALIZING_TRIES_COMPLETED, pnfe);
                }
                try {
                    Thread.sleep((5 - nTries) * 3000);
                }
                catch (Throwable t) {}
            }
            catch (ApplicationException ae) {
                throw new ReplicationCliException(ae.getMessageObject(), ReplicationCliReturnCode.ERROR_INITIALIZING_BASEDN_GENERIC, ae);
            }
            --nTries;
        }
    }

    private void preExternalInitialization(String baseDN, InitialLdapContext ctx, boolean localOnly, boolean displayProgress) throws ReplicationCliException {
        this.postPreExternalInitialization(baseDN, ctx, localOnly, displayProgress, true);
    }

    private void postExternalInitialization(String baseDN, InitialLdapContext ctx, boolean displayProgress) throws ReplicationCliException {
        this.postPreExternalInitialization(baseDN, ctx, false, displayProgress, false);
    }

    private void postPreExternalInitialization(String baseDN, InitialLdapContext ctx, boolean localOnly, boolean displayProgress, boolean isPre) throws ReplicationCliException {
        boolean taskCreated = false;
        int i = 1;
        boolean isOver = false;
        String dn = null;
        BasicAttributes attrs = new BasicAttributes();
        BasicAttribute oc = new BasicAttribute("objectclass");
        oc.add("top");
        oc.add("ds-task");
        oc.add("ds-task-reset-generation-id");
        attrs.put(oc);
        attrs.put("ds-task-class-name", "org.opends.server.tasks.SetGenerationIdTask");
        if (isPre) {
            if (!localOnly) {
                attrs.put("ds-task-reset-generation-id-new-value", "-1");
            } else {
                try {
                    attrs.put("ds-task-reset-generation-id-new-value", String.valueOf(this.getReplicationDomainId(ctx, baseDN)));
                }
                catch (NamingException ne) {
                    LOG.log(Level.SEVERE, "Error get replication domain id for base DN " + baseDN + " on server " + ConnectionUtils.getHostPort(ctx), ne);
                    throw new ReplicationCliException(Utils.getThrowableMsg(AdminToolMessages.ERR_LAUNCHING_PRE_EXTERNAL_INITIALIZATION.get(), ne), ReplicationCliReturnCode.ERROR_LAUNCHING_PRE_EXTERNAL_INITIALIZATION, ne);
                }
            }
        }
        attrs.put("ds-task-reset-generation-id-domain-base-dn", baseDN);
        while (!taskCreated) {
            String id = "dsreplication-reset-generation-id-" + i;
            dn = "ds-task-id=" + id + ",cn=Scheduled Tasks,cn=Tasks";
            attrs.put("ds-task-id", id);
            try {
                DirContext dirCtx = ctx.createSubcontext(dn, (Attributes)attrs);
                taskCreated = true;
                LOG.log(Level.INFO, "created task entry: " + attrs);
                dirCtx.close();
            }
            catch (NameAlreadyBoundException x) {
            }
            catch (NamingException ne) {
                LOG.log(Level.SEVERE, "Error creating task " + attrs, ne);
                Message msg = isPre ? AdminToolMessages.ERR_LAUNCHING_PRE_EXTERNAL_INITIALIZATION.get() : AdminToolMessages.ERR_LAUNCHING_POST_EXTERNAL_INITIALIZATION.get();
                ReplicationCliReturnCode code = isPre ? ReplicationCliReturnCode.ERROR_LAUNCHING_PRE_EXTERNAL_INITIALIZATION : ReplicationCliReturnCode.ERROR_LAUNCHING_POST_EXTERNAL_INITIALIZATION;
                throw new ReplicationCliException(Utils.getThrowableMsg(msg, ne), code, ne);
            }
            ++i;
        }
        SearchControls searchControls = new SearchControls();
        searchControls.setCountLimit(1L);
        searchControls.setSearchScope(0);
        String filter = "objectclass=*";
        searchControls.setReturningAttributes(new String[]{"ds-task-log-message", "ds-task-state"});
        String lastLogMsg = null;
        while (!isOver) {
            try {
                Thread.sleep(500L);
            }
            catch (Throwable t) {
                // empty catch block
            }
            try {
                Message errorMsg;
                String state;
                InstallerHelper helper;
                NamingEnumeration<SearchResult> res = ctx.search(dn, filter, searchControls);
                SearchResult sr = res.next();
                String logMsg = Utils.getFirstValue(sr, "ds-task-log-message");
                if (logMsg != null && !logMsg.equals(lastLogMsg)) {
                    LOG.log(Level.INFO, logMsg);
                    lastLogMsg = logMsg;
                }
                if (!(helper = new InstallerHelper()).isDone(state = Utils.getFirstValue(sr, "ds-task-state")) && !helper.isStoppedByError(state)) continue;
                isOver = true;
                String server = ConnectionUtils.getHostPort(ctx);
                if (lastLogMsg == null) {
                    errorMsg = isPre ? AdminToolMessages.INFO_ERROR_DURING_PRE_EXTERNAL_INITIALIZATION_NO_LOG.get(state, server) : AdminToolMessages.INFO_ERROR_DURING_POST_EXTERNAL_INITIALIZATION_NO_LOG.get(state, server);
                } else {
                    Message message = errorMsg = isPre ? AdminToolMessages.INFO_ERROR_DURING_PRE_EXTERNAL_INITIALIZATION_LOG.get(lastLogMsg, state, server) : AdminToolMessages.INFO_ERROR_DURING_POST_EXTERNAL_INITIALIZATION_LOG.get(lastLogMsg, state, server);
                }
                if (helper.isCompletedWithErrors(state)) {
                    LOG.log(Level.WARNING, "Completed with error: " + errorMsg);
                    this.println(errorMsg);
                    continue;
                }
                if (helper.isSuccessful(state) && !helper.isStoppedByError(state)) continue;
                LOG.log(Level.WARNING, "Error: " + errorMsg);
                ReplicationCliReturnCode code = isPre ? ReplicationCliReturnCode.ERROR_LAUNCHING_PRE_EXTERNAL_INITIALIZATION : ReplicationCliReturnCode.ERROR_LAUNCHING_POST_EXTERNAL_INITIALIZATION;
                throw new ReplicationCliException(errorMsg, code, null);
            }
            catch (NameNotFoundException x) {
                isOver = true;
            }
            catch (NamingException ne) {
                Message msg = isPre ? AdminToolMessages.ERR_POOLING_PRE_EXTERNAL_INITIALIZATION.get() : AdminToolMessages.ERR_POOLING_POST_EXTERNAL_INITIALIZATION.get();
                throw new ReplicationCliException(Utils.getThrowableMsg(msg, ne), ReplicationCliReturnCode.ERROR_CONNECTING, ne);
            }
        }
    }

    public void initializeAllSuffixTry(String baseDN, InitialLdapContext ctx, boolean displayProgress) throws ApplicationException, PeerNotFoundException {
        boolean taskCreated = false;
        int i = 1;
        boolean isOver = false;
        String dn = null;
        String serverDisplay = ConnectionUtils.getHostPort(ctx);
        BasicAttributes attrs = new BasicAttributes();
        BasicAttribute oc = new BasicAttribute("objectclass");
        oc.add("top");
        oc.add("ds-task");
        oc.add("ds-task-initialize-remote-replica");
        attrs.put(oc);
        attrs.put("ds-task-class-name", "org.opends.server.tasks.InitializeTargetTask");
        attrs.put("ds-task-initialize-domain-dn", baseDN);
        attrs.put("ds-task-initialize-replica-server-id", "all");
        while (!taskCreated) {
            String id = "quicksetup-initialize" + i;
            dn = "ds-task-id=" + id + ",cn=Scheduled Tasks,cn=Tasks";
            attrs.put("ds-task-id", id);
            try {
                DirContext dirCtx = ctx.createSubcontext(dn, (Attributes)attrs);
                taskCreated = true;
                LOG.log(Level.INFO, "created task entry: " + attrs);
                dirCtx.close();
            }
            catch (NameAlreadyBoundException x) {
                LOG.log(Level.WARNING, "A task with dn: " + dn + " already existed.");
            }
            catch (NamingException ne) {
                LOG.log(Level.SEVERE, "Error creating task " + attrs, ne);
                throw new ApplicationException(ReturnCode.APPLICATION_ERROR, Utils.getThrowableMsg(QuickSetupMessages.INFO_ERROR_LAUNCHING_INITIALIZATION.get(serverDisplay), ne), ne);
            }
            ++i;
        }
        SearchControls searchControls = new SearchControls();
        searchControls.setCountLimit(1L);
        searchControls.setSearchScope(0);
        String filter = "objectclass=*";
        searchControls.setReturningAttributes(new String[]{"ds-task-unprocessed-entry-count", "ds-task-processed-entry-count", "ds-task-log-message", "ds-task-state"});
        Message lastDisplayedMsg = null;
        String lastLogMsg = null;
        long lastTimeMsgDisplayed = -1L;
        long lastTimeMsgLogged = -1L;
        int totalEntries = 0;
        while (!isOver) {
            try {
                Thread.sleep(500L);
            }
            catch (Throwable t) {
                // empty catch block
            }
            try {
                String state;
                InstallerHelper helper;
                String logMsg;
                Message msg;
                NamingEnumeration<SearchResult> res = ctx.search(dn, filter, searchControls);
                SearchResult sr = res.next();
                String sProcessed = Utils.getFirstValue(sr, "ds-task-processed-entry-count");
                String sUnprocessed = Utils.getFirstValue(sr, "ds-task-unprocessed-entry-count");
                int processed = -1;
                int unprocessed = -1;
                if (sProcessed != null) {
                    processed = Integer.parseInt(sProcessed);
                }
                if (sUnprocessed != null) {
                    unprocessed = Integer.parseInt(sUnprocessed);
                }
                totalEntries = Math.max(totalEntries, processed + unprocessed);
                if (processed != -1 && unprocessed != -1) {
                    if (processed + unprocessed > 0) {
                        int perc = 100 * processed / (processed + unprocessed);
                        msg = QuickSetupMessages.INFO_INITIALIZE_PROGRESS_WITH_PERCENTAGE.get(sProcessed, String.valueOf(perc));
                    } else {
                        msg = null;
                    }
                } else {
                    msg = processed != -1 ? QuickSetupMessages.INFO_INITIALIZE_PROGRESS_WITH_PROCESSED.get(sProcessed) : (unprocessed != -1 ? QuickSetupMessages.INFO_INITIALIZE_PROGRESS_WITH_UNPROCESSED.get(sUnprocessed) : lastDisplayedMsg);
                }
                if (msg != null) {
                    long minRefreshPeriod;
                    long currentTime = System.currentTimeMillis();
                    if (currentTime - (minRefreshPeriod = totalEntries < 100 ? 0L : (totalEntries < 1000 ? 1000L : (totalEntries < 10000 ? 5000L : 10000L))) > lastTimeMsgLogged) {
                        lastTimeMsgLogged = currentTime;
                        LOG.log(Level.INFO, "Progress msg: " + msg);
                    }
                    if (displayProgress && currentTime - minRefreshPeriod > lastTimeMsgDisplayed && !msg.equals(lastDisplayedMsg)) {
                        this.printProgress(msg);
                        lastDisplayedMsg = msg;
                        this.printlnProgress();
                        lastTimeMsgDisplayed = currentTime;
                    }
                }
                if ((logMsg = Utils.getFirstValue(sr, "ds-task-log-message")) != null && !logMsg.equals(lastLogMsg)) {
                    LOG.log(Level.INFO, logMsg);
                    lastLogMsg = logMsg;
                }
                if (!(helper = new InstallerHelper()).isDone(state = Utils.getFirstValue(sr, "ds-task-state")) && !helper.isStoppedByError(state)) continue;
                isOver = true;
                LOG.log(Level.INFO, "Last task entry: " + sr);
                if (displayProgress && msg != null && !msg.equals(lastDisplayedMsg)) {
                    this.printProgress(msg);
                    lastDisplayedMsg = msg;
                    this.printlnProgress();
                }
                Message errorMsg = lastLogMsg == null ? QuickSetupMessages.INFO_ERROR_DURING_INITIALIZATION_NO_LOG.get(serverDisplay, state, serverDisplay) : QuickSetupMessages.INFO_ERROR_DURING_INITIALIZATION_LOG.get(serverDisplay, lastLogMsg, state, serverDisplay);
                if (helper.isCompletedWithErrors(state)) {
                    LOG.log(Level.WARNING, "Processed errorMsg: " + errorMsg);
                    if (!displayProgress) continue;
                    this.println(errorMsg);
                    continue;
                }
                if (!helper.isSuccessful(state) || helper.isStoppedByError(state)) {
                    LOG.log(Level.WARNING, "Processed errorMsg: " + errorMsg);
                    ApplicationException ae = new ApplicationException(ReturnCode.APPLICATION_ERROR, errorMsg, null);
                    if (lastLogMsg == null || helper.isPeersNotFoundError(lastLogMsg)) {
                        LOG.log(Level.WARNING, "Throwing peer not found error.  Last Log Msg: " + lastLogMsg);
                        throw new PeerNotFoundException(errorMsg);
                    }
                    LOG.log(Level.SEVERE, "Throwing ApplicationException.");
                    throw ae;
                }
                if (displayProgress) {
                    this.printProgress(QuickSetupMessages.INFO_SUFFIX_INITIALIZED_SUCCESSFULLY.get());
                    this.printlnProgress();
                }
                LOG.log(Level.INFO, "Processed msg: " + errorMsg);
                LOG.log(Level.INFO, "Initialization completed successfully.");
            }
            catch (NameNotFoundException x) {
                isOver = true;
                LOG.log(Level.INFO, "Initialization entry not found.");
                if (!displayProgress) continue;
                this.printProgress(QuickSetupMessages.INFO_SUFFIX_INITIALIZED_SUCCESSFULLY.get());
                this.printlnProgress();
            }
            catch (NamingException ne) {
                throw new ApplicationException(ReturnCode.APPLICATION_ERROR, Utils.getThrowableMsg(QuickSetupMessages.INFO_ERROR_POOLING_INITIALIZATION.get(serverDisplay), ne), ne);
            }
        }
    }

    private LinkedHashSet<Message> getErrorMessages(TopologyCache cache) {
        HashSet<TopologyCacheException> exceptions = new HashSet<TopologyCacheException>();
        Set<ServerDescriptor> servers = cache.getServers();
        LinkedHashSet<Message> exceptionMsgs = new LinkedHashSet<Message>();
        for (ServerDescriptor server : servers) {
            TopologyCacheException e = server.getLastException();
            if (e == null) continue;
            exceptions.add(e);
        }
        block5: for (TopologyCacheException e : exceptions) {
            switch (e.getType()) {
                case NOT_GLOBAL_ADMINISTRATOR: {
                    exceptionMsgs.add(QuickSetupMessages.INFO_NOT_GLOBAL_ADMINISTRATOR_PROVIDED.get());
                    continue block5;
                }
                case GENERIC_CREATING_CONNECTION: {
                    if (e.getCause() != null && Utils.isCertificateException(e.getCause())) {
                        exceptionMsgs.add(QuickSetupMessages.INFO_ERROR_READING_CONFIG_LDAP_CERTIFICATE_SERVER.get(e.getHostPort(), e.getCause().getMessage()));
                        continue block5;
                    }
                    exceptionMsgs.add(Utils.getMessage(e));
                    continue block5;
                }
            }
            exceptionMsgs.add(Utils.getMessage(e));
        }
        return exceptionMsgs;
    }

    private void removeReferencesInServer(ServerDescriptor server, String replicationServer, String bindDn, String pwd, Collection<String> baseDNs, boolean updateReplicationServers, LinkedHashSet<PreferredConnection> cnx) throws ReplicationCliException {
        TopologyCacheFilter filter = new TopologyCacheFilter();
        filter.setSearchMonitoringInformation(false);
        filter.setSearchBaseDNInformation(false);
        ServerLoader loader = new ServerLoader(server.getAdsProperties(), bindDn, pwd, this.getTrustManager(), cnx, filter);
        InitialLdapContext ctx = null;
        String lastBaseDN = null;
        String hostPort = null;
        try {
            ctx = loader.createContext();
            hostPort = ConnectionUtils.getHostPort(ctx);
            ManagementContext mCtx = LDAPManagementContext.createFromContext(JNDIDirContextAdaptor.adapt(ctx));
            RootCfgClient root = mCtx.getRootConfiguration();
            ReplicationSynchronizationProviderCfgClient sync = null;
            try {
                sync = (ReplicationSynchronizationProviderCfgClient)root.getSynchronizationProvider("Multimaster Synchronization");
            }
            catch (ManagedObjectNotFoundException monfe) {
                LOG.log(Level.INFO, "No synchronization found on " + hostPort + ".", monfe);
            }
            if (sync != null) {
                ReplicationServerCfgClient rServerObj;
                SortedSet<String> replServers;
                String[] domainNames = sync.listReplicationDomains();
                if (domainNames != null) {
                    for (int i = 0; i < domainNames.length; ++i) {
                        ReplicationDomainCfgClient domain = sync.getReplicationDomain(domainNames[i]);
                        Iterator<String> i$ = baseDNs.iterator();
                        while (i$.hasNext()) {
                            String baseDN;
                            lastBaseDN = baseDN = i$.next();
                            if (!Utils.areDnsEqual(domain.getBaseDN().toString(), baseDN)) continue;
                            this.printProgress(this.formatter.getFormattedWithPoints(AdminToolMessages.INFO_REPLICATION_REMOVING_REFERENCES_ON_REMOTE.get(baseDN, hostPort)));
                            SortedSet<String> replServers2 = domain.getReplicationServer();
                            if (replServers2 != null) {
                                String replServer = null;
                                for (String o : replServers2) {
                                    if (!replicationServer.equalsIgnoreCase(o)) continue;
                                    replServer = o;
                                    break;
                                }
                                if (replServer != null) {
                                    LOG.log(Level.INFO, "Updating references in domain " + domain.getBaseDN() + " on " + hostPort + ".");
                                    replServers2.remove(replServer);
                                    if (replServers2.size() > 0) {
                                        domain.setReplicationServer(replServers2);
                                        domain.commit();
                                    } else {
                                        sync.removeReplicationDomain(domainNames[i]);
                                        sync.commit();
                                    }
                                }
                            }
                            this.printProgress(this.formatter.getFormattedDone());
                            this.printlnProgress();
                        }
                    }
                }
                if (updateReplicationServers && sync.hasReplicationServer() && (replServers = (rServerObj = sync.getReplicationServer()).getReplicationServer()) != null) {
                    String replServer = null;
                    for (String o : replServers) {
                        if (!replicationServer.equalsIgnoreCase(o)) continue;
                        replServer = o;
                        break;
                    }
                    if (replServer != null) {
                        replServers.remove(replServer);
                        if (replServers.size() > 0) {
                            rServerObj.setReplicationServer(replServers);
                            rServerObj.commit();
                        } else {
                            sync.removeReplicationServer();
                            sync.commit();
                        }
                    }
                }
            }
        }
        catch (NamingException ne) {
            hostPort = this.getHostPort(server, cnx);
            Message msg = this.getMessageForException(ne, hostPort);
            throw new ReplicationCliException(msg, ReplicationCliReturnCode.ERROR_CONNECTING, ne);
        }
        catch (OpenDsException ode) {
            if (lastBaseDN != null) {
                Message msg = this.getMessageForDisableException(ode, hostPort, lastBaseDN);
                throw new ReplicationCliException(msg, ReplicationCliReturnCode.ERROR_DISABLING_REPLICATION_REMOVE_REFERENCE_ON_BASEDN, ode);
            }
            Message msg = AdminToolMessages.ERR_REPLICATION_ERROR_READING_CONFIGURATION.get(hostPort, ode.getMessage());
            throw new ReplicationCliException(msg, ReplicationCliReturnCode.ERROR_CONNECTING, ode);
        }
        finally {
            if (ctx != null) {
                try {
                    ctx.close();
                }
                catch (Throwable t) {}
            }
        }
    }

    private void deleteReplicationDomain(InitialLdapContext ctx, String baseDN) throws ReplicationCliException {
        String hostPort = ConnectionUtils.getHostPort(ctx);
        try {
            String[] domainNames;
            ManagementContext mCtx = LDAPManagementContext.createFromContext(JNDIDirContextAdaptor.adapt(ctx));
            RootCfgClient root = mCtx.getRootConfiguration();
            ReplicationSynchronizationProviderCfgClient sync = null;
            try {
                sync = (ReplicationSynchronizationProviderCfgClient)root.getSynchronizationProvider("Multimaster Synchronization");
            }
            catch (ManagedObjectNotFoundException monfe) {
                LOG.log(Level.INFO, "No synchronization found on " + hostPort + ".", monfe);
            }
            if (sync != null && (domainNames = sync.listReplicationDomains()) != null) {
                for (int i = 0; i < domainNames.length; ++i) {
                    ReplicationDomainCfgClient domain = sync.getReplicationDomain(domainNames[i]);
                    if (!Utils.areDnsEqual(domain.getBaseDN().toString(), baseDN)) continue;
                    this.printProgress(this.formatter.getFormattedWithPoints(AdminToolMessages.INFO_REPLICATION_DISABLING_BASEDN.get(baseDN, hostPort)));
                    sync.removeReplicationDomain(domainNames[i]);
                    sync.commit();
                    this.printProgress(this.formatter.getFormattedDone());
                    this.printlnProgress();
                }
            }
        }
        catch (OpenDsException ode) {
            Message msg = this.getMessageForDisableException(ode, hostPort, baseDN);
            throw new ReplicationCliException(msg, ReplicationCliReturnCode.ERROR_DISABLING_REPLICATION_REMOVE_REFERENCE_ON_BASEDN, ode);
        }
    }

    private void disableReplicationServer(InitialLdapContext ctx) throws ReplicationCliException {
        String hostPort = ConnectionUtils.getHostPort(ctx);
        try {
            ManagementContext mCtx = LDAPManagementContext.createFromContext(JNDIDirContextAdaptor.adapt(ctx));
            RootCfgClient root = mCtx.getRootConfiguration();
            ReplicationSynchronizationProviderCfgClient sync = null;
            ReplicationServerCfgClient replicationServer = null;
            try {
                sync = (ReplicationSynchronizationProviderCfgClient)root.getSynchronizationProvider("Multimaster Synchronization");
                if (sync.hasReplicationServer()) {
                    replicationServer = sync.getReplicationServer();
                }
            }
            catch (ManagedObjectNotFoundException monfe) {
                LOG.log(Level.INFO, "No synchronization found on " + hostPort + ".", monfe);
            }
            if (replicationServer != null) {
                String s = String.valueOf(replicationServer.getReplicationPort());
                this.printProgress(this.formatter.getFormattedWithPoints(AdminToolMessages.INFO_REPLICATION_DISABLING_REPLICATION_SERVER.get(s, hostPort)));
                sync.removeReplicationServer();
                sync.commit();
                this.printProgress(this.formatter.getFormattedDone());
                this.printlnProgress();
            }
        }
        catch (OpenDsException ode) {
            throw new ReplicationCliException(AdminToolMessages.ERR_REPLICATION_DISABLING_REPLICATIONSERVER.get(hostPort), ReplicationCliReturnCode.ERROR_DISABLING_REPLICATION_SERVER, ode);
        }
    }

    private Message getMessageForException(NamingException ne, String hostPort) {
        Message msg = Utils.isCertificateException(ne) ? QuickSetupMessages.INFO_ERROR_READING_CONFIG_LDAP_CERTIFICATE_SERVER.get(hostPort, ne.toString(true)) : QuickSetupMessages.INFO_CANNOT_CONNECT_TO_REMOTE_GENERIC.get(hostPort, ne.toString(true));
        return msg;
    }

    private Message getMessageForReplicationServerException(OpenDsException ode, String hostPort) {
        return AdminToolMessages.ERR_REPLICATION_CONFIGURING_REPLICATIONSERVER.get(hostPort);
    }

    private Message getMessageForEnableException(OpenDsException ode, String hostPort, String baseDN) {
        return AdminToolMessages.ERR_REPLICATION_CONFIGURING_BASEDN.get(baseDN, hostPort);
    }

    private Message getMessageForDisableException(OpenDsException ode, String hostPort, String baseDN) {
        return AdminToolMessages.ERR_REPLICATION_CONFIGURING_BASEDN.get(baseDN, hostPort);
    }

    private Message getCannotBindToPortError(int port) {
        Message message = SetupUtils.isPriviledgedPort(port) ? ToolMessages.ERR_INSTALLDS_CANNOT_BIND_TO_PRIVILEGED_PORT.get(port) : ToolMessages.ERR_INSTALLDS_CANNOT_BIND_TO_PORT.get(port);
        return message;
    }

    private boolean areReplicationServersEqual(Set<String> s1, Set<String> s2) {
        HashSet<String> c1 = new HashSet<String>();
        for (String s : s1) {
            c1.add(s.toLowerCase());
        }
        HashSet<String> c2 = new HashSet<String>();
        for (String s : s2) {
            c2.add(s.toLowerCase());
        }
        return ((Object)c1).equals(c2);
    }

    private Set<String> mergeReplicationServers(Set<String> s1, Set<String> s2) {
        HashSet<String> c1 = new HashSet<String>();
        for (String s : s1) {
            c1.add(s.toLowerCase());
        }
        for (String s : s2) {
            c1.add(s.toLowerCase());
        }
        return c1;
    }

    private Message getCriticalExceptionMessage(ReplicationCliException rce) {
        Throwable c;
        MessageBuilder mb = new MessageBuilder();
        mb.append(rce.getMessageObject());
        File logFile = QuickSetupLog.getLogFile();
        if (logFile != null) {
            mb.append(Constants.LINE_SEPARATOR);
            mb.append(QuickSetupMessages.INFO_GENERAL_SEE_FOR_DETAILS.get(logFile.getPath()));
        }
        if ((c = rce.getCause()) != null) {
            String s = c instanceof NamingException ? ((NamingException)c).toString(true) : c.toString();
            if (mb.toString().indexOf(s) == -1) {
                mb.append(Constants.LINE_SEPARATOR);
                mb.append(AdminToolMessages.INFO_REPLICATION_CRITICAL_ERROR_DETAILS.get(s));
            }
        }
        return mb.toMessage();
    }

    private boolean isLocalHost(String host) {
        boolean isLocalHost = false;
        if (!"localhost".equalsIgnoreCase(host)) {
            try {
                InetAddress localAddress = InetAddress.getLocalHost();
                InetAddress[] addresses = InetAddress.getAllByName(host);
                for (int i = 0; i < addresses.length && !isLocalHost; ++i) {
                    isLocalHost = localAddress.equals(addresses[i]);
                }
            }
            catch (Throwable t) {
                LOG.log(Level.WARNING, "Failing checking host names: " + t, t);
            }
        } else {
            isLocalHost = true;
        }
        return isLocalHost;
    }

    private boolean mustInitializeSchema(ServerDescriptor server1, ServerDescriptor server2) {
        boolean mustInitializeSchema = false;
        if (!this.argParser.noSchemaReplication()) {
            String id1 = server1.getSchemaReplicationID();
            String id2 = server2.getSchemaReplicationID();
            mustInitializeSchema = id1 != null ? id1.equals(id2) : true;
        }
        return mustInitializeSchema;
    }

    private void registerServer(ADSContext adsContext, Map<ADSContext.ServerProperty, Object> serverProperties) throws ADSContextException {
        try {
            adsContext.registerServer(serverProperties);
        }
        catch (ADSContextException ade) {
            if (ade.getError() == ADSContextException.ErrorType.ALREADY_REGISTERED) {
                LOG.log(Level.WARNING, "The server was already registered: " + serverProperties);
                adsContext.unregisterServer(serverProperties);
                adsContext.registerServer(serverProperties);
            }
            throw ade;
        }
    }

    @Override
    public boolean isAdvancedMode() {
        return false;
    }

    @Override
    public boolean isInteractive() {
        if (this.forceNonInteractive) {
            return false;
        }
        return this.argParser.isInteractive();
    }

    @Override
    public boolean isMenuDrivenMode() {
        return true;
    }

    @Override
    public boolean isQuiet() {
        return this.argParser.isQuiet();
    }

    @Override
    public boolean isScriptFriendly() {
        return this.argParser.isScriptFriendly();
    }

    @Override
    public boolean isVerbose() {
        return true;
    }

    private int askPort(Message prompt, int defaultValue) {
        int port = -1;
        while (port == -1) {
            try {
                port = this.readPort(prompt, defaultValue);
            }
            catch (CLIException ce) {
                port = -1;
                LOG.log(Level.WARNING, "Error reading input: " + ce, ce);
            }
        }
        return port;
    }

    private String askForAdministratorUID(String defaultValue) {
        String s = defaultValue;
        try {
            s = this.readInput(AdminToolMessages.INFO_ADMINISTRATOR_UID_PROMPT.get(), defaultValue);
        }
        catch (CLIException ce) {
            LOG.log(Level.WARNING, "Error reading input: " + ce, ce);
        }
        return s;
    }

    private String askForAdministratorPwd() {
        String pwd = this.readPassword(AdminToolMessages.INFO_ADMINISTRATOR_PWD_PROMPT.get(), LOG);
        return pwd;
    }

    private void printProgressMessageNoWrap(Message msg) {
        if (!this.isQuiet()) {
            this.getOutputStream().print(msg.toString());
        }
    }

    private void resetConnectionArguments() {
        this.argParser.getSecureArgsList().hostNameArg.clearValues();
        this.argParser.getSecureArgsList().hostNameArg.setPresent(false);
        this.argParser.getSecureArgsList().portArg.clearValues();
        this.argParser.getSecureArgsList().portArg.setPresent(false);
        this.argParser.getSecureArgsList().portArg.addValue(this.argParser.getSecureArgsList().portArg.getDefaultValue());
        this.argParser.getSecureArgsList().bindDnArg.clearValues();
        this.argParser.getSecureArgsList().bindDnArg.setPresent(false);
        this.argParser.getSecureArgsList().bindPasswordArg.clearValues();
        this.argParser.getSecureArgsList().bindPasswordArg.setPresent(false);
        this.argParser.getSecureArgsList().bindPasswordFileArg.clearValues();
        this.argParser.getSecureArgsList().bindPasswordFileArg.setPresent(false);
        this.argParser.getSecureArgsList().adminUidArg.clearValues();
        this.argParser.getSecureArgsList().adminUidArg.setPresent(false);
    }

    private void initializeGlobalArguments(String hostName, int port, String adminUid, String bindDn, String bindPwd) {
        this.resetConnectionArguments();
        if (hostName != null) {
            this.argParser.getSecureArgsList().hostNameArg.addValue(hostName);
            this.argParser.getSecureArgsList().hostNameArg.setPresent(true);
        }
        this.argParser.getSecureArgsList().portArg.clearValues();
        if (port != -1) {
            this.argParser.getSecureArgsList().portArg.addValue(String.valueOf(port));
            this.argParser.getSecureArgsList().portArg.setPresent(true);
        } else {
            this.argParser.getSecureArgsList().portArg.addValue(this.argParser.getSecureArgsList().portArg.getDefaultValue());
        }
        this.argParser.getSecureArgsList().useSSLArg.setPresent(this.useSSL);
        this.argParser.getSecureArgsList().useStartTLSArg.setPresent(this.useStartTLS);
        if (adminUid != null) {
            this.argParser.getSecureArgsList().adminUidArg.addValue(adminUid);
            this.argParser.getSecureArgsList().adminUidArg.setPresent(true);
        }
        if (bindDn != null) {
            this.argParser.getSecureArgsList().bindDnArg.addValue(bindDn);
            this.argParser.getSecureArgsList().bindDnArg.setPresent(true);
        }
        if (bindPwd != null) {
            this.argParser.getSecureArgsList().bindPasswordArg.addValue(bindPwd);
            this.argParser.getSecureArgsList().bindPasswordArg.setPresent(true);
        }
    }

    private void forceTrustManagerInitialization() {
        this.forceNonInteractive = true;
        try {
            this.ci.initializeTrustManagerIfRequired();
        }
        catch (ArgumentException ae) {
            LOG.log(Level.WARNING, "Error initializing trust store: " + ae, ae);
        }
        this.forceNonInteractive = false;
    }

    private int getReplicationDomainId(InitialLdapContext ctx, String baseDN) throws NamingException {
        int domainId = -1;
        TopologyCacheFilter filter = new TopologyCacheFilter();
        filter.setSearchMonitoringInformation(false);
        filter.addBaseDNToSearch(baseDN);
        ServerDescriptor server = ServerDescriptor.createStandalone(ctx, filter);
        for (ReplicaDescriptor replica : server.getReplicas()) {
            if (!Utils.areDnsEqual(replica.getSuffix().getDN(), baseDN)) continue;
            domainId = replica.getReplicationId();
            break;
        }
        return domainId;
    }

    private boolean areEqual(Set<Map<ADSContext.ServerProperty, Object>> registry1, Set<Map<ADSContext.ServerProperty, Object>> registry2) {
        boolean areEqual;
        boolean bl = areEqual = registry1.size() == registry2.size();
        if (areEqual) {
            HashSet<ADSContext.ServerProperty> propertiesToCompare = new HashSet<ADSContext.ServerProperty>();
            ADSContext.ServerProperty[] properties = ADSContext.ServerProperty.values();
            for (int i = 0; i < properties.length; ++i) {
                if (properties[i].getAttributeSyntax() == ADSContext.ADSPropertySyntax.CERTIFICATE_BINARY) continue;
                propertiesToCompare.add(properties[i]);
            }
            for (Map<ADSContext.ServerProperty, Object> server1 : registry1) {
                boolean found = false;
                for (Map<ADSContext.ServerProperty, Object> server2 : registry2) {
                    found = true;
                    for (ADSContext.ServerProperty prop : propertiesToCompare) {
                        Object v1 = server1.get((Object)prop);
                        Object v2 = server2.get((Object)prop);
                        if (v1 != null) {
                            found = v1.equals(v2);
                        } else if (v2 != null) {
                            found = false;
                        }
                        if (found) continue;
                        break;
                    }
                    if (!found) continue;
                    break;
                }
                if (areEqual = found) continue;
                break;
            }
        }
        return areEqual;
    }

    private boolean disableAllBaseDns(InitialLdapContext ctx, DisableReplicationUserData uData) {
        boolean returnValue = true;
        Collection<ReplicaDescriptor> replicas = this.getReplicas(ctx);
        HashSet<String> replicatedSuffixes = new HashSet<String>();
        for (ReplicaDescriptor rep : replicas) {
            String dn = rep.getSuffix().getDN();
            if (!rep.isReplicated()) continue;
            replicatedSuffixes.add(dn);
        }
        for (String dn1 : replicatedSuffixes) {
            if (Utils.areDnsEqual(ADSContext.getAdministrationSuffixDN(), dn1) || Utils.areDnsEqual("cn=schema", dn1)) continue;
            boolean found = false;
            Iterator i$ = uData.getBaseDNs().iterator();
            if (i$.hasNext()) {
                String dn2 = (String)i$.next();
                found = Utils.areDnsEqual(dn1, dn2);
            }
            if (found) continue;
            returnValue = false;
        }
        return returnValue;
    }

    private LinkedHashSet<PreferredConnection> getPreferredConnections(InitialLdapContext ctx) {
        PreferredConnection cnx = PreferredConnection.getPreferredConnection(ctx);
        LinkedHashSet<PreferredConnection> returnValue = new LinkedHashSet<PreferredConnection>();
        returnValue.add(cnx);
        return returnValue;
    }

    protected String getHostPort(ServerDescriptor server, Collection<PreferredConnection> cnx) {
        String hostPort = null;
        for (PreferredConnection connection : cnx) {
            String url = connection.getLDAPURL();
            if (url.equals(server.getLDAPURL())) {
                hostPort = server.getHostPort(false);
                continue;
            }
            if (!url.equals(server.getLDAPsURL())) continue;
            hostPort = server.getHostPort(true);
        }
        if (hostPort == null) {
            hostPort = server.getHostPort(true);
        }
        return hostPort;
    }

    private SubcommandChoice promptForSubcommand() {
        SubcommandChoice returnValue;
        MenuBuilder<SubcommandChoice> builder = new MenuBuilder<SubcommandChoice>(this);
        builder.setPrompt(AdminToolMessages.INFO_REPLICATION_SUBCOMMAND_PROMPT.get());
        builder.addCancelOption(false);
        for (SubcommandChoice choice : SubcommandChoice.values()) {
            if (choice == SubcommandChoice.CANCEL) continue;
            builder.addNumberedOption(choice.getPrompt(), MenuResult.success(choice), new Message[0]);
        }
        try {
            MenuResult m = builder.toMenu().run();
            returnValue = m.isSuccess() ? (SubcommandChoice)((Object)m.getValue()) : SubcommandChoice.CANCEL;
        }
        catch (CLIException ce) {
            returnValue = SubcommandChoice.CANCEL;
            LOG.log(Level.WARNING, "Error reading input: " + ce, ce);
        }
        return returnValue;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum SuffixRelationType {
        NOT_REPLICATED,
        FULLY_REPLICATED,
        REPLICATED,
        NOT_FULLY_REPLICATED,
        ALL;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum SubcommandChoice {
        ENABLE(AdminToolMessages.INFO_REPLICATION_ENABLE_MENU_PROMPT.get()),
        DISABLE(AdminToolMessages.INFO_REPLICATION_DISABLE_MENU_PROMPT.get()),
        INITIALIZE(AdminToolMessages.INFO_REPLICATION_INITIALIZE_MENU_PROMPT.get()),
        INITIALIZE_ALL(AdminToolMessages.INFO_REPLICATION_INITIALIZE_ALL_MENU_PROMPT.get()),
        PRE_EXTERNAL_INITIALIZATION(AdminToolMessages.INFO_REPLICATION_PRE_EXTERNAL_INITIALIZATION_MENU_PROMPT.get()),
        POST_EXTERNAL_INITIALIZATION(AdminToolMessages.INFO_REPLICATION_POST_EXTERNAL_INITIALIZATION_MENU_PROMPT.get()),
        STATUS(AdminToolMessages.INFO_REPLICATION_STATUS_MENU_PROMPT.get()),
        CANCEL(null);

        private Message prompt;

        private SubcommandChoice(Message prompt) {
            this.prompt = prompt;
        }

        Message getPrompt() {
            return this.prompt;
        }
    }
}

