/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.util.cli;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.net.InetAddress;
import java.net.URI;
import java.net.UnknownHostException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.KeyManager;
import org.opends.admin.ads.ADSContext;
import org.opends.admin.ads.util.ApplicationKeyManager;
import org.opends.admin.ads.util.ApplicationTrustManager;
import org.opends.messages.Message;
import org.opends.messages.QuickSetupMessages;
import org.opends.messages.ToolMessages;
import org.opends.messages.UtilityMessages;
import org.opends.quicksetup.Step;
import org.opends.quicksetup.UserDataCertificateException;
import org.opends.quicksetup.util.Utils;
import org.opends.server.admin.client.cli.SecureConnectionCliArgs;
import org.opends.server.tools.LDAPConnectionOptions;
import org.opends.server.tools.SSLConnectionException;
import org.opends.server.tools.SSLConnectionFactory;
import org.opends.server.tools.dsconfig.ArgumentExceptionFactory;
import org.opends.server.util.SelectableCertificateKeyManager;
import org.opends.server.util.args.ArgumentException;
import org.opends.server.util.cli.CLIException;
import org.opends.server.util.cli.CommandBuilder;
import org.opends.server.util.cli.ConsoleApplication;
import org.opends.server.util.cli.Menu;
import org.opends.server.util.cli.MenuBuilder;
import org.opends.server.util.cli.MenuResult;
import org.opends.server.util.cli.ValidationCallback;

public class LDAPConnectionConsoleInteraction {
    private boolean useSSL;
    private boolean useStartTLS;
    private String hostName;
    private int portNumber;
    private String bindDN;
    private String providedBindDN;
    private String adminUID;
    private String providedAdminUID;
    private String bindPassword;
    private KeyManager keyManager;
    private ApplicationTrustManager trustManager;
    private boolean useAdminOrBindDn = false;
    private boolean displayLdapIfSecureParameters = false;
    private SecureConnectionCliArgs secureArgsList = null;
    private boolean isHeadingDisplayed = false;
    private ConsoleApplication app;
    private boolean trustStoreInMemory = false;
    private boolean trustManagerInitialized;
    private KeyStore truststore;
    private String keystorePath;
    private String keystorePassword;
    private String certifNickname;
    private String truststorePath;
    private String truststorePassword;
    private Message heading = UtilityMessages.INFO_LDAP_CONN_HEADING_CONNECTION_PARAMETERS.get();
    private SecureConnectionCliArgs copySecureArgsList = null;
    private CommandBuilder commandBuilder;

    public LDAPConnectionConsoleInteraction(ConsoleApplication app, SecureConnectionCliArgs secureArgs) {
        this.app = app;
        this.secureArgsList = secureArgs;
        this.commandBuilder = new CommandBuilder(null);
        this.copySecureArgsList = new SecureConnectionCliArgs(secureArgs.alwaysSSL());
        try {
            this.copySecureArgsList.createGlobalArguments();
        }
        catch (Throwable t) {
            throw new RuntimeException("Unexpected error: " + t, t);
        }
    }

    public void run() throws ArgumentException {
        this.run(true, true);
    }

    public void run(boolean canUseSSL, boolean canUseStartTLS) throws ArgumentException {
        block40: {
            boolean connectionTypeIsSet;
            this.commandBuilder.clearArguments();
            this.copySecureArgsList.createGlobalArguments();
            boolean secureConnection = !(!canUseSSL && !canUseStartTLS || !this.secureArgsList.useSSLArg.isPresent() && !this.secureArgsList.useStartTLSArg.isPresent() && !this.secureArgsList.trustAllArg.isPresent() && !this.secureArgsList.trustStorePathArg.isPresent() && !this.secureArgsList.trustStorePasswordArg.isPresent() && !this.secureArgsList.trustStorePasswordFileArg.isPresent() && !this.secureArgsList.keyStorePathArg.isPresent() && !this.secureArgsList.keyStorePasswordArg.isPresent() && !this.secureArgsList.keyStorePasswordFileArg.isPresent());
            final String tmpHostName = this.hostName = this.secureArgsList.hostNameArg.getValue();
            if (this.app.isInteractive() && !this.secureArgsList.hostNameArg.isPresent()) {
                this.checkHeadingDisplayed();
                ValidationCallback<String> callback = new ValidationCallback<String>(){

                    @Override
                    public String validate(ConsoleApplication app, String input) throws CLIException {
                        String ninput = input.trim();
                        if (ninput.length() == 0) {
                            return tmpHostName;
                        }
                        try {
                            InetAddress.getByName(ninput);
                            return ninput;
                        }
                        catch (UnknownHostException e) {
                            app.println();
                            app.println(UtilityMessages.ERR_LDAP_CONN_BAD_HOST_NAME.get(ninput));
                            app.println();
                            return null;
                        }
                    }
                };
                try {
                    this.app.println();
                    this.hostName = this.app.readValidatedInput(UtilityMessages.INFO_LDAP_CONN_PROMPT_HOST_NAME.get(this.hostName), callback);
                }
                catch (CLIException e) {
                    throw ArgumentExceptionFactory.unableToReadConnectionParameters(e);
                }
            }
            this.copySecureArgsList.hostNameArg.clearValues();
            this.copySecureArgsList.hostNameArg.addValue(this.hostName);
            this.commandBuilder.addArgument(this.copySecureArgsList.hostNameArg);
            this.useSSL = this.secureArgsList.useSSL();
            this.useStartTLS = this.secureArgsList.useStartTLS();
            boolean bl = connectionTypeIsSet = this.secureArgsList.useSSLArg.isPresent() || this.secureArgsList.useStartTLSArg.isPresent() || this.secureArgsList.useSSLArg.isValueSetByProperty() && this.secureArgsList.useStartTLSArg.isValueSetByProperty();
            if (this.app.isInteractive() && !connectionTypeIsSet) {
                this.checkHeadingDisplayed();
                MenuBuilder<Integer> builder = new MenuBuilder<Integer>(this.app);
                builder.setPrompt(UtilityMessages.INFO_LDAP_CONN_PROMPT_SECURITY_USE_SECURE_CTX.get());
                Protocols defaultProtocol = secureConnection ? Protocols.SSL : Protocols.LDAP;
                for (Protocols p : Protocols.values()) {
                    if (secureConnection && p.equals((Object)Protocols.LDAP) && !this.displayLdapIfSecureParameters || !canUseSSL && p.equals((Object)Protocols.SSL) || !canUseStartTLS && p.equals((Object)Protocols.START_TLS)) continue;
                    int i = builder.addNumberedOption(p.getMenuMessage(), MenuResult.success(p.getChoice()), new Message[0]);
                    if (!p.equals((Object)defaultProtocol)) continue;
                    builder.setDefault(UtilityMessages.INFO_LDAP_CONN_PROMPT_SECURITY_PROTOCOL_DEFAULT_CHOICE.get(i), MenuResult.success(p.getChoice()));
                }
                Menu menu = builder.toMenu();
                try {
                    MenuResult result = menu.run();
                    if (result.isSuccess()) {
                        if (((Integer)result.getValue()).equals(Protocols.SSL.getChoice())) {
                            this.useSSL = true;
                        } else if (((Integer)result.getValue()).equals(Protocols.START_TLS.getChoice())) {
                            this.useStartTLS = true;
                        }
                        break block40;
                    }
                    throw new RuntimeException();
                }
                catch (CLIException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        if (this.useSSL) {
            this.commandBuilder.addArgument(this.copySecureArgsList.useSSLArg);
        } else if (this.useStartTLS) {
            this.commandBuilder.addArgument(this.copySecureArgsList.useStartTLSArg);
        }
        if ((this.useSSL || this.useStartTLS) && this.trustManager == null) {
            this.initializeTrustManager();
        }
        this.portNumber = !this.useSSL ? this.secureArgsList.portArg.getIntValue() : (this.secureArgsList.portArg.isPresent() ? this.secureArgsList.portArg.getIntValue() : (this.secureArgsList.alwaysSSL() ? 4444 : 636));
        final int tmpPortNumber = this.portNumber;
        if (this.app.isInteractive() && !this.secureArgsList.portArg.isPresent()) {
            this.checkHeadingDisplayed();
            ValidationCallback<Integer> callback = new ValidationCallback<Integer>(){

                @Override
                public Integer validate(ConsoleApplication app, String input) throws CLIException {
                    String ninput = input.trim();
                    if (ninput.length() == 0) {
                        return tmpPortNumber;
                    }
                    try {
                        int i = Integer.parseInt(ninput);
                        if (i < 1 || i > 65535) {
                            throw new NumberFormatException();
                        }
                        return i;
                    }
                    catch (NumberFormatException e) {
                        app.println();
                        app.println(UtilityMessages.ERR_LDAP_CONN_BAD_PORT_NUMBER.get(ninput));
                        app.println();
                        return null;
                    }
                }
            };
            try {
                this.app.println();
                Message askPortNumber = null;
                askPortNumber = this.secureArgsList.alwaysSSL() ? UtilityMessages.INFO_ADMIN_CONN_PROMPT_PORT_NUMBER.get(this.portNumber) : UtilityMessages.INFO_LDAP_CONN_PROMPT_PORT_NUMBER.get(this.portNumber);
                this.portNumber = this.app.readValidatedInput(askPortNumber, callback);
            }
            catch (CLIException e) {
                throw ArgumentExceptionFactory.unableToReadConnectionParameters(e);
            }
        }
        this.copySecureArgsList.portArg.clearValues();
        this.copySecureArgsList.portArg.addValue(String.valueOf(this.portNumber));
        this.commandBuilder.addArgument(this.copySecureArgsList.portArg);
        this.bindDN = this.secureArgsList.bindDnArg.getValue();
        this.adminUID = this.secureArgsList.adminUidArg.getValue();
        final boolean useAdmin = this.secureArgsList.useAdminUID();
        this.providedAdminUID = useAdmin && this.secureArgsList.adminUidArg.isPresent() ? this.adminUID : null;
        this.providedBindDN = (!useAdmin || this.useAdminOrBindDn) && this.secureArgsList.bindDnArg.isPresent() ? this.bindDN : null;
        boolean argIsPresent = this.providedAdminUID != null || this.providedBindDN != null;
        final String tmpBindDN = this.bindDN;
        final String tmpAdminUID = this.adminUID;
        if (this.keyManager == null) {
            if (this.app.isInteractive() && !argIsPresent) {
                this.checkHeadingDisplayed();
                ValidationCallback<String> callback = new ValidationCallback<String>(){

                    @Override
                    public String validate(ConsoleApplication app, String input) throws CLIException {
                        String ninput = input.trim();
                        if (ninput.length() == 0) {
                            if (useAdmin) {
                                return tmpAdminUID;
                            }
                            return tmpBindDN;
                        }
                        return ninput;
                    }
                };
                try {
                    this.app.println();
                    if (this.useAdminOrBindDn) {
                        String def = this.adminUID != null ? this.adminUID : this.bindDN;
                        String v = this.app.readValidatedInput(UtilityMessages.INFO_LDAP_CONN_GLOBAL_ADMINISTRATOR_OR_BINDDN_PROMPT.get(def), callback);
                        if (Utils.isDn(v)) {
                            this.bindDN = v;
                            this.providedBindDN = v;
                            this.adminUID = null;
                            this.providedAdminUID = null;
                        } else {
                            this.bindDN = null;
                            this.providedBindDN = null;
                            this.adminUID = v;
                            this.providedAdminUID = v;
                        }
                    } else if (useAdmin) {
                        this.providedAdminUID = this.adminUID = this.app.readValidatedInput(UtilityMessages.INFO_LDAP_CONN_PROMPT_ADMINISTRATOR_UID.get(this.adminUID), callback);
                    } else {
                        this.providedBindDN = this.bindDN = this.app.readValidatedInput(UtilityMessages.INFO_LDAP_CONN_PROMPT_BIND_DN.get(this.bindDN), callback);
                    }
                }
                catch (CLIException e) {
                    throw ArgumentExceptionFactory.unableToReadConnectionParameters(e);
                }
            }
            if (useAdmin) {
                this.copySecureArgsList.adminUidArg.clearValues();
                this.copySecureArgsList.adminUidArg.addValue(this.getAdministratorUID());
                this.commandBuilder.addArgument(this.copySecureArgsList.adminUidArg);
            } else {
                this.copySecureArgsList.bindDnArg.clearValues();
                this.copySecureArgsList.bindDnArg.addValue(this.getBindDN());
                this.commandBuilder.addArgument(this.copySecureArgsList.bindDnArg);
            }
        } else {
            this.bindDN = null;
            this.adminUID = null;
        }
        this.bindPassword = this.secureArgsList.bindPasswordArg.getValue();
        if (this.keyManager == null) {
            if (this.secureArgsList.bindPasswordFileArg.isPresent()) {
                this.bindPassword = this.secureArgsList.bindPasswordFileArg.getValue();
                if (this.bindPassword == null) {
                    if (useAdmin) {
                        throw ArgumentExceptionFactory.missingBindPassword(this.adminUID);
                    }
                    throw ArgumentExceptionFactory.missingBindPassword(this.bindDN);
                }
                this.copySecureArgsList.bindPasswordFileArg.clearValues();
                this.copySecureArgsList.bindPasswordFileArg.getNameToValueMap().putAll(this.secureArgsList.bindPasswordFileArg.getNameToValueMap());
                this.commandBuilder.addArgument(this.secureArgsList.bindPasswordFileArg);
            } else if (this.bindPassword == null || this.bindPassword.equals("-")) {
                if (!this.app.isInteractive()) {
                    throw ArgumentExceptionFactory.unableToReadBindPasswordInteractively();
                }
                this.checkHeadingDisplayed();
                try {
                    this.app.println();
                    Message prompt = this.providedAdminUID != null ? ToolMessages.INFO_LDAPAUTH_PASSWORD_PROMPT.get(this.providedAdminUID) : (this.providedBindDN != null ? ToolMessages.INFO_LDAPAUTH_PASSWORD_PROMPT.get(this.providedBindDN) : (this.bindDN != null ? ToolMessages.INFO_LDAPAUTH_PASSWORD_PROMPT.get(this.bindDN) : ToolMessages.INFO_LDAPAUTH_PASSWORD_PROMPT.get(this.adminUID)));
                    this.bindPassword = this.app.readPassword(prompt);
                }
                catch (Exception e) {
                    throw ArgumentExceptionFactory.unableToReadConnectionParameters(e);
                }
            }
            this.copySecureArgsList.bindPasswordArg.clearValues();
            this.copySecureArgsList.bindPasswordArg.addValue(this.bindPassword);
            this.commandBuilder.addObfuscatedArgument(this.copySecureArgsList.bindPasswordArg);
        }
    }

    private ApplicationTrustManager getTrustManagerInternal() throws ArgumentException {
        boolean askForTrustStore;
        block28: {
            this.commandBuilder.removeArgument(this.copySecureArgsList.trustAllArg);
            this.commandBuilder.removeArgument(this.copySecureArgsList.trustStorePathArg);
            this.commandBuilder.removeArgument(this.copySecureArgsList.trustStorePasswordArg);
            this.commandBuilder.removeArgument(this.copySecureArgsList.trustStorePasswordFileArg);
            if (this.secureArgsList.trustAllArg.isPresent()) {
                this.commandBuilder.addArgument(this.copySecureArgsList.trustAllArg);
                return null;
            }
            boolean weDontKnowTheTrustMethod = !this.secureArgsList.trustAllArg.isPresent() && !this.secureArgsList.trustStorePathArg.isPresent() && !this.secureArgsList.trustStorePasswordArg.isPresent() && !this.secureArgsList.trustStorePasswordFileArg.isPresent();
            askForTrustStore = false;
            if (this.app.isInteractive() && weDontKnowTheTrustMethod) {
                this.checkHeadingDisplayed();
                this.app.println();
                MenuBuilder<Integer> builder = new MenuBuilder<Integer>(this.app);
                builder.setPrompt(UtilityMessages.INFO_LDAP_CONN_PROMPT_SECURITY_TRUST_METHOD.get());
                TrustMethod defaultTrustMethod = TrustMethod.DISPLAY_CERTIFICATE;
                for (TrustMethod t : TrustMethod.values()) {
                    int i = builder.addNumberedOption(t.getMenuMessage(), MenuResult.success(t.getChoice()), new Message[0]);
                    if (!t.equals((Object)defaultTrustMethod)) continue;
                    builder.setDefault(UtilityMessages.INFO_LDAP_CONN_PROMPT_SECURITY_PROTOCOL_DEFAULT_CHOICE.get(new Integer(i)), MenuResult.success(t.getChoice()));
                }
                Menu menu = builder.toMenu();
                this.trustStoreInMemory = false;
                try {
                    MenuResult result = menu.run();
                    if (result.isSuccess()) {
                        if (((Integer)result.getValue()).equals(TrustMethod.TRUSTALL.getChoice())) {
                            this.commandBuilder.addArgument(this.copySecureArgsList.trustAllArg);
                            return null;
                        }
                        if (((Integer)result.getValue()).equals(TrustMethod.TRUSTSTORE.getChoice())) {
                            askForTrustStore = true;
                            break block28;
                        }
                        if (((Integer)result.getValue()).equals(TrustMethod.DISPLAY_CERTIFICATE.getChoice())) {
                            askForTrustStore = false;
                            this.trustStoreInMemory = true;
                            this.commandBuilder.addArgument(this.copySecureArgsList.trustAllArg);
                            break block28;
                        }
                        throw new RuntimeException();
                    }
                    throw new RuntimeException();
                }
                catch (CLIException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        this.truststorePath = this.secureArgsList.trustStorePathArg.getValue();
        if (this.app.isInteractive() && !this.secureArgsList.trustStorePathArg.isPresent() && askForTrustStore) {
            this.checkHeadingDisplayed();
            ValidationCallback<String> callback = new ValidationCallback<String>(){

                @Override
                public String validate(ConsoleApplication app, String input) throws CLIException {
                    String ninput = input.trim();
                    if (ninput.length() == 0) {
                        app.println();
                        app.println(UtilityMessages.ERR_LDAP_CONN_PROMPT_SECURITY_INVALID_FILE_PATH.get());
                        app.println();
                        return null;
                    }
                    File f = new File(ninput);
                    if (f.exists() && f.canRead() && !f.isDirectory()) {
                        return ninput;
                    }
                    app.println();
                    app.println(UtilityMessages.ERR_LDAP_CONN_PROMPT_SECURITY_INVALID_FILE_PATH.get());
                    app.println();
                    return null;
                }
            };
            try {
                this.app.println();
                this.truststorePath = this.app.readValidatedInput(UtilityMessages.INFO_LDAP_CONN_PROMPT_SECURITY_TRUSTSTORE_PATH.get(), callback);
            }
            catch (CLIException e) {
                throw ArgumentExceptionFactory.unableToReadConnectionParameters(e);
            }
        }
        if (this.truststorePath != null) {
            this.copySecureArgsList.trustStorePathArg.clearValues();
            this.copySecureArgsList.trustStorePathArg.addValue(this.truststorePath);
            this.commandBuilder.addArgument(this.copySecureArgsList.trustStorePathArg);
        }
        this.truststorePassword = this.secureArgsList.trustStorePasswordArg.getValue();
        if (this.secureArgsList.trustStorePasswordFileArg.isPresent()) {
            this.truststorePassword = this.secureArgsList.trustStorePasswordFileArg.getValue();
        }
        if (this.truststorePassword != null && this.truststorePassword.equals("-")) {
            if (!this.app.isInteractive()) {
                this.truststorePassword = null;
            } else {
                this.checkHeadingDisplayed();
                try {
                    this.app.println();
                    Message prompt = UtilityMessages.INFO_LDAP_CONN_PROMPT_SECURITY_TRUSTSTORE_PASSWORD.get(this.truststorePath);
                    this.truststorePassword = this.app.readPassword(prompt);
                }
                catch (Exception e) {
                    throw ArgumentExceptionFactory.unableToReadConnectionParameters(e);
                }
            }
        }
        try {
            this.truststore = KeyStore.getInstance(KeyStore.getDefaultType());
            if (this.truststorePath != null) {
                FileInputStream fos = new FileInputStream(this.truststorePath);
                if (this.truststorePassword != null) {
                    this.truststore.load(fos, this.truststorePassword.toCharArray());
                } else {
                    this.truststore.load(fos, null);
                }
                fos.close();
            } else {
                this.truststore.load(null, null);
            }
            if (this.secureArgsList.trustStorePasswordFileArg.isPresent() && this.truststorePath != null) {
                this.copySecureArgsList.trustStorePasswordFileArg.clearValues();
                this.copySecureArgsList.trustStorePasswordFileArg.getNameToValueMap().putAll(this.secureArgsList.trustStorePasswordFileArg.getNameToValueMap());
                this.commandBuilder.addArgument(this.copySecureArgsList.trustStorePasswordFileArg);
            } else if (this.truststorePassword != null && this.truststorePath != null) {
                this.copySecureArgsList.trustStorePasswordArg.clearValues();
                this.copySecureArgsList.trustStorePasswordArg.addValue(this.truststorePassword);
                this.commandBuilder.addObfuscatedArgument(this.copySecureArgsList.trustStorePasswordArg);
            }
            return new ApplicationTrustManager(this.truststore);
        }
        catch (Exception e) {
            throw ArgumentExceptionFactory.unableToReadConnectionParameters(e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private KeyManager getKeyManagerInternal() throws ArgumentException {
        boolean weDontKnowIfWeNeedKeystore;
        this.commandBuilder.removeArgument(this.copySecureArgsList.certNicknameArg);
        this.commandBuilder.removeArgument(this.copySecureArgsList.keyStorePathArg);
        this.commandBuilder.removeArgument(this.copySecureArgsList.keyStorePasswordArg);
        this.commandBuilder.removeArgument(this.copySecureArgsList.keyStorePasswordFileArg);
        if (!(this.secureArgsList.keyStorePathArg.isPresent() || this.secureArgsList.keyStorePasswordArg.isPresent() || this.secureArgsList.keyStorePasswordFileArg.isPresent() || this.secureArgsList.certNicknameArg.isPresent())) {
            return null;
        }
        boolean bl = weDontKnowIfWeNeedKeystore = false;
        if (weDontKnowIfWeNeedKeystore) {
            return null;
        }
        this.keystorePath = this.secureArgsList.keyStorePathArg.getValue();
        if (this.app.isInteractive() && !this.secureArgsList.keyStorePathArg.isPresent()) {
            this.checkHeadingDisplayed();
            ValidationCallback<String> callback = new ValidationCallback<String>(){

                @Override
                public String validate(ConsoleApplication app, String input) throws CLIException {
                    String ninput = input.trim();
                    if (ninput.length() == 0) {
                        return ninput;
                    }
                    File f = new File(ninput);
                    if (f.exists() && f.canRead() && !f.isDirectory()) {
                        return ninput;
                    }
                    app.println();
                    app.println(UtilityMessages.ERR_LDAP_CONN_PROMPT_SECURITY_INVALID_FILE_PATH.get());
                    app.println();
                    return null;
                }
            };
            try {
                this.app.println();
                this.keystorePath = this.app.readValidatedInput(UtilityMessages.INFO_LDAP_CONN_PROMPT_SECURITY_KEYSTORE_PATH.get(), callback);
            }
            catch (CLIException e) {
                throw ArgumentExceptionFactory.unableToReadConnectionParameters(e);
            }
        }
        if (this.keystorePath != null) {
            this.copySecureArgsList.keyStorePathArg.clearValues();
            this.copySecureArgsList.keyStorePathArg.addValue(this.keystorePath);
            this.commandBuilder.addArgument(this.copySecureArgsList.keyStorePathArg);
        }
        this.keystorePassword = this.secureArgsList.keyStorePasswordArg.getValue();
        if (this.secureArgsList.keyStorePasswordFileArg.isPresent()) {
            this.keystorePassword = this.secureArgsList.keyStorePasswordFileArg.getValue();
            if (this.keystorePassword == null) {
                throw ArgumentExceptionFactory.missingBindPassword(this.keystorePassword);
            }
        } else if (this.keystorePassword == null || this.keystorePassword.equals("-")) {
            if (!this.app.isInteractive()) {
                throw ArgumentExceptionFactory.unableToReadBindPasswordInteractively();
            }
            this.checkHeadingDisplayed();
            try {
                this.app.println();
                Message prompt = UtilityMessages.INFO_LDAP_CONN_PROMPT_SECURITY_KEYSTORE_PASSWORD.get(this.keystorePath);
                this.keystorePassword = this.app.readPassword(prompt);
            }
            catch (Exception e) {
                throw ArgumentExceptionFactory.unableToReadConnectionParameters(e);
            }
        }
        KeyStore keystore = null;
        Enumeration<String> aliasesEnum = null;
        try {
            FileInputStream fos = new FileInputStream(this.keystorePath);
            keystore = KeyStore.getInstance(KeyStore.getDefaultType());
            keystore.load(fos, this.keystorePassword.toCharArray());
            fos.close();
            aliasesEnum = keystore.aliases();
        }
        catch (Exception e) {
            throw ArgumentExceptionFactory.unableToReadConnectionParameters(e);
        }
        this.certifNickname = this.secureArgsList.certNicknameArg.getValue();
        if (this.app.isInteractive() && !this.secureArgsList.certNicknameArg.isPresent() && aliasesEnum.hasMoreElements()) {
            this.checkHeadingDisplayed();
            try {
                MenuBuilder<String> builder = new MenuBuilder<String>(this.app);
                builder.setPrompt(UtilityMessages.INFO_LDAP_CONN_PROMPT_SECURITY_CERTIFICATE_ALIASES.get());
                int certificateNumber = 0;
                while (aliasesEnum.hasMoreElements()) {
                    String alias = aliasesEnum.nextElement();
                    if (!keystore.isKeyEntry(alias)) continue;
                    X509Certificate certif = (X509Certificate)keystore.getCertificate(alias);
                    ++certificateNumber;
                    builder.addNumberedOption(UtilityMessages.INFO_LDAP_CONN_PROMPT_SECURITY_CERTIFICATE_ALIAS.get(alias, certif.getSubjectDN().getName()), MenuResult.success(alias), new Message[0]);
                }
                if (certificateNumber > 1) {
                    this.app.println();
                    Menu menu = builder.toMenu();
                    MenuResult result = menu.run();
                    if (!result.isSuccess()) throw new RuntimeException();
                    this.certifNickname = (String)result.getValue();
                } else {
                    this.certifNickname = null;
                }
            }
            catch (KeyStoreException e) {
                throw ArgumentExceptionFactory.unableToReadConnectionParameters(e);
            }
            catch (CLIException e) {
                throw ArgumentExceptionFactory.unableToReadConnectionParameters(e);
            }
        }
        ApplicationKeyManager akm = new ApplicationKeyManager(keystore, this.keystorePassword.toCharArray());
        if (this.secureArgsList.keyStorePasswordFileArg.isPresent()) {
            this.copySecureArgsList.keyStorePasswordFileArg.clearValues();
            this.copySecureArgsList.keyStorePasswordFileArg.getNameToValueMap().putAll(this.secureArgsList.keyStorePasswordFileArg.getNameToValueMap());
            this.commandBuilder.addArgument(this.copySecureArgsList.keyStorePasswordFileArg);
        } else if (this.keystorePassword != null) {
            this.copySecureArgsList.keyStorePasswordArg.clearValues();
            this.copySecureArgsList.keyStorePasswordArg.addValue(this.keystorePassword);
            this.commandBuilder.addObfuscatedArgument(this.copySecureArgsList.keyStorePasswordArg);
        }
        if (this.certifNickname != null) {
            this.copySecureArgsList.certNicknameArg.clearValues();
            this.copySecureArgsList.certNicknameArg.addValue(this.certifNickname);
        }
        if (this.certifNickname == null) return akm;
        return new SelectableCertificateKeyManager(akm, this.certifNickname);
    }

    public boolean useSSL() {
        return this.useSSL;
    }

    public boolean useStartTLS() {
        return this.useStartTLS;
    }

    public String getHostName() {
        return this.hostName;
    }

    public int getPortNumber() {
        return this.portNumber;
    }

    public void setPortNumber(int portNumber) {
        this.portNumber = portNumber;
    }

    public String getBindDN() {
        String dn = this.useAdminOrBindDn ? (this.providedBindDN != null ? this.providedBindDN : (this.providedAdminUID != null ? ADSContext.getAdministratorDN(this.providedAdminUID) : (this.bindDN != null ? this.bindDN : (this.adminUID != null ? ADSContext.getAdministratorDN(this.adminUID) : null)))) : (this.secureArgsList.useAdminUID() ? ADSContext.getAdministratorDN(this.adminUID) : this.bindDN);
        return dn;
    }

    public String getAdministratorUID() {
        return this.adminUID;
    }

    public String getBindPassword() {
        return this.bindPassword;
    }

    public ApplicationTrustManager getTrustManager() {
        return this.trustManager;
    }

    public KeyStore getKeyStore() {
        return this.truststore;
    }

    public KeyManager getKeyManager() {
        return this.keyManager;
    }

    public boolean isTrustStoreInMemory() {
        return this.trustStoreInMemory;
    }

    public boolean checkServerCertificate(X509Certificate[] chain) {
        return this.checkServerCertificate(chain, null, null);
    }

    public boolean checkServerCertificate(X509Certificate[] chain, String authType, String host) {
        if (this.trustManager == null) {
            try {
                this.initializeTrustManager();
            }
            catch (ArgumentException ae) {
                throw new RuntimeException(ae);
            }
        }
        this.app.println();
        this.app.println(UtilityMessages.INFO_LDAP_CONN_PROMPT_SECURITY_SERVER_CERTIFICATE.get());
        this.app.println();
        for (int i = 0; i < chain.length; ++i) {
            this.app.println(UtilityMessages.INFO_LDAP_CONN_SECURITY_SERVER_CERTIFICATE_USER_DN.get(((Object)chain[i].getSubjectDN()).toString()));
            this.app.println(UtilityMessages.INFO_LDAP_CONN_SECURITY_SERVER_CERTIFICATE_VALIDITY.get(chain[i].getNotBefore().toString(), chain[i].getNotAfter().toString()));
            this.app.println(UtilityMessages.INFO_LDAP_CONN_SECURITY_SERVER_CERTIFICATE_ISSUER.get(((Object)chain[i].getIssuerDN()).toString()));
            if (i + 1 >= chain.length) continue;
            this.app.println();
            this.app.println();
        }
        MenuBuilder<Integer> builder = new MenuBuilder<Integer>(this.app);
        builder.setPrompt(UtilityMessages.INFO_LDAP_CONN_PROMPT_SECURITY_TRUST_OPTION.get());
        TrustOption defaultTrustMethod = TrustOption.SESSION;
        for (TrustOption t : TrustOption.values()) {
            int i = builder.addNumberedOption(t.getMenuMessage(), MenuResult.success(t.getChoice()), new Message[0]);
            if (!t.equals((Object)defaultTrustMethod)) continue;
            builder.setDefault(UtilityMessages.INFO_LDAP_CONN_PROMPT_SECURITY_PROTOCOL_DEFAULT_CHOICE.get(new Integer(i)), MenuResult.success(t.getChoice()));
        }
        this.app.println();
        this.app.println();
        Menu menu = builder.toMenu();
        try {
            MenuResult result;
            while ((result = menu.run()).isSuccess()) {
                int i;
                if (((Integer)result.getValue()).equals(TrustOption.UNTRUSTED.getChoice())) {
                    return false;
                }
                if (((Integer)result.getValue()).equals(TrustOption.CERTIFICATE_DETAILS.getChoice())) {
                    for (i = 0; i < chain.length; ++i) {
                        this.app.println();
                        this.app.println(UtilityMessages.INFO_LDAP_CONN_SECURITY_SERVER_CERTIFICATE.get(chain[i].toString()));
                    }
                    continue;
                }
                for (i = 0; i < chain.length; ++i) {
                    String alias = chain[i].getSubjectDN().getName();
                    try {
                        this.truststore.setCertificateEntry(alias, chain[i]);
                        continue;
                    }
                    catch (KeyStoreException e1) {
                        return false;
                    }
                }
                if (this.trustManager == null) {
                    this.trustManager = new ApplicationTrustManager(this.truststore);
                }
                if (authType != null && host != null) {
                    this.trustManager.acceptCertificate(chain, authType, host);
                } else {
                    this.trustManager = new ApplicationTrustManager(this.truststore);
                }
                if (((Integer)result.getValue()).equals(TrustOption.PERMAMENT.getChoice())) {
                    String truststorePassword;
                    String truststorePath;
                    ValidationCallback<String> callback = new ValidationCallback<String>(){

                        @Override
                        public String validate(ConsoleApplication app, String input) throws CLIException {
                            String ninput = input.trim();
                            if (ninput.length() == 0) {
                                app.println();
                                app.println(UtilityMessages.ERR_LDAP_CONN_PROMPT_SECURITY_INVALID_FILE_PATH.get());
                                app.println();
                                return null;
                            }
                            File f = new File(ninput);
                            if (!f.isDirectory()) {
                                return ninput;
                            }
                            app.println();
                            app.println(UtilityMessages.ERR_LDAP_CONN_PROMPT_SECURITY_INVALID_FILE_PATH.get());
                            app.println();
                            return null;
                        }
                    };
                    try {
                        this.app.println();
                        truststorePath = this.app.readValidatedInput(UtilityMessages.INFO_LDAP_CONN_PROMPT_SECURITY_TRUSTSTORE_PATH.get(), callback);
                    }
                    catch (CLIException e) {
                        return true;
                    }
                    try {
                        this.app.println();
                        Message prompt = UtilityMessages.INFO_LDAP_CONN_PROMPT_SECURITY_KEYSTORE_PASSWORD.get(truststorePath);
                        truststorePassword = this.app.readPassword(prompt);
                    }
                    catch (Exception e) {
                        return true;
                    }
                    try {
                        FileInputStream fis;
                        KeyStore ts = KeyStore.getInstance("JKS");
                        try {
                            fis = new FileInputStream(truststorePath);
                        }
                        catch (FileNotFoundException e) {
                            fis = null;
                        }
                        ts.load(fis, truststorePassword.toCharArray());
                        if (fis != null) {
                            fis.close();
                        }
                        for (int i2 = 0; i2 < chain.length; ++i2) {
                            String alias = chain[i2].getSubjectDN().getName();
                            ts.setCertificateEntry(alias, chain[i2]);
                        }
                        FileOutputStream fos = new FileOutputStream(truststorePath);
                        ts.store(fos, truststorePassword.toCharArray());
                        if (fos != null) {
                            fos.close();
                        }
                    }
                    catch (Exception e) {
                        return true;
                    }
                }
                return true;
            }
            throw new RuntimeException();
        }
        catch (CLIException cliE) {
            throw new RuntimeException(cliE);
        }
    }

    public LDAPConnectionOptions populateLDAPOptions(LDAPConnectionOptions options) throws SSLConnectionException {
        if (options == null) {
            options = new LDAPConnectionOptions();
        }
        if (this.useSSL) {
            options.setUseSSL(true);
            SSLConnectionFactory sslConnectionFactory = new SSLConnectionFactory();
            sslConnectionFactory.init(this.getTrustManager() == null, this.keystorePath, this.keystorePassword, this.certifNickname, this.truststorePath, this.truststorePassword);
            options.setSSLConnectionFactory(sslConnectionFactory);
        } else {
            options.setUseSSL(false);
        }
        options.setStartTLS(this.useStartTLS);
        return options;
    }

    public boolean promptForCertificateConfirmation(Throwable t, ApplicationTrustManager usedTrustManager, String usedUrl, boolean displayErrorMessage, Logger logger) {
        boolean returnValue = false;
        ApplicationTrustManager.Cause cause = usedTrustManager != null ? usedTrustManager.getLastRefusedCause() : null;
        if (logger != null) {
            logger.log(Level.INFO, "Certificate exception cause: " + (Object)((Object)cause));
        }
        UserDataCertificateException.Type excType = null;
        if (cause == ApplicationTrustManager.Cause.NOT_TRUSTED) {
            excType = UserDataCertificateException.Type.NOT_TRUSTED;
        } else if (cause == ApplicationTrustManager.Cause.HOST_NAME_MISMATCH) {
            excType = UserDataCertificateException.Type.HOST_NAME_MISMATCH;
        } else {
            Message msg = Utils.getThrowableMsg(QuickSetupMessages.INFO_ERROR_CONNECTING_TO_LOCAL.get(), t);
            this.app.println(msg);
        }
        if (excType != null) {
            int p;
            String h;
            try {
                URI uri = new URI(usedUrl);
                h = uri.getHost();
                p = uri.getPort();
            }
            catch (Throwable t1) {
                if (logger != null) {
                    logger.log(Level.WARNING, "Error parsing ldap url of ldap url.", t1);
                }
                h = QuickSetupMessages.INFO_NOT_AVAILABLE_LABEL.get().toString();
                p = -1;
            }
            UserDataCertificateException udce = new UserDataCertificateException(Step.REPLICATION_OPTIONS, QuickSetupMessages.INFO_CERTIFICATE_EXCEPTION.get(h, String.valueOf(p)), t, h, p, usedTrustManager.getLastRefusedChain(), usedTrustManager.getLastRefusedAuthType(), excType);
            Message msg = udce.getType() == UserDataCertificateException.Type.NOT_TRUSTED ? QuickSetupMessages.INFO_CERTIFICATE_NOT_TRUSTED_TEXT_CLI.get(udce.getHost(), String.valueOf(udce.getPort())) : QuickSetupMessages.INFO_CERTIFICATE_NAME_MISMATCH_TEXT_CLI.get(udce.getHost(), String.valueOf(udce.getPort()), udce.getHost(), udce.getHost(), String.valueOf(udce.getPort()));
            if (displayErrorMessage) {
                this.app.println(msg);
            }
            X509Certificate[] chain = udce.getChain();
            String authType = udce.getAuthType();
            String host = udce.getHost();
            if (logger != null) {
                if (chain == null) {
                    logger.log(Level.WARNING, "The chain is null for the UserDataCertificateException");
                }
                if (authType == null) {
                    logger.log(Level.WARNING, "The auth type is null for the UserDataCertificateException");
                }
                if (host == null) {
                    logger.log(Level.WARNING, "The host is null for the UserDataCertificateException");
                }
            }
            if (chain != null) {
                returnValue = this.checkServerCertificate(chain, authType, host);
            }
        }
        return returnValue;
    }

    public void setHeadingMessage(Message heading) {
        this.heading = heading;
    }

    public CommandBuilder getCommandBuilder() {
        return this.commandBuilder;
    }

    private void checkHeadingDisplayed() {
        if (!this.isHeadingDisplayed) {
            this.app.println();
            this.app.println();
            this.app.println(this.heading);
            this.isHeadingDisplayed = true;
        }
    }

    public boolean isUseAdminOrBindDn() {
        return this.useAdminOrBindDn;
    }

    public void setUseAdminOrBindDn(boolean useAdminOrBindDn) {
        this.useAdminOrBindDn = useAdminOrBindDn;
    }

    public void setDisplayLdapIfSecureParameters(boolean displayLdapIfSecureParameters) {
        this.displayLdapIfSecureParameters = displayLdapIfSecureParameters;
    }

    public void resetHeadingDisplayed() {
        this.isHeadingDisplayed = false;
    }

    public void initializeTrustManagerIfRequired() throws ArgumentException {
        if (!this.trustManagerInitialized) {
            this.initializeTrustManager();
        }
    }

    private void initializeTrustManager() throws ArgumentException {
        this.trustManager = this.getTrustManagerInternal();
        this.keyManager = this.getKeyManagerInternal();
        this.trustManagerInitialized = true;
    }

    public String getProvidedAdminUID() {
        return this.providedAdminUID;
    }

    public String getProvidedBindDN() {
        return this.providedBindDN;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum TrustOption {
        UNTRUSTED(1, UtilityMessages.INFO_LDAP_CONN_PROMPT_SECURITY_TRUST_OPTION_NO.get()),
        SESSION(2, UtilityMessages.INFO_LDAP_CONN_PROMPT_SECURITY_TRUST_OPTION_SESSION.get()),
        PERMAMENT(3, UtilityMessages.INFO_LDAP_CONN_PROMPT_SECURITY_TRUST_OPTION_ALWAYS.get()),
        CERTIFICATE_DETAILS(4, UtilityMessages.INFO_LDAP_CONN_PROMPT_SECURITY_CERTIFICATE_DETAILS.get());

        private Integer choice;
        private Message msg;

        private TrustOption(int i, Message msg) {
            this.choice = new Integer(i);
            this.msg = msg;
        }

        public Integer getChoice() {
            return this.choice;
        }

        public Message getMenuMessage() {
            return this.msg;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum TrustMethod {
        TRUSTALL(1, UtilityMessages.INFO_LDAP_CONN_PROMPT_SECURITY_USE_TRUST_ALL.get()),
        TRUSTSTORE(2, UtilityMessages.INFO_LDAP_CONN_PROMPT_SECURITY_TRUSTSTORE.get()),
        DISPLAY_CERTIFICATE(3, UtilityMessages.INFO_LDAP_CONN_PROMPT_SECURITY_MANUAL_CHECK.get());

        private Integer choice;
        private Message msg;

        private TrustMethod(int i, Message msg) {
            this.choice = new Integer(i);
            this.msg = msg;
        }

        public Integer getChoice() {
            return this.choice;
        }

        public Message getMenuMessage() {
            return this.msg;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Protocols {
        LDAP(1, UtilityMessages.INFO_LDAP_CONN_PROMPT_SECURITY_LDAP.get()),
        SSL(2, UtilityMessages.INFO_LDAP_CONN_PROMPT_SECURITY_USE_SSL.get()),
        START_TLS(3, UtilityMessages.INFO_LDAP_CONN_PROMPT_SECURITY_USE_START_TLS.get());

        private Integer choice;
        private Message msg;

        private Protocols(int i, Message msg) {
            this.choice = i;
            this.msg = msg;
        }

        public Integer getChoice() {
            return this.choice;
        }

        public Message getMenuMessage() {
            return this.msg;
        }
    }
}

