/*
 * Decompiled with CFR 0.152.
 */
package org.opends.guitools.controlpanel.datamodel;

import java.net.InetAddress;
import java.util.Collection;
import java.util.SortedSet;
import java.util.TreeSet;
import org.opends.messages.AdminToolMessages;
import org.opends.messages.Message;
import org.opends.server.admin.std.meta.AdministrationConnectorCfgDefn;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConnectionHandlerDescriptor {
    private State state;
    private SortedSet<InetAddress> addresses = new TreeSet<InetAddress>(AdministrationConnectorCfgDefn.getInstance().getListenAddressPropertyDefinition());
    private int port;
    private Protocol protocol;
    private String toString;
    private String name;
    private int hashCode;

    public ConnectionHandlerDescriptor(Collection<InetAddress> addresses, int port, Protocol protocol, State state, String name) {
        this.addresses.addAll(addresses);
        this.port = port;
        this.protocol = protocol;
        this.state = state;
        this.name = name;
        StringBuilder builder = new StringBuilder();
        builder.append((Object)((Object)this.getProtocol()) + " " + (Object)((Object)this.getState()) + " ");
        for (InetAddress address : addresses) {
            builder.append(address.toString());
        }
        builder.append(" Port: " + port);
        this.toString = builder.toString();
        this.hashCode = this.toString.hashCode();
    }

    public SortedSet<InetAddress> getAddresses() {
        return this.addresses;
    }

    public Protocol getProtocol() {
        return this.protocol;
    }

    public State getState() {
        return this.state;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String toString() {
        return this.toString;
    }

    public boolean equals(Object o) {
        boolean equals = false;
        if (o == this) {
            equals = true;
        } else if (o instanceof ConnectionHandlerDescriptor) {
            equals = this.toString.equals(o.toString());
        }
        return equals;
    }

    public int getPort() {
        return this.port;
    }

    public String getName() {
        return this.name;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Protocol {
        LDAP(AdminToolMessages.INFO_CTRL_PANEL_CONN_HANDLER_LDAP.get()),
        LDAP_STARTTLS(AdminToolMessages.INFO_CTRL_PANEL_CONN_HANDLER_LDAP_STARTTLS.get()),
        LDAPS(AdminToolMessages.INFO_CTRL_PANEL_CONN_HANDLER_LDAPS.get()),
        JMX(AdminToolMessages.INFO_CTRL_PANEL_CONN_HANDLER_JMX.get()),
        JMXS(AdminToolMessages.INFO_CTRL_PANEL_CONN_HANDLER_JMXS.get()),
        LDIF(AdminToolMessages.INFO_CTRL_PANEL_CONN_HANDLER_LDIF.get()),
        SNMP(AdminToolMessages.INFO_CTRL_PANEL_CONN_HANDLER_SNMP.get()),
        REPLICATION(AdminToolMessages.INFO_CTRL_PANEL_CONN_HANDLER_REPLICATION.get()),
        REPLICATION_SECURE(AdminToolMessages.INFO_CTRL_PANEL_CONN_HANDLER_REPLICATION_SECURE.get()),
        ADMINISTRATION_CONNECTOR(AdminToolMessages.INFO_CTRL_PANEL_CONN_HANDLER_ADMINISTRATION.get()),
        OTHER(AdminToolMessages.INFO_CTRL_PANEL_CONN_HANDLER_OTHER.get());

        private Message displayMessage;

        private Protocol(Message displayMessage) {
            this.displayMessage = displayMessage;
        }

        public Message getDisplayMessage() {
            return this.displayMessage;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum State {
        ENABLED,
        DISABLED,
        UNKNOWN;

    }
}

