/*
 * Decompiled with CFR 0.152.
 */
package org.opends.guitools.controlpanel.datamodel;

import java.io.File;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.opends.guitools.controlpanel.datamodel.BackendDescriptor;
import org.opends.guitools.controlpanel.datamodel.ConnectionHandlerDescriptor;
import org.opends.guitools.controlpanel.util.Utilities;
import org.opends.server.types.AttributeType;
import org.opends.server.types.DN;
import org.opends.server.types.ObjectClass;
import org.opends.server.types.OpenDsException;
import org.opends.server.types.Schema;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServerDescriptor {
    private ServerStatus status;
    private int openConnections;
    private Set<BackendDescriptor> backends = new HashSet<BackendDescriptor>();
    private Set<ConnectionHandlerDescriptor> listeners = new HashSet<ConnectionHandlerDescriptor>();
    private ConnectionHandlerDescriptor adminConnector;
    private Set<DN> administrativeUsers = new HashSet<DN>();
    private File installPath;
    private File instancePath;
    private String openDSVersion;
    private String javaVersion;
    private ArrayList<OpenDsException> exceptions = new ArrayList();
    private boolean isWindowsServiceEnabled;
    private boolean isSchemaEnabled;
    private Schema schema;
    private boolean isAuthenticated;
    private static String hostName = "locahost";

    public Set<DN> getAdministrativeUsers() {
        return this.administrativeUsers;
    }

    public void setAdministrativeUsers(Set<DN> administrativeUsers) {
        this.administrativeUsers = Collections.unmodifiableSet(administrativeUsers);
    }

    public boolean isSchemaEnabled() {
        return this.isSchemaEnabled;
    }

    public void setSchemaEnabled(boolean isSchemaEnabled) {
        this.isSchemaEnabled = isSchemaEnabled;
    }

    public File getInstancePath() {
        return this.instancePath;
    }

    public void setInstancePath(File instancePath) {
        this.instancePath = instancePath;
    }

    public File getInstallPath() {
        return this.installPath;
    }

    public void setInstallPath(File installPath) {
        this.installPath = installPath;
    }

    public String getJavaVersion() {
        return this.javaVersion;
    }

    public void setJavaVersion(String javaVersion) {
        this.javaVersion = javaVersion;
    }

    public int getOpenConnections() {
        return this.openConnections;
    }

    public void setOpenConnections(int openConnections) {
        this.openConnections = openConnections;
    }

    public String getOpenDSVersion() {
        return this.openDSVersion;
    }

    public void setOpenDSVersion(String openDSVersion) {
        this.openDSVersion = openDSVersion;
    }

    public ServerStatus getStatus() {
        return this.status;
    }

    public void setStatus(ServerStatus status) {
        this.status = status;
    }

    public boolean equals(Object o) {
        boolean equals = false;
        if (this != o) {
            if (o instanceof ServerDescriptor) {
                ServerDescriptor desc = (ServerDescriptor)o;
                boolean bl = equals = desc.getStatus() == this.getStatus();
                if (equals) {
                    boolean bl2 = equals = desc.isAuthenticated() == this.isAuthenticated();
                }
                if (equals) {
                    boolean bl3 = equals = desc.getOpenConnections() == this.getOpenConnections();
                }
                if (equals) {
                    equals = desc.getInstallPath().equals(this.getInstallPath());
                }
                if (equals) {
                    equals = desc.getInstancePath().equals(this.getInstancePath());
                }
                if (equals) {
                    equals = desc.getJavaVersion() == null ? this.getJavaVersion() == null : desc.getJavaVersion().equals(this.getJavaVersion());
                }
                if (equals) {
                    equals = desc.getOpenDSVersion().equals(this.getOpenDSVersion());
                }
                if (equals) {
                    equals = ((Object)desc.getAdministrativeUsers()).equals(this.getAdministrativeUsers());
                }
                if (equals) {
                    equals = ((Object)desc.getConnectionHandlers()).equals(this.getConnectionHandlers());
                }
                if (equals) {
                    equals = ((Object)desc.getBackends()).equals(this.getBackends());
                }
                if (equals) {
                    equals = ((Object)desc.getExceptions()).equals(this.getExceptions());
                }
                if (equals) {
                    boolean bl4 = equals = desc.isSchemaEnabled() == this.isSchemaEnabled();
                }
                if (equals) {
                    equals = desc.getSchema() == null ? this.getSchema() != null : (this.getSchema() == null ? false : ServerDescriptor.areSchemasEqual(this.schema, desc.getSchema()));
                }
                if (equals && Utilities.isWindows()) {
                    equals = desc.isWindowsServiceEnabled() == this.isWindowsServiceEnabled();
                }
            }
        } else {
            equals = true;
        }
        return equals;
    }

    public int hashCode() {
        return this.status.hashCode() + this.openConnections + String.valueOf(this.installPath + this.openDSVersion + this.javaVersion + this.isAuthenticated).hashCode();
    }

    public boolean isAuthenticated() {
        return this.isAuthenticated;
    }

    public void setAuthenticated(boolean isAuthenticated) {
        this.isAuthenticated = isAuthenticated;
    }

    public Set<BackendDescriptor> getBackends() {
        return this.backends;
    }

    public void setBackends(Set<BackendDescriptor> backends) {
        this.backends = Collections.unmodifiableSet(backends);
    }

    public Set<ConnectionHandlerDescriptor> getConnectionHandlers() {
        return this.listeners;
    }

    public void setConnectionHandlers(Set<ConnectionHandlerDescriptor> listeners) {
        this.listeners = Collections.unmodifiableSet(listeners);
    }

    public void setSchema(Schema schema) {
        this.schema = schema;
    }

    public Schema getSchema() {
        return this.schema;
    }

    public String getHostname() {
        return hostName;
    }

    public List<OpenDsException> getExceptions() {
        return Collections.unmodifiableList(this.exceptions);
    }

    public void setExceptions(Collection<OpenDsException> exceptions) {
        this.exceptions.clear();
        this.exceptions.addAll(exceptions);
    }

    public boolean isWindowsServiceEnabled() {
        return this.isWindowsServiceEnabled;
    }

    public void setWindowsServiceEnabled(boolean isWindowsServiceEnabled) {
        this.isWindowsServiceEnabled = isWindowsServiceEnabled;
    }

    public static boolean areSchemasEqual(Schema schema1, Schema schema2) {
        boolean areEqual;
        boolean bl = areEqual = schema1 == schema2;
        if (!areEqual && schema1 != null && schema2 != null) {
            areEqual = true;
            ConcurrentHashMap<String, AttributeType> attrs1 = schema1.getAttributeTypes();
            ConcurrentHashMap<String, AttributeType> attrs2 = schema2.getAttributeTypes();
            areEqual = attrs1.size() == attrs2.size();
            for (String name : attrs1.keySet()) {
                if (!areEqual) break;
                AttributeType attr1 = (AttributeType)attrs1.get(name);
                AttributeType attr2 = (AttributeType)attrs2.get(name);
                if (attr2 != null) {
                    areEqual = ServerDescriptor.areAttributesEqual(attr1, attr2);
                    continue;
                }
                areEqual = false;
            }
            if (areEqual) {
                ConcurrentHashMap<String, ObjectClass> ocs1 = schema1.getObjectClasses();
                ConcurrentHashMap<String, ObjectClass> ocs2 = schema2.getObjectClasses();
                areEqual = ocs1.size() == ocs2.size();
                for (String name : ocs1.keySet()) {
                    if (!areEqual) break;
                    ObjectClass oc1 = (ObjectClass)ocs1.get(name);
                    ObjectClass oc2 = (ObjectClass)ocs2.get(name);
                    if (oc2 != null) {
                        areEqual = ServerDescriptor.areObjectClassesEqual(oc1, oc2);
                        continue;
                    }
                    areEqual = false;
                }
            }
            if (areEqual) {
                areEqual = schema1.getMatchingRules().equals(schema2.getMatchingRules());
            }
            if (areEqual) {
                areEqual = schema1.getSyntaxes().equals(schema2.getSyntaxes());
            }
        }
        return areEqual;
    }

    private static final boolean areAttributesEqual(AttributeType attr1, AttributeType attr2) {
        boolean areEqual;
        boolean bl = areEqual = attr1.getOID().equals(attr2.getOID()) && attr1.isCollective() == attr2.isCollective() && attr1.isNoUserModification() == attr2.isNoUserModification() && attr1.isObjectClassType() == attr2.isObjectClassType() && attr1.isObsolete() == attr2.isObsolete() && attr1.isOperational() == attr2.isOperational() && attr1.isSingleValue() == attr2.isSingleValue();
        if (areEqual) {
            Object[] compareWithEqual = new Object[]{attr1.getApproximateMatchingRule(), attr2.getApproximateMatchingRule(), attr1.getDefinitionWithFileName(), attr2.getDefinitionWithFileName(), attr1.getDescription(), attr2.getDescription(), attr1.getEqualityMatchingRule(), attr2.getEqualityMatchingRule(), attr1.getOrderingMatchingRule(), attr2.getOrderingMatchingRule(), attr1.getSubstringMatchingRule(), attr2.getSubstringMatchingRule(), attr1.getSuperiorType(), attr2.getSuperiorType(), attr1.getSyntax(), attr2.getSyntax(), attr1.getSyntaxOID(), attr2.getSyntaxOID()};
            for (int i = 0; i < compareWithEqual.length && areEqual; ++i) {
                areEqual = ServerDescriptor.areEqual(compareWithEqual[i], compareWithEqual[i + 1]);
                ++i;
            }
            if (areEqual) {
                Iterable[] iterables = new Iterable[]{attr1.getExtraPropertyNames(), attr2.getExtraPropertyNames(), attr1.getNormalizedNames(), attr2.getNormalizedNames(), attr1.getUserDefinedNames(), attr2.getUserDefinedNames()};
                for (int i = 0; i < iterables.length && areEqual; ++i) {
                    HashSet set1 = new HashSet();
                    HashSet set2 = new HashSet();
                    for (Object o : iterables[i]) {
                        set1.add(o);
                    }
                    for (Object o : iterables[i + 1]) {
                        set2.add(o);
                    }
                    areEqual = ((Object)set1).equals(set2);
                    ++i;
                }
            }
        }
        return areEqual;
    }

    private static final boolean areObjectClassesEqual(ObjectClass oc1, ObjectClass oc2) {
        int i;
        boolean areEqual;
        boolean bl = areEqual = oc1.getOID().equals(oc2.getOID()) && oc1.isExtensibleObject() == oc2.isExtensibleObject();
        if (areEqual) {
            Object[] compareWithEqual = new Object[]{oc1.getDefinitionWithFileName(), oc2.getDefinitionWithFileName(), oc1.getDescription(), oc2.getDescription(), oc1.getObjectClassType(), oc2.getObjectClassType(), oc1.getOptionalAttributes(), oc2.getOptionalAttributes(), oc1.getRequiredAttributes(), oc2.getRequiredAttributes(), oc1.getSuperiorClass(), oc2.getSuperiorClass()};
            for (i = 0; i < compareWithEqual.length && areEqual; ++i) {
                areEqual = ServerDescriptor.areEqual(compareWithEqual[i], compareWithEqual[i + 1]);
                ++i;
            }
        }
        if (areEqual) {
            Iterable[] iterables = new Iterable[]{oc1.getExtraPropertyNames(), oc2.getExtraPropertyNames(), oc1.getNormalizedNames(), oc2.getNormalizedNames(), oc1.getUserDefinedNames(), oc2.getUserDefinedNames()};
            for (i = 0; i < iterables.length && areEqual; ++i) {
                HashSet set1 = new HashSet();
                HashSet set2 = new HashSet();
                for (Object o : iterables[i]) {
                    set1.add(o);
                }
                for (Object o : iterables[i + 1]) {
                    set2.add(o);
                }
                areEqual = ((Object)set1).equals(set2);
                ++i;
            }
        }
        return areEqual;
    }

    private static boolean areEqual(Object o1, Object o2) {
        boolean areEqual = false;
        areEqual = o1 != null ? (o2 != null ? o1.equals(o2) : false) : o2 == null;
        return areEqual;
    }

    public ConnectionHandlerDescriptor getAdminConnector() {
        return this.adminConnector;
    }

    public void setAdminConnector(ConnectionHandlerDescriptor adminConnector) {
        this.adminConnector = adminConnector;
    }

    static {
        try {
            hostName = InetAddress.getLocalHost().getHostName();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ServerStatus {
        STARTED,
        STOPPED,
        STARTING,
        STOPPING,
        UNKNOWN;

    }
}

