/*
 * Decompiled with CFR 0.152.
 */
package org.opends.guitools.controlpanel.task;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.naming.NamingException;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.DirContext;
import javax.naming.directory.ModificationItem;
import javax.naming.ldap.InitialLdapContext;
import javax.swing.SwingUtilities;
import javax.swing.tree.TreePath;
import org.opends.guitools.controlpanel.browser.BrowserController;
import org.opends.guitools.controlpanel.datamodel.BackendDescriptor;
import org.opends.guitools.controlpanel.datamodel.BaseDNDescriptor;
import org.opends.guitools.controlpanel.datamodel.CannotRenameException;
import org.opends.guitools.controlpanel.datamodel.ControlPanelInfo;
import org.opends.guitools.controlpanel.datamodel.CustomSearchResult;
import org.opends.guitools.controlpanel.task.Task;
import org.opends.guitools.controlpanel.ui.ColorAndFontConstants;
import org.opends.guitools.controlpanel.ui.ProgressDialog;
import org.opends.guitools.controlpanel.ui.ViewEntryPanel;
import org.opends.guitools.controlpanel.ui.nodes.BasicNode;
import org.opends.guitools.controlpanel.util.Utilities;
import org.opends.messages.AdminToolMessages;
import org.opends.messages.Message;
import org.opends.server.types.Attribute;
import org.opends.server.types.AttributeType;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.ByteString;
import org.opends.server.types.ByteStringFactory;
import org.opends.server.types.DN;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.Entry;
import org.opends.server.types.OpenDsException;
import org.opends.server.types.RDN;
import org.opends.server.types.Schema;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModifyEntryTask
extends Task {
    private Set<String> backendSet = new HashSet<String>();
    private boolean mustRename;
    private boolean hasModifications;
    private CustomSearchResult oldEntry;
    private DN oldDn;
    private ArrayList<ModificationItem> modifications;
    private Entry newEntry;
    private BrowserController controller;
    private TreePath treePath;
    private boolean useAdminCtx = false;

    public ModifyEntryTask(ControlPanelInfo info, ProgressDialog dlg, Entry newEntry, CustomSearchResult oldEntry, BrowserController controller, TreePath path) {
        super(info, dlg);
        this.oldEntry = oldEntry;
        this.newEntry = newEntry;
        this.controller = controller;
        this.treePath = path;
        DN newDn = newEntry.getDN();
        try {
            this.oldDn = DN.decode(oldEntry.getDN());
            for (BackendDescriptor backend : info.getServerDescriptor().getBackends()) {
                for (BaseDNDescriptor baseDN : backend.getBaseDns()) {
                    if (!newDn.isDescendantOf(baseDN.getDn()) && !this.oldDn.isDescendantOf(baseDN.getDn())) continue;
                    this.backendSet.add(backend.getBackendID());
                }
            }
            this.mustRename = !newDn.equals(this.oldDn);
        }
        catch (OpenDsException ode) {
            throw new IllegalStateException("Could not parse DN: " + oldEntry.getDN(), ode);
        }
        this.modifications = ModifyEntryTask.getModifications(newEntry, oldEntry, this.getInfo());
        this.hasModifications = this.modifications.size() > 0 || !this.oldDn.equals(newEntry.getDN());
    }

    public boolean hasModifications() {
        return this.hasModifications;
    }

    @Override
    public Task.Type getType() {
        return Task.Type.MODIFY_ENTRY;
    }

    @Override
    public Set<String> getBackends() {
        return this.backendSet;
    }

    @Override
    public Message getTaskDescription() {
        return AdminToolMessages.INFO_CTRL_PANEL_MODIFY_ENTRY_TASK_DESCRIPTION.get(this.oldEntry.getDN());
    }

    @Override
    protected String getCommandLinePath() {
        return null;
    }

    protected ArrayList<String> getCommandLineArguments() {
        return new ArrayList<String>();
    }

    @Override
    public boolean canLaunch(Task taskToBeLaunched, Collection<Message> incompatibilityReasons) {
        boolean canLaunch = true;
        if (!this.isServerRunning() && this.state == Task.State.RUNNING) {
            TreeSet<String> backends = new TreeSet<String>(taskToBeLaunched.getBackends());
            backends.retainAll(this.getBackends());
            if (backends.size() > 0) {
                incompatibilityReasons.add(this.getIncompatibilityMessage(this, taskToBeLaunched));
                canLaunch = false;
            }
        }
        return canLaunch;
    }

    @Override
    public boolean regenerateDescriptor() {
        return false;
    }

    @Override
    public void runTask() {
        this.state = Task.State.RUNNING;
        this.lastException = null;
        try {
            BasicNode node = (BasicNode)this.treePath.getLastPathComponent();
            InitialLdapContext ctx = this.controller.findConnectionForDisplayedEntry(node);
            this.useAdminCtx = this.controller.isConfigurationNode(node);
            if (!this.mustRename) {
                if (this.modifications.size() > 0) {
                    ModificationItem[] mods = new ModificationItem[this.modifications.size()];
                    this.modifications.toArray(mods);
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            ModifyEntryTask.this.printEquivalentCommandToModify(ModifyEntryTask.this.newEntry.getDN(), (Collection<ModificationItem>)ModifyEntryTask.this.modifications, ModifyEntryTask.this.useAdminCtx);
                            ModifyEntryTask.this.getProgressDialog().appendProgressHtml(Utilities.getProgressWithPoints(AdminToolMessages.INFO_CTRL_PANEL_MODIFYING_ENTRY.get(ModifyEntryTask.this.oldEntry.getDN()), ColorAndFontConstants.progressFont));
                        }
                    });
                    ctx.modifyAttributes(Utilities.getJNDIName(this.oldEntry.getDN()), mods);
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            ModifyEntryTask.this.getProgressDialog().appendProgressHtml(Utilities.getProgressDone(ColorAndFontConstants.progressFont));
                            ModifyEntryTask.this.controller.notifyEntryChanged(ModifyEntryTask.this.controller.getNodeInfoFromPath(ModifyEntryTask.this.treePath));
                            ModifyEntryTask.this.controller.getTree().removeSelectionPath(ModifyEntryTask.this.treePath);
                            ModifyEntryTask.this.controller.getTree().setSelectionPath(ModifyEntryTask.this.treePath);
                        }
                    });
                }
            } else {
                this.modifyAndRename(ctx, this.oldDn, this.oldEntry, this.newEntry, this.modifications);
            }
            this.state = Task.State.FINISHED_SUCCESSFULLY;
        }
        catch (Throwable t) {
            this.lastException = t;
            this.state = Task.State.FINISHED_WITH_ERROR;
        }
    }

    private void modifyAndRename(DirContext ctx, final DN oldDN, CustomSearchResult originalEntry, final Entry newEntry, final ArrayList<ModificationItem> originalMods) throws CannotRenameException, NamingException {
        RDN oldRDN = oldDN.getRDN();
        RDN newRDN = newEntry.getDN().getRDN();
        boolean rdnTypeChanged = newRDN.getNumValues() != oldRDN.getNumValues();
        for (int i = 0; i < newRDN.getNumValues() && !rdnTypeChanged; ++i) {
            boolean found = false;
            for (int j = 0; j < oldRDN.getNumValues() && !found; ++j) {
                found = newRDN.getAttributeName(i).equalsIgnoreCase(oldRDN.getAttributeName(j));
            }
            rdnTypeChanged = !found;
        }
        if (rdnTypeChanged) {
            ModificationItem mod;
            javax.naming.directory.Attribute attr;
            boolean changedOc = false;
            Iterator<ModificationItem> i$ = originalMods.iterator();
            while (i$.hasNext() && !(changedOc = (attr = (mod = i$.next()).getAttribute()).getID().equalsIgnoreCase("objectClass"))) {
            }
            if (changedOc) {
                boolean entryContainsRdnTypes = true;
                for (int i = 0; i < newRDN.getNumValues() && entryContainsRdnTypes; ++i) {
                    Set<Object> values = originalEntry.getAttributeValues(newRDN.getAttributeName(i));
                    entryContainsRdnTypes = !values.isEmpty();
                }
                if (!entryContainsRdnTypes) {
                    throw new CannotRenameException(AdminToolMessages.ERR_CANNOT_MODIFY_OBJECTCLASS_AND_RENAME.get());
                }
            }
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ModifyEntryTask.this.printEquivalentRenameCommand(oldDN, newEntry.getDN(), ModifyEntryTask.this.useAdminCtx);
                ModifyEntryTask.this.getProgressDialog().appendProgressHtml(Utilities.getProgressWithPoints(AdminToolMessages.INFO_CTRL_PANEL_RENAMING_ENTRY.get(oldDN.toString(), newEntry.getDN().toString()), ColorAndFontConstants.progressFont));
            }
        });
        ctx.rename(Utilities.getJNDIName(this.oldDn.toString()), Utilities.getJNDIName(newEntry.getDN().toString()));
        final TreePath[] newPath = new TreePath[]{null};
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ModifyEntryTask.this.getProgressDialog().appendProgressHtml(Utilities.getProgressDone(ColorAndFontConstants.progressFont));
                ModifyEntryTask.this.getProgressDialog().appendProgressHtml("<br>");
                TreePath parentPath = ModifyEntryTask.this.controller.notifyEntryDeleted(ModifyEntryTask.this.controller.getNodeInfoFromPath(ModifyEntryTask.this.treePath));
                newPath[0] = ModifyEntryTask.this.controller.notifyEntryAdded(ModifyEntryTask.this.controller.getNodeInfoFromPath(parentPath), newEntry.getDN().toString());
            }
        });
        ModificationItem[] mods = new ModificationItem[originalMods.size()];
        originalMods.toArray(mods);
        if (mods.length > 0) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    DN dn = newEntry.getDN();
                    ModifyEntryTask.this.printEquivalentCommandToModify(dn, (Collection<ModificationItem>)originalMods, ModifyEntryTask.this.useAdminCtx);
                    ModifyEntryTask.this.getProgressDialog().appendProgressHtml(Utilities.getProgressWithPoints(AdminToolMessages.INFO_CTRL_PANEL_MODIFYING_ENTRY.get(dn.toString()), ColorAndFontConstants.progressFont));
                }
            });
            ctx.modifyAttributes(Utilities.getJNDIName(newEntry.getDN().toString()), mods);
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ModifyEntryTask.this.getProgressDialog().appendProgressHtml(Utilities.getProgressDone(ColorAndFontConstants.progressFont));
                    if (newPath[0] != null) {
                        ModifyEntryTask.this.controller.getTree().setSelectionPath(newPath[0]);
                    }
                }
            });
        }
    }

    public static ArrayList<ModificationItem> getModifications(Entry newEntry, CustomSearchResult oldEntry, ControlPanelInfo info) {
        ArrayList<ModificationItem> modifications = new ArrayList<ModificationItem>();
        Schema schema = info.getServerDescriptor().getSchema();
        List<Attribute> newAttrs = newEntry.getAttributes();
        newAttrs.add(newEntry.getObjectClassAttribute());
        for (Attribute attr : newAttrs) {
            String attrName = attr.getNameWithOptions();
            if (!ViewEntryPanel.isEditable(attrName, schema)) continue;
            AttributeType attrType = schema.getAttributeType(attr.getName().toLowerCase());
            LinkedHashSet<AttributeValue> newValues = new LinkedHashSet<AttributeValue>();
            Iterator<AttributeValue> it = attr.iterator();
            while (it.hasNext()) {
                newValues.add(it.next());
            }
            Set<Object> oldValues = oldEntry.getAttributeValues(attrName);
            boolean isAttributeInNewRdn = false;
            AttributeValue rdnValue = null;
            RDN rdn = newEntry.getDN().getRDN();
            for (int i = 0; i < rdn.getNumValues() && !isAttributeInNewRdn; ++i) {
                isAttributeInNewRdn = rdn.getAttributeName(i).equalsIgnoreCase(attrName);
                rdnValue = rdn.getAttributeValue(i);
            }
            AttributeValue oldRdnValueToAdd = null;
            AttributeValue oldRdnValueDeleted = null;
            RDN oldRDN = null;
            try {
                oldRDN = DN.decode(oldEntry.getDN()).getRDN();
            }
            catch (DirectoryException de) {
                throw new IllegalStateException("Unexpected error parsing DN: " + oldEntry.getDN(), de);
            }
            for (int i = 0; i < oldRDN.getNumValues(); ++i) {
                if (!oldRDN.getAttributeName(i).equalsIgnoreCase(attrName)) continue;
                AttributeValue value = oldRDN.getAttributeValue(i);
                boolean containsValue = false;
                it = attr.iterator();
                while (it.hasNext()) {
                    if (!value.equals(it.next())) continue;
                    containsValue = true;
                    break;
                }
                if (containsValue) {
                    if (rdnValue != null && rdnValue.equals(value)) break;
                    oldRdnValueToAdd = value;
                    break;
                }
                oldRdnValueDeleted = value;
                break;
            }
            if (oldValues == null) {
                HashSet<AttributeValue> vs = new HashSet<AttributeValue>();
                vs.addAll(newValues);
                if (rdnValue != null) {
                    vs.remove(rdnValue);
                }
                if (vs.size() <= 0) continue;
                modifications.add(new ModificationItem(1, ModifyEntryTask.createAttribute(attrName, newValues)));
                continue;
            }
            Set<AttributeValue> toDelete = ModifyEntryTask.getValuesToDelete(oldValues, newValues, attrType);
            if (oldRdnValueDeleted != null) {
                toDelete.remove(oldRdnValueDeleted);
            }
            Set<AttributeValue> toAdd = ModifyEntryTask.getValuesToAdd(oldValues, newValues, attrType);
            if (oldRdnValueToAdd != null) {
                toAdd.add(oldRdnValueToAdd);
            }
            if (toDelete.size() + toAdd.size() >= newValues.size() && !isAttributeInNewRdn) {
                modifications.add(new ModificationItem(2, ModifyEntryTask.createAttribute(attrName, newValues)));
                continue;
            }
            if (toDelete.size() > 0) {
                modifications.add(new ModificationItem(3, ModifyEntryTask.createAttribute(attrName, toDelete)));
            }
            if (toAdd.size() <= 0) continue;
            HashSet<AttributeValue> vs = new HashSet<AttributeValue>();
            vs.addAll(toAdd);
            if (rdnValue != null) {
                vs.remove(rdnValue);
            }
            if (vs.size() <= 0) continue;
            modifications.add(new ModificationItem(1, ModifyEntryTask.createAttribute(attrName, vs)));
        }
        for (String attrName : oldEntry.getAttributeNames()) {
            if (!ViewEntryPanel.isEditable(attrName, schema)) continue;
            Set<Object> oldValues = oldEntry.getAttributeValues(attrName);
            String attrNoOptions = Utilities.getAttributeNameWithoutOptions(attrName).toLowerCase();
            List<Attribute> attrs = newEntry.getAttribute(attrNoOptions);
            boolean found = false;
            if (attrs != null) {
                for (Attribute attr : attrs) {
                    if (!attr.getNameWithOptions().equalsIgnoreCase(attrName)) continue;
                    found = true;
                    break;
                }
            }
            if (found || oldValues.size() <= 0) continue;
            modifications.add(new ModificationItem(3, new BasicAttribute(attrName)));
        }
        return modifications;
    }

    private static javax.naming.directory.Attribute createAttribute(String attrName, Set<AttributeValue> values) {
        BasicAttribute attribute = new BasicAttribute(attrName);
        for (AttributeValue value : values) {
            attribute.add(value.getValue().value());
        }
        return attribute;
    }

    private static AttributeValue createAttributeValue(AttributeType attrType, Object value) {
        ByteString v = value instanceof String ? ByteStringFactory.create((String)value) : (value instanceof byte[] ? ByteStringFactory.create((byte[])value) : ByteStringFactory.create(String.valueOf(value)));
        return new AttributeValue(attrType, v);
    }

    private static Set<AttributeValue> getValuesToDelete(Set<Object> oldValues, Set<AttributeValue> newValues, AttributeType attrType) {
        HashSet<AttributeValue> valuesToDelete = new HashSet<AttributeValue>();
        for (Object o : oldValues) {
            AttributeValue oldValue = ModifyEntryTask.createAttributeValue(attrType, o);
            if (newValues.contains(oldValue)) continue;
            valuesToDelete.add(oldValue);
        }
        return valuesToDelete;
    }

    private static Set<AttributeValue> getValuesToAdd(Set<Object> oldValues, Set<AttributeValue> newValues, AttributeType attrType) {
        HashSet<AttributeValue> valuesToAdd = new HashSet<AttributeValue>();
        for (AttributeValue newValue : newValues) {
            Object o;
            boolean found = false;
            Iterator<Object> i$ = oldValues.iterator();
            while (i$.hasNext() && !(found = newValue.equals(ModifyEntryTask.createAttributeValue(attrType, o = i$.next())))) {
            }
            if (found) continue;
            valuesToAdd.add(newValue);
        }
        return valuesToAdd;
    }
}

