/*
 * Decompiled with CFR 0.152.
 */
package org.opends.guitools.controlpanel.ui;

import java.awt.Dimension;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import org.opends.guitools.controlpanel.datamodel.ControlPanelInfo;
import org.opends.guitools.controlpanel.datamodel.ServerDescriptor;
import org.opends.guitools.controlpanel.event.ConfigChangeListener;
import org.opends.guitools.controlpanel.event.ConfigurationChangeEvent;
import org.opends.guitools.controlpanel.ui.ColorAndFontConstants;
import org.opends.guitools.controlpanel.ui.GenericDialog;
import org.opends.guitools.controlpanel.ui.MainActionsPane;
import org.opends.guitools.controlpanel.ui.StatusPanel;
import org.opends.guitools.controlpanel.util.Utilities;

public class ControlCenterMainPane
extends JSplitPane {
    private static final long serialVersionUID = -8939025523701408656L;
    private StatusPanel statusPane;

    public ControlCenterMainPane(ControlPanelInfo info) {
        super(1);
        this.setOpaque(true);
        this.statusPane = new StatusPanel();
        this.statusPane.setBorder(new EmptyBorder(10, 10, 30, 10));
        this.statusPane.setInfo(info);
        MainActionsPane mainActionsPane = new MainActionsPane();
        mainActionsPane.setInfo(info);
        JScrollPane accordionScroll = Utilities.createScrollPane(mainActionsPane);
        accordionScroll.getViewport().setBackground(ColorAndFontConstants.greyBackground);
        JScrollPane statusScroll = Utilities.createScrollPane(this.statusPane);
        this.setLeftComponent(accordionScroll);
        this.setRightComponent(statusScroll);
        this.setResizeWeight(0.0);
        this.setDividerLocation(accordionScroll.getPreferredSize().width + 2);
        this.setPreferredSize(new Dimension(this.getPreferredSize().width + 4, this.getPreferredSize().height));
        info.addConfigChangeListener(new ConfigChangeListener(){
            private boolean lastStatusStopped;

            public void configurationChanged(ConfigurationChangeEvent ev) {
                if (ev.getNewDescriptor().getStatus() != ServerDescriptor.ServerStatus.STARTED) {
                    this.lastStatusStopped = true;
                } else if (this.lastStatusStopped && !ev.getNewDescriptor().isAuthenticated()) {
                    this.lastStatusStopped = false;
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            ControlCenterMainPane.this.getLoginDialog().setVisible(true);
                            ControlCenterMainPane.this.getLoginDialog().toFront();
                        }
                    });
                }
            }
        });
    }

    public GenericDialog getLoginDialog() {
        return this.statusPane.getLoginDialog();
    }
}

