/*
 * Decompiled with CFR 0.152.
 */
package org.opends.guitools.controlpanel.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.util.Collection;
import org.opends.guitools.controlpanel.event.ConfigurationChangeEvent;
import org.opends.guitools.controlpanel.ui.ColorAndFontConstants;
import org.opends.guitools.controlpanel.ui.GenericDialog;
import org.opends.guitools.controlpanel.ui.StatusGenericPanel;
import org.opends.guitools.controlpanel.util.Utilities;
import org.opends.messages.Message;
import org.opends.messages.MessageBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ErrorPanel
extends StatusGenericPanel {
    private static final long serialVersionUID = -4494826284037288552L;
    private Message title;

    public ErrorPanel(Message title, Collection<Message> errors) {
        this.title = title;
        this.createLayout(errors);
    }

    @Override
    public Message getTitle() {
        return this.title;
    }

    private void createLayout(Collection<Message> errors) {
        GridBagConstraints gbc = new GridBagConstraints();
        this.addErrorPane(gbc);
        this.errorPane.setVisible(true);
        MessageBuilder mb = new MessageBuilder();
        for (Message error : errors) {
            if (mb.length() > 0) {
                mb.append("<br>");
            }
            mb.append(error);
        }
        this.updateErrorPane(this.errorPane, this.title, ColorAndFontConstants.errorTitleFont, mb.toMessage(), ColorAndFontConstants.defaultFont);
        gbc.weighty = 0.0;
        this.addBottomGlue(gbc);
    }

    @Override
    public GenericDialog.ButtonType getButtonType() {
        return GenericDialog.ButtonType.OK;
    }

    @Override
    public void configurationChanged(ConfigurationChangeEvent ev) {
    }

    @Override
    public Component getPreferredFocusComponent() {
        return null;
    }

    @Override
    public void okClicked() {
        Utilities.getParentDialog(this).setVisible(false);
    }
}

