/*
 * Decompiled with CFR 0.152.
 */
package org.opends.guitools.controlpanel.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.opends.guitools.controlpanel.browser.BrowserController;
import org.opends.guitools.controlpanel.ui.AbstractNewEntryPanel;
import org.opends.guitools.controlpanel.ui.nodes.BasicNode;
import org.opends.guitools.controlpanel.util.Utilities;
import org.opends.messages.AdminToolMessages;
import org.opends.messages.Message;
import org.opends.server.types.OpenDsException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NewOrganizationalUnitPanel
extends AbstractNewEntryPanel {
    private static final long serialVersionUID = -7145648120019856161L;
    private JLabel lName = Utilities.createPrimaryLabel(AdminToolMessages.INFO_CTRL_PANEL_NEW_OU_NAME_LABEL.get());
    private JLabel lDescription = Utilities.createPrimaryLabel(AdminToolMessages.INFO_CTRL_PANEL_NEW_OU_DESCRIPTION_LABEL.get());
    private JLabel lAddress = Utilities.createPrimaryLabel(AdminToolMessages.INFO_CTRL_PANEL_NEW_OU_ADDRESS_LABEL.get());
    private JLabel lTelephoneNumber = Utilities.createPrimaryLabel(AdminToolMessages.INFO_CTRL_PANEL_NEW_OU_TELEPHONE_NUMBER_LABEL.get());
    private JLabel lFaxNumber = Utilities.createPrimaryLabel(AdminToolMessages.INFO_CTRL_PANEL_NEW_OU_FAX_NUMBER_LABEL.get());
    private JLabel lEntryDN = Utilities.createPrimaryLabel(AdminToolMessages.INFO_CTRL_PANEL_NEW_OU_ENTRY_DN_LABEL.get());
    private JLabel[] labels = new JLabel[]{this.lName, this.lDescription, this.lAddress, this.lTelephoneNumber, this.lFaxNumber, this.lEntryDN};
    private JTextField name = Utilities.createLongTextField();
    private JTextField description = Utilities.createLongTextField();
    private JTextField address = Utilities.createLongTextField();
    private JTextField telephoneNumber = Utilities.createLongTextField();
    private JTextField faxNumber = Utilities.createLongTextField();
    private JLabel dn = Utilities.createDefaultLabel();
    private Component[] comps = new Component[]{this.name, this.description, this.address, this.telephoneNumber, this.faxNumber, this.dn};

    public NewOrganizationalUnitPanel() {
        this.createLayout();
    }

    @Override
    public void setParent(BasicNode parentNode, BrowserController controller) {
        super.setParent(parentNode, controller);
        this.dn.setText("," + parentNode.getDN());
        for (Component comp : this.comps) {
            if (!(comp instanceof JTextField)) continue;
            ((JTextField)comp).setText("");
        }
    }

    @Override
    public Message getTitle() {
        return AdminToolMessages.INFO_CTRL_PANEL_NEW_OU_PANEL_TITLE.get();
    }

    @Override
    public Component getPreferredFocusComponent() {
        return this.name;
    }

    @Override
    protected Message getProgressDialogTitle() {
        return AdminToolMessages.INFO_CTRL_PANEL_NEW_OU_PANEL_TITLE.get();
    }

    @Override
    protected void checkSyntax(ArrayList<Message> errors) {
        for (JLabel label : this.labels) {
            this.setPrimaryValid(label);
        }
        JTextField[] requiredFields = new JTextField[]{this.name};
        Message[] msgs = new Message[]{AdminToolMessages.ERR_CTRL_PANEL_NAME_OF_OU_REQUIRED.get()};
        for (int i = 0; i < requiredFields.length; ++i) {
            String v = requiredFields[i].getText().trim();
            if (v.length() != 0) continue;
            errors.add(msgs[i]);
        }
        if (errors.size() == 0) {
            try {
                this.getEntry();
            }
            catch (OpenDsException ode) {
                errors.add(ode.getMessageObject());
            }
            catch (IOException ioe) {
                throw new IllegalStateException("Unexpected error: " + ioe, ioe);
            }
        }
    }

    private void createLayout() {
        JTextField[] toAddListener;
        GridBagConstraints gbc = new GridBagConstraints();
        Utilities.setRequiredIcon(this.lName);
        gbc.gridwidth = 2;
        gbc.gridy = 0;
        this.addErrorPane(gbc);
        ++gbc.gridy;
        gbc.gridwidth = 1;
        gbc.weighty = 0.0;
        gbc.gridx = 1;
        gbc.anchor = 13;
        gbc.fill = 0;
        JLabel requiredLabel = this.createRequiredLabel();
        gbc.insets.bottom = 10;
        this.add((Component)requiredLabel, gbc);
        ++gbc.gridy;
        gbc.fill = 2;
        gbc.anchor = 17;
        gbc.insets.bottom = 0;
        Component[] inlineHelp = new Component[]{null, null, null, null, null, null};
        for (int i = 0; i < this.labels.length; ++i) {
            gbc.insets.left = 0;
            gbc.weightx = 0.0;
            gbc.gridx = 0;
            this.add((Component)this.labels[i], gbc);
            gbc.insets.left = 10;
            gbc.weightx = 1.0;
            gbc.gridx = 1;
            this.add(this.comps[i], gbc);
            if (inlineHelp[i] != null) {
                gbc.insets.top = 3;
                ++gbc.gridy;
                this.add(inlineHelp[i], gbc);
            }
            gbc.insets.top = 10;
            ++gbc.gridy;
        }
        this.addBottomGlue(gbc);
        DocumentListener listener = new DocumentListener(){

            public void insertUpdate(DocumentEvent ev) {
                NewOrganizationalUnitPanel.this.updateDNValue();
            }

            public void changedUpdate(DocumentEvent ev) {
                this.insertUpdate(ev);
            }

            public void removeUpdate(DocumentEvent ev) {
                this.insertUpdate(ev);
            }
        };
        for (JTextField tf : toAddListener = new JTextField[]{this.name}) {
            tf.getDocument().addDocumentListener(listener);
        }
    }

    private void updateDNValue() {
        String value = this.name.getText().trim();
        if (value.length() > 0) {
            String rdn = Utilities.getRDNString("ou", value);
            this.dn.setText(rdn + "," + this.parentNode.getDN());
        } else {
            this.dn.setText("," + this.parentNode.getDN());
        }
    }

    @Override
    protected String getLDIF() {
        StringBuilder sb = new StringBuilder();
        sb.append("dn: " + this.dn.getText() + "\n");
        String[] attrNames = new String[]{"ou", "description", "postalAddress", "telephoneNumber", "facsimileTelephoneNumber"};
        JTextField[] textFields = new JTextField[]{this.name, this.description, this.address, this.telephoneNumber, this.faxNumber};
        sb.append("objectclass: top\n");
        sb.append("objectclass: organizationalUnit\n");
        for (int i = 0; i < attrNames.length; ++i) {
            String value = textFields[i].getText().trim();
            if (value.length() <= 0) continue;
            sb.append(attrNames[i] + ": " + value + "\n");
        }
        return sb.toString();
    }
}

