/*
 * Decompiled with CFR 0.152.
 */
package org.opends.guitools.controlpanel.util;

import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.Name;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.LdapName;
import org.opends.admin.ads.util.ConnectionUtils;
import org.opends.guitools.controlpanel.datamodel.BackendDescriptor;
import org.opends.guitools.controlpanel.datamodel.BaseDNDescriptor;
import org.opends.guitools.controlpanel.datamodel.ConnectionHandlerDescriptor;
import org.opends.guitools.controlpanel.datamodel.IndexDescriptor;
import org.opends.guitools.controlpanel.datamodel.VLVIndexDescriptor;
import org.opends.guitools.controlpanel.datamodel.VLVSortOrder;
import org.opends.guitools.controlpanel.task.OnlineUpdateException;
import org.opends.guitools.controlpanel.util.ConfigReader;
import org.opends.guitools.controlpanel.util.Utilities;
import org.opends.messages.AdminToolMessages;
import org.opends.server.admin.client.ManagementContext;
import org.opends.server.admin.client.ldap.JNDIDirContextAdaptor;
import org.opends.server.admin.client.ldap.LDAPManagementContext;
import org.opends.server.admin.std.client.AdministrationConnectorCfgClient;
import org.opends.server.admin.std.client.BackendCfgClient;
import org.opends.server.admin.std.client.BackupBackendCfgClient;
import org.opends.server.admin.std.client.ConnectionHandlerCfgClient;
import org.opends.server.admin.std.client.CryptoManagerCfgClient;
import org.opends.server.admin.std.client.JMXConnectionHandlerCfgClient;
import org.opends.server.admin.std.client.LDAPConnectionHandlerCfgClient;
import org.opends.server.admin.std.client.LDIFBackendCfgClient;
import org.opends.server.admin.std.client.LDIFConnectionHandlerCfgClient;
import org.opends.server.admin.std.client.LocalDBBackendCfgClient;
import org.opends.server.admin.std.client.LocalDBIndexCfgClient;
import org.opends.server.admin.std.client.LocalDBVLVIndexCfgClient;
import org.opends.server.admin.std.client.MemoryBackendCfgClient;
import org.opends.server.admin.std.client.MonitorBackendCfgClient;
import org.opends.server.admin.std.client.ReplicationDomainCfgClient;
import org.opends.server.admin.std.client.ReplicationServerCfgClient;
import org.opends.server.admin.std.client.ReplicationSynchronizationProviderCfgClient;
import org.opends.server.admin.std.client.RootCfgClient;
import org.opends.server.admin.std.client.RootDNCfgClient;
import org.opends.server.admin.std.client.RootDNUserCfgClient;
import org.opends.server.admin.std.client.SNMPConnectionHandlerCfgClient;
import org.opends.server.admin.std.client.TaskBackendCfgClient;
import org.opends.server.admin.std.meta.LocalDBIndexCfgDefn;
import org.opends.server.types.DN;
import org.opends.server.types.OpenDsException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigFromDirContext
extends ConfigReader {
    private static final Logger LOG = Logger.getLogger(ConfigFromDirContext.class.getName());

    /*
     * WARNING - void declaration
     */
    public void readConfiguration(InitialLdapContext ctx) {
        OnlineUpdateException oupe;
        ArrayList<OpenDsException> ex = new ArrayList<OpenDsException>();
        HashSet<ConnectionHandlerDescriptor> ls = new HashSet<ConnectionHandlerDescriptor>();
        HashSet<BackendDescriptor> bs = new HashSet<BackendDescriptor>();
        HashSet<DN> as = new HashSet<DN>();
        try {
            ManagementContext mCtx = LDAPManagementContext.createFromContext(JNDIDirContextAdaptor.adapt(ctx));
            RootCfgClient root = mCtx.getRootConfiguration();
            try {
                AdministrationConnectorCfgClient adminConnector = root.getAdministrationConnector();
                this.adminConnector = this.getConnectionHandler(adminConnector);
            }
            catch (OpenDsException oe) {
                ex.add(oe);
            }
            String[] connectionHandlers = root.listConnectionHandlers();
            for (int i = 0; i < connectionHandlers.length; ++i) {
                try {
                    ConnectionHandlerCfgClient connectionHandler = root.getConnectionHandler(connectionHandlers[i]);
                    ls.add(this.getConnectionHandler(connectionHandler, connectionHandlers[i]));
                    continue;
                }
                catch (OpenDsException oe) {
                    ex.add(oe);
                }
            }
            this.isSchemaEnabled = root.getGlobalConfiguration().isCheckSchema();
            String[] backendNames = root.listBackends();
            for (int i = 0; i < backendNames.length; ++i) {
                try {
                    BackendDescriptor.Type type;
                    BackendCfgClient backend = root.getBackend(backendNames[i]);
                    TreeSet<BaseDNDescriptor> baseDNs = new TreeSet<BaseDNDescriptor>();
                    for (DN dn : backend.getBaseDN()) {
                        BaseDNDescriptor baseDN = new BaseDNDescriptor(BaseDNDescriptor.Type.NOT_REPLICATED, dn, null, -1, -1L, -1);
                        baseDNs.add(baseDN);
                    }
                    TreeSet<IndexDescriptor> indexes = new TreeSet<IndexDescriptor>();
                    TreeSet<VLVIndexDescriptor> vlvIndexes = new TreeSet<VLVIndexDescriptor>();
                    if (backend instanceof LocalDBBackendCfgClient) {
                        type = BackendDescriptor.Type.LOCAL_DB;
                        LocalDBBackendCfgClient db = (LocalDBBackendCfgClient)backend;
                        String[] indexNames = db.listLocalDBIndexes();
                        try {
                            void var18_37;
                            boolean bl = false;
                            while (var18_37 < indexNames.length) {
                                LocalDBIndexCfgClient index = db.getLocalDBIndex(indexNames[var18_37]);
                                indexes.add(new IndexDescriptor(index.getAttribute().getNameOrOID(), index.getAttribute(), null, index.getIndexType(), index.getIndexEntryLimit()));
                                ++var18_37;
                            }
                        }
                        catch (OpenDsException openDsException) {
                            ex.add(openDsException);
                        }
                        indexes.add(new IndexDescriptor("dn2id", null, null, new TreeSet<LocalDBIndexCfgDefn.IndexType>(), -1));
                        indexes.add(new IndexDescriptor("id2children", null, null, new TreeSet<LocalDBIndexCfgDefn.IndexType>(), -1));
                        indexes.add(new IndexDescriptor("id2subtree", null, null, new TreeSet<LocalDBIndexCfgDefn.IndexType>(), -1));
                        String[] stringArray = db.listLocalDBVLVIndexes();
                        try {
                            for (int j = 0; j < stringArray.length; ++j) {
                                LocalDBVLVIndexCfgClient index = db.getLocalDBVLVIndex(stringArray[j]);
                                String s = index.getSortOrder();
                                List<VLVSortOrder> sortOrder = this.getVLVSortOrder(s);
                                vlvIndexes.add(new VLVIndexDescriptor(index.getName(), null, index.getBaseDN(), index.getScope(), index.getFilter(), sortOrder, index.getMaxBlockSize()));
                            }
                        }
                        catch (OpenDsException oe) {
                            ex.add(oe);
                        }
                    } else {
                        type = backend instanceof LDIFBackendCfgClient ? BackendDescriptor.Type.LDIF : (backend instanceof MemoryBackendCfgClient ? BackendDescriptor.Type.MEMORY : (backend instanceof BackupBackendCfgClient ? BackendDescriptor.Type.BACKUP : (backend instanceof MonitorBackendCfgClient ? BackendDescriptor.Type.MONITOR : (backend instanceof TaskBackendCfgClient ? BackendDescriptor.Type.TASK : BackendDescriptor.Type.OTHER))));
                    }
                    BackendDescriptor desc = new BackendDescriptor(backend.getBackendId(), baseDNs, indexes, vlvIndexes, -1, backend.isEnabled(), type);
                    for (IndexDescriptor indexDescriptor : indexes) {
                        indexDescriptor.setBackend(desc);
                    }
                    for (VLVIndexDescriptor vLVIndexDescriptor : vlvIndexes) {
                        vLVIndexDescriptor.setBackend(desc);
                    }
                    for (BaseDNDescriptor baseDNDescriptor : baseDNs) {
                        baseDNDescriptor.setBackend(desc);
                    }
                    bs.add(desc);
                    continue;
                }
                catch (OpenDsException oe) {
                    ex.add(oe);
                }
            }
            boolean isReplicationSecure = false;
            try {
                CryptoManagerCfgClient cryptoManager = root.getCryptoManager();
                isReplicationSecure = cryptoManager.isSSLEncryption();
            }
            catch (OpenDsException oe) {
                ex.add(oe);
            }
            this.replicationPort = -1;
            ReplicationSynchronizationProviderCfgClient sync = null;
            try {
                sync = (ReplicationSynchronizationProviderCfgClient)root.getSynchronizationProvider("Multimaster Synchronization");
            }
            catch (OpenDsException oe) {
                // empty catch block
            }
            if (sync != null) {
                try {
                    String[] domains;
                    ReplicationServerCfgClient replicationServer;
                    if (sync.isEnabled().booleanValue() && sync.hasReplicationServer() && (replicationServer = sync.getReplicationServer()) != null) {
                        this.replicationPort = replicationServer.getReplicationPort();
                        ConnectionHandlerDescriptor.Protocol protocol = isReplicationSecure ? ConnectionHandlerDescriptor.Protocol.REPLICATION_SECURE : ConnectionHandlerDescriptor.Protocol.REPLICATION;
                        ConnectionHandlerDescriptor connHandler = new ConnectionHandlerDescriptor(new HashSet<InetAddress>(), this.replicationPort, protocol, ConnectionHandlerDescriptor.State.ENABLED, "Multimaster Synchronization");
                        ls.add(connHandler);
                    }
                    if ((domains = sync.listReplicationDomains()) != null) {
                        for (int i = 0; i < domains.length; ++i) {
                            ReplicationDomainCfgClient domain = sync.getReplicationDomain(domains[i]);
                            DN dn = domain.getBaseDN();
                            for (BackendDescriptor backend : bs) {
                                for (BaseDNDescriptor baseDN : backend.getBaseDns()) {
                                    if (!baseDN.getDn().equals(dn)) continue;
                                    baseDN.setType(BaseDNDescriptor.Type.REPLICATED);
                                    baseDN.setReplicaID(domain.getServerId());
                                }
                            }
                        }
                    }
                }
                catch (OpenDsException oe) {
                    ex.add(oe);
                }
            }
            try {
                RootDNCfgClient rootDN = root.getRootDN();
                String[] rootUsers = rootDN.listRootDNUsers();
                if (rootUsers != null) {
                    for (int i = 0; i < rootUsers.length; ++i) {
                        RootDNUserCfgClient rootUser = rootDN.getRootDNUser(rootUsers[i]);
                        as.addAll(rootUser.getAlternateBindDN());
                    }
                }
            }
            catch (OpenDsException oe) {
                ex.add(oe);
            }
            try {
                this.readSchema();
            }
            catch (OpenDsException oe) {
                ex.add(oe);
            }
        }
        catch (Throwable t) {
            oupe = new OnlineUpdateException(AdminToolMessages.ERR_READING_CONFIG_LDAP.get(t.toString()), t);
            ex.add(oupe);
        }
        for (OpenDsException oe : ex) {
            LOG.log(Level.WARNING, "Error reading configuration: " + oe, oe);
        }
        this.administrativeUsers = Collections.unmodifiableSet(as);
        this.listeners = Collections.unmodifiableSet(ls);
        this.backends = Collections.unmodifiableSet(bs);
        try {
            this.updateMonitorInformation(ctx, ex);
        }
        catch (Throwable t) {
            oupe = new OnlineUpdateException(AdminToolMessages.ERR_READING_CONFIG_LDAP.get(t.toString()), t);
            ex.add(oupe);
        }
        this.exceptions = Collections.unmodifiableList(ex);
    }

    protected String[] getMonitoringAttributes() {
        return new String[]{"approx-older-change-not-synchronized-millis", "missing-changes", "base-dn", "server-id", "javaVersion", "currentConnections", "ds-backend-id", "ds-backend-entry-count", "ds-base-dn-entry-count"};
    }

    protected void handleMonitoringSearchResult(SearchResult sr, String searchBaseDN) throws NamingException {
        block15: {
            String dn;
            block14: {
                String v;
                if (this.javaVersion == null) {
                    this.javaVersion = ConnectionUtils.getFirstValue(sr, "javaVersion");
                }
                if (this.numberConnections == -1 && (v = ConnectionUtils.getFirstValue(sr, "currentConnections")) != null) {
                    this.numberConnections = Integer.parseInt(v);
                }
                dn = ConnectionUtils.getFirstValue(sr, "base-dn");
                String replicaId = ConnectionUtils.getFirstValue(sr, "server-id");
                if (dn == null || replicaId == null) break block14;
                for (BackendDescriptor backend : this.backends) {
                    for (BaseDNDescriptor baseDN : backend.getBaseDns()) {
                        if (!Utilities.areDnsEqual(baseDN.getDn().toString(), dn) || !String.valueOf(baseDN.getReplicaID()).equals(replicaId)) continue;
                        try {
                            baseDN.setAgeOfOldestMissingChange(new Long(ConnectionUtils.getFirstValue(sr, "approx-older-change-not-synchronized-millis")));
                        }
                        catch (Throwable t) {
                            // empty catch block
                        }
                        try {
                            baseDN.setMissingChanges(new Integer(ConnectionUtils.getFirstValue(sr, "missing-changes")));
                        }
                        catch (Throwable t) {}
                    }
                }
                break block15;
            }
            String backendID = ConnectionUtils.getFirstValue(sr, "ds-backend-id");
            String entryCount = ConnectionUtils.getFirstValue(sr, "ds-backend-entry-count");
            Set<String> baseDnEntries = ConnectionUtils.getValues(sr, "ds-base-dn-entry-count");
            if (backendID == null || entryCount == null && baseDnEntries == null) break block15;
            for (BackendDescriptor backend : this.backends) {
                if (!backend.getBackendID().equalsIgnoreCase(backendID)) continue;
                if (entryCount != null) {
                    backend.setEntries(Integer.parseInt(entryCount));
                }
                if (baseDnEntries == null) continue;
                block9: for (String s : baseDnEntries) {
                    int index = s.indexOf(" ");
                    if (index == -1) continue;
                    for (BaseDNDescriptor baseDN : backend.getBaseDns()) {
                        dn = s.substring(index + 1);
                        if (!Utilities.areDnsEqual(dn, baseDN.getDn().toString())) continue;
                        try {
                            baseDN.setEntries(Integer.parseInt(s.substring(0, index)));
                        }
                        catch (Throwable t) {}
                        continue block9;
                    }
                }
            }
        }
    }

    private void updateMonitorInformation(InitialLdapContext ctx, List<OpenDsException> ex) {
        SearchControls ctls = new SearchControls();
        ctls.setSearchScope(2);
        ctls.setReturningAttributes(this.getMonitoringAttributes());
        String filter = "(objectclass=*)";
        try {
            LdapName jndiName = new LdapName("cn=monitor");
            NamingEnumeration<SearchResult> monitorEntries = ctx.search((Name)jndiName, filter, ctls);
            this.javaVersion = null;
            this.numberConnections = -1;
            while (monitorEntries.hasMore()) {
                SearchResult sr = monitorEntries.next();
                this.handleMonitoringSearchResult(sr, "cn=monitor");
            }
        }
        catch (NamingException ne) {
            OnlineUpdateException oue = new OnlineUpdateException(AdminToolMessages.ERR_READING_CONFIG_LDAP.get(ne.getMessage().toString()), (Throwable)ne);
            ex.add(oue);
        }
    }

    private ConnectionHandlerDescriptor getConnectionHandler(ConnectionHandlerCfgClient connHandler, String name) throws OpenDsException {
        int port;
        ConnectionHandlerDescriptor.Protocol protocol;
        ConnectionHandlerDescriptor.State state;
        TreeSet<InetAddress> addresses = new TreeSet<InetAddress>(this.getInetAddressComparator());
        ConnectionHandlerDescriptor.State state2 = state = connHandler.isEnabled() != false ? ConnectionHandlerDescriptor.State.ENABLED : ConnectionHandlerDescriptor.State.DISABLED;
        if (connHandler instanceof LDAPConnectionHandlerCfgClient) {
            LDAPConnectionHandlerCfgClient ldap = (LDAPConnectionHandlerCfgClient)connHandler;
            protocol = ldap.isUseSSL() ? ConnectionHandlerDescriptor.Protocol.LDAPS : (ldap.isAllowStartTLS() ? ConnectionHandlerDescriptor.Protocol.LDAP_STARTTLS : ConnectionHandlerDescriptor.Protocol.LDAP);
            SortedSet<InetAddress> v = ldap.getListenAddress();
            if (v != null) {
                addresses.addAll(v);
            }
            port = ldap.getListenPort();
        } else if (connHandler instanceof JMXConnectionHandlerCfgClient) {
            JMXConnectionHandlerCfgClient jmx = (JMXConnectionHandlerCfgClient)connHandler;
            protocol = jmx.isUseSSL() ? ConnectionHandlerDescriptor.Protocol.JMXS : ConnectionHandlerDescriptor.Protocol.JMX;
            port = jmx.getListenPort();
        } else if (connHandler instanceof LDIFConnectionHandlerCfgClient) {
            protocol = ConnectionHandlerDescriptor.Protocol.LDIF;
            port = -1;
        } else if (connHandler instanceof SNMPConnectionHandlerCfgClient) {
            protocol = ConnectionHandlerDescriptor.Protocol.SNMP;
            SNMPConnectionHandlerCfgClient snmp = (SNMPConnectionHandlerCfgClient)connHandler;
            port = snmp.getListenPort();
        } else {
            protocol = ConnectionHandlerDescriptor.Protocol.OTHER;
            port = -1;
        }
        return new ConnectionHandlerDescriptor(addresses, port, protocol, state, name);
    }

    private ConnectionHandlerDescriptor getConnectionHandler(AdministrationConnectorCfgClient adminConnector) throws OpenDsException {
        TreeSet<InetAddress> addresses = new TreeSet<InetAddress>(this.getInetAddressComparator());
        ConnectionHandlerDescriptor.Protocol protocol = ConnectionHandlerDescriptor.Protocol.ADMINISTRATION_CONNECTOR;
        ConnectionHandlerDescriptor.State state = ConnectionHandlerDescriptor.State.ENABLED;
        SortedSet<InetAddress> v = adminConnector.getListenAddress();
        if (v != null) {
            addresses.addAll(v);
        }
        int port = adminConnector.getListenPort();
        return new ConnectionHandlerDescriptor(addresses, port, protocol, state, AdminToolMessages.INFO_CTRL_PANEL_CONN_HANDLER_ADMINISTRATION.get().toString());
    }
}

