/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.admin;

import java.net.InetAddress;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import org.opends.server.core.DirectoryServer;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.protocols.internal.InternalClientConnection;
import org.opends.server.protocols.internal.InternalSearchOperation;
import org.opends.server.protocols.ldap.LDAPFilter;
import org.opends.server.schema.DirectoryStringSyntax;
import org.opends.server.types.Attribute;
import org.opends.server.types.AttributeType;
import org.opends.server.types.Attributes;
import org.opends.server.types.DN;
import org.opends.server.types.DereferencePolicy;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.Entry;
import org.opends.server.types.LDAPException;
import org.opends.server.types.Modification;
import org.opends.server.types.ModificationType;
import org.opends.server.types.ResultCode;
import org.opends.server.types.SearchResultEntry;
import org.opends.server.types.SearchScope;

public final class AdministrationDataSync {
    private InternalClientConnection internalConnection;
    private static final String LDAP_PORT = "ds-cfg-listen-port";

    public AdministrationDataSync(InternalClientConnection internalConnection) {
        this.internalConnection = internalConnection;
    }

    public void synchronize() {
        this.checkAdminConnector();
    }

    private void checkAdminConnector() {
        DN serverEntryDN = this.searchServerEntry();
        if (serverEntryDN == null) {
            return;
        }
        String adminPort = this.getAttr("cn=Administration Connector,cn=config", LDAP_PORT);
        if (adminPort == null) {
            return;
        }
        LinkedList<Modification> mods = new LinkedList<Modification>();
        String attName = "adminport";
        AttributeType attrType = DirectoryServer.getAttributeType(attName.toLowerCase());
        if (attrType == null) {
            attrType = DirectoryServer.getDefaultAttributeType(attName.toLowerCase());
        }
        mods.add(new Modification(ModificationType.REPLACE, Attributes.create(attrType, adminPort)));
        attName = "adminEnabled";
        attrType = DirectoryServer.getAttributeType(attName.toLowerCase());
        if (attrType == null) {
            attrType = DirectoryServer.getDefaultAttributeType(attName.toLowerCase());
        }
        mods.add(new Modification(ModificationType.REPLACE, Attributes.create(attrType, "true")));
        this.internalConnection.processModify(serverEntryDN, mods);
    }

    private DN searchServerEntry() {
        DN returnDN = null;
        String ldapPort = this.getAttr("cn=LDAP Connection Handler,cn=Connection Handlers,cn=config", LDAP_PORT);
        String ldapsPort = this.getAttr("cn=LDAPS Connection Handler,cn=Connection Handlers,cn=config", LDAP_PORT);
        boolean ldapsPortEnable = false;
        String val = this.getAttr("cn=LDAPS Connection Handler,cn=Connection Handlers,cn=config", "ds-cfg-enabled");
        if (val != null) {
            ldapsPortEnable = val.toLowerCase().equals("true");
        }
        if (ldapPort == null && ldapsPort == null) {
            return null;
        }
        String hostName = "";
        try {
            hostName = InetAddress.getLocalHost().getCanonicalHostName();
        }
        catch (Throwable t) {
            return null;
        }
        InternalSearchOperation op = null;
        String attrName = "hostname";
        AttributeType hostnameType = DirectoryServer.getAttributeType(attrName);
        if (hostnameType == null) {
            hostnameType = DirectoryServer.getDefaultAttributeType(attrName);
        }
        try {
            op = this.internalConnection.processSearch("cn=Servers,cn=admin data", SearchScope.SINGLE_LEVEL, "objectclass=*");
            if (op.getResultCode() == ResultCode.SUCCESS) {
                Entry entry = null;
                for (SearchResultEntry currentEntry : op.getSearchEntries()) {
                    String currentHostname = currentEntry.getAttributeValue(hostnameType, DirectoryStringSyntax.DECODER);
                    try {
                        String currentport;
                        String currentIPAddress = InetAddress.getByName(currentHostname).getCanonicalHostName();
                        if (!currentIPAddress.equals(hostName)) continue;
                        attrName = "ldapport";
                        AttributeType portType = DirectoryServer.getAttributeType(attrName);
                        if (portType == null) {
                            portType = DirectoryServer.getDefaultAttributeType(attrName);
                        }
                        if ((currentport = currentEntry.getAttributeValue(portType, DirectoryStringSyntax.DECODER)).equals(ldapPort)) {
                            entry = currentEntry;
                            break;
                        }
                        if (!ldapsPortEnable) continue;
                        attrName = "ldapsport";
                        portType = DirectoryServer.getAttributeType(attrName);
                        if (portType == null) {
                            portType = DirectoryServer.getDefaultAttributeType(attrName);
                        }
                        if (!(currentport = currentEntry.getAttributeValue(portType, DirectoryStringSyntax.DECODER)).equals(ldapsPort)) continue;
                        entry = currentEntry;
                        break;
                    }
                    catch (Exception e) {
                    }
                }
                if (entry != null) {
                    returnDN = entry.getDN();
                }
            }
        }
        catch (DirectoryException e) {
            return null;
        }
        return returnDN;
    }

    private String getAttr(String baseDN, String attrName) {
        List<Attribute> attrs;
        AttributeType attrType;
        LDAPFilter filter;
        String value = null;
        try {
            filter = LDAPFilter.decode("objectclass=*");
        }
        catch (LDAPException e) {
            return null;
        }
        ASN1OctetString asn1BaseDn = new ASN1OctetString(baseDN);
        LinkedHashSet<String> attributes = new LinkedHashSet<String>(1);
        attributes.add(attrName);
        InternalSearchOperation search = this.internalConnection.processSearch(asn1BaseDn, SearchScope.BASE_OBJECT, DereferencePolicy.DEREF_ALWAYS, 0, 0, false, filter, attributes);
        if (search.getResultCode() != ResultCode.SUCCESS) {
            return null;
        }
        SearchResultEntry adminConnectorEntry = null;
        LinkedList<SearchResultEntry> result = search.getSearchEntries();
        if (!result.isEmpty()) {
            adminConnectorEntry = result.getFirst();
        }
        if ((attrType = DirectoryServer.getAttributeType(attrName)) == null) {
            attrType = DirectoryServer.getDefaultAttributeType(attrName);
        }
        if ((attrs = adminConnectorEntry.getAttribute(attrType)) == null) {
            return null;
        }
        value = attrs.get(0).iterator().next().getStringValue();
        return value;
    }
}

