/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.config;

import java.security.AccessControlContext;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanConstructorInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.security.auth.Subject;
import org.opends.messages.ConfigMessages;
import org.opends.messages.Message;
import org.opends.server.admin.std.server.MonitorProviderCfg;
import org.opends.server.api.AlertGenerator;
import org.opends.server.api.ClientConnection;
import org.opends.server.api.DirectoryServerMBean;
import org.opends.server.api.InvokableComponent;
import org.opends.server.api.MonitorProvider;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.protocols.internal.InternalClientConnection;
import org.opends.server.protocols.jmx.Credential;
import org.opends.server.protocols.jmx.JmxClientConnection;
import org.opends.server.protocols.ldap.LDAPFilter;
import org.opends.server.types.AbstractOperation;
import org.opends.server.types.Attribute;
import org.opends.server.types.AttributeType;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.DN;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.InvokableMethod;
import org.opends.server.types.LDAPException;
import org.opends.server.types.PublicAPI;
import org.opends.server.types.ResultCode;
import org.opends.server.types.SearchScope;
import org.opends.server.types.StabilityLevel;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@PublicAPI(stability=StabilityLevel.VOLATILE, mayInstantiate=true, mayExtend=false, mayInvoke=true)
public final class JMXMBean
implements DynamicMBean,
DirectoryServerMBean {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private static final String CLASS_NAME = "org.opends.server.config.JMXMBean";
    private CopyOnWriteArrayList<AlertGenerator> alertGenerators;
    private CopyOnWriteArrayList<InvokableComponent> invokableComponents;
    private CopyOnWriteArrayList<MonitorProvider<? extends MonitorProviderCfg>> monitorProviders;
    private DN configEntryDN;
    private ObjectName objectName;

    public static String getJmxName(DN configEntryDN) {
        String typeStr = null;
        String nameStr = null;
        try {
            String dnString = configEntryDN.toString();
            if (dnString != null && dnString.length() != 0) {
                StringBuilder buffer = new StringBuilder(dnString.length());
                String[] rdns = dnString.replace(',', ';').split(";");
                for (int j = rdns.length - 1; j >= 0; --j) {
                    int rdnIndex = rdns.length - j;
                    buffer.append(",Rdn" + rdnIndex + "=");
                    block7: for (int i = 0; i < rdns[j].length(); ++i) {
                        char c = rdns[j].charAt(i);
                        if (StaticUtils.isAlpha(c) || StaticUtils.isDigit(c)) {
                            buffer.append(c);
                            continue;
                        }
                        switch (c) {
                            case ' ': {
                                buffer.append("_");
                                continue block7;
                            }
                            case '=': {
                                buffer.append("-");
                            }
                        }
                    }
                }
                typeStr = buffer.toString();
            }
            nameStr = "org.opends.server:Name=rootDSE" + typeStr;
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = ConfigMessages.ERR_CONFIG_JMX_CANNOT_REGISTER_MBEAN.get(configEntryDN.toString(), String.valueOf(e));
            ErrorLogger.logError(message);
        }
        return nameStr;
    }

    public JMXMBean(DN configEntryDN) {
        this.configEntryDN = configEntryDN;
        this.alertGenerators = new CopyOnWriteArrayList();
        this.invokableComponents = new CopyOnWriteArrayList();
        this.monitorProviders = new CopyOnWriteArrayList();
        MBeanServer mBeanServer = DirectoryServer.getJMXMBeanServer();
        if (mBeanServer != null) {
            try {
                block7: {
                    this.objectName = new ObjectName(JMXMBean.getJmxName(configEntryDN));
                    try {
                        if (mBeanServer.isRegistered(this.objectName)) {
                            mBeanServer.unregisterMBean(this.objectName);
                        }
                    }
                    catch (Exception e) {
                        if (!DebugLogger.debugEnabled()) break block7;
                        TRACER.debugCaught(DebugLogLevel.ERROR, e);
                    }
                }
                mBeanServer.registerMBean(this, this.objectName);
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                e.printStackTrace();
                Message message = ConfigMessages.ERR_CONFIG_JMX_CANNOT_REGISTER_MBEAN.get(configEntryDN.toString(), String.valueOf(e));
                ErrorLogger.logError(message);
            }
        }
    }

    @Override
    public ObjectName getObjectName() {
        return this.objectName;
    }

    public CopyOnWriteArrayList<AlertGenerator> getAlertGenerators() {
        return this.alertGenerators;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAlertGenerator(AlertGenerator generator) {
        CopyOnWriteArrayList<AlertGenerator> copyOnWriteArrayList = this.alertGenerators;
        synchronized (copyOnWriteArrayList) {
            if (!this.alertGenerators.contains(generator)) {
                this.alertGenerators.add(generator);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeAlertGenerator(AlertGenerator generator) {
        CopyOnWriteArrayList<AlertGenerator> copyOnWriteArrayList = this.alertGenerators;
        synchronized (copyOnWriteArrayList) {
            return this.alertGenerators.remove(generator);
        }
    }

    public CopyOnWriteArrayList<InvokableComponent> getInvokableComponents() {
        return this.invokableComponents;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addInvokableComponent(InvokableComponent component) {
        CopyOnWriteArrayList<InvokableComponent> copyOnWriteArrayList = this.invokableComponents;
        synchronized (copyOnWriteArrayList) {
            if (!this.invokableComponents.contains(component)) {
                this.invokableComponents.add(component);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeInvokableComponent(InvokableComponent component) {
        CopyOnWriteArrayList<InvokableComponent> copyOnWriteArrayList = this.invokableComponents;
        synchronized (copyOnWriteArrayList) {
            return this.invokableComponents.remove(component);
        }
    }

    public CopyOnWriteArrayList<MonitorProvider<? extends MonitorProviderCfg>> getMonitorProviders() {
        return this.monitorProviders;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMonitorProvider(MonitorProvider<? extends MonitorProviderCfg> component) {
        CopyOnWriteArrayList<MonitorProvider<? extends MonitorProviderCfg>> copyOnWriteArrayList = this.monitorProviders;
        synchronized (copyOnWriteArrayList) {
            if (!this.monitorProviders.contains(component)) {
                this.monitorProviders.add(component);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeMonitorProvider(MonitorProvider<?> component) {
        CopyOnWriteArrayList<MonitorProvider<? extends MonitorProviderCfg>> copyOnWriteArrayList = this.monitorProviders;
        synchronized (copyOnWriteArrayList) {
            return this.monitorProviders.remove(component);
        }
    }

    private javax.management.Attribute getJmxAttribute(String name) {
        AttributeType attrType = DirectoryServer.getAttributeType(name.toLowerCase());
        if (attrType == null) {
            attrType = DirectoryServer.getDefaultAttributeType(name);
        }
        for (MonitorProvider<? extends MonitorProviderCfg> monitor : this.monitorProviders) {
            for (Attribute a : monitor.getMonitorData()) {
                if (!attrType.equals(a.getAttributeType()) || a.isEmpty()) continue;
                Iterator<AttributeValue> iterator = a.iterator();
                AttributeValue value = iterator.next();
                if (iterator.hasNext()) {
                    ArrayList<String> stringValues = new ArrayList<String>();
                    stringValues.add(value.getStringValue());
                    while (iterator.hasNext()) {
                        value = iterator.next();
                        stringValues.add(value.getStringValue());
                    }
                    String[] valueArray = new String[stringValues.size()];
                    stringValues.toArray(valueArray);
                    return new javax.management.Attribute(name, valueArray);
                }
                return new javax.management.Attribute(name, value.getStringValue());
            }
        }
        return null;
    }

    @Override
    public javax.management.Attribute getAttribute(String attributeName) throws AttributeNotFoundException {
        LDAPFilter filter;
        ClientConnection clientConnection = this.getClientConnection();
        if (clientConnection == null) {
            return null;
        }
        try {
            filter = LDAPFilter.decode("objectclass=*");
        }
        catch (LDAPException e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = ConfigMessages.ERR_CONFIG_JMX_CANNOT_GET_ATTRIBUTE.get(String.valueOf(attributeName), String.valueOf(this.configEntryDN), StaticUtils.getExceptionMessage(e));
            throw new AttributeNotFoundException(message.toString());
        }
        AbstractOperation op = null;
        if (clientConnection instanceof JmxClientConnection) {
            op = ((JmxClientConnection)clientConnection).processSearch(new ASN1OctetString(this.configEntryDN.toString()), SearchScope.BASE_OBJECT, filter);
        } else if (clientConnection instanceof InternalClientConnection) {
            op = ((InternalClientConnection)clientConnection).processSearch(new ASN1OctetString(this.configEntryDN.toString()), SearchScope.BASE_OBJECT, filter);
        }
        ResultCode rc = op.getResultCode();
        if (rc != ResultCode.SUCCESS) {
            clientConnection = null;
            Message message = ConfigMessages.ERR_CONFIG_JMX_CANNOT_GET_ATTRIBUTE.get(String.valueOf(attributeName), String.valueOf(this.configEntryDN), String.valueOf(op.getErrorMessage()));
            throw new AttributeNotFoundException(message.toString());
        }
        try {
            return this.getJmxAttribute(attributeName);
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = ConfigMessages.ERR_CONFIG_JMX_ATTR_NO_ATTR.get(String.valueOf(this.configEntryDN), attributeName);
            ErrorLogger.logError(message);
            throw new AttributeNotFoundException(message.toString());
        }
    }

    @Override
    public void setAttribute(javax.management.Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException {
        throw new InvalidAttributeValueException();
    }

    @Override
    public AttributeList getAttributes(String[] attributes) {
        LDAPFilter filter;
        ClientConnection clientConnection = this.getClientConnection();
        if (clientConnection == null) {
            return null;
        }
        try {
            filter = LDAPFilter.decode("objectclass=*");
        }
        catch (LDAPException e) {
            return null;
        }
        AbstractOperation op = null;
        if (clientConnection instanceof JmxClientConnection) {
            op = ((JmxClientConnection)clientConnection).processSearch(new ASN1OctetString(this.configEntryDN.toString()), SearchScope.BASE_OBJECT, filter);
        } else if (clientConnection instanceof InternalClientConnection) {
            op = ((InternalClientConnection)clientConnection).processSearch(new ASN1OctetString(this.configEntryDN.toString()), SearchScope.BASE_OBJECT, filter);
        }
        ResultCode rc = op.getResultCode();
        if (rc != ResultCode.SUCCESS) {
            clientConnection = null;
            return null;
        }
        AttributeList attrList = new AttributeList(attributes.length);
        block4: for (String name : attributes) {
            AttributeType attrType;
            block16: {
                try {
                    javax.management.Attribute attr = this.getJmxAttribute(name);
                    if (attr != null) {
                        attrList.add(attr);
                        continue;
                    }
                }
                catch (Exception e) {
                    if (!DebugLogger.debugEnabled()) break block16;
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
            }
            if ((attrType = DirectoryServer.getAttributeType(name.toLowerCase())) == null) {
                attrType = DirectoryServer.getDefaultAttributeType(name);
            }
            for (MonitorProvider<? extends MonitorProviderCfg> monitor : this.monitorProviders) {
                for (Attribute a : monitor.getMonitorData()) {
                    if (!attrType.equals(a.getAttributeType()) || a.isEmpty()) continue;
                    Iterator<AttributeValue> iterator = a.iterator();
                    AttributeValue value = iterator.next();
                    if (iterator.hasNext()) {
                        ArrayList<String> stringValues = new ArrayList<String>();
                        stringValues.add(value.getStringValue());
                        while (iterator.hasNext()) {
                            value = iterator.next();
                            stringValues.add(value.getStringValue());
                        }
                        String[] valueArray = new String[stringValues.size()];
                        stringValues.toArray(valueArray);
                        attrList.add(new javax.management.Attribute(name, valueArray));
                        continue block4;
                    }
                    attrList.add(new javax.management.Attribute(name, value.getStringValue()));
                    continue block4;
                }
            }
        }
        return attrList;
    }

    @Override
    public AttributeList setAttributes(AttributeList attributes) {
        return new AttributeList();
    }

    @Override
    public Object invoke(String actionName, Object[] params, String[] signature) throws MBeanException {
        for (InvokableComponent component : this.invokableComponents) {
            for (InvokableMethod method : component.getOperationSignatures()) {
                if (!method.hasSignature(actionName, signature)) continue;
                try {
                    method.invoke(component, params);
                }
                catch (MBeanException me) {
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugCaught(DebugLogLevel.ERROR, me);
                    }
                    throw me;
                }
                catch (Exception e) {
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugCaught(DebugLogLevel.ERROR, e);
                    }
                    throw new MBeanException(e);
                }
            }
        }
        StringBuilder buffer = new StringBuilder();
        buffer.append(actionName);
        buffer.append("(");
        if (signature.length > 0) {
            buffer.append(signature[0]);
            for (int i = 1; i < signature.length; ++i) {
                buffer.append(", ");
                buffer.append(signature[i]);
            }
        }
        buffer.append(")");
        Message message = ConfigMessages.ERR_CONFIG_JMX_NO_METHOD.get(buffer.toString(), this.configEntryDN.toString());
        throw new MBeanException(new DirectoryException(ResultCode.NO_SUCH_OPERATION, message));
    }

    @Override
    public MBeanInfo getMBeanInfo() {
        ClientConnection clientConnection = this.getClientConnection();
        if (clientConnection == null) {
            return new MBeanInfo(CLASS_NAME, null, null, null, null, null);
        }
        ArrayList<MBeanAttributeInfo> attrs = new ArrayList<MBeanAttributeInfo>();
        for (MonitorProvider<? extends MonitorProviderCfg> monitor : this.monitorProviders) {
            for (Attribute a : monitor.getMonitorData()) {
                attrs.add(new MBeanAttributeInfo(a.getName(), String.class.getName(), null, true, false, false));
            }
        }
        MBeanAttributeInfo[] mBeanAttributes = new MBeanAttributeInfo[attrs.size()];
        attrs.toArray(mBeanAttributes);
        ArrayList<MBeanNotificationInfo> notifications = new ArrayList<MBeanNotificationInfo>();
        for (AlertGenerator generator : this.alertGenerators) {
            String className = generator.getClassName();
            LinkedHashMap<String, String> alerts = generator.getAlerts();
            for (String type : alerts.keySet()) {
                String[] types = new String[]{type};
                String description = alerts.get(type);
                notifications.add(new MBeanNotificationInfo(types, className, description));
            }
        }
        MBeanNotificationInfo[] mBeanNotifications = new MBeanNotificationInfo[notifications.size()];
        notifications.toArray(mBeanNotifications);
        ArrayList<MBeanOperationInfo> ops = new ArrayList<MBeanOperationInfo>();
        for (InvokableComponent component : this.invokableComponents) {
            for (InvokableMethod method : component.getOperationSignatures()) {
                ops.add(method.toOperationInfo());
            }
        }
        MBeanOperationInfo[] mBeanOperations = new MBeanOperationInfo[ops.size()];
        ops.toArray(mBeanOperations);
        MBeanConstructorInfo[] mBeanConstructors = new MBeanConstructorInfo[]{};
        return new MBeanInfo(CLASS_NAME, "Configurable Attributes for " + this.configEntryDN.toString(), mBeanAttributes, mBeanConstructors, mBeanOperations, mBeanNotifications);
    }

    private ClientConnection getClientConnection() {
        ClientConnection clientConnection = null;
        AccessControlContext acc = AccessController.getContext();
        try {
            Subject subject = Subject.getSubject(acc);
            if (subject != null) {
                Set<Credential> privateCreds = subject.getPrivateCredentials(Credential.class);
                clientConnection = privateCreds.iterator().next().getClientConnection();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return clientConnection;
    }
}

