/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.core;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.opends.messages.CoreMessages;
import org.opends.messages.Message;
import org.opends.messages.MessageBuilder;
import org.opends.server.admin.std.meta.PasswordPolicyCfgDefn;
import org.opends.server.admin.std.server.PasswordValidatorCfg;
import org.opends.server.api.AccountStatusNotificationHandler;
import org.opends.server.api.PasswordGenerator;
import org.opends.server.api.PasswordStorageScheme;
import org.opends.server.api.PasswordValidator;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.ModifyOperation;
import org.opends.server.core.PasswordPolicy;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.protocols.internal.InternalClientConnection;
import org.opends.server.protocols.ldap.LDAPAttribute;
import org.opends.server.schema.AuthPasswordSyntax;
import org.opends.server.schema.GeneralizedTimeSyntax;
import org.opends.server.schema.UserPasswordSyntax;
import org.opends.server.types.AccountStatusNotification;
import org.opends.server.types.AccountStatusNotificationProperty;
import org.opends.server.types.AccountStatusNotificationType;
import org.opends.server.types.Attribute;
import org.opends.server.types.AttributeBuilder;
import org.opends.server.types.AttributeType;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.Attributes;
import org.opends.server.types.ByteString;
import org.opends.server.types.ConditionResult;
import org.opends.server.types.DN;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.Entry;
import org.opends.server.types.Modification;
import org.opends.server.types.ModificationType;
import org.opends.server.types.Operation;
import org.opends.server.types.RawModification;
import org.opends.server.types.ResultCode;
import org.opends.server.util.StaticUtils;
import org.opends.server.util.TimeThread;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PasswordPolicyState {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private final Entry userEntry;
    private final boolean updateEntry;
    private final String userDNString;
    private final PasswordPolicy passwordPolicy;
    private final long currentTime;
    private long passwordChangedTime = Long.MIN_VALUE;
    private ConditionResult isAccountExpired = ConditionResult.UNDEFINED;
    private ConditionResult isDisabled = ConditionResult.UNDEFINED;
    private ConditionResult isPasswordExpired = ConditionResult.UNDEFINED;
    private ConditionResult isFirstWarning = ConditionResult.UNDEFINED;
    private ConditionResult isIdleLocked = ConditionResult.UNDEFINED;
    private ConditionResult mayUseGraceLogin = ConditionResult.UNDEFINED;
    private ConditionResult mustChangePassword = ConditionResult.UNDEFINED;
    private ConditionResult shouldWarn = ConditionResult.UNDEFINED;
    private int secondsUntilUnlock = Integer.MIN_VALUE;
    private List<Long> authFailureTimes = null;
    private List<Long> graceLoginTimes = null;
    private long accountExpirationTime = Long.MIN_VALUE;
    private long failureLockedTime = Long.MIN_VALUE;
    private long lastLoginTime = Long.MIN_VALUE;
    private long passwordExpirationTime = Long.MIN_VALUE;
    private long requiredChangeTime = Long.MIN_VALUE;
    private long warnedTime = Long.MIN_VALUE;
    private LinkedList<Modification> modifications = new LinkedList();

    public PasswordPolicyState(Entry userEntry, boolean updateEntry) throws DirectoryException {
        this(userEntry, updateEntry, TimeThread.getTime(), false);
    }

    public PasswordPolicyState(Entry userEntry, boolean updateEntry, long currentTime, boolean useDefaultOnError) throws DirectoryException {
        this.userEntry = userEntry;
        this.updateEntry = updateEntry;
        this.currentTime = currentTime;
        this.userDNString = userEntry.getDN().toString();
        this.passwordPolicy = PasswordPolicyState.getPasswordPolicyInternal(this.userEntry, useDefaultOnError);
        AttributeType type = DirectoryServer.getAttributeType("pwdchangedtime");
        if (type == null) {
            type = DirectoryServer.getDefaultAttributeType("pwdChangedTime");
        }
        this.passwordChangedTime = this.getGeneralizedTime(type);
        if (this.passwordChangedTime <= 0L) {
            AttributeType createTimeType = DirectoryServer.getAttributeType("createtimestamp");
            if (createTimeType == null) {
                createTimeType = DirectoryServer.getDefaultAttributeType("createTimestamp");
            }
            this.passwordChangedTime = this.getGeneralizedTime(createTimeType);
            if (this.passwordChangedTime <= 0L) {
                this.passwordChangedTime = 0L;
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugWarning("Could not determine password changed time for user %s.", this.userDNString);
                }
            }
        }
    }

    private static PasswordPolicy getPasswordPolicyInternal(Entry userEntry, boolean useDefaultOnError) throws DirectoryException {
        String userDNString = userEntry.getDN().toString();
        AttributeType type = DirectoryServer.getAttributeType("ds-pwp-password-policy-dn", true);
        List<Attribute> attrList = userEntry.getAttribute(type);
        if (attrList != null) {
            for (Attribute a : attrList) {
                DN subentryDN;
                if (a.isEmpty()) continue;
                AttributeValue v = a.iterator().next();
                try {
                    subentryDN = DN.decode(v.getValue());
                }
                catch (Exception e) {
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugCaught(DebugLogLevel.ERROR, e);
                    }
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugError("Could not parse password policy subentry DN %s for user %s: %s", v.getStringValue(), userDNString, StaticUtils.stackTraceToSingleLineString(e));
                    }
                    Message message = CoreMessages.ERR_PWPSTATE_CANNOT_DECODE_SUBENTRY_VALUE_AS_DN.get(v.getStringValue(), userDNString, e.getMessage());
                    if (useDefaultOnError) {
                        ErrorLogger.logError(message);
                        return DirectoryServer.getDefaultPasswordPolicy();
                    }
                    throw new DirectoryException(ResultCode.INVALID_DN_SYNTAX, message, e);
                }
                PasswordPolicy policy = DirectoryServer.getPasswordPolicy(subentryDN);
                if (policy == null) {
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugError("Password policy subentry %s for user %s is not defined in the Directory Server.", String.valueOf(subentryDN), userDNString);
                    }
                    Message message = CoreMessages.ERR_PWPSTATE_NO_SUCH_POLICY.get(userDNString, String.valueOf(subentryDN));
                    if (useDefaultOnError) {
                        ErrorLogger.logError(message);
                        return DirectoryServer.getDefaultPasswordPolicy();
                    }
                    throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message);
                }
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugInfo("Using password policy subentry %s for user %s.", String.valueOf(subentryDN), userDNString);
                }
                return policy;
            }
        }
        if (DebugLogger.debugEnabled()) {
            TRACER.debugInfo("Using the default password policy for user %s", userDNString);
        }
        return DirectoryServer.getDefaultPasswordPolicy();
    }

    private String getValue(AttributeType attributeType) {
        String stringValue = null;
        List<Attribute> attrList = this.userEntry.getAttribute(attributeType);
        if (attrList != null) {
            for (Attribute a : attrList) {
                if (a.isEmpty()) continue;
                stringValue = a.iterator().next().getStringValue();
                break;
            }
        }
        if (stringValue == null) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugInfo("Returning null because attribute %s does not exist in user entry %s", attributeType.getNameOrOID(), this.userDNString);
            }
        } else if (DebugLogger.debugEnabled()) {
            TRACER.debugInfo("Returning value %s for user %s", stringValue, this.userDNString);
        }
        return stringValue;
    }

    private long getGeneralizedTime(AttributeType attributeType) throws DirectoryException {
        long timeValue = -1L;
        List<Attribute> attrList = this.userEntry.getAttribute(attributeType);
        if (attrList != null) {
            for (Attribute a : attrList) {
                if (a.isEmpty()) continue;
                AttributeValue v = a.iterator().next();
                try {
                    timeValue = GeneralizedTimeSyntax.decodeGeneralizedTimeValue(v.getNormalizedValue());
                    break;
                }
                catch (Exception e) {
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugCaught(DebugLogLevel.ERROR, e);
                        TRACER.debugWarning("Unable to decode value %s for attribute %s in user entry %s: %s", v.getStringValue(), attributeType.getNameOrOID(), this.userDNString, StaticUtils.stackTraceToSingleLineString(e));
                    }
                    Message message = CoreMessages.ERR_PWPSTATE_CANNOT_DECODE_GENERALIZED_TIME.get(v.getStringValue(), attributeType.getNameOrOID(), this.userDNString, String.valueOf(e));
                    throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message, e);
                }
            }
        }
        if (timeValue == -1L && DebugLogger.debugEnabled()) {
            TRACER.debugInfo("Returning -1 because attribute %s does not exist in user entry %s", attributeType.getNameOrOID(), this.userDNString);
        }
        return timeValue;
    }

    private List<Long> getGeneralizedTimes(AttributeType attributeType) throws DirectoryException {
        ArrayList<Long> timeValues = new ArrayList<Long>();
        List<Attribute> attrList = this.userEntry.getAttribute(attributeType);
        if (attrList != null) {
            for (Attribute a : attrList) {
                for (AttributeValue v : a) {
                    try {
                        timeValues.add(GeneralizedTimeSyntax.decodeGeneralizedTimeValue(v.getNormalizedValue()));
                    }
                    catch (Exception e) {
                        if (DebugLogger.debugEnabled()) {
                            TRACER.debugCaught(DebugLogLevel.ERROR, e);
                            TRACER.debugWarning("Unable to decode value %s for attribute %sin user entry %s: %s", v.getStringValue(), attributeType.getNameOrOID(), this.userDNString, StaticUtils.stackTraceToSingleLineString(e));
                        }
                        Message message = CoreMessages.ERR_PWPSTATE_CANNOT_DECODE_GENERALIZED_TIME.get(v.getStringValue(), attributeType.getNameOrOID(), this.userDNString, String.valueOf(e));
                        throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message, e);
                    }
                }
            }
        }
        if (timeValues.isEmpty() && DebugLogger.debugEnabled()) {
            TRACER.debugInfo("Returning an empty list because attribute %s does not exist in user entry %s", attributeType.getNameOrOID(), this.userDNString);
        }
        return timeValues;
    }

    private ConditionResult getBoolean(AttributeType attributeType) throws DirectoryException {
        List<Attribute> attrList = this.userEntry.getAttribute(attributeType);
        if (attrList != null) {
            for (Attribute a : attrList) {
                if (a.isEmpty()) continue;
                String valueString = StaticUtils.toLowerCase(a.iterator().next().getStringValue());
                if (valueString.equals("true") || valueString.equals("yes") || valueString.equals("on") || valueString.equals("1")) {
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugInfo("Attribute %s resolves to true for user entry %s", attributeType.getNameOrOID(), this.userDNString);
                    }
                    return ConditionResult.TRUE;
                }
                if (valueString.equals("false") || valueString.equals("no") || valueString.equals("off") || valueString.equals("0")) {
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugInfo("Attribute %s resolves to false for user entry %s", attributeType.getNameOrOID(), this.userDNString);
                    }
                    return ConditionResult.FALSE;
                }
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugError("Unable to resolve value %s for attribute %s in user entry %s as a Boolean.", valueString, attributeType.getNameOrOID(), this.userDNString);
                }
                Message message = CoreMessages.ERR_PWPSTATE_CANNOT_DECODE_BOOLEAN.get(valueString, attributeType.getNameOrOID(), this.userDNString);
                throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message);
            }
        }
        if (DebugLogger.debugEnabled()) {
            TRACER.debugInfo("Returning %s because attribute %s does not exist in user entry %s", ConditionResult.UNDEFINED.toString(), attributeType.getNameOrOID(), this.userDNString);
        }
        return ConditionResult.UNDEFINED;
    }

    public PasswordPolicy getPolicy() {
        return this.passwordPolicy;
    }

    public long getPasswordChangedTime() {
        return this.passwordChangedTime;
    }

    public long getCurrentTime() {
        return this.currentTime;
    }

    public Set<AttributeValue> getPasswordValues() {
        List<Attribute> attrList = this.userEntry.getAttribute(this.passwordPolicy.getPasswordAttribute());
        if (attrList != null) {
            for (Attribute a : attrList) {
                if (a.isEmpty()) continue;
                LinkedHashSet<AttributeValue> values = new LinkedHashSet<AttributeValue>(a.size());
                for (AttributeValue value : a) {
                    values.add(value);
                }
                return Collections.unmodifiableSet(values);
            }
        }
        return Collections.emptySet();
    }

    public void setPasswordChangedTime() {
        this.setPasswordChangedTime(this.currentTime);
    }

    public void setPasswordChangedTime(long passwordChangedTime) {
        if (DebugLogger.debugEnabled()) {
            TRACER.debugInfo("Setting password changed time for user %s to current time of %d", this.userDNString, this.currentTime);
        }
        if (this.passwordChangedTime != passwordChangedTime) {
            this.passwordChangedTime = passwordChangedTime;
            String timeValue = GeneralizedTimeSyntax.format(passwordChangedTime);
            Attribute a = Attributes.create("pwdChangedTime", timeValue);
            if (this.updateEntry) {
                ArrayList<Attribute> attrList = new ArrayList<Attribute>(1);
                attrList.add(a);
                this.userEntry.putAttribute(a.getAttributeType(), attrList);
            } else {
                this.modifications.add(new Modification(ModificationType.REPLACE, a, true));
            }
        }
    }

    public void clearPasswordChangedTime() {
        if (DebugLogger.debugEnabled()) {
            TRACER.debugInfo("Clearing password changed time for user %s", this.userDNString);
        }
        AttributeType type = DirectoryServer.getAttributeType("pwdchangedtime", true);
        if (this.updateEntry) {
            this.userEntry.removeAttribute(type);
        } else {
            Attribute a = Attributes.empty(type);
            this.modifications.add(new Modification(ModificationType.REPLACE, a, true));
        }
        AttributeType createTimeType = DirectoryServer.getAttributeType("createtimestamp", true);
        try {
            this.passwordChangedTime = this.getGeneralizedTime(createTimeType);
            if (this.passwordChangedTime <= 0L) {
                this.passwordChangedTime = 0L;
            }
        }
        catch (Exception e) {
            this.passwordChangedTime = 0L;
        }
    }

    public boolean isDisabled() {
        if (this.isDisabled != ConditionResult.UNDEFINED) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugInfo("Returning stored result of %b for user %s", this.isDisabled == ConditionResult.TRUE, this.userDNString);
            }
            return this.isDisabled == ConditionResult.TRUE;
        }
        AttributeType type = DirectoryServer.getAttributeType("ds-pwp-account-disabled", true);
        try {
            this.isDisabled = this.getBoolean(type);
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            this.isDisabled = ConditionResult.TRUE;
            if (DebugLogger.debugEnabled()) {
                TRACER.debugWarning("User %s is considered administratively disabled because an error occurred while attempting to make the determination: %s.", this.userDNString, StaticUtils.stackTraceToSingleLineString(e));
            }
            return true;
        }
        if (this.isDisabled == ConditionResult.UNDEFINED) {
            this.isDisabled = ConditionResult.FALSE;
            if (DebugLogger.debugEnabled()) {
                TRACER.debugInfo("User %s is not administratively disabled since the attribute \"%s\" is not present in the entry.", this.userDNString, "ds-pwp-account-disabled");
            }
            return false;
        }
        if (DebugLogger.debugEnabled()) {
            TRACER.debugInfo("User %s %s administratively disabled.", this.userDNString, this.isDisabled == ConditionResult.TRUE ? " is" : " is not");
        }
        return this.isDisabled == ConditionResult.TRUE;
    }

    public void setDisabled(boolean isDisabled) {
        if (DebugLogger.debugEnabled()) {
            TRACER.debugInfo("Updating user %s to set the disabled flag to %b", this.userDNString, isDisabled);
        }
        if (isDisabled == this.isDisabled()) {
            return;
        }
        this.isDisabled = ConditionResult.inverseOf(this.isDisabled);
        AttributeType type = DirectoryServer.getAttributeType("ds-pwp-account-disabled", true);
        if (isDisabled) {
            Attribute a = Attributes.create(type, String.valueOf(true));
            if (this.updateEntry) {
                ArrayList<Attribute> attrList = new ArrayList<Attribute>(1);
                attrList.add(a);
                this.userEntry.putAttribute(type, attrList);
            } else {
                this.modifications.add(new Modification(ModificationType.REPLACE, a, true));
            }
        } else if (this.updateEntry) {
            this.userEntry.removeAttribute(type);
        } else {
            this.modifications.add(new Modification(ModificationType.REPLACE, Attributes.empty(type), true));
        }
    }

    public boolean isAccountExpired() {
        if (this.isAccountExpired != ConditionResult.UNDEFINED) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugInfo("Returning stored result of %b for user %s", this.isAccountExpired == ConditionResult.TRUE, this.userDNString);
            }
            return this.isAccountExpired == ConditionResult.TRUE;
        }
        AttributeType type = DirectoryServer.getAttributeType("ds-pwp-account-expiration-time", true);
        try {
            this.accountExpirationTime = this.getGeneralizedTime(type);
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            this.isAccountExpired = ConditionResult.TRUE;
            if (DebugLogger.debugEnabled()) {
                TRACER.debugWarning("User %s is considered to have an expired account because an error occurred while attempting to make the determination: %s.", this.userDNString, StaticUtils.stackTraceToSingleLineString(e));
            }
            return true;
        }
        if (this.accountExpirationTime > this.currentTime) {
            this.isAccountExpired = ConditionResult.FALSE;
            if (DebugLogger.debugEnabled()) {
                TRACER.debugInfo("The account for user %s is not expired because the expiration time has not yet arrived.", this.userDNString);
            }
        } else if (this.accountExpirationTime >= 0L) {
            this.isAccountExpired = ConditionResult.TRUE;
            if (DebugLogger.debugEnabled()) {
                TRACER.debugInfo("The account for user %s is expired because the expiration time in that account has passed.", this.userDNString);
            }
        } else {
            this.isAccountExpired = ConditionResult.FALSE;
            if (DebugLogger.debugEnabled()) {
                TRACER.debugInfo("The account for user %s is not expired because there is no expiration time in the user's entry.", this.userDNString);
            }
        }
        return this.isAccountExpired == ConditionResult.TRUE;
    }

    public long getAccountExpirationTime() {
        if (this.accountExpirationTime == Long.MIN_VALUE) {
            this.isAccountExpired();
        }
        return this.accountExpirationTime;
    }

    public void setAccountExpirationTime(long accountExpirationTime) {
        if (accountExpirationTime < 0L) {
            this.clearAccountExpirationTime();
        } else {
            String timeStr = GeneralizedTimeSyntax.format(accountExpirationTime);
            if (DebugLogger.debugEnabled()) {
                TRACER.debugInfo("Setting account expiration time for user %s to %s", this.userDNString, timeStr);
            }
            this.accountExpirationTime = accountExpirationTime;
            AttributeType type = DirectoryServer.getAttributeType("ds-pwp-account-expiration-time", true);
            Attribute a = Attributes.create(type, timeStr);
            if (this.updateEntry) {
                ArrayList<Attribute> attrList = new ArrayList<Attribute>(1);
                attrList.add(a);
                this.userEntry.putAttribute(type, attrList);
            } else {
                this.modifications.add(new Modification(ModificationType.REPLACE, a, true));
            }
        }
    }

    public void clearAccountExpirationTime() {
        if (DebugLogger.debugEnabled()) {
            TRACER.debugInfo("Clearing account expiration time for user %s", this.userDNString);
        }
        this.accountExpirationTime = -1L;
        AttributeType type = DirectoryServer.getAttributeType("ds-pwp-account-expiration-time", true);
        if (this.updateEntry) {
            this.userEntry.removeAttribute(type);
        } else {
            this.modifications.add(new Modification(ModificationType.REPLACE, Attributes.empty(type), true));
        }
    }

    public List<Long> getAuthFailureTimes() {
        if (this.authFailureTimes != null) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugInfo("Returning stored auth failure time list of %d elements for user %s" + this.authFailureTimes.size(), this.userDNString);
            }
            return this.authFailureTimes;
        }
        AttributeType type = DirectoryServer.getAttributeType("pwdfailuretime");
        if (type == null) {
            type = DirectoryServer.getDefaultAttributeType("pwdFailureTime");
        }
        try {
            this.authFailureTimes = this.getGeneralizedTimes(type);
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            if (DebugLogger.debugEnabled()) {
                TRACER.debugWarning("Error while processing auth failure times for user %s: %s", this.userDNString, StaticUtils.stackTraceToSingleLineString(e));
            }
            this.authFailureTimes = new ArrayList<Long>();
            if (this.updateEntry) {
                this.userEntry.removeAttribute(type);
            } else {
                this.modifications.add(new Modification(ModificationType.REPLACE, Attributes.empty(type), true));
            }
            return this.authFailureTimes;
        }
        if (this.authFailureTimes.isEmpty()) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugInfo("Returning an empty auth failure time list for user %s because the attribute is absent from the entry.", this.userDNString);
            }
            return this.authFailureTimes;
        }
        if (this.passwordPolicy.getLockoutFailureExpirationInterval() > 0) {
            LinkedHashSet<AttributeValue> valuesToRemove = null;
            long expirationTime = this.currentTime - (long)this.passwordPolicy.getLockoutFailureExpirationInterval() * 1000L;
            Iterator<Long> iterator = this.authFailureTimes.iterator();
            while (iterator.hasNext()) {
                long l = iterator.next();
                if (l >= expirationTime) continue;
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugInfo("Removing expired auth failure time %d for user %s", l, this.userDNString);
                }
                iterator.remove();
                if (valuesToRemove == null) {
                    valuesToRemove = new LinkedHashSet<AttributeValue>();
                }
                valuesToRemove.add(new AttributeValue(type, GeneralizedTimeSyntax.format(l)));
            }
            if (valuesToRemove != null) {
                if (this.updateEntry) {
                    if (this.authFailureTimes.isEmpty()) {
                        this.userEntry.removeAttribute(type);
                    } else {
                        AttributeBuilder builder = new AttributeBuilder(type);
                        for (Long l : this.authFailureTimes) {
                            builder.add(new AttributeValue(type, GeneralizedTimeSyntax.format(l)));
                        }
                        ArrayList<Attribute> keepList = new ArrayList<Attribute>(1);
                        keepList.add(builder.toAttribute());
                        this.userEntry.putAttribute(type, keepList);
                    }
                } else {
                    AttributeBuilder builder = new AttributeBuilder(type);
                    builder.addAll(valuesToRemove);
                    Attribute a = builder.toAttribute();
                    this.modifications.add(new Modification(ModificationType.DELETE, a, true));
                }
            }
        }
        if (DebugLogger.debugEnabled()) {
            TRACER.debugInfo("Returning auth failure time list of %d elements for user %s", this.authFailureTimes.size(), this.userDNString);
        }
        return this.authFailureTimes;
    }

    public void updateAuthFailureTimes() {
        if (this.passwordPolicy.getLockoutFailureCount() <= 0) {
            return;
        }
        if (DebugLogger.debugEnabled()) {
            TRACER.debugInfo("Updating authentication failure times for user %s", this.userDNString);
        }
        List<Long> failureTimes = this.getAuthFailureTimes();
        long highestFailureTime = -1L;
        for (Long l : failureTimes) {
            highestFailureTime = Math.max(l, highestFailureTime);
        }
        highestFailureTime = highestFailureTime >= this.currentTime ? ++highestFailureTime : this.currentTime;
        failureTimes.add(highestFailureTime);
        AttributeType type = DirectoryServer.getAttributeType("pwdfailuretime");
        if (type == null) {
            type = DirectoryServer.getDefaultAttributeType("pwdFailureTime");
        }
        AttributeBuilder builder = new AttributeBuilder(type);
        for (Long l : failureTimes) {
            builder.add(new AttributeValue(type, GeneralizedTimeSyntax.format(l)));
        }
        ArrayList<Attribute> attrList = new ArrayList<Attribute>(1);
        attrList.add(builder.toAttribute());
        Attribute addAttr = Attributes.create(type, new AttributeValue(type, GeneralizedTimeSyntax.format(highestFailureTime)));
        if (this.updateEntry) {
            this.userEntry.putAttribute(type, attrList);
        } else {
            this.modifications.add(new Modification(ModificationType.ADD, addAttr, true));
        }
        int lockoutCount = this.passwordPolicy.getLockoutFailureCount();
        if (lockoutCount > 0 && lockoutCount <= this.authFailureTimes.size()) {
            this.setFailureLockedTime(highestFailureTime);
            if (DebugLogger.debugEnabled()) {
                TRACER.debugInfo("Locking user account %s due to too many failures.", this.userDNString);
            }
        }
    }

    public void setAuthFailureTimes(List<Long> authFailureTimes) {
        if (authFailureTimes == null || authFailureTimes.isEmpty()) {
            this.clearAuthFailureTimes();
            this.clearFailureLockedTime();
            return;
        }
        long highestFailureTime = -1L;
        for (Long l : authFailureTimes) {
            highestFailureTime = Math.max(l, highestFailureTime);
        }
        AttributeType type = DirectoryServer.getAttributeType("pwdfailuretime", true);
        AttributeBuilder builder = new AttributeBuilder(type);
        for (Long l : authFailureTimes) {
            builder.add(new AttributeValue(type, GeneralizedTimeSyntax.format(l)));
        }
        Attribute a = builder.toAttribute();
        if (this.updateEntry) {
            ArrayList<Attribute> attrList = new ArrayList<Attribute>(1);
            attrList.add(a);
            this.userEntry.putAttribute(type, attrList);
        } else {
            this.modifications.add(new Modification(ModificationType.REPLACE, a, true));
        }
        int lockoutCount = this.passwordPolicy.getLockoutFailureCount();
        if (lockoutCount > 0 && lockoutCount <= authFailureTimes.size()) {
            this.setFailureLockedTime(highestFailureTime);
            if (DebugLogger.debugEnabled()) {
                TRACER.debugInfo("Locking user account %s due to too many failures.", this.userDNString);
            }
        }
    }

    private void clearAuthFailureTimes() {
        List<Long> failureTimes;
        if (DebugLogger.debugEnabled()) {
            TRACER.debugInfo("Clearing authentication failure times for user %s", this.userDNString);
        }
        if ((failureTimes = this.getAuthFailureTimes()).isEmpty()) {
            return;
        }
        failureTimes.clear();
        AttributeType type = DirectoryServer.getAttributeType("pwdfailuretime");
        if (type == null) {
            type = DirectoryServer.getDefaultAttributeType("pwdFailureTime");
        }
        if (this.updateEntry) {
            this.userEntry.removeAttribute(type);
        } else {
            this.modifications.add(new Modification(ModificationType.REPLACE, Attributes.empty(type), true));
        }
    }

    private long getFailureLockedTime() {
        if (this.failureLockedTime != Long.MIN_VALUE) {
            return this.failureLockedTime;
        }
        AttributeType type = DirectoryServer.getAttributeType("pwdaccountlockedtime");
        if (type == null) {
            type = DirectoryServer.getDefaultAttributeType("pwdAccountLockedTime");
        }
        try {
            this.failureLockedTime = this.getGeneralizedTime(type);
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            this.failureLockedTime = this.currentTime;
            if (DebugLogger.debugEnabled()) {
                TRACER.debugWarning("Returning current time for user %s because an error occurred: %s", this.userDNString, StaticUtils.stackTraceToSingleLineString(e));
            }
            return this.failureLockedTime;
        }
        return this.failureLockedTime;
    }

    private void setFailureLockedTime(long time) {
        if (time == this.getFailureLockedTime()) {
            return;
        }
        this.failureLockedTime = time;
        AttributeType type = DirectoryServer.getAttributeType("pwdaccountlockedtime");
        if (type == null) {
            type = DirectoryServer.getDefaultAttributeType("pwdAccountLockedTime");
        }
        Attribute a = Attributes.create(type, new AttributeValue(type, GeneralizedTimeSyntax.format(this.failureLockedTime)));
        if (this.updateEntry) {
            ArrayList<Attribute> attrList = new ArrayList<Attribute>(1);
            attrList.add(a);
            this.userEntry.putAttribute(type, attrList);
        } else {
            this.modifications.add(new Modification(ModificationType.REPLACE, a, true));
        }
    }

    private void clearFailureLockedTime() {
        if (DebugLogger.debugEnabled()) {
            TRACER.debugInfo("Clearing failure lockout time for user %s.", this.userDNString);
        }
        if (-1L == this.getFailureLockedTime()) {
            return;
        }
        this.failureLockedTime = -1L;
        AttributeType type = DirectoryServer.getAttributeType("pwdaccountlockedtime");
        if (type == null) {
            type = DirectoryServer.getDefaultAttributeType("pwdAccountLockedTime");
        }
        if (this.updateEntry) {
            this.userEntry.removeAttribute(type);
        } else {
            this.modifications.add(new Modification(ModificationType.REPLACE, Attributes.empty(type), true));
        }
    }

    public boolean lockedDueToFailures() {
        int maxFailures = this.passwordPolicy.getLockoutFailureCount();
        if (maxFailures <= 0) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugInfo("Returning false for user %s because lockout due to failures is not enabled.", this.userDNString);
            }
            return false;
        }
        if (this.getFailureLockedTime() < 0L) {
            if (this.getAuthFailureTimes().size() < maxFailures) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugInfo("Returning false for user %s because there is no locked time.", this.userDNString);
                }
                return false;
            }
            this.setFailureLockedTime(this.currentTime);
            if (DebugLogger.debugEnabled()) {
                TRACER.debugInfo("Locking user %s because there were enough existing failures even though there was no account locked time.", this.userDNString);
            }
        }
        if (this.passwordPolicy.getLockoutDuration() > 0) {
            long unlockTime = this.getFailureLockedTime() + 1000L * (long)this.passwordPolicy.getLockoutDuration();
            if (unlockTime > this.currentTime) {
                this.secondsUntilUnlock = (int)((unlockTime - this.currentTime) / 1000L);
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugInfo("Returning true for user %s because there is a locked time and the lockout duration has not been reached.", this.userDNString);
                }
                return true;
            }
            this.clearFailureLockout();
            if (DebugLogger.debugEnabled()) {
                TRACER.debugInfo("Returning false for user %s because the existing lockout has expired.", this.userDNString);
            }
            assert (-1L == this.getFailureLockedTime());
            return false;
        }
        if (DebugLogger.debugEnabled()) {
            TRACER.debugInfo("Returning true for user %s because there is a locked time and no lockout duration.", this.userDNString);
        }
        assert (-1L <= this.getFailureLockedTime());
        return true;
    }

    public int getSecondsUntilUnlock() {
        assert (this.failureLockedTime != Long.MIN_VALUE);
        return this.secondsUntilUnlock < 0 ? -1 : this.secondsUntilUnlock;
    }

    public void clearFailureLockout() {
        this.clearAuthFailureTimes();
        this.clearFailureLockedTime();
    }

    public long getLastLoginTime() {
        if (this.lastLoginTime != Long.MIN_VALUE) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugInfo("Returning stored last login time of %d for user %s.", this.lastLoginTime, this.userDNString);
            }
            return this.lastLoginTime;
        }
        AttributeType type = this.passwordPolicy.getLastLoginTimeAttribute();
        String format = this.passwordPolicy.getLastLoginTimeFormat();
        if (type == null || format == null) {
            this.lastLoginTime = -1L;
            if (DebugLogger.debugEnabled()) {
                TRACER.debugInfo("Returning -1 for user %s because no last login time will be maintained.", this.userDNString);
            }
            return this.lastLoginTime;
        }
        this.lastLoginTime = -1L;
        List<Attribute> attrList = this.userEntry.getAttribute(type);
        if (attrList != null) {
            for (Attribute a : attrList) {
                if (a.isEmpty()) continue;
                String valueString = a.iterator().next().getStringValue();
                try {
                    SimpleDateFormat dateFormat = new SimpleDateFormat(format);
                    this.lastLoginTime = dateFormat.parse(valueString).getTime();
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugInfo("Returning last login time of %d for user %sdecoded using current last login time format.", this.lastLoginTime, this.userDNString);
                    }
                    return this.lastLoginTime;
                }
                catch (Exception e) {
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugCaught(DebugLogLevel.ERROR, e);
                    }
                    for (String f : this.passwordPolicy.getPreviousLastLoginTimeFormats()) {
                        try {
                            SimpleDateFormat dateFormat = new SimpleDateFormat(f);
                            this.lastLoginTime = dateFormat.parse(valueString).getTime();
                            if (DebugLogger.debugEnabled()) {
                                TRACER.debugInfo("Returning last login time of %d for user %s decoded using previous last login time format of %s.", this.lastLoginTime, this.userDNString, f);
                            }
                            return this.lastLoginTime;
                        }
                        catch (Exception e2) {
                            if (!DebugLogger.debugEnabled()) continue;
                            TRACER.debugCaught(DebugLogLevel.ERROR, e);
                        }
                    }
                    assert (this.lastLoginTime == -1L);
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugWarning("Returning -1 for user %s because the last login time value %s could not be parsed using any known format.", this.userDNString, valueString);
                    }
                    return this.lastLoginTime;
                }
            }
        }
        assert (this.lastLoginTime == -1L);
        if (DebugLogger.debugEnabled()) {
            TRACER.debugInfo("Returning %d for user %s because no last login time value exists.", this.lastLoginTime, this.userDNString);
        }
        return this.lastLoginTime;
    }

    public void setLastLoginTime() {
        this.setLastLoginTime(this.currentTime);
    }

    public void setLastLoginTime(long lastLoginTime) {
        String timestamp;
        AttributeType type = this.passwordPolicy.getLastLoginTimeAttribute();
        String format = this.passwordPolicy.getLastLoginTimeFormat();
        if (type == null || format == null) {
            return;
        }
        try {
            SimpleDateFormat dateFormat = new SimpleDateFormat(format);
            timestamp = dateFormat.format(new Date(lastLoginTime));
            this.lastLoginTime = dateFormat.parse(timestamp).getTime();
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            if (DebugLogger.debugEnabled()) {
                TRACER.debugWarning("Unable to set last login time for user %s because an error occurred: %s", this.userDNString, StaticUtils.stackTraceToSingleLineString(e));
            }
            return;
        }
        String existingTimestamp = this.getValue(type);
        if (existingTimestamp != null && timestamp.equals(existingTimestamp)) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugInfo("Not updating last login time for user %s because the new value matches the existing value.", this.userDNString);
            }
            return;
        }
        Attribute a = Attributes.create(type, timestamp);
        if (this.updateEntry) {
            ArrayList<Attribute> attrList = new ArrayList<Attribute>(1);
            attrList.add(a);
            this.userEntry.putAttribute(type, attrList);
        } else {
            this.modifications.add(new Modification(ModificationType.REPLACE, a, true));
        }
        if (DebugLogger.debugEnabled()) {
            TRACER.debugInfo("Updated the last login time for user %s to %s", this.userDNString, timestamp);
        }
    }

    public void clearLastLoginTime() {
        if (DebugLogger.debugEnabled()) {
            TRACER.debugInfo("Clearing last login time for user %s", this.userDNString);
        }
        this.lastLoginTime = -1L;
        AttributeType type = DirectoryServer.getAttributeType("ds-pwp-last-login-time", true);
        if (this.updateEntry) {
            this.userEntry.removeAttribute(type);
        } else {
            this.modifications.add(new Modification(ModificationType.REPLACE, Attributes.empty(type), true));
        }
    }

    public boolean lockedDueToIdleInterval() {
        long lastLoginTime;
        if (this.isIdleLocked != ConditionResult.UNDEFINED) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugInfo("Returning stored result of %b for user %s", this.isIdleLocked == ConditionResult.TRUE, this.userDNString);
            }
            return this.isIdleLocked == ConditionResult.TRUE;
        }
        if (this.passwordPolicy.getIdleLockoutInterval() <= 0) {
            this.isIdleLocked = ConditionResult.FALSE;
            if (DebugLogger.debugEnabled()) {
                TRACER.debugInfo("Returning false for user %s because no idle lockout interval is defined.", this.userDNString);
            }
            return false;
        }
        long lockTime = this.currentTime - 1000L * (long)this.passwordPolicy.getIdleLockoutInterval();
        if (lockTime < 0L) {
            lockTime = 0L;
        }
        if ((lastLoginTime = this.getLastLoginTime()) > lockTime || this.passwordChangedTime > lockTime) {
            this.isIdleLocked = ConditionResult.FALSE;
            if (DebugLogger.debugEnabled()) {
                StringBuilder reason = new StringBuilder();
                if (lastLoginTime > lockTime) {
                    reason.append("the last login time is in an acceptable window");
                } else {
                    if (lastLoginTime < 0L) {
                        reason.append("there is no last login time, but ");
                    }
                    reason.append("the password changed time is in an acceptable window");
                }
                TRACER.debugInfo("Returning false for user %s because %s.", this.userDNString, reason.toString());
            }
        } else {
            this.isIdleLocked = ConditionResult.TRUE;
            if (DebugLogger.debugEnabled()) {
                String reason = lastLoginTime < 0L ? "there is no last login time and the password changed time is not in an acceptable window" : "neither last login time nor password changed time are in an acceptable window";
                TRACER.debugInfo("Returning true for user %s because %s.", this.userDNString, reason);
            }
        }
        return this.isIdleLocked == ConditionResult.TRUE;
    }

    public boolean mustChangePassword() {
        if (this.mustChangePassword != ConditionResult.UNDEFINED) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugInfo("Returning stored result of %b for user %s.", this.mustChangePassword == ConditionResult.TRUE, this.userDNString);
            }
            return this.mustChangePassword == ConditionResult.TRUE;
        }
        if (!this.passwordPolicy.allowUserPasswordChanges() || !this.passwordPolicy.forceChangeOnAdd() && !this.passwordPolicy.forceChangeOnReset()) {
            this.mustChangePassword = ConditionResult.FALSE;
            if (DebugLogger.debugEnabled()) {
                TRACER.debugInfo("Returning false for user %s because neither force change on add nor force change on reset is enabled, or users are not allowed to self-modify passwords.", this.userDNString);
            }
            return false;
        }
        AttributeType type = DirectoryServer.getAttributeType("pwdreset");
        if (type == null) {
            type = DirectoryServer.getDefaultAttributeType("pwdReset");
        }
        try {
            this.mustChangePassword = this.getBoolean(type);
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
                TRACER.debugWarning("Returning true for user %s because an error occurred: %s", this.userDNString, StaticUtils.stackTraceToSingleLineString(e));
            }
            this.mustChangePassword = ConditionResult.TRUE;
            return true;
        }
        if (this.mustChangePassword == ConditionResult.UNDEFINED) {
            this.mustChangePassword = ConditionResult.FALSE;
            if (DebugLogger.debugEnabled()) {
                TRACER.debugInfo("Returning %b for user since the attribute \"%s\" is not present in the entry.", false, this.userDNString, "pwdReset");
            }
            return false;
        }
        if (DebugLogger.debugEnabled()) {
            TRACER.debugInfo("Returning %b for user %s.", this.mustChangePassword == ConditionResult.TRUE, this.userDNString);
        }
        return this.mustChangePassword == ConditionResult.TRUE;
    }

    public void setMustChangePassword(boolean mustChangePassword) {
        if (DebugLogger.debugEnabled()) {
            TRACER.debugInfo("Updating user %s to set the reset flag to %b", this.userDNString, mustChangePassword);
        }
        if (mustChangePassword == this.mustChangePassword()) {
            return;
        }
        this.mustChangePassword = ConditionResult.inverseOf(this.mustChangePassword);
        AttributeType type = DirectoryServer.getAttributeType("pwdreset");
        if (type == null) {
            type = DirectoryServer.getDefaultAttributeType("pwdReset");
        }
        if (mustChangePassword) {
            Attribute a = Attributes.create(type, String.valueOf(true));
            if (this.updateEntry) {
                ArrayList<Attribute> attrList = new ArrayList<Attribute>(1);
                attrList.add(a);
                this.userEntry.putAttribute(type, attrList);
            } else {
                this.modifications.add(new Modification(ModificationType.REPLACE, a, true));
            }
        } else if (this.updateEntry) {
            this.userEntry.removeAttribute(type);
        } else {
            this.modifications.add(new Modification(ModificationType.REPLACE, Attributes.empty(type), true));
        }
    }

    public boolean lockedDueToMaximumResetAge() {
        boolean locked;
        if (this.passwordPolicy.getMaximumPasswordResetAge() <= 0) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugInfo("Returning false for user %s because there is no maximum reset age.", this.userDNString);
            }
            return false;
        }
        if (!this.mustChangePassword()) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugInfo("Returning false for user %s because the user's password has not been reset.", this.userDNString);
            }
            return false;
        }
        long maxResetTime = this.passwordChangedTime + 1000L * (long)this.passwordPolicy.getMaximumPasswordResetAge();
        boolean bl = locked = maxResetTime < this.currentTime;
        if (DebugLogger.debugEnabled()) {
            TRACER.debugInfo("Returning %b for user %s after comparing the current and max reset times.", locked, this.userDNString);
        }
        return locked;
    }

    public long getPasswordExpirationTime() {
        if (this.passwordExpirationTime == Long.MIN_VALUE) {
            long reqChangeTime;
            long mustChangeTime;
            long expTime;
            long expTime2;
            this.passwordExpirationTime = Long.MAX_VALUE;
            boolean checkWarning = false;
            int maxAge = this.passwordPolicy.getMaximumPasswordAge();
            if (maxAge > 0 && (expTime2 = this.passwordChangedTime + 1000L * (long)maxAge) < this.passwordExpirationTime) {
                this.passwordExpirationTime = expTime2;
                checkWarning = true;
            }
            int maxResetAge = this.passwordPolicy.getMaximumPasswordResetAge();
            if (this.mustChangePassword() && maxResetAge > 0 && (expTime = this.passwordChangedTime + 1000L * (long)maxResetAge) < this.passwordExpirationTime) {
                this.passwordExpirationTime = expTime;
                checkWarning = false;
            }
            if ((mustChangeTime = this.passwordPolicy.getRequireChangeByTime()) > 0L && (reqChangeTime = this.getRequiredChangeTime()) != mustChangeTime && mustChangeTime < this.passwordExpirationTime) {
                this.passwordExpirationTime = mustChangeTime;
                checkWarning = true;
            }
            if (this.passwordExpirationTime == Long.MAX_VALUE) {
                this.passwordExpirationTime = -1L;
                this.shouldWarn = ConditionResult.FALSE;
                this.isFirstWarning = ConditionResult.FALSE;
                this.isPasswordExpired = ConditionResult.FALSE;
                this.mayUseGraceLogin = ConditionResult.TRUE;
            } else if (checkWarning) {
                this.mayUseGraceLogin = ConditionResult.TRUE;
                int warningInterval = this.passwordPolicy.getWarningInterval();
                if (warningInterval > 0) {
                    long shouldWarnTime = this.passwordExpirationTime - (long)warningInterval * 1000L;
                    if (shouldWarnTime > this.currentTime) {
                        this.shouldWarn = ConditionResult.FALSE;
                        this.isFirstWarning = ConditionResult.FALSE;
                        this.isPasswordExpired = ConditionResult.FALSE;
                    } else {
                        long warnedTime = this.getWarnedTime();
                        if (this.passwordExpirationTime > this.currentTime) {
                            this.shouldWarn = ConditionResult.TRUE;
                            this.isPasswordExpired = ConditionResult.FALSE;
                            if (warnedTime < 0L) {
                                this.isFirstWarning = ConditionResult.TRUE;
                                this.setWarnedTime();
                                if (!this.passwordPolicy.expirePasswordsWithoutWarning()) {
                                    this.passwordExpirationTime = this.currentTime + (long)warningInterval * 1000L;
                                }
                            } else {
                                this.isFirstWarning = ConditionResult.FALSE;
                                if (!this.passwordPolicy.expirePasswordsWithoutWarning()) {
                                    this.passwordExpirationTime = warnedTime + (long)warningInterval * 1000L;
                                }
                            }
                        } else if (this.passwordPolicy.expirePasswordsWithoutWarning()) {
                            this.shouldWarn = ConditionResult.FALSE;
                            this.isFirstWarning = ConditionResult.FALSE;
                            this.isPasswordExpired = ConditionResult.TRUE;
                        } else if (warnedTime > 0L) {
                            this.passwordExpirationTime = warnedTime + (long)warningInterval * 1000L;
                            if (this.passwordExpirationTime > this.currentTime) {
                                this.shouldWarn = ConditionResult.TRUE;
                                this.isFirstWarning = ConditionResult.FALSE;
                                this.isPasswordExpired = ConditionResult.FALSE;
                            } else {
                                this.shouldWarn = ConditionResult.FALSE;
                                this.isFirstWarning = ConditionResult.FALSE;
                                this.isPasswordExpired = ConditionResult.TRUE;
                            }
                        } else {
                            this.shouldWarn = ConditionResult.TRUE;
                            this.isFirstWarning = ConditionResult.TRUE;
                            this.isPasswordExpired = ConditionResult.FALSE;
                            this.passwordExpirationTime = this.currentTime + (long)warningInterval * 1000L;
                        }
                    }
                } else {
                    this.shouldWarn = ConditionResult.FALSE;
                    this.isFirstWarning = ConditionResult.FALSE;
                    this.isPasswordExpired = this.currentTime > this.passwordExpirationTime ? ConditionResult.TRUE : ConditionResult.FALSE;
                }
            } else {
                this.mayUseGraceLogin = ConditionResult.FALSE;
                this.shouldWarn = ConditionResult.FALSE;
                this.isFirstWarning = ConditionResult.FALSE;
                this.isPasswordExpired = this.passwordExpirationTime < this.currentTime ? ConditionResult.TRUE : ConditionResult.FALSE;
            }
        }
        if (DebugLogger.debugEnabled()) {
            TRACER.debugInfo("Returning password expiration time of %d for user %s.", this.passwordExpirationTime, this.userDNString);
        }
        return this.passwordExpirationTime;
    }

    public boolean isPasswordExpired() {
        if (this.isPasswordExpired == null || this.isPasswordExpired == ConditionResult.UNDEFINED) {
            this.getPasswordExpirationTime();
        }
        return this.isPasswordExpired == ConditionResult.TRUE;
    }

    public boolean isWithinMinimumAge() {
        int minAge = this.passwordPolicy.getMinimumPasswordAge();
        if (minAge <= 0) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugInfo("Returning false because there is no minimum age.");
            }
            return false;
        }
        if (this.passwordChangedTime + (long)minAge * 1000L < this.currentTime) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugInfo("Returning false because the minimum age has expired.");
            }
            return false;
        }
        if (this.mustChangePassword()) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugInfo("Returning false because the account is in a must-change state.");
            }
            return false;
        }
        if (DebugLogger.debugEnabled()) {
            TRACER.debugInfo("Returning true.");
        }
        return true;
    }

    public boolean mayUseGraceLogin() {
        if (this.mayUseGraceLogin == null || this.mayUseGraceLogin == ConditionResult.UNDEFINED) {
            this.getPasswordExpirationTime();
        }
        return this.mayUseGraceLogin == ConditionResult.TRUE;
    }

    public boolean shouldWarn() {
        if (this.shouldWarn == null || this.shouldWarn == ConditionResult.UNDEFINED) {
            this.getPasswordExpirationTime();
        }
        return this.shouldWarn == ConditionResult.TRUE;
    }

    public boolean isFirstWarning() {
        if (this.isFirstWarning == null || this.isFirstWarning == ConditionResult.UNDEFINED) {
            this.getPasswordExpirationTime();
        }
        return this.isFirstWarning == ConditionResult.TRUE;
    }

    public int getSecondsUntilExpiration() {
        long expirationTime = this.getPasswordExpirationTime();
        if (expirationTime < 0L) {
            return -1;
        }
        if (expirationTime < this.currentTime) {
            return 0;
        }
        return (int)((expirationTime - this.currentTime) / 1000L);
    }

    public long getRequiredChangeTime() {
        if (this.requiredChangeTime != Long.MIN_VALUE) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugInfo("Returning stored required change time of %d for user %s", this.requiredChangeTime, this.userDNString);
            }
            return this.requiredChangeTime;
        }
        AttributeType type = DirectoryServer.getAttributeType("ds-pwp-password-changed-by-required-time", true);
        try {
            this.requiredChangeTime = this.getGeneralizedTime(type);
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            this.requiredChangeTime = -1L;
            if (DebugLogger.debugEnabled()) {
                TRACER.debugWarning("Returning %d for user %s because an error occurred: %s", this.requiredChangeTime, this.userDNString, StaticUtils.stackTraceToSingleLineString(e));
            }
            return this.requiredChangeTime;
        }
        if (DebugLogger.debugEnabled()) {
            TRACER.debugInfo("Returning required change time of %d for user %s", this.requiredChangeTime, this.userDNString);
        }
        return this.requiredChangeTime;
    }

    public void setRequiredChangeTime() {
        long requiredChangeByTimePolicy = this.passwordPolicy.getRequireChangeByTime();
        if (requiredChangeByTimePolicy > 0L) {
            this.setRequiredChangeTime(requiredChangeByTimePolicy);
        }
    }

    public void setRequiredChangeTime(long requiredChangeTime) {
        if (DebugLogger.debugEnabled()) {
            TRACER.debugInfo("Updating required change time for user %s", this.userDNString);
        }
        if (this.getRequiredChangeTime() != requiredChangeTime) {
            AttributeType type = DirectoryServer.getAttributeType("ds-pwp-password-changed-by-required-time", true);
            String timeValue = GeneralizedTimeSyntax.format(requiredChangeTime);
            Attribute a = Attributes.create(type, timeValue);
            if (this.updateEntry) {
                ArrayList<Attribute> attrList = new ArrayList<Attribute>(1);
                attrList.add(a);
                this.userEntry.putAttribute(type, attrList);
            } else {
                this.modifications.add(new Modification(ModificationType.REPLACE, a, true));
            }
        }
    }

    public void clearRequiredChangeTime() {
        if (DebugLogger.debugEnabled()) {
            TRACER.debugInfo("Clearing required change time for user %s", this.userDNString);
        }
        AttributeType type = DirectoryServer.getAttributeType("ds-pwp-password-changed-by-required-time", true);
        if (this.updateEntry) {
            this.userEntry.removeAttribute(type);
        } else {
            this.modifications.add(new Modification(ModificationType.REPLACE, Attributes.empty(type), true));
        }
    }

    public long getWarnedTime() {
        if (this.warnedTime == Long.MIN_VALUE) {
            AttributeType type = DirectoryServer.getAttributeType("ds-pwp-warned-time", true);
            try {
                this.warnedTime = this.getGeneralizedTime(type);
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugWarning("Unable to decode the warned time for user %s: %s", this.userDNString, StaticUtils.stackTraceToSingleLineString(e));
                }
                this.warnedTime = -1L;
            }
        }
        if (DebugLogger.debugEnabled()) {
            TRACER.debugInfo("Returning a warned time of %d for user %s", this.warnedTime, this.userDNString);
        }
        return this.warnedTime;
    }

    public void setWarnedTime() {
        this.setWarnedTime(this.currentTime);
    }

    public void setWarnedTime(long warnedTime) {
        long warnTime = this.getWarnedTime();
        if (warnTime == warnedTime) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugInfo("Not updating warned time for user %s because the warned time is the same as the specified time.", this.userDNString);
            }
            return;
        }
        this.warnedTime = warnedTime;
        AttributeType type = DirectoryServer.getAttributeType("ds-pwp-warned-time", true);
        Attribute a = Attributes.create(type, GeneralizedTimeSyntax.createGeneralizedTimeValue(this.currentTime));
        if (this.updateEntry) {
            ArrayList<Attribute> attrList = new ArrayList<Attribute>(1);
            attrList.add(a);
            this.userEntry.putAttribute(type, attrList);
        } else {
            this.modifications.add(new Modification(ModificationType.REPLACE, a, true));
        }
        if (DebugLogger.debugEnabled()) {
            TRACER.debugInfo("Updated the warned time for user %s", this.userDNString);
        }
    }

    public void clearWarnedTime() {
        if (DebugLogger.debugEnabled()) {
            TRACER.debugInfo("Clearing warned time for user %s", this.userDNString);
        }
        if (this.getWarnedTime() < 0L) {
            return;
        }
        this.warnedTime = -1L;
        AttributeType type = DirectoryServer.getAttributeType("ds-pwp-warned-time", true);
        if (this.updateEntry) {
            this.userEntry.removeAttribute(type);
        } else {
            Attribute a = Attributes.empty(type);
            this.modifications.add(new Modification(ModificationType.REPLACE, a, true));
        }
        if (DebugLogger.debugEnabled()) {
            TRACER.debugInfo("Cleared the warned time for user %s", this.userDNString);
        }
    }

    public List<Long> getGraceLoginTimes() {
        if (this.graceLoginTimes == null) {
            AttributeType type = DirectoryServer.getAttributeType("pwdgraceusetime");
            if (type == null) {
                type = DirectoryServer.getDefaultAttributeType("pwdGraceUseTime");
            }
            try {
                this.graceLoginTimes = this.getGeneralizedTimes(type);
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugWarning("Error while processing grace login times for user %s: %s", this.userDNString, StaticUtils.stackTraceToSingleLineString(e));
                }
                this.graceLoginTimes = new ArrayList<Long>();
                if (this.updateEntry) {
                    this.userEntry.removeAttribute(type);
                }
                this.modifications.add(new Modification(ModificationType.REPLACE, Attributes.empty(type), true));
            }
        }
        if (DebugLogger.debugEnabled()) {
            TRACER.debugInfo("Returning grace login times for user %s", this.userDNString);
        }
        return this.graceLoginTimes;
    }

    public int getGraceLoginsRemaining() {
        int maxGraceLogins = this.passwordPolicy.getGraceLoginCount();
        if (maxGraceLogins <= 0) {
            return -1;
        }
        List<Long> graceLoginTimes = this.getGraceLoginTimes();
        return maxGraceLogins - graceLoginTimes.size();
    }

    public void updateGraceLoginTimes() {
        if (DebugLogger.debugEnabled()) {
            TRACER.debugInfo("Updating grace login times for user %s", this.userDNString);
        }
        List<Long> graceTimes = this.getGraceLoginTimes();
        long highestGraceTime = -1L;
        for (Long l : graceTimes) {
            highestGraceTime = Math.max(l, highestGraceTime);
        }
        highestGraceTime = highestGraceTime >= this.currentTime ? ++highestGraceTime : this.currentTime;
        graceTimes.add(highestGraceTime);
        AttributeType type = DirectoryServer.getAttributeType("pwdgraceusetime");
        if (type == null) {
            type = DirectoryServer.getDefaultAttributeType("pwdGraceUseTime");
        }
        if (this.updateEntry) {
            AttributeBuilder builder = new AttributeBuilder(type);
            for (Long l : graceTimes) {
                builder.add(new AttributeValue(type, GeneralizedTimeSyntax.format(l)));
            }
            ArrayList<Attribute> attrList = new ArrayList<Attribute>(1);
            attrList.add(builder.toAttribute());
            this.userEntry.putAttribute(type, attrList);
        } else {
            Attribute addAttr = Attributes.create(type, new AttributeValue(type, GeneralizedTimeSyntax.format(highestGraceTime)));
            this.modifications.add(new Modification(ModificationType.ADD, addAttr, true));
        }
    }

    public void setGraceLoginTimes(List<Long> graceLoginTimes) {
        if (graceLoginTimes == null || graceLoginTimes.isEmpty()) {
            this.clearGraceLoginTimes();
            return;
        }
        if (DebugLogger.debugEnabled()) {
            TRACER.debugInfo("Updating grace login times for user %s", this.userDNString);
        }
        AttributeType type = DirectoryServer.getAttributeType("pwdgraceusetime", true);
        AttributeBuilder builder = new AttributeBuilder(type);
        for (Long l : graceLoginTimes) {
            builder.add(new AttributeValue(type, GeneralizedTimeSyntax.format(l)));
        }
        Attribute a = builder.toAttribute();
        if (this.updateEntry) {
            ArrayList<Attribute> attrList = new ArrayList<Attribute>(1);
            attrList.add(a);
            this.userEntry.putAttribute(type, attrList);
        } else {
            this.modifications.add(new Modification(ModificationType.REPLACE, a, true));
        }
    }

    public void clearGraceLoginTimes() {
        List<Long> graceTimes;
        if (DebugLogger.debugEnabled()) {
            TRACER.debugInfo("Clearing grace login times for user %s", this.userDNString);
        }
        if ((graceTimes = this.getGraceLoginTimes()).isEmpty()) {
            return;
        }
        graceTimes.clear();
        AttributeType type = DirectoryServer.getAttributeType("pwdgraceusetime");
        if (type == null) {
            type = DirectoryServer.getDefaultAttributeType("pwdGraceUseTime");
        }
        if (this.updateEntry) {
            this.userEntry.removeAttribute(type);
        } else {
            this.modifications.add(new Modification(ModificationType.REPLACE, Attributes.empty(type), true));
        }
    }

    public List<ByteString> getClearPasswords() {
        LinkedList<ByteString> clearPasswords = new LinkedList<ByteString>();
        List<Attribute> attrList = this.userEntry.getAttribute(this.passwordPolicy.getPasswordAttribute());
        if (attrList == null) {
            return clearPasswords;
        }
        for (Attribute a : attrList) {
            boolean usesAuthPasswordSyntax = this.passwordPolicy.usesAuthPasswordSyntax();
            for (AttributeValue v : a) {
                try {
                    PasswordStorageScheme scheme;
                    StringBuilder[] pwComponents;
                    if (usesAuthPasswordSyntax) {
                        pwComponents = AuthPasswordSyntax.decodeAuthPassword(v.getStringValue());
                    } else {
                        String[] userPwComponents = UserPasswordSyntax.decodeUserPassword(v.getStringValue());
                        pwComponents = new StringBuilder[userPwComponents.length];
                        for (int i = 0; i < userPwComponents.length; ++i) {
                            pwComponents[i] = new StringBuilder(userPwComponents[i]);
                        }
                    }
                    String schemeName = pwComponents[0].toString();
                    PasswordStorageScheme passwordStorageScheme = scheme = usesAuthPasswordSyntax ? DirectoryServer.getAuthPasswordStorageScheme(schemeName) : DirectoryServer.getPasswordStorageScheme(schemeName);
                    if (scheme == null) {
                        if (!DebugLogger.debugEnabled()) continue;
                        TRACER.debugWarning("User entry %s contains a password with scheme %s that is not defined in the server.", this.userDNString, schemeName);
                        continue;
                    }
                    if (!scheme.isReversible()) continue;
                    ByteString clearValue = usesAuthPasswordSyntax ? scheme.getAuthPasswordPlaintextValue(pwComponents[1].toString(), pwComponents[2].toString()) : scheme.getPlaintextValue(new ASN1OctetString(pwComponents[1].toString()));
                    clearPasswords.add(clearValue);
                }
                catch (Exception e) {
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugCaught(DebugLogLevel.ERROR, e);
                    }
                    if (!DebugLogger.debugEnabled()) continue;
                    TRACER.debugWarning("Cannot get clear password value foruser %s: %s", this.userDNString, e);
                }
            }
        }
        return clearPasswords;
    }

    public boolean passwordMatches(ByteString password) {
        List<Attribute> attrList = this.userEntry.getAttribute(this.passwordPolicy.getPasswordAttribute());
        if (attrList == null || attrList.isEmpty()) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugInfo("Returning false because user %s does not have any values for password attribute %s", this.userDNString, this.passwordPolicy.getPasswordAttribute().getNameOrOID());
            }
            return false;
        }
        for (Attribute a : attrList) {
            boolean usesAuthPasswordSyntax = this.passwordPolicy.usesAuthPasswordSyntax();
            for (AttributeValue v : a) {
                try {
                    PasswordStorageScheme scheme;
                    StringBuilder[] pwComponents;
                    if (usesAuthPasswordSyntax) {
                        pwComponents = AuthPasswordSyntax.decodeAuthPassword(v.getStringValue());
                    } else {
                        String[] userPwComponents = UserPasswordSyntax.decodeUserPassword(v.getStringValue());
                        pwComponents = new StringBuilder[userPwComponents.length];
                        for (int i = 0; i < userPwComponents.length; ++i) {
                            pwComponents[i] = new StringBuilder(userPwComponents[i]);
                        }
                    }
                    String schemeName = pwComponents[0].toString();
                    PasswordStorageScheme passwordStorageScheme = scheme = usesAuthPasswordSyntax ? DirectoryServer.getAuthPasswordStorageScheme(schemeName) : DirectoryServer.getPasswordStorageScheme(schemeName);
                    if (scheme == null) {
                        if (!DebugLogger.debugEnabled()) continue;
                        TRACER.debugWarning("User entry %s contains a password with scheme %s that is not defined in the server.", this.userDNString, schemeName);
                        continue;
                    }
                    boolean passwordMatches = usesAuthPasswordSyntax ? scheme.authPasswordMatches(password, pwComponents[1].toString(), pwComponents[2].toString()) : scheme.passwordMatches(password, new ASN1OctetString(pwComponents[1].toString()));
                    if (!passwordMatches) continue;
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugInfo("Returning true for user %s because the provided password matches a value encoded with scheme %s", this.userDNString, schemeName);
                    }
                    return true;
                }
                catch (Exception e) {
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugCaught(DebugLogLevel.ERROR, e);
                    }
                    if (!DebugLogger.debugEnabled()) continue;
                    TRACER.debugWarning("An error occurred while attempting to process a password value for user %s: %s", this.userDNString, StaticUtils.stackTraceToSingleLineString(e));
                }
            }
        }
        if (DebugLogger.debugEnabled()) {
            TRACER.debugInfo("Returning false because the provided password does not match any of the stored password values for user %s", this.userDNString);
        }
        return false;
    }

    public boolean passwordIsPreEncoded(ByteString passwordValue) {
        if (this.passwordPolicy.usesAuthPasswordSyntax()) {
            return AuthPasswordSyntax.isEncoded(passwordValue);
        }
        return UserPasswordSyntax.isEncoded(passwordValue);
    }

    public List<ByteString> encodePassword(ByteString password) throws DirectoryException {
        CopyOnWriteArrayList<PasswordStorageScheme<?>> schemes = this.passwordPolicy.getDefaultStorageSchemes();
        ArrayList<ByteString> encodedPasswords = new ArrayList<ByteString>(schemes.size());
        if (this.passwordPolicy.usesAuthPasswordSyntax()) {
            for (PasswordStorageScheme passwordStorageScheme : schemes) {
                encodedPasswords.add(passwordStorageScheme.encodeAuthPassword(password));
            }
        } else {
            for (PasswordStorageScheme passwordStorageScheme : schemes) {
                encodedPasswords.add(passwordStorageScheme.encodePasswordWithScheme(password));
            }
        }
        return encodedPasswords;
    }

    public boolean passwordIsAcceptable(Operation operation, Entry userEntry, ByteString newPassword, Set<ByteString> currentPasswords, MessageBuilder invalidReason) {
        for (DN validatorDN : this.passwordPolicy.getPasswordValidators().keySet()) {
            PasswordValidator<? extends PasswordValidatorCfg> validator = this.passwordPolicy.getPasswordValidators().get(validatorDN);
            if (!validator.passwordIsAcceptable(newPassword, currentPasswords, operation, userEntry, invalidReason)) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugInfo("The password provided for user %s failed the %s password validator.", this.userDNString, validatorDN.toString());
                }
                return false;
            }
            if (!DebugLogger.debugEnabled()) continue;
            TRACER.debugInfo("The password provided for user %s passed the %s password validator.", this.userDNString, validatorDN.toString());
        }
        return true;
    }

    public void handleDeprecatedStorageSchemes(ByteString password) {
        AttributeBuilder builder;
        if (this.passwordPolicy.getDefaultStorageSchemes().isEmpty()) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugInfo("Doing nothing for user %s because no deprecated storage schemes have been defined.", this.userDNString);
            }
            return;
        }
        AttributeType type = this.passwordPolicy.getPasswordAttribute();
        List<Attribute> attrList = this.userEntry.getAttribute(type);
        if (attrList == null || attrList.isEmpty()) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugInfo("Doing nothing for entry %s because no password values were found.", this.userDNString);
            }
            return;
        }
        HashSet<String> existingDefaultSchemes = new HashSet<String>();
        LinkedHashSet<AttributeValue> removedValues = new LinkedHashSet<AttributeValue>();
        LinkedHashSet<AttributeValue> updatedValues = new LinkedHashSet<AttributeValue>();
        boolean usesAuthPasswordSyntax = this.passwordPolicy.usesAuthPasswordSyntax();
        for (Attribute a : attrList) {
            Iterator<AttributeValue> iterator = a.iterator();
            while (iterator.hasNext()) {
                AttributeValue v = iterator.next();
                try {
                    PasswordStorageScheme scheme;
                    StringBuilder[] pwComponents;
                    if (usesAuthPasswordSyntax) {
                        pwComponents = AuthPasswordSyntax.decodeAuthPassword(v.getStringValue());
                    } else {
                        String[] userPwComponents = UserPasswordSyntax.decodeUserPassword(v.getStringValue());
                        pwComponents = new StringBuilder[userPwComponents.length];
                        for (int i = 0; i < userPwComponents.length; ++i) {
                            pwComponents[i] = new StringBuilder(userPwComponents[i]);
                        }
                    }
                    String schemeName = pwComponents[0].toString();
                    PasswordStorageScheme passwordStorageScheme = scheme = usesAuthPasswordSyntax ? DirectoryServer.getAuthPasswordStorageScheme(schemeName) : DirectoryServer.getPasswordStorageScheme(schemeName);
                    if (scheme == null) {
                        if (!DebugLogger.debugEnabled()) continue;
                        TRACER.debugWarning("Skipping password value for user %s because the associated storage scheme %s is not configured for use.", this.userDNString, schemeName);
                        continue;
                    }
                    boolean passwordMatches = usesAuthPasswordSyntax ? scheme.authPasswordMatches(password, pwComponents[1].toString(), pwComponents[2].toString()) : scheme.passwordMatches(password, new ASN1OctetString(pwComponents[1].toString()));
                    if (!passwordMatches) continue;
                    if (this.passwordPolicy.isDefaultStorageScheme(schemeName)) {
                        existingDefaultSchemes.add(schemeName);
                        updatedValues.add(v);
                        continue;
                    }
                    if (this.passwordPolicy.isDeprecatedStorageScheme(schemeName)) {
                        if (DebugLogger.debugEnabled()) {
                            TRACER.debugInfo("Marking password with scheme %s for removal from user entry %s.", schemeName, this.userDNString);
                        }
                        iterator.remove();
                        removedValues.add(v);
                        continue;
                    }
                    updatedValues.add(v);
                }
                catch (Exception e) {
                    if (!DebugLogger.debugEnabled()) continue;
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                    TRACER.debugWarning("Skipping password value for user %s because an error occurred while attempting to decode it based on the user password syntax: %s", this.userDNString, StaticUtils.stackTraceToSingleLineString(e));
                }
            }
        }
        if (removedValues.isEmpty()) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugInfo("User entry %s does not have any password values encoded using deprecated schemes.", this.userDNString);
            }
            return;
        }
        LinkedHashSet<AttributeValue> addedValues = new LinkedHashSet<AttributeValue>();
        for (PasswordStorageScheme<?> s : this.passwordPolicy.getDefaultStorageSchemes()) {
            if (existingDefaultSchemes.contains(StaticUtils.toLowerCase(s.getStorageSchemeName()))) continue;
            try {
                ByteString encodedPassword = usesAuthPasswordSyntax ? s.encodeAuthPassword(password) : s.encodePasswordWithScheme(password);
                AttributeValue v = new AttributeValue(type, encodedPassword);
                addedValues.add(v);
                updatedValues.add(v);
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                if (!DebugLogger.debugEnabled()) continue;
                TRACER.debugWarning("Unable to encode password for user %s using default scheme %s: %s", this.userDNString, s.getStorageSchemeName(), StaticUtils.stackTraceToSingleLineString(e));
            }
        }
        if (updatedValues.isEmpty()) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugWarning("Not updating user entry %s because removing deprecated schemes would leave the user without a password.", this.userDNString);
            }
            return;
        }
        if (this.updateEntry) {
            builder = new AttributeBuilder(type);
            builder.addAll(updatedValues);
            ArrayList<Attribute> newList = new ArrayList<Attribute>(1);
            newList.add(builder.toAttribute());
            this.userEntry.putAttribute(type, newList);
        } else {
            builder = new AttributeBuilder(type);
            builder.addAll(removedValues);
            Attribute a = builder.toAttribute();
            this.modifications.add(new Modification(ModificationType.DELETE, a, true));
            if (!addedValues.isEmpty()) {
                builder = new AttributeBuilder(type);
                builder.addAll(addedValues);
                Attribute a2 = builder.toAttribute();
                this.modifications.add(new Modification(ModificationType.ADD, a2, true));
            }
        }
        if (DebugLogger.debugEnabled()) {
            TRACER.debugInfo("Updating user entry %s to replace password values encoded with deprecated schemes with values encoded with the default schemes.", this.userDNString);
        }
    }

    public boolean maintainHistory() {
        return this.passwordPolicy.getPasswordHistoryCount() > 0 || this.passwordPolicy.getPasswordHistoryDuration() > 0;
    }

    public boolean isPasswordInHistory(ByteString password) {
        int historyDuration;
        if (!this.maintainHistory()) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugInfo("Returning false because password history checking is disabled.");
            }
            return false;
        }
        if (this.passwordMatches(password)) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugInfo("Returning true because the provided password is currently in use.");
            }
            return true;
        }
        TreeMap<Long, AttributeValue> historyMap = this.getSortedHistoryValues(null);
        int historyCount = this.passwordPolicy.getPasswordHistoryCount();
        if (historyCount > 0 && historyMap.size() > historyCount) {
            Iterator<Long> iterator = historyMap.keySet().iterator();
            for (int numToDelete = historyMap.size() - historyCount; iterator.hasNext() && numToDelete > 0; --numToDelete) {
                iterator.next();
                iterator.remove();
            }
        }
        if ((historyDuration = this.passwordPolicy.getPasswordHistoryDuration()) > 0) {
            long historyDate;
            long retainDate = this.currentTime - (long)(1000 * historyDuration);
            Iterator<Long> iterator = historyMap.keySet().iterator();
            while (iterator.hasNext() && (historyDate = iterator.next().longValue()) < retainDate) {
                iterator.remove();
            }
        }
        for (AttributeValue v : historyMap.values()) {
            if (!this.historyValueMatches(password, v)) continue;
            if (DebugLogger.debugEnabled()) {
                TRACER.debugInfo("Returning true because the password is in the history.");
            }
            return true;
        }
        if (DebugLogger.debugEnabled()) {
            TRACER.debugInfo("Returning false because the password isn't in the history.");
        }
        return false;
    }

    private TreeMap<Long, AttributeValue> getSortedHistoryValues(List<Attribute> removeAttrs) {
        TreeMap<Long, AttributeValue> historyMap = new TreeMap<Long, AttributeValue>();
        AttributeType historyType = DirectoryServer.getAttributeType("pwdhistory", true);
        List<Attribute> attrList = this.userEntry.getAttribute(historyType);
        if (attrList != null) {
            for (Attribute a : attrList) {
                for (AttributeValue v : a) {
                    String histStr = v.getStringValue();
                    int hashPos = histStr.indexOf(35);
                    if (hashPos <= 0) {
                        if (DebugLogger.debugEnabled()) {
                            TRACER.debugInfo("Found value " + histStr + " in the " + "history with no timestamp.  Marking it " + "for removal.");
                        }
                        if (removeAttrs == null) continue;
                        removeAttrs.add(Attributes.create(a.getAttributeType(), v));
                        continue;
                    }
                    try {
                        long timestamp = GeneralizedTimeSyntax.decodeGeneralizedTimeValue(new ASN1OctetString(histStr.substring(0, hashPos)));
                        historyMap.put(timestamp, v);
                    }
                    catch (Exception e) {
                        if (DebugLogger.debugEnabled()) {
                            TRACER.debugCaught(DebugLogLevel.ERROR, e);
                            TRACER.debugInfo("Could not decode the timestamp in history value " + histStr + " -- " + e + ".  Marking it for removal.");
                        }
                        if (removeAttrs == null) continue;
                        removeAttrs.add(Attributes.create(a.getAttributeType(), v));
                    }
                }
            }
        }
        return historyMap;
    }

    private boolean historyValueMatches(ByteString password, AttributeValue historyValue) {
        try {
            String histStr = historyValue.getStringValue();
            int hashPos1 = histStr.indexOf(35);
            if (hashPos1 <= 0) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugInfo("Returning false because the password history value didn't include any hash characters.");
                }
                return false;
            }
            int hashPos2 = histStr.indexOf(35, hashPos1 + 1);
            if (hashPos2 < 0) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugInfo("Returning false because the password history value only had one hash character.");
                }
                return false;
            }
            String syntaxOID = StaticUtils.toLowerCase(histStr.substring(hashPos1 + 1, hashPos2));
            if (syntaxOID.equals("1.3.6.1.4.1.4203.1.1.2")) {
                StringBuilder[] authPWComponents = AuthPasswordSyntax.decodeAuthPassword(histStr.substring(hashPos2 + 1));
                PasswordStorageScheme scheme = DirectoryServer.getAuthPasswordStorageScheme(authPWComponents[0].toString());
                if (scheme.authPasswordMatches(password, authPWComponents[1].toString(), authPWComponents[2].toString())) {
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugInfo("Returning true because the auth password history value matched.");
                    }
                    return true;
                }
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugInfo("Returning false because the auth password history value did not match.");
                }
                return false;
            }
            if (syntaxOID.equals("1.3.6.1.4.1.26027.1.3.1")) {
                String[] userPWComponents = UserPasswordSyntax.decodeUserPassword(histStr.substring(hashPos2 + 1));
                PasswordStorageScheme scheme = DirectoryServer.getPasswordStorageScheme(userPWComponents[0]);
                if (scheme.passwordMatches(password, new ASN1OctetString(userPWComponents[1]))) {
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugInfo("Returning true because the user password history value matched.");
                    }
                    return true;
                }
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugInfo("Returning false because the user password history value did not match.");
                }
                return false;
            }
            if (DebugLogger.debugEnabled()) {
                TRACER.debugInfo("Returning false because the syntax OID " + syntaxOID + " didn't match for either the auth " + "or user password syntax.");
            }
            return false;
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugInfo("Returning false because of an exception:  " + StaticUtils.stackTraceToSingleLineString(e));
                }
            }
            return false;
        }
    }

    public void updatePasswordHistory() {
        List<Attribute> attrList = this.userEntry.getAttribute(this.passwordPolicy.getPasswordAttribute());
        if (attrList != null) {
            for (Attribute a : attrList) {
                for (AttributeValue v : a) {
                    this.addPasswordToHistory(v.getStringValue());
                }
            }
        }
    }

    private void addPasswordToHistory(String encodedPassword) {
        int historyDuration;
        if (!this.maintainHistory()) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugInfo("Not doing anything because password history maintenance is disabled.");
            }
            return;
        }
        LinkedList<Attribute> removeAttrs = new LinkedList<Attribute>();
        TreeMap<Long, AttributeValue> historyMap = this.getSortedHistoryValues(removeAttrs);
        AttributeType historyType = DirectoryServer.getAttributeType("pwdhistory", true);
        int historyCount = this.passwordPolicy.getPasswordHistoryCount();
        if (historyCount > 0 && historyMap.size() >= historyCount) {
            int numToDelete;
            LinkedHashSet<AttributeValue> removeValues = new LinkedHashSet<AttributeValue>(numToDelete);
            Iterator<AttributeValue> iterator = historyMap.values().iterator();
            for (numToDelete = historyMap.size() - historyCount + 1; iterator.hasNext() && numToDelete > 0; --numToDelete) {
                AttributeValue v = iterator.next();
                removeValues.add(v);
                iterator.remove();
                if (!DebugLogger.debugEnabled()) continue;
                TRACER.debugInfo("Removing history value " + v.getStringValue() + " to preserve the history count.");
            }
            if (!removeValues.isEmpty()) {
                AttributeBuilder builder = new AttributeBuilder(historyType);
                builder.addAll(removeValues);
                removeAttrs.add(builder.toAttribute());
            }
        }
        if ((historyDuration = this.passwordPolicy.getPasswordHistoryDuration()) > 0) {
            long timestamp;
            long minAgeToKeep = this.currentTime - 1000L * (long)historyDuration;
            Iterator<Long> iterator = historyMap.keySet().iterator();
            LinkedHashSet<AttributeValue> removeValues = new LinkedHashSet<AttributeValue>();
            while (iterator.hasNext() && (timestamp = iterator.next().longValue()) < minAgeToKeep) {
                AttributeValue v = historyMap.get(timestamp);
                removeValues.add(v);
                iterator.remove();
                if (!DebugLogger.debugEnabled()) continue;
                TRACER.debugInfo("Removing history value " + v.getStringValue() + " to preserve the history duration.");
            }
            if (!removeValues.isEmpty()) {
                AttributeBuilder builder = new AttributeBuilder(historyType);
                builder.addAll(removeValues);
                removeAttrs.add(builder.toAttribute());
            }
        }
        long newTimestamp = this.currentTime;
        while (historyMap.containsKey(newTimestamp)) {
            ++newTimestamp;
        }
        String newHistStr = GeneralizedTimeSyntax.format(newTimestamp) + "#" + this.passwordPolicy.getPasswordAttribute().getSyntaxOID() + "#" + encodedPassword;
        Attribute newHistAttr = Attributes.create(historyType, newHistStr);
        if (DebugLogger.debugEnabled()) {
            TRACER.debugInfo("Going to add history value " + newHistStr);
        }
        if (this.updateEntry) {
            LinkedList<AttributeValue> valueList = new LinkedList<AttributeValue>();
            for (Attribute a : removeAttrs) {
                this.userEntry.removeAttribute(a, valueList);
            }
            this.userEntry.addAttribute(newHistAttr, valueList);
        } else {
            for (Attribute a : removeAttrs) {
                this.modifications.add(new Modification(ModificationType.DELETE, a, true));
            }
            this.modifications.add(new Modification(ModificationType.ADD, newHistAttr, true));
        }
    }

    public String[] getPasswordHistoryValues() {
        ArrayList<String> historyValues = new ArrayList<String>();
        AttributeType historyType = DirectoryServer.getAttributeType("pwdhistory", true);
        List<Attribute> attrList = this.userEntry.getAttribute(historyType);
        if (attrList != null) {
            for (Attribute a : attrList) {
                for (AttributeValue v : a) {
                    historyValues.add(v.getStringValue());
                }
            }
        }
        String[] historyArray = new String[historyValues.size()];
        return historyValues.toArray(historyArray);
    }

    public void clearPasswordHistory() {
        if (DebugLogger.debugEnabled()) {
            TRACER.debugInfo("Clearing password history for user %s", this.userDNString);
        }
        AttributeType type = DirectoryServer.getAttributeType("pwdhistory", true);
        if (this.updateEntry) {
            this.userEntry.removeAttribute(type);
        } else {
            this.modifications.add(new Modification(ModificationType.REPLACE, Attributes.empty(type), true));
        }
    }

    public ByteString generatePassword() throws DirectoryException {
        PasswordGenerator<?> generator = this.passwordPolicy.getPasswordGenerator();
        if (generator == null) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugWarning("Unable to generate a new password for user %s because no password generator has been defined in the associated password policy.", this.userDNString);
            }
            return null;
        }
        return generator.generatePassword(this.userEntry);
    }

    public void generateAccountStatusNotification(AccountStatusNotificationType notificationType, Entry userEntry, Message message, Map<AccountStatusNotificationProperty, List<String>> notificationProperties) {
        this.generateAccountStatusNotification(new AccountStatusNotification(notificationType, userEntry, message, notificationProperties));
    }

    public void generateAccountStatusNotification(AccountStatusNotification notification) {
        Collection<AccountStatusNotificationHandler<?>> handlers = this.passwordPolicy.getAccountStatusNotificationHandlers().values();
        if (handlers == null || handlers.isEmpty()) {
            return;
        }
        for (AccountStatusNotificationHandler<?> handler : handlers) {
            handler.handleStatusNotification(notification);
        }
    }

    public List<Modification> getModifications() {
        return this.modifications;
    }

    public void updateUserEntry() throws DirectoryException {
        if (this.modifications.isEmpty()) {
            return;
        }
        ArrayList<RawModification> modList = new ArrayList<RawModification>();
        for (Modification m : this.modifications) {
            modList.add(RawModification.create(m.getModificationType(), new LDAPAttribute(m.getAttribute())));
        }
        InternalClientConnection conn = InternalClientConnection.getRootConnection();
        ModifyOperation internalModify = conn.processModify(new ASN1OctetString(this.userDNString), modList);
        ResultCode resultCode = internalModify.getResultCode();
        if (resultCode != ResultCode.SUCCESS) {
            Message message = CoreMessages.ERR_PWPSTATE_CANNOT_UPDATE_USER_ENTRY.get(this.userDNString, String.valueOf(internalModify.getErrorMessage()));
            if (DirectoryServer.isRootDN(this.userEntry.getDN()) || this.passwordPolicy.getStateUpdateFailurePolicy() == PasswordPolicyCfgDefn.StateUpdateFailurePolicy.IGNORE) {
                ErrorLogger.logError(message);
            } else {
                throw new DirectoryException(resultCode, message);
            }
        }
    }
}

