/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.core.networkgroups;

import java.net.InetAddress;
import java.util.Collection;
import java.util.HashSet;
import org.opends.server.api.ClientConnection;
import org.opends.server.core.networkgroups.NetworkGroupCriterion;
import org.opends.server.types.AddressMask;
import org.opends.server.types.AuthenticationType;
import org.opends.server.types.DN;

public class IpFilterCriteria
implements NetworkGroupCriterion {
    private Collection<AddressMask> ipFilters = new HashSet<AddressMask>();

    public void addIpFilter(AddressMask filter) {
        this.ipFilters.add(filter);
    }

    public boolean match(ClientConnection connection) {
        InetAddress ipAddr = connection.getRemoteAddress();
        return AddressMask.maskListContains(ipAddr.getAddress(), ipAddr.getCanonicalHostName(), this.ipFilters.toArray(new AddressMask[0]));
    }

    public boolean matchAfterBind(ClientConnection connection, DN bindDN, AuthenticationType authType, boolean isSecure) {
        return this.match(connection);
    }
}

