/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.core.networkgroups;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import org.opends.messages.CoreMessages;
import org.opends.messages.Message;
import org.opends.server.admin.std.meta.NetworkGroupResourceLimitsCfgDefn;
import org.opends.server.api.ClientConnection;
import org.opends.server.core.RootDseWorkflowTopology;
import org.opends.server.core.Workflow;
import org.opends.server.core.WorkflowImpl;
import org.opends.server.core.WorkflowTopology;
import org.opends.server.core.WorkflowTopologyNode;
import org.opends.server.core.networkgroups.NetworkGroupCriteria;
import org.opends.server.core.networkgroups.NetworkGroupNamingContexts;
import org.opends.server.core.networkgroups.NetworkGroupStatistics;
import org.opends.server.core.networkgroups.RequestFilteringPolicy;
import org.opends.server.core.networkgroups.RequestFilteringPolicyStat;
import org.opends.server.core.networkgroups.ResourceLimits;
import org.opends.server.core.networkgroups.ResourceLimitsStat;
import org.opends.server.protocols.ldap.LDAPMessage;
import org.opends.server.types.AuthenticationType;
import org.opends.server.types.DN;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.ResultCode;
import org.opends.server.types.operation.PreParseOperation;
import org.opends.server.util.Validator;
import org.opends.server.workflowelement.WorkflowElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NetworkGroup {
    private TreeMap<String, WorkflowTopologyNode> registeredWorkflowNodes = new TreeMap();
    private Object registeredWorkflowNodesLock = new Object();
    private RootDseWorkflowTopology rootDSEWorkflowNode = null;
    private NetworkGroupNamingContexts namingContexts = new NetworkGroupNamingContexts();
    private static final String DEFAULT_NETWORK_GROUP_NAME = "default";
    private final boolean isDefaultNetworkGroup;
    private static NetworkGroup defaultNetworkGroup = new NetworkGroup("default");
    private static final String ADMIN_NETWORK_GROUP_NAME = "admin";
    private final boolean isAdminNetworkGroup;
    private static NetworkGroup adminNetworkGroup = new NetworkGroup("admin");
    private static final String INTERNAL_NETWORK_GROUP_NAME = "internal";
    private boolean isInternalNetworkGroup;
    private static NetworkGroup internalNetworkGroup = new NetworkGroup("internal");
    private static TreeMap<String, NetworkGroup> registeredNetworkGroups = new TreeMap();
    private static Object registeredNetworkGroupsLock = new Object();
    private static List<NetworkGroup> orderedNetworkGroups = new ArrayList<NetworkGroup>();
    private String networkGroupID = null;
    private int priority = 100;
    private NetworkGroupCriteria criteria = null;
    private ResourceLimits resourceLimits = null;
    private RequestFilteringPolicy requestFilteringPolicy = null;
    private NetworkGroupStatistics stats;

    public NetworkGroup(String networkGroupID) {
        this.networkGroupID = networkGroupID;
        this.isInternalNetworkGroup = INTERNAL_NETWORK_GROUP_NAME.equals(networkGroupID);
        this.isAdminNetworkGroup = ADMIN_NETWORK_GROUP_NAME.equals(networkGroupID);
        this.isDefaultNetworkGroup = DEFAULT_NETWORK_GROUP_NAME.equals(networkGroupID);
        this.stats = new NetworkGroupStatistics(this, networkGroupID + " Network Group Statistics");
    }

    public String getID() {
        return this.networkGroupID;
    }

    public void finalizeNetworkGroup() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register() throws DirectoryException {
        Validator.ensureNotNull(this.networkGroupID);
        Object object = registeredNetworkGroupsLock;
        synchronized (object) {
            if (registeredNetworkGroups.containsKey(this.networkGroupID)) {
                Message message = CoreMessages.ERR_REGISTER_NETWORK_GROUP_ALREADY_EXISTS.get(this.networkGroupID);
                throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, message);
            }
            TreeMap<String, NetworkGroup> newRegisteredNetworkGroups = new TreeMap<String, NetworkGroup>((SortedMap<String, NetworkGroup>)registeredNetworkGroups);
            newRegisteredNetworkGroups.put(this.networkGroupID, this);
            registeredNetworkGroups = newRegisteredNetworkGroups;
            int index = 0;
            for (NetworkGroup ng : registeredNetworkGroups.values()) {
                if (ng.equals(this) || this.priority <= ng.priority) continue;
                ++index;
            }
            orderedNetworkGroups.add(index, this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deregister() {
        Object object = registeredNetworkGroupsLock;
        synchronized (object) {
            TreeMap<String, NetworkGroup> networkGroups = new TreeMap<String, NetworkGroup>((SortedMap<String, NetworkGroup>)registeredNetworkGroups);
            networkGroups.remove(this.networkGroupID);
            registeredNetworkGroups = networkGroups;
            orderedNetworkGroups.remove(this);
            this.updateWorkflowReferenceCounters();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateWorkflowReferenceCounters() {
        Object object = this.registeredWorkflowNodesLock;
        synchronized (object) {
            for (WorkflowTopologyNode workflowNode : this.registeredWorkflowNodes.values()) {
                WorkflowImpl workflowImpl = workflowNode.getWorkflowImpl();
                workflowImpl.decrementReferenceCounter();
            }
        }
    }

    public void registerWorkflow(WorkflowImpl workflow) throws DirectoryException {
        this.registerWorkflow(workflow, null, null);
    }

    private void registerWorkflow(WorkflowImpl workflow, WorkflowElement<?>[] preWorkflowElements, WorkflowElement<?>[] postWorkflowElements) throws DirectoryException {
        DN baseDN = workflow.getBaseDN();
        if (baseDN.isNullDN()) {
            this.rootDSEWorkflowNode = new RootDseWorkflowTopology(workflow, this.namingContexts);
        } else {
            WorkflowTopologyNode workflowNode = new WorkflowTopologyNode(workflow, preWorkflowElements, postWorkflowElements);
            this.registerWorkflowNode(workflowNode);
            for (WorkflowTopologyNode curNode : this.registeredWorkflowNodes.values()) {
                if (!curNode.insertSubordinate(workflowNode) && !workflowNode.insertSubordinate(curNode)) continue;
            }
            this.rebuildNamingContextList();
            if (!(this.isAdminNetworkGroup || this.isInternalNetworkGroup || this.isDefaultNetworkGroup)) {
                workflow.incrementReferenceCounter();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Workflow deregisterWorkflow(DN baseDN) {
        WorkflowImpl workflow = null;
        if (baseDN == null) {
            return workflow;
        }
        if (baseDN.isNullDN()) {
            this.deregisterWorkflow(this.rootDSEWorkflowNode);
            workflow = this.rootDSEWorkflowNode.getWorkflowImpl();
        } else {
            Object object = this.registeredWorkflowNodesLock;
            synchronized (object) {
                for (WorkflowTopologyNode node : this.registeredWorkflowNodes.values()) {
                    DN curDN = node.getBaseDN();
                    if (!curDN.equals(baseDN)) continue;
                    this.deregisterWorkflow(node);
                    workflow = node.getWorkflowImpl();
                    break;
                }
            }
        }
        if (!(workflow == null || this.isAdminNetworkGroup || this.isInternalNetworkGroup || this.isDefaultNetworkGroup)) {
            WorkflowImpl workflowImpl = workflow;
            workflowImpl.decrementReferenceCounter();
        }
        return workflow;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Workflow deregisterWorkflow(String workflowID) {
        WorkflowImpl workflow = null;
        String rootDSEWorkflowID = null;
        if (this.rootDSEWorkflowNode != null) {
            rootDSEWorkflowID = this.rootDSEWorkflowNode.getWorkflowImpl().getWorkflowId();
        }
        if (workflowID.equalsIgnoreCase(rootDSEWorkflowID)) {
            this.deregisterWorkflow(this.rootDSEWorkflowNode);
            workflow = this.rootDSEWorkflowNode.getWorkflowImpl();
        } else {
            Object object = this.registeredWorkflowNodesLock;
            synchronized (object) {
                for (WorkflowTopologyNode node : this.registeredWorkflowNodes.values()) {
                    String curID = node.getWorkflowImpl().getWorkflowId();
                    if (!curID.equals(workflowID)) continue;
                    this.deregisterWorkflow(node);
                    workflow = node.getWorkflowImpl();
                    break;
                }
            }
        }
        if (!(workflow == null || this.isAdminNetworkGroup || this.isInternalNetworkGroup || this.isDefaultNetworkGroup)) {
            WorkflowImpl workflowImpl = workflow;
            workflowImpl.decrementReferenceCounter();
        }
        return workflow;
    }

    private boolean deregisterWorkflow(Workflow workflow) {
        boolean deregistered = false;
        if (workflow == this.rootDSEWorkflowNode) {
            this.rootDSEWorkflowNode = null;
            deregistered = true;
        } else {
            WorkflowTopologyNode workflowNode = (WorkflowTopologyNode)workflow;
            this.deregisterWorkflowNode(workflowNode);
            deregistered = true;
            workflowNode.remove();
            this.rebuildNamingContextList();
        }
        return deregistered;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getRegisteredWorkflows() {
        ArrayList<String> workflowIDs = new ArrayList<String>();
        Object object = this.registeredWorkflowNodesLock;
        synchronized (object) {
            for (WorkflowTopologyNode node : this.registeredWorkflowNodes.values()) {
                workflowIDs.add(node.getWorkflowImpl().getWorkflowId());
            }
        }
        return workflowIDs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerWorkflowNode(WorkflowTopologyNode workflowNode) throws DirectoryException {
        String workflowID = workflowNode.getWorkflowImpl().getWorkflowId();
        Validator.ensureNotNull(workflowID);
        Object object = this.registeredWorkflowNodesLock;
        synchronized (object) {
            if (this.registeredWorkflowNodes.containsKey(workflowID)) {
                Message message = CoreMessages.ERR_REGISTER_WORKFLOW_NODE_ALREADY_EXISTS.get(workflowID, this.networkGroupID);
                throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, message);
            }
            this.checkWorkflowBaseDN(workflowNode);
            TreeMap<String, WorkflowTopologyNode> newRegisteredWorkflowNodes = new TreeMap<String, WorkflowTopologyNode>((SortedMap<String, WorkflowTopologyNode>)this.registeredWorkflowNodes);
            newRegisteredWorkflowNodes.put(workflowID, workflowNode);
            this.registeredWorkflowNodes = newRegisteredWorkflowNodes;
        }
    }

    private void checkWorkflowBaseDN(WorkflowTopologyNode workflowNode) throws DirectoryException {
        String workflowID = workflowNode.getWorkflowImpl().getWorkflowId();
        Validator.ensureNotNull(workflowID);
        if (this.isInternalNetworkGroup) {
            return;
        }
        if (this.isAdminNetworkGroup) {
            return;
        }
        for (WorkflowTopologyNode node : this.registeredWorkflowNodes.values()) {
            DN nodeBaseDN = node.getBaseDN();
            if (!nodeBaseDN.equals(workflowNode.getBaseDN())) continue;
            Message message = CoreMessages.ERR_REGISTER_WORKFLOW_BASE_DN_ALREADY_EXISTS.get(workflowID, this.networkGroupID, node.getWorkflowImpl().getWorkflowId(), workflowNode.getWorkflowImpl().getBaseDN().toString());
            throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deregisterWorkflowNode(WorkflowTopologyNode workflowNode) {
        Object object = this.registeredWorkflowNodesLock;
        synchronized (object) {
            TreeMap<String, WorkflowTopologyNode> newWorkflowNodes = new TreeMap<String, WorkflowTopologyNode>((SortedMap<String, WorkflowTopologyNode>)this.registeredWorkflowNodes);
            newWorkflowNodes.remove(workflowNode.getWorkflowImpl().getWorkflowId());
            this.registeredWorkflowNodes = newWorkflowNodes;
        }
    }

    public void addConnection(ClientConnection connection) {
        if (this.resourceLimits != null) {
            this.resourceLimits.addConnection(connection);
        }
    }

    public void removeConnection(ClientConnection connection) {
        if (this.resourceLimits != null) {
            this.resourceLimits.removeConnection(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNetworkGroupPriority(int prio) {
        if (this.priority != prio) {
            Object object = registeredNetworkGroupsLock;
            synchronized (object) {
                this.priority = prio;
                if (registeredNetworkGroups.containsKey(this.networkGroupID)) {
                    orderedNetworkGroups.remove(this);
                    int index = 0;
                    for (NetworkGroup ng : registeredNetworkGroups.values()) {
                        if (ng.equals(this) || this.priority <= ng.priority) continue;
                        ++index;
                    }
                    orderedNetworkGroups.add(index, this);
                }
            }
        }
    }

    public void setCriteria(NetworkGroupCriteria ngCriteria) {
        this.criteria = ngCriteria;
    }

    public void setResourceLimits(ResourceLimits limits) {
        this.resourceLimits = limits;
    }

    public void setRequestFilteringPolicy(RequestFilteringPolicy policy) {
        this.requestFilteringPolicy = policy;
    }

    public static NetworkGroup findMatchingNetworkGroup(ClientConnection connection) {
        for (NetworkGroup ng : NetworkGroup.getOrderedNetworkGroups()) {
            if (!ng.match(connection)) continue;
            return ng;
        }
        return defaultNetworkGroup;
    }

    public static NetworkGroup findBindMatchingNetworkGroup(ClientConnection connection, DN dn, AuthenticationType authType, boolean isSecure) {
        for (NetworkGroup ng : NetworkGroup.getOrderedNetworkGroups()) {
            if (!ng.matchAfterBind(connection, dn, authType, isSecure)) continue;
            return ng;
        }
        return defaultNetworkGroup;
    }

    private boolean match(ClientConnection connection) {
        if (this.criteria != null) {
            return this.criteria.match(connection);
        }
        return true;
    }

    private boolean matchAfterBind(ClientConnection connection, DN bindDN, AuthenticationType authType, boolean isSecure) {
        if (this.criteria != null) {
            return this.criteria.matchAfterBind(connection, bindDN, authType, isSecure);
        }
        return true;
    }

    public boolean checkResourceLimits(ClientConnection connection, PreParseOperation operation, boolean fullCheck, List<Message> messages) {
        if (this.resourceLimits != null) {
            return this.resourceLimits.checkLimits(connection, operation, fullCheck, messages);
        }
        return true;
    }

    public int getSearchSizeLimit() {
        if (this.resourceLimits != null) {
            return this.resourceLimits.getSizeLimit();
        }
        return -1;
    }

    public int getSearchDurationLimit() {
        if (this.resourceLimits != null) {
            return this.resourceLimits.getTimeLimit();
        }
        return -1;
    }

    public int getMinSubstring() {
        if (this.resourceLimits != null) {
            return this.resourceLimits.getMinSubstring();
        }
        return 0;
    }

    public NetworkGroupResourceLimitsCfgDefn.ReferralPolicy getReferralPolicy() {
        if (this.resourceLimits != null) {
            return this.resourceLimits.getReferralPolicy();
        }
        return NetworkGroupResourceLimitsCfgDefn.ReferralPolicy.FORWARD;
    }

    public NetworkGroupResourceLimitsCfgDefn.ReferralBindPolicy getReferralBindPolicy() {
        if (this.resourceLimits != null) {
            return this.resourceLimits.getReferralBindPolicy();
        }
        return NetworkGroupResourceLimitsCfgDefn.ReferralBindPolicy.ANONYMOUS;
    }

    public int getReferralHopLimit() {
        if (this.resourceLimits != null) {
            return this.resourceLimits.getReferralHopLimit();
        }
        return 0;
    }

    public boolean checkRequestFilteringPolicy(PreParseOperation operation, List<Message> messages) {
        if (this.requestFilteringPolicy != null) {
            return this.requestFilteringPolicy.checkPolicy(operation, messages);
        }
        return true;
    }

    public Workflow getWorkflowCandidate(DN baseDN) {
        WorkflowTopology workflowCandidate = null;
        if (baseDN.isNullDN()) {
            workflowCandidate = this.rootDSEWorkflowNode;
        } else {
            WorkflowTopologyNode curWorkflow;
            Iterator<WorkflowTopologyNode> i$ = this.namingContexts.getNamingContexts().iterator();
            while (i$.hasNext() && (workflowCandidate = (curWorkflow = i$.next()).getWorkflowCandidate(baseDN)) == null) {
            }
        }
        return workflowCandidate;
    }

    public static NetworkGroup getDefaultNetworkGroup() {
        return defaultNetworkGroup;
    }

    public static NetworkGroup getAdminNetworkGroup() {
        return adminNetworkGroup;
    }

    public static NetworkGroup getInternalNetworkGroup() {
        return internalNetworkGroup;
    }

    private void rebuildNamingContextList() {
        this.namingContexts.resetLists();
        for (WorkflowTopologyNode workflowNode : this.registeredWorkflowNodes.values()) {
            WorkflowTopologyNode parent = workflowNode.getParent();
            if (parent != null) continue;
            this.namingContexts.addNamingContext(workflowNode);
        }
    }

    public NetworkGroupNamingContexts getNamingContexts() {
        return this.namingContexts;
    }

    public StringBuilder toString(String leftMargin) {
        StringBuilder sb = new StringBuilder();
        String newMargin = leftMargin + "   ";
        sb.append(leftMargin + "Networkgroup (" + this.networkGroupID + "\n");
        sb.append(leftMargin + "List of registered workflows:\n");
        for (WorkflowTopologyNode node : this.registeredWorkflowNodes.values()) {
            sb.append((CharSequence)node.toString(newMargin));
        }
        this.namingContexts.toString(leftMargin);
        sb.append(leftMargin + "rootDSEWorkflow:\n");
        if (this.rootDSEWorkflowNode == null) {
            sb.append(newMargin + "null\n");
        } else {
            sb.append((CharSequence)this.rootDSEWorkflowNode.toString(newMargin));
        }
        return sb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deregisterAllOnShutdown() {
        Object object = registeredNetworkGroupsLock;
        synchronized (object) {
            Collection<NetworkGroup> networkGroups = registeredNetworkGroups.values();
            for (NetworkGroup networkGroup : networkGroups) {
                networkGroup.invalidate();
            }
            defaultNetworkGroup.invalidate();
            adminNetworkGroup.invalidate();
            internalNetworkGroup.invalidate();
            registeredNetworkGroups = new TreeMap();
            orderedNetworkGroups = new ArrayList<NetworkGroup>();
            defaultNetworkGroup = new NetworkGroup(DEFAULT_NETWORK_GROUP_NAME);
            adminNetworkGroup = new NetworkGroup(ADMIN_NETWORK_GROUP_NAME);
            internalNetworkGroup = new NetworkGroup(INTERNAL_NETWORK_GROUP_NAME);
        }
    }

    private void invalidate() {
        this.namingContexts = null;
        this.networkGroupID = null;
        this.rootDSEWorkflowNode = null;
        this.registeredWorkflowNodes = null;
    }

    public static Collection<NetworkGroup> getRegisteredNetworkGroups() {
        return registeredNetworkGroups.values();
    }

    private static List<NetworkGroup> getOrderedNetworkGroups() {
        return orderedNetworkGroups;
    }

    public static NetworkGroup getNetworkGroup(String networkGroupId) {
        return registeredNetworkGroups.get(networkGroupId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void resetConfig() {
        defaultNetworkGroup.reset();
        adminNetworkGroup.reset();
        internalNetworkGroup.reset();
        Object object = registeredNetworkGroupsLock;
        synchronized (object) {
            registeredNetworkGroups = new TreeMap();
            orderedNetworkGroups = new ArrayList<NetworkGroup>();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        Object object = this.registeredWorkflowNodesLock;
        synchronized (object) {
            this.registeredWorkflowNodes = new TreeMap();
            this.rootDSEWorkflowNode = null;
            this.namingContexts = new NetworkGroupNamingContexts();
        }
    }

    public RequestFilteringPolicyStat getRequestFilteringPolicyStat() {
        if (this.requestFilteringPolicy != null) {
            return this.requestFilteringPolicy.getStat();
        }
        return null;
    }

    public ResourceLimitsStat getResourceLimitStat() {
        if (this.resourceLimits != null) {
            return this.resourceLimits.getStat();
        }
        return null;
    }

    public void updateMessageRead(LDAPMessage message) {
        this.stats.updateMessageRead(message);
    }
}

