/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.core.networkgroups;

import java.util.ArrayList;
import java.util.Collection;
import org.opends.server.admin.std.meta.NetworkGroupCriteriaCfgDefn;
import org.opends.server.api.ClientConnection;
import org.opends.server.core.networkgroups.NetworkGroupCriterion;
import org.opends.server.types.AuthenticationType;
import org.opends.server.types.DN;

public class PortCriteria
implements NetworkGroupCriterion {
    private Collection<String> allowedPorts = new ArrayList<String>();

    public void addPort(NetworkGroupCriteriaCfgDefn.AllowedLDAPPort port) {
        if (port.toString().equals("ldap")) {
            this.allowedPorts.add("LDAP");
        } else if (port.toString().equals("ldaps")) {
            this.allowedPorts.add("LDAP+SSL");
        }
    }

    public boolean match(ClientConnection connection) {
        String connectionPort = connection.getConnectionHandler().getProtocol();
        for (String port : this.allowedPorts) {
            if (!connectionPort.equalsIgnoreCase(port)) continue;
            return true;
        }
        return false;
    }

    public boolean matchAfterBind(ClientConnection connection, DN bindDN, AuthenticationType authType, boolean isSecure) {
        return this.match(connection);
    }
}

