/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.core.networkgroups;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.opends.messages.ConfigMessages;
import org.opends.messages.CoreMessages;
import org.opends.messages.Message;
import org.opends.server.admin.server.ConfigurationAddListener;
import org.opends.server.admin.server.ConfigurationChangeListener;
import org.opends.server.admin.server.ConfigurationDeleteListener;
import org.opends.server.admin.std.meta.NetworkGroupRequestFilteringPolicyCfgDefn;
import org.opends.server.admin.std.server.NetworkGroupRequestFilteringPolicyCfg;
import org.opends.server.core.networkgroups.RequestFilteringPolicyStat;
import org.opends.server.types.ConfigChangeResult;
import org.opends.server.types.DN;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.OperationType;
import org.opends.server.types.RawFilter;
import org.opends.server.types.ResultCode;
import org.opends.server.types.operation.PreParseAddOperation;
import org.opends.server.types.operation.PreParseCompareOperation;
import org.opends.server.types.operation.PreParseDeleteOperation;
import org.opends.server.types.operation.PreParseModifyDNOperation;
import org.opends.server.types.operation.PreParseModifyOperation;
import org.opends.server.types.operation.PreParseOperation;
import org.opends.server.types.operation.PreParseSearchOperation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RequestFilteringPolicy
implements ConfigurationAddListener<NetworkGroupRequestFilteringPolicyCfg>,
ConfigurationDeleteListener<NetworkGroupRequestFilteringPolicyCfg>,
ConfigurationChangeListener<NetworkGroupRequestFilteringPolicyCfg> {
    private boolean isConfigured = false;
    Set<NetworkGroupRequestFilteringPolicyCfgDefn.AllowedOperations> allowedOperations = null;
    Set<String> allowedAttributes = null;
    Set<String> prohibitedAttributes = null;
    Set<NetworkGroupRequestFilteringPolicyCfgDefn.AllowedSearchScopes> allowedSearchScopes = null;
    Set<DN> allowedSubtrees = null;
    Set<DN> prohibitedSubtrees = null;
    private RequestFilteringPolicyStat stat = new RequestFilteringPolicyStat();
    NetworkGroupRequestFilteringPolicyCfg config = null;

    public RequestFilteringPolicy(NetworkGroupRequestFilteringPolicyCfg policyCfg) {
        this.createPolicy(policyCfg);
    }

    private void resetPolicy() {
        this.allowedOperations = Collections.emptySet();
        this.allowedAttributes = Collections.emptySet();
        this.prohibitedAttributes = Collections.emptySet();
        this.allowedSearchScopes = Collections.emptySet();
        this.allowedSubtrees = Collections.emptySet();
        this.prohibitedSubtrees = Collections.emptySet();
        this.isConfigured = false;
        if (this.config != null) {
            this.config.removeChangeListener(this);
        }
        this.config = null;
    }

    private void createPolicy(NetworkGroupRequestFilteringPolicyCfg policyCfg) {
        if (policyCfg != null) {
            this.allowedOperations = policyCfg.getAllowedOperations();
            this.allowedAttributes = policyCfg.getAllowedAttributes();
            this.prohibitedAttributes = policyCfg.getProhibitedAttributes();
            this.allowedSearchScopes = policyCfg.getAllowedSearchScopes();
            this.allowedSubtrees = policyCfg.getAllowedSubtrees();
            this.prohibitedSubtrees = policyCfg.getProhibitedSubtrees();
            if (this.config == null) {
                policyCfg.addChangeListener(this);
            }
            this.config = policyCfg;
            this.isConfigured = true;
        } else {
            this.resetPolicy();
        }
    }

    public RequestFilteringPolicyStat getStat() {
        return this.stat;
    }

    public void setAllowedOperations(Set<NetworkGroupRequestFilteringPolicyCfgDefn.AllowedOperations> allowedOps) {
        this.allowedOperations = allowedOps == null ? Collections.emptySet() : allowedOps;
    }

    public void setAllowedAttributes(Set<String> allowedAttrs) {
        this.allowedAttributes = allowedAttrs == null ? Collections.emptySet() : allowedAttrs;
    }

    public void setProhibitedAttributes(Set<String> prohibitedAttrs) {
        this.prohibitedAttributes = prohibitedAttrs == null ? Collections.emptySet() : prohibitedAttrs;
    }

    public void setAllowedSearchScopes(Set<NetworkGroupRequestFilteringPolicyCfgDefn.AllowedSearchScopes> allowedScopes) {
        this.allowedSearchScopes = allowedScopes == null ? Collections.emptySet() : allowedScopes;
    }

    public void setAllowedSubtrees(Set<DN> allowedSubt) {
        this.allowedSubtrees = allowedSubt == null ? Collections.emptySet() : allowedSubt;
    }

    public void setProhibitedSubtrees(Set<DN> prohibitedSubt) {
        this.prohibitedSubtrees = prohibitedSubt == null ? Collections.emptySet() : prohibitedSubt;
    }

    public boolean checkPolicy(PreParseOperation operation, List<Message> messages) {
        boolean result = true;
        if (!this.allowedOperations.isEmpty()) {
            switch (operation.getOperationType()) {
                case ABANDON: {
                    result = true;
                    break;
                }
                case ADD: {
                    result = this.allowedOperations.contains((Object)NetworkGroupRequestFilteringPolicyCfgDefn.AllowedOperations.ADD);
                    break;
                }
                case BIND: {
                    result = this.allowedOperations.contains((Object)NetworkGroupRequestFilteringPolicyCfgDefn.AllowedOperations.BIND);
                    break;
                }
                case COMPARE: {
                    result = this.allowedOperations.contains((Object)NetworkGroupRequestFilteringPolicyCfgDefn.AllowedOperations.COMPARE);
                    break;
                }
                case DELETE: {
                    result = this.allowedOperations.contains((Object)NetworkGroupRequestFilteringPolicyCfgDefn.AllowedOperations.DELETE);
                    break;
                }
                case EXTENDED: {
                    result = this.allowedOperations.contains((Object)NetworkGroupRequestFilteringPolicyCfgDefn.AllowedOperations.EXTENDED);
                    break;
                }
                case MODIFY: {
                    result = this.allowedOperations.contains((Object)NetworkGroupRequestFilteringPolicyCfgDefn.AllowedOperations.MODIFY);
                    break;
                }
                case MODIFY_DN: {
                    result = this.allowedOperations.contains((Object)NetworkGroupRequestFilteringPolicyCfgDefn.AllowedOperations.RENAME);
                    break;
                }
                case SEARCH: {
                    result = this.allowedOperations.contains((Object)NetworkGroupRequestFilteringPolicyCfgDefn.AllowedOperations.SEARCH);
                    if (!result || this.allowedOperations.contains((Object)NetworkGroupRequestFilteringPolicyCfgDefn.AllowedOperations.INEQUALITY_SEARCH)) break;
                    RawFilter flt = ((PreParseSearchOperation)operation).getRawFilter();
                    result = !this.containsInequalitySearch(flt);
                    break;
                }
                case UNBIND: {
                    result = true;
                }
            }
            if (!result) {
                this.stat.updateRejectedOperations();
                messages.add(CoreMessages.INFO_ERROR_OPERATION_NOT_ALLOWED.get());
                return result;
            }
        }
        if (operation.getOperationType().equals((Object)OperationType.SEARCH)) {
            PreParseSearchOperation searchOp = (PreParseSearchOperation)operation;
            if (!this.prohibitedAttributes.isEmpty()) {
                boolean bl = result = !this.containsProhibitedAttribute(searchOp.getRawFilter());
            }
            if (!result) {
                this.stat.updateRejectedAttributes();
                messages.add(CoreMessages.INFO_ERROR_ATTRIBUTE_NOT_ALLOWED.get());
                return result;
            }
            if (!this.allowedAttributes.isEmpty()) {
                result = this.containsOnlyAllowedAttributes(searchOp.getRawFilter());
            }
            if (!result) {
                this.stat.updateRejectedAttributes();
                messages.add(CoreMessages.INFO_ERROR_ATTRIBUTE_NOT_ALLOWED.get());
                return result;
            }
            if (!this.allowedSearchScopes.isEmpty()) {
                switch (searchOp.getScope()) {
                    case BASE_OBJECT: {
                        result = this.allowedSearchScopes.contains((Object)NetworkGroupRequestFilteringPolicyCfgDefn.AllowedSearchScopes.BASE);
                        break;
                    }
                    case SINGLE_LEVEL: {
                        result = this.allowedSearchScopes.contains((Object)NetworkGroupRequestFilteringPolicyCfgDefn.AllowedSearchScopes.ONE);
                        break;
                    }
                    case WHOLE_SUBTREE: {
                        result = this.allowedSearchScopes.contains((Object)NetworkGroupRequestFilteringPolicyCfgDefn.AllowedSearchScopes.SUB);
                        break;
                    }
                    case SUBORDINATE_SUBTREE: {
                        result = this.allowedSearchScopes.contains((Object)NetworkGroupRequestFilteringPolicyCfgDefn.AllowedSearchScopes.CHILDREN);
                    }
                }
                if (!result) {
                    this.stat.updateRejectedScopes();
                    messages.add(CoreMessages.INFO_ERROR_SEARCH_SCOPE_NOT_ALLOWED.get());
                    return result;
                }
            }
        }
        if (operation.getOperationType().equals((Object)OperationType.COMPARE)) {
            PreParseCompareOperation compareOp = (PreParseCompareOperation)operation;
            if (!this.prohibitedAttributes.isEmpty()) {
                boolean bl = result = !this.prohibitedAttributes.contains(compareOp.getRawAttributeType());
            }
            if (!result) {
                this.stat.updateRejectedAttributes();
                messages.add(CoreMessages.INFO_ERROR_ATTRIBUTE_NOT_ALLOWED.get());
                return result;
            }
            if (!this.allowedAttributes.isEmpty()) {
                result = this.allowedAttributes.contains(compareOp.getRawAttributeType());
            }
            if (!result) {
                this.stat.updateRejectedAttributes();
                messages.add(CoreMessages.INFO_ERROR_ATTRIBUTE_NOT_ALLOWED.get());
                return result;
            }
        }
        DN entryDN = null;
        DN newEntryDN = null;
        try {
            switch (operation.getOperationType()) {
                case ADD: {
                    entryDN = DN.decode(((PreParseAddOperation)operation).getRawEntryDN());
                    break;
                }
                case COMPARE: {
                    entryDN = DN.decode(((PreParseCompareOperation)operation).getRawEntryDN());
                    break;
                }
                case DELETE: {
                    entryDN = DN.decode(((PreParseDeleteOperation)operation).getRawEntryDN());
                    break;
                }
                case EXTENDED: {
                    break;
                }
                case MODIFY: {
                    entryDN = DN.decode(((PreParseModifyOperation)operation).getRawEntryDN());
                    break;
                }
                case MODIFY_DN: {
                    entryDN = DN.decode(((PreParseModifyDNOperation)operation).getRawEntryDN());
                    newEntryDN = DN.decode(((PreParseModifyDNOperation)operation).getRawNewRDN());
                    break;
                }
                case SEARCH: {
                    entryDN = DN.decode(((PreParseSearchOperation)operation).getRawBaseDN());
                    break;
                }
            }
            if (entryDN != null) {
                boolean bl = result = this.isInAllowedSubtrees(entryDN) && !this.isInProhibitedSubtrees(entryDN);
            }
            if (newEntryDN != null) {
                result = this.isInAllowedSubtrees(newEntryDN) && !this.isInProhibitedSubtrees(newEntryDN);
            }
        }
        catch (DirectoryException ex) {
            Logger.getLogger(RequestFilteringPolicy.class.getName()).log(Level.SEVERE, null, ex);
        }
        if (!result) {
            this.stat.updateRejectedSubtrees();
            messages.add(CoreMessages.INFO_ERROR_SUBTREE_NOT_ALLOWED.get());
            return result;
        }
        return true;
    }

    private boolean containsInequalitySearch(RawFilter filter) {
        boolean result = false;
        switch (filter.getFilterType()) {
            case AND: 
            case OR: {
                ArrayList<RawFilter> filterComponents = filter.getFilterComponents();
                if (filterComponents != null) {
                    for (RawFilter element : filterComponents) {
                        if (!this.containsInequalitySearch(element)) continue;
                        return true;
                    }
                }
                return false;
            }
            case NOT: {
                return this.containsInequalitySearch(filter.getNOTComponent());
            }
            case GREATER_OR_EQUAL: 
            case LESS_OR_EQUAL: {
                return true;
            }
        }
        return false;
    }

    private boolean containsProhibitedAttribute(RawFilter filter) {
        boolean result = false;
        switch (filter.getFilterType()) {
            case AND: 
            case OR: {
                ArrayList<RawFilter> filterComponents = filter.getFilterComponents();
                if (filterComponents != null) {
                    for (RawFilter element : filterComponents) {
                        if (!this.containsProhibitedAttribute(element)) continue;
                        return true;
                    }
                }
                return false;
            }
            case NOT: {
                return this.containsProhibitedAttribute(filter.getNOTComponent());
            }
        }
        return this.prohibitedAttributes.contains(filter.getAttributeType());
    }

    private boolean containsOnlyAllowedAttributes(RawFilter filter) {
        switch (filter.getFilterType()) {
            case AND: 
            case OR: {
                ArrayList<RawFilter> filterComponents = filter.getFilterComponents();
                if (filterComponents != null) {
                    for (RawFilter element : filterComponents) {
                        if (this.containsOnlyAllowedAttributes(element)) continue;
                        return false;
                    }
                }
                return true;
            }
            case NOT: {
                return this.containsOnlyAllowedAttributes(filter.getNOTComponent());
            }
        }
        return this.allowedAttributes.contains(filter.getAttributeType());
    }

    private boolean isInAllowedSubtrees(DN dn) {
        boolean result = false;
        if (this.allowedSubtrees.isEmpty()) {
            return true;
        }
        for (DN branch : this.allowedSubtrees) {
            if (!dn.isDescendantOf(branch)) continue;
            result = true;
            break;
        }
        return result;
    }

    private boolean isInProhibitedSubtrees(DN dn) {
        boolean result = false;
        for (DN branch : this.prohibitedSubtrees) {
            if (!dn.isDescendantOf(branch)) continue;
            result = true;
            break;
        }
        return result;
    }

    @Override
    public boolean isConfigurationAddAcceptable(NetworkGroupRequestFilteringPolicyCfg configuration, List<Message> unacceptableReasons) {
        if (this.isConfigured) {
            return false;
        }
        return this.isConfigurationChangeAcceptable(configuration, unacceptableReasons);
    }

    @Override
    public ConfigChangeResult applyConfigurationAdd(NetworkGroupRequestFilteringPolicyCfg configuration) {
        ResultCode resultCode = ResultCode.SUCCESS;
        boolean adminActionRequired = false;
        ArrayList<Message> messages = new ArrayList<Message>();
        ConfigChangeResult configChangeResult = new ConfigChangeResult(resultCode, adminActionRequired, messages);
        this.createPolicy(configuration);
        return configChangeResult;
    }

    @Override
    public boolean isConfigurationDeleteAcceptable(NetworkGroupRequestFilteringPolicyCfg configuration, List<Message> unacceptableReasons) {
        return this.isConfigured;
    }

    @Override
    public ConfigChangeResult applyConfigurationDelete(NetworkGroupRequestFilteringPolicyCfg configuration) {
        ResultCode resultCode = ResultCode.SUCCESS;
        boolean adminActionRequired = false;
        ArrayList<Message> messages = new ArrayList<Message>();
        ConfigChangeResult configChangeResult = new ConfigChangeResult(resultCode, adminActionRequired, messages);
        this.resetPolicy();
        return configChangeResult;
    }

    @Override
    public boolean isConfigurationChangeAcceptable(NetworkGroupRequestFilteringPolicyCfg configuration, List<Message> unacceptableReasons) {
        if (configuration != null) {
            for (String allowedAttr : configuration.getAllowedAttributes()) {
                if (!configuration.getProhibitedAttributes().contains(allowedAttr)) continue;
                unacceptableReasons.add(ConfigMessages.ERR_CONFIG_NETWORKGROUPREQUESTFILTERINGPOLICY_INVALID_ATTRIBUTE.get(allowedAttr, configuration.dn().toString()));
                return false;
            }
            for (DN allowedSubtree : configuration.getAllowedSubtrees()) {
                if (!configuration.getProhibitedSubtrees().contains(allowedSubtree)) continue;
                unacceptableReasons.add(ConfigMessages.ERR_CONFIG_NETWORKGROUPREQUESTFILTERINGPOLICY_INVALID_SUBTREE.get(allowedSubtree.toString(), configuration.dn().toString()));
                return false;
            }
        }
        return true;
    }

    @Override
    public ConfigChangeResult applyConfigurationChange(NetworkGroupRequestFilteringPolicyCfg configuration) {
        ResultCode resultCode = ResultCode.SUCCESS;
        boolean adminActionRequired = false;
        ArrayList<Message> messages = new ArrayList<Message>();
        ConfigChangeResult configChangeResult = new ConfigChangeResult(resultCode, adminActionRequired, messages);
        this.createPolicy(configuration);
        return configChangeResult;
    }
}

