/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.extensions;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.opends.messages.ExtensionMessages;
import org.opends.messages.Message;
import org.opends.server.admin.std.server.StaticGroupImplementationCfg;
import org.opends.server.api.ClientConnection;
import org.opends.server.api.Group;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.ModifyOperationBasis;
import org.opends.server.extensions.FilteredStaticGroupMemberList;
import org.opends.server.extensions.SimpleStaticGroupMemberList;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.protocols.internal.InternalClientConnection;
import org.opends.server.types.Attribute;
import org.opends.server.types.AttributeType;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.Attributes;
import org.opends.server.types.Control;
import org.opends.server.types.DN;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DirectoryConfig;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.Entry;
import org.opends.server.types.InitializationException;
import org.opends.server.types.MemberList;
import org.opends.server.types.MembershipException;
import org.opends.server.types.Modification;
import org.opends.server.types.ModificationType;
import org.opends.server.types.ObjectClass;
import org.opends.server.types.ResultCode;
import org.opends.server.types.SearchFilter;
import org.opends.server.types.SearchScope;
import org.opends.server.util.Validator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StaticGroup
extends Group<StaticGroupImplementationCfg> {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private AttributeType memberAttributeType;
    private DN groupEntryDN;
    private LinkedHashSet<DN> memberDNs;
    private LinkedList<DN> nestedGroups = new LinkedList();
    private long nestedGroupRefreshToken = DirectoryServer.getGroupManager().refreshToken();

    public StaticGroup() {
    }

    public StaticGroup(DN groupEntryDN, AttributeType memberAttributeType, LinkedHashSet<DN> memberDNs) {
        Validator.ensureNotNull(groupEntryDN, memberAttributeType, memberDNs);
        this.groupEntryDN = groupEntryDN;
        this.memberAttributeType = memberAttributeType;
        this.memberDNs = memberDNs;
    }

    @Override
    public void initializeGroupImplementation(StaticGroupImplementationCfg configuration) throws ConfigException, InitializationException {
    }

    @Override
    public StaticGroup newInstance(Entry groupEntry) throws DirectoryException {
        AttributeType memberAttributeType;
        Validator.ensureNotNull(groupEntry);
        ObjectClass groupOfEntriesClass = DirectoryConfig.getObjectClass("groupofentries", true);
        ObjectClass groupOfNamesClass = DirectoryConfig.getObjectClass("groupofnames", true);
        ObjectClass groupOfUniqueNamesClass = DirectoryConfig.getObjectClass("groupofuniquenames", true);
        if (groupEntry.hasObjectClass(groupOfEntriesClass)) {
            if (groupEntry.hasObjectClass(groupOfNamesClass)) {
                Message message = ExtensionMessages.ERR_STATICGROUP_INVALID_OC_COMBINATION.get(String.valueOf(groupEntry.getDN()), "groupOfEntries", "groupOfNames");
                throw new DirectoryException(ResultCode.OBJECTCLASS_VIOLATION, message);
            }
            if (groupEntry.hasObjectClass(groupOfUniqueNamesClass)) {
                Message message = ExtensionMessages.ERR_STATICGROUP_INVALID_OC_COMBINATION.get(String.valueOf(groupEntry.getDN()), "groupOfEntries", "groupOfUniqueNames");
                throw new DirectoryException(ResultCode.OBJECTCLASS_VIOLATION, message);
            }
            memberAttributeType = DirectoryConfig.getAttributeType("member", true);
        } else if (groupEntry.hasObjectClass(groupOfNamesClass)) {
            if (groupEntry.hasObjectClass(groupOfUniqueNamesClass)) {
                Message message = ExtensionMessages.ERR_STATICGROUP_INVALID_OC_COMBINATION.get(String.valueOf(groupEntry.getDN()), "groupOfNames", "groupOfUniqueNames");
                throw new DirectoryException(ResultCode.OBJECTCLASS_VIOLATION, message);
            }
            memberAttributeType = DirectoryConfig.getAttributeType("member", true);
        } else if (groupEntry.hasObjectClass(groupOfUniqueNamesClass)) {
            memberAttributeType = DirectoryConfig.getAttributeType("uniquemember", true);
        } else {
            Message message = ExtensionMessages.ERR_STATICGROUP_NO_VALID_OC.get(String.valueOf(groupEntry.getDN()), "groupOfNames", "groupOfUniqueNames");
            throw new DirectoryException(ResultCode.OBJECTCLASS_VIOLATION, message);
        }
        LinkedHashSet<DN> memberDNs = new LinkedHashSet<DN>();
        List<Attribute> memberAttrList = groupEntry.getAttribute(memberAttributeType);
        if (memberAttrList != null) {
            for (Attribute a : memberAttrList) {
                for (AttributeValue v : a) {
                    try {
                        DN memberDN = DN.decode(v.getValue());
                        memberDNs.add(memberDN);
                    }
                    catch (DirectoryException de) {
                        if (DebugLogger.debugEnabled()) {
                            TRACER.debugCaught(DebugLogLevel.ERROR, de);
                        }
                        Message message = ExtensionMessages.ERR_STATICGROUP_CANNOT_DECODE_MEMBER_VALUE_AS_DN.get(v.getStringValue(), memberAttributeType.getNameOrOID(), String.valueOf(groupEntry.getDN()), de.getMessageObject());
                        ErrorLogger.logError(message);
                    }
                }
            }
        }
        return new StaticGroup(groupEntry.getDN(), memberAttributeType, memberDNs);
    }

    @Override
    public SearchFilter getGroupDefinitionFilter() throws DirectoryException {
        String filterString = "(&(|(objectClass=groupOfNames)(objectClass=groupOfUniqueNames)(objectClass=groupOfEntries))(!(objectClass=ds-virtual-static-group)))";
        return SearchFilter.createFilterFromString(filterString);
    }

    @Override
    public boolean isGroupDefinition(Entry entry) {
        Validator.ensureNotNull(entry);
        ObjectClass virtualStaticGroupClass = DirectoryConfig.getObjectClass("ds-virtual-static-group", true);
        if (entry.hasObjectClass(virtualStaticGroupClass)) {
            return false;
        }
        ObjectClass groupOfEntriesClass = DirectoryConfig.getObjectClass("groupofentries", true);
        ObjectClass groupOfNamesClass = DirectoryConfig.getObjectClass("groupofnames", true);
        ObjectClass groupOfUniqueNamesClass = DirectoryConfig.getObjectClass("groupofuniquenames", true);
        if (entry.hasObjectClass(groupOfEntriesClass)) {
            return !entry.hasObjectClass(groupOfNamesClass) && !entry.hasObjectClass(groupOfUniqueNamesClass);
        }
        if (entry.hasObjectClass(groupOfNamesClass)) {
            return !entry.hasObjectClass(groupOfUniqueNamesClass);
        }
        return entry.hasObjectClass(groupOfUniqueNamesClass);
    }

    @Override
    public DN getGroupDN() {
        return this.groupEntryDN;
    }

    @Override
    public boolean supportsNestedGroups() {
        return true;
    }

    @Override
    public List<DN> getNestedGroupDNs() {
        try {
            this.reloadIfNeeded();
        }
        catch (DirectoryException ex) {
            return Collections.emptyList();
        }
        return this.nestedGroups;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addNestedGroup(DN nestedGroupDN) throws UnsupportedOperationException, DirectoryException {
        Validator.ensureNotNull(nestedGroupDN);
        StaticGroup staticGroup = this;
        synchronized (staticGroup) {
            if (this.nestedGroups.contains(nestedGroupDN)) {
                Message msg = ExtensionMessages.ERR_STATICGROUP_ADD_NESTED_GROUP_ALREADY_EXISTS.get(String.valueOf(nestedGroupDN), String.valueOf(this.groupEntryDN));
                throw new DirectoryException(ResultCode.ATTRIBUTE_OR_VALUE_EXISTS, msg);
            }
            Attribute attr = Attributes.create(this.memberAttributeType, nestedGroupDN.toString());
            LinkedList<Modification> mods = new LinkedList<Modification>();
            mods.add(new Modification(ModificationType.ADD, attr));
            LinkedList<Control> requestControls = new LinkedList<Control>();
            requestControls.add(new Control("1.3.6.1.4.1.26027.1.5.1", false));
            InternalClientConnection conn = InternalClientConnection.getRootConnection();
            ModifyOperationBasis modifyOperation = new ModifyOperationBasis((ClientConnection)conn, InternalClientConnection.nextOperationID(), InternalClientConnection.nextMessageID(), requestControls, this.groupEntryDN, mods);
            modifyOperation.run();
            if (modifyOperation.getResultCode() != ResultCode.SUCCESS) {
                Message msg = ExtensionMessages.ERR_STATICGROUP_ADD_MEMBER_UPDATE_FAILED.get(String.valueOf(nestedGroupDN), String.valueOf(this.groupEntryDN), modifyOperation.getErrorMessage().toString());
                throw new DirectoryException(modifyOperation.getResultCode(), msg);
            }
            LinkedList<DN> newNestedGroups = new LinkedList<DN>(this.nestedGroups);
            newNestedGroups.add(nestedGroupDN);
            this.nestedGroups = newNestedGroups;
            LinkedHashSet<DN> newMemberDNs = new LinkedHashSet<DN>(this.memberDNs);
            newMemberDNs.add(nestedGroupDN);
            this.memberDNs = newMemberDNs;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeNestedGroup(DN nestedGroupDN) throws UnsupportedOperationException, DirectoryException {
        Validator.ensureNotNull(nestedGroupDN);
        StaticGroup staticGroup = this;
        synchronized (staticGroup) {
            if (!this.nestedGroups.contains(nestedGroupDN)) {
                throw new DirectoryException(ResultCode.NO_SUCH_ATTRIBUTE, ExtensionMessages.ERR_STATICGROUP_REMOVE_NESTED_GROUP_NO_SUCH_GROUP.get(String.valueOf(nestedGroupDN), String.valueOf(this.groupEntryDN)));
            }
            Attribute attr = Attributes.create(this.memberAttributeType, nestedGroupDN.toString());
            LinkedList<Modification> mods = new LinkedList<Modification>();
            mods.add(new Modification(ModificationType.DELETE, attr));
            LinkedList<Control> requestControls = new LinkedList<Control>();
            requestControls.add(new Control("1.3.6.1.4.1.26027.1.5.1", false));
            InternalClientConnection conn = InternalClientConnection.getRootConnection();
            ModifyOperationBasis modifyOperation = new ModifyOperationBasis((ClientConnection)conn, InternalClientConnection.nextOperationID(), InternalClientConnection.nextMessageID(), requestControls, this.groupEntryDN, mods);
            modifyOperation.run();
            if (modifyOperation.getResultCode() != ResultCode.SUCCESS) {
                throw new DirectoryException(modifyOperation.getResultCode(), ExtensionMessages.ERR_STATICGROUP_REMOVE_MEMBER_UPDATE_FAILED.get(String.valueOf(nestedGroupDN), String.valueOf(this.groupEntryDN), modifyOperation.getErrorMessage()));
            }
            LinkedList<DN> newNestedGroups = new LinkedList<DN>(this.nestedGroups);
            newNestedGroups.remove(nestedGroupDN);
            this.nestedGroups = newNestedGroups;
            LinkedHashSet<DN> newMemberDNs = new LinkedHashSet<DN>(this.memberDNs);
            newMemberDNs.remove(nestedGroupDN);
            this.memberDNs = newMemberDNs;
        }
    }

    @Override
    public boolean isMember(DN userDN, Set<DN> examinedGroups) throws DirectoryException {
        this.reloadIfNeeded();
        if (this.memberDNs.contains(userDN)) {
            return true;
        }
        if (!examinedGroups.add(this.getGroupDN())) {
            return false;
        }
        for (DN nestedGroupDN : this.nestedGroups) {
            Group g = DirectoryServer.getGroupManager().getGroupInstance(nestedGroupDN);
            if (g == null || !g.isMember(userDN, examinedGroups)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isMember(Entry userEntry, Set<DN> examinedGroups) throws DirectoryException {
        return this.isMember(userEntry.getDN(), examinedGroups);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reloadIfNeeded() throws DirectoryException {
        if (DirectoryServer.getGroupManager().hasInstancesChanged(this.nestedGroupRefreshToken)) {
            StaticGroup staticGroup = this;
            synchronized (staticGroup) {
                Group thisGroup = DirectoryServer.getGroupManager().getGroupInstance(this.groupEntryDN);
                if (thisGroup == null) {
                    throw new DirectoryException(ResultCode.NO_SUCH_ATTRIBUTE, ExtensionMessages.ERR_STATICGROUP_GROUP_INSTANCE_INVALID.get(String.valueOf(this.groupEntryDN)));
                }
                if (thisGroup != this) {
                    LinkedHashSet<DN> newMemberDNs = new LinkedHashSet<DN>();
                    MemberList memberList = thisGroup.getMembers();
                    while (memberList.hasMoreMembers()) {
                        try {
                            newMemberDNs.add(memberList.nextMemberDN());
                        }
                        catch (MembershipException ex) {}
                    }
                    this.memberDNs = newMemberDNs;
                }
                LinkedList<DN> newNestedGroups = new LinkedList<DN>();
                for (DN dn : this.memberDNs) {
                    Group gr = DirectoryServer.getGroupManager().getGroupInstance(dn);
                    if (gr == null) continue;
                    newNestedGroups.add(gr.getGroupDN());
                }
                this.nestedGroupRefreshToken = DirectoryServer.getGroupManager().refreshToken();
                this.nestedGroups = newNestedGroups;
            }
        }
    }

    @Override
    public MemberList getMembers() throws DirectoryException {
        this.reloadIfNeeded();
        return new SimpleStaticGroupMemberList(this.groupEntryDN, this.memberDNs);
    }

    @Override
    public MemberList getMembers(DN baseDN, SearchScope scope, SearchFilter filter) throws DirectoryException {
        this.reloadIfNeeded();
        if (baseDN == null && filter == null) {
            return new SimpleStaticGroupMemberList(this.groupEntryDN, this.memberDNs);
        }
        return new FilteredStaticGroupMemberList(this.groupEntryDN, this.memberDNs, baseDN, scope, filter);
    }

    @Override
    public boolean mayAlterMemberList() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addMember(Entry userEntry) throws UnsupportedOperationException, DirectoryException {
        Validator.ensureNotNull(userEntry);
        StaticGroup staticGroup = this;
        synchronized (staticGroup) {
            DN userDN = userEntry.getDN();
            if (this.memberDNs.contains(userDN)) {
                Message message = ExtensionMessages.ERR_STATICGROUP_ADD_MEMBER_ALREADY_EXISTS.get(String.valueOf(userDN), String.valueOf(this.groupEntryDN));
                throw new DirectoryException(ResultCode.ATTRIBUTE_OR_VALUE_EXISTS, message);
            }
            Attribute attr = Attributes.create(this.memberAttributeType, userDN.toString());
            LinkedList<Modification> mods = new LinkedList<Modification>();
            mods.add(new Modification(ModificationType.ADD, attr));
            LinkedList<Control> requestControls = new LinkedList<Control>();
            requestControls.add(new Control("1.3.6.1.4.1.26027.1.5.1", false));
            InternalClientConnection conn = InternalClientConnection.getRootConnection();
            ModifyOperationBasis modifyOperation = new ModifyOperationBasis((ClientConnection)conn, conn.nextOperationID(), conn.nextMessageID(), requestControls, this.groupEntryDN, mods);
            modifyOperation.run();
            if (modifyOperation.getResultCode() != ResultCode.SUCCESS) {
                Message message = ExtensionMessages.ERR_STATICGROUP_ADD_MEMBER_UPDATE_FAILED.get(String.valueOf(userDN), String.valueOf(this.groupEntryDN), modifyOperation.getErrorMessage().toString());
                throw new DirectoryException(modifyOperation.getResultCode(), message);
            }
            LinkedHashSet<DN> newMemberDNs = new LinkedHashSet<DN>(this.memberDNs.size() + 1);
            newMemberDNs.addAll(this.memberDNs);
            newMemberDNs.add(userDN);
            this.memberDNs = newMemberDNs;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeMember(DN userDN) throws UnsupportedOperationException, DirectoryException {
        Validator.ensureNotNull(userDN);
        StaticGroup staticGroup = this;
        synchronized (staticGroup) {
            if (!this.memberDNs.contains(userDN)) {
                Message message = ExtensionMessages.ERR_STATICGROUP_REMOVE_MEMBER_NO_SUCH_MEMBER.get(String.valueOf(userDN), String.valueOf(this.groupEntryDN));
                throw new DirectoryException(ResultCode.NO_SUCH_ATTRIBUTE, message);
            }
            Attribute attr = Attributes.create(this.memberAttributeType, userDN.toString());
            LinkedList<Modification> mods = new LinkedList<Modification>();
            mods.add(new Modification(ModificationType.DELETE, attr));
            LinkedList<Control> requestControls = new LinkedList<Control>();
            requestControls.add(new Control("1.3.6.1.4.1.26027.1.5.1", false));
            InternalClientConnection conn = InternalClientConnection.getRootConnection();
            ModifyOperationBasis modifyOperation = new ModifyOperationBasis((ClientConnection)conn, conn.nextOperationID(), conn.nextMessageID(), requestControls, this.groupEntryDN, mods);
            modifyOperation.run();
            if (modifyOperation.getResultCode() != ResultCode.SUCCESS) {
                Message message = ExtensionMessages.ERR_STATICGROUP_REMOVE_MEMBER_UPDATE_FAILED.get(String.valueOf(userDN), String.valueOf(this.groupEntryDN), modifyOperation.getErrorMessage().toString());
                throw new DirectoryException(modifyOperation.getResultCode(), message);
            }
            LinkedHashSet<DN> newMemberDNs = new LinkedHashSet<DN>(this.memberDNs);
            newMemberDNs.remove(userDN);
            this.memberDNs = newMemberDNs;
            if (this.nestedGroups.contains(userDN)) {
                LinkedList<DN> newNestedGroups = new LinkedList<DN>(this.nestedGroups);
                newNestedGroups.remove(userDN);
                this.nestedGroups = newNestedGroups;
            }
        }
    }

    @Override
    public void toString(StringBuilder buffer) {
        buffer.append("StaticGroup(");
        buffer.append(this.groupEntryDN);
        buffer.append(")");
    }
}

