/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.protocols.jmx;

import java.io.IOException;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.util.HashMap;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.remote.JMXConnectorServer;
import javax.management.remote.JMXServiceURL;
import javax.management.remote.rmi.RMIConnectorServer;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import org.opends.server.api.KeyManagerProvider;
import org.opends.server.config.JMXMBean;
import org.opends.server.core.DirectoryServer;
import org.opends.server.extensions.NullKeyManagerProvider;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.protocols.jmx.DirectoryRMIClientSocketFactory;
import org.opends.server.protocols.jmx.DirectoryRMIServerSocketFactory;
import org.opends.server.protocols.jmx.JmxConnectionHandler;
import org.opends.server.protocols.jmx.OpendsRMIJRMPServerImpl;
import org.opends.server.protocols.jmx.OpendsRmiServerSocketFactory;
import org.opends.server.protocols.jmx.RmiAuthenticator;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.util.SelectableCertificateKeyManager;

public class RmiConnector {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private MBeanServer mbs = null;
    private String registryClientAddress = "0.0.0.0";
    private JmxConnectionHandler jmxConnectionHandler;
    private String jmxRmiConnectorNoClientCertificateName;
    private String jmxRmiConnectorClientCertificateName;
    protected JMXConnectorServer jmxRmiConnectorNoClientCertificate;
    private JMXConnectorServer jmxRmiConnectorClientCertificate;
    private RmiAuthenticator rmiAuthenticator;
    private Registry registry = null;
    private OpendsRmiServerSocketFactory rmiSsf;
    private String rmiVersion;

    public RmiConnector(MBeanServer mbs, JmxConnectionHandler jmxConnectionHandler) {
        this.mbs = mbs;
        this.jmxConnectionHandler = jmxConnectionHandler;
        String baseName = JMXMBean.getJmxName(jmxConnectionHandler.getComponentEntryDN());
        this.jmxRmiConnectorNoClientCertificateName = baseName + "," + "Type=jmxRmiConnectorNoClientCertificateName";
        this.jmxRmiConnectorClientCertificateName = baseName + "," + "Type=jmxRmiConnectorClientCertificateName";
    }

    public void initialize() {
        try {
            this.startCommonRegistry();
            this.startConnectorNoClientCertificate();
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            throw new RuntimeException("Error while starting the RMI module : " + e.getMessage());
        }
        if (DebugLogger.debugEnabled()) {
            TRACER.debugVerbose("RMI module started");
        }
    }

    private void startCommonRegistry() throws Exception {
        block8: {
            int registryPort = this.jmxConnectionHandler.getListenPort();
            if (DebugLogger.debugEnabled()) {
                TRACER.debugVerbose("start or reach an RMI registry on port %d", registryPort);
            }
            try {
                if (this.registry == null) {
                    this.rmiSsf = new OpendsRmiServerSocketFactory();
                    this.registry = LocateRegistry.createRegistry(registryPort, null, this.rmiSsf);
                }
            }
            catch (RemoteException re) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugWarning("cannot create the RMI registry -> already done ?");
                }
                try {
                    Registry reg = LocateRegistry.getRegistry(registryPort);
                    reg.list();
                    this.registry = reg;
                }
                catch (Exception e) {
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugError("exception thrown while pinging the RMI registry");
                        TRACER.debugCaught(DebugLogLevel.ERROR, re);
                    }
                    throw re;
                }
                if (!DebugLogger.debugEnabled()) break block8;
                TRACER.debugWarning("RMI was registry already started");
            }
        }
    }

    private void startConnectorNoClientCertificate() throws Exception {
        try {
            HashMap<String, Object> env = new HashMap<String, Object>();
            DirectoryRMIClientSocketFactory rmiClientSockeyFactory = null;
            DirectoryRMIServerSocketFactory rmiServerSockeyFactory = null;
            if (this.jmxConnectionHandler.isUseSSL()) {
                String nickname;
                KeyManagerProvider provider;
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugVerbose("SSL connection");
                }
                KeyManager[] keyManagers = (provider = DirectoryServer.getKeyManagerProvider(this.jmxConnectionHandler.getKeyManagerProviderDN())) == null ? new NullKeyManagerProvider().getKeyManagers() : ((nickname = this.jmxConnectionHandler.getSSLServerCertNickname()) == null ? provider.getKeyManagers() : SelectableCertificateKeyManager.wrap(provider.getKeyManagers(), nickname));
                SSLContext ctx = SSLContext.getInstance("TLSv1");
                ctx.init(keyManagers, null, null);
                SSLSocketFactory ssf = ctx.getSocketFactory();
                rmiServerSockeyFactory = new DirectoryRMIServerSocketFactory(ssf, false);
                env.put("jmx.remote.rmi.server.socket.factory", rmiServerSockeyFactory);
                rmiClientSockeyFactory = new DirectoryRMIClientSocketFactory(false);
                env.put("jmx.remote.rmi.client.socket.factory", rmiClientSockeyFactory);
            } else if (DebugLogger.debugEnabled()) {
                TRACER.debugVerbose("UNSECURE CONNECTION");
            }
            if (DebugLogger.debugEnabled()) {
                TRACER.debugVerbose("Add RmiAuthenticator into JMX map");
            }
            this.rmiAuthenticator = new RmiAuthenticator(this.jmxConnectionHandler);
            env.put("jmx.remote.authenticator", this.rmiAuthenticator);
            String uri = "org.opends.server.protocols.jmx.client-unknown";
            String serviceUrl = "service:jmx:rmi:///jndi/rmi://" + this.registryClientAddress + ":" + this.jmxConnectionHandler.getListenPort() + "/" + uri;
            JMXServiceURL url = new JMXServiceURL(serviceUrl);
            if (DebugLogger.debugEnabled()) {
                TRACER.debugVerbose("Create and start the JMX RMI connector");
            }
            OpendsRMIJRMPServerImpl opendsRmiConnectorServer = new OpendsRMIJRMPServerImpl(0, rmiClientSockeyFactory, rmiServerSockeyFactory, env);
            this.jmxRmiConnectorNoClientCertificate = new RMIConnectorServer(url, env, opendsRmiConnectorServer, this.mbs);
            this.jmxRmiConnectorNoClientCertificate.start();
            ObjectName name = new ObjectName(this.jmxRmiConnectorNoClientCertificateName);
            this.mbs.registerMBean(this.jmxRmiConnectorNoClientCertificate, name);
            this.rmiVersion = opendsRmiConnectorServer.getVersion();
            if (DebugLogger.debugEnabled()) {
                TRACER.debugVerbose("JMX RMI connector Started");
            }
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            throw e;
        }
    }

    public void finalizeConnectionHandler(boolean closeConnections, boolean stopRegistry) {
        block14: {
            if (closeConnections) {
                try {
                    if (this.jmxRmiConnectorNoClientCertificate != null) {
                        this.jmxRmiConnectorNoClientCertificate.stop();
                    }
                    if (this.jmxRmiConnectorClientCertificate != null) {
                        this.jmxRmiConnectorClientCertificate.stop();
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                this.jmxRmiConnectorNoClientCertificate = null;
                this.jmxRmiConnectorClientCertificate = null;
            } else {
                this.rmiAuthenticator.setFinalizedPhase(true);
            }
            try {
                ObjectName name = new ObjectName(this.jmxRmiConnectorNoClientCertificateName);
                if (this.mbs.isRegistered(name)) {
                    this.mbs.unregisterMBean(name);
                }
                if (this.jmxRmiConnectorNoClientCertificate != null) {
                    this.jmxRmiConnectorNoClientCertificate.stop();
                }
            }
            catch (Exception e) {
                if (!DebugLogger.debugEnabled()) break block14;
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
        }
        if (stopRegistry) {
            block15: {
                try {
                    if (this.rmiSsf != null) {
                        this.rmiSsf.close();
                    }
                }
                catch (IOException e) {
                    if (!DebugLogger.debugEnabled()) break block15;
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
            }
            this.registry = null;
        }
    }

    public String getProtocolVersion() {
        return this.rmiVersion;
    }
}

