/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.protocols.ldap;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.opends.messages.Message;
import org.opends.messages.ProtocolMessages;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.types.Attribute;
import org.opends.server.types.AttributeBuilder;
import org.opends.server.types.AttributeType;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.ByteString;
import org.opends.server.types.LDAPException;
import org.opends.server.types.RawAttribute;
import org.opends.server.util.ServerConstants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LDAPAttribute
extends RawAttribute {
    private ArrayList<ASN1OctetString> values;
    private String attributeType;

    public LDAPAttribute(String attributeType) {
        this.attributeType = attributeType;
        this.values = new ArrayList(0);
    }

    public LDAPAttribute(String attributeType, String value) {
        this.attributeType = attributeType;
        this.values = new ArrayList(1);
        this.values.add(new ASN1OctetString(value));
    }

    public LDAPAttribute(String attributeType, ASN1OctetString value) {
        this.attributeType = attributeType;
        this.values = new ArrayList(1);
        this.values.add(value);
    }

    public LDAPAttribute(String attributeType, List<String> values) {
        this.attributeType = attributeType;
        if (values == null) {
            this.values = new ArrayList(0);
        } else {
            this.values = new ArrayList(values.size());
            for (String value : values) {
                this.values.add(new ASN1OctetString(value));
            }
        }
    }

    public LDAPAttribute(String attributeType, ArrayList<ASN1OctetString> values) {
        this.attributeType = attributeType;
        this.values = values == null ? new ArrayList(0) : values;
    }

    public LDAPAttribute(Attribute attribute) {
        if (attribute.hasOptions()) {
            StringBuilder attrName = new StringBuilder(attribute.getName());
            for (String o : attribute.getOptions()) {
                attrName.append(";");
                attrName.append(o);
            }
            this.attributeType = attrName.toString();
        } else {
            this.attributeType = attribute.getName();
        }
        if (attribute.isEmpty()) {
            this.values = new ArrayList(0);
            return;
        }
        this.values = new ArrayList(attribute.size());
        for (AttributeValue v : attribute) {
            this.values.add(v.getValue().toASN1OctetString());
        }
    }

    @Override
    public String getAttributeType() {
        return this.attributeType;
    }

    @Override
    public void setAttributeType(String attributeType) {
        this.attributeType = attributeType;
    }

    @Override
    public ArrayList<ASN1OctetString> getValues() {
        return this.values;
    }

    @Override
    public Attribute toAttribute() throws LDAPException {
        AttributeBuilder builder;
        int semicolonPos = this.attributeType.indexOf(59);
        if (semicolonPos > 0) {
            String option;
            builder = new AttributeBuilder(this.attributeType.substring(0, semicolonPos));
            int nextPos = this.attributeType.indexOf(59, semicolonPos + 1);
            while (nextPos > 0) {
                option = this.attributeType.substring(semicolonPos + 1, nextPos);
                if (option.length() > 0) {
                    builder.setOption(option);
                }
                semicolonPos = nextPos;
                nextPos = this.attributeType.indexOf(59, semicolonPos + 1);
            }
            option = this.attributeType.substring(semicolonPos + 1);
            if (option.length() > 0) {
                builder.setOption(option);
            }
        } else {
            builder = new AttributeBuilder(this.attributeType);
        }
        AttributeType attrType = builder.getAttributeType();
        for (ASN1OctetString value : this.values) {
            if (builder.add(new AttributeValue(attrType, (ByteString)value))) continue;
            Message message = ProtocolMessages.ERR_LDAP_ATTRIBUTE_DUPLICATE_VALUES.get(this.attributeType);
            throw new LDAPException(20, message);
        }
        return builder.toAttribute();
    }

    @Override
    public String toString() {
        StringBuilder buffer = new StringBuilder();
        this.toString(buffer);
        return buffer.toString();
    }

    @Override
    public void toString(StringBuilder buffer) {
        buffer.append("LDAPAttribute(type=");
        buffer.append(this.attributeType);
        buffer.append(", values={");
        if (!this.values.isEmpty()) {
            Iterator<ASN1OctetString> iterator = this.values.iterator();
            iterator.next().toString(buffer);
            while (iterator.hasNext()) {
                buffer.append(", ");
                iterator.next().toString(buffer);
            }
        }
        buffer.append("})");
    }

    @Override
    public void toString(StringBuilder buffer, int indent) {
        StringBuilder indentBuf = new StringBuilder(indent);
        for (int i = 0; i < indent; ++i) {
            indentBuf.append(' ');
        }
        buffer.append((CharSequence)indentBuf);
        buffer.append("LDAP Attribute");
        buffer.append(ServerConstants.EOL);
        buffer.append((CharSequence)indentBuf);
        buffer.append("  Attribute Type:  ");
        buffer.append(this.attributeType);
        buffer.append(ServerConstants.EOL);
        buffer.append("  Attribute Values:");
        buffer.append(ServerConstants.EOL);
        for (ASN1OctetString value : this.values) {
            value.toString(buffer, indent + 4);
        }
    }
}

