/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.replication.common;

import org.opends.server.replication.common.ChangeNumber;
import org.opends.server.replication.common.ServerState;
import org.opends.server.util.TimeThread;

public class ChangeNumberGenerator {
    private long lastTime;
    private int seqnum;
    private short serverId;

    public ChangeNumberGenerator(short id, long timestamp) {
        this.lastTime = timestamp;
        this.serverId = id;
        this.seqnum = 0;
    }

    public ChangeNumberGenerator(short id, ServerState state) {
        this.lastTime = TimeThread.getTime();
        for (short stateId : state) {
            if (this.lastTime < state.getMaxChangeNumber(stateId).getTime()) {
                this.lastTime = state.getMaxChangeNumber(stateId).getTime();
            }
            if (stateId != id) continue;
            this.seqnum = state.getMaxChangeNumber(id).getSeqnum();
        }
        this.serverId = id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ChangeNumber newChangeNumber() {
        long curTime = TimeThread.getTime();
        ChangeNumberGenerator changeNumberGenerator = this;
        synchronized (changeNumberGenerator) {
            if (curTime > this.lastTime) {
                this.lastTime = curTime;
            }
            if (this.seqnum++ == 0) {
                ++this.lastTime;
            }
        }
        return new ChangeNumber(this.lastTime, this.seqnum, this.serverId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void adjust(ChangeNumber number) {
        if (number == null) {
            this.lastTime = TimeThread.getTime();
            this.seqnum = 0;
            return;
        }
        long rcvdTime = number.getTime();
        ChangeNumberGenerator changeNumberGenerator = this;
        synchronized (changeNumberGenerator) {
            if (this.lastTime > rcvdTime) {
                return;
            }
            this.lastTime = ++rcvdTime;
        }
    }
}

