/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.replication.plugin;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.zip.CheckedOutputStream;
import java.util.zip.DataFormatException;
import org.opends.messages.Message;
import org.opends.messages.MessageBuilder;
import org.opends.messages.ReplicationMessages;
import org.opends.messages.ToolMessages;
import org.opends.server.admin.server.ConfigurationChangeListener;
import org.opends.server.admin.std.meta.ReplicationDomainCfgDefn;
import org.opends.server.admin.std.server.ReplicationDomainCfg;
import org.opends.server.admin.std.server.SynchronizationProviderCfg;
import org.opends.server.api.AlertGenerator;
import org.opends.server.api.Backend;
import org.opends.server.api.ClientConnection;
import org.opends.server.api.DirectoryThread;
import org.opends.server.api.SynchronizationProvider;
import org.opends.server.backends.jeb.BackendImpl;
import org.opends.server.backends.task.Task;
import org.opends.server.config.ConfigException;
import org.opends.server.controls.SubtreeDeleteControl;
import org.opends.server.core.AddOperation;
import org.opends.server.core.DeleteOperation;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.LockFileManager;
import org.opends.server.core.ModifyDNOperation;
import org.opends.server.core.ModifyDNOperationBasis;
import org.opends.server.core.ModifyOperation;
import org.opends.server.core.ModifyOperationBasis;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.protocols.asn1.ASN1Exception;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.protocols.internal.InternalClientConnection;
import org.opends.server.protocols.internal.InternalSearchOperation;
import org.opends.server.protocols.ldap.LDAPAttribute;
import org.opends.server.protocols.ldap.LDAPFilter;
import org.opends.server.protocols.ldap.LDAPModification;
import org.opends.server.replication.common.AssuredMode;
import org.opends.server.replication.common.ChangeNumber;
import org.opends.server.replication.common.ChangeNumberGenerator;
import org.opends.server.replication.common.DSInfo;
import org.opends.server.replication.common.RSInfo;
import org.opends.server.replication.common.ServerState;
import org.opends.server.replication.common.ServerStatus;
import org.opends.server.replication.common.StatusMachine;
import org.opends.server.replication.common.StatusMachineEvent;
import org.opends.server.replication.plugin.GenerationIdChecksum;
import org.opends.server.replication.plugin.Historical;
import org.opends.server.replication.plugin.ListenerThread;
import org.opends.server.replication.plugin.MultimasterReplication;
import org.opends.server.replication.plugin.PendingChanges;
import org.opends.server.replication.plugin.PersistentServerState;
import org.opends.server.replication.plugin.RemotePendingChanges;
import org.opends.server.replication.plugin.ReplLDIFInputStream;
import org.opends.server.replication.plugin.ReplLDIFOutputStream;
import org.opends.server.replication.plugin.ReplicationBroker;
import org.opends.server.replication.plugin.ReplicationMonitor;
import org.opends.server.replication.plugin.UpdateToReplay;
import org.opends.server.replication.protocol.AckMsg;
import org.opends.server.replication.protocol.AddContext;
import org.opends.server.replication.protocol.AddMsg;
import org.opends.server.replication.protocol.ChangeStatusMsg;
import org.opends.server.replication.protocol.DeleteContext;
import org.opends.server.replication.protocol.DoneMsg;
import org.opends.server.replication.protocol.EntryMsg;
import org.opends.server.replication.protocol.ErrorMsg;
import org.opends.server.replication.protocol.HeartbeatMsg;
import org.opends.server.replication.protocol.InitializeRequestMsg;
import org.opends.server.replication.protocol.InitializeTargetMsg;
import org.opends.server.replication.protocol.ModifyContext;
import org.opends.server.replication.protocol.ModifyDNMsg;
import org.opends.server.replication.protocol.ModifyDnContext;
import org.opends.server.replication.protocol.ModifyMsg;
import org.opends.server.replication.protocol.OperationContext;
import org.opends.server.replication.protocol.ReplSessionSecurity;
import org.opends.server.replication.protocol.ReplicationMsg;
import org.opends.server.replication.protocol.ResetGenerationIdMsg;
import org.opends.server.replication.protocol.RoutableMsg;
import org.opends.server.replication.protocol.TopologyMsg;
import org.opends.server.replication.protocol.UpdateMsg;
import org.opends.server.tasks.InitializeTargetTask;
import org.opends.server.tasks.InitializeTask;
import org.opends.server.tasks.TaskUtils;
import org.opends.server.types.AbstractOperation;
import org.opends.server.types.Attribute;
import org.opends.server.types.AttributeBuilder;
import org.opends.server.types.AttributeType;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.Attributes;
import org.opends.server.types.ConfigChangeResult;
import org.opends.server.types.Control;
import org.opends.server.types.DN;
import org.opends.server.types.DereferencePolicy;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.Entry;
import org.opends.server.types.ExistingFileBehavior;
import org.opends.server.types.LDAPException;
import org.opends.server.types.LDIFExportConfig;
import org.opends.server.types.LDIFImportConfig;
import org.opends.server.types.Modification;
import org.opends.server.types.ModificationType;
import org.opends.server.types.Operation;
import org.opends.server.types.RDN;
import org.opends.server.types.RawModification;
import org.opends.server.types.ResultCode;
import org.opends.server.types.SearchFilter;
import org.opends.server.types.SearchResultEntry;
import org.opends.server.types.SearchScope;
import org.opends.server.types.SynchronizationProviderResult;
import org.opends.server.types.operation.PluginOperation;
import org.opends.server.types.operation.PostOperationOperation;
import org.opends.server.types.operation.PreOperationAddOperation;
import org.opends.server.types.operation.PreOperationDeleteOperation;
import org.opends.server.types.operation.PreOperationModifyDNOperation;
import org.opends.server.types.operation.PreOperationModifyOperation;
import org.opends.server.types.operation.PreOperationOperation;
import org.opends.server.util.StaticUtils;
import org.opends.server.workflowelement.localbackend.LocalBackendModifyOperation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReplicationDomain
extends DirectoryThread
implements ConfigurationChangeListener<ReplicationDomainCfg>,
AlertGenerator {
    private static final String CLASS_NAME = "org.opends.server.replication.plugin.ReplicationDomain";
    public static final String DS_SYNC_CONFLICT = "ds-sync-conflict";
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private ReplicationMonitor monitor;
    private ReplicationBroker broker;
    private ListenerThread listenerThread;
    private LinkedBlockingQueue<UpdateToReplay> updateToReplayQueue;
    private SortedMap<ChangeNumber, UpdateMsg> waitingAckMsgs = new TreeMap<ChangeNumber, UpdateMsg>();
    private AtomicInteger numRcvdUpdates = new AtomicInteger(0);
    private AtomicInteger numSentUpdates = new AtomicInteger(0);
    private AtomicInteger numProcessedUpdates = new AtomicInteger();
    private AtomicInteger numResolvedNamingConflicts = new AtomicInteger();
    private AtomicInteger numResolvedModifyConflicts = new AtomicInteger();
    private AtomicInteger numUnresolvedNamingConflicts = new AtomicInteger();
    private int debugCount = 0;
    private PersistentServerState state;
    private int numReplayedPostOpCalled = 0;
    private int maxReceiveQueue = 0;
    private int maxSendQueue = 0;
    private int maxReceiveDelay = 0;
    private int maxSendDelay = 0;
    private long generationId = -1L;
    private boolean generationIdSavedStatus = false;
    ChangeNumberGenerator generator;
    private PendingChanges pendingChanges;
    private RemotePendingChanges remotePendingChanges;
    private long heartbeatInterval = 0L;
    private short serverId;
    private IEContext ieContext = null;
    private Collection<String> replicationServers;
    private DN baseDn;
    private boolean shutdown = false;
    private InternalClientConnection conn = InternalClientConnection.getRootConnection();
    private boolean solveConflictFlag = true;
    private boolean disabled = false;
    private boolean stateSavingDisabled = false;
    private int window = 100;
    private boolean assured = false;
    private AssuredMode assuredMode = AssuredMode.SAFE_DATA_MODE;
    private byte assuredSdLevel = 1;
    private long assuredTimeout = 1000L;
    private byte groupId = 1;
    private List<String> refUrls = new ArrayList<String>();
    private ServerStatus status = ServerStatus.NOT_CONNECTED_STATUS;
    private List<DSInfo> dsList = new ArrayList<DSInfo>();
    private List<RSInfo> rsList = new ArrayList<RSInfo>();
    private ReplicationDomainCfgDefn.IsolationPolicy isolationpolicy;
    private DN configDn;
    private boolean done = true;
    protected static final String REPLICATION_GENERATION_ID = "ds-sync-generation-id";

    public ReplicationDomain(ReplicationDomainCfg configuration, LinkedBlockingQueue<UpdateToReplay> updateToReplayQueue) throws ConfigException {
        super("Replication State Saver for server id " + configuration.getServerId() + " and domain " + configuration.getBaseDN());
        this.replicationServers = configuration.getReplicationServer();
        this.serverId = (short)configuration.getServerId();
        this.baseDn = configuration.getBaseDN();
        this.window = configuration.getWindowSize();
        this.heartbeatInterval = configuration.getHeartbeatInterval();
        this.isolationpolicy = configuration.getIsolationPolicy();
        this.configDn = configuration.dn();
        this.updateToReplayQueue = updateToReplayQueue;
        ReplicationDomainCfgDefn.AssuredType assuredType = configuration.getAssuredType();
        switch (assuredType) {
            case NOT_ASSURED: {
                this.assured = false;
                break;
            }
            case SAFE_DATA: {
                this.assured = true;
                this.assuredMode = AssuredMode.SAFE_DATA_MODE;
                break;
            }
            case SAFE_READ: {
                this.assured = true;
                this.assuredMode = AssuredMode.SAFE_READ_MODE;
            }
        }
        this.assuredSdLevel = (byte)configuration.getAssuredSdLevel();
        this.groupId = (byte)configuration.getGroupId();
        this.assuredTimeout = configuration.getAssuredTimeout();
        SortedSet<String> urls = configuration.getReferralsUrl();
        if (urls != null) {
            for (String url : urls) {
                this.refUrls.add(url);
            }
        }
        this.solveConflictFlag = this.baseDn.compareTo(DirectoryServer.getSchemaDN()) != 0;
        this.state = new PersistentServerState(this.baseDn, this.serverId);
        this.monitor = new ReplicationMonitor(this);
        DirectoryServer.registerMonitorProvider(this.monitor);
        Backend backend = ReplicationDomain.retrievesBackend(this.baseDn);
        if (backend == null) {
            throw new ConfigException(ReplicationMessages.ERR_SEARCHING_DOMAIN_BACKEND.get(this.baseDn.toNormalizedString()));
        }
        try {
            this.generationId = this.loadGenerationId();
        }
        catch (DirectoryException e) {
            ErrorLogger.logError(ReplicationMessages.ERR_LOADING_GENERATION_ID.get(this.baseDn.toNormalizedString(), e.getLocalizedMessage()));
        }
        this.broker = new ReplicationBroker(this, this.state, this.baseDn, this.serverId, this.maxReceiveQueue, this.maxReceiveDelay, this.maxSendQueue, this.maxSendDelay, this.window, this.heartbeatInterval, this.generationId, new ReplSessionSecurity(configuration), this.getGroupId());
        this.broker.start(this.replicationServers);
        this.generator = new ChangeNumberGenerator(this.serverId, this.state);
        this.pendingChanges = new PendingChanges(this.generator, this.broker, this.state);
        this.remotePendingChanges = new RemotePendingChanges(this.generator, this.state);
        configuration.addChangeListener(this);
        DirectoryServer.registerAlertGenerator(this);
    }

    public DN getBaseDN() {
        return this.baseDn;
    }

    public SynchronizationProviderResult handleConflictResolution(PreOperationDeleteOperation deleteOperation) {
        if (!deleteOperation.isSynchronizationOperation() && !this.brokerIsConnected(deleteOperation)) {
            Message msg = ReplicationMessages.ERR_REPLICATION_COULD_NOT_CONNECT.get(this.baseDn.toString());
            return new SynchronizationProviderResult.StopProcessing(ResultCode.UNWILLING_TO_PERFORM, msg);
        }
        DeleteContext ctx = (DeleteContext)deleteOperation.getAttachment("replicationContext");
        Entry deletedEntry = deleteOperation.getEntryToDelete();
        if (ctx != null) {
            String modifiedEntryUUID;
            String operationEntryUUID = ctx.getEntryUid();
            if (!operationEntryUUID.equals(modifiedEntryUUID = Historical.getEntryUuid(deletedEntry))) {
                return new SynchronizationProviderResult.StopProcessing(ResultCode.NO_SUCH_OBJECT, null);
            }
        } else {
            ChangeNumber changeNumber = this.generateChangeNumber(deleteOperation);
            String modifiedEntryUUID = Historical.getEntryUuid(deletedEntry);
            ctx = new DeleteContext(changeNumber, modifiedEntryUUID);
            deleteOperation.setAttachment("replicationContext", ctx);
        }
        return new SynchronizationProviderResult.ContinueProcessing();
    }

    public SynchronizationProviderResult handleConflictResolution(PreOperationAddOperation addOperation) {
        if (!addOperation.isSynchronizationOperation() && !this.brokerIsConnected(addOperation)) {
            Message msg = ReplicationMessages.ERR_REPLICATION_COULD_NOT_CONNECT.get(this.baseDn.toString());
            return new SynchronizationProviderResult.StopProcessing(ResultCode.UNWILLING_TO_PERFORM, msg);
        }
        if (addOperation.isSynchronizationOperation()) {
            AddContext ctx = (AddContext)addOperation.getAttachment("replicationContext");
            String uuid = ctx.getEntryUid();
            if (this.findEntryDN(uuid) != null) {
                return new SynchronizationProviderResult.StopProcessing(ResultCode.CANCELED, null);
            }
            String parentUid = ctx.getParentUid();
            if (parentUid != null) {
                DN parentDnFromCtx = this.findEntryDN(ctx.getParentUid());
                if (parentDnFromCtx == null) {
                    return new SynchronizationProviderResult.StopProcessing(ResultCode.NO_SUCH_OBJECT, null);
                }
                DN entryDN = addOperation.getEntryDN();
                DN parentDnFromEntryDn = entryDN.getParentDNInSuffix();
                if (parentDnFromEntryDn != null && !parentDnFromCtx.equals(parentDnFromEntryDn)) {
                    return new SynchronizationProviderResult.StopProcessing(ResultCode.NO_SUCH_OBJECT, null);
                }
            }
        }
        return new SynchronizationProviderResult.ContinueProcessing();
    }

    private boolean brokerIsConnected(PreOperationOperation op) {
        if (this.isolationpolicy.equals((Object)ReplicationDomainCfgDefn.IsolationPolicy.ACCEPT_ALL_UPDATES)) {
            return true;
        }
        if (this.isolationpolicy.equals((Object)ReplicationDomainCfgDefn.IsolationPolicy.REJECT_ALL_UPDATES)) {
            return this.broker.isConnected();
        }
        return true;
    }

    public SynchronizationProviderResult handleConflictResolution(PreOperationModifyDNOperation modifyDNOperation) {
        if (!modifyDNOperation.isSynchronizationOperation() && !this.brokerIsConnected(modifyDNOperation)) {
            Message msg = ReplicationMessages.ERR_REPLICATION_COULD_NOT_CONNECT.get(this.baseDn.toString());
            return new SynchronizationProviderResult.StopProcessing(ResultCode.UNWILLING_TO_PERFORM, msg);
        }
        ModifyDnContext ctx = (ModifyDnContext)modifyDNOperation.getAttachment("replicationContext");
        if (ctx != null) {
            String newParentId;
            String modifiedEntryUUID = Historical.getEntryUuid(modifyDNOperation.getOriginalEntry());
            if (!modifiedEntryUUID.equals(ctx.getEntryUid())) {
                return new SynchronizationProviderResult.StopProcessing(ResultCode.NO_SUCH_OBJECT, null);
            }
            if (modifyDNOperation.getNewSuperior() != null && (newParentId = ReplicationDomain.findEntryId(modifyDNOperation.getNewSuperior())) != null && ctx.getNewParentId() != null && !newParentId.equals(ctx.getNewParentId())) {
                return new SynchronizationProviderResult.StopProcessing(ResultCode.NO_SUCH_OBJECT, null);
            }
        } else {
            ChangeNumber changeNumber = this.generateChangeNumber(modifyDNOperation);
            String newParentId = null;
            if (modifyDNOperation.getNewSuperior() != null) {
                newParentId = ReplicationDomain.findEntryId(modifyDNOperation.getNewSuperior());
            }
            Entry modifiedEntry = modifyDNOperation.getOriginalEntry();
            String modifiedEntryUUID = Historical.getEntryUuid(modifiedEntry);
            ctx = new ModifyDnContext(changeNumber, modifiedEntryUUID, newParentId);
            modifyDNOperation.setAttachment("replicationContext", ctx);
        }
        return new SynchronizationProviderResult.ContinueProcessing();
    }

    public SynchronizationProviderResult handleConflictResolution(PreOperationModifyOperation modifyOperation) {
        if (!modifyOperation.isSynchronizationOperation() && !this.brokerIsConnected(modifyOperation)) {
            Message msg = ReplicationMessages.ERR_REPLICATION_COULD_NOT_CONNECT.get(this.baseDn.toString());
            return new SynchronizationProviderResult.StopProcessing(ResultCode.UNWILLING_TO_PERFORM, msg);
        }
        ModifyContext ctx = (ModifyContext)modifyOperation.getAttachment("replicationContext");
        Entry modifiedEntry = modifyOperation.getModifiedEntry();
        if (ctx == null) {
            ChangeNumber changeNumber = this.generateChangeNumber(modifyOperation);
            String modifiedEntryUUID = Historical.getEntryUuid(modifiedEntry);
            if (modifiedEntryUUID == null) {
                modifiedEntryUUID = modifyOperation.getEntryDN().toString();
            }
            ctx = new ModifyContext(changeNumber, modifiedEntryUUID);
            modifyOperation.setAttachment("replicationContext", ctx);
        } else {
            String modifiedEntryUUID = ctx.getEntryUid();
            String currentEntryUUID = Historical.getEntryUuid(modifiedEntry);
            if (currentEntryUUID != null && !currentEntryUUID.equals(modifiedEntryUUID)) {
                return new SynchronizationProviderResult.StopProcessing(ResultCode.NO_SUCH_OBJECT, null);
            }
            Historical historicalInformation = Historical.load(modifiedEntry);
            modifyOperation.setAttachment("ds-synch-historical", historicalInformation);
            if (historicalInformation.replayOperation(modifyOperation, modifiedEntry)) {
                this.numResolvedModifyConflicts.incrementAndGet();
            }
            if (modifyOperation.getModifications().isEmpty()) {
                return new SynchronizationProviderResult.StopProcessing(ResultCode.SUCCESS, null);
            }
        }
        return new SynchronizationProviderResult.ContinueProcessing();
    }

    public void doPreOperation(PreOperationAddOperation addOperation) {
        AddContext ctx = new AddContext(this.generateChangeNumber(addOperation), Historical.getEntryUuid(addOperation), ReplicationDomain.findEntryId(addOperation.getEntryDN().getParentDNInSuffix()));
        addOperation.setAttachment("replicationContext", ctx);
        Historical.generateState(addOperation);
    }

    public UpdateMsg receive() {
        UpdateMsg update = null;
        while (update == null && !this.shutdown) {
            RoutableMsg initMsg = null;
            try {
                ReplicationMsg msg = this.broker.receive();
                if (msg == null) {
                    return null;
                }
                if (DebugLogger.debugEnabled() && !(msg instanceof HeartbeatMsg)) {
                    TRACER.debugVerbose("Message received <" + msg + ">");
                }
                if (msg instanceof AckMsg) {
                    AckMsg ack = (AckMsg)msg;
                    this.receiveAck(ack);
                } else if (msg instanceof InitializeRequestMsg) {
                    initMsg = (InitializeRequestMsg)msg;
                } else if (msg instanceof InitializeTargetMsg) {
                    InitializeTargetMsg importMsg = (InitializeTargetMsg)msg;
                    try {
                        this.initialize(importMsg);
                    }
                    catch (DirectoryException de) {
                        ErrorMsg errorMsg = new ErrorMsg(importMsg.getsenderID(), de.getMessageObject());
                        MessageBuilder mb = new MessageBuilder();
                        mb.append(de.getMessageObject());
                        TRACER.debugInfo(Message.toString(mb.toMessage()));
                        this.broker.publish(errorMsg);
                    }
                } else if (msg instanceof ErrorMsg) {
                    if (this.ieContext != null) {
                        this.abandonImportExport((ErrorMsg)msg);
                    } else {
                        ErrorMsg errorMsg = (ErrorMsg)msg;
                        ErrorLogger.logError(ReplicationMessages.ERR_ERROR_MSG_RECEIVED.get(errorMsg.getDetails()));
                    }
                }
                if (msg instanceof TopologyMsg) {
                    TopologyMsg topoMsg = (TopologyMsg)msg;
                    this.receiveTopo(topoMsg);
                }
                if (msg instanceof ChangeStatusMsg) {
                    ChangeStatusMsg csMsg = (ChangeStatusMsg)msg;
                    this.receiveChangeStatus(csMsg);
                } else if (msg instanceof UpdateMsg) {
                    update = (UpdateMsg)msg;
                    this.receiveUpdate(update);
                }
            }
            catch (SocketTimeoutException e) {
                // empty catch block
            }
            if (initMsg == null) continue;
            ExportThread exportThread = new ExportThread(initMsg.getsenderID());
            exportThread.start();
        }
        return update;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receiveTopo(TopologyMsg topoMsg) {
        if (DebugLogger.debugEnabled()) {
            TRACER.debugInfo("Replication domain " + this.baseDn + " received topology info update:\n" + topoMsg);
        }
        List<DSInfo> list = this.getDsList();
        synchronized (list) {
            List<RSInfo> list2 = this.getRsList();
            synchronized (list2) {
                this.dsList = topoMsg.getDsList();
                this.rsList = topoMsg.getRsList();
            }
        }
    }

    public void setInitialStatus(ServerStatus initStatus) {
        if (!StatusMachine.isValidInitialStatus(initStatus)) {
            Message msg = ReplicationMessages.ERR_DS_INVALID_INIT_STATUS.get(initStatus.toString(), this.baseDn.toString(), Short.toString(this.serverId));
            ErrorLogger.logError(msg);
        } else {
            this.status = initStatus;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void receiveChangeStatus(ChangeStatusMsg csMsg) {
        ServerStatus reqStatus;
        StatusMachineEvent event;
        if (DebugLogger.debugEnabled()) {
            TRACER.debugInfo("Replication domain " + this.baseDn + " received change status message:\n" + csMsg);
        }
        if ((event = StatusMachineEvent.statusToEvent(reqStatus = csMsg.getRequestedStatus())) == StatusMachineEvent.INVALID_EVENT) {
            Message msg = ReplicationMessages.ERR_DS_INVALID_REQUESTED_STATUS.get(reqStatus.toString(), this.baseDn.toString(), Short.toString(this.serverId));
            ErrorLogger.logError(msg);
            return;
        }
        ServerStatus serverStatus = this.status;
        synchronized (serverStatus) {
            ServerStatus newStatus = StatusMachine.computeNewStatus(this.status, event);
            if (newStatus == ServerStatus.INVALID_STATUS) {
                Message msg = ReplicationMessages.ERR_DS_CANNOT_CHANGE_STATUS.get(this.baseDn.toString(), Short.toString(this.serverId), this.status.toString(), event.toString());
                ErrorLogger.logError(msg);
                return;
            }
            this.status = newStatus;
            if (DebugLogger.debugEnabled()) {
                TRACER.debugInfo("Replication domain " + this.baseDn + " new status is: " + (Object)((Object)this.status));
            }
            this.updateDomainForNewStatus();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void toNotConnectedStatus() {
        ServerStatus serverStatus = this.status;
        synchronized (serverStatus) {
            StatusMachineEvent event = StatusMachineEvent.TO_NOT_CONNECTED_STATUS_EVENT;
            ServerStatus newStatus = StatusMachine.computeNewStatus(this.status, event);
            if (newStatus == ServerStatus.INVALID_STATUS) {
                Message msg = ReplicationMessages.ERR_DS_CANNOT_CHANGE_STATUS.get(this.baseDn.toString(), Short.toString(this.serverId), this.status.toString(), event.toString());
                ErrorLogger.logError(msg);
                return;
            }
            this.status = newStatus;
            if (DebugLogger.debugEnabled()) {
                TRACER.debugInfo("Replication domain " + this.baseDn + " new status is: " + (Object)((Object)this.status));
            }
            this.updateDomainForNewStatus();
        }
    }

    private void updateDomainForNewStatus() {
        switch (this.status) {
            case NOT_CONNECTED_STATUS: {
                break;
            }
            case NORMAL_STATUS: {
                break;
            }
            case DEGRADED_STATUS: {
                break;
            }
            case FULL_UPDATE_STATUS: {
                this.broker.signalStatusChange(this.status);
                break;
            }
            case BAD_GEN_ID_STATUS: {
                break;
            }
            default: {
                if (!DebugLogger.debugEnabled()) break;
                TRACER.debugInfo("updateDomainForNewStatus: unexpected status: " + (Object)((Object)this.status));
            }
        }
    }

    public void receiveUpdate(UpdateMsg update) {
        this.remotePendingChanges.putRemoteUpdate(update);
        this.numRcvdUpdates.incrementAndGet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receiveAck(AckMsg ack) {
        UpdateMsg update;
        ChangeNumber changeNumber = ack.getChangeNumber();
        Object object = this.waitingAckMsgs;
        synchronized (object) {
            update = (UpdateMsg)this.waitingAckMsgs.remove(changeNumber);
        }
        if (update != null) {
            object = update;
            synchronized (object) {
                update.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void synchronize(PostOperationOperation op) {
        ResultCode result = op.getResultCode();
        if (result == ResultCode.SUCCESS && op.isSynchronizationOperation()) {
            ++this.numReplayedPostOpCalled;
        }
        UpdateMsg msg = null;
        ChangeNumber curChangeNumber = OperationContext.getChangeNumber(op);
        boolean isAssured = this.isAssured(op);
        if (result == ResultCode.SUCCESS && !op.isSynchronizationOperation() && (msg = UpdateMsg.generateMsg(op)) == null) {
            this.pendingChanges.remove(curChangeNumber);
            Message message = ReplicationMessages.ERR_UNKNOWN_TYPE.get(op.getOperationType().toString());
            ErrorLogger.logError(message);
            return;
        }
        if (result == ResultCode.SUCCESS) {
            try {
                if (op.isSynchronizationOperation()) {
                    this.remotePendingChanges.commit(curChangeNumber);
                } else {
                    this.pendingChanges.commit(curChangeNumber, msg);
                }
            }
            catch (NoSuchElementException e) {
                Message message = ReplicationMessages.ERR_OPERATION_NOT_FOUND_IN_PENDING.get(curChangeNumber.toString(), op.toString());
                ErrorLogger.logError(message);
                return;
            }
            if (msg != null && isAssured) {
                SortedMap<ChangeNumber, UpdateMsg> e = this.waitingAckMsgs;
                synchronized (e) {
                    this.waitingAckMsgs.put(curChangeNumber, msg);
                }
            }
            if (!this.generationIdSavedStatus) {
                this.saveGenerationId(this.generationId);
            }
        } else if (!op.isSynchronizationOperation() && curChangeNumber != null) {
            this.pendingChanges.remove(curChangeNumber);
        }
        if (!op.isSynchronizationOperation()) {
            int pushedChanges = this.pendingChanges.pushCommittedChanges();
            this.numSentUpdates.addAndGet(pushedChanges);
        }
        if (msg != null && isAssured) {
            UpdateMsg updateMsg = msg;
            synchronized (updateMsg) {
                while (this.waitingAckMsgs.containsKey(msg.getChangeNumber())) {
                    try {
                        msg.wait(1000L);
                    }
                    catch (InterruptedException e) {}
                }
            }
        }
    }

    public int getNumRcvdUpdates() {
        if (this.numRcvdUpdates != null) {
            return this.numRcvdUpdates.get();
        }
        return 0;
    }

    public int getNumSentUpdates() {
        if (this.numSentUpdates != null) {
            return this.numSentUpdates.get();
        }
        return 0;
    }

    public int getPendingUpdatesCount() {
        if (this.pendingChanges != null) {
            return this.pendingChanges.size();
        }
        return 0;
    }

    public void incProcessedUpdates() {
        this.numProcessedUpdates.incrementAndGet();
    }

    public int getNumProcessedUpdates() {
        if (this.numProcessedUpdates != null) {
            return this.numProcessedUpdates.get();
        }
        return 0;
    }

    public int getNumReplayedPostOpCalled() {
        return this.numReplayedPostOpCalled;
    }

    public ServerState getServerState() {
        return this.state;
    }

    public int getDebugCount() {
        return this.debugCount;
    }

    public void ack(ChangeNumber changeNumber) {
        this.broker.publish(new AckMsg(changeNumber));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.done = false;
        this.listenerThread = new ListenerThread(this, this.updateToReplayQueue);
        this.listenerThread.start();
        while (!this.shutdown) {
            try {
                ReplicationDomain replicationDomain = this;
                synchronized (replicationDomain) {
                    this.wait(1000L);
                    if (!this.disabled && !this.stateSavingDisabled) {
                        this.state.save();
                    }
                }
            }
            catch (InterruptedException interruptedException) {
            }
        }
        this.state.save();
        this.done = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        this.shutdown = true;
        if (this.listenerThread != null) {
            this.listenerThread.shutdown();
        }
        ReplicationDomain replicationDomain = this;
        synchronized (replicationDomain) {
            this.notify();
        }
        DirectoryServer.deregisterMonitorProvider(this.monitor.getMonitorInstanceName());
        DirectoryServer.deregisterAlertGenerator(this);
        this.broker.stop();
        if (this.listenerThread != null) {
            this.listenerThread.waitForShutdown();
        }
        try {
            while (!this.done) {
                Thread.sleep(50L);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public String getReplicationServer() {
        if (this.broker != null) {
            return this.broker.getReplicationServer();
        }
        return "Not connected";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replay(UpdateMsg msg) {
        AbstractOperation op = null;
        boolean done = false;
        boolean dependency = false;
        ChangeNumber changeNumber = null;
        int retryCount = 10;
        do {
            Message message;
            try {
                op = msg.createOperation(this.conn);
                dependency = this.remotePendingChanges.checkDependencies(op, msg);
                while (!dependency && !done && retryCount-- > 0) {
                    op.setInternalOperation(true);
                    op.setSynchronizationOperation(true);
                    changeNumber = OperationContext.getChangeNumber(op);
                    op.run();
                    ResultCode result = op.getResultCode();
                    if (result != ResultCode.SUCCESS) {
                        Operation newOp;
                        if (op instanceof ModifyOperation) {
                            newOp = (ModifyOperation)((Object)op);
                            dependency = this.remotePendingChanges.checkDependencies((ModifyOperation)newOp);
                            ModifyMsg modifyMsg = (ModifyMsg)msg;
                            done = this.solveNamingConflict((ModifyOperation)newOp, modifyMsg);
                        } else if (op instanceof DeleteOperation) {
                            newOp = (DeleteOperation)((Object)op);
                            dependency = this.remotePendingChanges.checkDependencies((DeleteOperation)newOp);
                            done = this.solveNamingConflict((DeleteOperation)newOp, msg);
                        } else if (op instanceof AddOperation) {
                            newOp = (AddOperation)((Object)op);
                            AddMsg addMsg = (AddMsg)msg;
                            dependency = this.remotePendingChanges.checkDependencies((AddOperation)newOp);
                            done = this.solveNamingConflict((AddOperation)newOp, addMsg);
                        } else if (op instanceof ModifyDNOperationBasis) {
                            newOp = (ModifyDNOperationBasis)op;
                            done = this.solveNamingConflict((ModifyDNOperation)newOp, msg);
                        } else {
                            done = true;
                        }
                        if (done) {
                            this.updateError(changeNumber);
                            continue;
                        }
                        op = msg.createOperation(this.conn);
                        if (!(op instanceof DeleteOperation)) continue;
                        op.addRequestControl(new SubtreeDeleteControl());
                        continue;
                    }
                    done = true;
                }
                if (!done && !dependency) {
                    Message message2 = ReplicationMessages.ERR_LOOP_REPLAYING_OPERATION.get(((Object)op).toString(), op.getErrorMessage().toString());
                    ErrorLogger.logError(message2);
                    this.numUnresolvedNamingConflicts.incrementAndGet();
                    this.updateError(changeNumber);
                }
            }
            catch (ASN1Exception e) {
                message = ReplicationMessages.ERR_EXCEPTION_DECODING_OPERATION.get(String.valueOf(msg) + StaticUtils.stackTraceToSingleLineString(e));
                ErrorLogger.logError(message);
            }
            catch (LDAPException e) {
                message = ReplicationMessages.ERR_EXCEPTION_DECODING_OPERATION.get(String.valueOf(msg) + StaticUtils.stackTraceToSingleLineString(e));
                ErrorLogger.logError(message);
            }
            catch (DataFormatException e) {
                message = ReplicationMessages.ERR_EXCEPTION_DECODING_OPERATION.get(String.valueOf(msg) + StaticUtils.stackTraceToSingleLineString(e));
                ErrorLogger.logError(message);
            }
            catch (Exception e) {
                if (changeNumber != null) {
                    message = ReplicationMessages.ERR_EXCEPTION_REPLAYING_OPERATION.get(StaticUtils.stackTraceToSingleLineString(e), ((Object)op).toString());
                    ErrorLogger.logError(message);
                    this.updateError(changeNumber);
                } else {
                    message = ReplicationMessages.ERR_EXCEPTION_DECODING_OPERATION.get(String.valueOf(msg) + StaticUtils.stackTraceToSingleLineString(e));
                    ErrorLogger.logError(message);
                }
            }
            finally {
                if (!dependency) {
                    this.broker.updateWindowAfterReplay();
                    if (msg.isAssured()) {
                        this.ack(msg.getChangeNumber());
                    }
                    this.incProcessedUpdates();
                }
            }
            msg = this.remotePendingChanges.getNextUpdate();
            done = false;
            dependency = false;
            changeNumber = null;
            retryCount = 10;
        } while (msg != null);
    }

    public void updateError(ChangeNumber changeNumber) {
        this.remotePendingChanges.commit(changeNumber);
    }

    private ChangeNumber generateChangeNumber(PluginOperation operation) {
        return this.pendingChanges.putLocalOperation(operation);
    }

    static String findEntryId(DN dn) {
        if (dn == null) {
            return null;
        }
        try {
            SearchResultEntry resultEntry;
            LinkedList<SearchResultEntry> result;
            InternalClientConnection conn = InternalClientConnection.getRootConnection();
            LinkedHashSet<String> attrs = new LinkedHashSet<String>(1);
            attrs.add("entryuuid");
            InternalSearchOperation search = conn.processSearch(dn, SearchScope.BASE_OBJECT, DereferencePolicy.NEVER_DEREF_ALIASES, 0, 0, false, SearchFilter.createFilterFromString("objectclass=*"), attrs);
            if (search.getResultCode() == ResultCode.SUCCESS && !(result = search.getSearchEntries()).isEmpty() && (resultEntry = result.getFirst()) != null) {
                return Historical.getEntryUuid(resultEntry);
            }
        }
        catch (DirectoryException directoryException) {
            // empty catch block
        }
        return null;
    }

    private DN findEntryDN(String uuid) {
        try {
            SearchResultEntry resultEntry;
            LinkedList<SearchResultEntry> result;
            InternalSearchOperation search = this.conn.processSearch(this.baseDn, SearchScope.WHOLE_SUBTREE, SearchFilter.createFilterFromString("entryuuid=" + uuid));
            if (search.getResultCode() == ResultCode.SUCCESS && !(result = search.getSearchEntries()).isEmpty() && (resultEntry = result.getFirst()) != null) {
                return resultEntry.getDN();
            }
        }
        catch (DirectoryException directoryException) {
            // empty catch block
        }
        return null;
    }

    private boolean solveNamingConflict(ModifyOperation op, ModifyMsg msg) {
        ResultCode result = op.getResultCode();
        ModifyContext ctx = (ModifyContext)op.getAttachment("replicationContext");
        String entryUid = ctx.getEntryUid();
        if (result == ResultCode.NO_SUCH_OBJECT) {
            DN newdn = this.findEntryDN(entryUid);
            if (newdn != null) {
                msg.setDn(newdn.toString());
                this.numResolvedNamingConflicts.incrementAndGet();
                return false;
            }
            this.numResolvedNamingConflicts.incrementAndGet();
            return true;
        }
        if (result == ResultCode.NOT_ALLOWED_ON_RDN) {
            DN currentDN = this.findEntryDN(entryUid);
            RDN currentRDN = null;
            if (currentDN == null) {
                this.numResolvedNamingConflicts.incrementAndGet();
                return true;
            }
            currentRDN = currentDN.getRDN();
            List<Modification> mods = op.getModifications();
            for (Modification mod : mods) {
                AttributeType modAttrType = mod.getAttribute().getAttributeType();
                if (mod.getModificationType() != ModificationType.DELETE && mod.getModificationType() != ModificationType.REPLACE || !currentRDN.hasAttributeType(modAttrType)) continue;
                mod.setModificationType(ModificationType.REPLACE);
                Attribute newAttribute = mod.getAttribute();
                AttributeBuilder attrBuilder = newAttribute == null ? new AttributeBuilder(modAttrType) : new AttributeBuilder(newAttribute);
                attrBuilder.add(currentRDN.getAttributeValue(modAttrType));
                mod.setAttribute(attrBuilder.toAttribute());
            }
            msg.setMods(mods);
            this.numResolvedNamingConflicts.incrementAndGet();
            return false;
        }
        Message message = ReplicationMessages.ERR_ERROR_REPLAYING_OPERATION.get(op.toString(), ctx.getChangeNumber().toString(), result.toString(), op.getErrorMessage().toString());
        ErrorLogger.logError(message);
        return true;
    }

    private boolean solveNamingConflict(DeleteOperation op, UpdateMsg msg) {
        ResultCode result = op.getResultCode();
        DeleteContext ctx = (DeleteContext)op.getAttachment("replicationContext");
        String entryUid = ctx.getEntryUid();
        if (result == ResultCode.NO_SUCH_OBJECT) {
            DN currentDn = this.findEntryDN(entryUid);
            if (currentDn == null) {
                this.numResolvedNamingConflicts.incrementAndGet();
                return true;
            }
            msg.setDn(currentDn.toString());
            this.numResolvedNamingConflicts.incrementAndGet();
            return false;
        }
        if (result == ResultCode.NOT_ALLOWED_ON_NONLEAF) {
            if (this.findAndRenameChild(entryUid, op.getEntryDN(), op)) {
                this.numUnresolvedNamingConflicts.incrementAndGet();
            }
            return false;
        }
        Message message = ReplicationMessages.ERR_ERROR_REPLAYING_OPERATION.get(op.toString(), ctx.getChangeNumber().toString(), result.toString(), op.getErrorMessage().toString());
        ErrorLogger.logError(message);
        return true;
    }

    private boolean solveNamingConflict(ModifyDNOperation op, UpdateMsg msg) throws Exception {
        ResultCode result = op.getResultCode();
        ModifyDnContext ctx = (ModifyDnContext)op.getAttachment("replicationContext");
        String entryUid = ctx.getEntryUid();
        String newSuperiorID = ctx.getNewParentId();
        DN currentDN = this.findEntryDN(entryUid);
        DN entryDN = op.getEntryDN();
        DN newSuperior = null;
        RDN newRDN = op.getNewRDN();
        newSuperior = newSuperiorID != null ? this.findEntryDN(newSuperiorID) : entryDN.getParent();
        if (newSuperior == null) {
            this.markConflictEntry(op, currentDN, currentDN.getParent().concat(newRDN));
            this.numUnresolvedNamingConflicts.incrementAndGet();
            return true;
        }
        DN newDN = newSuperior.concat(newRDN);
        if (currentDN == null) {
            this.numResolvedNamingConflicts.incrementAndGet();
            return true;
        }
        if (newDN.equals(currentDN)) {
            this.numResolvedNamingConflicts.incrementAndGet();
            return true;
        }
        if (result == ResultCode.NO_SUCH_OBJECT || result == ResultCode.UNWILLING_TO_PERFORM || result == ResultCode.OBJECTCLASS_VIOLATION) {
            ModifyDNMsg modifyDnMsg = (ModifyDNMsg)msg;
            msg.setDn(currentDN.toString());
            modifyDnMsg.setNewSuperior(newSuperior.toString());
            this.numResolvedNamingConflicts.incrementAndGet();
            return false;
        }
        if (result == ResultCode.ENTRY_ALREADY_EXISTS) {
            ModifyDNMsg modifyDnMsg = (ModifyDNMsg)msg;
            this.markConflictEntry(op, op.getEntryDN(), newDN);
            modifyDnMsg.setNewRDN(this.generateConflictRDN(entryUid, modifyDnMsg.getNewRDN()));
            modifyDnMsg.setNewSuperior(newSuperior.toString());
            this.numUnresolvedNamingConflicts.incrementAndGet();
            return false;
        }
        Message message = ReplicationMessages.ERR_ERROR_REPLAYING_OPERATION.get(op.toString(), ctx.getChangeNumber().toString(), result.toString(), op.getErrorMessage().toString());
        ErrorLogger.logError(message);
        return true;
    }

    private boolean solveNamingConflict(AddOperation op, AddMsg msg) throws Exception {
        ResultCode result = op.getResultCode();
        AddContext ctx = (AddContext)op.getAttachment("replicationContext");
        String entryUid = ctx.getEntryUid();
        String parentUniqueId = ctx.getParentUid();
        if (result == ResultCode.NO_SUCH_OBJECT) {
            if (parentUniqueId == null) {
                return true;
            }
            DN parentDn = this.findEntryDN(parentUniqueId);
            if (parentDn == null) {
                this.addConflict(msg);
                msg.setDn(this.generateConflictRDN(entryUid, op.getEntryDN().getRDN().toString()) + "," + this.baseDn);
                msg.setParentUid(null);
                this.numUnresolvedNamingConflicts.incrementAndGet();
                return false;
            }
            RDN entryRdn = DN.decode(msg.getDn()).getRDN();
            msg.setDn(entryRdn + "," + parentDn);
            this.numResolvedNamingConflicts.incrementAndGet();
            return false;
        }
        if (result == ResultCode.ENTRY_ALREADY_EXISTS) {
            if (this.findEntryDN(entryUid) != null) {
                return true;
            }
            this.addConflict(msg);
            msg.setDn(this.generateConflictRDN(entryUid, msg.getDn()));
            this.numUnresolvedNamingConflicts.incrementAndGet();
            return false;
        }
        Message message = ReplicationMessages.ERR_ERROR_REPLAYING_OPERATION.get(op.toString(), ctx.getChangeNumber().toString(), result.toString(), op.getErrorMessage().toString());
        ErrorLogger.logError(message);
        return true;
    }

    private boolean findAndRenameChild(String entryUid, DN entryDN, Operation conflictOp) {
        boolean conflict = false;
        InternalClientConnection conn = InternalClientConnection.getRootConnection();
        DeleteContext ctx = (DeleteContext)conflictOp.getAttachment("replicationContext");
        ChangeNumber cn = null;
        if (ctx != null) {
            cn = ctx.getChangeNumber();
        }
        try {
            LinkedHashSet<String> attrs = new LinkedHashSet<String>(1);
            attrs.add("entryuuid");
            attrs.add("ds-sync-hist");
            SearchFilter ALLMATCH = SearchFilter.createFilterFromString("(objectClass=*)");
            InternalSearchOperation op = conn.processSearch(entryDN, SearchScope.SINGLE_LEVEL, DereferencePolicy.NEVER_DEREF_ALIASES, 0, 0, false, ALLMATCH, attrs);
            if (op.getResultCode() == ResultCode.SUCCESS) {
                LinkedList<SearchResultEntry> entries = op.getSearchEntries();
                if (entries != null) {
                    for (SearchResultEntry entry : entries) {
                        Historical hist;
                        if (cn == null || !(hist = Historical.load(entry)).AddedOrRenamedAfter(cn)) continue;
                        conflict = true;
                        this.markConflictEntry(conflictOp, entry.getDN(), entryDN);
                        this.renameConflictEntry(conflictOp, entry.getDN(), Historical.getEntryUuid(entry));
                    }
                }
            } else {
                MessageBuilder mb = new MessageBuilder();
                mb.append(ReplicationMessages.ERR_CANNOT_RENAME_CONFLICT_ENTRY.get());
                mb.append(String.valueOf(entryDN));
                mb.append(" ");
                mb.append(String.valueOf(conflictOp));
                mb.append(" ");
                mb.append(String.valueOf((Object)op.getResultCode()));
                ErrorLogger.logError(mb.toMessage());
            }
        }
        catch (DirectoryException e) {
            MessageBuilder mb = new MessageBuilder();
            mb.append(ReplicationMessages.ERR_EXCEPTION_RENAME_CONFLICT_ENTRY.get());
            mb.append(String.valueOf(entryDN));
            mb.append(" ");
            mb.append(String.valueOf(conflictOp));
            mb.append(" ");
            mb.append(e.getLocalizedMessage());
            ErrorLogger.logError(mb.toMessage());
        }
        return conflict;
    }

    private void renameConflictEntry(Operation conflictOp, DN dn, String uid) {
        InternalClientConnection conn = InternalClientConnection.getRootConnection();
        ModifyDNOperation newOp = conn.processModifyDN(dn, this.generateDeleteConflictDn(uid, dn), false, this.baseDn);
        if (newOp.getResultCode() != ResultCode.SUCCESS) {
            MessageBuilder mb = new MessageBuilder();
            mb.append(ReplicationMessages.ERR_CANNOT_RENAME_CONFLICT_ENTRY.get());
            mb.append(String.valueOf(dn));
            mb.append(" ");
            mb.append(String.valueOf(conflictOp));
            mb.append(" ");
            mb.append(String.valueOf((Object)newOp.getResultCode()));
            ErrorLogger.logError(mb.toMessage());
        }
    }

    private void markConflictEntry(Operation op, DN currentDN, DN conflictDN) {
        InternalClientConnection conn = InternalClientConnection.getRootConnection();
        AttributeType attrType = DirectoryServer.getAttributeType(DS_SYNC_CONFLICT, true);
        Attribute attr = Attributes.create(attrType, new AttributeValue(attrType, conflictDN.toString()));
        ArrayList<Modification> mods = new ArrayList<Modification>();
        Modification mod = new Modification(ModificationType.REPLACE, attr);
        mods.add(mod);
        ModifyOperation newOp = conn.processModify(currentDN, mods);
        if (newOp.getResultCode() != ResultCode.SUCCESS) {
            MessageBuilder mb = new MessageBuilder();
            mb.append(ReplicationMessages.ERR_CANNOT_ADD_CONFLICT_ATTRIBUTE.get());
            mb.append(String.valueOf(op));
            mb.append(" ");
            mb.append(String.valueOf((Object)newOp.getResultCode()));
            ErrorLogger.logError(mb.toMessage());
        }
        Message alertMessage = ReplicationMessages.NOTE_UNRESOLVED_CONFLICT.get(conflictDN.toString());
        DirectoryServer.sendAlertNotification(this, "org.opends.server.replication.UnresolvedConflict", alertMessage);
    }

    private void addConflict(AddMsg msg) throws ASN1Exception {
        Message alertMessage = ReplicationMessages.NOTE_UNRESOLVED_CONFLICT.get(msg.getDn());
        DirectoryServer.sendAlertNotification(this, "org.opends.server.replication.UnresolvedConflict", alertMessage);
        msg.addAttribute(DS_SYNC_CONFLICT, msg.getDn());
    }

    private String generateConflictRDN(String entryUid, String rdn) {
        return "entryuuid=" + entryUid + "+" + rdn;
    }

    private RDN generateDeleteConflictDn(String entryUid, DN dn) {
        String newRDN = "entryuuid=" + entryUid + "+" + dn.getRDN();
        RDN rdn = null;
        try {
            rdn = RDN.decode(newRDN);
        }
        catch (DirectoryException e) {
            // empty catch block
        }
        return rdn;
    }

    private boolean isAssured(PostOperationOperation op) {
        return false;
    }

    public int getMaxRcvWindow() {
        if (this.broker != null) {
            return this.broker.getMaxRcvWindow();
        }
        return 0;
    }

    public int getCurrentRcvWindow() {
        if (this.broker != null) {
            return this.broker.getCurrentRcvWindow();
        }
        return 0;
    }

    public int getMaxSendWindow() {
        if (this.broker != null) {
            return this.broker.getMaxSendWindow();
        }
        return 0;
    }

    public int getCurrentSendWindow() {
        if (this.broker != null) {
            return this.broker.getCurrentSendWindow();
        }
        return 0;
    }

    public int getNumLostConnections() {
        if (this.broker != null) {
            return this.broker.getNumLostConnections();
        }
        return 0;
    }

    public int getNumResolvedModifyConflicts() {
        return this.numResolvedModifyConflicts.get();
    }

    public int getNumResolvedNamingConflicts() {
        return this.numResolvedNamingConflicts.get();
    }

    public int getNumUnresolvedNamingConflicts() {
        return this.numUnresolvedNamingConflicts.get();
    }

    public short getServerId() {
        return this.serverId;
    }

    public boolean solveConflict() {
        return this.solveConflictFlag;
    }

    public void disable() {
        this.state.save();
        this.state.clearInMemory();
        this.disabled = true;
        if (this.listenerThread != null) {
            this.listenerThread.shutdown();
        }
        this.broker.stop();
        if (this.listenerThread != null) {
            this.listenerThread.waitForShutdown();
        }
    }

    protected void loadDataState() throws DirectoryException {
        this.state.clearInMemory();
        this.state.loadState();
        this.generator.adjust(this.state.getMaxChangeNumber(this.serverId));
        this.generationId = this.loadGenerationId();
    }

    public void enable() {
        try {
            this.loadDataState();
        }
        catch (Exception e) {
            ErrorLogger.logError(ReplicationMessages.ERR_LOADING_GENERATION_ID.get(this.baseDn.toNormalizedString(), e.getLocalizedMessage()));
            return;
        }
        this.broker.setGenerationId(this.generationId);
        this.broker.start(this.replicationServers);
        this.listenerThread = new ListenerThread(this, this.updateToReplayQueue);
        this.listenerThread.start();
        this.disabled = false;
    }

    public long computeGenerationId() throws DirectoryException {
        long genId = this.exportBackend(true);
        if (DebugLogger.debugEnabled()) {
            TRACER.debugInfo("Computed generationId: generationId=" + genId);
        }
        return genId;
    }

    public long getGenerationId() {
        return this.generationId;
    }

    public ResultCode saveGenerationId(long generationId) {
        ASN1OctetString asn1BaseDn = new ASN1OctetString(this.baseDn.toString());
        ArrayList<ASN1OctetString> values = new ArrayList<ASN1OctetString>();
        ASN1OctetString value = new ASN1OctetString(Long.toString(generationId));
        values.add(value);
        LDAPAttribute attr = new LDAPAttribute(REPLICATION_GENERATION_ID, values);
        LDAPModification mod = new LDAPModification(ModificationType.REPLACE, attr);
        ArrayList<RawModification> mods = new ArrayList<RawModification>(1);
        mods.add(mod);
        ModifyOperationBasis op = new ModifyOperationBasis((ClientConnection)this.conn, InternalClientConnection.nextOperationID(), InternalClientConnection.nextMessageID(), new ArrayList<Control>(0), asn1BaseDn, mods);
        op.setInternalOperation(true);
        op.setSynchronizationOperation(true);
        op.setDontSynchronize(true);
        op.run();
        ResultCode result = op.getResultCode();
        if (result != ResultCode.SUCCESS) {
            this.generationIdSavedStatus = false;
            if (result != ResultCode.NO_SUCH_OBJECT) {
                Message message = ReplicationMessages.ERR_UPDATING_GENERATION_ID.get(op.getResultCode().getResultCodeName() + " " + op.getErrorMessage(), this.baseDn.toString());
                ErrorLogger.logError(message);
            }
        } else {
            this.generationIdSavedStatus = true;
        }
        return result;
    }

    public long loadGenerationId() throws DirectoryException {
        AttributeType synchronizationGenIDType;
        List<Attribute> attrs;
        LinkedList<SearchResultEntry> result;
        LDAPFilter filter;
        long generationId = -1L;
        if (DebugLogger.debugEnabled()) {
            TRACER.debugInfo("Attempt to read generation ID from DB " + this.baseDn.toString());
        }
        ASN1OctetString asn1BaseDn = new ASN1OctetString(this.baseDn.toString());
        boolean found = false;
        try {
            filter = LDAPFilter.decode("objectclass=*");
        }
        catch (LDAPException e) {
            return -1L;
        }
        InternalSearchOperation search = null;
        LinkedHashSet<String> attributes = new LinkedHashSet<String>(1);
        attributes.add(REPLICATION_GENERATION_ID);
        search = this.conn.processSearch(asn1BaseDn, SearchScope.BASE_OBJECT, DereferencePolicy.DEREF_ALWAYS, 0, 0, false, filter, attributes);
        if (search.getResultCode() != ResultCode.SUCCESS && search.getResultCode() != ResultCode.NO_SUCH_OBJECT) {
            Message message = ReplicationMessages.ERR_SEARCHING_GENERATION_ID.get(search.getResultCode().getResultCodeName() + " " + search.getErrorMessage(), this.baseDn.toString());
            ErrorLogger.logError(message);
        }
        SearchResultEntry resultEntry = null;
        if (search.getResultCode() == ResultCode.SUCCESS && (resultEntry = (result = search.getSearchEntries()).getFirst()) != null && (attrs = resultEntry.getAttribute(synchronizationGenIDType = DirectoryServer.getAttributeType(REPLICATION_GENERATION_ID))) != null) {
            Attribute attr = attrs.get(0);
            if (attr.size() > 1) {
                Message message = ReplicationMessages.ERR_LOADING_GENERATION_ID.get(this.baseDn.toString(), "#Values=" + attr.size() + " Must be exactly 1 in entry " + resultEntry.toLDIFString());
                ErrorLogger.logError(message);
            } else if (attr.size() == 1) {
                found = true;
                try {
                    generationId = Long.decode(attr.iterator().next().getStringValue());
                }
                catch (Exception e) {
                    Message message = ReplicationMessages.ERR_LOADING_GENERATION_ID.get(this.baseDn.toString(), e.getLocalizedMessage());
                    ErrorLogger.logError(message);
                }
            }
        }
        if (!found) {
            generationId = this.computeGenerationId();
            this.saveGenerationId(generationId);
            if (DebugLogger.debugEnabled()) {
                TRACER.debugInfo("Generation ID created for domain base DN=" + this.baseDn.toString() + " generationId=" + generationId);
            }
        } else {
            this.generationIdSavedStatus = true;
            if (DebugLogger.debugEnabled()) {
                TRACER.debugInfo("Generation ID successfully read from domain base DN=" + this.baseDn + " generationId=" + generationId);
            }
        }
        return generationId;
    }

    public void resetGenerationId(Long generationIdNewValue) throws DirectoryException {
        if (DebugLogger.debugEnabled()) {
            TRACER.debugInfo(this.getName() + "resetGenerationId" + generationIdNewValue);
        }
        if (!this.isConnected()) {
            ResultCode resultCode = ResultCode.OTHER;
            Message message = ReplicationMessages.ERR_RESET_GENERATION_CONN_ERR_ID.get(this.baseDn.toNormalizedString());
            throw new DirectoryException(resultCode, message);
        }
        ResetGenerationIdMsg genIdMessage = null;
        genIdMessage = generationIdNewValue == null ? new ResetGenerationIdMsg(this.generationId) : new ResetGenerationIdMsg(generationIdNewValue);
        this.broker.publish(genIdMessage);
    }

    public void backupStart() {
        this.state.save();
    }

    public void backupEnd() {
    }

    public byte[] receiveEntryBytes() {
        while (true) {
            try {
                ReplicationMsg msg;
                do {
                    msg = this.broker.receive();
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugVerbose(" sid:" + this.serverId + " base DN:" + this.baseDn + " Import EntryBytes received " + msg);
                    }
                    if (msg == null) {
                        return null;
                    }
                    if (msg instanceof EntryMsg) {
                        EntryMsg entryMsg = (EntryMsg)msg;
                        byte[] entryBytes = entryMsg.getEntryBytes();
                        this.ieContext.updateCounters();
                        return entryBytes;
                    }
                    if (!(msg instanceof DoneMsg)) continue;
                    return null;
                } while (!(msg instanceof ErrorMsg));
                ErrorMsg errorMsg = (ErrorMsg)msg;
                this.ieContext.exception = new DirectoryException(ResultCode.OTHER, errorMsg.getDetails());
                return null;
            }
            catch (Exception e) {
                this.ieContext.exception = new DirectoryException(ResultCode.OTHER, Message.raw("received an unexpected message type" + e.getLocalizedMessage(), new Object[0]));
                continue;
            }
            break;
        }
    }

    protected void abandonImportExport(ErrorMsg errorMsg) {
        if (DebugLogger.debugEnabled()) {
            TRACER.debugVerbose(" abandonImportExport:" + this.serverId + " base DN:" + this.baseDn + " Error Msg received " + errorMsg);
        }
        if (this.ieContext != null) {
            this.ieContext.exception = new DirectoryException(ResultCode.OTHER, errorMsg.getDetails());
            if (this.ieContext.initializeTask instanceof InitializeTask) {
                ((InitializeTask)this.ieContext.initializeTask).updateTaskCompletionState(this.ieContext.exception);
                this.releaseIEContext();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearJEBackend(boolean createBaseEntry, String beID, String dn) throws Exception {
        BackendImpl backend = (BackendImpl)DirectoryServer.getBackend(beID);
        TaskUtils.disableBackend(beID);
        try {
            String lockFile = LockFileManager.getBackendLockFileName(backend);
            StringBuilder failureReason = new StringBuilder();
            if (!LockFileManager.acquireExclusiveLock(lockFile, failureReason)) {
                throw new RuntimeException(failureReason.toString());
            }
            try {
                backend.clearBackend();
            }
            finally {
                LockFileManager.releaseLock(lockFile, failureReason);
            }
        }
        finally {
            TaskUtils.enableBackend(beID);
        }
        if (createBaseEntry) {
            DN baseDN = DN.decode(dn);
            Entry e = StaticUtils.createEntry(baseDN);
            backend = (BackendImpl)DirectoryServer.getBackend(beID);
            backend.addEntry(e, null);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected long exportBackend(boolean checksumOutput) throws DirectoryException {
        OutputStream os;
        ReplLDIFOutputStream ros;
        long genID = 0L;
        Backend backend = ReplicationDomain.retrievesBackend(this.baseDn);
        long bec = backend.numSubordinates(this.baseDn, true) + 1L;
        long entryCount = bec < 1000L ? bec : 1000L;
        try {
            String lockFile = LockFileManager.getBackendLockFileName(backend);
            StringBuilder failureReason = new StringBuilder();
            if (!LockFileManager.acquireSharedLock(lockFile, failureReason)) {
                Message message = ToolMessages.ERR_LDIFEXPORT_CANNOT_LOCK_BACKEND.get(backend.getBackendID(), String.valueOf(failureReason));
                ErrorLogger.logError(message);
                throw new DirectoryException(ResultCode.OTHER, message, null);
            }
        }
        catch (Exception e) {
            Message message = ToolMessages.ERR_LDIFEXPORT_CANNOT_LOCK_BACKEND.get(backend.getBackendID(), e.getLocalizedMessage());
            ErrorLogger.logError(message);
            throw new DirectoryException(ResultCode.OTHER, message, null);
        }
        if (checksumOutput) {
            ros = new ReplLDIFOutputStream(this, entryCount);
            os = new CheckedOutputStream(ros, new GenerationIdChecksum());
            try {
                os.write(Long.toString(backend.numSubordinates(this.baseDn, true) + 1L).getBytes());
            }
            catch (Exception e) {}
        } else {
            ros = new ReplLDIFOutputStream(this, -1L);
            os = ros;
        }
        LDIFExportConfig exportConfig = new LDIFExportConfig(os);
        ArrayList<DN> includeBranches = new ArrayList<DN>(1);
        includeBranches.add(this.baseDn);
        exportConfig.setIncludeBranches(includeBranches);
        if (checksumOutput) {
            String[] includeAttributeStrings = new String[]{"objectclass", "sn", "cn", "entryuuid"};
            HashSet<AttributeType> includeAttributes = new HashSet<AttributeType>();
            for (String attrName : includeAttributeStrings) {
                AttributeType attrType = DirectoryServer.getAttributeType(attrName);
                if (attrType == null) {
                    attrType = DirectoryServer.getDefaultAttributeType(attrName);
                }
                includeAttributes.add(attrType);
            }
            exportConfig.setIncludeAttributes(includeAttributes);
        }
        try {
            Message message;
            try {
                backend.exportLDIF(exportConfig);
            }
            catch (DirectoryException de) {
                block22: {
                    block23: {
                        block21: {
                            if (!checksumOutput || ros.getNumExportedEntries() < entryCount) break block21;
                            Object var21_24 = null;
                            exportConfig.close();
                            if (!checksumOutput) break block22;
                            break block23;
                        }
                        message = ToolMessages.ERR_LDIFEXPORT_ERROR_DURING_EXPORT.get(de.getMessageObject());
                        ErrorLogger.logError(message);
                        throw new DirectoryException(ResultCode.OTHER, message, null);
                    }
                    genID = ((CheckedOutputStream)os).getChecksum().getValue();
                }
                try {
                    String lockFile = LockFileManager.getBackendLockFileName(backend);
                    StringBuilder failureReason = new StringBuilder();
                    if (LockFileManager.releaseLock(lockFile, failureReason)) return genID;
                    Message message2 = ToolMessages.WARN_LDIFEXPORT_CANNOT_UNLOCK_BACKEND.get(backend.getBackendID(), String.valueOf(failureReason));
                    ErrorLogger.logError(message2);
                    throw new DirectoryException(ResultCode.OTHER, message2, null);
                }
                catch (Exception e) {
                    Message message3 = ToolMessages.WARN_LDIFEXPORT_CANNOT_UNLOCK_BACKEND.get(backend.getBackendID(), StaticUtils.stackTraceToSingleLineString(e));
                    ErrorLogger.logError(message3);
                    throw new DirectoryException(ResultCode.OTHER, message3, null);
                }
            }
            catch (Exception e) {
                message = ToolMessages.ERR_LDIFEXPORT_ERROR_DURING_EXPORT.get(StaticUtils.stackTraceToSingleLineString(e));
                ErrorLogger.logError(message);
                throw new DirectoryException(ResultCode.OTHER, message, null);
            }
            Object var21_23 = null;
            exportConfig.close();
            if (checksumOutput) {
                genID = ((CheckedOutputStream)os).getChecksum().getValue();
            }
        }
        catch (Throwable throwable) {
            Object var21_25 = null;
            exportConfig.close();
            if (checksumOutput) {
                genID = ((CheckedOutputStream)os).getChecksum().getValue();
            }
            try {}
            catch (Exception e) {
                Message message3 = ToolMessages.WARN_LDIFEXPORT_CANNOT_UNLOCK_BACKEND.get(backend.getBackendID(), StaticUtils.stackTraceToSingleLineString(e));
                ErrorLogger.logError(message3);
                throw new DirectoryException(ResultCode.OTHER, message3, null);
            }
            String lockFile = LockFileManager.getBackendLockFileName(backend);
            StringBuilder failureReason = new StringBuilder();
            if (LockFileManager.releaseLock(lockFile, failureReason)) throw throwable;
            Message message2 = ToolMessages.WARN_LDIFEXPORT_CANNOT_UNLOCK_BACKEND.get(backend.getBackendID(), String.valueOf(failureReason));
            ErrorLogger.logError(message2);
            throw new DirectoryException(ResultCode.OTHER, message2, null);
        }
        try {}
        catch (Exception e) {
            Message message3 = ToolMessages.WARN_LDIFEXPORT_CANNOT_UNLOCK_BACKEND.get(backend.getBackendID(), StaticUtils.stackTraceToSingleLineString(e));
            ErrorLogger.logError(message3);
            throw new DirectoryException(ResultCode.OTHER, message3, null);
        }
        String lockFile = LockFileManager.getBackendLockFileName(backend);
        StringBuilder failureReason = new StringBuilder();
        if (LockFileManager.releaseLock(lockFile, failureReason)) return genID;
        Message message2 = ToolMessages.WARN_LDIFEXPORT_CANNOT_UNLOCK_BACKEND.get(backend.getBackendID(), String.valueOf(failureReason));
        ErrorLogger.logError(message2);
        throw new DirectoryException(ResultCode.OTHER, message2, null);
    }

    protected static Backend retrievesBackend(DN baseDn) {
        return DirectoryServer.getBackend(baseDn);
    }

    ReplicationBroker getBroker() {
        return this.broker;
    }

    public void exportLDIFEntry(String lDIFEntry) throws IOException {
        if (this.ieContext.exception != null) {
            IOException ioe = new IOException(this.ieContext.exception.getMessage());
            this.ieContext = null;
            throw ioe;
        }
        EntryMsg entryMessage = new EntryMsg(this.serverId, this.ieContext.exportTarget, lDIFEntry.getBytes());
        this.broker.publish(entryMessage);
        try {
            this.ieContext.updateCounters();
        }
        catch (DirectoryException de) {
            throw new IOException(de.getMessage());
        }
    }

    public void initializeFromRemote(short source, Task initTask) throws DirectoryException {
        if (DebugLogger.debugEnabled()) {
            TRACER.debugInfo("Entering initializeFromRemote");
        }
        this.acquireIEContext();
        this.ieContext.initializeTask = initTask;
        InitializeRequestMsg initializeMsg = new InitializeRequestMsg(this.baseDn, this.serverId, source);
        this.broker.publish(initializeMsg);
    }

    public short decodeSource(String sourceString) throws DirectoryException {
        short source = 0;
        Exception cause = null;
        try {
            source = Integer.decode(sourceString).shortValue();
            if (source >= -1 && source != this.serverId) {
                return source;
            }
        }
        catch (Exception e) {
            cause = e;
        }
        ResultCode resultCode = ResultCode.OTHER;
        Message message = ReplicationMessages.ERR_INVALID_IMPORT_SOURCE.get();
        if (cause != null) {
            throw new DirectoryException(resultCode, message, cause);
        }
        throw new DirectoryException(resultCode, message);
    }

    public short decodeTarget(String targetString) throws DirectoryException {
        short target = 0;
        if (targetString.equalsIgnoreCase("all")) {
            return -2;
        }
        try {
            target = Integer.decode(targetString).shortValue();
            if (target >= 0) {
                // empty if block
            }
            return target;
        }
        catch (Exception e) {
            Exception cause = e;
            ResultCode resultCode = ResultCode.OTHER;
            Message message = ReplicationMessages.ERR_INVALID_EXPORT_TARGET.get();
            if (cause != null) {
                throw new DirectoryException(resultCode, message, cause);
            }
            throw new DirectoryException(resultCode, message);
        }
    }

    private synchronized void acquireIEContext() throws DirectoryException {
        if (this.ieContext != null) {
            Message message = ReplicationMessages.ERR_SIMULTANEOUS_IMPORT_EXPORT_REJECTED.get();
            throw new DirectoryException(ResultCode.OTHER, message);
        }
        this.ieContext = new IEContext();
    }

    private synchronized void releaseIEContext() {
        this.ieContext = null;
    }

    public void initializeRemote(short target, Task initTask) throws DirectoryException {
        this.initializeRemote(target, this.serverId, initTask);
    }

    public void initializeRemote(short target, short requestorID, Task initTask) throws DirectoryException {
        Message msg = ReplicationMessages.NOTE_FULL_UPDATE_ENGAGED_FOR_REMOTE_START.get(Short.toString(this.serverId), this.baseDn.toString(), Short.toString(requestorID));
        ErrorLogger.logError(msg);
        boolean contextAcquired = false;
        try {
            Backend backend = ReplicationDomain.retrievesBackend(this.baseDn);
            if (!backend.supportsLDIFExport()) {
                Message message = ReplicationMessages.ERR_INIT_EXPORT_NOT_SUPPORTED.get(backend.getBackendID().toString());
                ErrorLogger.logError(message);
                throw new DirectoryException(ResultCode.OTHER, message);
            }
            this.acquireIEContext();
            contextAcquired = true;
            long entryCount = backend.numSubordinates(this.baseDn, true) + 1L;
            this.ieContext.exportTarget = target;
            if (initTask != null) {
                this.ieContext.initializeTask = initTask;
            }
            this.ieContext.setCounters(entryCount, entryCount);
            InitializeTargetMsg initializeMessage = new InitializeTargetMsg(this.baseDn, this.serverId, this.ieContext.exportTarget, requestorID, entryCount);
            this.broker.publish(initializeMessage);
            this.exportBackend(false);
            DoneMsg doneMsg = new DoneMsg(this.serverId, initializeMessage.getDestination());
            this.broker.publish(doneMsg);
            this.releaseIEContext();
        }
        catch (DirectoryException de) {
            ErrorMsg errorMsg = new ErrorMsg(target, de.getMessageObject());
            this.broker.publish(errorMsg);
            if (contextAcquired) {
                this.releaseIEContext();
            }
            throw de;
        }
        msg = ReplicationMessages.NOTE_FULL_UPDATE_ENGAGED_FOR_REMOTE_END.get(Short.toString(this.serverId), this.baseDn.toString(), Short.toString(requestorID));
        ErrorLogger.logError(msg);
    }

    private void preBackendImport(Backend backend) throws Exception {
        this.stateSavingDisabled = true;
        TaskUtils.disableBackend(backend.getBackendID());
        String lockFile = LockFileManager.getBackendLockFileName(backend);
        StringBuilder failureReason = new StringBuilder();
        if (!LockFileManager.acquireExclusiveLock(lockFile, failureReason)) {
            Message message = ReplicationMessages.ERR_INIT_CANNOT_LOCK_BACKEND.get(backend.getBackendID(), String.valueOf(failureReason));
            ErrorLogger.logError(message);
            throw new DirectoryException(ResultCode.OTHER, message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected void initialize(InitializeTargetMsg initializeMessage) throws DirectoryException {
        Message msg;
        DirectoryException de;
        block30: {
            Backend backend;
            LDIFImportConfig importConfig;
            block29: {
                block28: {
                    block27: {
                        importConfig = null;
                        de = null;
                        msg = ReplicationMessages.NOTE_FULL_UPDATE_ENGAGED_FROM_REMOTE_START.get(Short.toString(this.serverId), this.baseDn.toString(), Long.toString(initializeMessage.getRequestorID()));
                        ErrorLogger.logError(msg);
                        ServerStatus serverStatus = this.status;
                        synchronized (serverStatus) {
                            StatusMachineEvent event = StatusMachineEvent.TO_FULL_UPDATE_STATUS_EVENT;
                            ServerStatus newStatus = StatusMachine.computeNewStatus(this.status, event);
                            if (newStatus == ServerStatus.INVALID_STATUS) {
                                msg = ReplicationMessages.ERR_DS_CANNOT_CHANGE_STATUS.get(this.baseDn.toString(), Short.toString(this.serverId), this.status.toString(), event.toString());
                                ErrorLogger.logError(msg);
                                return;
                            }
                            this.status = newStatus;
                            if (DebugLogger.debugEnabled()) {
                                TRACER.debugInfo("Replication domain " + this.baseDn + " new status is: " + (Object)((Object)this.status));
                            }
                            this.updateDomainForNewStatus();
                        }
                        backend = ReplicationDomain.retrievesBackend(this.baseDn);
                        if (!backend.supportsLDIFImport()) {
                            Message message = ReplicationMessages.ERR_INIT_IMPORT_NOT_SUPPORTED.get(backend.getBackendID().toString());
                            ErrorLogger.logError(message);
                            de = new DirectoryException(ResultCode.OTHER, message);
                            break block27;
                        }
                        if (initializeMessage.getRequestorID() != (long)this.serverId) {
                            this.acquireIEContext();
                        }
                        this.ieContext.importSource = initializeMessage.getsenderID();
                        this.ieContext.entryLeftCount = initializeMessage.getEntryCount();
                        this.ieContext.setCounters(initializeMessage.getEntryCount(), initializeMessage.getEntryCount());
                        this.preBackendImport(backend);
                        this.ieContext.ldifImportInputStream = new ReplLDIFInputStream(this);
                        importConfig = new LDIFImportConfig(this.ieContext.ldifImportInputStream);
                        ArrayList<DN> includeBranches = new ArrayList<DN>();
                        includeBranches.add(this.baseDn);
                        importConfig.setIncludeBranches(includeBranches);
                        importConfig.setAppendToExistingData(false);
                        importConfig.writeRejectedEntries(StaticUtils.getFileForPath("logs" + File.separator + "replInitRejectedEntries").getAbsolutePath(), ExistingFileBehavior.OVERWRITE);
                        backend.importLDIF(importConfig);
                        this.stateSavingDisabled = false;
                    }
                    Object var10_10 = null;
                    if (this.ieContext != null && this.ieContext.exception != null) {
                        de = this.ieContext.exception;
                    }
                    if (importConfig == null) break block28;
                    importConfig.close();
                    this.closeBackendImport(backend);
                    backend = ReplicationDomain.retrievesBackend(this.baseDn);
                }
                try {
                    this.loadDataState();
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugInfo("After import, the replication plugin restarts connections to all RSs to provide new generation ID=" + this.generationId);
                    }
                    this.broker.setGenerationId(this.generationId);
                }
                catch (DirectoryException fe) {
                    if (de != null) break block29;
                    de = fe;
                }
            }
            this.broker.reStart();
            if (this.ieContext != null && this.ieContext.initializeTask != null) {
                ((InitializeTask)this.ieContext.initializeTask).updateTaskCompletionState(de);
            }
            this.releaseIEContext();
            {
                break block30;
                catch (Exception e) {
                    block31: {
                        de = new DirectoryException(ResultCode.OTHER, Message.raw(e.getLocalizedMessage(), new Object[0]));
                        Object var10_11 = null;
                        if (this.ieContext != null && this.ieContext.exception != null) {
                            de = this.ieContext.exception;
                        }
                        if (importConfig != null) {
                            importConfig.close();
                            this.closeBackendImport(backend);
                            backend = ReplicationDomain.retrievesBackend(this.baseDn);
                        }
                        try {
                            this.loadDataState();
                            if (DebugLogger.debugEnabled()) {
                                TRACER.debugInfo("After import, the replication plugin restarts connections to all RSs to provide new generation ID=" + this.generationId);
                            }
                            this.broker.setGenerationId(this.generationId);
                        }
                        catch (DirectoryException fe) {
                            if (de != null) break block31;
                            de = fe;
                        }
                    }
                    this.broker.reStart();
                    if (this.ieContext != null && this.ieContext.initializeTask != null) {
                        ((InitializeTask)this.ieContext.initializeTask).updateTaskCompletionState(de);
                    }
                    this.releaseIEContext();
                }
            }
            catch (Throwable throwable) {
                block32: {
                    Object var10_12 = null;
                    if (this.ieContext != null && this.ieContext.exception != null) {
                        de = this.ieContext.exception;
                    }
                    if (importConfig != null) {
                        importConfig.close();
                        this.closeBackendImport(backend);
                        backend = ReplicationDomain.retrievesBackend(this.baseDn);
                    }
                    try {
                        this.loadDataState();
                        if (DebugLogger.debugEnabled()) {
                            TRACER.debugInfo("After import, the replication plugin restarts connections to all RSs to provide new generation ID=" + this.generationId);
                        }
                        this.broker.setGenerationId(this.generationId);
                    }
                    catch (DirectoryException fe) {
                        if (de != null) break block32;
                        de = fe;
                    }
                }
                this.broker.reStart();
                if (this.ieContext != null && this.ieContext.initializeTask != null) {
                    ((InitializeTask)this.ieContext.initializeTask).updateTaskCompletionState(de);
                }
                this.releaseIEContext();
                throw throwable;
            }
        }
        if (de != null) {
            throw de;
        }
        msg = ReplicationMessages.NOTE_FULL_UPDATE_ENGAGED_FROM_REMOTE_END.get(Short.toString(this.serverId), this.baseDn.toString(), Long.toString(initializeMessage.getRequestorID()));
        ErrorLogger.logError(msg);
    }

    protected void closeBackendImport(Backend backend) throws DirectoryException {
        StringBuilder failureReason;
        String lockFile = LockFileManager.getBackendLockFileName(backend);
        if (!LockFileManager.releaseLock(lockFile, failureReason = new StringBuilder())) {
            Message message = ToolMessages.WARN_LDIFIMPORT_CANNOT_UNLOCK_BACKEND.get(backend.getBackendID(), String.valueOf(failureReason));
            ErrorLogger.logError(message);
            throw new DirectoryException(ResultCode.OTHER, message);
        }
        TaskUtils.enableBackend(backend.getBackendID());
    }

    public static ReplicationDomain retrievesReplicationDomain(DN baseDn) throws DirectoryException {
        ReplicationDomain replicationDomain = null;
        DirectoryServer.getSynchronizationProviders();
        for (SynchronizationProvider<SynchronizationProviderCfg> provider : DirectoryServer.getSynchronizationProviders()) {
            if (!(provider instanceof MultimasterReplication)) {
                Message message = ReplicationMessages.ERR_INVALID_PROVIDER.get();
                throw new DirectoryException(ResultCode.OTHER, message);
            }
            ReplicationDomain sdomain = MultimasterReplication.findDomain(baseDn, null);
            if (sdomain == null) break;
            if (replicationDomain != null) {
                Message message = ReplicationMessages.ERR_MULTIPLE_MATCHING_DOMAIN.get();
                throw new DirectoryException(ResultCode.OTHER, message);
            }
            replicationDomain = sdomain;
        }
        if (replicationDomain == null) {
            MessageBuilder mb = new MessageBuilder(ReplicationMessages.ERR_NO_MATCHING_DOMAIN.get());
            mb.append(" ");
            mb.append(String.valueOf(baseDn));
            throw new DirectoryException(ResultCode.OTHER, mb.toMessage());
        }
        return replicationDomain;
    }

    public Backend getBackend() {
        return ReplicationDomain.retrievesBackend(this.baseDn);
    }

    public boolean ieRunning() {
        return this.ieContext != null;
    }

    public void synchronizeModifications(List<Modification> modifications) {
        ModifyOperationBasis opBasis = new ModifyOperationBasis((ClientConnection)InternalClientConnection.getRootConnection(), InternalClientConnection.nextOperationID(), InternalClientConnection.nextMessageID(), null, DirectoryServer.getSchemaDN(), modifications);
        LocalBackendModifyOperation op = new LocalBackendModifyOperation(opBasis);
        ChangeNumber cn = this.generateChangeNumber(op);
        ModifyContext ctx = new ModifyContext(cn, "schema");
        op.setAttachment("replicationContext", ctx);
        op.setResultCode(ResultCode.SUCCESS);
        this.synchronize(op);
    }

    public static boolean isConfigurationAcceptable(ReplicationDomainCfg configuration, List<Message> unacceptableReasons) {
        DN dn = configuration.getBaseDN();
        ReplicationDomain domain = MultimasterReplication.findDomain(dn, null);
        if (domain != null && domain.baseDn.equals(dn)) {
            Message message = ReplicationMessages.ERR_SYNC_INVALID_DN.get();
            unacceptableReasons.add(message);
            return false;
        }
        if (ReplicationDomain.retrievesBackend(dn) == null) {
            Message message = ReplicationMessages.ERR_UNKNOWN_DN.get(dn.toString());
            unacceptableReasons.add(message);
            return false;
        }
        return true;
    }

    @Override
    public ConfigChangeResult applyConfigurationChange(ReplicationDomainCfg configuration) {
        Boolean needToRestartSession = false;
        SortedSet<String> newReplServers = configuration.getReplicationServer();
        if (this.replicationServers.size() != newReplServers.size() || !this.replicationServers.containsAll(newReplServers) || this.window != configuration.getWindowSize() || this.heartbeatInterval != configuration.getHeartbeatInterval()) {
            needToRestartSession = true;
        }
        this.replicationServers = newReplServers;
        this.window = configuration.getWindowSize();
        this.heartbeatInterval = configuration.getHeartbeatInterval();
        this.broker.changeConfig(this.replicationServers, this.maxReceiveQueue, this.maxReceiveDelay, this.maxSendQueue, this.maxSendDelay, this.window, this.heartbeatInterval);
        this.isolationpolicy = configuration.getIsolationPolicy();
        if (needToRestartSession.booleanValue()) {
            this.disable();
            this.enable();
        }
        return new ConfigChangeResult(ResultCode.SUCCESS, false);
    }

    @Override
    public boolean isConfigurationChangeAcceptable(ReplicationDomainCfg configuration, List<Message> unacceptableReasons) {
        return true;
    }

    @Override
    public LinkedHashMap<String, String> getAlerts() {
        LinkedHashMap<String, String> alerts = new LinkedHashMap<String, String>();
        alerts.put("org.opends.server.replication.UnresolvedConflict", "This alert type will be used to notify administrators if the  multimaster replication cannot resolve automatically a conflict.");
        return alerts;
    }

    @Override
    public String getClassName() {
        return CLASS_NAME;
    }

    @Override
    public DN getComponentEntryDN() {
        return this.configDn;
    }

    public boolean isConnected() {
        if (this.broker != null) {
            return this.broker.isConnected();
        }
        return false;
    }

    public boolean isSessionEncrypted() {
        if (this.broker != null) {
            return this.broker.isSessionEncrypted();
        }
        return false;
    }

    public List<DSInfo> getDsList() {
        return this.dsList;
    }

    public List<RSInfo> getRsList() {
        return this.rsList;
    }

    public boolean isAssured() {
        return this.assured;
    }

    public AssuredMode getAssuredMode() {
        return this.assuredMode;
    }

    public byte getAssuredSdLevel() {
        return this.assuredSdLevel;
    }

    public byte getGroupId() {
        return this.groupId;
    }

    public List<String> getRefUrls() {
        return this.refUrls;
    }

    public ServerStatus getStatus() {
        return this.status;
    }

    private class ExportThread
    extends DirectoryThread {
        private short target;

        public ExportThread(short target) {
            super("Export thread " + ReplicationDomain.this.serverId);
            this.target = target;
        }

        public void run() {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugInfo("Export thread starting.");
            }
            try {
                ReplicationDomain.this.initializeRemote(this.target, this.target, null);
            }
            catch (DirectoryException directoryException) {
                // empty catch block
            }
            if (DebugLogger.debugEnabled()) {
                TRACER.debugInfo("Export thread stopping.");
            }
        }
    }

    private class IEContext {
        Task initializeTask;
        ReplLDIFInputStream ldifImportInputStream = null;
        short exportTarget = (short)-1;
        short importSource = (short)-1;
        long entryCount = 0L;
        long entryLeftCount = 0L;
        DirectoryException exception = null;

        private IEContext() {
        }

        public void setCounters(long total, long left) throws DirectoryException {
            this.entryCount = total;
            this.entryLeftCount = left;
            if (this.initializeTask != null) {
                if (this.initializeTask instanceof InitializeTask) {
                    ((InitializeTask)this.initializeTask).setTotal(this.entryCount);
                    ((InitializeTask)this.initializeTask).setLeft(this.entryCount);
                } else if (this.initializeTask instanceof InitializeTargetTask) {
                    ((InitializeTargetTask)this.initializeTask).setTotal(this.entryCount);
                    ((InitializeTargetTask)this.initializeTask).setLeft(this.entryCount);
                }
            }
        }

        public void updateCounters() throws DirectoryException {
            --this.entryLeftCount;
            if (this.initializeTask != null) {
                if (this.initializeTask instanceof InitializeTask) {
                    ((InitializeTask)this.initializeTask).setLeft(this.entryLeftCount);
                } else if (this.initializeTask instanceof InitializeTargetTask) {
                    ((InitializeTargetTask)this.initializeTask).setLeft(this.entryLeftCount);
                }
            }
        }

        public String toString() {
            return new String("[ Entry count=" + this.entryCount + ", Entry left count=" + this.entryLeftCount + "]");
        }
    }
}

